//
// $Id: StackTest.m,v 1.17 2007/03/28 03:16:53 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "StackTest.h"
#import "Random.h"
#import <ObjectiveLib/Stack.h>
#import <ObjectiveLib/Vector.h>
#import <ObjectiveLib/DataOutStream.h>
#import <ObjectiveLib/DataInStream.h>
#import <ObjectiveLib/ObjectOutStream.h>
#import <ObjectiveLib/ObjectInStream.h>
#import "Number.h"
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Text.h>
#import <ObjectiveLib/Reaper.h>
#else
#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>
#import <Foundation/NSData.h>
#import <Foundation/NSArchiver.h>
#if defined(HAVE_KEYED_ARCHIVES)
#import <Foundation/NSKeyedArchiver.h>
#endif
#endif
#include <stdlib.h>
#if defined(__NEXT_RUNTIME__)
#import <objc/objc-class.h>
#endif

@implementation StackTest

#if !defined(OL_NO_OPENSTEP)
- (void) testCoding
{
    NSMutableData* data;
    NSArchiver* archiver;
    NSData* archData;
    OLStack* s1;
    OLStack* s2;
    OLNumber* num;
    int i;


    s1 = [[OLStack alloc] init];
    for (i = 0; i< 5000; i++)
    {
        num = [[OLNumber alloc] initWithInt: OLRandom() % 10000];
        [s1 push: num];
        [num RELEASE];
    }
    data = [[NSMutableData alloc] initWithCapacity: 5000];
    archiver = [[NSArchiver alloc] initForWritingWithMutableData: data];
    [archiver encodeRootObject: s1];
    [archiver RELEASE];
    s2 = [NSUnarchiver unarchiveObjectWithData: data];
    [data RELEASE];
    if (![s1 isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The deques should be equal"];
    }
#if defined(HAVE_KEYED_ARCHIVES)
    archData = [NSKeyedArchiver archivedDataWithRootObject: s1];
    s2 = [NSKeyedUnarchiver unarchiveObjectWithData: archData];
    if (![s1 isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The deques should be equal"];
    }
#endif
    [s1 RELEASE];
}
#endif

- (void) testConvenienceAllocators
{
    OLStack* q;
    OLStack* q2;
    OLNumber* num;

    q = REAP([OLStack stack]);
    if (![q IS_MEMBER_OF: [OLStack class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLStack class])->name, ((Class)[q class])->name];
    }
    if (![q empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The stack should be empty"];
    }
    num = [[OLNumber alloc] initWithInt: 1];
    [q push: num];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 2];
    [q push: num];
    [num RELEASE];
    q2 = REAP([OLStack stackWithStack: q]);
    if (![q isEqual: q2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The stacks should be equal"];
    }
}

- (void) testInitializers
{
    OLStack* s;

    s = [[OLStack alloc] init];
    if ([s size] != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", [s size]];
    }
    [s RELEASE];
}

- (void) testPop
{
    OLStack* s;
    OLNumber* num;
    int i;

    s = [[OLStack alloc] init];
    for (i = 0; i < 5000; i++)
    {
        num = [[OLNumber alloc] initWithInt: i];
        [s push: num];
        [num RELEASE];
    }
    if ([s size] != 5000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5000, but got %i", [s size]];
    }
    for (i = 4999; i >= 0; i--)
    {
        [s pop];
        if ([s size] != i)
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i", i, [s size]];
        }
        if (i > 0 && [[s top] intValue] != i - 1)
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i", i - 1, [[s top] intValue]];
        }
    }
    [s RELEASE];
}

- (void) testProperties
{
    OLStack* s;
    OLStack* s2;

    s = [[OLStack alloc] init];
    if (![s empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The stack is empty"];
    }
    if ([s size] != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", [s size]];
    }
    [s push: @"one"];
    if ([s empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The stack is not empty"];
    }
    if ([s size] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", [s size]];
    }
    if (![[s top] isEqual: @"one"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"one\", but got \"%s\"", [[s top] cString]];
    }
    s2 = [[OLStack alloc] init];
    if ([s isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The stacks are not equal"];
    }
    [s2 push: @"one"];
    if (![s isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The stacks are equal"];
    }
    [s RELEASE];
    [s2 RELEASE];
}

- (void) testPush
{
    OLStack* s;

    s = [[OLStack alloc] init];
    [s push: @"one"];
    if ([s size] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", [s size]];
    }
    if (![[s top] isEqual: @"one"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"one\", but got \"%s\"", [[s top] cString]];
    }
    [s push: @"two"];
    if ([s size] != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %i", [s size]];
    }
    if (![[s top] isEqual: @"two"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"two\", but got \"%s\"", [[s top] cString]];
    }
    [s RELEASE];
}

- (void) testStreaming
{
    OLDataOutStream* dout;
    OLObjectOutStream* oout;
    OLObjectInStream* oin;
    OLStack* stack;
    OLStack* readStack;
    OLNumber* num;
    int i;

    dout = REAP([OLDataOutStream stream]);
    oout = REAP([OLObjectOutStream streamWithOutStream: dout]);
    stack = [[OLStack alloc] init];
    for (i = 0; i< 10000; i++)
    {
        num = [[OLNumber alloc] initWithInt: OLRandom() % 10000];
        [stack push: num];
        [num RELEASE];
    }
    [oout writeObject: stack];
    oin = REAP([OLObjectInStream streamWithInStream:
        REAP([OLDataInStream streamWithBytes: [dout bytes] count: [dout count]])]);
    readStack = REAP([oin readObject]);
    if (![readStack IS_MEMBER_OF: [OLStack class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected OLStack class, but got %s", ((Class)[readStack class])->name];
    }
    if (![readStack isEqual: stack])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The stacks should be equal"];
    }
    [stack RELEASE];
}

@end
