//
// $Id: ReaperTest.m,v 1.5 2007/03/28 03:16:53 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "ReaperTest.h"
#import "Random.h"
#import "Number.h"
#import "ThreadServices.h"
#include <stdlib.h>
#if defined(OL_HAVE_WIN32_SLEEP)
#include <windows.h>
#endif

static void* __threadMain(void* arg)
{
    ReaperTest* test = arg;
#if defined(OL_HAVE_NANOSLEEP)
    struct timespec speck;
#endif
    OLReaper* cur;
    int i;

    [test logMessage: "Thread %p: Starting", OLCurrentThread()];
    if ([OLReaper currentReaper] != nil)
    {
        [test errInFile: __FILE__ line: __LINE__
            format: "There should be no current reaper in thread %p",
            OLCurrentThread()];
    }
    for (i = 0; i < 10000; i++)
    {
#if defined(OL_HAVE_NANOSLEEP)
        speck.tv_sec = 0;
        speck.tv_nsec = OLRandom() % 5000000;
        nanosleep(&speck, NULL);
#elif defined(OL_HAVE_WIN32_SLEEP)
        Sleep(OLRandom() % 5);
#endif
        cur = [[OLReaper alloc] init];
        [cur reap: [[OLNumber alloc] initWithInt: i]];
        if ([cur size] != 1)
        {
            [test errInFile: __FILE__ line: __LINE__
                format: "Thread %p: Expected 1, but got %u",
                OLCurrentThread(), [cur size]];
        }
    }
    [test logMessage: "Thread %p: Done allocating", OLCurrentThread()];
    for (i = 9999; i >= 0; i--)
    {
#if defined(OL_HAVE_NANOSLEEP)
        speck.tv_sec = 0;
        speck.tv_nsec = OLRandom() % 5000000;
        nanosleep(&speck, NULL);
#elif defined(OL_HAVE_WIN32_SLEEP)
        Sleep(OLRandom() % 5);
#endif
        [[OLReaper currentReaper] RELEASE];
    }
    if ([OLReaper currentReaper] != nil)
    {
        [test errInFile: __FILE__ line: __LINE__
            format: "There should be no current reaper in thread %p",
            OLCurrentThread()];
    }
    [test logMessage: "Thread %p: Done", OLCurrentThread()];
    return NULL;
}

@implementation ReaperTest : UnitTest

- (BOOL) setUp
{
    topReaper = [[OLReaper alloc] init];
    return YES;
}

- (BOOL) tearDown
{
    [topReaper RELEASE];
    topReaper = nil;
    return YES;
}

- (void) testCurrentReaper
{
    OLReaper* reapers[5];
    int i;

    reapers[0] = [OLReaper currentReaper];
    if (reapers[0] != topReaper)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected %p, but got %p", topReaper, reapers[0]];
    }
    for (i = 1; i < 5; i++)
    {
        reapers[i] = [[OLReaper alloc] init];
        if ([OLReaper currentReaper] != reapers[i])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %p, but got %p", reapers[i], [OLReaper currentReaper]];
        }
    }
    for (i = 4; i > 0; i--)
    {
        [reapers[i] RELEASE];
        if ([OLReaper currentReaper] != reapers[i - 1])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %p, but got %p", reapers[i - 1], [OLReaper currentReaper]];
        }
    }
}

- (void) testReap
{
    OLNumber* num = [[OLNumber alloc] initWithInt: 0];
    id returned;

    returned = [topReaper reap: num];
    if (returned != num)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected %p, but got %p", num, returned];
    }
    if ([topReaper size] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", [topReaper size]];
    }
}

- (void) testThreadSafety
{
    OLThread threads[20];
    unsigned i;

    for (i = 0; i < 20; i++)
        OLCreateThread(&threads[i], __threadMain, self);
    for (i = 0; i < 20; i++)
        OLWaitForThread(threads[i]);
}

@end
