//
// $Id: PointerData.h,v 1.8 2007/03/08 19:59:21 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if !defined(POINTERDATA_OL_GUARD)
#define POINTERDATA_OL_GUARD

#include "ObjectBase.h"
#if defined(OL_HAVE_INTTYPES_H)
#include <inttypes.h>
#else
#include <stdint.h>
#endif

#if defined(GNUSTEP)
@class NSMutableData;
#endif
@class OLInStream;

@interface OLPointerData :
#if defined(OL_NO_OPENSTEP)
    Object
#else
    NSObject
#endif
{
@private
#if defined(GNUSTEP)
    NSMutableData*  data;
#else
    uint8_t*        bytes;
    unsigned        numberOfBytes;
    unsigned        capacity;
#endif
}

- (id) init;
- (id) initWithSize: (unsigned)sz;
#if defined(OL_NO_OPENSTEP)
- (id) free;
#else
- (void) dealloc;
#endif
- (uint8_t*) bytes;
- (void) grow: (unsigned)amount;
- (void) nullTerminate;
- (void) readFromStream: (OLInStream*)stream count: (unsigned)amount;

@end

#endif
