//
// $Id: Pair.m,v 1.14 2007/03/06 20:42:20 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "Pair.h"
#import "Macros.h"
#import "ObjectInStream.h"
#import "ObjectOutStream.h"
#if !defined(OL_NO_OPENSTEP)
#import <Foundation/NSCoder.h>
#import <Foundation/NSString.h>
#endif

#if !defined(OL_NO_OPENSTEP)
NSString* const FIRST_KEY = @"OL_FIRST_KEY";
NSString* const SECOND_KEY = @"OL_SECOND_KEY";
#endif

@implementation OLPair

#if !defined(OL_NO_OPENSTEP)
- (id) initWithCoder: (NSCoder*)decoder
{
    [super init];
    if ([decoder respondsToSelector: @selector(allowsKeyedCoding)] &&
        [decoder allowsKeyedCoding])
    {
        first = OBJ_RETAIN_AUTO([decoder decodeObjectForKey: FIRST_KEY]);
        second = OBJ_RETAIN_AUTO([decoder decodeObjectForKey: SECOND_KEY]);
    }
    else
    {
        first = OBJ_RETAIN_AUTO([decoder decodeObject]);
        second = OBJ_RETAIN_AUTO([decoder decodeObject]);
    }
    return self;
}
#endif

- (id) initWithFirst: (id)f second: (id)s
{
    [super init];
    first = OBJ_RETAIN(f);
    second = OBJ_RETAIN(s);
    return self;
}

- (id) initWithObjectInStream: (OLObjectInStream*)stream
{
    [super init];
    first = OBJ_RETAIN_AUTO([stream readObject]);
    second = OBJ_RETAIN_AUTO([stream readObject]);
    return self;
}

#if defined(OL_NO_OPENSTEP)
- (id) free
#else
- (void) dealloc
#endif
{
    OBJ_RELEASE(first);
    OBJ_RELEASE(second);
    SUPER_FREE;
}

- (int) compare: (id)other
{
    OLPair* pair;
    int result;

    if (IS_KIND_OF(other, OLPair))
    {
        pair = (OLPair*)other;
        result = [first compare: pair->first];
        if (result == 0)
            result = [second compare: pair->second];
    }
    else
    {
        result = -1;
    }
    return result;
}

#if defined(OL_NO_OPENSTEP)

- (id) copy
{
    return [[OLPair alloc] initWithFirst: first second: second];
}

#else

- (id) copyWithZone: (NSZone*)zone
{
    return [[OLPair allocWithZone: zone] initWithFirst: first second: second];
}

#endif

#if !defined(OL_NO_OPENSTEP)
- (void) encodeWithCoder: (NSCoder*)encoder
{
    if ([encoder respondsToSelector: @selector(allowsKeyedCoding)] &&
        [encoder allowsKeyedCoding])
    {
        [encoder encodeObject: first forKey: FIRST_KEY];
        [encoder encodeObject: second forKey: SECOND_KEY];
    }
    else
    {
        [encoder encodeObject: first];
        [encoder encodeObject: second];
    }
}
#endif

- (id) first
{
    return first;
}

- (BOOL) isEqual: (id)object
{
    return IS_KIND_OF(object, OLPair) &&
           [first isEqual: ((OLPair*)object)->first] &&
           [second isEqual: ((OLPair*)object)->second];
}

- (id) second
{
    return second;
}

- (void) setFirst: (id)f
{
    if (f != first)
    {
        OBJ_RELEASE(first);
        first = OBJ_RETAIN(f);
    }
}

- (void) setSecond: (id)s
{
    if (s != second)
    {
        OBJ_RELEASE(second);
        second = OBJ_RETAIN(s);
    }
}

- (void) writeSelfToStream: (OLObjectOutStream*)stream
{
    [stream writeObject: first];
    [stream writeObject: second];
}

@end
