//
// $Id: MainPageDoc.h,v 1.14 2007/03/08 19:59:21 will_mason Exp $
//

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#include "Algorithm.h"

/**
 * @mainpage
 *
 * @image html ObjectiveLibLogoLarge.gif ""
 *
 * @b ObjectiveLib provides three primary services: @ref Containers "containers",
 * @ref Algorithms "algorithms" and @ref Streams "streams". An important part of
 * the library that keeps everything
 * moving is @ref Iterators "iterators". Iterators perform two functions: they provide
 * access to elements stored in containers and they provide a way for generic algorithms
 * to operate on elements of almost any type of container. Algorithms take iterators
 * as arguments, and thus never have any knowledge of what type of container they
 * happen to be affecting.
 *
 * @b ObjectiveLib is designed to offer the same functionality to Objective-C
 * programmers that the Standard Template Library offers to C++ programmers. Therefore,
 * anyone familiar with the STL will have no trouble using and understanding
 * the machinery of @b ObjectiveLib.
 *
 * It is important to note that the @ref Streams "streams" of @b ObjectiveLib do not
 * function at all like the streams of C++ from the std namespace. @b ObjectiveLib
 * @ref Streams "streams" never perform any formatting on the data that is sent
 * to them or read into them. They are in effect binary streams only. Data written to
 * and read from @ObjectiveLib @ref Streams "streams" is always written or read
 * in network byte order, and therefore architecture-independent.
 *
 * <hr>
 * @section Navigation Navigating The Documentation
 * To view features of @b ObjectiveLib by category please visit the
 * <a href="modules.html">Modules</a> page. Otherwise, if you are looking for a specific
 * class, then you are most likely to find it quickly using the
 * <a href="classes.html">Classes</a> page. Links to each of these pages
 * are also found at the top of every page in the API documentation, including this one.
 *
 * <hr>
 * @section Contacts Contact The Project
 * All project contacts are handled through <a href="http://sourceforge.net">SourceForge</a>.
 * To ask for support or to submit bug reports and feature requests please visit
 * the <a href="http://sourceforge.net/projects/objectivelib/">ObjectiveLib project
 * site</a>. Additionally, you may view detailed information about getting support on
 * the <a href="http://sourceforge.net/support/getsupport.php?group_id=120814">Get Support</a>
 * page.
 *
 * You are encouraged to join discussion of @b ObjectiveLib on the mailing list. You may
 * <a href="http://lists.sourceforge.net/mailman/listinfo/objectivelib-discussion">
 * subscribe</a> to the mailing list to talk with the developers of @b ObjectiveLib
 * and to discuss possible bugs or new features.
 *
 * <hr>
 * @section Credits Credits
 * <p><b>Programming</b> Will Mason, Russell Johnston</p>
 * <p><b>Visual Effects</b> Tom Mason</p>
 * <p><b>Special Thanks</b> to everyone from <a href="http://www.stlport.org">STLport</a>,
 * especially Boris Fomitchev and to the makers of
 * <a href="http://www.stlport.org">Doxygen</a>, especially Dimitri van Heesch.</p>
 */

/**
 * @defgroup Containers
 *
 * A container is an object that contains other objects and provides ways of accessing
 * the stored objects. The way that objects are stored varies from container to
 * container, and the requirements for use should guide the user in choosing the type
 * of container. All containers provide @ref Iterators "iterators" for traversing the
 * container and accessing its elements. Additionally, all containers assume ownership of
 * the objects that they contain.
 */

/**
 * @defgroup Streams
 *
 * Streams provide a means of channeling information to or from an application. All stream
 * classes are derived either from OLInStream or OLOutStream. There are two branches of
 * inheritance from the base stream classes: connected streams and layered streams.
 * Connected streams (subclasses of OLConnectedOutStream and OLConnectedInStream)
 * communicate with entities outside of the @b ObjectiveLib streaming subsystem, like
 * files and sockets, while layered streams (subclasses of OLLayeredOutStream and
 * OLLayeredInStream) are only capable of communicating with other @b ObjectiveLib streams.
 *
 * <center>
 * @dotfile StreamLayers.dot "Stream Layering"
 * </center>
 *
 * Connected streams can be used without any layered streams, but generally the services
 * provided by layered streams will be advantageous. Layered streams act as filters for
 * the data and can include services such as buffering and compression. For example, to
 * write some data to a file that is compatible with the command-line tool gzip, one
 * constructs a set of streams as follows.
 * @code
 * OLGzipOutStream* gzstream = [OLGzipOutStream streamWithOutStream:
 *     [OLFileOutStream streamWithPath: "mydata.gz"]];
 * [gzstream writeInt: 6];
 * [gzstream close];
 * @endcode
 *
 * The layers in the previous sample are stacked as follows, where the OLFileOutStream is
 * the connected stream and the OLGzipOutStream is the layered stream.
 *
 * <center>
 * @dotfile FileGzipLayers.dot
 * </center>
 *
 * Of course, in the
 * real world you would probably put an OLBufferingOutStream in between the OLFileOutStream and
 * the OLGzipOutStream, since you'd probably be writing a lot of data. Additionally, if
 * you wanted to write objects to the file, you would have to put an OLObjectOutStream on
 * the top of the stream stack. Something like this.
 * @code
 * OLObjectOutStream* ostream = [OLObjectOutStream streamWithOutStream:
 *     [OLGzipOutStream streamWithOutStream:
 *         [OLBufferingOutStream streamWithOutStream:
 *             [OLFileOutStream streamWithPath: "mydata.gz"]]]];
 * [ostream writeObject: objectWithLotsOfDataToWrite];
 * [ostream close];
 * @endcode
 *
 * And the layers would map like this.
 *
 * <center>
 * @dotfile FileBufferingGzipObjectLayers.dot
 * </center>
 */
