//
// $Id: DataInStream.m,v 1.12 2007/03/06 20:42:19 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "DataInStream.h"
#import "Macros.h"
#import "RunTime.h"
#import "Exception.h"
#if defined(OL_NO_OPENSTEP)
#import "Text.h"
#else
#import <Foundation/NSData.h>
#import <Foundation/NSException.h>
#import <Foundation/NSString.h>
#endif
#import <string.h>
#import <limits.h>
#import <stdlib.h>

#define FREE_MY_RESOURCES \
    objc_free(bytes)

@implementation OLDataInStream

+ (id) streamWithBytes: (const uint8_t*)buffer count: (unsigned)length
{
    OL_BEGIN_AUTO_CTOR(OLDataInStream)
        initWithBytes: buffer count: length
    OL_END_AUTO_CTOR;
}

#if !defined(OL_NO_OPENSTEP)
+ (id) streamWithDataObject: (NSData*)data
{
    OL_BEGIN_AUTO_CTOR(OLDataInStream)
        initWithDataObject: data
    OL_END_AUTO_CTOR;
}

- (id) initWithDataObject: (NSData*)data
{
    return [self initWithBytes: [data bytes] count: [data length]];
}
#endif

- (id) initWithBytes: (const uint8_t*)buffer count: (unsigned)length
{
    [super init];
    byteCount = length;
    bytes = objc_malloc(length);
    position = 0;
    memcpy(bytes, buffer, length);
    return self;
}

#if !defined(OL_NO_OPENSTEP)
- (void) dealloc
{
	FREE_MY_RESOURCES;
	SUPER_FREE;
}
#endif

#if defined(OL_NO_OPENSTEP)
- (void) freeStreamResources
{
	FREE_MY_RESOURCES;
	[super freeStreamResources];
}
#endif

- (uint8_t) readByte
{
    if (position == byteCount)
        RAISE_EXCEPTION(OLEndOfStreamException, @"");
    return bytes[position++];
}

- (unsigned) readBytes: (uint8_t*)buffer count: (unsigned)max
{
    unsigned amountToRead;

    if (position == byteCount)
    {
        amountToRead = UINT_MAX;
    }
    else
    {
        amountToRead = MIN(max, byteCount - position);
        memcpy(buffer, bytes + position, amountToRead);
        position += amountToRead;
    }
    return amountToRead;
}

@end
