//
// $Id: Arithmetic.m,v 1.11 2007/03/06 20:42:19 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "Config.h"

#if !defined(OL_NO_OPENSTEP)

#import "Arithmetic.h"
#import "Macros.h"
#import <string.h>
#import <math.h>

#define DO_ARITHMETIC(op) \
    const char* myType; \
    const char* valType; \
    NSNumber* rc; \
    if (!IS_KIND_OF(value, NSNumber)) \
        return self; \
    myType = [self objCType]; \
    valType = [value objCType]; \
    rc = [NSNumber alloc]; \
    if (strcmp("d", myType) == 0 || strcmp("d", valType) == 0) \
    { \
        rc = [rc initWithDouble: [self doubleValue] op [value doubleValue]]; \
    } \
    else if (strcmp("f", myType) == 0 || strcmp("f", valType) == 0) \
    { \
        rc = [rc initWithFloat: [self floatValue] op [value floatValue]]; \
    } \
    else if (strcmp("Q", myType) == 0 || strcmp("Q", valType) == 0) \
    { \
        rc = [rc initWithUnsignedLongLong: \
            [self unsignedLongLongValue] op [value unsignedLongLongValue]]; \
    } \
    else if (strcmp("q", myType) == 0 || strcmp("q", valType) == 0) \
    { \
        rc = [rc initWithLongLong: \
            [self longLongValue] op [value longLongValue]]; \
    } \
    else if (strcmp("L", myType) == 0 || strcmp("L", valType) == 0) \
    { \
        rc = [rc initWithUnsignedLong: \
            [self unsignedLongValue] op [value unsignedLongValue]]; \
    } \
    else if (strcmp("l", myType) == 0 || strcmp("l", valType) == 0) \
    { \
        rc = [rc initWithLong: [self longValue] op [value longValue]]; \
    } \
    else if (strcmp("I", myType) == 0 || strcmp("I", valType) == 0) \
    { \
        rc = [rc initWithUnsignedInt: \
            [self unsignedIntValue] op [value unsignedIntValue]]; \
    } \
    else \
    { \
        rc = [rc initWithInt: [self intValue] op [value intValue]]; \
    } \
    return OBJ_AUTORELEASE(rc);

@implementation NSNumber (OLArithmetic)

- (id) arithmeticAdd: (id)value
{
    DO_ARITHMETIC(+);
}

- (id) arithmeticDivideBy: (id)value
{
    DO_ARITHMETIC(/);
}

- (id) arithmeticModulus: (id)value
{
    const char* myType;
    const char* valType;
    NSNumber* rc;

    if (!IS_KIND_OF(value, NSNumber))
        return self;
    myType = [self objCType];
    valType = [value objCType];
    rc = [NSNumber alloc];
    if (strcmp("d", myType) == 0 || strcmp("d", valType) == 0)
    {
        rc = [rc initWithDouble: remainder([self doubleValue], [value doubleValue])];
    }
    else if (strcmp("f", myType) == 0 || strcmp("f", valType) == 0)
    {
        rc = [rc initWithFloat: remainder([self floatValue], [value floatValue])];
    }
    else if (strcmp("Q", myType) == 0 || strcmp("Q", valType) == 0)
    {
        rc = [rc initWithUnsignedLongLong:
            [self unsignedLongLongValue] % [value unsignedLongLongValue]];
    }
    else if (strcmp("q", myType) == 0 || strcmp("q", valType) == 0)
    {
        rc = [rc initWithLongLong:
            [self longLongValue] % [value longLongValue]];
    }
    else if (strcmp("L", myType) == 0 || strcmp("L", valType) == 0)
    {
        rc = [rc initWithUnsignedLong:
            [self unsignedLongValue] % [value unsignedLongValue]];
    }
    else if (strcmp("l", myType) == 0 || strcmp("l", valType) == 0)
    {
        rc = [rc initWithLong: [self longValue] % [value longValue]];
    }
    else if (strcmp("I", myType) == 0 || strcmp("I", valType) == 0)
    {
        rc = [rc initWithUnsignedInt:
            [self unsignedIntValue] % [value unsignedIntValue]];
    }
    else
    {
        rc = [rc initWithInt: [self intValue] % [value intValue]];
    }
    return OBJ_AUTORELEASE(rc);
}

- (id) arithmeticMultiply: (id)value
{
    DO_ARITHMETIC(*);
}

- (id) arithmeticNegate
{
    const char* myType;
    NSNumber* rc;

    myType = [self objCType];
    rc = [NSNumber alloc];
    if (strcmp("d", myType) == 0)
    {
        rc = [rc initWithDouble: -[self doubleValue]];
    }
    else if (strcmp("f", myType) == 0)
    {
        rc = [rc initWithFloat: -[self floatValue]];
    }
    else if (strcmp("Q", myType) == 0)
    {
        rc = self;
    }
    else if (strcmp("q", myType) == 0)
    {
        rc = [rc initWithLongLong: -[self longLongValue]];
    }
    else if (strcmp("L", myType) == 0)
    {
        rc = self;
    }
    else if (strcmp("l", myType) == 0)
    {
        rc = [rc initWithLong: -[self longValue]];
    }
    else if (strcmp("I", myType) == 0)
    {
        rc = self;
    }
    else
    {
        rc = [rc initWithInt: -[self intValue]];
    }
    return OBJ_AUTORELEASE(rc);
}

- (id) arithmeticSubtract: (id)value
{
    DO_ARITHMETIC(-);
}

@end

#endif
