//
// $Id: SetTest.m,v 1.18 2007/03/28 03:16:53 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "SetTest.h"
#import "Random.h"
#import <ObjectiveLib/Set.h>
#import <ObjectiveLib/Vector.h>
#import <ObjectiveLib/DataOutStream.h>
#import <ObjectiveLib/DataInStream.h>
#import <ObjectiveLib/ObjectOutStream.h>
#import <ObjectiveLib/ObjectInStream.h>
#import "Number.h"
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Text.h>
#import <ObjectiveLib/Reaper.h>
#else
#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>
#import <Foundation/NSData.h>
#import <Foundation/NSArchiver.h>
#if defined(HAVE_KEYED_ARCHIVES)
#import <Foundation/NSKeyedArchiver.h>
#endif
#endif
#if defined(__NEXT_RUNTIME__)
#import <objc/objc-class.h>
#endif
#include <stdlib.h>

@implementation SetTest

#if !defined(OL_NO_OPENSTEP)
- (void) testCoding
{
    NSMutableData* data;
    NSArchiver* archiver;
    NSData* archData;
    OLSet* s1;
    OLSet* s2;
    OLNumber* v;
    int i;


    s1 = [[OLSet alloc] init];
    for (i = 0; i< 5000; i++)
    {
        v = [[OLNumber alloc] initWithInt: i];
        [s1 insert: v];
        [v RELEASE];
    }
    data = [[NSMutableData alloc] initWithCapacity: 5000];
    archiver = [[NSArchiver alloc] initForWritingWithMutableData: data];
    [archiver encodeRootObject: s1];
    [archiver RELEASE];
    s2 = [NSUnarchiver unarchiveObjectWithData: data];
    [data RELEASE];
    if (![s1 isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The hash sets should be equal"];
    }
#if defined(HAVE_KEYED_ARCHIVES)
    archData = [NSKeyedArchiver archivedDataWithRootObject: s1];
    s2 = [NSKeyedUnarchiver unarchiveObjectWithData: archData];
    if (![s1 isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The hash sets should be equal"];
    }
#endif
    [s1 RELEASE];
}
#endif

- (void) testConvenienceAllocators
{
    OLSet* s;
    OLSet* s2;
    OLNumber* num;

    s = REAP([OLSet set]);
    if (![s IS_MEMBER_OF: [OLSet class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLSet class])->name, ((Class)[s class])->name];
    }
    if (![s empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The set should be empty"];
    }
    num = [[OLNumber alloc] initWithInt: 1];
    REAP([s insert: num]);
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 2];
    REAP([s insert: num]);
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 3];
    REAP([s insert: num]);
    [num RELEASE];
    s2 = REAP([OLSet setFrom: REAP([s begin]) to: REAP([s end])]);
    if (![s isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The sets should be equal"];
    }
    num = [[OLNumber alloc] initWithInt: 4];
    REAP([s insert: num]);
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 5];
    REAP([s insert: num]);
    [num RELEASE];
    s2 = REAP([OLSet setWithOLSet: s]);
    if (![s isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The sets should be equal"];
    }
    s = REAP([OLSet setWithCompare:
        REAP([OLFunctor functorOfType: OLFunctorType_Greater])]);
    if (![s IS_MEMBER_OF: [OLSet class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLSet class])->name, ((Class)[s class])->name];
    }
    if (![s empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The set should be empty"];
    }
    if (![[s keyComp] IS_MEMBER_OF: [OLGreater class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLGreater class])->name, ((Class)[[s keyComp] class])->name];
    }
}

- (void) testErase
{
    CONSTSTR* strs[] = { @"five", @"four", @"three", @"two" };
    int i;
    OLSet* s;
    OLAssociativeIterator* itor;
    OLAssociativeIterator* end;
    unsigned count;

    s = [[OLSet alloc] init];
    for (i = 0; i < 4; i++)
        REAP([s insert: strs[i]]);
    REAP([s insert: @"one"]);
    itor = [[REAP([s begin]) advance] advance];
    [self logMessage: "Going to erase \"%s\"", [[itor dereference] cString]];
    [s erase: itor];
    if ([s size] != 4)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 4, but got %u", [s size]];
    }
    end = REAP([s end]);
    for (itor = REAP([s begin]), i = 0; ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[itor dereference] isEqual: strs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [strs[i] cString], [[itor dereference] cString]];
        }
    }
    [s erase: REAP([s begin])];
    if ([s size] != 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %u", [s size]];
    }
    end = REAP([s end]);
    for (itor = REAP([s begin]), i = 1; ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[itor dereference] isEqual: strs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [strs[i] cString], [[itor dereference] cString]];
        }
    }
    [s erase: [REAP([s end]) reverse]];
    if ([s size] != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %u", [s size]];
    }
    end = REAP([s end]);
    for (itor = REAP([s begin]), i = 1; ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[itor dereference] isEqual: strs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [strs[i] cString], [[itor dereference] cString]];
        }
    }
    count = [s eraseKey: @"three"];
    if (count != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", count];
    }
    if ([s size] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", [s size]];
    }
    if (![[REAP([s begin]) dereference] isEqual: @"four"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"four\", but got \"%s\"", [[s begin] dereference]];
    }
    [s eraseFrom: REAP([s begin]) to: REAP([s end])];
    if (![s empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The set should be empty"];
    }
    for (i = 0; i < 4; i++)
        REAP([s insert: strs[i]]);
    [s clear];
    if (![s empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The set should be empty"];
    }
    [s RELEASE];
}

- (void) testFind
{
    CONSTSTR* strs[] = { @"one", @"two", @"three", @"four", @"five" };
    int i;
    OLSet* s;
    OLAssociativeIterator* itor;
    OLArrayIterator* ab;
    OLArrayIterator* ae;
    OLPair* p;

    s = [[OLSet alloc] init];
    ab = [[OLArrayIterator alloc] initWithPointer: strs];
    ae = [[OLArrayIterator alloc] initWithPointer: strs + 5];
    [s insertFrom: ab to: ae];
    [ab RELEASE];
    [ae RELEASE];
    for (i = 0; i < 5; i++)
    {
        itor = REAP([s find: strs[i]]);
        if (![[itor dereference] isEqual: strs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [strs[i] cString], [[itor dereference] cString]];
        }
    }
    itor = REAP([s find: @"doggyboy"]);
    if (![itor isEqual: REAP([s end])])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The item should not have been found"];
    }
    itor = REAP([s lowerBound: strs[0]]);
    if (![[itor dereference] isEqual: strs[0]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[0] cString], [[itor dereference] cString]];
    }
    itor = [REAP([s upperBound: strs[4]]) reverse];
    if (![[itor dereference] isEqual: strs[4]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[4] cString], [[itor dereference] cString]];
    }
    p = REAP([s equalRange: strs[3]]);
    if (![[[p first] dereference] isEqual: strs[3]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[3] cString], [[itor dereference] cString]];
    }
    if (![[[[p second] reverse] dereference] isEqual: strs[3]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[3] cString], [[itor dereference] cString]];
    }
    [s RELEASE];
}

- (void) testInsert
{
    OLSet* s;
    CONSTSTR* strs[] = { @"one", @"two", @"three", @"four", @"five" };
    CONSTSTR* orderedStrs[] = { @"five", @"four", @"one", @"three", @"two" };
    int i;
    OLPair* p;
    OLVector* v;
    OLAssociativeIterator* itor;
    OLAssociativeIterator* end;

    s = [[OLSet alloc] init];
    p = REAP([s insert: strs[0]]);
    if ([s size] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", [s size]];
    }
    if (![[p second] boolValue])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected YES, but got NO"];
    }
    if (![[[p first] dereference] isEqual: strs[0]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[0] cString], [[[p first] dereference] cString]];
    }
    p = REAP([s insert: strs[0]]);
    if ([s size] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", [s size]];
    }
    if ([[p second] boolValue])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected YES, but got NO"];
    }
    if (![[[p first] dereference] isEqual: strs[0]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[0] cString], [[[p first] dereference] cString]];
    }
    v = [[OLVector alloc] init];
    for (i = 1; i < 4; i++)
        [v pushBack: strs[i]];
    [s insertFrom: REAP([v begin]) to: REAP([v end])];
    [v RELEASE];
    if ([s size] != 4)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 4, but got %u", [s size]];
    }
    end = REAP([s end]);
    for (itor = REAP([s begin]), i = 1; ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[itor dereference] isEqual: orderedStrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedStrs[i] cString], [[itor dereference] cString]];
        }
    }
    itor = REAP([s insertAt: [REAP([s begin]) advance] value: strs[4]]);
    if ([s size] != 5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5, but got %u", [s size]];
    }
    if (![[itor dereference] isEqual: strs[4]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[0] cString], [[itor dereference] cString]];
    }
    end = REAP([s end]);
    for (itor = REAP([s begin]), i = 0; ![itor isEqual: end]; [itor advance], i++)
    {
        [self logMessage: "[%i] %s", i, [[itor dereference] cString]];
        if (![[itor dereference] isEqual: orderedStrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedStrs[i] cString], [[itor dereference] cString]];
        }
    }
    [s RELEASE];
}

- (void) testInitializers
{
    OLSet* s;
    OLGreater* greater;
    OLVector* v;
    CONSTSTR* strs[] = { @"one", @"two", @"three", @"four", @"five" };
    CONSTSTR* orderedStrs[] = { @"five", @"four", @"one", @"three", @"two" };
    int i;
    OLAssociativeIterator* b;
    OLAssociativeIterator* e;
    OLSet* s2;

    s = [[OLSet alloc] init];
    if (![s empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The set should be empty"];
    }
    [s RELEASE];
    greater = [[OLGreater alloc] init];
    s = [[OLSet alloc] initWithCompare: greater];
    if (![s empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The set should be empty"];
    }
    if (![[s keyComp] IS_MEMBER_OF: [OLGreater class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The key comparison object is wrong"];
    }
    [s RELEASE];
    v = [[OLVector alloc] init];
    for (i = 0; i < 5; i++)
        [v pushBack: strs[i]];
    s = [[OLSet alloc] initFrom: REAP([v begin]) to: REAP([v end])];
    if ([s size] != 5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5, but got %u", [s size]];
    }
    for (b = REAP([s begin]), e = REAP([s end]), i = 0; ![b isEqual: e]; [b advance], i++)
    {
        if (![[b dereference] isEqual: orderedStrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedStrs[i] cString], [[b dereference] cString]];
        }
    }
    [s RELEASE];
    s = [[OLSet alloc] initFrom: REAP([v begin]) to: REAP([v end]) compare: greater];
    [v RELEASE];
    [greater RELEASE];
    if ([s size] != 5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5, but got %u", [s size]];
    }
    for (b = REAP([s begin]), e = REAP([s end]), i = 4; ![b isEqual: e]; [b advance], i--)
    {
        if (![[b dereference] isEqual: orderedStrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedStrs[i] cString], [[b dereference] cString]];
        }
    }
    s2 = [[OLSet alloc] initWithOLSet: s];
    if ([s2 size] != 5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5, but got %u", [s2 size]];
    }
    for (b = REAP([s2 begin]), e = REAP([s2 end]), i = 4; ![b isEqual: e]; [b advance], i--)
    {
        if (![[b dereference] isEqual: orderedStrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedStrs[i] cString], [[b dereference] cString]];
        }
    }
    if (![s isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The sets must be equal"];
    }
    [s RELEASE];
    [s2 RELEASE];
}

- (void) testIterators
{
    OLSet* s;
    int nums[] = { 4, 3, 5, 1, 2 };
    int orderedNums[] = { 1, 2, 3, 4, 5 };
    int i;
    OLAssociativeIterator* itor;
    OLAssociativeIterator* end;
    OLReverseBidiIterator* rtor;
    OLReverseBidiIterator* rend;

    s = [[OLSet alloc] init];
    for (i = 0; i < 5; i++)
        REAP([s insert: REAP([OLNumber numberWithInt: nums[i]])]);
    end = REAP([s end]);
    for (itor = REAP([s begin]), i = 0; ![itor isEqual: end]; [itor advance], i++)
    {
        if ([[itor dereference] intValue] != orderedNums[i])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                orderedNums[i], [[itor dereference] intValue]];
        }
    }
    [itor reverse];
    for (i = 4; i >= 0; i--, [itor reverse])
    {
        if ([[itor dereference] intValue] != orderedNums[i])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                orderedNums[i], [[itor dereference] intValue]];
        }
    }
    rend = REAP([s rend]);
    for (rtor = REAP([s rbegin]), i = 4; ![rtor isEqual: rend]; [rtor advance], i--)
    {
        if ([[rtor dereference] intValue] != orderedNums[i])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                orderedNums[i], [[rtor dereference] intValue]];
        }
    }
    [rtor reverse];
    for (i = 0; i < 5; i++, [rtor reverse])
    {
        if ([[rtor dereference] intValue] != orderedNums[i])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                orderedNums[i], [[rtor dereference] intValue]];
        }
    }
    [s RELEASE];
}

- (void) testProperties
{
    CONSTSTR* strs[] = { @"one", @"two", @"three" };
    OLSet* s;
    OLSet* s2;
    int i;

    s = [[OLSet alloc] init];
    if (![s empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The set is empty"];
    }
    for (i = 0; i < 3; i++)
        REAP([s insert: strs[i]]);
    if ([s count: strs[0]] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", [s count: strs[0]]];
    }
    if ([s count: @"doggyboy"] != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", [s count: @"doggyboy"]];
    }
    if ([s empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The set is not empty"];
    }
    s2 = [[OLSet alloc] init];
    if ([s isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The sets are not equal"];
    }
    if (![s2 size] == 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", [s size]];
    }
    [s2 insertFrom: REAP([s begin]) to: REAP([s end])];
    if (![s isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The sets are equal"];
    }
    if ([s maxSize] != [s2 maxSize])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "All sets must have the same max size"];
    }
    [self logMessage: "The max size of a set is %u", [s maxSize]];
    if (![s size] == 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %i", [s size]];
    }
    if ([s valueComp] != [s keyComp])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Value comp and key comp should point to the same object"];
    }
    [s RELEASE];
    [s2 RELEASE];
}

- (void) testStreaming
{
    OLDataOutStream* dout;
    OLObjectOutStream* oout;
    OLObjectInStream* oin;
    OLSet* set;
    OLSet* readSet;
    OLNumber* v;
    int i;

    dout = REAP([OLDataOutStream stream]);
    oout = REAP([OLObjectOutStream streamWithOutStream: dout]);
    set = [[OLSet alloc] init];
    for (i = 0; i< 10000; i++)
    {
        v = [[OLNumber alloc] initWithInt: OLRandom() % 10000];
        REAP([set insert: v]);
        [v RELEASE];
    }
    [oout writeObject: set];
    oin = REAP([OLObjectInStream streamWithInStream:
        REAP([OLDataInStream streamWithBytes: [dout bytes] count: [dout count]])]);
    readSet = REAP([oin readObject]);
    if (![readSet IS_MEMBER_OF: [OLSet class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected OLSet class, but got %s", ((Class)[readSet class])->name];
    }
    if (![readSet isEqual: set])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The sets should be equal"];
    }
    [set RELEASE];
}

- (void) testSwap
{
    OLSet* s;
    OLSet* s2;
    CONSTSTR* strs[] = { @"one", @"two", @"three" };
    CONSTSTR* ostrs[] = { @"one", @"three", @"two" };
    CONSTSTR* strs2[] = { @"four", @"five", @"six" };
    CONSTSTR* ostrs2[] = { @"five", @"four", @"six" };
    int i;
    OLArrayIterator* ab;
    OLArrayIterator* ae;
    OLAssociativeIterator* itor;
    OLAssociativeIterator* end;

    ab = [[OLArrayIterator alloc] initWithPointer: strs];
    ae = [[OLArrayIterator alloc] initWithPointer: strs + 3];
    s = [[OLSet alloc] initFrom: ab to: ae];
    [ab RELEASE];
    [ae RELEASE];
    ab = [[OLArrayIterator alloc] initWithPointer: strs2];
    ae = [[OLArrayIterator alloc] initWithPointer: strs2 + 3];
    s2 = [[OLSet alloc] initFrom: ab to: ae];
    [ab RELEASE];
    [ae RELEASE];
    [s swap: s2];
    if (![s size] == 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %i", [s size]];
    }
    if (![s2 size] == 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %i", [s2 size]];
    }
    end = REAP([s end]);
    for (itor = REAP([s begin]), i = 0; ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[itor dereference] isEqual: ostrs2[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [ostrs2[i] cString], [[itor dereference] cString]];
        }
    }
    end = REAP([s2 end]);
    for (itor = REAP([s2 begin]), i = 0; ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[itor dereference] isEqual: ostrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [ostrs[i] cString], [[itor dereference] cString]];
        }
    }
    [s RELEASE];
    [s2 RELEASE];
}

@end
