//
// $Id: MultiSetTest.m,v 1.14 2007/03/28 03:16:53 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "MultiSetTest.h"
#import <ObjectiveLib/Set.h>
#import "Number.h"
#import "Random.h"
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Text.h>
#import <ObjectiveLib/Reaper.h>
#else
#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>
#endif
#include <stdlib.h>
#if defined(__NEXT_RUNTIME__)
#import <objc/objc-class.h>
#endif

@implementation MultiSetTest

- (void) testBounds
{
    OLMultiSet* s;
    CONSTSTR* strs[] = { @"one", @"one", @"one", @"two", @"two",
                         @"three", @"four", @"four", @"five", @"five" };
    OLPair* p;
    OLAssociativeIterator* itor;

    p = REAP([OLArrayIterator pairWithPointer: strs andPointer: strs + 10]);
    s = [[OLMultiSet alloc] initFrom: [p first] to: [p second]];
    itor = REAP([s lowerBound: strs[0]]);
    if (![[itor dereference] isEqual: strs[0]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[0] cString], [[itor dereference] cString]];
    }
    itor = REAP([s lowerBound: @"six"]);
    if (![[itor dereference] isEqual: strs[5]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[5] cString], [[itor dereference] cString]];
    }
    itor = REAP([s upperBound: strs[0]]);
    if (![[itor dereference] isEqual: strs[5]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[5] cString], [[itor dereference] cString]];
    }
    p = REAP([s equalRange: strs[0]]);
    for ( ; ![[p first] isEqual: [p second]]; [[p first] advance])
    {
        if (![[[p first] dereference] isEqual: strs[0]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [strs[0] cString], [[[p first] dereference] cString]];
        }
    }
    [s RELEASE];
}

- (void) testConvenienceAllocators
{
    OLMultiSet* s;
    OLMultiSet* s2;
    OLNumber* num;

    s = REAP([OLMultiSet multiSet]);
    if (![s IS_MEMBER_OF: [OLMultiSet class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLMultiSet class])->name, ((Class)[s class])->name];
    }
    if (![s empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The set should be empty"];
    }
    num = [[OLNumber alloc] initWithInt: 1];
    REAP([s insert: num]);
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 2];
    REAP([s insert: num]);
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 3];
    REAP([s insert: num]);
    [num RELEASE];
    s2 = REAP([OLMultiSet multiSetFrom: REAP([s begin]) to: REAP([s end])]);
    if (![s isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The sets should be equal"];
    }
    num = [[OLNumber alloc] initWithInt: 4];
    REAP([s insert: num]);
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 5];
    REAP([s insert: num]);
    [num RELEASE];
    s2 = REAP([OLMultiSet multiSetWithOLSet: s]);
    if (![s isEqual: s2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The sets should be equal"];
    }
    s = REAP([OLMultiSet multiSetWithCompare:
        REAP([OLFunctor functorOfType: OLFunctorType_Greater])]);
    if (![s IS_MEMBER_OF: [OLMultiSet class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLMultiSet class])->name, ((Class)[s class])->name];
    }
    if (![s empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The set should be empty"];
    }
    if (![[s keyComp] IS_MEMBER_OF: [OLGreater class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLGreater class])->name, ((Class)[[s keyComp] class])->name];
    }
}

- (void) testCounting
{
    OLMultiSet* s;
    OLNumber* num;
    int i;
    int j;

    s = [[OLMultiSet alloc] init];
    for (i = 0; i < 100; i++)
    {
        num = [[OLNumber alloc] initWithInt: i];
        if (i == 20)
        {
            for (j = 0; j < 20; j++)
                REAP([s insert: num]);
        }
        else
        {
            REAP([s insert: num]);
        }
        [num RELEASE];
    }
    num = [[OLNumber alloc] initWithInt: 20];
    i = [s count: num];
    [num RELEASE];
    if (i != 20)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 20, but got %i", i];
    }
    num = [[OLNumber alloc] initWithInt: 1];
    i = [s count: num];
    [num RELEASE];
    if (i != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", i];
    }
    num = [[OLNumber alloc] initWithInt: 722];
    i = [s count: num];
    [num RELEASE];
    if (i != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", i];
    }
    [s RELEASE];
}

- (void) testInsert
{
    OLMultiSet* s;
    CONSTSTR* strs[] = { @"one", @"one", @"one", @"two", @"two",
                         @"three", @"four", @"four", @"five", @"five" };
    CONSTSTR* orderedStrs[] = { @"five", @"five", @"four", @"four", @"one",
                                @"one", @"one", @"three", @"two", @"two" };
    OLAssociativeIterator* itor;
    OLAssociativeIterator* end;
    OLNumber* num;
    OLNumber* nums[10000];
    OLPair* p;
    int counts[10];
    int i;
    int j;

    s = [[OLMultiSet alloc] init];
    for (i = 0; i < 10; i++)
    {
        itor = REAP([s insert: strs[i]]);
        if (![[itor dereference] isEqual: strs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [strs[i] cString], [[itor dereference] cString]];
        }
    }
    if ([s size] != 10)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 10, but got %u", [s size]];
    }
    for (itor = REAP([s begin]), end = REAP([s end]), i = 0;
         ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[itor dereference] isEqual: orderedStrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedStrs[i] cString], [[itor dereference] cString]];
        }
    }
    [s RELEASE];
    s = [[OLMultiSet alloc] init];
    for (i = 0; i < 10; i++)
        counts[i] = 0;
    for (i = 0; i < 10000; i++)
    {
        j = OLRandom() % 10;
        counts[j]++;
        nums[i] = [[OLNumber alloc] initWithInt: j];
    }
    p = REAP([OLArrayIterator pairWithPointer: nums andPointer: nums + 10000]);
    [s insertFrom: [p first] to: [p second]];
    for (i = 0; i < 10000; i++)
        [nums[i] RELEASE];
    if ([s size] != 10000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 10000, but got %u", [s size]];
    }
    end = REAP([s end]);
    itor = REAP([s begin]);
    for (i = 0; i < 10; i++)
    {
        for (j = 0; j < counts[i]; [itor advance], j++)
        {
            if ([itor isEqual: end])
            {
                [self errInFile: __FILE__ line: __LINE__
                    format: "The iterator should not be at the end"];
                break;
            }
            if ([[itor dereference] intValue] != i)
            {
                [self errInFile: __FILE__ line: __LINE__
                    format: "Expected %i, but got %i",
                    i, [[itor dereference] intValue]];
            }
        }
        if ([itor isEqual: end])
            break;
    }
    num = [[OLNumber alloc] initWithInt: 72];
    REAP([s insertAt: [[REAP([s begin]) advance] advance] value: num]);
    [num RELEASE];
    end = [REAP([s end]) reverse];
    if ([[end dereference] intValue] != 72)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected %i, but got %i",
            72, [[end dereference] intValue]];
    }
    [s RELEASE];
}

- (void) testInitializers
{
    OLMultiSet* s;
    CONSTSTR* strs[] = { @"one", @"one", @"one", @"two", @"two",
                         @"three", @"four", @"four", @"five", @"five" };
    CONSTSTR* orderedStrs[] = { @"five", @"five", @"four", @"four", @"one",
                                @"one", @"one", @"three", @"two", @"two" };
    OLPair* p;
    OLAssociativeIterator* b;
    OLAssociativeIterator* e;
    int i;

    p = REAP([OLArrayIterator pairWithPointer: strs andPointer: strs + 10]);
    s = [[OLMultiSet alloc] initFrom: [p first] to: [p second]];
    if ([s size] != 10)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 10, but got %u", [s size]];
    }
    for (b = REAP([s begin]), e = REAP([s end]), i = 0; ![b isEqual: e]; [b advance], i++)
    {
        if (![[b dereference] isEqual: orderedStrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedStrs[i] cString], [[b dereference] cString]];
        }
    }
    [s RELEASE];
}

@end
