//
// $Id: VectorJunior.m,v 1.6 2007/03/06 20:42:20 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "VectorJunior.h"
#import "Macros.h"
#import "RunTime.h"
#import <string.h>
#import <stdlib.h>

@implementation OLVectorJunior

- (id) init
{
    [super init];
    size = 0;
    capacity = 20;
    buffer = objc_malloc(capacity * sizeof(id));
    capacity = 20;
    return self;
}

#if defined(OL_NO_OPENSTEP)
- (id) free
#else
- (void) dealloc
#endif
{
    objc_free(buffer);
    SUPER_FREE;
}

- (id) at: (unsigned)index
{
    return buffer[index];
}

- (BOOL) checkAndClear: (id)object
{
    unsigned i;

    for (i = 0; i < size; i++)
    {
        if (buffer[i] != nil && [buffer[i] isEqual: object])
        {
            buffer[i] = nil;
            return YES;
        }
    }
    return NO;
}

- (void) clear
{
    size = 0;
}

- (void) pushBack: (id)object
{
    id* newBuf;

    if (size == capacity)
    {
        capacity *= 2;
        newBuf = objc_malloc(capacity * sizeof(id));
        memcpy(newBuf, buffer, size * sizeof(id));
        objc_free(buffer);
        buffer = newBuf;
    }
    buffer[size++] = object;
}

- (unsigned) size
{
    return size;
}

@end
