//
// $Id: RunTime.h,v 1.7 2007/03/06 20:42:20 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if !defined(RUNTIME_OL_GUARD)
#define RUNTIME_OL_GUARD

#include "Config.h"

#if defined(__NEXT_RUNTIME__)

#include <objc/objc-class.h>
#include <objc/objc-runtime.h>
#include <stddef.h>

#define objc_malloc(s) malloc(s)
#define objc_free(p) free(p)

struct objc_struct_layout
{
    const char*     original_type;
    const char*     type;
    const char*     prev_type;
    int             record_size;
    int             record_align;
};

int objc_aligned_size(const char* type);
int objc_alignof_type(const char* type);
void objc_layout_finish_structure(struct objc_struct_layout* layout,
                                  int* size,
                                  int* align);
void objc_layout_structure(const char* type, struct objc_struct_layout* layout);
void objc_layout_structure_get_info(struct objc_struct_layout* layout,
                                    int* offset,
                                    int* align,
                                    const char** type);
BOOL objc_layout_structure_next_member(struct objc_struct_layout* layout);
int objc_sizeof_type(const char* type);
const char* objc_skip_type_qualifiers(const char* type);
const char* objc_skip_typespec(const char* type);

static inline Class class_get_super_class(Class cls)
{
    return cls == NULL ? NULL : cls->super_class;
}

static inline int class_get_version(Class cls)
{
    return class_getVersion(cls);
}

static inline Class objc_get_class(const char* name)
{
    return objc_getClass(name);
}

static inline BOOL object_is_class(id obj)
{
    return ((struct objc_class*)obj)->info & CLS_CLASS ?
        YES : NO;
}

static inline SEL sel_get_any_typed_uid(const char* name)
{
    return sel_getUid(name);
}

static inline const char* sel_get_name(SEL selector)
{
    return sel_getName(selector);
}

static inline const char* sel_get_type(SEL selector)
{
    return NULL;
}

static inline SEL sel_get_typed_uid(const char* name, const char* types)
{
    return sel_getUid(name);
}

static inline SEL sel_get_uid(const char* name)
{
    return sel_getUid(name);
}

static inline SEL sel_register_name(const char* name)
{
    return sel_registerName(name);
}

static inline SEL sel_register_typed_name(const char* name, const char* types)
{
    return sel_registerName(name);
}

#else

#include <objc/objc-api.h>

#endif

#if !defined(_C_LNG_LNG)
#define _C_LNG_LNG 'q'
#endif
#if !defined(_C_ULNG_LNG)
#define _C_ULNG_LNG 'Q'
#endif
#if !defined(_C_CONST)
#define _C_CONST 'r'
#endif
#if !defined(_C_IN)
#define _C_IN 'n'
#endif
#if !defined(_C_INOUT)
#define _C_INOUT 'N'
#endif
#if !defined(_C_OUT)
#define _C_OUT 'o'
#endif
#if !defined(_C_BYCOPY)
#define _C_BYCOPY 'O'
#endif
#if !defined(_C_BYREF)
#define _C_BYREF 'R'
#endif
#if !defined(_C_ONEWAY)
#define _C_ONEWAY 'V'
#endif

#endif
