<?php
//
// BDF ファイルから必要な範囲だけ抜き出す
// Copyright (C) 2012 Tetsuya Isaki
//

// 書式
//	bdfcut.php [command] < in.bdf > out.bdf
//
// 解説
//	BDF ファイルから必要な範囲だけを抜き出します。
//	標準入力から読み込み、標準出力に書き出します。
//
//	範囲は command で指定します。今のところ以下が使用できます。
//
//	  h : Unicode の BDF からひらがなのみを抜き出します。
//	  r : Unicode の BDF からひらがな、カタカナのみを抜き出します。
//	  k : JISX0208 の BDF から非漢字のみを抜き出します。

	$opt = $argv[1];

	$range = array();

	// オプションによって出力範囲を指定
	if ($opt == "h") {
		// Unicode のひらがなのみ取り出す
		$range[] = array(0x3041, 0x309f);
	} else if ($opt == "r") {
		// Unicode のひらがな、カタカナを取り出す
		$range[] = array(0x3041, 0x30fc);
		// 、。
		$range[] = array(0x3001, 0x3002);
		// 「」
		$range[] = array(0x300c, 0x300d);
	} else if ($opt == "k") {
		// JIS X 0208 の非漢字のみ取り出す
		$range[] = array(0x2120, 0x287f);
	}

	// どのオプションもなければ終了
	if (count($range) < 1) {
		fprintf(STDERR, "usage: {$argv[0]} [command] < in.bdf > out.bdf\n");
		fprintf(STDERR, "   h: hiragana only in unicode\n");
		fprintf(STDERR, "   r: hira and katakana in unicode\n");
		fprintf(STDERR, "   k: non-kanji only in JIS X 0208\n");
		exit(1);
	}

	// プロパティ部分。
	// o TTF から縦横比を変えて変換した BDF には QUAD_WIDTH が含まれてない
	//   ので、ついでにここで追加してやる。
	$pixel_size = -1;
	$quad_width = -1;
	$res_x = -1;
	$res_y = -1;
	while (($buf = fgets(STDIN))) {
		if (preg_match("/^PIXEL_SIZE (\d+)/", $buf, $m)) {
			$pixel_size = $m[1] + 0;

		} else if (preg_match("/^QUAD_WIDTH (\d+)/", $buf, $m)) {
			$quad_width = $m[1] + 0;

		} else if (preg_match("/^RESOLUTION_X (\d+)/", $buf, $m)) {
			$res_x = $m[1] + 0;

		} else if (preg_match("/^RESOLUTION_Y (\d+)/", $buf, $m)) {
			$res_y = $m[1] + 0;

		} else if (preg_match("/^ENDPROPERTIES/", $buf)) {
			// h モードで QUAD_WIDTH がなければ作成
			if ($opt == "h" && $quad_width == -1) {
				if ($pixel_size > 0 && $res_x > 0 && $res_y > 0) {
					$quad_width = intval($pixel_size * $res_x / $res_y);
					print "QUAD_WIDTH {$quad_width}\n";
				} else {
					fprintf(STDERR, "Warning: cannot generate QUAD_WIDTH\n");
				}
			}

			// ここで自身も出力して終了
			print $buf;
			break;
		}
		print $buf;
	}

	// 本体ループ
	$body = "";
	$ischar = false;
	$num = 0;
	while (($buf = fgets(STDIN))) {
		if ($ischar) {
			$body .= $buf;

			// ENDCHAR を書き出したら一旦終わり
			if (preg_match("/^ENDCHAR/", $buf)) {
				$ischar = false;
			}

		} else if (preg_match("/^STARTCHAR ([\d\w]+)/", $buf, $m)) {
			list($code) = sscanf($m[1], "%x");
			if (inrange($code)) {
				$body .= $buf;
				$ischar = true;
				$num++;
			}
		}
	}

	// 文字数とともに残りを出力
	print "CHARS {$num}\n";
	print "{$body}";
?>
<?php
function inrange($code)
{
	global $range;

	foreach ($range as $r) {
		if ($r[0] <= $code && $code <= $r[1]) {
			return true;
		}
	}
	return false;
}
?>
