//
// XM6i
// Copyright (C) 2013 Tetsuya Isaki
//
// 簡易アセンブラ
//

#ifndef iasm_h
#define iasm_h

#include <string>

#define countof(x)	(sizeof(x) / sizeof(x[0]))

typedef std::string String;

enum token_type_t {
	T_END,
	T_SPACE,		/* 空白 */
	T_CHAR,			/* 文字 */
	T_STRING,		/* 文字列 */
	T_NUMBER,		/* 数字(16進、10進) */
	T_LITERAL,		/* リテラル(ラベル) */
	T_SIZE,			/* サイズサフィックス */
	T_SHARP,		/* '#' */
	T_COLON,		/* ':' */
	T_COMMA,
	T_LPAREN,
	T_RPAREN,
	T_PLUS,
	T_MINUS,
	T_MULTI,
	T_DIVIDE,
	T_LT,
	T_GT,

	T_MAX,
};

class Token
{
 public:
	token_type_t type;	/* 種別 */
	String word;		/* 語 */
	int number;			/* (必要なら) 数値 */
 public:
	Token();

	void clear();

	const char *type_name() const;

	static const char *type_name(token_type_t t);

	static const char *type_str[];

};

class Scanner
{
	/* 1文字の記号テーブル */
	struct mark_t {
		int chr;			/* 文字 */
		token_type_t type;	/* トークン種別 */
	};

 public:
	Scanner(String& src);

	virtual ~Scanner();

	bool get_token(Token& t);

	String errmsg;

	int isSize(int c) const;

	static bool isLabel1(int c);

	static bool isLabel2(int c);

 private:
	int getch(int offset = 0) const;

	String buf;

	int ptr;

	static mark_t mark[];

};

#endif /* !iasm_h */
