//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// バックバッファが BitmapRGBX なパネル
//

#include "wxbitmappanel.h"

// イベントテーブル
wxBEGIN_EVENT_TABLE(WXBitmapPanel, inherited)
	EVT_SIZE(WXBitmapPanel::OnSize)
	EVT_PAINT(WXBitmapPanel::OnPaint)
wxEND_EVENT_TABLE()

// コンストラクタ (ID なし)
WXBitmapPanel::WXBitmapPanel(wxWindow *parent,
	const wxPoint& position, const wxSize& size, long style)
	: WXBitmapPanel(parent, wxID_ANY, position, size, style)	// 移譲
{
}

// コンストラクタ (ID あり)
WXBitmapPanel::WXBitmapPanel(wxWindow *parent, wxWindowID id,
	const wxPoint& position, const wxSize& size, long style)
	: inherited(parent, id, position, size, style)
{
	SetName("WXBitmapPanel");

	bitmap_bgcolor = BGPANEL;
}

// デストラクタ
WXBitmapPanel::~WXBitmapPanel()
{
}

// 背景色を設定する
void
WXBitmapPanel::SetBitmapBGColor(Color c)
{
	bitmap_bgcolor = c;
}

// 背景色で塗りつぶす
void
WXBitmapPanel::Fill()
{
	if (bitmap.GetBuf()) {
		bitmap.Fill(bitmap_bgcolor);
	}
}

// 最小サイズ指定
void
WXBitmapPanel::SetMinBitmapSize(const wxSize& size_)
{
	fixedsize = size_;
}

// サイズ変更イベント
void
WXBitmapPanel::OnSize(wxSizeEvent& event)
{
	wxSize size = event.GetSize();
	if (size.x < 1 || size.y < 1) {
		return;
	}

	// 最小サイズ指定がある場合。
	if (fixedsize.x != 0 && size.x < fixedsize.x) {
		size.x = fixedsize.x;
	}
	if (fixedsize.y != 0 && size.y < fixedsize.y) {
		size.y = fixedsize.y;
	}

	// バックバッファの大きさが変われば変更。
	wxSize oldsize(bitmap.GetWidth(), bitmap.GetHeight());
	if (size != oldsize) {
		bitmap.Create(size.x, size.y);
		bitmap.Fill(bitmap_bgcolor);

		bitmap24.Create(size.x, size.y);
	}

	Refresh();
	event.Skip();
}

// 描画イベント (UI スレッドから呼ばれる)
void
WXBitmapPanel::OnPaint(wxPaintEvent& event)
{
	if (__predict_false(bitmap.GetBuf() == NULL)) {
		return;
	}

	// 継承クラスによる描画
	Draw();

	bitmap.ConvertToRGB(bitmap24);

	wxImage image(bitmap24.GetWidth(), bitmap24.GetHeight(),
		bitmap24.GetBuf(), true);
	wxBitmap bmp(image);

	// 実画面 DC にコピー。
	// バックバッファのほうが大きくても気にしない。
	wxPaintDC dstDC(this);
	dstDC.DrawBitmap(bmp, 0, 0);
}

// 描画処理
void
WXBitmapPanel::Draw()
{
	// 通常は継承クラスが記述する。
	// ここで用意している Draw() は何もしないことで、全域を背景色で
	// 塗りつぶしただけの状態が表示できる。空き地や下地表示用。
}
