//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// TAS ポート
//

#pragma once

#include "device.h"
#include <atomic>

class TASDevice : public IODevice
{
	using inherited = IODevice;
 public:
	TASDevice();
	~TASDevice() override;

	void ResetHard(bool poweron) override;

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = 1;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);
	bool PokePort(uint32 offset, uint32 data);

 private:
	std::atomic<uint8> tas {};	// bit 7 のみ有効。
};
