//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// LUNA-88K の ROM エミュレーション
//

#pragma once

#include "romemu_luna.h"

class MPU88xx0Device;

class Luna88kPROMEmuDevice : public LunaPROMEmuDevice
{
	using inherited = LunaPROMEmuDevice;

	// プロンプト種別
	enum {
		PROMPT_DEFAULT = 0,
		PROMPT_NVRAM_UPDATE,
		PROMPT_NVRAM_NEW,
		PROMPT_NVRAM_INIT,
	};

 public:
	Luna88kPROMEmuDevice();
	~Luna88kPROMEmuDevice() override;

	bool Init() override;

	// DOS call エミュレーション
	bool FLineCallback(MPU88xx0Device *cpu);

 private:
	void ROM_InitMD() override;
	void ROM_Close() override;
	void ProcessChar(char asciicode) override;
	uint32 LoadFile(const std::string& fname) override;
	void Command() override;

	void CommandH(const std::vector<std::string>& arg);
	void CommandB(const std::vector<std::string>& arg);
	void CommandNvram(const std::vector<std::string>& arg);
	void CommandNvramShowAll();
	void CommandNvramShow(const std::vector<std::string>& arg);
	void CommandNvramUpdate(const std::vector<std::string>& arg);
	void CommandNvramUpdate2(char);
	void CommandNvramNew2(char);
	void CommandNvramDelete(const std::vector<std::string>& arg);
	void CommandNvramInit();
	void CommandNvramInit2(char);

	// NVRAM
	uint32 FindNVRAM(const std::string& key) const;
	bool InitNVRAM() override;
	void GetNVRAM(bootinfo_t&) override;

	// nvram コマンドの遷移で覚えておくもの
	int nvram_offset {};
	std::string nvram_key {};
	std::string nvram_val {};

	// プロンプトの状態。
	// 0 (PROMPT_DEFAULT) が通常の行入力プロンプト。
	// PROMPT_NVRAM_* は nvram コマンドでの確認プロンプト。
	int prompt_idx {};
};
