//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// DIPSW
//

#pragma once

#include "device.h"

// DIPSW 共通クラス
class DipswDevice : public Device
{
	using inherited = Device;
 public:
	explicit DipswDevice(int sz_);
	~DipswDevice() override;

	// 総数を返す。
	int GetSize() const { return dipsw.size(); }

	// DIPSW n 番の値を取得/設定する。
	// true/false の割り当て方は機種依存。
	bool Get(uint n) const;
	void Set(uint n, bool val);

	// DIPSW n 番の物理位置を取得/設定する。0 が上、1が下。
	// これは GUI 用なので、値の向きはスクロールバーの position に由来。
	int GetPosition(uint n) const;
	void SetPosition(uint n, uint val);

 protected:
	std::vector<bool> dipsw {};

	// 論理値と物理位置の対応。
	// upside が true なら、上が true
	// upside が false なら、上が false。
	bool upside {};
};

// LUNA の DIPSW
class LunaDipswDevice : public DipswDevice
{
	using inherited = DipswDevice;
 public:
	LunaDipswDevice();
	~LunaDipswDevice() override;

	bool Init() override;
};

// NEWS の DIPSW
class NewsDipswDevice : public DipswDevice
{
	using inherited = DipswDevice;
 public:
	NewsDipswDevice();
	~NewsDipswDevice() override;

	bool Init() override;
};

inline DipswDevice *GetDipswDevice() {
	return Object::GetObject<DipswDevice>(OBJ_DIPSW);
}
