//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

// 実行系とデバッガで演算器を共有したい

#pragma once

// 命令フィールドの取り出し
#define m88100opf_D(x)		(((x) >> 21) & 0x1f)
#define m88100opf_S1(x)		(((x) >> 16) & 0x1f)
#define m88100opf_S2(x)		( (x)        & 0x1f)
#define m88100opf_CR(x)		(((x) >>  5) & 0x3f)
#define m88100opf_B5(x)		m88100opf_D(x)
#define m88100opf_M5(x)		m88100opf_D(x)
#define m88100opf_W5(x)		m88100opf_CR(x)
#define m88100opf_O5(x)		m88100opf_S2(x)
#define m88100opf_IMM16(x)	((x) & 0x0000ffffU)
#define m88100opf_VEC9(x)	((x) & 0x000001ffU)
// FP フィールド
#define m88100opf_FP_T1(x)	(((x) >> 9) & 3)
#define m88100opf_FP_T2(x)	(((x) >> 7) & 3)
#define m88100opf_FP_TD(x)	(((x) >> 5) & 3)

// cmp のやつ
inline uint32
acc_cmp(uint32 a, uint32 b)
{
	uint32 rv = 0;
	if (a >= b) rv |= (1U << 11);
	if (a <  b) rv |= (1U << 10);
	if (a <= b) rv |= (1U << 9);
	if (a >  b) rv |= (1U << 8);
	if ((int32)a >= (int32)b) rv |= (1U << 7);
	if ((int32)a <  (int32)b) rv |= (1U << 6);
	if ((int32)a <= (int32)b) rv |= (1U << 5);
	if ((int32)a >  (int32)b) rv |= (1U << 4);
	if ((int32)a != (int32)b) rv |= (1U << 3);
	if ((int32)a == (int32)b) rv |= (1U << 2);
	return rv;
}
