//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

#pragma once

#include "mpu680x0.h"

// ビットフィールド命令
class acc_bf
{
 public:
	explicit acc_bf(MPU680x0Device *);
	// デストラクタは無し。

	void LoadReg(uint n);		// Dn から値を読み込む
	bool LoadMem(uint32 addr);	// メモリから値を読み込む

	// レジスタまたはメモリにストアする
	void Store(uint n) {
		if (n < 8) {
			StoreReg(n);
		} else {
			StoreMem();
		}
	}

	uint32 data {};				// 32bit 左詰めデータ
	int32 offset {};			// (第2ワードで指定された) オフセット
	uint32 width {};			// 幅

 private:
	void StoreReg(uint n);		// 値を Dn に書き出す
	void StoreMem();			// 値をメモリに書き出す

	MPU680x0Device *cpu {};

	uint32 mask {};			// 32ビット左詰めマスク
	uint32 ea {};			// オフセット計算後の EA
	int32 local_offset {};	// 内部(32bit or 8bit 内)オフセット
	uint bytes {};			// アクセスバイト数
	uint64 buf {};			// 40ビットのメモリバッファ
};
