//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

// テスト用の DebuggerMemoryStream の簡易でっち上げ版。
// 実物をリンクすると芋づる式に必要なものが増えるので。
// アドレスは paddr のみ使うことにする。
//
// testdis.cpp 等から ram[] の宣言以降に直接 include して使う。

static inline uint64
vm_phys_peek_8(uint32 addr)
{
	assertmsg(addr < sizeof(ram), "addr=0x%x", addr);

	// XXX endian
	return ram[addr ^ 1];
}

// コンストラクタ
DebuggerMemoryStream::DebuggerMemoryStream(const DebuggerMD *md_,
	busaddr laddr_)
{
	md = md_;
	laddr = laddr_;
	paddr = laddr.Addr();
}

uint64
DebuggerMemoryStream::Peek(int bytes)
{
	uint64 data;

	data = 0;
	for (int i = 0; i < bytes; i++) {
		data <<= 8;
		data |= vm_phys_peek_8(paddr + i);
	}
	return data;
}

uint64
DebuggerMemoryStream::Read(int bytes)
{
	uint64 data;

	data = Peek(bytes);
	laddr += bytes;
	paddr += bytes;
	return data;
}
