//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// VM (LUNA)
//

#include "vm_luna.h"
#include "config.h"
#include "dipsw.h"
#include "lcd.h"
#include "lunakbd.h"
#include "mainbus_luna.h"
#include "mpu64180.h"
#include "mpu680x0.h"
#include "mpu88xx0.h"
#include "nmi.h"
#include "power.h"
#include "renderer.h"
#include "ssg.h"
#include "xpbus.h"

//
// LUNA 共通部
//

// コンストラクタ
VM_LUNA::VM_LUNA(const char *name_)
	: inherited(name_)
{
	// 実時間に同期したほうが便利。
	gConfig->SetDefault("clock-sync", "real");

	// RTC epoch は NetBSD/luna68k, OpenBSD/luna88k をデフォルトにしておく。
	gConfig->SetDefault("rtc-epoch-year", 1970);

	// LUNA 共通だしここで作成しておく
	NEWDV(Power, new LunaPowerDevice());
	NEWDV(Dipsw, new LunaDipswDevice());
	NEWDV(Keyboard, new LunaKeyboard());
	NEWDV(LCD, new LCDDevice());
	NEWDV(MPU64180, new MPU64180Device());
	NEWDV(NMI, new NMIDevice());
	NEWDV(Renderer, new LunaVideoRenderer());
	NEWDV(XPbus, new XPbusDevice());
}

// デストラクタ
VM_LUNA::~VM_LUNA()
{
}


//
// LUNA-I
//

// コンストラクタ
VM_LUNA1::VM_LUNA1()
	: inherited("LUNA-I")
{
	// 機種固有パラメータ
	// MPU 種別。
	gConfig->SetDefault("mpu-type", "68030");
	// MPU クロックの初期値は機種ごとに異なる。単位は MHz
	gConfig->SetDefault("mpu-clock", 20);
	// RAM 初期値は MAX にしておく
	gConfig->SetDefault("ram-size", 16);
	// SPC の入力クロック (おそらく 6.144MHz = 163ns が入ってる)
	gConfig->Add("!spc-tCLF", 163);
	// LUNA-I のクロック割り込みは 60Hz
	gConfig->Add("!sysclk-freq", 60);

	// デバイス
	NEWDV(MPU, NewMPU680x0Device());
	NEWDV(Mainbus, new Luna1Mainbus());
	NEWDV(SSG, new SSGDevice());

	// バーストアクセスたぶんあり
	auto mpu680x0 = GetMPU680x0Device(pMPU.get());
	if (mpu680x0) {
		mpu680x0->EnableBurstAccess(true);
	}
}

// デストラクタ
VM_LUNA1::~VM_LUNA1()
{
}


//
// LUNA-88K
//

// コンストラクタ
VM_LUNA88K::VM_LUNA88K()
	: inherited("LUNA-88K")
{
	// 機種固有パラメータ
	// MPU クロックの初期値は機種ごとに異なる。単位は MHz
	gConfig->SetDefault("mpu-clock", 25);
	// RAM 初期値は MAX にしておく
	gConfig->SetDefault("ram-size", 64);
	// SPC の入力クロック (XXX LUNA-I と同じ?)
	gConfig->Add("!spc-tCLF", 163);
	// LUNA-II, LUNA-88K, LUNA-88K2 のクロック割り込みは 100Hz らしい
	gConfig->Add("!sysclk-freq", 100);

	// デバイス (順序に注意)
	NEWDV(MPU, new MPU88xx0Device());
	NEWDV(Mainbus, new Luna88kMainbus());

	// バーストアクセスあり (m88k では常に有効)
}

// デストラクタ
VM_LUNA88K::~VM_LUNA88K()
{
}
