//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// LUNA システムクロック
//

#pragma once

#include "device.h"

class InterruptDevice;
class Syncer;

class SysClkDevice : public IODevice
{
	using inherited = IODevice;
 public:
	SysClkDevice();
	~SysClkDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	uint GetFreq() const { return freq; }

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = 1;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);
	bool PokePort(uint32 offset, uint32 data);

 private:
	// イベントコールバック
	void Callback(Event *ev);

	DECLARE_MONITOR_SCREEN(MonitorScreen);

	// 割り込み状態をレジスタイメージにして返す
	uint8 GetInt() const;

	// 割り込み信号線の状態を変える。
	void ChangeInterrupt();

	// システムクロック割り込み有りなら true。
	bool sysint {};

	// 割り込みイベント
	Event *event {};

	// システムクロック周波数 [Hz]
	uint freq {};

	// 本来のイベント間隔。機種によって異なる。
	uint64 period {};

	// システムクロックが刻んでいる時刻
	uint64 stime {};

	// 実時間との差 (表示用)
	int64 delta {};

	// システムクロックを実時間に同期する場合 true
	bool sync_rt {};

	InterruptDevice *interrupt {};
	Syncer *syncer {};

	Monitor *monitor {};
};

static inline SysClkDevice *GetSysClkDevice() {
	return Object::GetObject<SysClkDevice>(OBJ_SYSCLK);
}
