//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// メインメモリ
//

#pragma once

#include "device.h"
#include "bootloader.h"

class MainRAMDevice : public IODevice
{
	using inherited = IODevice;
 public:
	MainRAMDevice();
	~MainRAMDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata ReadBurst16(busaddr addr, uint32 *dst) override;
	busdata WriteBurst16(busaddr addr, const uint32 *dst) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

	// 領域アクセス
	bool ReadMem(uint32 addr, void *dst, uint32 len);
	bool WriteMem(uint32 addr, const void *src, uint32 len);

	// RAM 容量(バイト単位)を取得
	size_t GetSize() const	{ return ram_size; }
	// RAM 容量(MB単位)を取得
	uint GetSizeMB() const { return (uint)(ram_size / 1024 / 1024); }

	// アクセスウェイト [clock] を設定
	void SetWait(uint32 wait_clock);

 private:
	std::unique_ptr<uint8[]> mainram {};

	// RAM 容量(バイト単位)。ram[] の確保したバイト数
	size_t ram_size {};

	// アクセスウェイト
	busdata normal_wait {};
	busdata burst_wait {};

	// 電源オン時にメモリをクリアする。
	bool clear_on_boot {};
};

static inline MainRAMDevice *GetMainRAMDevice() {
	return Object::GetObject<MainRAMDevice>(OBJ_MAINRAM);
}
