//
// nono
// Copyright (C) 2025 nono project
// Licensed under nono-license.txt
//

//
// サウンドの OpenBSD sndio ドライバ
//

#include "sounddriver_sndio.h"
#include "config.h"
#include "sound.h"

// コンストラクタ
SoundDriverSndIO::SoundDriverSndIO(HostDevice *hostdev_)
	: inherited(hostdev_, "sndio")
{
}

// デストラクタ
SoundDriverSndIO::~SoundDriverSndIO()
{
	Close();
}

bool
SoundDriverSndIO::InitDriver(bool startup)
{
	if (inherited::InitDriver(startup) == false) {
		return false;
	}

	sio = sio_open(SIO_DEVANY, SIO_PLAY, 0);
	if (sio == NULL) {
		warn("%s: sio_open() failed", __method__);
		return false;
	}

	struct sio_par param;
	sio_initpar(&param);
	param.rate = freq;
	param.bits = 16;
	param.sig = 1;
	param.le = SIO_LE_NATIVE;
	param.pchan = Sound::NCHAN;
	param.appbufsz = freq * Sound::BLK_NSEC / 1_sec;
	if (sio_setpar(sio, &param) != 1) {
		warn("%s: sio_set_par() failed", __method__);
		sio_close(sio);
		return false;
	}

	if (sio_start(sio) != 1) {
		warn("%s: sio_start() failed", __method__);
		sio_close(sio);
		return false;
	}

	return true;
}

// ブロック書き出し
void
SoundDriverSndIO::Write(const int16 *blk)
{
	size_t written = 0;
	for (; written < blkbytes;) {
		const uint8 *buf = (const uint8 *)blk;
		auto r = sio_write(sio, buf + written, blkbytes - written);
		if (r == 0) {
			// ?
			break;
		}
		written += r;
	}
}

void
SoundDriverSndIO::Close()
{
	sio_stop(sio);
	sio_close(sio);
}

void
SoundDriverSndIO::MonitorScreenMD(TextScreen& screen, int y)
{
}
