<!--

    Copyright (c) 2011-present Sonatype, Inc. All rights reserved.
    Includes the third-party code listed at http://links.sonatype.com/products/clm/attributions.
    "Sonatype" is a trademark of Sonatype, Inc.

-->

# Reporting Security Vulnerabilities

## When to report

First check
[Important advisories of known security vulnerabilities in Sonatype products](https://support.sonatype.com/hc/en-us/sections/203012668-Security-Advisories)
to see if this has been previously reported.

## How to report

Please email reports regarding security related issues you find to [mailto:security@sonatype.com](security@sonatype.com).

Use our public key below to keep your message safe.

## What to include

Please use a descriptive subject line in your email report.

Your name and/or affiliation.

A detailed technical description of the vulnerability, attack scenario and where
possible, how we can reproduce your findings.

Provide us with a secure way to respond.

## What to expect

Your email will be acknowledged within 1 - 2 business days, and you'll receive a
more detailed response to your email within 7 business days.

We ask that everyone please follow responsible disclosure practices and allow
time for us to release a fix prior to public release.

Once an issue is reported, Sonatype uses the following disclosure process:

When a report is received, we confirm the issue and determine its severity.

If third-party services or software require mitigation before publication, those
projects will be notified.

## Our public key

```console
-----BEGIN PUBLIC KEY BLOCK-----
mQENBFF+a9ABCADQWSAAU7w9i71Zn3TQ6k7lT9x57cRdtX7V709oeN/c/1it+gCw
onmmCyf4ypor6XcPSOasp/x0s3hVuf6YfMbI0tSwJUWWihrmoPGIXtmiSOotQE0Q
Sav41xs3YyI9LzQB4ngZR/nhp4YhioD1dVorD6LGXk08rvl2ikoqHwTagbEXZJY7
3VYhW6JHbZTLwCsfyg6uaSYF1qXfUxHPOiHYKNbhK/tM3giX+9ld/7xi+9f4zEFQ
eX9wcRTdgdDOAqDOK7MV30KXagSqvW0MgEYtKX6q4KjjRzBYjkiTdFW/yMXub/Bs
5UckxHTCuAmvpr5J0HIUeLtXi1QCkijyn8HJABEBAAG0KVNvbmF0eXBlIFNlY3Vy
aXR5IDxzZWN1cml0eUBzb25hdHlwZS5jb20+iQE4BBMBAgAiBQJRfmvQAhsDBgsJ
CAcDAgYVCAIJCgsEFgIDAQIeAQIXgAAKCRAgkmxsNtgwfUzbCACLtCgieq1kJOqo
2i136ND5ZOj31zIzNENLn8dhSg5zQwTHOcntWAtS8uCNq4fSlslwvlbPYWTLD7fE
iJn1z7BCU8gBk+pkAJJFWEPweMVt+9bYQ4HfKceGbJeuwBBhS34SK9ZIp9gfxxfA
oTm0aGYwKR5wH3sqL/mrhwKhPt9wXR4qwlE635STEX8wzJ5SBqf3ArJUtCp1rzgR
Dx+DiZed5HE1pOI2Kyb6O80bm485WThPXxpvp3bfzTNYoGzeLi/F7WkmgggkXxsT
Pyd0sSx0B/MO4lJtQvEBlIHDFno9mXa30fKl+rzp2geG5UxNHJUjaC5JhfWLEXEX
wV0ErBsmuQENBFF+a9ABCADXj04+GLIz8VCaZH554nUHEhaKoiIXH3Tj7UiMZDqy
o4WIw2RFaCQNA8T0R5Q0yxINU146JQMbA2SN59AGcGYZcajyEvTR7tLG0meMO6S0
JWpkX7s3xaC0s+5SJ/ba00oHGzW0aotgzG9BWA5OniNHK7zZKMVu7M80M/wB1RvK
x775hAeJ+8F9MDJ+ijydBtaOfDdkbg+0kU1xR6Io+vVLPk38ghlWU8QFP4/B0oWi
jK4xiDqK6cG7kyH9kC9nau+ckH8MrJ/RzEpsc4GRwqS4IEnvHWe7XbgydWS1bCp6
8uP5ma3d02elQmSEa+PABIPKnZcAf1YKLr9O/+IzEdOhABEBAAGJAR8EGAECAAkF
AlF+a9ACGwwACgkQIJJsbDbYMH3WzAf/XOm4YQZFOgG2h9d03m8me8d1vrYico+0
pBYU9iCozLgamM4er9Efb+XzfLvNVKuqyR0cgvGszukIPQYeX58DMrZ07C+E0wDZ
bG+ZAYXT5GqsHkSVnMCVIfyJNLjR4sbVzykyVtnccBL6bP3jxbCP1jJdT7bwiKre
1jQjvyoL0yIegdiN/oEdmx52Fqjt4NkQsp4sk625UBFTVISr22bnf60ZIGgrRbAP
DU1XMdIrmqmhEEQcXMp4CeflDMksOmaIeAUkZY7eddnXMwQDJTnz5ziCal+1r0R3
dh0XISRG0NkiLEXeGkrs7Sn7BAAsTsaH/1zU6YbvoWlMlHYT6EarFQ== =sFGt
-----END PUBLIC KEY BLOCK-----
```
