// SPDX-License-Identifier: GPL-2.0-only
/*
 * multiskkserv.h -- simple skk multi-dictionary server
 * (C)Copyright 2001-2024 by Hiroshi Takekawa
 * This file is part of multiskkserv.
 *
 * Last Modified: Sat Feb 24 15:53:24 2024.
 */

#ifndef _MULTISKKSERV_H
#define _MULTISKKSERV_H

#define SKKSERV_SERVICE      "skkserv"
#define SKKSERV_WORD_SIZE    1023
#define SKKSERV_RESULT_SIZE  4096
#define SKKSERV_REQUEST_SIZE (SKKSERV_WORD_SIZE + 1)

#define SKKSERV_PORT         1178 /* can be specified by -p */
#define SKKSERV_BACKLOG      8    /* can be specified by -b */

#define SKKSERV_MAX_THREADS  16   /* Should be specified via option? */
#define SKKSERV_EXTENDED     1    /* This enables the statistic query. */

/* skkserv protocol */
#define SKKSERV_C_END       '0'
#define SKKSERV_C_REQUEST   '1'
#define SKKSERV_C_VERSION   '2'
#define SKKSERV_C_HOST      '3'
#ifdef SKKSERV_EXTENDED
# define SKKSERV_C_STAT      'S'
#endif

#define SKKSERV_S_ERROR     '0'
#define SKKSERV_S_FOUND     '1'
#define SKKSERV_S_NOT_FOUND '4'
#define SKKSERV_S_FULL      '9'
#ifdef SKKSERV_EXTENDED
# define SKKSERV_S_STAT      'S'
#endif

#endif
