/* $NetBSD$ */

/*
 * Copyright (c) 1996 Mark Brinicombe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Mark Brinicombe
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * RiscBSD kernel project
 *
 * blanktime.c
 *
 * Sets blanktime for a console
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <machine/vidc.h>
#include <machine/vconsole.h>

#define TTYNAME		"/dev/tty"

int verbose = 0;
int quiet = 0;

int set_blanktime(char *device, int blanktime);

void
usage()
{
	printf("Usage:\tblanktime [-q] [-v] [-b blanktime] [device] [device] ...\n");
	printf("or\tblanktime [-h]\n");
	exit(0);
}

int
main(argc, argv)
	int argc;
	char *argv[];
{
	int ch;
	char *devicename = TTYNAME;
	int fd;
	int blanktime = 600;
	int error;

	while ((ch = getopt(argc, argv, "d:b:vhq")) != -1) {
		switch(ch) {
		case 'd':
			devicename = optarg;
			break;
		case 'q':
			quiet = 1;
			break;
		case 'b':
			blanktime = atoi(optarg);
			break;
		case 'v':
		   	verbose = 1;
		   	break;
		case 'h':
		   	usage();
		   	break;
		}
	}

	argc -= optind;
	argv += optind;

/*	if (argc > 0) {
		blanktime = atoi(argv[0]);
		--argc;
		++argv;
	}*/

	error = 0;

	if (argc > 0) {
		while (argc > 0) {
			error += set_blanktime(argv[0], blanktime);
			--argc;
			++argv;
		}
	} else {
		error = set_blanktime(devicename, blanktime);
	}
	exit(error);
}

int
set_blanktime(device, blanktime)
	char *device;
	int blanktime;
{
	int fd;

	fd = open(device, O_RDWR);
	if (fd < 0) {
		if (!quiet)
			perror("Can't open device");
		return(1);
	}
	if (verbose) {
		printf("Setting blank time for %s\n", device);
		printf("Blank time = %d seconds\n", blanktime);
	}
	if (ioctl(fd, CONSOLE_BLANKTIME, &blanktime) != 0) {
		if (!quiet)
			perror("could not change blanking time\n");
		return(1);
	}

	close(fd);
	return(0);
}
