; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S -o - %s | FileCheck %s

define i1 @masked_and_notallzeroes(i32 %A) {
; CHECK-LABEL: @masked_and_notallzeroes(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 7
; CHECK-NEXT:    [[TST1:%.*]] = icmp ne i32 [[MASK1]], 0
; CHECK-NEXT:    ret i1 [[TST1]]
;
  %mask1 = and i32 %A, 7
  %tst1 = icmp ne i32 %mask1, 0
  %mask2 = and i32 %A, 39
  %tst2 = icmp ne i32 %mask2, 0
  %res = and i1 %tst1, %tst2
  ret i1 %res
}

define <2 x i1> @masked_and_notallzeroes_splat(<2 x i32> %A) {
; CHECK-LABEL: @masked_and_notallzeroes_splat(
; CHECK-NEXT:    [[MASK1:%.*]] = and <2 x i32> [[A:%.*]], <i32 7, i32 7>
; CHECK-NEXT:    [[TST1:%.*]] = icmp ne <2 x i32> [[MASK1]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[TST1]]
;
  %mask1 = and <2 x i32> %A, <i32 7, i32 7>
  %tst1 = icmp ne <2 x i32> %mask1, <i32 0, i32 0>
  %mask2 = and <2 x i32> %A, <i32 39, i32 39>
  %tst2 = icmp ne <2 x i32> %mask2, <i32 0, i32 0>
  %res = and <2 x i1> %tst1, %tst2
  ret <2 x i1> %res
}

define i1 @masked_and_notallzeroes_logical(i32 %A) {
; CHECK-LABEL: @masked_and_notallzeroes_logical(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 7
; CHECK-NEXT:    [[TST1:%.*]] = icmp ne i32 [[MASK1]], 0
; CHECK-NEXT:    ret i1 [[TST1]]
;
  %mask1 = and i32 %A, 7
  %tst1 = icmp ne i32 %mask1, 0
  %mask2 = and i32 %A, 39
  %tst2 = icmp ne i32 %mask2, 0
  %res = select i1 %tst1, i1 %tst2, i1 false
  ret i1 %res
}

define i1 @masked_or_allzeroes(i32 %A) {
; CHECK-LABEL: @masked_or_allzeroes(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 7
; CHECK-NEXT:    [[TST1:%.*]] = icmp eq i32 [[MASK1]], 0
; CHECK-NEXT:    ret i1 [[TST1]]
;
  %mask1 = and i32 %A, 7
  %tst1 = icmp eq i32 %mask1, 0
  %mask2 = and i32 %A, 39
  %tst2 = icmp eq i32 %mask2, 0
  %res = or i1 %tst1, %tst2
  ret i1 %res
}

define i1 @masked_or_allzeroes_logical(i32 %A) {
; CHECK-LABEL: @masked_or_allzeroes_logical(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 7
; CHECK-NEXT:    [[TST1:%.*]] = icmp eq i32 [[MASK1]], 0
; CHECK-NEXT:    ret i1 [[TST1]]
;
  %mask1 = and i32 %A, 7
  %tst1 = icmp eq i32 %mask1, 0
  %mask2 = and i32 %A, 39
  %tst2 = icmp eq i32 %mask2, 0
  %res = select i1 %tst1, i1 true, i1 %tst2
  ret i1 %res
}

define i1 @masked_and_notallones(i32 %A) {
; CHECK-LABEL: @masked_and_notallones(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 7
; CHECK-NEXT:    [[TST1:%.*]] = icmp ne i32 [[MASK1]], 7
; CHECK-NEXT:    ret i1 [[TST1]]
;
  %mask1 = and i32 %A, 7
  %tst1 = icmp ne i32 %mask1, 7
  %mask2 = and i32 %A, 39
  %tst2 = icmp ne i32 %mask2, 39
  %res = and i1 %tst1, %tst2
  ret i1 %res
}

define i1 @masked_and_notallones_logical(i32 %A) {
; CHECK-LABEL: @masked_and_notallones_logical(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 7
; CHECK-NEXT:    [[TST1:%.*]] = icmp ne i32 [[MASK1]], 7
; CHECK-NEXT:    ret i1 [[TST1]]
;
  %mask1 = and i32 %A, 7
  %tst1 = icmp ne i32 %mask1, 7
  %mask2 = and i32 %A, 39
  %tst2 = icmp ne i32 %mask2, 39
  %res = select i1 %tst1, i1 %tst2, i1 false
  ret i1 %res
}

define i1 @masked_or_allones(i32 %A) {
; CHECK-LABEL: @masked_or_allones(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 7
; CHECK-NEXT:    [[TST1:%.*]] = icmp eq i32 [[MASK1]], 7
; CHECK-NEXT:    ret i1 [[TST1]]
;
  %mask1 = and i32 %A, 7
  %tst1 = icmp eq i32 %mask1, 7
  %mask2 = and i32 %A, 39
  %tst2 = icmp eq i32 %mask2, 39
  %res = or i1 %tst1, %tst2
  ret i1 %res
}

define i1 @masked_or_allones_logical(i32 %A) {
; CHECK-LABEL: @masked_or_allones_logical(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 7
; CHECK-NEXT:    [[TST1:%.*]] = icmp eq i32 [[MASK1]], 7
; CHECK-NEXT:    ret i1 [[TST1]]
;
  %mask1 = and i32 %A, 7
  %tst1 = icmp eq i32 %mask1, 7
  %mask2 = and i32 %A, 39
  %tst2 = icmp eq i32 %mask2, 39
  %res = select i1 %tst1, i1 true, i1 %tst2
  ret i1 %res
}

define i1 @masked_and_notA(i32 %A) {
; CHECK-LABEL: @masked_and_notA(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A:%.*]], -79
; CHECK-NEXT:    [[TST2:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[TST2]]
;
  %mask1 = and i32 %A, 14
  %tst1 = icmp ne i32 %mask1, %A
  %mask2 = and i32 %A, 78
  %tst2 = icmp ne i32 %mask2, %A
  %res = and i1 %tst1, %tst2
  ret i1 %res
}

define i1 @masked_and_notA_logical(i32 %A) {
; CHECK-LABEL: @masked_and_notA_logical(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A:%.*]], -79
; CHECK-NEXT:    [[TST2:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[TST2]]
;
  %mask1 = and i32 %A, 14
  %tst1 = icmp ne i32 %mask1, %A
  %mask2 = and i32 %A, 78
  %tst2 = icmp ne i32 %mask2, %A
  %res = select i1 %tst1, i1 %tst2, i1 false
  ret i1 %res
}

define i1 @masked_and_notA_slightly_optimized(i32 %A) {
; CHECK-LABEL: @masked_and_notA_slightly_optimized(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A:%.*]], -40
; CHECK-NEXT:    [[TST2:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[TST2]]
;
  %t0 = icmp uge i32 %A, 8
  %mask2 = and i32 %A, 39
  %tst2 = icmp ne i32 %mask2, %A
  %res = and i1 %t0, %tst2
  ret i1 %res
}

define i1 @masked_and_notA_slightly_optimized_logical(i32 %A) {
; CHECK-LABEL: @masked_and_notA_slightly_optimized_logical(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A:%.*]], -40
; CHECK-NEXT:    [[TST2:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[TST2]]
;
  %t0 = icmp uge i32 %A, 8
  %mask2 = and i32 %A, 39
  %tst2 = icmp ne i32 %mask2, %A
  %res = select i1 %t0, i1 %tst2, i1 false
  ret i1 %res
}

define i1 @masked_or_A(i32 %A) {
; CHECK-LABEL: @masked_or_A(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A:%.*]], -79
; CHECK-NEXT:    [[TST2:%.*]] = icmp eq i32 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[TST2]]
;
  %mask1 = and i32 %A, 14
  %tst1 = icmp eq i32 %mask1, %A
  %mask2 = and i32 %A, 78
  %tst2 = icmp eq i32 %mask2, %A
  %res = or i1 %tst1, %tst2
  ret i1 %res
}

define i1 @masked_or_A_logical(i32 %A) {
; CHECK-LABEL: @masked_or_A_logical(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A:%.*]], -79
; CHECK-NEXT:    [[TST2:%.*]] = icmp eq i32 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[TST2]]
;
  %mask1 = and i32 %A, 14
  %tst1 = icmp eq i32 %mask1, %A
  %mask2 = and i32 %A, 78
  %tst2 = icmp eq i32 %mask2, %A
  %res = select i1 %tst1, i1 true, i1 %tst2
  ret i1 %res
}

define i1 @masked_or_A_slightly_optimized(i32 %A) {
; CHECK-LABEL: @masked_or_A_slightly_optimized(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A:%.*]], -40
; CHECK-NEXT:    [[TST2:%.*]] = icmp eq i32 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[TST2]]
;
  %t0 = icmp ult i32 %A, 8
  %mask2 = and i32 %A, 39
  %tst2 = icmp eq i32 %mask2, %A
  %res = or i1 %t0, %tst2
  ret i1 %res
}

define i1 @masked_or_A_slightly_optimized_logical(i32 %A) {
; CHECK-LABEL: @masked_or_A_slightly_optimized_logical(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A:%.*]], -40
; CHECK-NEXT:    [[TST2:%.*]] = icmp eq i32 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[TST2]]
;
  %t0 = icmp ult i32 %A, 8
  %mask2 = and i32 %A, 39
  %tst2 = icmp eq i32 %mask2, %A
  %res = select i1 %t0, i1 true, i1 %tst2
  ret i1 %res
}

define i1 @masked_or_allzeroes_notoptimised(i32 %A) {
; CHECK-LABEL: @masked_or_allzeroes_notoptimised(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 15
; CHECK-NEXT:    [[TST1:%.*]] = icmp eq i32 [[MASK1]], 0
; CHECK-NEXT:    [[MASK2:%.*]] = and i32 [[A]], 39
; CHECK-NEXT:    [[TST2:%.*]] = icmp eq i32 [[MASK2]], 0
; CHECK-NEXT:    [[RES:%.*]] = or i1 [[TST1]], [[TST2]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %mask1 = and i32 %A, 15
  %tst1 = icmp eq i32 %mask1, 0
  %mask2 = and i32 %A, 39
  %tst2 = icmp eq i32 %mask2, 0
  %res = or i1 %tst1, %tst2
  ret i1 %res
}

define i1 @masked_or_allzeroes_notoptimised_logical(i32 %A) {
; CHECK-LABEL: @masked_or_allzeroes_notoptimised_logical(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 15
; CHECK-NEXT:    [[TST1:%.*]] = icmp eq i32 [[MASK1]], 0
; CHECK-NEXT:    [[MASK2:%.*]] = and i32 [[A]], 39
; CHECK-NEXT:    [[TST2:%.*]] = icmp eq i32 [[MASK2]], 0
; CHECK-NEXT:    [[RES:%.*]] = or i1 [[TST1]], [[TST2]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %mask1 = and i32 %A, 15
  %tst1 = icmp eq i32 %mask1, 0
  %mask2 = and i32 %A, 39
  %tst2 = icmp eq i32 %mask2, 0
  %res = select i1 %tst1, i1 true, i1 %tst2
  ret i1 %res
}

define i1 @nomask_lhs(i32 %in) {
; CHECK-LABEL: @nomask_lhs(
; CHECK-NEXT:    [[MASKED:%.*]] = and i32 [[IN:%.*]], 1
; CHECK-NEXT:    [[TST2:%.*]] = icmp eq i32 [[MASKED]], 0
; CHECK-NEXT:    ret i1 [[TST2]]
;
  %tst1 = icmp eq i32 %in, 0
  %masked = and i32 %in, 1
  %tst2 = icmp eq i32 %masked, 0
  %val = or i1 %tst1, %tst2
  ret i1 %val
}

define i1 @nomask_lhs_logical(i32 %in) {
; CHECK-LABEL: @nomask_lhs_logical(
; CHECK-NEXT:    [[MASKED:%.*]] = and i32 [[IN:%.*]], 1
; CHECK-NEXT:    [[TST2:%.*]] = icmp eq i32 [[MASKED]], 0
; CHECK-NEXT:    ret i1 [[TST2]]
;
  %tst1 = icmp eq i32 %in, 0
  %masked = and i32 %in, 1
  %tst2 = icmp eq i32 %masked, 0
  %val = select i1 %tst1, i1 true, i1 %tst2
  ret i1 %val
}

define i1 @nomask_rhs(i32 %in) {
; CHECK-LABEL: @nomask_rhs(
; CHECK-NEXT:    [[MASKED:%.*]] = and i32 [[IN:%.*]], 1
; CHECK-NEXT:    [[TST1:%.*]] = icmp eq i32 [[MASKED]], 0
; CHECK-NEXT:    ret i1 [[TST1]]
;
  %masked = and i32 %in, 1
  %tst1 = icmp eq i32 %masked, 0
  %tst2 = icmp eq i32 %in, 0
  %val = or i1 %tst1, %tst2
  ret i1 %val
}

define i1 @nomask_rhs_logical(i32 %in) {
; CHECK-LABEL: @nomask_rhs_logical(
; CHECK-NEXT:    [[MASKED:%.*]] = and i32 [[IN:%.*]], 1
; CHECK-NEXT:    [[TST1:%.*]] = icmp eq i32 [[MASKED]], 0
; CHECK-NEXT:    ret i1 [[TST1]]
;
  %masked = and i32 %in, 1
  %tst1 = icmp eq i32 %masked, 0
  %tst2 = icmp eq i32 %in, 0
  %val = select i1 %tst1, i1 true, i1 %tst2
  ret i1 %val
}

; TODO: This test simplifies to a constant, so the functionality and test could be in InstSimplify.

define i1 @fold_mask_cmps_to_false(i32 %x) {
; CHECK-LABEL: @fold_mask_cmps_to_false(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 2147483647
  %t2 = icmp eq i32 %t1, 0
  %t3 = icmp eq i32 %x, 2147483647
  %t4 = and i1 %t3, %t2
  ret i1 %t4
}

define i1 @fold_mask_cmps_to_false_logical(i32 %x) {
; CHECK-LABEL: @fold_mask_cmps_to_false_logical(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 2147483647
  %t2 = icmp eq i32 %t1, 0
  %t3 = icmp eq i32 %x, 2147483647
  %t4 = select i1 %t3, i1 %t2, i1 false
  ret i1 %t4
}

; TODO: This test simplifies to a constant, so the functionality and test could be in InstSimplify.

define i1 @fold_mask_cmps_to_true(i32 %x) {
; CHECK-LABEL: @fold_mask_cmps_to_true(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 2147483647
  %t2 = icmp ne i32 %t1, 0
  %t3 = icmp ne i32 %x, 2147483647
  %t4 = or i1 %t3, %t2
  ret i1 %t4
}

define i1 @fold_mask_cmps_to_true_logical(i32 %x) {
; CHECK-LABEL: @fold_mask_cmps_to_true_logical(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 2147483647
  %t2 = icmp ne i32 %t1, 0
  %t3 = icmp ne i32 %x, 2147483647
  %t4 = select i1 %t3, i1 true, i1 %t2
  ret i1 %t4
}

define <2 x i1> @nomask_splat_and_B_allones(<2 x i32> %A) {
; CHECK-LABEL: @nomask_splat_and_B_allones(
; CHECK-NEXT:    [[RES:%.*]] = icmp ugt <2 x i32> [[A:%.*]], <i32 -268435457, i32 -268435457>
; CHECK-NEXT:    ret <2 x i1> [[RES]]
;
  %tst1 = icmp slt <2 x i32> %A, <i32 0, i32 poison>
  %mask2 = and <2 x i32> %A, <i32 1879048192, i32 1879048192>
  %tst2 = icmp eq <2 x i32> %mask2, <i32 1879048192, i32 1879048192>
  %res = and <2 x i1> %tst1, %tst2
  ret <2 x i1> %res
}

define <2 x i1> @nomask_splat_and_B_mixed(<2 x i32> %A) {
; CHECK-LABEL: @nomask_splat_and_B_mixed(
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[A:%.*]], <i32 -268435456, i32 -268435456>
; CHECK-NEXT:    [[RES:%.*]] = icmp eq <2 x i32> [[TMP1]], <i32 1879048192, i32 1879048192>
; CHECK-NEXT:    ret <2 x i1> [[RES]]
;
  %tst1 = icmp sgt <2 x i32> %A, <i32 -1, i32 poison>
  %mask2 = and <2 x i32> %A, <i32 1879048192, i32 1879048192>
  %tst2 = icmp eq <2 x i32> %mask2, <i32 1879048192, i32 1879048192>
  %res = and <2 x i1> %tst1, %tst2
  ret <2 x i1> %res
}

; PR32401 - https://bugs.llvm.org/show_bug.cgi?id=32401

define i1 @cmpeq_bitwise(i8 %a, i8 %b, i8 %c, i8 %d) {
; CHECK-LABEL: @cmpeq_bitwise(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[C:%.*]], [[D:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor1 = xor i8 %a, %b
  %xor2 = xor i8 %c, %d
  %or = or i8 %xor1, %xor2
  %cmp = icmp eq i8 %or, 0
  ret i1 %cmp
}

define <2 x i1> @cmpne_bitwise(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c, <2 x i64> %d) {
; CHECK-LABEL: @cmpne_bitwise(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne <2 x i64> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i64> [[C:%.*]], [[D:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = or <2 x i1> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %xor1 = xor <2 x i64> %a, %b
  %xor2 = xor <2 x i64> %c, %d
  %or = or <2 x i64> %xor1, %xor2
  %cmp = icmp ne <2 x i64> %or, zeroinitializer
  ret <2 x i1> %cmp
}

; ((X & 12) != 0 & (X & 3) == 1) -> no change
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_0(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_0(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 12
; CHECK-NEXT:    [[T2:%.*]] = icmp ne i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = and i1 [[T2]], [[T4]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp eq i32 %t3, 1
  %t5 = and i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_0_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_0_logical(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 12
; CHECK-NEXT:    [[T2:%.*]] = icmp ne i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = and i1 [[T2]], [[T4]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp eq i32 %t3, 1
  %t5 = select i1 %t2, i1 %t4, i1 false
  ret i1 %t5
}

; ((X & 12) != 0 & (X & 7) == 1) -> (X & 15) == 9
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_1(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_1(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp eq i32 [[TMP1]], 9
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp eq i32 %t3, 1
  %t5 = and i1 %t2, %t4
  ret i1 %t5
}

define <2 x i1> @masked_icmps_mask_notallzeros_bmask_mixed_1_vector(<2 x i32> %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_1_vector(
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[X:%.*]], <i32 15, i32 15>
; CHECK-NEXT:    [[T5:%.*]] = icmp eq <2 x i32> [[TMP1]], <i32 9, i32 9>
; CHECK-NEXT:    ret <2 x i1> [[T5]]
;
  %t1 = and <2 x i32> %x, <i32 12, i32 12>
  %t2 = icmp ne <2 x i32> %t1, zeroinitializer
  %t3 = and <2 x i32> %x, <i32 7, i32 7>
  %t4 = icmp eq <2 x i32> %t3, <i32 1, i32 1>
  %t5 = and <2 x i1> %t2, %t4
  ret <2 x i1> %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_1_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_1_logical(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp eq i32 [[TMP1]], 9
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp eq i32 %t3, 1
  %t5 = select i1 %t2, i1 %t4, i1 false
  ret i1 %t5
}

; ((X & 14) != 0 & (X & 3) == 1) -> no change
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_1b(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_1b(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 14
; CHECK-NEXT:    [[T2:%.*]] = icmp ne i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = and i1 [[T2]], [[T4]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 14
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp eq i32 %t3, 1
  %t5 = and i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_1b_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_1b_logical(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 14
; CHECK-NEXT:    [[T2:%.*]] = icmp ne i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = and i1 [[T2]], [[T4]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 14
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp eq i32 %t3, 1
  %t5 = select i1 %t2, i1 %t4, i1 false
  ret i1 %t5
}

; ((X & 3) != 0 & (X & 7) == 0) -> false
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_2(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_2(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 3
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp eq i32 %t3, 0
  %t5 = and i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_2_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_2_logical(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 3
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp eq i32 %t3, 0
  %t5 = select i1 %t2, i1 %t4, i1 false
  ret i1 %t5
}

; ((X & 15) != 0 & (X & 7) == 0) -> (X & 15) == 8
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_3(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_3(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp eq i32 [[TMP1]], 8
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp eq i32 %t3, 0
  %t5 = and i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_3_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_3_logical(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp eq i32 [[TMP1]], 8
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp eq i32 %t3, 0
  %t5 = select i1 %t2, i1 %t4, i1 false
  ret i1 %t5
}

; ((X & 15) != 0 & (X & 3) == 0) -> no change
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_3b(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_3b(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T2:%.*]] = icmp ne i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 0
; CHECK-NEXT:    [[T5:%.*]] = and i1 [[T2]], [[T4]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp eq i32 %t3, 0
  %t5 = and i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_3b_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_3b_logical(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T2:%.*]] = icmp ne i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 0
; CHECK-NEXT:    [[T5:%.*]] = and i1 [[T2]], [[T4]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp eq i32 %t3, 0
  %t5 = select i1 %t2, i1 %t4, i1 false
  ret i1 %t5
}

; ((X & 255) != 0 & (X & 15) == 8) -> (X & 15) == 8
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_4(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_4(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 255
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = and i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_4_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_4_logical(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 255
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = select i1 %t2, i1 %t4, i1 false
  ret i1 %t5
}

; ((X & 15) != 0 & (X & 15) == 8) -> (X & 15) == 8
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_5(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_5(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = and i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_5_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_5_logical(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = select i1 %t2, i1 %t4, i1 false
  ret i1 %t5
}

; ((X & 12) != 0 & (X & 15) == 8) -> (X & 15) == 8
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_6(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_6(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = and i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_6_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_6_logical(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = select i1 %t2, i1 %t4, i1 false
  ret i1 %t5
}

; ((X & 7) != 0 & (X & 15) == 8) -> false
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_7(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_7(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 7
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = and i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_7_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_7_logical(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 7
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = select i1 %t2, i1 %t4, i1 false
  ret i1 %t5
}

; ((X & 6) != 0 & (X & 15) == 8) -> false
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_7b(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_7b(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 6
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = and i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_7b_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_7b_logical(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 6
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = select i1 %t2, i1 %t4, i1 false
  ret i1 %t5
}

; ((X & 12) == 0 | (X & 3) != 1) -> !((X & 12) != 0 & (X & 3) == 1)) ->
; no change
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_0(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_0(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 12
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = or i1 [[T2]], [[T4]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp ne i32 %t3, 1
  %t5 = or i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_0_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_0_logical(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 12
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = or i1 [[T2]], [[T4]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp ne i32 %t3, 1
  %t5 = select i1 %t2, i1 true, i1 %t4
  ret i1 %t5
}

; ((X & 12) == 0 | (X & 7) != 1) -> !((X & 12) != 0 & (X & 7) == 1) ->
; !((X & 15) == 9) -> (X & 15) != 9
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_1(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_1(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp ne i32 [[TMP1]], 9
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp ne i32 %t3, 1
  %t5 = or i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_1_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_1_logical(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp ne i32 [[TMP1]], 9
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp ne i32 %t3, 1
  %t5 = select i1 %t2, i1 true, i1 %t4
  ret i1 %t5
}

; ((X & 14) == 0 | (X & 3) != 1) -> !((X & 14) != 0 & (X & 3) == 1) ->
; no change.
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_1b(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_1b(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 14
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = or i1 [[T2]], [[T4]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 14
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp ne i32 %t3, 1
  %t5 = or i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_1b_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_1b_logical(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 14
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = or i1 [[T2]], [[T4]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 14
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp ne i32 %t3, 1
  %t5 = select i1 %t2, i1 true, i1 %t4
  ret i1 %t5
}

; ((X & 3) == 0 | (X & 7) != 0) -> !((X & 3) != 0 & (X & 7) == 0) ->
; !(false) -> true
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_2(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_2(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 3
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp ne i32 %t3, 0
  %t5 = or i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_2_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_2_logical(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 3
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp ne i32 %t3, 0
  %t5 = select i1 %t2, i1 true, i1 %t4
  ret i1 %t5
}

; ((X & 15) == 0 | (X & 7) != 0) -> !((X & 15) != 0 & (X & 7) == 0) ->
; !((X & 15) == 8) -> (X & 15) != 8
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_3(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_3(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp ne i32 [[TMP1]], 8
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp ne i32 %t3, 0
  %t5 = or i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_3_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_3_logical(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp ne i32 [[TMP1]], 8
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp ne i32 %t3, 0
  %t5 = select i1 %t2, i1 true, i1 %t4
  ret i1 %t5
}

; ((X & 15) == 0 | (X & 3) != 0) -> !((X & 15) != 0 & (X & 3) == 0) ->
; no change.
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_3b(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_3b(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 0
; CHECK-NEXT:    [[T5:%.*]] = or i1 [[T2]], [[T4]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp ne i32 %t3, 0
  %t5 = or i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_3b_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_3b_logical(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 0
; CHECK-NEXT:    [[T5:%.*]] = or i1 [[T2]], [[T4]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp ne i32 %t3, 0
  %t5 = select i1 %t2, i1 true, i1 %t4
  ret i1 %t5
}

; ((X & 255) == 0 | (X & 15) != 8) -> !(((X & 255) != 0 & (X & 15) == 8)) ->
; !((X & 15) == 8) -> ((X & 15) != 8)
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_4(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_4(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 255
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = or i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_4_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_4_logical(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 255
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = select i1 %t2, i1 true, i1 %t4
  ret i1 %t5
}

; ((X & 15) == 0 | (X & 15) != 8) -> !(((X & 15) != 0 & (X & 15) == 8)) ->
; !((X & 15) == 8) -> ((X & 15) != 8)
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_5(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_5(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = or i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_5_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_5_logical(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = select i1 %t2, i1 true, i1 %t4
  ret i1 %t5
}

; ((X & 12) == 0 | (X & 15) != 8) -> !(((X & 12) != 0 & (X & 15) == 8)) ->
; !((X & 15) == 8) -> ((X & 15) != 8
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_6(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_6(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = or i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_6_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_6_logical(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = select i1 %t2, i1 true, i1 %t4
  ret i1 %t5
}

; ((X & 7) == 0 | (X & 15) != 8) -> !(((X & 7) != 0 & (X & 15) == 8)) ->
; !(false) -> true
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_7(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_7(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 7
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = or i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_7_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_7_logical(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 7
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = select i1 %t2, i1 true, i1 %t4
  ret i1 %t5
}

; ((X & 6) == 0 | (X & 15) != 8) -> !(((X & 6) != 0 & (X & 15) == 8)) ->
; !(false) -> true
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_7b(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_7b(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 6
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = or i1 %t2, %t4
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_7b_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_7b_logical(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 6
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = select i1 %t2, i1 true, i1 %t4
  ret i1 %t5
}


; ((X & 12) != 0 & (X & 3) == 1) -> no change
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_0(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_0(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 12
; CHECK-NEXT:    [[T2:%.*]] = icmp ne i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = and i1 [[T4]], [[T2]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp eq i32 %t3, 1
  %t5 = and i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_0_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_0_logical(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 12
; CHECK-NEXT:    [[T2:%.*]] = icmp ne i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = and i1 [[T4]], [[T2]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp eq i32 %t3, 1
  %t5 = select i1 %t4, i1 %t2, i1 false
  ret i1 %t5
}

; ((X & 12) != 0 & (X & 7) == 1) -> (X & 15) == 9
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_1(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_1(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp eq i32 [[TMP1]], 9
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp eq i32 %t3, 1
  %t5 = and i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_1_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_1_logical(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp eq i32 [[TMP1]], 9
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp eq i32 %t3, 1
  %t5 = select i1 %t4, i1 %t2, i1 false
  ret i1 %t5
}

; ((X & 14) != 0 & (X & 3) == 1) -> no change
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_1b(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_1b(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 14
; CHECK-NEXT:    [[T2:%.*]] = icmp ne i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = and i1 [[T4]], [[T2]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 14
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp eq i32 %t3, 1
  %t5 = and i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_1b_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_1b_logical(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 14
; CHECK-NEXT:    [[T2:%.*]] = icmp ne i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = and i1 [[T4]], [[T2]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 14
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp eq i32 %t3, 1
  %t5 = select i1 %t4, i1 %t2, i1 false
  ret i1 %t5
}

; ((X & 3) != 0 & (X & 7) == 0) -> false
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_2(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_2(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 3
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp eq i32 %t3, 0
  %t5 = and i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_2_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_2_logical(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 3
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp eq i32 %t3, 0
  %t5 = select i1 %t4, i1 %t2, i1 false
  ret i1 %t5
}

; ((X & 15) != 0 & (X & 7) == 0) -> (X & 15) == 8
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_3(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_3(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp eq i32 [[TMP1]], 8
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp eq i32 %t3, 0
  %t5 = and i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_3_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_3_logical(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp eq i32 [[TMP1]], 8
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp eq i32 %t3, 0
  %t5 = select i1 %t4, i1 %t2, i1 false
  ret i1 %t5
}

; ((X & 15) != 0 & (X & 3) == 0) -> no change
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_3b(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_3b(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T2:%.*]] = icmp ne i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 0
; CHECK-NEXT:    [[T5:%.*]] = and i1 [[T4]], [[T2]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp eq i32 %t3, 0
  %t5 = and i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_3b_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_3b_logical(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T2:%.*]] = icmp ne i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 0
; CHECK-NEXT:    [[T5:%.*]] = and i1 [[T4]], [[T2]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp eq i32 %t3, 0
  %t5 = select i1 %t4, i1 %t2, i1 false
  ret i1 %t5
}

; ((X & 255) != 0 & (X & 15) == 8) -> (X & 15) == 8
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_4(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_4(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 255
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = and i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_4_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_4_logical(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 255
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = select i1 %t4, i1 %t2, i1 false
  ret i1 %t5
}

; ((X & 15) != 0 & (X & 15) == 8) -> (X & 15) == 8
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_5(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_5(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = and i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_5_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_5_logical(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = select i1 %t4, i1 %t2, i1 false
  ret i1 %t5
}

; ((X & 12) != 0 & (X & 15) == 8) -> (X & 15) == 8
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_6(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_6(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = and i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_6_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_6_logical(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = select i1 %t4, i1 %t2, i1 false
  ret i1 %t5
}

; ((X & 7) != 0 & (X & 15) == 8) -> false
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_7(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_7(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 7
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = and i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_7_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_7_logical(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 7
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = select i1 %t4, i1 %t2, i1 false
  ret i1 %t5
}

; ((X & 6) != 0 & (X & 15) == 8) -> false
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_7b(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_7b(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 6
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = and i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_swapped_7b_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_swapped_7b_logical(
; CHECK-NEXT:    ret i1 false
;
  %t1 = and i32 %x, 6
  %t2 = icmp ne i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp eq i32 %t3, 8
  %t5 = select i1 %t4, i1 %t2, i1 false
  ret i1 %t5
}

; ((X & 12) == 0 | (X & 3) != 1) -> !((X & 12) != 0 & (X & 3) == 1)) ->
; no change
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_0(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_0(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 12
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = or i1 [[T4]], [[T2]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp ne i32 %t3, 1
  %t5 = or i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_0_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_0_logical(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 12
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = or i1 [[T4]], [[T2]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp ne i32 %t3, 1
  %t5 = select i1 %t4, i1 true, i1 %t2
  ret i1 %t5
}

; ((X & 12) == 0 | (X & 7) != 1) -> !((X & 12) != 0 & (X & 7) == 1) ->
; !((X & 15) == 9) -> (X & 15) != 9
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_1(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_1(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp ne i32 [[TMP1]], 9
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp ne i32 %t3, 1
  %t5 = or i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_1_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_1_logical(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp ne i32 [[TMP1]], 9
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp ne i32 %t3, 1
  %t5 = select i1 %t4, i1 true, i1 %t2
  ret i1 %t5
}

; ((X & 14) == 0 | (X & 3) != 1) -> !((X & 14) != 0 & (X & 3) == 1) ->
; no change.
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_1b(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_1b(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 14
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = or i1 [[T4]], [[T2]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 14
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp ne i32 %t3, 1
  %t5 = or i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_1b_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_1b_logical(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 14
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 1
; CHECK-NEXT:    [[T5:%.*]] = or i1 [[T4]], [[T2]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 14
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp ne i32 %t3, 1
  %t5 = select i1 %t4, i1 true, i1 %t2
  ret i1 %t5
}

; ((X & 3) == 0 | (X & 7) != 0) -> !((X & 3) != 0 & (X & 7) == 0) ->
; !(false) -> true
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_2(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_2(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 3
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp ne i32 %t3, 0
  %t5 = or i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_2_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_2_logical(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 3
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp ne i32 %t3, 0
  %t5 = select i1 %t4, i1 true, i1 %t2
  ret i1 %t5
}

; ((X & 15) == 0 | (X & 7) != 0) -> !((X & 15) != 0 & (X & 7) == 0) ->
; !((X & 15) == 8) -> (X & 15) != 8
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_3(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_3(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp ne i32 [[TMP1]], 8
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp ne i32 %t3, 0
  %t5 = or i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_3_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_3_logical(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T5:%.*]] = icmp ne i32 [[TMP1]], 8
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 7
  %t4 = icmp ne i32 %t3, 0
  %t5 = select i1 %t4, i1 true, i1 %t2
  ret i1 %t5
}

; ((X & 15) == 0 | (X & 3) != 0) -> !((X & 15) != 0 & (X & 3) == 0) ->
; no change.
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_3b(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_3b(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 0
; CHECK-NEXT:    [[T5:%.*]] = or i1 [[T4]], [[T2]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp ne i32 %t3, 0
  %t5 = or i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_3b_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_3b_logical(
; CHECK-NEXT:    [[T1:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 0
; CHECK-NEXT:    [[T5:%.*]] = or i1 [[T4]], [[T2]]
; CHECK-NEXT:    ret i1 [[T5]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 3
  %t4 = icmp ne i32 %t3, 0
  %t5 = select i1 %t4, i1 true, i1 %t2
  ret i1 %t5
}

; ((X & 255) == 0 | (X & 15) != 8) -> !(((X & 255) != 0 & (X & 15) == 8)) ->
; !((X & 15) == 8) -> ((X & 15) != 8)
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_4(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_4(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 255
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = or i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_4_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_4_logical(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 255
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = select i1 %t4, i1 true, i1 %t2
  ret i1 %t5
}

; ((X & 15) == 0 | (X & 15) != 8) -> !(((X & 15) != 0 & (X & 15) == 8)) ->
; !((X & 15) == 8) -> ((X & 15) != 8)
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_5(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_5(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = or i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_5_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_5_logical(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 15
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = select i1 %t4, i1 true, i1 %t2
  ret i1 %t5
}

; ((X & 12) == 0 | (X & 15) != 8) -> !(((X & 12) != 0 & (X & 15) == 8)) ->
; !((X & 15) == 8) -> ((X & 15) != 8
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_6(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_6(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = or i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_6_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_6_logical(
; CHECK-NEXT:    [[T3:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[T3]], 8
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = and i32 %x, 12
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = select i1 %t4, i1 true, i1 %t2
  ret i1 %t5
}

; ((X & 7) == 0 | (X & 15) != 8) -> !(((X & 7) != 0 & (X & 15) == 8)) ->
; !(false) -> true
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_7(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_7(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 7
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = or i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_7_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_7_logical(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 7
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = select i1 %t4, i1 true, i1 %t2
  ret i1 %t5
}

; ((X & 6) == 0 | (X & 15) != 8) -> !(((X & 6) != 0 & (X & 15) == 8)) ->
; !(false) -> true
define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_7b(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_7b(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 6
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = or i1 %t4, %t2
  ret i1 %t5
}

define i1 @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_7b_logical(i32 %x) {
; CHECK-LABEL: @masked_icmps_mask_notallzeros_bmask_mixed_negated_swapped_7b_logical(
; CHECK-NEXT:    ret i1 true
;
  %t1 = and i32 %x, 6
  %t2 = icmp eq i32 %t1, 0
  %t3 = and i32 %x, 15
  %t4 = icmp ne i32 %t3, 8
  %t5 = select i1 %t4, i1 true, i1 %t2
  ret i1 %t5
}


define i1 @masked_icmps_bmask_notmixed_or(i32 %A) {
; CHECK-LABEL: @masked_icmps_bmask_notmixed_or(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A:%.*]], 15
; CHECK-NEXT:    [[RES:%.*]] = icmp eq i32 [[TMP1]], 3
; CHECK-NEXT:    ret i1 [[RES]]
;
  %mask1 = and i32 %A, 15 ; 0x0f
  %tst1 = icmp eq i32 %mask1, 3 ; 0x03
  %mask2 = and i32 %A, 255 ; 0xff
  %tst2 = icmp eq i32 %mask2, 243; 0xf3
  %res = or i1 %tst1, %tst2
  ret i1 %res
}

define <2 x i1> @masked_icmps_bmask_notmixed_or_vec(<2 x i8> %A) {
; CHECK-LABEL: @masked_icmps_bmask_notmixed_or_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i8> [[A:%.*]], <i8 15, i8 15>
; CHECK-NEXT:    [[RES:%.*]] = icmp eq <2 x i8> [[TMP1]], <i8 3, i8 3>
; CHECK-NEXT:    ret <2 x i1> [[RES]]
;
  %mask1 = and <2 x i8> %A, <i8 15, i8 15> ; 0x0f
  %tst1 = icmp eq <2 x i8> %mask1, <i8 3, i8 3> ; 0x03
  %mask2 = and <2 x i8> %A, <i8 255, i8 255> ; 0xff
  %tst2 = icmp eq <2 x i8> %mask2, <i8 243, i8 243> ; 0xf3
  %res = or <2 x i1> %tst1, %tst2
  ret <2 x i1> %res
}

define <2 x i1> @masked_icmps_bmask_notmixed_or_vec_poison1(<2 x i8> %A) {
; CHECK-LABEL: @masked_icmps_bmask_notmixed_or_vec_poison1(
; CHECK-NEXT:    [[MASK1:%.*]] = and <2 x i8> [[A:%.*]], <i8 15, i8 15>
; CHECK-NEXT:    [[TST1:%.*]] = icmp eq <2 x i8> [[MASK1]], <i8 3, i8 poison>
; CHECK-NEXT:    [[TST2:%.*]] = icmp eq <2 x i8> [[A]], <i8 -13, i8 -13>
; CHECK-NEXT:    [[RES:%.*]] = or <2 x i1> [[TST1]], [[TST2]]
; CHECK-NEXT:    ret <2 x i1> [[RES]]
;
  %mask1 = and <2 x i8> %A, <i8 15, i8 15> ; 0x0f
  %tst1 = icmp eq <2 x i8> %mask1, <i8 3, i8 poison> ; 0x03
  %mask2 = and <2 x i8> %A, <i8 255, i8 255> ; 0xff
  %tst2 = icmp eq <2 x i8> %mask2, <i8 243, i8 243> ; 0xf3
  %res = or <2 x i1> %tst1, %tst2
  ret <2 x i1> %res
}

define <2 x i1> @masked_icmps_bmask_notmixed_or_vec_poison2(<2 x i8> %A) {
; CHECK-LABEL: @masked_icmps_bmask_notmixed_or_vec_poison2(
; CHECK-NEXT:    [[MASK1:%.*]] = and <2 x i8> [[A:%.*]], <i8 15, i8 15>
; CHECK-NEXT:    [[TST1:%.*]] = icmp eq <2 x i8> [[MASK1]], <i8 3, i8 3>
; CHECK-NEXT:    [[TST2:%.*]] = icmp eq <2 x i8> [[A]], <i8 -13, i8 poison>
; CHECK-NEXT:    [[RES:%.*]] = or <2 x i1> [[TST1]], [[TST2]]
; CHECK-NEXT:    ret <2 x i1> [[RES]]
;
  %mask1 = and <2 x i8> %A, <i8 15, i8 15> ; 0x0f
  %tst1 = icmp eq <2 x i8> %mask1, <i8 3, i8 3> ; 0x03
  %mask2 = and <2 x i8> %A, <i8 255, i8 255> ; 0xff
  %tst2 = icmp eq <2 x i8> %mask2, <i8 243, i8 poison> ; 0xf3
  %res = or <2 x i1> %tst1, %tst2
  ret <2 x i1> %res
}

define i1 @masked_icmps_bmask_notmixed_or_contradict_notoptimized(i32 %A) {
; CHECK-LABEL: @masked_icmps_bmask_notmixed_or_contradict_notoptimized(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 15
; CHECK-NEXT:    [[TST1:%.*]] = icmp eq i32 [[MASK1]], 3
; CHECK-NEXT:    [[MASK2:%.*]] = and i32 [[A]], 255
; CHECK-NEXT:    [[TST2:%.*]] = icmp eq i32 [[MASK2]], 242
; CHECK-NEXT:    [[RES:%.*]] = or i1 [[TST1]], [[TST2]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %mask1 = and i32 %A, 15 ; 0x0f
  %tst1 = icmp eq i32 %mask1, 3 ; 0x03
  %mask2 = and i32 %A, 255 ; 0xff
  %tst2 = icmp eq i32 %mask2, 242; 0xf2
  %res = or i1 %tst1, %tst2
  ret i1 %res
}

define i1 @masked_icmps_bmask_notmixed_and(i32 %A) {
; CHECK-LABEL: @masked_icmps_bmask_notmixed_and(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A:%.*]], 15
; CHECK-NEXT:    [[RES:%.*]] = icmp ne i32 [[TMP1]], 3
; CHECK-NEXT:    ret i1 [[RES]]
;
  %mask1 = and i32 %A, 15 ; 0x0f
  %tst1 = icmp ne i32 %mask1, 3 ; 0x03
  %mask2 = and i32 %A, 255 ; 0xff
  %tst2 = icmp ne i32 %mask2, 243 ; 0xf3
  %res = and i1 %tst1, %tst2
  ret i1 %res
}

define i1 @masked_icmps_bmask_notmixed_and_contradict_notoptimized(i32 %A) {
; CHECK-LABEL: @masked_icmps_bmask_notmixed_and_contradict_notoptimized(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 15
; CHECK-NEXT:    [[TST1:%.*]] = icmp ne i32 [[MASK1]], 3
; CHECK-NEXT:    [[MASK2:%.*]] = and i32 [[A]], 255
; CHECK-NEXT:    [[TST2:%.*]] = icmp ne i32 [[MASK2]], 242
; CHECK-NEXT:    [[RES:%.*]] = and i1 [[TST1]], [[TST2]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %mask1 = and i32 %A, 15 ; 0x0f
  %tst1 = icmp ne i32 %mask1, 3 ; 0x03
  %mask2 = and i32 %A, 255 ; 0xff
  %tst2 = icmp ne i32 %mask2, 242 ; 0xf2
  %res = and i1 %tst1, %tst2
  ret i1 %res
}

define i1 @masked_icmps_bmask_notmixed_and_expected_false(i32 %A) {
; CHECK-LABEL: @masked_icmps_bmask_notmixed_and_expected_false(
; CHECK-NEXT:    [[MASK2:%.*]] = and i32 [[A:%.*]], 255
; CHECK-NEXT:    [[TST2:%.*]] = icmp ne i32 [[MASK2]], 242
; CHECK-NEXT:    ret i1 [[TST2]]
;
  %mask1 = and i32 %A, 3 ; 0x0f
  %tst1 = icmp ne i32 %mask1, 15 ; 0x03
  %mask2 = and i32 %A, 255 ; 0xff
  %tst2 = icmp ne i32 %mask2, 242 ; 0xf2
  %res = and i1 %tst1, %tst2
  ret i1 %res
}

define i1 @masked_icmps_bmask_notmixed_not_subset_notoptimized(i32 %A) {
; CHECK-LABEL: @masked_icmps_bmask_notmixed_not_subset_notoptimized(
; CHECK-NEXT:    [[MASK1:%.*]] = and i32 [[A:%.*]], 254
; CHECK-NEXT:    [[TST1:%.*]] = icmp ne i32 [[MASK1]], 252
; CHECK-NEXT:    [[MASK2:%.*]] = and i32 [[A]], 253
; CHECK-NEXT:    [[TST2:%.*]] = icmp ne i32 [[MASK2]], 252
; CHECK-NEXT:    [[RES:%.*]] = and i1 [[TST1]], [[TST2]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %mask1 = and i32 %A, 254 ; 0xfe
  %tst1 = icmp ne i32 %mask1, 252 ; 0xfc
  %mask2 = and i32 %A, 253 ; 0xfd
  %tst2 = icmp ne i32 %mask2, 252 ; 0xfc
  %res = and i1 %tst1, %tst2
  ret i1 %res
}
