; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve < %s | FileCheck %s

; Check that DAGCombiner is not asserting with mis-matched vector element count, "Vector element counts must match in SIGN_EXTEND_INREG".
; Also no warning message of "warning: Possible incorrect use of EVT::getVectorNumElements() for scalable vector.".

define <vscale x 4 x i32> @sext_inreg(<vscale x 4 x i32> %a) {
; CHECK-LABEL: sext_inreg:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sxth z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %in = insertelement <vscale x 4 x i32> undef, i32 16, i32 0
  %splat = shufflevector <vscale x 4 x i32> %in, <vscale x 4 x i32> undef, <vscale x 4 x i32> zeroinitializer
  %sext = shl <vscale x 4 x i32> %a, %splat
  %conv = ashr <vscale x 4 x i32> %sext, %splat
  ret <vscale x 4 x i32> %conv
}

define <vscale x 4 x i32> @ashr_shl(<vscale x 4 x i32> %a)  {
; CHECK-LABEL: ashr_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #8
; CHECK-NEXT:    asr z0.s, z0.s, #16
; CHECK-NEXT:    ret
  %in1 = insertelement <vscale x 4 x i32> undef, i32 8, i32 0
  %splat1 = shufflevector <vscale x 4 x i32> %in1, <vscale x 4 x i32> undef, <vscale x 4 x i32> zeroinitializer
  %in2 = insertelement <vscale x 4 x i32> undef, i32 16, i32 0
  %splat2 = shufflevector <vscale x 4 x i32> %in2, <vscale x 4 x i32> undef, <vscale x 4 x i32> zeroinitializer
  %shl = shl <vscale x 4 x i32> %a, %splat1
  %r = ashr <vscale x 4 x i32> %shl, %splat2
  ret <vscale x 4 x i32> %r
}

define <vscale x 4 x i32> @ashr_shl_illegal_trunc_vec_ty(<vscale x 4 x i32> %a)  {
; CHECK-LABEL: ashr_shl_illegal_trunc_vec_ty:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #8
; CHECK-NEXT:    asr z0.s, z0.s, #11
; CHECK-NEXT:    ret
  %in1 = insertelement <vscale x 4 x i32> undef, i32 8, i32 0
  %splat1 = shufflevector <vscale x 4 x i32> %in1, <vscale x 4 x i32> undef, <vscale x 4 x i32> zeroinitializer
  %in2 = insertelement <vscale x 4 x i32> undef, i32 11, i32 0
  %splat2 = shufflevector <vscale x 4 x i32> %in2, <vscale x 4 x i32> undef, <vscale x 4 x i32> zeroinitializer
  %shl = shl <vscale x 4 x i32> %a, %splat1
  %r = ashr <vscale x 4 x i32> %shl, %splat2
  ret <vscale x 4 x i32> %r
}

define <vscale x 4 x i32> @ashr_add_shl_nxv4i8(<vscale x 4 x i32> %a) {
; CHECK-LABEL: ashr_add_shl_nxv4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z1.s, #0x1000000
; CHECK-NEXT:    lsl z0.s, z0.s, #24
; CHECK-NEXT:    add z0.s, z0.s, z1.s
; CHECK-NEXT:    asr z0.s, z0.s, #24
; CHECK-NEXT:    ret
  %in1 = insertelement <vscale x 4 x i32> undef, i32 24, i32 0
  %splat1 = shufflevector <vscale x 4 x i32> %in1, <vscale x 4 x i32> undef, <vscale x 4 x i32> zeroinitializer
  %in2 = insertelement <vscale x 4 x i32> undef, i32 16777216, i32 0
  %splat2 = shufflevector <vscale x 4 x i32> %in2, <vscale x 4 x i32> undef, <vscale x 4 x i32> zeroinitializer
  %conv = shl <vscale x 4 x i32> %a, %splat1
  %sext = add <vscale x 4 x i32> %conv, %splat2
  %conv1 = ashr <vscale x 4 x i32> %sext, %splat1
  ret <vscale x 4 x i32> %conv1
}
