#include <assert.h>
#include <errno.h>
#include <config.h>
#include <string.h>
#if !HAVE_THREADSAFE_STRERROR
#ifdef MULTITHREAD
#include "./Rthreads.h"
#endif

#ifdef XMUTEX_INITIALIZER
static xmutex_rec errlock = XMUTEX_INITIALIZER;
#endif
#endif


/*
   The strerror_r() function shall map the error number in errnum
   to a locale-dependent error message string and shall return
   the string in the buffer pointed to by strerrbuf, with length buflen.
*/
int strerror_r(int errnum, char *strerrbuf, size_t buflen)
{
    char* errPtr;
    int retVal = 0;
#if !HAVE_THREADSAFE_STRERROR
#ifdef XMUTEX_INITIALIZER
    xmutex_lock(&errlock);
#endif
#endif
    errPtr = strerror(errnum);
    /*
     The getenv() function searches the environment list for a string
     of the form "name=value", and returns a pointer to a string
     containing the value for the specified name. If the specified
     name cannot be found, a null pointer is returned.
    */
    if (errPtr == NULL)
    {
        retVal = EINVAL;
    }
    else
    {
        /* Copy errPtr into caller provided buffer */
        if (strlen(errPtr) > buflen - 1)
        {
            /*
             Insufficient storage was supplied via strerrbuf and buflen to 
             contain the value for the specified name.
            */ 
            retVal = ERANGE;
        }
        else
        {
            strcpy(strerrbuf, errPtr);
        }
    }
#if !HAVE_THREADSAFE_STRERROR
#ifdef XMUTEX_INITIALIZER
    xmutex_unlock(&errlock);
#endif
#endif
    return (retVal);
}
