#ifndef _RTHREADS_H
#define _RTHREADS_H

#if HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef MULTITHREAD
#if HAVE_PTHREAD_H
#include <pthread.h>
typedef pthread_mutex_t xmutex_rec;
#define XMUTEX_INITIALIZER PTHREAD_MUTEX_INITIALIZER
#define xmutex_lock(m) pthread_mutex_lock(m)
#define xmutex_unlock(m) pthread_mutex_unlock(m)
#endif
#else
#if HAVE_PTH_H
#include <pth.h>
typedef pth_mutex_t xmutex_rec;
#define XMUTEX_INITIALIZER PTH_MUTEX_INIT
#define xmutex_lock(m) pth_mutex_acquire(m, FALSE, NULL)
#define xmutex_unlock(m) pth_mutex_release(m)
#endif
#endif

#endif
