#include "cpudefs.h"
#include "cpuextra.h"
#include "inlines.h"
#include "cputbl.h"
#define CPUFUNC(x) x##_ff
#ifdef NOFLAGS
#include "noflags.h"
#endif

const int areg_byteinc[] = { 1, 1, 1, 1, 1, 1, 1, 2 };
const int imm8_table[]   = { 8, 1, 2, 3, 4, 5, 6, 7 };

const int movem_index1[256] = {
0x08, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x05, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x06, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x05, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x07, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x05, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x06, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x05, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 
};

const int movem_index2[256] = {
0xFFFFFFFF, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x03, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x02, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x03, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x01, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x03, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x02, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x03, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x00, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x03, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x02, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x03, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x01, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x03, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x02, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
0x03, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 0x04, 0x07, 0x06, 0x07, 0x05, 0x07, 0x06, 0x07, 
};

const int movem_next[256] = {
0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x04, 0x06, 0x00, 0x08, 0x08, 0x0A, 0x08, 0x0C, 0x0C, 0x0E, 
0x00, 0x10, 0x10, 0x12, 0x10, 0x14, 0x14, 0x16, 0x10, 0x18, 0x18, 0x1A, 0x18, 0x1C, 0x1C, 0x1E, 
0x00, 0x20, 0x20, 0x22, 0x20, 0x24, 0x24, 0x26, 0x20, 0x28, 0x28, 0x2A, 0x28, 0x2C, 0x2C, 0x2E, 
0x20, 0x30, 0x30, 0x32, 0x30, 0x34, 0x34, 0x36, 0x30, 0x38, 0x38, 0x3A, 0x38, 0x3C, 0x3C, 0x3E, 
0x00, 0x40, 0x40, 0x42, 0x40, 0x44, 0x44, 0x46, 0x40, 0x48, 0x48, 0x4A, 0x48, 0x4C, 0x4C, 0x4E, 
0x40, 0x50, 0x50, 0x52, 0x50, 0x54, 0x54, 0x56, 0x50, 0x58, 0x58, 0x5A, 0x58, 0x5C, 0x5C, 0x5E, 
0x40, 0x60, 0x60, 0x62, 0x60, 0x64, 0x64, 0x66, 0x60, 0x68, 0x68, 0x6A, 0x68, 0x6C, 0x6C, 0x6E, 
0x60, 0x70, 0x70, 0x72, 0x70, 0x74, 0x74, 0x76, 0x70, 0x78, 0x78, 0x7A, 0x78, 0x7C, 0x7C, 0x7E, 
0x00, 0x80, 0x80, 0x82, 0x80, 0x84, 0x84, 0x86, 0x80, 0x88, 0x88, 0x8A, 0x88, 0x8C, 0x8C, 0x8E, 
0x80, 0x90, 0x90, 0x92, 0x90, 0x94, 0x94, 0x96, 0x90, 0x98, 0x98, 0x9A, 0x98, 0x9C, 0x9C, 0x9E, 
0x80, 0xA0, 0xA0, 0xA2, 0xA0, 0xA4, 0xA4, 0xA6, 0xA0, 0xA8, 0xA8, 0xAA, 0xA8, 0xAC, 0xAC, 0xAE, 
0xA0, 0xB0, 0xB0, 0xB2, 0xB0, 0xB4, 0xB4, 0xB6, 0xB0, 0xB8, 0xB8, 0xBA, 0xB8, 0xBC, 0xBC, 0xBE, 
0x80, 0xC0, 0xC0, 0xC2, 0xC0, 0xC4, 0xC4, 0xC6, 0xC0, 0xC8, 0xC8, 0xCA, 0xC8, 0xCC, 0xCC, 0xCE, 
0xC0, 0xD0, 0xD0, 0xD2, 0xD0, 0xD4, 0xD4, 0xD6, 0xD0, 0xD8, 0xD8, 0xDA, 0xD8, 0xDC, 0xDC, 0xDE, 
0xC0, 0xE0, 0xE0, 0xE2, 0xE0, 0xE4, 0xE4, 0xE6, 0xE0, 0xE8, 0xE8, 0xEA, 0xE8, 0xEC, 0xEC, 0xEE, 
0xE0, 0xF0, 0xF0, 0xF2, 0xF0, 0xF4, 0xF4, 0xF6, 0xF0, 0xF8, 0xF8, 0xFA, 0xF8, 0xFC, 0xFC, 0xFE, 
};


#if !defined(PART_1) && !defined(PART_2) && !defined(PART_3) && !defined(PART_4) && !defined(PART_5) && !defined(PART_6) && !defined(PART_7) && !defined(PART_8)
#define PART_1 1
#define PART_2 1
#define PART_3 1
#define PART_4 1
#define PART_5 1
#define PART_6 1
#define PART_7 1
#define PART_8 1
#endif

#ifdef PART_1
unsigned long CPUFUNC(op_0_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_10_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_18_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_20_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_28_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_30_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 22; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_38_4)(uint32_t opcode) /* OR */
{
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_39_4)(uint32_t opcode) /* OR */
{
	OpcodeFamily = 1; CurrentInstrCycles = 24; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_ilong(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_3c_4)(uint32_t opcode) /* ORSR */
{
	OpcodeFamily = 4; CurrentInstrCycles = 20; 
{	MakeSR();
{	int16_t src = get_iword(2);
	src &= 0xFF;
	regs.sr |= src;
	MakeFromSR();
}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_40_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_50_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_58_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_60_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_68_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_70_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_78_4)(uint32_t opcode) /* OR */
{
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_79_4)(uint32_t opcode) /* OR */
{
	OpcodeFamily = 1; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_ilong(4);
{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_7c_4)(uint32_t opcode) /* ORSR */
{
	OpcodeFamily = 4; CurrentInstrCycles = 20; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel18; }
{	MakeSR();
{	int16_t src = get_iword(2);
	regs.sr |= src;
	MakeFromSR();
}}}m68k_incpc(4);
endlabel18: ;
return 20;
}
unsigned long CPUFUNC(op_80_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_90_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_98_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_a0_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 30; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_a8_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_b0_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 34; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 34;
}
unsigned long CPUFUNC(op_b8_4)(uint32_t opcode) /* OR */
{
	OpcodeFamily = 1; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_b9_4)(uint32_t opcode) /* OR */
{
	OpcodeFamily = 1; CurrentInstrCycles = 36; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_ilong(6);
{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(10);
return 36;
}
unsigned long CPUFUNC(op_100_4)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 6;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_108_4)(uint32_t opcode) /* MVPMR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 29; CurrentInstrCycles = 16; 
{	uint32_t memp = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	uint16_t val = (m68k_read_memory_8(memp) << 8) + m68k_read_memory_8(memp + 2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_110_4)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_118_4)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_120_4)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 10; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_128_4)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_130_4)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_138_4)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 21; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_139_4)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 21; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_13a_4)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 2;
	OpcodeFamily = 21; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_getpc () + 2;
	dsta += (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_13b_4)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 3;
	OpcodeFamily = 21; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_13c_4)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 21; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	int8_t dst = get_ibyte(2);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_140_4)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_148_4)(uint32_t opcode) /* MVPMR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 29; CurrentInstrCycles = 24; 
{	uint32_t memp = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	uint32_t val = (m68k_read_memory_8(memp) << 24) + (m68k_read_memory_8(memp + 2) << 16)
              + (m68k_read_memory_8(memp + 4) << 8) + m68k_read_memory_8(memp + 6);
	m68k_dreg(regs, dstreg) = (val);
}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_150_4)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_158_4)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_160_4)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_168_4)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_170_4)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_178_4)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 22; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_179_4)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 22; CurrentInstrCycles = 20; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_17a_4)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 2;
	OpcodeFamily = 22; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_getpc () + 2;
	dsta += (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_17b_4)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 3;
	OpcodeFamily = 22; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_180_4)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 10; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	if ( src < 16 ) { m68k_incpc(2); return 8; }
}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_188_4)(uint32_t opcode) /* MVPRM */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 28; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
	uint32_t memp = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	m68k_write_memory_8(memp, src >> 8); m68k_write_memory_8(memp + 2, src);
}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_190_4)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_198_4)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_1a0_4)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_1a8_4)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_1b0_4)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_1b8_4)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 23; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_1b9_4)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 23; CurrentInstrCycles = 20; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_1ba_4)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 2;
	OpcodeFamily = 23; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_getpc () + 2;
	dsta += (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_1bb_4)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 3;
	OpcodeFamily = 23; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_1c0_4)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_1c8_4)(uint32_t opcode) /* MVPRM */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 28; CurrentInstrCycles = 24; 
{{	int32_t src = m68k_dreg(regs, srcreg);
	uint32_t memp = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	m68k_write_memory_8(memp, src >> 24); m68k_write_memory_8(memp + 2, src >> 16);
	m68k_write_memory_8(memp + 4, src >> 8); m68k_write_memory_8(memp + 6, src);
}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_1d0_4)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_1d8_4)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_1e0_4)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_1e8_4)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_1f0_4)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_1f8_4)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 24; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_1f9_4)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 24; CurrentInstrCycles = 20; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_1fa_4)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 2;
	OpcodeFamily = 24; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_getpc () + 2;
	dsta += (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_1fb_4)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 3;
	OpcodeFamily = 24; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_200_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_210_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_218_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_220_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_228_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_230_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 22; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_238_4)(uint32_t opcode) /* AND */
{
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_239_4)(uint32_t opcode) /* AND */
{
	OpcodeFamily = 2; CurrentInstrCycles = 24; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_ilong(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_23c_4)(uint32_t opcode) /* ANDSR */
{
	OpcodeFamily = 5; CurrentInstrCycles = 20; 
{	MakeSR();
{	int16_t src = get_iword(2);
	src |= 0xFF00;
	regs.sr &= src;
	MakeFromSR();
}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_240_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_250_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_258_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_260_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_268_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_270_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_278_4)(uint32_t opcode) /* AND */
{
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_279_4)(uint32_t opcode) /* AND */
{
	OpcodeFamily = 2; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_ilong(4);
{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_27c_4)(uint32_t opcode) /* ANDSR */
{
	OpcodeFamily = 5; CurrentInstrCycles = 20; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel89; }
{	MakeSR();
{	int16_t src = get_iword(2);
	regs.sr &= src;
	MakeFromSR();
}}}m68k_incpc(4);
endlabel89: ;
return 20;
}
unsigned long CPUFUNC(op_280_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_290_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_298_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_2a0_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 30; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_2a8_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_2b0_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 34; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 34;
}
unsigned long CPUFUNC(op_2b8_4)(uint32_t opcode) /* AND */
{
	OpcodeFamily = 2; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_2b9_4)(uint32_t opcode) /* AND */
{
	OpcodeFamily = 2; CurrentInstrCycles = 36; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_ilong(6);
{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(10);
return 36;
}
unsigned long CPUFUNC(op_400_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_410_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_418_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_420_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_428_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_430_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 22; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_438_4)(uint32_t opcode) /* SUB */
{
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_439_4)(uint32_t opcode) /* SUB */
{
	OpcodeFamily = 7; CurrentInstrCycles = 24; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_ilong(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_440_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_450_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_458_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_460_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_468_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_470_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_478_4)(uint32_t opcode) /* SUB */
{
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_479_4)(uint32_t opcode) /* SUB */
{
	OpcodeFamily = 7; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_ilong(4);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_480_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_490_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_498_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_4a0_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 30; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_4a8_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_4b0_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 34; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(8);
return 34;
}
unsigned long CPUFUNC(op_4b8_4)(uint32_t opcode) /* SUB */
{
	OpcodeFamily = 7; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_4b9_4)(uint32_t opcode) /* SUB */
{
	OpcodeFamily = 7; CurrentInstrCycles = 36; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_ilong(6);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(10);
return 36;
}
unsigned long CPUFUNC(op_600_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_610_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_618_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_620_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_628_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_630_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 22; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_638_4)(uint32_t opcode) /* ADD */
{
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_639_4)(uint32_t opcode) /* ADD */
{
	OpcodeFamily = 11; CurrentInstrCycles = 24; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_ilong(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_640_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_650_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_658_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_660_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_668_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_670_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_678_4)(uint32_t opcode) /* ADD */
{
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_679_4)(uint32_t opcode) /* ADD */
{
	OpcodeFamily = 11; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_ilong(4);
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_680_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_690_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_698_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_6a0_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 30; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_6a8_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_6b0_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 34; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(8);
return 34;
}
unsigned long CPUFUNC(op_6b8_4)(uint32_t opcode) /* ADD */
{
	OpcodeFamily = 11; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_6b9_4)(uint32_t opcode) /* ADD */
{
	OpcodeFamily = 11; CurrentInstrCycles = 36; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_ilong(6);
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(10);
return 36;
}
unsigned long CPUFUNC(op_800_4)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 10; 
{{	int16_t src = get_iword(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}m68k_incpc(4);
return 10;
}
unsigned long CPUFUNC(op_810_4)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_818_4)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_820_4)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 14; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_828_4)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_830_4)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
return 18;
}
unsigned long CPUFUNC(op_838_4)(uint32_t opcode) /* BTST */
{
	OpcodeFamily = 21; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_839_4)(uint32_t opcode) /* BTST */
{
	OpcodeFamily = 21; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_ilong(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(8);
return 20;
}
unsigned long CPUFUNC(op_83a_4)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 21; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_getpc () + 4;
	dsta += (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_83b_4)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 21; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
return 18;
}
unsigned long CPUFUNC(op_83c_4)(uint32_t opcode) /* BTST */
{
	OpcodeFamily = 21; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
{	int8_t dst = get_ibyte(4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}m68k_incpc(6);
return 12;
}
unsigned long CPUFUNC(op_840_4)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_850_4)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_858_4)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_860_4)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_868_4)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_870_4)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_878_4)(uint32_t opcode) /* BCHG */
{
	OpcodeFamily = 22; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_879_4)(uint32_t opcode) /* BCHG */
{
	OpcodeFamily = 22; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_ilong(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_87a_4)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 22; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_getpc () + 4;
	dsta += (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_87b_4)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 22; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword(2);
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_880_4)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 14; 
{{	int16_t src = get_iword(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	if ( src < 16 ) { m68k_incpc(4); return 12; }
}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_890_4)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_898_4)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_8a0_4)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_8a8_4)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_8b0_4)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_8b8_4)(uint32_t opcode) /* BCLR */
{
	OpcodeFamily = 23; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_8b9_4)(uint32_t opcode) /* BCLR */
{
	OpcodeFamily = 23; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_ilong(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_8ba_4)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 23; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_getpc () + 4;
	dsta += (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_8bb_4)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 23; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword(2);
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_8c0_4)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_8d0_4)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_8d8_4)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_8e0_4)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_8e8_4)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_8f0_4)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_8f8_4)(uint32_t opcode) /* BSET */
{
	OpcodeFamily = 24; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_8f9_4)(uint32_t opcode) /* BSET */
{
	OpcodeFamily = 24; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_ilong(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_8fa_4)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 24; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_getpc () + 4;
	dsta += (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_8fb_4)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 24; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword(2);
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_write_memory_8(dsta,dst);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_a00_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_a10_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_a18_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_a20_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_a28_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_a30_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 22; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_a38_4)(uint32_t opcode) /* EOR */
{
	OpcodeFamily = 3; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_a39_4)(uint32_t opcode) /* EOR */
{
	OpcodeFamily = 3; CurrentInstrCycles = 24; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_ilong(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_a3c_4)(uint32_t opcode) /* EORSR */
{
	OpcodeFamily = 6; CurrentInstrCycles = 20; 
{	MakeSR();
{	int16_t src = get_iword(2);
	src &= 0xFF;
	regs.sr ^= src;
	MakeFromSR();
}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_a40_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_a50_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_a58_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_a60_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_a68_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_a70_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_a78_4)(uint32_t opcode) /* EOR */
{
	OpcodeFamily = 3; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_a79_4)(uint32_t opcode) /* EOR */
{
	OpcodeFamily = 3; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_ilong(4);
{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_a7c_4)(uint32_t opcode) /* EORSR */
{
	OpcodeFamily = 6; CurrentInstrCycles = 20; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel204; }
{	MakeSR();
{	int16_t src = get_iword(2);
	regs.sr ^= src;
	MakeFromSR();
}}}m68k_incpc(4);
endlabel204: ;
return 20;
}
#endif

#ifdef PART_2
unsigned long CPUFUNC(op_a80_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_a90_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_a98_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_aa0_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 30; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_aa8_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_ab0_4)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 34; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 34;
}
unsigned long CPUFUNC(op_ab8_4)(uint32_t opcode) /* EOR */
{
	OpcodeFamily = 3; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_ab9_4)(uint32_t opcode) /* EOR */
{
	OpcodeFamily = 3; CurrentInstrCycles = 36; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_ilong(6);
{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(10);
return 36;
}
unsigned long CPUFUNC(op_c00_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_c10_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_c18_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_c20_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_c28_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_c30_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 18;
}
unsigned long CPUFUNC(op_c38_4)(uint32_t opcode) /* CMP */
{
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_c39_4)(uint32_t opcode) /* CMP */
{
	OpcodeFamily = 25; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_ilong(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 20;
}
unsigned long CPUFUNC(op_c3a_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_getpc () + 4;
	dsta += (int32_t)(int16_t)get_iword(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_c3b_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 25; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte(2);
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 18;
}
unsigned long CPUFUNC(op_c40_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_c50_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_c58_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_c60_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_c68_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_c70_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 18;
}
unsigned long CPUFUNC(op_c78_4)(uint32_t opcode) /* CMP */
{
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_c79_4)(uint32_t opcode) /* CMP */
{
	OpcodeFamily = 25; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_ilong(4);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 20;
}
unsigned long CPUFUNC(op_c7a_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_getpc () + 4;
	dsta += (int32_t)(int16_t)get_iword(4);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_c7b_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 25; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword(4));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 18;
}
unsigned long CPUFUNC(op_c80_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(6);
return 14;
}
unsigned long CPUFUNC(op_c90_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 20; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_c98_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 20; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_ca0_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 22; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_ca8_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 24; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_cb0_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 26; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 26;
}
unsigned long CPUFUNC(op_cb8_4)(uint32_t opcode) /* CMP */
{
	OpcodeFamily = 25; CurrentInstrCycles = 24; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_cb9_4)(uint32_t opcode) /* CMP */
{
	OpcodeFamily = 25; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_ilong(6);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(10);
return 28;
}
unsigned long CPUFUNC(op_cba_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 25; CurrentInstrCycles = 24; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_getpc () + 6;
	dsta += (int32_t)(int16_t)get_iword(6);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_cbb_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 25; CurrentInstrCycles = 26; 
{{	int32_t src = get_ilong(2);
{	uint32_t tmppc = m68k_getpc() + 6;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword(6));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 26;
}
unsigned long CPUFUNC(op_1000_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_1008_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_areg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_1010_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_1018_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_1020_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_1028_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_1030_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_1038_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_1039_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_103a_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_103b_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_103c_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_1080_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_1088_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_1090_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_1098_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_10a0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_10a8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_10b0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_10b8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_10b9_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_10ba_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_10bb_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_10bc_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_10c0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_10c8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_10d0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_10d8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_10e0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_10e8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_10f0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_10f8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_10f9_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_10fa_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_10fb_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_10fc_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_1100_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_1108_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_1110_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_1118_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_1120_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_1128_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_1130_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_1138_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_1139_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_113a_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_113b_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_113c_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_1140_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_1148_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_1150_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_1158_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_1160_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_1168_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_1170_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_1178_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_1179_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_117a_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_117b_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_117c_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_1180_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_1188_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_1190_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_1198_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_11a0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_11a8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_11b0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 24;
}
unsigned long CPUFUNC(op_11b8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_11b9_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(8);
return 26;
}
unsigned long CPUFUNC(op_11ba_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_11bb_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 24;
}
unsigned long CPUFUNC(op_11bc_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(6);
return 18;
}
unsigned long CPUFUNC(op_11c0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_11c8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_11d0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_11d8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_11e0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_11e8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_11f0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_11f8_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_11f9_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_11fa_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_11fb_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_11fc_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_13c0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_13c8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_13d0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_13d8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_13e0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_13e8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_13f0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(8);
return 26;
}
unsigned long CPUFUNC(op_13f8_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_13f9_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_ilong(6);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(10);
return 28;
}
unsigned long CPUFUNC(op_13fa_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_13fb_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(8);
return 26;
}
unsigned long CPUFUNC(op_13fc_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte(2);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}m68k_incpc(8);
return 20;
}
unsigned long CPUFUNC(op_2000_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 4;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_2008_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 4;  
{{	int32_t src = m68k_areg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_2010_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_2018_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_2020_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_2028_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_2030_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_2038_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_2039_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_203a_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_203b_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_203c_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int32_t src = get_ilong(2);
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
return 12;
}
unsigned long CPUFUNC(op_2040_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 4;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t val = src;
	m68k_areg(regs, dstreg) = (val);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_2048_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 4;  
{{	int32_t src = m68k_areg(regs, srcreg);
{	uint32_t val = src;
	m68k_areg(regs, dstreg) = (val);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_2050_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_2058_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	uint32_t val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_2060_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_2068_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_2070_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_2078_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_2079_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_207a_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_207b_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_207c_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 12; 
{{	int32_t src = get_ilong(2);
{	uint32_t val = src;
	m68k_areg(regs, dstreg) = (val);
}}}m68k_incpc(6);
return 12;
}
unsigned long CPUFUNC(op_2080_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_2088_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int32_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_2090_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_2098_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_20a0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_20a8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_20b0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_20b8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_20b9_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_20ba_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_20bb_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_20bc_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_20c0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_20c8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int32_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_20d0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_20d8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_20e0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_20e8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_20f0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_20f8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_20f9_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_20fa_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_20fb_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_20fc_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_2100_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_2108_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int32_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_2110_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_2118_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_2120_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_2128_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_2130_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_2138_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
#endif

#ifdef PART_3
unsigned long CPUFUNC(op_2139_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_213a_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_213b_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_213c_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_2140_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_2148_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int32_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_2150_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_2158_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_2160_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_2168_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_2170_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 30; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_2178_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_2179_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 32; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_217a_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_217b_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 30; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_217c_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_2180_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_2188_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	int32_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_2190_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_2198_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_21a0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 28;
}
unsigned long CPUFUNC(op_21a8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 30; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_21b0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 32; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 32;
}
unsigned long CPUFUNC(op_21b8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 30; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_21b9_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 34; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 34;
}
unsigned long CPUFUNC(op_21ba_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 30; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_21bb_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 32; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 32;
}
unsigned long CPUFUNC(op_21bc_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(8);
return 26;
}
unsigned long CPUFUNC(op_21c0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_21c8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int32_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_21d0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_21d8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_21e0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_21e8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_21f0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 30; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_21f8_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_21f9_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 32; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_21fa_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_21fb_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 30; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_21fc_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_23c0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_23c8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	int32_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_23d0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_23d8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_23e0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 30; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 30;
}
unsigned long CPUFUNC(op_23e8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 32; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_23f0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 34; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 34;
}
unsigned long CPUFUNC(op_23f8_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 32; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_23f9_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 36; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_ilong(6);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(10);
return 36;
}
unsigned long CPUFUNC(op_23fa_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 32; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 32;
}
unsigned long CPUFUNC(op_23fb_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 34; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(8);
return 34;
}
unsigned long CPUFUNC(op_23fc_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong(2);
{	uint32_t dsta = get_ilong(6);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}m68k_incpc(10);
return 28;
}
unsigned long CPUFUNC(op_3000_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_3008_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_areg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_3010_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_3018_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_3020_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_3028_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_3030_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_3038_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_3039_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_303a_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_303b_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_303c_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_3040_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t val = (int32_t)(int16_t)src;
	m68k_areg(regs, dstreg) = (val);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_3048_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_areg(regs, srcreg);
{	uint32_t val = (int32_t)(int16_t)src;
	m68k_areg(regs, dstreg) = (val);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_3050_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t val = (int32_t)(int16_t)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_3058_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t val = (int32_t)(int16_t)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_3060_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t val = (int32_t)(int16_t)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_3068_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t val = (int32_t)(int16_t)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_3070_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t val = (int32_t)(int16_t)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_3078_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t val = (int32_t)(int16_t)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_3079_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t val = (int32_t)(int16_t)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_307a_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t val = (int32_t)(int16_t)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_307b_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t val = (int32_t)(int16_t)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_307c_4)(uint32_t opcode) /* MOVEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 31; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	uint32_t val = (int32_t)(int16_t)src;
	m68k_areg(regs, dstreg) = (val);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_3080_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_3088_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int16_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_3090_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_3098_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_30a0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_30a8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_30b0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_30b8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_30b9_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_30ba_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_30bb_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_30bc_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_30c0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_30c8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int16_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_30d0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_30d8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_30e0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_30e8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_30f0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_30f8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_30f9_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_30fa_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_30fb_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_30fc_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_3100_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_3108_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int16_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_3110_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_3118_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_3120_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_3128_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_3130_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_3138_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_3139_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_313a_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_313b_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_313c_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_3140_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_3148_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_3150_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_3158_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_3160_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_3168_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_3170_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_3178_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_3179_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_317a_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_317b_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_317c_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_3180_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_3188_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	int16_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_3190_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_3198_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_31a0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_31a8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_31b0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 24;
}
unsigned long CPUFUNC(op_31b8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_31b9_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(8);
return 26;
}
unsigned long CPUFUNC(op_31ba_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_31bb_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 24;
}
unsigned long CPUFUNC(op_31bc_4)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(6);
return 18;
}
unsigned long CPUFUNC(op_31c0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_31c8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_31d0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_31d8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_31e0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_31e8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_31f0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_31f8_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_31f9_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_31fa_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_31fb_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_31fc_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_33c0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_33c8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_33d0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_33d8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_33e0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_33e8_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_33f0_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(8);
return 26;
}
unsigned long CPUFUNC(op_33f8_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_33f9_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 28; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_ilong(6);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(10);
return 28;
}
unsigned long CPUFUNC(op_33fa_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(8);
return 24;
}
unsigned long CPUFUNC(op_33fb_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(8);
return 26;
}
unsigned long CPUFUNC(op_33fc_4)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword(2);
{	uint32_t dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}m68k_incpc(8);
return 20;
}
unsigned long CPUFUNC(op_4000_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4010_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4018_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4020_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_4028_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4030_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4038_4)(uint32_t opcode) /* NEGX */
{
	OpcodeFamily = 16; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4039_4)(uint32_t opcode) /* NEGX */
{
	OpcodeFamily = 16; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_4040_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int16_t)(newv)) == 0));
	SET_NFLG (((int16_t)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4050_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int16_t)(newv)) == 0));
	SET_NFLG (((int16_t)(newv)) < 0);
	m68k_write_memory_16(srca,newv);
}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4058_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int16_t)(newv)) == 0));
	SET_NFLG (((int16_t)(newv)) < 0);
	m68k_write_memory_16(srca,newv);
}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4060_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int16_t)(newv)) == 0));
	SET_NFLG (((int16_t)(newv)) < 0);
	m68k_write_memory_16(srca,newv);
}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_4068_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int16_t)(newv)) == 0));
	SET_NFLG (((int16_t)(newv)) < 0);
	m68k_write_memory_16(srca,newv);
}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4070_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int16_t)(newv)) == 0));
	SET_NFLG (((int16_t)(newv)) < 0);
	m68k_write_memory_16(srca,newv);
}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4078_4)(uint32_t opcode) /* NEGX */
{
	OpcodeFamily = 16; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int16_t)(newv)) == 0));
	SET_NFLG (((int16_t)(newv)) < 0);
	m68k_write_memory_16(srca,newv);
}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4079_4)(uint32_t opcode) /* NEGX */
{
	OpcodeFamily = 16; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int16_t)(newv)) == 0));
	SET_NFLG (((int16_t)(newv)) < 0);
	m68k_write_memory_16(srca,newv);
}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_4080_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 6;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int32_t)(newv)) == 0));
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (newv);
}}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_4090_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int32_t)(newv)) == 0));
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_write_memory_32(srca,newv);
}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_4098_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int32_t)(newv)) == 0));
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_write_memory_32(srca,newv);
}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_40a0_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int32_t)(newv)) == 0));
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_write_memory_32(srca,newv);
}}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_40a8_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int32_t)(newv)) == 0));
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_write_memory_32(srca,newv);
}}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_40b0_4)(uint32_t opcode) /* NEGX */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 16; CurrentInstrCycles = 26; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int32_t)(newv)) == 0));
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_write_memory_32(srca,newv);
}}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_40b8_4)(uint32_t opcode) /* NEGX */
{
	OpcodeFamily = 16; CurrentInstrCycles = 24; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int32_t)(newv)) == 0));
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_write_memory_32(srca,newv);
}}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_40b9_4)(uint32_t opcode) /* NEGX */
{
	OpcodeFamily = 16; CurrentInstrCycles = 28; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int32_t)(newv)) == 0));
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_write_memory_32(srca,newv);
}}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_40c0_4)(uint32_t opcode) /* MVSR2 */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 32; CurrentInstrCycles = 6;  
{{	MakeSR();
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr) & 0xffff);
}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_40d0_4)(uint32_t opcode) /* MVSR2 */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 32; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	MakeSR();
	m68k_write_memory_16(srca,regs.sr);
}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_40d8_4)(uint32_t opcode) /* MVSR2 */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 32; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	m68k_write_memory_16(srca,regs.sr);
}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_40e0_4)(uint32_t opcode) /* MVSR2 */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 32; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	MakeSR();
	m68k_write_memory_16(srca,regs.sr);
}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_40e8_4)(uint32_t opcode) /* MVSR2 */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 32; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
	MakeSR();
	m68k_write_memory_16(srca,regs.sr);
}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_40f0_4)(uint32_t opcode) /* MVSR2 */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 32; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
	MakeSR();
	m68k_write_memory_16(srca,regs.sr);
}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_40f8_4)(uint32_t opcode) /* MVSR2 */
{
	OpcodeFamily = 32; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
	MakeSR();
	m68k_write_memory_16(srca,regs.sr);
}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_40f9_4)(uint32_t opcode) /* MVSR2 */
{
	OpcodeFamily = 32; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
	MakeSR();
	m68k_write_memory_16(srca,regs.sr);
}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_4180_4)(uint32_t opcode) /* CHK */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 80; CurrentInstrCycles = 10; 
{	uint32_t oldpc = m68k_getpc();
{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	if ((int32_t)dst < 0) { SET_NFLG (1); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel587; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel587; }
}}}endlabel587: ;
return 10;
}
unsigned long CPUFUNC(op_4190_4)(uint32_t opcode) /* CHK */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 80; CurrentInstrCycles = 14; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	if ((int32_t)dst < 0) { SET_NFLG (1); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel588; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel588; }
}}}}endlabel588: ;
return 14;
}
unsigned long CPUFUNC(op_4198_4)(uint32_t opcode) /* CHK */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 80; CurrentInstrCycles = 14; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int16_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	if ((int32_t)dst < 0) { SET_NFLG (1); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel589; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel589; }
}}}}endlabel589: ;
return 14;
}
unsigned long CPUFUNC(op_41a0_4)(uint32_t opcode) /* CHK */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 80; CurrentInstrCycles = 16; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int16_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	if ((int32_t)dst < 0) { SET_NFLG (1); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel590; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel590; }
}}}}endlabel590: ;
return 16;
}
unsigned long CPUFUNC(op_41a8_4)(uint32_t opcode) /* CHK */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 80; CurrentInstrCycles = 18; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if ((int32_t)dst < 0) { SET_NFLG (1); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel591; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel591; }
}}}}endlabel591: ;
return 18;
}
unsigned long CPUFUNC(op_41b0_4)(uint32_t opcode) /* CHK */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 80; CurrentInstrCycles = 20; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if ((int32_t)dst < 0) { SET_NFLG (1); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel592; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel592; }
}}}}endlabel592: ;
return 20;
}
unsigned long CPUFUNC(op_41b8_4)(uint32_t opcode) /* CHK */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 80; CurrentInstrCycles = 18; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if ((int32_t)dst < 0) { SET_NFLG (1); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel593; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel593; }
}}}}endlabel593: ;
return 18;
}
unsigned long CPUFUNC(op_41b9_4)(uint32_t opcode) /* CHK */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 80; CurrentInstrCycles = 22; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(6);
	if ((int32_t)dst < 0) { SET_NFLG (1); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel594; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel594; }
}}}}endlabel594: ;
return 22;
}
unsigned long CPUFUNC(op_41ba_4)(uint32_t opcode) /* CHK */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 80; CurrentInstrCycles = 18; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if ((int32_t)dst < 0) { SET_NFLG (1); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel595; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel595; }
}}}}endlabel595: ;
return 18;
}
unsigned long CPUFUNC(op_41bb_4)(uint32_t opcode) /* CHK */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 80; CurrentInstrCycles = 20; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if ((int32_t)dst < 0) { SET_NFLG (1); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel596; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel596; }
}}}}endlabel596: ;
return 20;
}
unsigned long CPUFUNC(op_41bc_4)(uint32_t opcode) /* CHK */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 80; CurrentInstrCycles = 14; 
{	uint32_t oldpc = m68k_getpc();
{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if ((int32_t)dst < 0) { SET_NFLG (1); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel597; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc,M68000_EXC_SRC_CPU); goto endlabel597; }
}}}endlabel597: ;
return 14;
}
unsigned long CPUFUNC(op_41d0_4)(uint32_t opcode) /* LEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 56; CurrentInstrCycles = 4;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	m68k_areg(regs, dstreg) = (srca);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_41e8_4)(uint32_t opcode) /* LEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 56; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	m68k_areg(regs, dstreg) = (srca);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_41f0_4)(uint32_t opcode) /* LEA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 56; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	m68k_areg(regs, dstreg) = (srca);
}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_41f8_4)(uint32_t opcode) /* LEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 56; CurrentInstrCycles = 8;  
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	m68k_areg(regs, dstreg) = (srca);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_41f9_4)(uint32_t opcode) /* LEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 56; CurrentInstrCycles = 12; 
{{	uint32_t srca = get_ilong(2);
{	m68k_areg(regs, dstreg) = (srca);
}}}m68k_incpc(6);
return 12;
}
unsigned long CPUFUNC(op_41fa_4)(uint32_t opcode) /* LEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 56; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	m68k_areg(regs, dstreg) = (srca);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_41fb_4)(uint32_t opcode) /* LEA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 56; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	m68k_areg(regs, dstreg) = (srca);
}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_4200_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 4;  
{{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(0)) == 0);
	SET_NFLG (((int8_t)(0)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((0) & 0xff);
}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4210_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(0)) == 0);
	SET_NFLG (((int8_t)(0)) < 0);
	m68k_write_memory_8(srca,0);
}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4218_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 12; 
{{	int8_t src; uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(0)) == 0);
	SET_NFLG (((int8_t)(0)) < 0);
	m68k_write_memory_8(srca,0);
}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4220_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 14; 
{{	int8_t src; uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(0)) == 0);
	SET_NFLG (((int8_t)(0)) < 0);
	m68k_write_memory_8(srca,0);
}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_4228_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(0)) == 0);
	SET_NFLG (((int8_t)(0)) < 0);
	m68k_write_memory_8(srca,0);
}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4230_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 18; 
{{	int8_t src; uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
	src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(0)) == 0);
	SET_NFLG (((int8_t)(0)) < 0);
	m68k_write_memory_8(srca,0);
}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4238_4)(uint32_t opcode) /* CLR */
{
	OpcodeFamily = 18; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(0)) == 0);
	SET_NFLG (((int8_t)(0)) < 0);
	m68k_write_memory_8(srca,0);
}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4239_4)(uint32_t opcode) /* CLR */
{
	OpcodeFamily = 18; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(0)) == 0);
	SET_NFLG (((int8_t)(0)) < 0);
	m68k_write_memory_8(srca,0);
}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_4240_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 4;  
{{	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(0)) == 0);
	SET_NFLG (((int16_t)(0)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((0) & 0xffff);
}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4250_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	int16_t src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(0)) == 0);
	SET_NFLG (((int16_t)(0)) < 0);
	m68k_write_memory_16(srca,0);
}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4258_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 12; 
{{	int16_t src; uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(0)) == 0);
	SET_NFLG (((int16_t)(0)) < 0);
	m68k_write_memory_16(srca,0);
}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4260_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 14; 
{{	int16_t src; uint32_t srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(0)) == 0);
	SET_NFLG (((int16_t)(0)) < 0);
	m68k_write_memory_16(srca,0);
}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_4268_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
	int16_t src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(0)) == 0);
	SET_NFLG (((int16_t)(0)) < 0);
	m68k_write_memory_16(srca,0);
}}m68k_incpc(4);
return 16;
}
#endif

#ifdef PART_4
unsigned long CPUFUNC(op_4270_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 18; 
{{	int16_t src; uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
	src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(0)) == 0);
	SET_NFLG (((int16_t)(0)) < 0);
	m68k_write_memory_16(srca,0);
}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4278_4)(uint32_t opcode) /* CLR */
{
	OpcodeFamily = 18; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
	int16_t src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(0)) == 0);
	SET_NFLG (((int16_t)(0)) < 0);
	m68k_write_memory_16(srca,0);
}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4279_4)(uint32_t opcode) /* CLR */
{
	OpcodeFamily = 18; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
	int16_t src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(0)) == 0);
	SET_NFLG (((int16_t)(0)) < 0);
	m68k_write_memory_16(srca,0);
}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_4280_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 6;  
{{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(0)) == 0);
	SET_NFLG (((int32_t)(0)) < 0);
	m68k_dreg(regs, srcreg) = (0);
}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_4290_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	int32_t src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(0)) == 0);
	SET_NFLG (((int32_t)(0)) < 0);
	m68k_write_memory_32(srca,0);
}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_4298_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 20; 
{{	int32_t src; uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 4;
	src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(0)) == 0);
	SET_NFLG (((int32_t)(0)) < 0);
	m68k_write_memory_32(srca,0);
}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_42a0_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 22; 
{{	int32_t src; uint32_t srca = m68k_areg(regs, srcreg) - 4;
	m68k_areg (regs, srcreg) = srca;
	src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(0)) == 0);
	SET_NFLG (((int32_t)(0)) < 0);
	m68k_write_memory_32(srca,0);
}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_42a8_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
	int32_t src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(0)) == 0);
	SET_NFLG (((int32_t)(0)) < 0);
	m68k_write_memory_32(srca,0);
}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_42b0_4)(uint32_t opcode) /* CLR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 18; CurrentInstrCycles = 26; 
{{	int32_t src; uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
	src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(0)) == 0);
	SET_NFLG (((int32_t)(0)) < 0);
	m68k_write_memory_32(srca,0);
}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_42b8_4)(uint32_t opcode) /* CLR */
{
	OpcodeFamily = 18; CurrentInstrCycles = 24; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
	int32_t src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(0)) == 0);
	SET_NFLG (((int32_t)(0)) < 0);
	m68k_write_memory_32(srca,0);
}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_42b9_4)(uint32_t opcode) /* CLR */
{
	OpcodeFamily = 18; CurrentInstrCycles = 28; 
{{	uint32_t srca = get_ilong(2);
	int32_t src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(0)) == 0);
	SET_NFLG (((int32_t)(0)) < 0);
	m68k_write_memory_32(srca,0);
}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_4400_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{{uint32_t dst = ((int8_t)(0)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(dst)) < 0;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4410_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{{uint32_t dst = ((int8_t)(0)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(dst)) < 0;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(srca,dst);
}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4418_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{{uint32_t dst = ((int8_t)(0)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(dst)) < 0;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(srca,dst);
}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4420_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{{uint32_t dst = ((int8_t)(0)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(dst)) < 0;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(srca,dst);
}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_4428_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{{uint32_t dst = ((int8_t)(0)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(dst)) < 0;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(srca,dst);
}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4430_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{{uint32_t dst = ((int8_t)(0)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(dst)) < 0;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(srca,dst);
}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4438_4)(uint32_t opcode) /* NEG */
{
	OpcodeFamily = 15; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{{uint32_t dst = ((int8_t)(0)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(dst)) < 0;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(srca,dst);
}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4439_4)(uint32_t opcode) /* NEG */
{
	OpcodeFamily = 15; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{{uint32_t dst = ((int8_t)(0)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(0)) < 0;
	int flgn = ((int8_t)(dst)) < 0;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(srca,dst);
}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_4440_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{{uint32_t dst = ((int16_t)(0)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(dst)) < 0;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4450_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{{uint32_t dst = ((int16_t)(0)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(dst)) < 0;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(srca,dst);
}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4458_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{{uint32_t dst = ((int16_t)(0)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(dst)) < 0;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(srca,dst);
}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4460_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{{uint32_t dst = ((int16_t)(0)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(dst)) < 0;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(srca,dst);
}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_4468_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{{uint32_t dst = ((int16_t)(0)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(dst)) < 0;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(srca,dst);
}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4470_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{{uint32_t dst = ((int16_t)(0)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(dst)) < 0;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(srca,dst);
}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4478_4)(uint32_t opcode) /* NEG */
{
	OpcodeFamily = 15; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{{uint32_t dst = ((int16_t)(0)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(dst)) < 0;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(srca,dst);
}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4479_4)(uint32_t opcode) /* NEG */
{
	OpcodeFamily = 15; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{{uint32_t dst = ((int16_t)(0)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(0)) < 0;
	int flgn = ((int16_t)(dst)) < 0;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(srca,dst);
}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_4480_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 6;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{{uint32_t dst = ((int32_t)(0)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(dst)) < 0;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, srcreg) = (dst);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_4490_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{{uint32_t dst = ((int32_t)(0)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(dst)) < 0;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(srca,dst);
}}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_4498_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{{uint32_t dst = ((int32_t)(0)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(dst)) < 0;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(srca,dst);
}}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_44a0_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{{uint32_t dst = ((int32_t)(0)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(dst)) < 0;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(srca,dst);
}}}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_44a8_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{{uint32_t dst = ((int32_t)(0)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(dst)) < 0;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(srca,dst);
}}}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_44b0_4)(uint32_t opcode) /* NEG */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 15; CurrentInstrCycles = 26; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{{uint32_t dst = ((int32_t)(0)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(dst)) < 0;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(srca,dst);
}}}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_44b8_4)(uint32_t opcode) /* NEG */
{
	OpcodeFamily = 15; CurrentInstrCycles = 24; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{{uint32_t dst = ((int32_t)(0)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(dst)) < 0;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(srca,dst);
}}}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_44b9_4)(uint32_t opcode) /* NEG */
{
	OpcodeFamily = 15; CurrentInstrCycles = 28; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{{uint32_t dst = ((int32_t)(0)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(0)) < 0;
	int flgn = ((int32_t)(dst)) < 0;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(0)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(srca,dst);
}}}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_44c0_4)(uint32_t opcode) /* MV2SR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 33; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_44d0_4)(uint32_t opcode) /* MV2SR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 33; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(2);
return 16;
}
unsigned long CPUFUNC(op_44d8_4)(uint32_t opcode) /* MV2SR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 33; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(2);
return 16;
}
unsigned long CPUFUNC(op_44e0_4)(uint32_t opcode) /* MV2SR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 33; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(2);
return 18;
}
unsigned long CPUFUNC(op_44e8_4)(uint32_t opcode) /* MV2SR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 33; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_44f0_4)(uint32_t opcode) /* MV2SR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 33; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(4);
return 22;
}
unsigned long CPUFUNC(op_44f8_4)(uint32_t opcode) /* MV2SR */
{
	OpcodeFamily = 33; CurrentInstrCycles = 20; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_44f9_4)(uint32_t opcode) /* MV2SR */
{
	OpcodeFamily = 33; CurrentInstrCycles = 24; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(6);
return 24;
}
unsigned long CPUFUNC(op_44fa_4)(uint32_t opcode) /* MV2SR */
{
	OpcodeFamily = 33; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_44fb_4)(uint32_t opcode) /* MV2SR */
{
	OpcodeFamily = 33; CurrentInstrCycles = 22; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(4);
return 22;
}
unsigned long CPUFUNC(op_44fc_4)(uint32_t opcode) /* MV2SR */
{
	OpcodeFamily = 33; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword(2);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4600_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_NFLG (((int8_t)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4610_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_NFLG (((int8_t)(dst)) < 0);
	m68k_write_memory_8(srca,dst);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4618_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_NFLG (((int8_t)(dst)) < 0);
	m68k_write_memory_8(srca,dst);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4620_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_NFLG (((int8_t)(dst)) < 0);
	m68k_write_memory_8(srca,dst);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_4628_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_NFLG (((int8_t)(dst)) < 0);
	m68k_write_memory_8(srca,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4630_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 18; 
{{	int8_t src; uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	src = m68k_read_memory_8(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_NFLG (((int8_t)(dst)) < 0);
	m68k_write_memory_8(srca,dst);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4638_4)(uint32_t opcode) /* NOT */
{
	OpcodeFamily = 19; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_NFLG (((int8_t)(dst)) < 0);
	m68k_write_memory_8(srca,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4639_4)(uint32_t opcode) /* NOT */
{
	OpcodeFamily = 19; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(dst)) == 0);
	SET_NFLG (((int8_t)(dst)) < 0);
	m68k_write_memory_8(srca,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_4640_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_NFLG (((int16_t)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4650_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_NFLG (((int16_t)(dst)) < 0);
	m68k_write_memory_16(srca,dst);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4658_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_NFLG (((int16_t)(dst)) < 0);
	m68k_write_memory_16(srca,dst);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4660_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_NFLG (((int16_t)(dst)) < 0);
	m68k_write_memory_16(srca,dst);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_4668_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_NFLG (((int16_t)(dst)) < 0);
	m68k_write_memory_16(srca,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4670_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_NFLG (((int16_t)(dst)) < 0);
	m68k_write_memory_16(srca,dst);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4678_4)(uint32_t opcode) /* NOT */
{
	OpcodeFamily = 19; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_NFLG (((int16_t)(dst)) < 0);
	m68k_write_memory_16(srca,dst);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4679_4)(uint32_t opcode) /* NOT */
{
	OpcodeFamily = 19; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_NFLG (((int16_t)(dst)) < 0);
	m68k_write_memory_16(srca,dst);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_4680_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 6;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_NFLG (((int32_t)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (dst);
}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_4690_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_NFLG (((int32_t)(dst)) < 0);
	m68k_write_memory_32(srca,dst);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_4698_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_NFLG (((int32_t)(dst)) < 0);
	m68k_write_memory_32(srca,dst);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_46a0_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_NFLG (((int32_t)(dst)) < 0);
	m68k_write_memory_32(srca,dst);
}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_46a8_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_NFLG (((int32_t)(dst)) < 0);
	m68k_write_memory_32(srca,dst);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_46b0_4)(uint32_t opcode) /* NOT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 19; CurrentInstrCycles = 26; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_NFLG (((int32_t)(dst)) < 0);
	m68k_write_memory_32(srca,dst);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_46b8_4)(uint32_t opcode) /* NOT */
{
	OpcodeFamily = 19; CurrentInstrCycles = 24; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_NFLG (((int32_t)(dst)) < 0);
	m68k_write_memory_32(srca,dst);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_46b9_4)(uint32_t opcode) /* NOT */
{
	OpcodeFamily = 19; CurrentInstrCycles = 28; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	uint32_t dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_NFLG (((int32_t)(dst)) < 0);
	m68k_write_memory_32(srca,dst);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_46c0_4)(uint32_t opcode) /* MV2SR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 33; CurrentInstrCycles = 12; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel688; }
{{	int16_t src = m68k_dreg(regs, srcreg);
	regs.sr = src;
	MakeFromSR();
}}}m68k_incpc(2);
endlabel688: ;
return 12;
}
unsigned long CPUFUNC(op_46d0_4)(uint32_t opcode) /* MV2SR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 33; CurrentInstrCycles = 16; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel689; }
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(2);
endlabel689: ;
return 16;
}
unsigned long CPUFUNC(op_46d8_4)(uint32_t opcode) /* MV2SR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 33; CurrentInstrCycles = 16; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel690; }
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(2);
endlabel690: ;
return 16;
}
unsigned long CPUFUNC(op_46e0_4)(uint32_t opcode) /* MV2SR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 33; CurrentInstrCycles = 18; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel691; }
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(2);
endlabel691: ;
return 18;
}
unsigned long CPUFUNC(op_46e8_4)(uint32_t opcode) /* MV2SR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 33; CurrentInstrCycles = 20; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel692; }
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(4);
endlabel692: ;
return 20;
}
unsigned long CPUFUNC(op_46f0_4)(uint32_t opcode) /* MV2SR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 33; CurrentInstrCycles = 22; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel693; }
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(4);
endlabel693: ;
return 22;
}
unsigned long CPUFUNC(op_46f8_4)(uint32_t opcode) /* MV2SR */
{
	OpcodeFamily = 33; CurrentInstrCycles = 20; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel694; }
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(4);
endlabel694: ;
return 20;
}
unsigned long CPUFUNC(op_46f9_4)(uint32_t opcode) /* MV2SR */
{
	OpcodeFamily = 33; CurrentInstrCycles = 24; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel695; }
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(6);
endlabel695: ;
return 24;
}
unsigned long CPUFUNC(op_46fa_4)(uint32_t opcode) /* MV2SR */
{
	OpcodeFamily = 33; CurrentInstrCycles = 20; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel696; }
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(4);
endlabel696: ;
return 20;
}
unsigned long CPUFUNC(op_46fb_4)(uint32_t opcode) /* MV2SR */
{
	OpcodeFamily = 33; CurrentInstrCycles = 22; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel697; }
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(4);
endlabel697: ;
return 22;
}
unsigned long CPUFUNC(op_46fc_4)(uint32_t opcode) /* MV2SR */
{
	OpcodeFamily = 33; CurrentInstrCycles = 16; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel698; }
{{	int16_t src = get_iword(2);
	regs.sr = src;
	MakeFromSR();
}}}m68k_incpc(4);
endlabel698: ;
return 16;
}
unsigned long CPUFUNC(op_4800_4)(uint32_t opcode) /* NBCD */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 17; CurrentInstrCycles = 6;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint16_t newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uint16_t newv_hi = - (src & 0xF0);
	uint16_t newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_4810_4)(uint32_t opcode) /* NBCD */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 17; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint16_t newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uint16_t newv_hi = - (src & 0xF0);
	uint16_t newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4818_4)(uint32_t opcode) /* NBCD */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 17; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint16_t newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uint16_t newv_hi = - (src & 0xF0);
	uint16_t newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4820_4)(uint32_t opcode) /* NBCD */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 17; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint16_t newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uint16_t newv_hi = - (src & 0xF0);
	uint16_t newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_4828_4)(uint32_t opcode) /* NBCD */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 17; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint16_t newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uint16_t newv_hi = - (src & 0xF0);
	uint16_t newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4830_4)(uint32_t opcode) /* NBCD */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 17; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint16_t newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uint16_t newv_hi = - (src & 0xF0);
	uint16_t newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4838_4)(uint32_t opcode) /* NBCD */
{
	OpcodeFamily = 17; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint16_t newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uint16_t newv_hi = - (src & 0xF0);
	uint16_t newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4839_4)(uint32_t opcode) /* NBCD */
{
	OpcodeFamily = 17; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint16_t newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uint16_t newv_hi = - (src & 0xF0);
	uint16_t newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(srca,newv);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_4840_4)(uint32_t opcode) /* SWAP */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 34; CurrentInstrCycles = 4;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_NFLG (((int32_t)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (dst);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4850_4)(uint32_t opcode) /* PEA */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 57; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	m68k_write_memory_32(dsta,srca);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4868_4)(uint32_t opcode) /* PEA */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 57; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	uint32_t dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	m68k_write_memory_32(dsta,srca);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4870_4)(uint32_t opcode) /* PEA */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 57; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	uint32_t dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	m68k_write_memory_32(dsta,srca);
}}}m68k_incpc(4);
return 22;
}
unsigned long CPUFUNC(op_4878_4)(uint32_t opcode) /* PEA */
{
	OpcodeFamily = 57; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	uint32_t dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	m68k_write_memory_32(dsta,srca);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4879_4)(uint32_t opcode) /* PEA */
{
	OpcodeFamily = 57; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	uint32_t dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	m68k_write_memory_32(dsta,srca);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_487a_4)(uint32_t opcode) /* PEA */
{
	OpcodeFamily = 57; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	uint32_t dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	m68k_write_memory_32(dsta,srca);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_487b_4)(uint32_t opcode) /* PEA */
{
	OpcodeFamily = 57; CurrentInstrCycles = 22; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	uint32_t dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	m68k_write_memory_32(dsta,srca);
}}}m68k_incpc(4);
return 22;
}
unsigned long CPUFUNC(op_4880_4)(uint32_t opcode) /* EXT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 36; CurrentInstrCycles = 4;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint16_t dst = (int16_t)(int8_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(dst)) == 0);
	SET_NFLG (((int16_t)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4890_4)(uint32_t opcode) /* MVMLE */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 38; CurrentInstrCycles = 8;  
{	uint16_t mask = get_iword(2);
	retcycles = 0;
{	uint32_t srca = m68k_areg(regs, dstreg);
{	uint16_t dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { m68k_write_memory_16(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_write_memory_16(srca, m68k_areg(regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; retcycles+=4; }
}}}m68k_incpc(4);
 return (8+retcycles);
}
unsigned long CPUFUNC(op_48a0_4)(uint32_t opcode) /* MVMLE */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 38; CurrentInstrCycles = 8;  
{	uint16_t mask = get_iword(2);
	retcycles = 0;
{	uint32_t srca = m68k_areg(regs, dstreg) - 0;
{	uint16_t amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) { srca -= 2; m68k_write_memory_16(srca, m68k_areg(regs, movem_index2[amask])); amask = movem_next[amask]; retcycles+=4; }
	while (dmask) { srca -= 2; m68k_write_memory_16(srca, m68k_dreg(regs, movem_index2[dmask])); dmask = movem_next[dmask]; retcycles+=4; }
	m68k_areg(regs, dstreg) = srca;
}}}m68k_incpc(4);
 return (8+retcycles);
}
unsigned long CPUFUNC(op_48a8_4)(uint32_t opcode) /* MVMLE */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 38; CurrentInstrCycles = 12; 
{	uint16_t mask = get_iword(2);
	retcycles = 0;
{	uint32_t srca = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	uint16_t dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { m68k_write_memory_16(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_write_memory_16(srca, m68k_areg(regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; retcycles+=4; }
}}}m68k_incpc(6);
 return (12+retcycles);
}
unsigned long CPUFUNC(op_48b0_4)(uint32_t opcode) /* MVMLE */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 38; CurrentInstrCycles = 14; 
{	uint16_t mask = get_iword(2);
	retcycles = 0;
{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	uint16_t dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { m68k_write_memory_16(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_write_memory_16(srca, m68k_areg(regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; retcycles+=4; }
}}}m68k_incpc(6);
 return (14+retcycles);
}
unsigned long CPUFUNC(op_48b8_4)(uint32_t opcode) /* MVMLE */
{
	unsigned int retcycles = 0;
	OpcodeFamily = 38; CurrentInstrCycles = 12; 
{	uint16_t mask = get_iword(2);
	retcycles = 0;
{	uint32_t srca = (int32_t)(int16_t)get_iword(4);
{	uint16_t dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { m68k_write_memory_16(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_write_memory_16(srca, m68k_areg(regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; retcycles+=4; }
}}}m68k_incpc(6);
 return (12+retcycles);
}
unsigned long CPUFUNC(op_48b9_4)(uint32_t opcode) /* MVMLE */
{
	unsigned int retcycles = 0;
	OpcodeFamily = 38; CurrentInstrCycles = 16; 
{	uint16_t mask = get_iword(2);
	retcycles = 0;
{	uint32_t srca = get_ilong(4);
{	uint16_t dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { m68k_write_memory_16(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_write_memory_16(srca, m68k_areg(regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; retcycles+=4; }
}}}m68k_incpc(8);
 return (16+retcycles);
}
unsigned long CPUFUNC(op_48c0_4)(uint32_t opcode) /* EXT */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 36; CurrentInstrCycles = 4;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dst = (int32_t)(int16_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(dst)) == 0);
	SET_NFLG (((int32_t)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (dst);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_48d0_4)(uint32_t opcode) /* MVMLE */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 38; CurrentInstrCycles = 8;  
{	uint16_t mask = get_iword(2);
	retcycles = 0;
{	uint32_t srca = m68k_areg(regs, dstreg);
{	uint16_t dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { m68k_write_memory_32(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_write_memory_32(srca, m68k_areg(regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; retcycles+=8; }
}}}m68k_incpc(4);
 return (8+retcycles);
}
unsigned long CPUFUNC(op_48e0_4)(uint32_t opcode) /* MVMLE */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 38; CurrentInstrCycles = 8;  
{	uint16_t mask = get_iword(2);
	retcycles = 0;
{	uint32_t srca = m68k_areg(regs, dstreg) - 0;
{	uint16_t amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) { srca -= 4; m68k_write_memory_32(srca, m68k_areg(regs, movem_index2[amask])); amask = movem_next[amask]; retcycles+=8; }
	while (dmask) { srca -= 4; m68k_write_memory_32(srca, m68k_dreg(regs, movem_index2[dmask])); dmask = movem_next[dmask]; retcycles+=8; }
	m68k_areg(regs, dstreg) = srca;
}}}m68k_incpc(4);
 return (8+retcycles);
}
unsigned long CPUFUNC(op_48e8_4)(uint32_t opcode) /* MVMLE */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 38; CurrentInstrCycles = 12; 
{	uint16_t mask = get_iword(2);
	retcycles = 0;
{	uint32_t srca = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	uint16_t dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { m68k_write_memory_32(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_write_memory_32(srca, m68k_areg(regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; retcycles+=8; }
}}}m68k_incpc(6);
 return (12+retcycles);
}
unsigned long CPUFUNC(op_48f0_4)(uint32_t opcode) /* MVMLE */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 38; CurrentInstrCycles = 14; 
{	uint16_t mask = get_iword(2);
	retcycles = 0;
{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	uint16_t dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { m68k_write_memory_32(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_write_memory_32(srca, m68k_areg(regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; retcycles+=8; }
}}}m68k_incpc(6);
 return (14+retcycles);
}
unsigned long CPUFUNC(op_48f8_4)(uint32_t opcode) /* MVMLE */
{
	unsigned int retcycles = 0;
	OpcodeFamily = 38; CurrentInstrCycles = 12; 
{	uint16_t mask = get_iword(2);
	retcycles = 0;
{	uint32_t srca = (int32_t)(int16_t)get_iword(4);
{	uint16_t dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { m68k_write_memory_32(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_write_memory_32(srca, m68k_areg(regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; retcycles+=8; }
}}}m68k_incpc(6);
 return (12+retcycles);
}
unsigned long CPUFUNC(op_48f9_4)(uint32_t opcode) /* MVMLE */
{
	unsigned int retcycles = 0;
	OpcodeFamily = 38; CurrentInstrCycles = 16; 
{	uint16_t mask = get_iword(2);
	retcycles = 0;
{	uint32_t srca = get_ilong(4);
{	uint16_t dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { m68k_write_memory_32(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_write_memory_32(srca, m68k_areg(regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; retcycles+=8; }
}}}m68k_incpc(8);
 return (16+retcycles);
}
unsigned long CPUFUNC(op_4a00_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4a10_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_4a18_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_4a20_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_4a28_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_4a30_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_4a38_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_4a39_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_4a3a_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_4a3b_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_4a3c_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_4a40_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4a48_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_areg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4a50_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_4a58_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_4a60_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_4a68_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_4a70_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_4a78_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_4a79_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_4a7a_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_4a7b_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_4a7c_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_4a80_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 4;  
{{	int32_t src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4a88_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 4;  
{{	int32_t src = m68k_areg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4a90_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4a98_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4aa0_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_4aa8_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4ab0_4)(uint32_t opcode) /* TST */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 20; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4ab8_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4ab9_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_4aba_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_4abb_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4abc_4)(uint32_t opcode) /* TST */
{
	OpcodeFamily = 20; CurrentInstrCycles = 12; 
{{	int32_t src = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
}}m68k_incpc(6);
return 12;
}
unsigned long CPUFUNC(op_4ac0_4)(uint32_t opcode) /* TAS */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 98; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	src |= 0x80;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((src) & 0xff);
}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4ad0_4)(uint32_t opcode) /* TAS */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 98; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	src |= 0x80;
	m68k_write_memory_8(srca,src);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_4ad8_4)(uint32_t opcode) /* TAS */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 98; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	src |= 0x80;
	m68k_write_memory_8(srca,src);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_4ae0_4)(uint32_t opcode) /* TAS */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 98; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	src |= 0x80;
	m68k_write_memory_8(srca,src);
}}}m68k_incpc(2);
return 16;
}
unsigned long CPUFUNC(op_4ae8_4)(uint32_t opcode) /* TAS */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 98; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	src |= 0x80;
	m68k_write_memory_8(srca,src);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4af0_4)(uint32_t opcode) /* TAS */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 98; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	src |= 0x80;
	m68k_write_memory_8(srca,src);
}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_4af8_4)(uint32_t opcode) /* TAS */
{
	OpcodeFamily = 98; CurrentInstrCycles = 18; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	src |= 0x80;
	m68k_write_memory_8(srca,src);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4af9_4)(uint32_t opcode) /* TAS */
{
	OpcodeFamily = 98; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	src |= 0x80;
	m68k_write_memory_8(srca,src);
}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_4c90_4)(uint32_t opcode) /* MVMEL */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 12; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = m68k_areg(regs, dstreg);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; amask = movem_next[amask]; retcycles+=4; }
}}}m68k_incpc(4);
 return (12+retcycles);
}
unsigned long CPUFUNC(op_4c98_4)(uint32_t opcode) /* MVMEL */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 12; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = m68k_areg(regs, dstreg);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; amask = movem_next[amask]; retcycles+=4; }
	m68k_areg(regs, dstreg) = srca;
}}}m68k_incpc(4);
 return (12+retcycles);
}
unsigned long CPUFUNC(op_4ca8_4)(uint32_t opcode) /* MVMEL */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 16; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; amask = movem_next[amask]; retcycles+=4; }
}}}m68k_incpc(6);
 return (16+retcycles);
}
unsigned long CPUFUNC(op_4cb0_4)(uint32_t opcode) /* MVMEL */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 18; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; amask = movem_next[amask]; retcycles+=4; }
}}}m68k_incpc(6);
 return (18+retcycles);
}
unsigned long CPUFUNC(op_4cb8_4)(uint32_t opcode) /* MVMEL */
{
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 16; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = (int32_t)(int16_t)get_iword(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; amask = movem_next[amask]; retcycles+=4; }
}}}m68k_incpc(6);
 return (16+retcycles);
}
unsigned long CPUFUNC(op_4cb9_4)(uint32_t opcode) /* MVMEL */
{
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 20; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = get_ilong(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; amask = movem_next[amask]; retcycles+=4; }
}}}m68k_incpc(8);
 return (20+retcycles);
}
unsigned long CPUFUNC(op_4cba_4)(uint32_t opcode) /* MVMEL */
{
	uint32_t dstreg = 2;
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 16; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = m68k_getpc () + 4;
	srca += (int32_t)(int16_t)get_iword(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; amask = movem_next[amask]; retcycles+=4; }
}}}m68k_incpc(6);
 return (16+retcycles);
}
unsigned long CPUFUNC(op_4cbb_4)(uint32_t opcode) /* MVMEL */
{
	uint32_t dstreg = 3;
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 18; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(4));
	BusCyclePenalty += 2;
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; dmask = movem_next[dmask]; retcycles+=4; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (int32_t)(int16_t)m68k_read_memory_16(srca); srca += 2; amask = movem_next[amask]; retcycles+=4; }
}}}m68k_incpc(6);
 return (18+retcycles);
}
unsigned long CPUFUNC(op_4cd0_4)(uint32_t opcode) /* MVMEL */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 12; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = m68k_areg(regs, dstreg);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = m68k_read_memory_32(srca); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = m68k_read_memory_32(srca); srca += 4; amask = movem_next[amask]; retcycles+=8; }
}}}m68k_incpc(4);
 return (12+retcycles);
}
unsigned long CPUFUNC(op_4cd8_4)(uint32_t opcode) /* MVMEL */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 12; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = m68k_areg(regs, dstreg);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = m68k_read_memory_32(srca); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = m68k_read_memory_32(srca); srca += 4; amask = movem_next[amask]; retcycles+=8; }
	m68k_areg(regs, dstreg) = srca;
}}}m68k_incpc(4);
 return (12+retcycles);
}
unsigned long CPUFUNC(op_4ce8_4)(uint32_t opcode) /* MVMEL */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 16; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = m68k_read_memory_32(srca); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = m68k_read_memory_32(srca); srca += 4; amask = movem_next[amask]; retcycles+=8; }
}}}m68k_incpc(6);
 return (16+retcycles);
}
unsigned long CPUFUNC(op_4cf0_4)(uint32_t opcode) /* MVMEL */
{
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 18; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	BusCyclePenalty += 2;
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = m68k_read_memory_32(srca); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = m68k_read_memory_32(srca); srca += 4; amask = movem_next[amask]; retcycles+=8; }
}}}m68k_incpc(6);
 return (18+retcycles);
}
unsigned long CPUFUNC(op_4cf8_4)(uint32_t opcode) /* MVMEL */
{
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 16; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = (int32_t)(int16_t)get_iword(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = m68k_read_memory_32(srca); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = m68k_read_memory_32(srca); srca += 4; amask = movem_next[amask]; retcycles+=8; }
}}}m68k_incpc(6);
 return (16+retcycles);
}
unsigned long CPUFUNC(op_4cf9_4)(uint32_t opcode) /* MVMEL */
{
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 20; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = get_ilong(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = m68k_read_memory_32(srca); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = m68k_read_memory_32(srca); srca += 4; amask = movem_next[amask]; retcycles+=8; }
}}}m68k_incpc(8);
 return (20+retcycles);
}
unsigned long CPUFUNC(op_4cfa_4)(uint32_t opcode) /* MVMEL */
{
	uint32_t dstreg = 2;
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 16; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t srca = m68k_getpc () + 4;
	srca += (int32_t)(int16_t)get_iword(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = m68k_read_memory_32(srca); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = m68k_read_memory_32(srca); srca += 4; amask = movem_next[amask]; retcycles+=8; }
}}}m68k_incpc(6);
 return (16+retcycles);
}
unsigned long CPUFUNC(op_4cfb_4)(uint32_t opcode) /* MVMEL */
{
	uint32_t dstreg = 3;
	unsigned int retcycles = 0;
	OpcodeFamily = 37; CurrentInstrCycles = 18; 
{	uint16_t mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	retcycles = 0;
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(4));
	BusCyclePenalty += 2;
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = m68k_read_memory_32(srca); srca += 4; dmask = movem_next[dmask]; retcycles+=8; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = m68k_read_memory_32(srca); srca += 4; amask = movem_next[amask]; retcycles+=8; }
}}}m68k_incpc(6);
 return (18+retcycles);
}
unsigned long CPUFUNC(op_4e40_4)(uint32_t opcode) /* TRAP */
{
	uint32_t srcreg = (opcode & 15);
	OpcodeFamily = 39; CurrentInstrCycles = 4;  
{{	uint32_t src = srcreg;
m68k_incpc(2);
	Exception(src+32,0,M68000_EXC_SRC_CPU);
}}return 4;
}
unsigned long CPUFUNC(op_4e50_4)(uint32_t opcode) /* LINK */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 47; CurrentInstrCycles = 18; 
{{	uint32_t olda = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = olda;
{	int32_t src = m68k_areg(regs, srcreg);
	m68k_write_memory_32(olda,src);
	m68k_areg(regs, srcreg) = (m68k_areg(regs, 7));
{	int16_t offs = get_iword(2);
	m68k_areg(regs, 7) += offs;
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_4e58_4)(uint32_t opcode) /* UNLK */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 48; CurrentInstrCycles = 12; 
{{	int32_t src = m68k_areg(regs, srcreg);
	m68k_areg(regs, 7) = src;
{	uint32_t olda = m68k_areg(regs, 7);
{	int32_t old = m68k_read_memory_32(olda);
	m68k_areg(regs, 7) += 4;
	m68k_areg(regs, srcreg) = (old);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_4e60_4)(uint32_t opcode) /* MVR2USP */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 40; CurrentInstrCycles = 4;  
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel791; }
{{	int32_t src = m68k_areg(regs, srcreg);
	regs.usp = src;
}}}m68k_incpc(2);
endlabel791: ;
return 4;
}
unsigned long CPUFUNC(op_4e68_4)(uint32_t opcode) /* MVUSP2R */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 41; CurrentInstrCycles = 4;  
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel792; }
{{	m68k_areg(regs, srcreg) = (regs.usp);
}}}m68k_incpc(2);
endlabel792: ;
return 4;
}
unsigned long CPUFUNC(op_4e70_4)(uint32_t opcode) /* RESET */
{
	OpcodeFamily = 42; CurrentInstrCycles = 132;
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel793; }
{}}m68k_incpc(2);
endlabel793: ;
return 132;
}
unsigned long CPUFUNC(op_4e71_4)(uint32_t opcode) /* NOP */
{
	OpcodeFamily = 43; CurrentInstrCycles = 4;  
{}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_4e72_4)(uint32_t opcode) /* STOP */
{
	OpcodeFamily = 44; CurrentInstrCycles = 4;  
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel795; }
{{	int16_t src = get_iword(2);
	regs.sr = src;
	MakeFromSR();
	m68k_setstopped(1);
}}}m68k_incpc(4);
endlabel795: ;
return 4;
}
unsigned long CPUFUNC(op_4e73_4)(uint32_t opcode) /* RTE */
{
	OpcodeFamily = 45; CurrentInstrCycles = 20; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel796; }
{{	uint32_t sra = m68k_areg(regs, 7);
{	int16_t sr = m68k_read_memory_16(sra);
	m68k_areg(regs, 7) += 2;
{	uint32_t pca = m68k_areg(regs, 7);
{	int32_t pc = m68k_read_memory_32(pca);
	m68k_areg(regs, 7) += 4;
	regs.sr = sr; m68k_setpc_rte(pc);
	MakeFromSR();
}}}}}}endlabel796: ;
return 20;
}
unsigned long CPUFUNC(op_4e74_4)(uint32_t opcode) /* RTD */
{
	OpcodeFamily = 46; CurrentInstrCycles = 16; 
{{	uint32_t pca = m68k_areg(regs, 7);
{	int32_t pc = m68k_read_memory_32(pca);
	m68k_areg(regs, 7) += 4;
{	int16_t offs = get_iword(2);
	m68k_areg(regs, 7) += offs;
	m68k_setpc_rte(pc);
}}}}return 16;
}
unsigned long CPUFUNC(op_4e75_4)(uint32_t opcode) /* RTS */
{
	OpcodeFamily = 49; CurrentInstrCycles = 16; 
{	m68k_do_rts();
}return 16;
}
unsigned long CPUFUNC(op_4e76_4)(uint32_t opcode) /* TRAPV */
{
	OpcodeFamily = 50; CurrentInstrCycles = 4;  
{m68k_incpc(2);
	if (GET_VFLG) { Exception(7,m68k_getpc(),M68000_EXC_SRC_CPU); goto endlabel799; }
}endlabel799: ;
return 4;
}
unsigned long CPUFUNC(op_4e77_4)(uint32_t opcode) /* RTR */
{
	OpcodeFamily = 51; CurrentInstrCycles = 20; 
{	MakeSR();
{	uint32_t sra = m68k_areg(regs, 7);
{	int16_t sr = m68k_read_memory_16(sra);
	m68k_areg(regs, 7) += 2;
{	uint32_t pca = m68k_areg(regs, 7);
{	int32_t pc = m68k_read_memory_32(pca);
	m68k_areg(regs, 7) += 4;
	regs.sr &= 0xFF00; sr &= 0xFF;
	regs.sr |= sr; m68k_setpc(pc);
	MakeFromSR();
}}}}}return 20;
}
unsigned long CPUFUNC(op_4e90_4)(uint32_t opcode) /* JSR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 52; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	uint32_t oldpc = m68k_getpc () + 2;
	m68k_do_jsr(m68k_getpc() + 2, srca);
}}return 16;
}
unsigned long CPUFUNC(op_4ea8_4)(uint32_t opcode) /* JSR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 52; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
	uint32_t oldpc = m68k_getpc () + 4;
	m68k_do_jsr(m68k_getpc() + 4, srca);
}}return 18;
}
unsigned long CPUFUNC(op_4eb0_4)(uint32_t opcode) /* JSR */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 52; CurrentInstrCycles = 22; 
{{	uint32_t oldpc; uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
	oldpc = m68k_getpc () + 4;
	m68k_do_jsr(m68k_getpc() + 4, srca);
}}return 22;
}
unsigned long CPUFUNC(op_4eb8_4)(uint32_t opcode) /* JSR */
{
	OpcodeFamily = 52; CurrentInstrCycles = 18; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
	uint32_t oldpc = m68k_getpc () + 4;
	m68k_do_jsr(m68k_getpc() + 4, srca);
}}return 18;
}
unsigned long CPUFUNC(op_4eb9_4)(uint32_t opcode) /* JSR */
{
	OpcodeFamily = 52; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
	uint32_t oldpc = m68k_getpc () + 6;
	m68k_do_jsr(m68k_getpc() + 6, srca);
}}return 20;
}
unsigned long CPUFUNC(op_4eba_4)(uint32_t opcode) /* JSR */
{
	OpcodeFamily = 52; CurrentInstrCycles = 18; 
{{	uint32_t oldpc; uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
	oldpc = m68k_getpc () + 4;
	m68k_do_jsr(m68k_getpc() + 4, srca);
}}return 18;
}
unsigned long CPUFUNC(op_4ebb_4)(uint32_t opcode) /* JSR */
{
	OpcodeFamily = 52; CurrentInstrCycles = 22; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t oldpc; uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
	oldpc = m68k_getpc () + 4;
	m68k_do_jsr(m68k_getpc() + 4, srca);
}}return 22;
}
unsigned long CPUFUNC(op_4ed0_4)(uint32_t opcode) /* JMP */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 53; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_setpc(srca);
}}return 8;
}
unsigned long CPUFUNC(op_4ee8_4)(uint32_t opcode) /* JMP */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 53; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
	m68k_setpc(srca);
}}return 10;
}
unsigned long CPUFUNC(op_4ef0_4)(uint32_t opcode) /* JMP */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 53; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
	m68k_setpc(srca);
}}return 14;
}
unsigned long CPUFUNC(op_4ef8_4)(uint32_t opcode) /* JMP */
{
	OpcodeFamily = 53; CurrentInstrCycles = 10; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
	m68k_setpc(srca);
}}return 10;
}
unsigned long CPUFUNC(op_4ef9_4)(uint32_t opcode) /* JMP */
{
	OpcodeFamily = 53; CurrentInstrCycles = 12; 
{{	uint32_t srca = get_ilong(2);
	m68k_setpc(srca);
}}return 12;
}
unsigned long CPUFUNC(op_4efa_4)(uint32_t opcode) /* JMP */
{
	OpcodeFamily = 53; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
	m68k_setpc(srca);
}}return 10;
}
unsigned long CPUFUNC(op_4efb_4)(uint32_t opcode) /* JMP */
{
	OpcodeFamily = 53; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
	m68k_setpc(srca);
}}return 14;
}
unsigned long CPUFUNC(op_5000_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 4;  
{{	uint32_t src = srcreg;
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_5010_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5018_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
#endif

#ifdef PART_5
unsigned long CPUFUNC(op_5020_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 14; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_5028_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5030_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 18; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_5038_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5039_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = get_ilong(2);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_5040_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 4;  
{{	uint32_t src = srcreg;
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_5048_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_5050_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5058_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5060_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 14; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_5068_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5070_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 18; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_5078_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5079_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = get_ilong(2);
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_5080_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_5088_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_5090_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_5098_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_50a0_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 22; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_50a8_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 24; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_50b0_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 26; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_50b8_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	OpcodeFamily = 11; CurrentInstrCycles = 24; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_50b9_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	OpcodeFamily = 11; CurrentInstrCycles = 28; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = get_ilong(2);
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_50c0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(0) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_50c8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(0)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel842: ;
return 12;
}
unsigned long CPUFUNC(op_50d0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(0) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_50d8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(0) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_50e0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(0) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_50e8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(0) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_50f0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(0) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_50f8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(0) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_50f9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(0) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_5100_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 4;  
{{	uint32_t src = srcreg;
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_5110_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5118_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5120_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 14; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_5128_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5130_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 18; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_5138_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5139_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = get_ilong(2);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_5140_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 4;  
{{	uint32_t src = srcreg;
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_5148_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_5150_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5158_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5160_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 14; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_5168_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5170_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 18; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_5178_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5179_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = get_ilong(2);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_5180_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_5188_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_5190_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_5198_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_51a0_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 22; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_51a8_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 24; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_51b0_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 26; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_51b8_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	OpcodeFamily = 7; CurrentInstrCycles = 24; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_51b9_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	OpcodeFamily = 7; CurrentInstrCycles = 28; 
{{	uint32_t src = srcreg;
{	uint32_t dsta = get_ilong(2);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_51c0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(1) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_51c8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(1)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel877: ;
return 12;
}
unsigned long CPUFUNC(op_51d0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(1) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_51d8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(1) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_51e0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(1) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_51e8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(1) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_51f0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(1) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_51f8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(1) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_51f9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(1) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_52c0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(2) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_52c8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(2)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel886: ;
return 12;
}
unsigned long CPUFUNC(op_52d0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(2) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_52d8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(2) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_52e0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(2) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_52e8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(2) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_52f0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(2) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_52f8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(2) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_52f9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(2) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_53c0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(3) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_53c8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(3)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel895: ;
return 12;
}
unsigned long CPUFUNC(op_53d0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(3) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_53d8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(3) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_53e0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(3) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_53e8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(3) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_53f0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(3) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_53f8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(3) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_53f9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(3) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_54c0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(4) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_54c8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(4)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel904: ;
return 12;
}
unsigned long CPUFUNC(op_54d0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(4) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_54d8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(4) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_54e0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(4) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_54e8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(4) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_54f0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(4) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_54f8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(4) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_54f9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(4) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_55c0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(5) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_55c8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(5)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel913: ;
return 12;
}
unsigned long CPUFUNC(op_55d0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(5) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_55d8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(5) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_55e0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(5) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_55e8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(5) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_55f0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(5) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_55f8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(5) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_55f9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(5) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_56c0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(6) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_56c8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(6)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel922: ;
return 12;
}
unsigned long CPUFUNC(op_56d0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(6) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_56d8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(6) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_56e0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(6) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_56e8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(6) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_56f0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(6) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_56f8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(6) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_56f9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(6) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_57c0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(7) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_57c8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(7)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel931: ;
return 12;
}
unsigned long CPUFUNC(op_57d0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(7) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_57d8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(7) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_57e0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(7) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_57e8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(7) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_57f0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(7) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_57f8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(7) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_57f9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(7) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_58c0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(8) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_58c8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(8)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel940: ;
return 12;
}
unsigned long CPUFUNC(op_58d0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(8) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_58d8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(8) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_58e0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(8) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_58e8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(8) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_58f0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(8) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_58f8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(8) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_58f9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(8) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_59c0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(9) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_59c8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(9)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel949: ;
return 12;
}
unsigned long CPUFUNC(op_59d0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(9) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_59d8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(9) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_59e0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(9) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_59e8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(9) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_59f0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(9) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_59f8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(9) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_59f9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(9) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_5ac0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(10) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_5ac8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(10)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel958: ;
return 12;
}
unsigned long CPUFUNC(op_5ad0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(10) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5ad8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(10) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5ae0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(10) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_5ae8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(10) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5af0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(10) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_5af8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(10) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5af9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(10) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_5bc0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(11) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_5bc8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(11)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel967: ;
return 12;
}
unsigned long CPUFUNC(op_5bd0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(11) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5bd8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(11) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5be0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(11) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_5be8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(11) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5bf0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(11) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_5bf8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(11) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5bf9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(11) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_5cc0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(12) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_5cc8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(12)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel976: ;
return 12;
}
unsigned long CPUFUNC(op_5cd0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(12) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5cd8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(12) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5ce0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(12) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_5ce8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(12) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5cf0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(12) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_5cf8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(12) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5cf9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(12) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_5dc0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(13) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_5dc8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(13)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel985: ;
return 12;
}
unsigned long CPUFUNC(op_5dd0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(13) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5dd8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(13) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5de0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(13) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_5de8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(13) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5df0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(13) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_5df8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(13) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5df9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(13) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_5ec0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(14) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_5ec8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(14)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel994: ;
return 12;
}
unsigned long CPUFUNC(op_5ed0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(14) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5ed8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(14) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5ee0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(14) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_5ee8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(14) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5ef0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(14) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_5ef8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(14) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5ef9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(14) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_5fc0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 4;  
{{{	int val = cctrue(15) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	if (val) { m68k_incpc(2) ; return 4+2; }
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_5fc8_4)(uint32_t opcode) /* DBcc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 58; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t offs = get_iword(2);
	if (!cctrue(15)) {
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((int32_t)offs + 2);
			return 10;
		} else {
			m68k_incpc(4);
			return 14;
		}
	}
}}}m68k_incpc(4);
endlabel1003: ;
return 12;
}
unsigned long CPUFUNC(op_5fd0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int val = cctrue(15) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5fd8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(15) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_5fe0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(15) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(2);
return 14;
}
#endif

#ifdef PART_6
unsigned long CPUFUNC(op_5fe8_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(15) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5ff0_4)(uint32_t opcode) /* Scc */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 59; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int val = cctrue(15) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_5ff8_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int val = cctrue(15) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_5ff9_4)(uint32_t opcode) /* Scc */
{
	OpcodeFamily = 59; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int val = cctrue(15) ? 0xff : 0;
	m68k_write_memory_8(srca,val);
}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_6000_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(0)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1011: ;
return 12;
}
unsigned long CPUFUNC(op_6001_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(0)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1012: ;
return 8;
}
unsigned long CPUFUNC(op_60ff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(0)) goto endlabel1013;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1013;
{	int32_t src = get_ilong(2);
	if (!cctrue(0)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1013: ;
return 12;
}
unsigned long CPUFUNC(op_6100_4)(uint32_t opcode) /* BSR */
{
	OpcodeFamily = 54; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword(2);
	int32_t s = (int32_t)src + 2;
	m68k_do_bsr(m68k_getpc() + 4, s);
}}return 18;
}
unsigned long CPUFUNC(op_6101_4)(uint32_t opcode) /* BSR */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 54; CurrentInstrCycles = 18; 
{{	uint32_t src = srcreg;
	int32_t s = (int32_t)src + 2;
	m68k_do_bsr(m68k_getpc() + 2, s);
}}return 18;
}
unsigned long CPUFUNC(op_61ff_4)(uint32_t opcode) /* BSR */
{
	OpcodeFamily = 54; CurrentInstrCycles = 18; 
{{	int32_t src = get_ilong(2);
	int32_t s = (int32_t)src + 2;
	m68k_do_bsr(m68k_getpc() + 6, s);
}}return 18;
}
unsigned long CPUFUNC(op_6200_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(2)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1017: ;
return 12;
}
unsigned long CPUFUNC(op_6201_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(2)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1018: ;
return 8;
}
unsigned long CPUFUNC(op_62ff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(2)) goto endlabel1019;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1019;
{	int32_t src = get_ilong(2);
	if (!cctrue(2)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1019: ;
return 12;
}
unsigned long CPUFUNC(op_6300_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(3)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1020: ;
return 12;
}
unsigned long CPUFUNC(op_6301_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(3)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1021: ;
return 8;
}
unsigned long CPUFUNC(op_63ff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(3)) goto endlabel1022;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1022;
{	int32_t src = get_ilong(2);
	if (!cctrue(3)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1022: ;
return 12;
}
unsigned long CPUFUNC(op_6400_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(4)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1023: ;
return 12;
}
unsigned long CPUFUNC(op_6401_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(4)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1024: ;
return 8;
}
unsigned long CPUFUNC(op_64ff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(4)) goto endlabel1025;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1025;
{	int32_t src = get_ilong(2);
	if (!cctrue(4)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1025: ;
return 12;
}
unsigned long CPUFUNC(op_6500_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(5)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1026: ;
return 12;
}
unsigned long CPUFUNC(op_6501_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(5)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1027: ;
return 8;
}
unsigned long CPUFUNC(op_65ff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(5)) goto endlabel1028;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1028;
{	int32_t src = get_ilong(2);
	if (!cctrue(5)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1028: ;
return 12;
}
unsigned long CPUFUNC(op_6600_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(6)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1029: ;
return 12;
}
unsigned long CPUFUNC(op_6601_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(6)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1030: ;
return 8;
}
unsigned long CPUFUNC(op_66ff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(6)) goto endlabel1031;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1031;
{	int32_t src = get_ilong(2);
	if (!cctrue(6)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1031: ;
return 12;
}
unsigned long CPUFUNC(op_6700_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(7)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1032: ;
return 12;
}
unsigned long CPUFUNC(op_6701_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(7)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1033: ;
return 8;
}
unsigned long CPUFUNC(op_67ff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(7)) goto endlabel1034;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1034;
{	int32_t src = get_ilong(2);
	if (!cctrue(7)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1034: ;
return 12;
}
unsigned long CPUFUNC(op_6800_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(8)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1035: ;
return 12;
}
unsigned long CPUFUNC(op_6801_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(8)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1036: ;
return 8;
}
unsigned long CPUFUNC(op_68ff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(8)) goto endlabel1037;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1037;
{	int32_t src = get_ilong(2);
	if (!cctrue(8)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1037: ;
return 12;
}
unsigned long CPUFUNC(op_6900_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(9)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1038: ;
return 12;
}
unsigned long CPUFUNC(op_6901_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(9)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1039: ;
return 8;
}
unsigned long CPUFUNC(op_69ff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(9)) goto endlabel1040;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1040;
{	int32_t src = get_ilong(2);
	if (!cctrue(9)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1040: ;
return 12;
}
unsigned long CPUFUNC(op_6a00_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(10)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1041: ;
return 12;
}
unsigned long CPUFUNC(op_6a01_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(10)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1042: ;
return 8;
}
unsigned long CPUFUNC(op_6aff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(10)) goto endlabel1043;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1043;
{	int32_t src = get_ilong(2);
	if (!cctrue(10)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1043: ;
return 12;
}
unsigned long CPUFUNC(op_6b00_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(11)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1044: ;
return 12;
}
unsigned long CPUFUNC(op_6b01_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(11)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1045: ;
return 8;
}
unsigned long CPUFUNC(op_6bff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(11)) goto endlabel1046;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1046;
{	int32_t src = get_ilong(2);
	if (!cctrue(11)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1046: ;
return 12;
}
unsigned long CPUFUNC(op_6c00_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(12)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1047: ;
return 12;
}
unsigned long CPUFUNC(op_6c01_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(12)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1048: ;
return 8;
}
unsigned long CPUFUNC(op_6cff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(12)) goto endlabel1049;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1049;
{	int32_t src = get_ilong(2);
	if (!cctrue(12)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1049: ;
return 12;
}
unsigned long CPUFUNC(op_6d00_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(13)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1050: ;
return 12;
}
unsigned long CPUFUNC(op_6d01_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(13)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1051: ;
return 8;
}
unsigned long CPUFUNC(op_6dff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(13)) goto endlabel1052;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1052;
{	int32_t src = get_ilong(2);
	if (!cctrue(13)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1052: ;
return 12;
}
unsigned long CPUFUNC(op_6e00_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(14)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1053: ;
return 12;
}
unsigned long CPUFUNC(op_6e01_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(14)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1054: ;
return 8;
}
unsigned long CPUFUNC(op_6eff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(14)) goto endlabel1055;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1055;
{	int32_t src = get_ilong(2);
	if (!cctrue(14)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1055: ;
return 12;
}
unsigned long CPUFUNC(op_6f00_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
	if (!cctrue(15)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(4);
endlabel1056: ;
return 12;
}
unsigned long CPUFUNC(op_6f01_4)(uint32_t opcode) /* Bcc */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	OpcodeFamily = 55; CurrentInstrCycles = 8;  
{{	uint32_t src = srcreg;
	if (!cctrue(15)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(2);
endlabel1057: ;
return 8;
}
unsigned long CPUFUNC(op_6fff_4)(uint32_t opcode) /* Bcc */
{
	OpcodeFamily = 55; CurrentInstrCycles = 12; 
{	m68k_incpc(2);
	if (!cctrue(15)) goto endlabel1058;
		last_addr_for_exception_3 = m68k_getpc() + 2;
		last_fault_for_exception_3 = m68k_getpc() + 1;
		last_op_for_exception_3 = opcode; Exception(3,0,M68000_EXC_SRC_CPU); goto endlabel1058;
{	int32_t src = get_ilong(2);
	if (!cctrue(15)) goto didnt_jump;
	m68k_incpc ((int32_t)src + 2);
	return 10;
didnt_jump:;
}}m68k_incpc(6);
endlabel1058: ;
return 12;
}
unsigned long CPUFUNC(op_7000_4)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (int32_t)(int8_t)(opcode & 255);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 4;  
{{	uint32_t src = srcreg;
{	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_8000_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_8010_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_8018_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_8020_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_8028_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_8030_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_8038_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_8039_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_803a_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_803b_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_803c_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_8040_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_8050_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_8058_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_8060_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_8068_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_8070_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_8078_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_8079_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_807a_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_807b_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_807c_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_8080_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_8090_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_8098_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_80a0_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 16;
}
unsigned long CPUFUNC(op_80a8_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_80b0_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_80b8_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 18; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_80b9_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_80ba_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_80bb_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_80bc_4)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_80c0_4)(uint32_t opcode) /* DIVU */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 60; CurrentInstrCycles = 4;  
{	uint32_t oldpc = m68k_getpc();
{	int16_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	if (src == 0) { SET_VFLG (0); Exception (5, oldpc,M68000_EXC_SRC_CPU); goto endlabel1093; } else {
	uint32_t newv = (uint32_t)dst / (uint32_t)(uint16_t)src;
	uint32_t rem = (uint32_t)dst % (uint32_t)(uint16_t)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivu68kCycles((uint32_t)dst, (uint16_t)src);
}}}endlabel1093: ;
 return (4+retcycles);
}
unsigned long CPUFUNC(op_80d0_4)(uint32_t opcode) /* DIVU */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 60; CurrentInstrCycles = 8;  
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	if (src == 0) { SET_VFLG (0); Exception (5, oldpc,M68000_EXC_SRC_CPU); goto endlabel1094; } else {
	uint32_t newv = (uint32_t)dst / (uint32_t)(uint16_t)src;
	uint32_t rem = (uint32_t)dst % (uint32_t)(uint16_t)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivu68kCycles((uint32_t)dst, (uint16_t)src);
}}}}endlabel1094: ;
 return (8+retcycles);
}
unsigned long CPUFUNC(op_80d8_4)(uint32_t opcode) /* DIVU */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 60; CurrentInstrCycles = 8;  
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	if (src == 0) { SET_VFLG (0); Exception (5, oldpc,M68000_EXC_SRC_CPU); goto endlabel1095; } else {
	uint32_t newv = (uint32_t)dst / (uint32_t)(uint16_t)src;
	uint32_t rem = (uint32_t)dst % (uint32_t)(uint16_t)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivu68kCycles((uint32_t)dst, (uint16_t)src);
}}}}endlabel1095: ;
 return (8+retcycles);
}
unsigned long CPUFUNC(op_80e0_4)(uint32_t opcode) /* DIVU */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 60; CurrentInstrCycles = 10; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	if (src == 0) { SET_VFLG (0); Exception (5, oldpc,M68000_EXC_SRC_CPU); goto endlabel1096; } else {
	uint32_t newv = (uint32_t)dst / (uint32_t)(uint16_t)src;
	uint32_t rem = (uint32_t)dst % (uint32_t)(uint16_t)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivu68kCycles((uint32_t)dst, (uint16_t)src);
}}}}endlabel1096: ;
 return (10+retcycles);
}
unsigned long CPUFUNC(op_80e8_4)(uint32_t opcode) /* DIVU */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 60; CurrentInstrCycles = 12; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if (src == 0) { SET_VFLG (0); Exception (5, oldpc,M68000_EXC_SRC_CPU); goto endlabel1097; } else {
	uint32_t newv = (uint32_t)dst / (uint32_t)(uint16_t)src;
	uint32_t rem = (uint32_t)dst % (uint32_t)(uint16_t)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivu68kCycles((uint32_t)dst, (uint16_t)src);
}}}}endlabel1097: ;
 return (12+retcycles);
}
unsigned long CPUFUNC(op_80f0_4)(uint32_t opcode) /* DIVU */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 60; CurrentInstrCycles = 14; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if (src == 0) { SET_VFLG (0); Exception (5, oldpc,M68000_EXC_SRC_CPU); goto endlabel1098; } else {
	uint32_t newv = (uint32_t)dst / (uint32_t)(uint16_t)src;
	uint32_t rem = (uint32_t)dst % (uint32_t)(uint16_t)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivu68kCycles((uint32_t)dst, (uint16_t)src);
}}}}endlabel1098: ;
 return (14+retcycles);
}
unsigned long CPUFUNC(op_80f8_4)(uint32_t opcode) /* DIVU */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 60; CurrentInstrCycles = 12; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if (src == 0) { SET_VFLG (0); Exception (5, oldpc,M68000_EXC_SRC_CPU); goto endlabel1099; } else {
	uint32_t newv = (uint32_t)dst / (uint32_t)(uint16_t)src;
	uint32_t rem = (uint32_t)dst % (uint32_t)(uint16_t)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivu68kCycles((uint32_t)dst, (uint16_t)src);
}}}}endlabel1099: ;
 return (12+retcycles);
}
unsigned long CPUFUNC(op_80f9_4)(uint32_t opcode) /* DIVU */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 60; CurrentInstrCycles = 16; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(6);
	if (src == 0) { SET_VFLG (0); Exception (5, oldpc,M68000_EXC_SRC_CPU); goto endlabel1100; } else {
	uint32_t newv = (uint32_t)dst / (uint32_t)(uint16_t)src;
	uint32_t rem = (uint32_t)dst % (uint32_t)(uint16_t)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivu68kCycles((uint32_t)dst, (uint16_t)src);
}}}}endlabel1100: ;
 return (16+retcycles);
}
unsigned long CPUFUNC(op_80fa_4)(uint32_t opcode) /* DIVU */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 60; CurrentInstrCycles = 12; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if (src == 0) { SET_VFLG (0); Exception (5, oldpc,M68000_EXC_SRC_CPU); goto endlabel1101; } else {
	uint32_t newv = (uint32_t)dst / (uint32_t)(uint16_t)src;
	uint32_t rem = (uint32_t)dst % (uint32_t)(uint16_t)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivu68kCycles((uint32_t)dst, (uint16_t)src);
}}}}endlabel1101: ;
 return (12+retcycles);
}
unsigned long CPUFUNC(op_80fb_4)(uint32_t opcode) /* DIVU */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 60; CurrentInstrCycles = 14; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if (src == 0) { SET_VFLG (0); Exception (5, oldpc,M68000_EXC_SRC_CPU); goto endlabel1102; } else {
	uint32_t newv = (uint32_t)dst / (uint32_t)(uint16_t)src;
	uint32_t rem = (uint32_t)dst % (uint32_t)(uint16_t)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivu68kCycles((uint32_t)dst, (uint16_t)src);
}}}}endlabel1102: ;
 return (14+retcycles);
}
unsigned long CPUFUNC(op_80fc_4)(uint32_t opcode) /* DIVU */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 60; CurrentInstrCycles = 8;  
{	uint32_t oldpc = m68k_getpc();
{	int16_t src = get_iword(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if (src == 0) { SET_VFLG (0); Exception (5, oldpc,M68000_EXC_SRC_CPU); goto endlabel1103; } else {
	uint32_t newv = (uint32_t)dst / (uint32_t)(uint16_t)src;
	uint32_t rem = (uint32_t)dst % (uint32_t)(uint16_t)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivu68kCycles((uint32_t)dst, (uint16_t)src);
}}}endlabel1103: ;
 return (8+retcycles);
}
unsigned long CPUFUNC(op_8100_4)(uint32_t opcode) /* SBCD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 10; CurrentInstrCycles = 6;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	uint16_t newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uint16_t newv_hi = (dst & 0xF0) - (src & 0xF0);
	uint16_t newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG ((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_8108_4)(uint32_t opcode) /* SBCD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 10; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uint16_t newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uint16_t newv_hi = (dst & 0xF0) - (src & 0xF0);
	uint16_t newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG ((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}m68k_incpc(2);
return 18;
}
unsigned long CPUFUNC(op_8110_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_8118_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_8120_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_8128_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_8130_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_8138_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_8139_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_8150_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_8158_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_8160_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 14; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_8168_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_8170_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 18; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_8178_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_8179_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_8190_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_8198_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_81a0_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 22; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_81a8_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 24; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_81b0_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 26; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_81b8_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 1; CurrentInstrCycles = 24; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_81b9_4)(uint32_t opcode) /* OR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 1; CurrentInstrCycles = 28; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_81c0_4)(uint32_t opcode) /* DIVS */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 61; CurrentInstrCycles = 4;  
{	uint32_t oldpc = m68k_getpc();
{	int16_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	if (src == 0) { SET_VFLG (0); Exception(5,oldpc,M68000_EXC_SRC_CPU); goto endlabel1127; } else {
	int32_t newv = (int32_t)dst / (int32_t)(int16_t)src;
	uint16_t rem = (int32_t)dst % (int32_t)(int16_t)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((int16_t)rem < 0) != ((int32_t)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivs68kCycles((int32_t)dst, (int16_t)src);
}}}endlabel1127: ;
 return (4+retcycles);
}
unsigned long CPUFUNC(op_81d0_4)(uint32_t opcode) /* DIVS */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 61; CurrentInstrCycles = 8;  
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	if (src == 0) { SET_VFLG (0); Exception(5,oldpc,M68000_EXC_SRC_CPU); goto endlabel1128; } else {
	int32_t newv = (int32_t)dst / (int32_t)(int16_t)src;
	uint16_t rem = (int32_t)dst % (int32_t)(int16_t)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((int16_t)rem < 0) != ((int32_t)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivs68kCycles((int32_t)dst, (int16_t)src);
}}}}endlabel1128: ;
 return (8+retcycles);
}
unsigned long CPUFUNC(op_81d8_4)(uint32_t opcode) /* DIVS */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 61; CurrentInstrCycles = 8;  
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	if (src == 0) { SET_VFLG (0); Exception(5,oldpc,M68000_EXC_SRC_CPU); goto endlabel1129; } else {
	int32_t newv = (int32_t)dst / (int32_t)(int16_t)src;
	uint16_t rem = (int32_t)dst % (int32_t)(int16_t)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((int16_t)rem < 0) != ((int32_t)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivs68kCycles((int32_t)dst, (int16_t)src);
}}}}endlabel1129: ;
 return (8+retcycles);
}
unsigned long CPUFUNC(op_81e0_4)(uint32_t opcode) /* DIVS */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 61; CurrentInstrCycles = 10; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	if (src == 0) { SET_VFLG (0); Exception(5,oldpc,M68000_EXC_SRC_CPU); goto endlabel1130; } else {
	int32_t newv = (int32_t)dst / (int32_t)(int16_t)src;
	uint16_t rem = (int32_t)dst % (int32_t)(int16_t)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((int16_t)rem < 0) != ((int32_t)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivs68kCycles((int32_t)dst, (int16_t)src);
}}}}endlabel1130: ;
 return (10+retcycles);
}
unsigned long CPUFUNC(op_81e8_4)(uint32_t opcode) /* DIVS */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 61; CurrentInstrCycles = 12; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if (src == 0) { SET_VFLG (0); Exception(5,oldpc,M68000_EXC_SRC_CPU); goto endlabel1131; } else {
	int32_t newv = (int32_t)dst / (int32_t)(int16_t)src;
	uint16_t rem = (int32_t)dst % (int32_t)(int16_t)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((int16_t)rem < 0) != ((int32_t)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivs68kCycles((int32_t)dst, (int16_t)src);
}}}}endlabel1131: ;
 return (12+retcycles);
}
unsigned long CPUFUNC(op_81f0_4)(uint32_t opcode) /* DIVS */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 61; CurrentInstrCycles = 14; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if (src == 0) { SET_VFLG (0); Exception(5,oldpc,M68000_EXC_SRC_CPU); goto endlabel1132; } else {
	int32_t newv = (int32_t)dst / (int32_t)(int16_t)src;
	uint16_t rem = (int32_t)dst % (int32_t)(int16_t)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((int16_t)rem < 0) != ((int32_t)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivs68kCycles((int32_t)dst, (int16_t)src);
}}}}endlabel1132: ;
 return (14+retcycles);
}
unsigned long CPUFUNC(op_81f8_4)(uint32_t opcode) /* DIVS */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 61; CurrentInstrCycles = 12; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if (src == 0) { SET_VFLG (0); Exception(5,oldpc,M68000_EXC_SRC_CPU); goto endlabel1133; } else {
	int32_t newv = (int32_t)dst / (int32_t)(int16_t)src;
	uint16_t rem = (int32_t)dst % (int32_t)(int16_t)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((int16_t)rem < 0) != ((int32_t)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivs68kCycles((int32_t)dst, (int16_t)src);
}}}}endlabel1133: ;
 return (12+retcycles);
}
unsigned long CPUFUNC(op_81f9_4)(uint32_t opcode) /* DIVS */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 61; CurrentInstrCycles = 16; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(6);
	if (src == 0) { SET_VFLG (0); Exception(5,oldpc,M68000_EXC_SRC_CPU); goto endlabel1134; } else {
	int32_t newv = (int32_t)dst / (int32_t)(int16_t)src;
	uint16_t rem = (int32_t)dst % (int32_t)(int16_t)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((int16_t)rem < 0) != ((int32_t)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivs68kCycles((int32_t)dst, (int16_t)src);
}}}}endlabel1134: ;
 return (16+retcycles);
}
unsigned long CPUFUNC(op_81fa_4)(uint32_t opcode) /* DIVS */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 61; CurrentInstrCycles = 12; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if (src == 0) { SET_VFLG (0); Exception(5,oldpc,M68000_EXC_SRC_CPU); goto endlabel1135; } else {
	int32_t newv = (int32_t)dst / (int32_t)(int16_t)src;
	uint16_t rem = (int32_t)dst % (int32_t)(int16_t)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((int16_t)rem < 0) != ((int32_t)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivs68kCycles((int32_t)dst, (int16_t)src);
}}}}endlabel1135: ;
 return (12+retcycles);
}
unsigned long CPUFUNC(op_81fb_4)(uint32_t opcode) /* DIVS */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 61; CurrentInstrCycles = 14; 
{	uint32_t oldpc = m68k_getpc();
{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if (src == 0) { SET_VFLG (0); Exception(5,oldpc,M68000_EXC_SRC_CPU); goto endlabel1136; } else {
	int32_t newv = (int32_t)dst / (int32_t)(int16_t)src;
	uint16_t rem = (int32_t)dst % (int32_t)(int16_t)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((int16_t)rem < 0) != ((int32_t)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivs68kCycles((int32_t)dst, (int16_t)src);
}}}}endlabel1136: ;
 return (14+retcycles);
}
unsigned long CPUFUNC(op_81fc_4)(uint32_t opcode) /* DIVS */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 61; CurrentInstrCycles = 8;  
{	uint32_t oldpc = m68k_getpc();
{	int16_t src = get_iword(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	if (src == 0) { SET_VFLG (0); Exception(5,oldpc,M68000_EXC_SRC_CPU); goto endlabel1137; } else {
	int32_t newv = (int32_t)dst / (int32_t)(int16_t)src;
	uint16_t rem = (int32_t)dst % (int32_t)(int16_t)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((int16_t)rem < 0) != ((int32_t)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_NFLG (((int16_t)(newv)) < 0);
	newv = (newv & 0xffff) | ((uint32_t)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
	retcycles = getDivs68kCycles((int32_t)dst, (int16_t)src);
}}}endlabel1137: ;
 return (8+retcycles);
}
unsigned long CPUFUNC(op_9000_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_9010_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_9018_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_9020_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_9028_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_9030_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_9038_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_9039_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_903a_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_903b_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_903c_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_9040_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_9048_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_areg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_9050_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_9058_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_9060_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_9068_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_9070_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_9078_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_9079_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_907a_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_907b_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_907c_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_9080_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_9088_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_areg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_9090_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_9098_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_90a0_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(2);
return 16;
}
unsigned long CPUFUNC(op_90a8_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_90b0_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_90b8_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 18; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_90b9_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_90ba_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_90bb_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_90bc_4)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_90c0_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 8;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_90c8_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 8;  
{{	int16_t src = m68k_areg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_90d0_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_90d8_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_90e0_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_90e8_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_90f0_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_90f8_4)(uint32_t opcode) /* SUBA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_90f9_4)(uint32_t opcode) /* SUBA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_90fa_4)(uint32_t opcode) /* SUBA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_90fb_4)(uint32_t opcode) /* SUBA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_90fc_4)(uint32_t opcode) /* SUBA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_9100_4)(uint32_t opcode) /* SUBX */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 9; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = dst - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_9108_4)(uint32_t opcode) /* SUBX */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 9; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uint32_t newv = dst - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 18;
}
unsigned long CPUFUNC(op_9110_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_9118_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_9120_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_9128_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_9130_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_9138_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_9139_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_9140_4)(uint32_t opcode) /* SUBX */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 9; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = dst - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int16_t)(newv)) == 0));
	SET_NFLG (((int16_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_9148_4)(uint32_t opcode) /* SUBX */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 9; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uint32_t newv = dst - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int16_t)(newv)) == 0));
	SET_NFLG (((int16_t)(newv)) < 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 18;
}
unsigned long CPUFUNC(op_9150_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_9158_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_9160_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 14; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_9168_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_9170_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 18; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_9178_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_9179_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_9180_4)(uint32_t opcode) /* SUBX */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 9; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = dst - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int32_t)(newv)) == 0));
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_9188_4)(uint32_t opcode) /* SUBX */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 9; CurrentInstrCycles = 30; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uint32_t newv = dst - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int32_t)(newv)) == 0));
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 30;
}
unsigned long CPUFUNC(op_9190_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_9198_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_91a0_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 22; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_91a8_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 24; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_91b0_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 26; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_91b8_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 7; CurrentInstrCycles = 24; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_91b9_4)(uint32_t opcode) /* SUB */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 7; CurrentInstrCycles = 28; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_91c0_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_91c8_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_areg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_91d0_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_91d8_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_91e0_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 16;
}
unsigned long CPUFUNC(op_91e8_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_91f0_4)(uint32_t opcode) /* SUBA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_91f8_4)(uint32_t opcode) /* SUBA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 18; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_91f9_4)(uint32_t opcode) /* SUBA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_91fa_4)(uint32_t opcode) /* SUBA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_91fb_4)(uint32_t opcode) /* SUBA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 20; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_91fc_4)(uint32_t opcode) /* SUBA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 8; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_b000_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_b010_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_b018_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_b020_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_b028_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_b030_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_b038_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_b039_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_b03a_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_b03b_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 14;
}
#endif

#ifdef PART_7
unsigned long CPUFUNC(op_b03c_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_b040_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_b048_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_areg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_b050_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_b058_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_b060_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_b068_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_b070_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_b078_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_b079_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_b07a_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_b07b_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_b07c_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_b080_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 6;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_b088_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 6;  
{{	int32_t src = m68k_areg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_b090_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_b098_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_b0a0_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 16;
}
unsigned long CPUFUNC(op_b0a8_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_b0b0_4)(uint32_t opcode) /* CMP */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_b0b8_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 18; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_b0b9_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_b0ba_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_b0bb_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 20; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_b0bc_4)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(6);
return 14;
}
unsigned long CPUFUNC(op_b0c0_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 6;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_b0c8_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 6;  
{{	int16_t src = m68k_areg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_b0d0_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_b0d8_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_b0e0_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_b0e8_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_b0f0_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_b0f8_4)(uint32_t opcode) /* CMPA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 14; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_b0f9_4)(uint32_t opcode) /* CMPA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 18;
}
unsigned long CPUFUNC(op_b0fa_4)(uint32_t opcode) /* CMPA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_b0fb_4)(uint32_t opcode) /* CMPA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 16; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_b0fc_4)(uint32_t opcode) /* CMPA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 10; 
{{	int16_t src = get_iword(2);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(4);
return 10;
}
unsigned long CPUFUNC(op_b100_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_b108_4)(uint32_t opcode) /* CMPM */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 26; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_b110_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_b118_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_b120_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_b128_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_b130_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_b138_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_b139_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 3; CurrentInstrCycles = 20; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_b140_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_b148_4)(uint32_t opcode) /* CMPM */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 26; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_b150_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_b158_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_b160_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 14; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_b168_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_b170_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 18; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_b178_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_b179_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 3; CurrentInstrCycles = 20; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_b180_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_b188_4)(uint32_t opcode) /* CMPM */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 26; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_b190_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 20; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_b198_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 20; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_b1a0_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 22; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_b1a8_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 24; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_b1b0_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 26; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_b1b8_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 3; CurrentInstrCycles = 24; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_b1b9_4)(uint32_t opcode) /* EOR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 3; CurrentInstrCycles = 28; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_b1c0_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 6;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_b1c8_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 6;  
{{	int32_t src = m68k_areg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_b1d0_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_b1d8_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_b1e0_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 16;
}
unsigned long CPUFUNC(op_b1e8_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_b1f0_4)(uint32_t opcode) /* CMPA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_b1f8_4)(uint32_t opcode) /* CMPA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 18; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_b1f9_4)(uint32_t opcode) /* CMPA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_b1fa_4)(uint32_t opcode) /* CMPA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_b1fb_4)(uint32_t opcode) /* CMPA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 20; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_b1fc_4)(uint32_t opcode) /* CMPA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 27; CurrentInstrCycles = 14; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_areg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(6);
return 14;
}
unsigned long CPUFUNC(op_c000_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_c010_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_c018_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_c020_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_c028_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_c030_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_c038_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_c039_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_c03a_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_c03b_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_c03c_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_c040_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_c050_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_c058_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_c060_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_c068_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_c070_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_c078_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_c079_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_c07a_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_c07b_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_c07c_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_c080_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_c090_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_c098_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_c0a0_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 16;
}
unsigned long CPUFUNC(op_c0a8_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_c0b0_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_c0b8_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 18; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_c0b9_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_c0ba_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_c0bb_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_c0bc_4)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_c0c0_4)(uint32_t opcode) /* MULU */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 62; CurrentInstrCycles = 38; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (uint32_t)(uint16_t)dst * (uint32_t)(uint16_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	while (src) { if (src & 1) retcycles++; src = (uint16_t)src >> 1; }
}}}}m68k_incpc(2);
 return (38+retcycles*2);
}
unsigned long CPUFUNC(op_c0d0_4)(uint32_t opcode) /* MULU */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 62; CurrentInstrCycles = 42; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (uint32_t)(uint16_t)dst * (uint32_t)(uint16_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	while (src) { if (src & 1) retcycles++; src = (uint16_t)src >> 1; }
}}}}}m68k_incpc(2);
 return (42+retcycles*2);
}
unsigned long CPUFUNC(op_c0d8_4)(uint32_t opcode) /* MULU */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 62; CurrentInstrCycles = 42; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (uint32_t)(uint16_t)dst * (uint32_t)(uint16_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	while (src) { if (src & 1) retcycles++; src = (uint16_t)src >> 1; }
}}}}}m68k_incpc(2);
 return (42+retcycles*2);
}
unsigned long CPUFUNC(op_c0e0_4)(uint32_t opcode) /* MULU */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 62; CurrentInstrCycles = 44; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (uint32_t)(uint16_t)dst * (uint32_t)(uint16_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	while (src) { if (src & 1) retcycles++; src = (uint16_t)src >> 1; }
}}}}}m68k_incpc(2);
 return (44+retcycles*2);
}
unsigned long CPUFUNC(op_c0e8_4)(uint32_t opcode) /* MULU */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 62; CurrentInstrCycles = 46; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (uint32_t)(uint16_t)dst * (uint32_t)(uint16_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	while (src) { if (src & 1) retcycles++; src = (uint16_t)src >> 1; }
}}}}}m68k_incpc(4);
 return (46+retcycles*2);
}
unsigned long CPUFUNC(op_c0f0_4)(uint32_t opcode) /* MULU */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 62; CurrentInstrCycles = 48; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (uint32_t)(uint16_t)dst * (uint32_t)(uint16_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	while (src) { if (src & 1) retcycles++; src = (uint16_t)src >> 1; }
}}}}}m68k_incpc(4);
 return (48+retcycles*2);
}
unsigned long CPUFUNC(op_c0f8_4)(uint32_t opcode) /* MULU */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 62; CurrentInstrCycles = 46; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (uint32_t)(uint16_t)dst * (uint32_t)(uint16_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	while (src) { if (src & 1) retcycles++; src = (uint16_t)src >> 1; }
}}}}}m68k_incpc(4);
 return (46+retcycles*2);
}
unsigned long CPUFUNC(op_c0f9_4)(uint32_t opcode) /* MULU */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 62; CurrentInstrCycles = 50; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (uint32_t)(uint16_t)dst * (uint32_t)(uint16_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	while (src) { if (src & 1) retcycles++; src = (uint16_t)src >> 1; }
}}}}}m68k_incpc(6);
 return (50+retcycles*2);
}
unsigned long CPUFUNC(op_c0fa_4)(uint32_t opcode) /* MULU */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 62; CurrentInstrCycles = 46; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (uint32_t)(uint16_t)dst * (uint32_t)(uint16_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	while (src) { if (src & 1) retcycles++; src = (uint16_t)src >> 1; }
}}}}}m68k_incpc(4);
 return (46+retcycles*2);
}
unsigned long CPUFUNC(op_c0fb_4)(uint32_t opcode) /* MULU */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 62; CurrentInstrCycles = 48; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (uint32_t)(uint16_t)dst * (uint32_t)(uint16_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	while (src) { if (src & 1) retcycles++; src = (uint16_t)src >> 1; }
}}}}}m68k_incpc(4);
 return (48+retcycles*2);
}
unsigned long CPUFUNC(op_c0fc_4)(uint32_t opcode) /* MULU */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 62; CurrentInstrCycles = 42; 
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (uint32_t)(uint16_t)dst * (uint32_t)(uint16_t)src;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	while (src) { if (src & 1) retcycles++; src = (uint16_t)src >> 1; }
}}}}m68k_incpc(4);
 return (42+retcycles*2);
}
unsigned long CPUFUNC(op_c100_4)(uint32_t opcode) /* ABCD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 14; CurrentInstrCycles = 6;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	uint16_t newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG ? 1 : 0);
	uint16_t newv_hi = (src & 0xF0) + (dst & 0xF0);
	uint16_t newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;	if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG (cflg);
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) == 0 && (newv & 0x80) != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_c108_4)(uint32_t opcode) /* ABCD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 14; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uint16_t newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG ? 1 : 0);
	uint16_t newv_hi = (src & 0xF0) + (dst & 0xF0);
	uint16_t newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;	if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG (cflg);
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) == 0 && (newv & 0x80) != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}m68k_incpc(2);
return 18;
}
unsigned long CPUFUNC(op_c110_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_c118_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_c120_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_c128_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_c130_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_c138_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_c139_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_write_memory_8(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_c140_4)(uint32_t opcode) /* EXG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 35; CurrentInstrCycles = 6;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_c148_4)(uint32_t opcode) /* EXG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 35; CurrentInstrCycles = 6;  
{{	int32_t src = m68k_areg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
	m68k_areg(regs, srcreg) = (dst);
	m68k_areg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_c150_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_c158_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_c160_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 14; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_c168_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_c170_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 18; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_c178_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_c179_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_write_memory_16(dsta,src);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_c188_4)(uint32_t opcode) /* EXG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 35; CurrentInstrCycles = 6;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_areg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 6;
}
unsigned long CPUFUNC(op_c190_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_c198_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_c1a0_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 22; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_c1a8_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 24; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_c1b0_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 26; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_c1b8_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 2; CurrentInstrCycles = 24; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_c1b9_4)(uint32_t opcode) /* AND */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 2; CurrentInstrCycles = 28; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_write_memory_32(dsta,src);
}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_c1c0_4)(uint32_t opcode) /* MULS */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 63; CurrentInstrCycles = 38; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (int32_t)(int16_t)dst * (int32_t)(int16_t)src;
	uint32_t src2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	src2 = ((uint32_t)src) << 1;
	while (src2) { if ( ( (src2 & 3) == 1 ) || ( (src2 & 3) == 2 ) ) retcycles++; src2 >>= 1; }
}}}}m68k_incpc(2);
 return (38+retcycles*2);
}
unsigned long CPUFUNC(op_c1d0_4)(uint32_t opcode) /* MULS */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 63; CurrentInstrCycles = 42; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (int32_t)(int16_t)dst * (int32_t)(int16_t)src;
	uint32_t src2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	src2 = ((uint32_t)src) << 1;
	while (src2) { if ( ( (src2 & 3) == 1 ) || ( (src2 & 3) == 2 ) ) retcycles++; src2 >>= 1; }
}}}}}m68k_incpc(2);
 return (42+retcycles*2);
}
unsigned long CPUFUNC(op_c1d8_4)(uint32_t opcode) /* MULS */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 63; CurrentInstrCycles = 42; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (int32_t)(int16_t)dst * (int32_t)(int16_t)src;
	uint32_t src2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	src2 = ((uint32_t)src) << 1;
	while (src2) { if ( ( (src2 & 3) == 1 ) || ( (src2 & 3) == 2 ) ) retcycles++; src2 >>= 1; }
}}}}}m68k_incpc(2);
 return (42+retcycles*2);
}
unsigned long CPUFUNC(op_c1e0_4)(uint32_t opcode) /* MULS */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 63; CurrentInstrCycles = 44; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (int32_t)(int16_t)dst * (int32_t)(int16_t)src;
	uint32_t src2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	src2 = ((uint32_t)src) << 1;
	while (src2) { if ( ( (src2 & 3) == 1 ) || ( (src2 & 3) == 2 ) ) retcycles++; src2 >>= 1; }
}}}}}m68k_incpc(2);
 return (44+retcycles*2);
}
unsigned long CPUFUNC(op_c1e8_4)(uint32_t opcode) /* MULS */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 63; CurrentInstrCycles = 46; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (int32_t)(int16_t)dst * (int32_t)(int16_t)src;
	uint32_t src2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	src2 = ((uint32_t)src) << 1;
	while (src2) { if ( ( (src2 & 3) == 1 ) || ( (src2 & 3) == 2 ) ) retcycles++; src2 >>= 1; }
}}}}}m68k_incpc(4);
 return (46+retcycles*2);
}
unsigned long CPUFUNC(op_c1f0_4)(uint32_t opcode) /* MULS */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 63; CurrentInstrCycles = 48; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (int32_t)(int16_t)dst * (int32_t)(int16_t)src;
	uint32_t src2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	src2 = ((uint32_t)src) << 1;
	while (src2) { if ( ( (src2 & 3) == 1 ) || ( (src2 & 3) == 2 ) ) retcycles++; src2 >>= 1; }
}}}}}m68k_incpc(4);
 return (48+retcycles*2);
}
unsigned long CPUFUNC(op_c1f8_4)(uint32_t opcode) /* MULS */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 63; CurrentInstrCycles = 46; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (int32_t)(int16_t)dst * (int32_t)(int16_t)src;
	uint32_t src2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	src2 = ((uint32_t)src) << 1;
	while (src2) { if ( ( (src2 & 3) == 1 ) || ( (src2 & 3) == 2 ) ) retcycles++; src2 >>= 1; }
}}}}}m68k_incpc(4);
 return (46+retcycles*2);
}
unsigned long CPUFUNC(op_c1f9_4)(uint32_t opcode) /* MULS */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 63; CurrentInstrCycles = 50; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (int32_t)(int16_t)dst * (int32_t)(int16_t)src;
	uint32_t src2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	src2 = ((uint32_t)src) << 1;
	while (src2) { if ( ( (src2 & 3) == 1 ) || ( (src2 & 3) == 2 ) ) retcycles++; src2 >>= 1; }
}}}}}m68k_incpc(6);
 return (50+retcycles*2);
}
unsigned long CPUFUNC(op_c1fa_4)(uint32_t opcode) /* MULS */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 63; CurrentInstrCycles = 46; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (int32_t)(int16_t)dst * (int32_t)(int16_t)src;
	uint32_t src2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	src2 = ((uint32_t)src) << 1;
	while (src2) { if ( ( (src2 & 3) == 1 ) || ( (src2 & 3) == 2 ) ) retcycles++; src2 >>= 1; }
}}}}}m68k_incpc(4);
 return (46+retcycles*2);
}
unsigned long CPUFUNC(op_c1fb_4)(uint32_t opcode) /* MULS */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 63; CurrentInstrCycles = 48; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (int32_t)(int16_t)dst * (int32_t)(int16_t)src;
	uint32_t src2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	src2 = ((uint32_t)src) << 1;
	while (src2) { if ( ( (src2 & 3) == 1 ) || ( (src2 & 3) == 2 ) ) retcycles++; src2 >>= 1; }
}}}}}m68k_incpc(4);
 return (48+retcycles*2);
}
unsigned long CPUFUNC(op_c1fc_4)(uint32_t opcode) /* MULS */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 63; CurrentInstrCycles = 42; 
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = (int32_t)(int16_t)dst * (int32_t)(int16_t)src;
	uint32_t src2;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	src2 = ((uint32_t)src) << 1;
	while (src2) { if ( ( (src2 & 3) == 1 ) || ( (src2 & 3) == 2 ) ) retcycles++; src2 >>= 1; }
}}}}m68k_incpc(4);
 return (42+retcycles*2);
}
unsigned long CPUFUNC(op_d000_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_d010_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_d018_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_d020_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_d028_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_d030_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_d038_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_d039_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_d03a_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_d03b_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_d03c_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_d040_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_d048_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_areg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_d050_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_d058_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_d060_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long CPUFUNC(op_d068_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_d070_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_d078_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_d079_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_d07a_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_d07b_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 14;
}
unsigned long CPUFUNC(op_d07c_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long CPUFUNC(op_d080_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_d088_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_areg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_d090_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_d098_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_d0a0_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(2);
return 16;
}
unsigned long CPUFUNC(op_d0a8_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_d0b0_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_d0b8_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 18; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_d0b9_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_d0ba_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_d0bb_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_d0bc_4)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_d0c0_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 8;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_d0c8_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 8;  
{{	int16_t src = m68k_areg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_d0d0_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_d0d8_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg(regs, srcreg) += 2;
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_d0e0_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_d0e8_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_d0f0_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_d0f8_4)(uint32_t opcode) /* ADDA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_d0f9_4)(uint32_t opcode) /* ADDA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_d0fa_4)(uint32_t opcode) /* ADDA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_d0fb_4)(uint32_t opcode) /* ADDA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int16_t src = m68k_read_memory_16(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_d0fc_4)(uint32_t opcode) /* ADDA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword(2);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(4);
return 12;
}
unsigned long CPUFUNC(op_d100_4)(uint32_t opcode) /* ADDX */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 13; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = dst + src + (GET_XFLG ? 1 : 0);
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_d108_4)(uint32_t opcode) /* ADDX */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 13; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uint32_t newv = dst + src + (GET_XFLG ? 1 : 0);
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int8_t)(newv)) == 0));
	SET_NFLG (((int8_t)(newv)) < 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 18;
}
unsigned long CPUFUNC(op_d110_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_d118_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_d120_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_d128_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_d130_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_d138_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_d139_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_8(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_d140_4)(uint32_t opcode) /* ADDX */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 13; CurrentInstrCycles = 4;  
{{	int16_t src = m68k_dreg(regs, srcreg);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = dst + src + (GET_XFLG ? 1 : 0);
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int16_t)(newv)) == 0));
	SET_NFLG (((int16_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}m68k_incpc(2);
return 4;
}
unsigned long CPUFUNC(op_d148_4)(uint32_t opcode) /* ADDX */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 13; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 2;
{	int16_t src = m68k_read_memory_16(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uint32_t newv = dst + src + (GET_XFLG ? 1 : 0);
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int16_t)(newv)) == 0));
	SET_NFLG (((int16_t)(newv)) < 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 18;
}
unsigned long CPUFUNC(op_d150_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_d158_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 12; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_d160_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 14; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_d168_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_d170_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 18; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_d178_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_d179_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	int16_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_16(dsta,newv);
}}}}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_d180_4)(uint32_t opcode) /* ADDX */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 13; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	uint32_t newv = dst + src + (GET_XFLG ? 1 : 0);
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int32_t)(newv)) == 0));
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_d188_4)(uint32_t opcode) /* ADDX */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 13; CurrentInstrCycles = 30; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uint32_t newv = dst + src + (GET_XFLG ? 1 : 0);
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((int32_t)(newv)) == 0));
	SET_NFLG (((int32_t)(newv)) < 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 30;
}
unsigned long CPUFUNC(op_d190_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_d198_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 20;
}
unsigned long CPUFUNC(op_d1a0_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 22; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(2);
return 22;
}
unsigned long CPUFUNC(op_d1a8_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 24; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_d1b0_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 26; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(4);
return 26;
}
unsigned long CPUFUNC(op_d1b8_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 11; CurrentInstrCycles = 24; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword(2);
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(4);
return 24;
}
unsigned long CPUFUNC(op_d1b9_4)(uint32_t opcode) /* ADD */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 11; CurrentInstrCycles = 28; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong(2);
{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_write_memory_32(dsta,newv);
}}}}}}}m68k_incpc(6);
return 28;
}
unsigned long CPUFUNC(op_d1c0_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_d1c8_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_areg(regs, srcreg);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 8;
}
unsigned long CPUFUNC(op_d1d0_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 14;
}
#endif

#ifdef PART_8
unsigned long CPUFUNC(op_d1d8_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg(regs, srcreg) += 4;
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_d1e0_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - 4;
{	int32_t src = m68k_read_memory_32(srca);
	m68k_areg (regs, srcreg) = srca;
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 16;
}
unsigned long CPUFUNC(op_d1e8_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_d1f0_4)(uint32_t opcode) /* ADDA */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_d1f8_4)(uint32_t opcode) /* ADDA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 18; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_d1f9_4)(uint32_t opcode) /* ADDA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_ilong(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(6);
return 22;
}
unsigned long CPUFUNC(op_d1fa_4)(uint32_t opcode) /* ADDA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword(2);
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_d1fb_4)(uint32_t opcode) /* ADDA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 20; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword(2));
	BusCyclePenalty += 2;
{	int32_t src = m68k_read_memory_32(srca);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 20;
}
unsigned long CPUFUNC(op_d1fc_4)(uint32_t opcode) /* ADDA */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 12; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong(2);
{	int32_t dst = m68k_areg(regs, dstreg);
{	uint32_t newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(6);
return 16;
}
unsigned long CPUFUNC(op_e000_4)(uint32_t opcode) /* ASR */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 64; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	uint32_t sign = (0x80 & val) >> 7;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 8) {
		val = 0xff & (uint32_t)-sign;
		SET_CFLG (sign);
	COPY_CARRY;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
		val |= (0xff << (8 - cnt)) & (uint32_t)-sign;
		val &= 0xff;
	}
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e008_4)(uint32_t opcode) /* LSR */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 66; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 8) {
		SET_CFLG ((cnt == 8) & (val >> 7));
	COPY_CARRY;
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
	}
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e010_4)(uint32_t opcode) /* ROXR */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 71; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
{	cnt--;
	{
	uint32_t carry;
	uint32_t hival = (val << 1) | GET_XFLG;
	hival <<= (7 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e018_4)(uint32_t opcode) /* ROR */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 69; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
{	uint32_t hival;
	cnt &= 7;
	hival = val << (8 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xff;
	SET_CFLG ((val & 0x80) >> 7);
	}
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e020_4)(uint32_t opcode) /* ASR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 64; CurrentInstrCycles = 4;  
{{	int8_t cnt = m68k_dreg(regs, srcreg);
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	uint32_t sign = (0x80 & val) >> 7;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 8) {
		val = 0xff & (uint32_t)-sign;
		SET_CFLG (sign);
	COPY_CARRY;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
		val |= (0xff << (8 - cnt)) & (uint32_t)-sign;
		val &= 0xff;
	}
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e028_4)(uint32_t opcode) /* LSR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 66; CurrentInstrCycles = 4;  
{{	int8_t cnt = m68k_dreg(regs, srcreg);
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 8) {
		SET_CFLG ((cnt == 8) & (val >> 7));
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
	}
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e030_4)(uint32_t opcode) /* ROXR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 71; CurrentInstrCycles = 4;  
{{	int8_t cnt = m68k_dreg(regs, srcreg);
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 36) cnt -= 36;
	if (cnt >= 18) cnt -= 18;
	if (cnt >= 9) cnt -= 9;
	if (cnt > 0) {
	cnt--;
	{
	uint32_t carry;
	uint32_t hival = (val << 1) | GET_XFLG;
	hival <<= (7 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e038_4)(uint32_t opcode) /* ROR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 69; CurrentInstrCycles = 4;  
{{	int8_t cnt = m68k_dreg(regs, srcreg);
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt > 0) {	uint32_t hival;
	cnt &= 7;
	hival = val << (8 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xff;
	SET_CFLG ((val & 0x80) >> 7);
	}
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e040_4)(uint32_t opcode) /* ASR */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 64; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	uint32_t sign = (0x8000 & val) >> 15;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 16) {
		val = 0xffff & (uint32_t)-sign;
		SET_CFLG (sign);
	COPY_CARRY;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
		val |= (0xffff << (16 - cnt)) & (uint32_t)-sign;
		val &= 0xffff;
	}
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e048_4)(uint32_t opcode) /* LSR */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 66; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 16) {
		SET_CFLG ((cnt == 16) & (val >> 15));
	COPY_CARRY;
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
	}
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e050_4)(uint32_t opcode) /* ROXR */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 71; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
{	cnt--;
	{
	uint32_t carry;
	uint32_t hival = (val << 1) | GET_XFLG;
	hival <<= (15 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e058_4)(uint32_t opcode) /* ROR */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 69; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
{	uint32_t hival;
	cnt &= 15;
	hival = val << (16 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffff;
	SET_CFLG ((val & 0x8000) >> 15);
	}
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e060_4)(uint32_t opcode) /* ASR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 64; CurrentInstrCycles = 4;  
{{	int16_t cnt = m68k_dreg(regs, srcreg);
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	uint32_t sign = (0x8000 & val) >> 15;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 16) {
		val = 0xffff & (uint32_t)-sign;
		SET_CFLG (sign);
	COPY_CARRY;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
		val |= (0xffff << (16 - cnt)) & (uint32_t)-sign;
		val &= 0xffff;
	}
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e068_4)(uint32_t opcode) /* LSR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 66; CurrentInstrCycles = 4;  
{{	int16_t cnt = m68k_dreg(regs, srcreg);
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 16) {
		SET_CFLG ((cnt == 16) & (val >> 15));
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
	}
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e070_4)(uint32_t opcode) /* ROXR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 71; CurrentInstrCycles = 4;  
{{	int16_t cnt = m68k_dreg(regs, srcreg);
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 34) cnt -= 34;
	if (cnt >= 17) cnt -= 17;
	if (cnt > 0) {
	cnt--;
	{
	uint32_t carry;
	uint32_t hival = (val << 1) | GET_XFLG;
	hival <<= (15 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e078_4)(uint32_t opcode) /* ROR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 69; CurrentInstrCycles = 4;  
{{	int16_t cnt = m68k_dreg(regs, srcreg);
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt > 0) {	uint32_t hival;
	cnt &= 15;
	hival = val << (16 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffff;
	SET_CFLG ((val & 0x8000) >> 15);
	}
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e080_4)(uint32_t opcode) /* ASR */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 64; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	uint32_t sign = (0x80000000 & val) >> 31;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 32) {
		val = 0xffffffff & (uint32_t)-sign;
		SET_CFLG (sign);
	COPY_CARRY;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
		val |= (0xffffffff << (32 - cnt)) & (uint32_t)-sign;
		val &= 0xffffffff;
	}
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e088_4)(uint32_t opcode) /* LSR */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 66; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 32) {
		SET_CFLG ((cnt == 32) & (val >> 31));
	COPY_CARRY;
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
	}
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e090_4)(uint32_t opcode) /* ROXR */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 71; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
{	cnt--;
	{
	uint32_t carry;
	uint32_t hival = (val << 1) | GET_XFLG;
	hival <<= (31 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xffffffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e098_4)(uint32_t opcode) /* ROR */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 69; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
{	uint32_t hival;
	cnt &= 31;
	hival = val << (32 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffffffff;
	SET_CFLG ((val & 0x80000000) >> 31);
	}
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e0a0_4)(uint32_t opcode) /* ASR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 64; CurrentInstrCycles = 4;  
{{	int32_t cnt = m68k_dreg(regs, srcreg);
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	uint32_t sign = (0x80000000 & val) >> 31;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 32) {
		val = 0xffffffff & (uint32_t)-sign;
		SET_CFLG (sign);
	COPY_CARRY;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
		val |= (0xffffffff << (32 - cnt)) & (uint32_t)-sign;
		val &= 0xffffffff;
	}
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e0a8_4)(uint32_t opcode) /* LSR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 66; CurrentInstrCycles = 4;  
{{	int32_t cnt = m68k_dreg(regs, srcreg);
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 32) {
		SET_CFLG ((cnt == 32) & (val >> 31));
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
	}
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e0b0_4)(uint32_t opcode) /* ROXR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 71; CurrentInstrCycles = 4;  
{{	int32_t cnt = m68k_dreg(regs, srcreg);
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 33) cnt -= 33;
	if (cnt > 0) {
	cnt--;
	{
	uint32_t carry;
	uint32_t hival = (val << 1) | GET_XFLG;
	hival <<= (31 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xffffffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e0b8_4)(uint32_t opcode) /* ROR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 69; CurrentInstrCycles = 4;  
{{	int32_t cnt = m68k_dreg(regs, srcreg);
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt > 0) {	uint32_t hival;
	cnt &= 31;
	hival = val << (32 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffffffff;
	SET_CFLG ((val & 0x80000000) >> 31);
	}
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e0d0_4)(uint32_t opcode) /* ASRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 72; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e0d8_4)(uint32_t opcode) /* ASRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 72; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e0e0_4)(uint32_t opcode) /* ASRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 72; CurrentInstrCycles = 14; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) - 2;
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_e0e8_4)(uint32_t opcode) /* ASRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 72; CurrentInstrCycles = 16; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e0f0_4)(uint32_t opcode) /* ASRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 72; CurrentInstrCycles = 18; 
{{	uint32_t dataa = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_e0f8_4)(uint32_t opcode) /* ASRW */
{
	OpcodeFamily = 72; CurrentInstrCycles = 16; 
{{	uint32_t dataa = (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e0f9_4)(uint32_t opcode) /* ASRW */
{
	OpcodeFamily = 72; CurrentInstrCycles = 20; 
{{	uint32_t dataa = get_ilong(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_e100_4)(uint32_t opcode) /* ASL */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 65; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 8) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 8 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else {
		uint32_t mask = (0xff << (7 - cnt)) & 0xff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x80) >> 7);
	COPY_CARRY;
		val <<= 1;
		val &= 0xff;
	}
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e108_4)(uint32_t opcode) /* LSL */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 67; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 8) {
		SET_CFLG (cnt == 8 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x80) >> 7);
	COPY_CARRY;
		val <<= 1;
	val &= 0xff;
	}
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e110_4)(uint32_t opcode) /* ROXL */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 70; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
{	cnt--;
	{
	uint32_t carry;
	uint32_t loval = val >> (7 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e118_4)(uint32_t opcode) /* ROL */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 68; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
{	uint32_t loval;
	cnt &= 7;
	loval = val >> (8 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e120_4)(uint32_t opcode) /* ASL */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 65; CurrentInstrCycles = 4;  
{{	int8_t cnt = m68k_dreg(regs, srcreg);
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 8) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 8 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		uint32_t mask = (0xff << (7 - cnt)) & 0xff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x80) >> 7);
	COPY_CARRY;
		val <<= 1;
		val &= 0xff;
	}
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e128_4)(uint32_t opcode) /* LSL */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 67; CurrentInstrCycles = 4;  
{{	int8_t cnt = m68k_dreg(regs, srcreg);
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 8) {
		SET_CFLG (cnt == 8 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x80) >> 7);
	COPY_CARRY;
		val <<= 1;
	val &= 0xff;
	}
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e130_4)(uint32_t opcode) /* ROXL */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 70; CurrentInstrCycles = 4;  
{{	int8_t cnt = m68k_dreg(regs, srcreg);
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 36) cnt -= 36;
	if (cnt >= 18) cnt -= 18;
	if (cnt >= 9) cnt -= 9;
	if (cnt > 0) {
	cnt--;
	{
	uint32_t carry;
	uint32_t loval = val >> (7 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e138_4)(uint32_t opcode) /* ROL */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 68; CurrentInstrCycles = 4;  
{{	int8_t cnt = m68k_dreg(regs, srcreg);
{	int8_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint8_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt > 0) {
	uint32_t loval;
	cnt &= 7;
	loval = val >> (8 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((int8_t)(val)) == 0);
	SET_NFLG (((int8_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e140_4)(uint32_t opcode) /* ASL */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 65; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 16) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 16 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else {
		uint32_t mask = (0xffff << (15 - cnt)) & 0xffff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x8000) >> 15);
	COPY_CARRY;
		val <<= 1;
		val &= 0xffff;
	}
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e148_4)(uint32_t opcode) /* LSL */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 67; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 16) {
		SET_CFLG (cnt == 16 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x8000) >> 15);
	COPY_CARRY;
		val <<= 1;
	val &= 0xffff;
	}
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e150_4)(uint32_t opcode) /* ROXL */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 70; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
{	cnt--;
	{
	uint32_t carry;
	uint32_t loval = val >> (15 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e158_4)(uint32_t opcode) /* ROL */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 68; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
{	uint32_t loval;
	cnt &= 15;
	loval = val >> (16 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xffff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e160_4)(uint32_t opcode) /* ASL */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 65; CurrentInstrCycles = 4;  
{{	int16_t cnt = m68k_dreg(regs, srcreg);
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 16) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 16 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		uint32_t mask = (0xffff << (15 - cnt)) & 0xffff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x8000) >> 15);
	COPY_CARRY;
		val <<= 1;
		val &= 0xffff;
	}
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e168_4)(uint32_t opcode) /* LSL */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 67; CurrentInstrCycles = 4;  
{{	int16_t cnt = m68k_dreg(regs, srcreg);
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 16) {
		SET_CFLG (cnt == 16 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x8000) >> 15);
	COPY_CARRY;
		val <<= 1;
	val &= 0xffff;
	}
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e170_4)(uint32_t opcode) /* ROXL */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 70; CurrentInstrCycles = 4;  
{{	int16_t cnt = m68k_dreg(regs, srcreg);
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 34) cnt -= 34;
	if (cnt >= 17) cnt -= 17;
	if (cnt > 0) {
	cnt--;
	{
	uint32_t carry;
	uint32_t loval = val >> (15 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e178_4)(uint32_t opcode) /* ROL */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 68; CurrentInstrCycles = 4;  
{{	int16_t cnt = m68k_dreg(regs, srcreg);
{	int16_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = (uint16_t)data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt > 0) {
	uint32_t loval;
	cnt &= 15;
	loval = val >> (16 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xffff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
 return (6+retcycles*2);
}
unsigned long CPUFUNC(op_e180_4)(uint32_t opcode) /* ASL */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 65; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 32) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 32 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else {
		uint32_t mask = (0xffffffff << (31 - cnt)) & 0xffffffff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x80000000) >> 31);
	COPY_CARRY;
		val <<= 1;
		val &= 0xffffffff;
	}
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e188_4)(uint32_t opcode) /* LSL */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 67; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 32) {
		SET_CFLG (cnt == 32 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x80000000) >> 31);
	COPY_CARRY;
		val <<= 1;
	val &= 0xffffffff;
	}
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e190_4)(uint32_t opcode) /* ROXL */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 70; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
{	cnt--;
	{
	uint32_t carry;
	uint32_t loval = val >> (31 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xffffffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e198_4)(uint32_t opcode) /* ROL */
{
	uint32_t srcreg = imm8_table[((opcode >> 9) & 7)];
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 68; CurrentInstrCycles = 4;  
{{	uint32_t cnt = srcreg;
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
{	uint32_t loval;
	cnt &= 31;
	loval = val >> (32 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xffffffff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e1a0_4)(uint32_t opcode) /* ASL */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 65; CurrentInstrCycles = 4;  
{{	int32_t cnt = m68k_dreg(regs, srcreg);
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 32) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 32 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		uint32_t mask = (0xffffffff << (31 - cnt)) & 0xffffffff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x80000000) >> 31);
	COPY_CARRY;
		val <<= 1;
		val &= 0xffffffff;
	}
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e1a8_4)(uint32_t opcode) /* LSL */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 67; CurrentInstrCycles = 4;  
{{	int32_t cnt = m68k_dreg(regs, srcreg);
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 32) {
		SET_CFLG (cnt == 32 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x80000000) >> 31);
	COPY_CARRY;
		val <<= 1;
	val &= 0xffffffff;
	}
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e1b0_4)(uint32_t opcode) /* ROXL */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 70; CurrentInstrCycles = 4;  
{{	int32_t cnt = m68k_dreg(regs, srcreg);
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt >= 33) cnt -= 33;
	if (cnt > 0) {
	cnt--;
	{
	uint32_t carry;
	uint32_t loval = val >> (31 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xffffffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e1b8_4)(uint32_t opcode) /* ROL */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	unsigned int retcycles = 0;
	OpcodeFamily = 68; CurrentInstrCycles = 4;  
{{	int32_t cnt = m68k_dreg(regs, srcreg);
{	int32_t data = m68k_dreg(regs, dstreg);
{	uint32_t val = data;
	cnt &= 63;
	retcycles = cnt;
	CLEAR_CZNV;
	if (cnt > 0) {
	uint32_t loval;
	cnt &= 31;
	loval = val >> (32 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xffffffff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((int32_t)(val)) == 0);
	SET_NFLG (((int32_t)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
 return (8+retcycles*2);
}
unsigned long CPUFUNC(op_e1d0_4)(uint32_t opcode) /* ASLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 73; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e1d8_4)(uint32_t opcode) /* ASLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 73; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e1e0_4)(uint32_t opcode) /* ASLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 73; CurrentInstrCycles = 14; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) - 2;
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_e1e8_4)(uint32_t opcode) /* ASLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 73; CurrentInstrCycles = 16; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e1f0_4)(uint32_t opcode) /* ASLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 73; CurrentInstrCycles = 18; 
{{	uint32_t dataa = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_e1f8_4)(uint32_t opcode) /* ASLW */
{
	OpcodeFamily = 73; CurrentInstrCycles = 16; 
{{	uint32_t dataa = (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e1f9_4)(uint32_t opcode) /* ASLW */
{
	OpcodeFamily = 73; CurrentInstrCycles = 20; 
{{	uint32_t dataa = get_ilong(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t sign = 0x8000 & val;
	uint32_t sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_e2d0_4)(uint32_t opcode) /* LSRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 74; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e2d8_4)(uint32_t opcode) /* LSRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 74; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uint32_t val = (uint16_t)data;
	uint32_t carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e2e0_4)(uint32_t opcode) /* LSRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 74; CurrentInstrCycles = 14; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) - 2;
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uint32_t val = (uint16_t)data;
	uint32_t carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_e2e8_4)(uint32_t opcode) /* LSRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 74; CurrentInstrCycles = 16; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e2f0_4)(uint32_t opcode) /* LSRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 74; CurrentInstrCycles = 18; 
{{	uint32_t dataa = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_e2f8_4)(uint32_t opcode) /* LSRW */
{
	OpcodeFamily = 74; CurrentInstrCycles = 16; 
{{	uint32_t dataa = (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e2f9_4)(uint32_t opcode) /* LSRW */
{
	OpcodeFamily = 74; CurrentInstrCycles = 20; 
{{	uint32_t dataa = get_ilong(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint32_t val = (uint16_t)data;
	uint32_t carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_e3d0_4)(uint32_t opcode) /* LSLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 75; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e3d8_4)(uint32_t opcode) /* LSLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 75; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e3e0_4)(uint32_t opcode) /* LSLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 75; CurrentInstrCycles = 14; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) - 2;
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_e3e8_4)(uint32_t opcode) /* LSLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 75; CurrentInstrCycles = 16; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e3f0_4)(uint32_t opcode) /* LSLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 75; CurrentInstrCycles = 18; 
{{	uint32_t dataa = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_e3f8_4)(uint32_t opcode) /* LSLW */
{
	OpcodeFamily = 75; CurrentInstrCycles = 16; 
{{	uint32_t dataa = (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e3f9_4)(uint32_t opcode) /* LSLW */
{
	OpcodeFamily = 75; CurrentInstrCycles = 20; 
{{	uint32_t dataa = get_ilong(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_e4d0_4)(uint32_t opcode) /* ROXRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 79; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e4d8_4)(uint32_t opcode) /* ROXRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 79; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e4e0_4)(uint32_t opcode) /* ROXRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 79; CurrentInstrCycles = 14; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) - 2;
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_e4e8_4)(uint32_t opcode) /* ROXRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 79; CurrentInstrCycles = 16; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e4f0_4)(uint32_t opcode) /* ROXRW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 79; CurrentInstrCycles = 18; 
{{	uint32_t dataa = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_e4f8_4)(uint32_t opcode) /* ROXRW */
{
	OpcodeFamily = 79; CurrentInstrCycles = 16; 
{{	uint32_t dataa = (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e4f9_4)(uint32_t opcode) /* ROXRW */
{
	OpcodeFamily = 79; CurrentInstrCycles = 20; 
{{	uint32_t dataa = get_ilong(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_e5d0_4)(uint32_t opcode) /* ROXLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 78; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e5d8_4)(uint32_t opcode) /* ROXLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 78; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e5e0_4)(uint32_t opcode) /* ROXLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 78; CurrentInstrCycles = 14; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) - 2;
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_e5e8_4)(uint32_t opcode) /* ROXLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 78; CurrentInstrCycles = 16; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e5f0_4)(uint32_t opcode) /* ROXLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 78; CurrentInstrCycles = 18; 
{{	uint32_t dataa = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_e5f8_4)(uint32_t opcode) /* ROXLW */
{
	OpcodeFamily = 78; CurrentInstrCycles = 16; 
{{	uint32_t dataa = (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e5f9_4)(uint32_t opcode) /* ROXLW */
{
	OpcodeFamily = 78; CurrentInstrCycles = 20; 
{{	uint32_t dataa = get_ilong(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_e6d0_4)(uint32_t opcode) /* RORW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 77; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e6d8_4)(uint32_t opcode) /* RORW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 77; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e6e0_4)(uint32_t opcode) /* RORW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 77; CurrentInstrCycles = 14; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) - 2;
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_e6e8_4)(uint32_t opcode) /* RORW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 77; CurrentInstrCycles = 16; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e6f0_4)(uint32_t opcode) /* RORW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 77; CurrentInstrCycles = 18; 
{{	uint32_t dataa = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_e6f8_4)(uint32_t opcode) /* RORW */
{
	OpcodeFamily = 77; CurrentInstrCycles = 16; 
{{	uint32_t dataa = (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e6f9_4)(uint32_t opcode) /* RORW */
{
	OpcodeFamily = 77; CurrentInstrCycles = 20; 
{{	uint32_t dataa = get_ilong(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(6);
return 20;
}
unsigned long CPUFUNC(op_e7d0_4)(uint32_t opcode) /* ROLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 76; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e7d8_4)(uint32_t opcode) /* ROLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 76; CurrentInstrCycles = 12; 
{{	uint32_t dataa = m68k_areg(regs, srcreg);
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 12;
}
unsigned long CPUFUNC(op_e7e0_4)(uint32_t opcode) /* ROLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 76; CurrentInstrCycles = 14; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) - 2;
{	int16_t data = m68k_read_memory_16(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(2);
return 14;
}
unsigned long CPUFUNC(op_e7e8_4)(uint32_t opcode) /* ROLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 76; CurrentInstrCycles = 16; 
{{	uint32_t dataa = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e7f0_4)(uint32_t opcode) /* ROLW */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 76; CurrentInstrCycles = 18; 
{{	uint32_t dataa = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
	BusCyclePenalty += 2;
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 18;
}
unsigned long CPUFUNC(op_e7f8_4)(uint32_t opcode) /* ROLW */
{
	OpcodeFamily = 76; CurrentInstrCycles = 16; 
{{	uint32_t dataa = (int32_t)(int16_t)get_iword(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(4);
return 16;
}
unsigned long CPUFUNC(op_e7f9_4)(uint32_t opcode) /* ROLW */
{
	OpcodeFamily = 76; CurrentInstrCycles = 20; 
{{	uint32_t dataa = get_ilong(2);
{	int16_t data = m68k_read_memory_16(dataa);
{	uint16_t val = data;
	uint32_t carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(val)) == 0);
	SET_NFLG (((int16_t)(val)) < 0);
SET_CFLG (carry >> 15);
	m68k_write_memory_16(dataa,val);
}}}}m68k_incpc(6);
return 20;
}
#endif


#if !defined(PART_1) && !defined(PART_2) && !defined(PART_3) && !defined(PART_4) && !defined(PART_5) && !defined(PART_6) && !defined(PART_7) && !defined(PART_8)
#define PART_1 1
#define PART_2 1
#define PART_3 1
#define PART_4 1
#define PART_5 1
#define PART_6 1
#define PART_7 1
#define PART_8 1
#endif

#ifdef PART_1
unsigned long CPUFUNC(op_0_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte_prefetch(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_10_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_18_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_20_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_28_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_30_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 22; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 22;
}
unsigned long CPUFUNC(op_38_5)(uint32_t opcode) /* OR */
{
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_39_5)(uint32_t opcode) /* OR */
{
	OpcodeFamily = 1; CurrentInstrCycles = 24; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 24;
}
unsigned long CPUFUNC(op_3c_5)(uint32_t opcode) /* ORSR */
{
	OpcodeFamily = 4; CurrentInstrCycles = 20; 
{	MakeSR();
{	int16_t src = get_iword_prefetch(2);
	src &= 0xFF;
	regs.sr |= src;
	MakeFromSR();
}}m68k_incpc(4);
fill_prefetch_0 ();
return 20;
}
unsigned long CPUFUNC(op_40_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword_prefetch(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_50_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1591;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1591: ;
return 16;
}
unsigned long CPUFUNC(op_58_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1592;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1592: ;
return 16;
}
unsigned long CPUFUNC(op_60_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1593;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1593: ;
return 18;
}
unsigned long CPUFUNC(op_68_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1594;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1594: ;
return 20;
}
unsigned long CPUFUNC(op_70_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1595;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1595: ;
return 22;
}
unsigned long CPUFUNC(op_78_5)(uint32_t opcode) /* OR */
{
	OpcodeFamily = 1; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1596;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1596: ;
return 20;
}
unsigned long CPUFUNC(op_79_5)(uint32_t opcode) /* OR */
{
	OpcodeFamily = 1; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1597;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1597: ;
return 24;
}
unsigned long CPUFUNC(op_7c_5)(uint32_t opcode) /* ORSR */
{
	OpcodeFamily = 4; CurrentInstrCycles = 20; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel1598; }
{	MakeSR();
{	int16_t src = get_iword_prefetch(2);
	regs.sr |= src;
	MakeFromSR();
}}}m68k_incpc(4);
fill_prefetch_0 ();
endlabel1598: ;
return 20;
}
unsigned long CPUFUNC(op_80_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong_prefetch(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_90_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1600;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1600: ;
return 28;
}
unsigned long CPUFUNC(op_98_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1601;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1601: ;
return 28;
}
unsigned long CPUFUNC(op_a0_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 30; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1602;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1602: ;
return 30;
}
unsigned long CPUFUNC(op_a8_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1603;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1603: ;
return 32;
}
unsigned long CPUFUNC(op_b0_5)(uint32_t opcode) /* OR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 1; CurrentInstrCycles = 34; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(6));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1604;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1604: ;
return 34;
}
unsigned long CPUFUNC(op_b8_5)(uint32_t opcode) /* OR */
{
	OpcodeFamily = 1; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1605;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1605: ;
return 32;
}
unsigned long CPUFUNC(op_b9_5)(uint32_t opcode) /* OR */
{
	OpcodeFamily = 1; CurrentInstrCycles = 36; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 10;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1606;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(10);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1606: ;
return 36;
}
unsigned long CPUFUNC(op_100_5)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 6;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}m68k_incpc(2);
fill_prefetch_2 ();
return 6;
}
unsigned long CPUFUNC(op_108_5)(uint32_t opcode) /* MVPMR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 29; CurrentInstrCycles = 16; 
{	uint32_t memp = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	uint16_t val = (m68k_read_memory_8(memp) << 8) + m68k_read_memory_8(memp + 2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}m68k_incpc(4);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_110_5)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(2);
fill_prefetch_2 ();
return 8;
}
unsigned long CPUFUNC(op_118_5)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(2);
fill_prefetch_2 ();
return 8;
}
unsigned long CPUFUNC(op_120_5)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 10; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(2);
fill_prefetch_2 ();
return 10;
}
unsigned long CPUFUNC(op_128_5)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_130_5)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 14;
}
unsigned long CPUFUNC(op_138_5)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 21; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_139_5)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 21; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_13a_5)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 2;
	OpcodeFamily = 21; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_getpc () + 2;
	dsta += (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_13b_5)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 3;
	OpcodeFamily = 21; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 14;
}
unsigned long CPUFUNC(op_13c_5)(uint32_t opcode) /* BTST */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 21; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	int8_t dst = get_ibyte_prefetch(2);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_140_5)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(2);
fill_prefetch_2 ();
return 8;
}
unsigned long CPUFUNC(op_148_5)(uint32_t opcode) /* MVPMR */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 29; CurrentInstrCycles = 24; 
{	uint32_t memp = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	uint32_t val = (m68k_read_memory_8(memp) << 24) + (m68k_read_memory_8(memp + 2) << 16)
              + (m68k_read_memory_8(memp + 4) << 8) + m68k_read_memory_8(memp + 6);
	m68k_dreg(regs, dstreg) = (val);
}}m68k_incpc(4);
fill_prefetch_0 ();
return 24;
}
unsigned long CPUFUNC(op_150_5)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 12;
}
unsigned long CPUFUNC(op_158_5)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 12;
}
unsigned long CPUFUNC(op_160_5)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 14;
}
unsigned long CPUFUNC(op_168_5)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_170_5)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 18;
}
unsigned long CPUFUNC(op_178_5)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 22; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_179_5)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 22; CurrentInstrCycles = 20; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 20;
}
unsigned long CPUFUNC(op_17a_5)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 2;
	OpcodeFamily = 22; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_getpc () + 2;
	dsta += (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_17b_5)(uint32_t opcode) /* BCHG */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 3;
	OpcodeFamily = 22; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 18;
}
unsigned long CPUFUNC(op_180_5)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 10; 
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	if ( src < 16 ) { m68k_incpc(2); return 8; }
}}}m68k_incpc(2);
fill_prefetch_2 ();
return 10;
}
unsigned long CPUFUNC(op_188_5)(uint32_t opcode) /* MVPRM */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 28; CurrentInstrCycles = 16; 
{{	int16_t src = m68k_dreg(regs, srcreg);
	uint32_t memp = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(2);
	m68k_write_memory_8(memp, src >> 8); m68k_write_memory_8(memp + 2, src);
}}m68k_incpc(4);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_190_5)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 12;
}
unsigned long CPUFUNC(op_198_5)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 12;
}
unsigned long CPUFUNC(op_1a0_5)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 14;
}
unsigned long CPUFUNC(op_1a8_5)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_1b0_5)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 18;
}
unsigned long CPUFUNC(op_1b8_5)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 23; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_1b9_5)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 23; CurrentInstrCycles = 20; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 20;
}
unsigned long CPUFUNC(op_1ba_5)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 2;
	OpcodeFamily = 23; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_getpc () + 2;
	dsta += (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_1bb_5)(uint32_t opcode) /* BCLR */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 3;
	OpcodeFamily = 23; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 18;
}
unsigned long CPUFUNC(op_1c0_5)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 8;  
{{	int32_t src = m68k_dreg(regs, srcreg);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(2);
fill_prefetch_2 ();
return 8;
}
unsigned long CPUFUNC(op_1c8_5)(uint32_t opcode) /* MVPRM */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 28; CurrentInstrCycles = 24; 
{{	int32_t src = m68k_dreg(regs, srcreg);
	uint32_t memp = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(2);
	m68k_write_memory_8(memp, src >> 24); m68k_write_memory_8(memp + 2, src >> 16);
	m68k_write_memory_8(memp + 4, src >> 8); m68k_write_memory_8(memp + 6, src);
}}m68k_incpc(4);
fill_prefetch_0 ();
return 24;
}
unsigned long CPUFUNC(op_1d0_5)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 12;
}
unsigned long CPUFUNC(op_1d8_5)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 12;
}
unsigned long CPUFUNC(op_1e0_5)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 14;
}
unsigned long CPUFUNC(op_1e8_5)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_1f0_5)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 18;
}
unsigned long CPUFUNC(op_1f8_5)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 24; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_1f9_5)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	OpcodeFamily = 24; CurrentInstrCycles = 20; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 20;
}
unsigned long CPUFUNC(op_1fa_5)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 2;
	OpcodeFamily = 24; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_getpc () + 2;
	dsta += (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_1fb_5)(uint32_t opcode) /* BSET */
{
	uint32_t srcreg = ((opcode >> 9) & 7);
	uint32_t dstreg = 3;
	OpcodeFamily = 24; CurrentInstrCycles = 18; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 18;
}
unsigned long CPUFUNC(op_200_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte_prefetch(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_210_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_218_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_220_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_228_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_230_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 22; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 22;
}
unsigned long CPUFUNC(op_238_5)(uint32_t opcode) /* AND */
{
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_239_5)(uint32_t opcode) /* AND */
{
	OpcodeFamily = 2; CurrentInstrCycles = 24; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 24;
}
unsigned long CPUFUNC(op_23c_5)(uint32_t opcode) /* ANDSR */
{
	OpcodeFamily = 5; CurrentInstrCycles = 20; 
{	MakeSR();
{	int16_t src = get_iword_prefetch(2);
	src |= 0xFF00;
	regs.sr &= src;
	MakeFromSR();
}}m68k_incpc(4);
fill_prefetch_0 ();
return 20;
}
unsigned long CPUFUNC(op_240_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword_prefetch(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_250_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1662;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1662: ;
return 16;
}
unsigned long CPUFUNC(op_258_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1663;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1663: ;
return 16;
}
unsigned long CPUFUNC(op_260_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1664;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1664: ;
return 18;
}
unsigned long CPUFUNC(op_268_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1665;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1665: ;
return 20;
}
unsigned long CPUFUNC(op_270_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1666;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1666: ;
return 22;
}
unsigned long CPUFUNC(op_278_5)(uint32_t opcode) /* AND */
{
	OpcodeFamily = 2; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1667;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1667: ;
return 20;
}
unsigned long CPUFUNC(op_279_5)(uint32_t opcode) /* AND */
{
	OpcodeFamily = 2; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1668;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1668: ;
return 24;
}
unsigned long CPUFUNC(op_27c_5)(uint32_t opcode) /* ANDSR */
{
	OpcodeFamily = 5; CurrentInstrCycles = 20; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel1669; }
{	MakeSR();
{	int16_t src = get_iword_prefetch(2);
	regs.sr &= src;
	MakeFromSR();
}}}m68k_incpc(4);
fill_prefetch_0 ();
endlabel1669: ;
return 20;
}
unsigned long CPUFUNC(op_280_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong_prefetch(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_290_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1671;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1671: ;
return 28;
}
unsigned long CPUFUNC(op_298_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1672;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1672: ;
return 28;
}
unsigned long CPUFUNC(op_2a0_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 30; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1673;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1673: ;
return 30;
}
unsigned long CPUFUNC(op_2a8_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1674;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1674: ;
return 32;
}
unsigned long CPUFUNC(op_2b0_5)(uint32_t opcode) /* AND */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 2; CurrentInstrCycles = 34; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(6));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1675;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1675: ;
return 34;
}
unsigned long CPUFUNC(op_2b8_5)(uint32_t opcode) /* AND */
{
	OpcodeFamily = 2; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1676;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1676: ;
return 32;
}
unsigned long CPUFUNC(op_2b9_5)(uint32_t opcode) /* AND */
{
	OpcodeFamily = 2; CurrentInstrCycles = 36; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 10;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1677;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(10);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1677: ;
return 36;
}
unsigned long CPUFUNC(op_400_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte_prefetch(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_410_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 16;
}
unsigned long CPUFUNC(op_418_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 16;
}
unsigned long CPUFUNC(op_420_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 18;
}
unsigned long CPUFUNC(op_428_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 20;
}
unsigned long CPUFUNC(op_430_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 22; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 22;
}
unsigned long CPUFUNC(op_438_5)(uint32_t opcode) /* SUB */
{
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 20;
}
unsigned long CPUFUNC(op_439_5)(uint32_t opcode) /* SUB */
{
	OpcodeFamily = 7; CurrentInstrCycles = 24; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 24;
}
unsigned long CPUFUNC(op_440_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword_prefetch(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_450_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1687;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1687: ;
return 16;
}
unsigned long CPUFUNC(op_458_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1688;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1688: ;
return 16;
}
unsigned long CPUFUNC(op_460_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1689;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1689: ;
return 18;
}
unsigned long CPUFUNC(op_468_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1690;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1690: ;
return 20;
}
unsigned long CPUFUNC(op_470_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1691;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1691: ;
return 22;
}
unsigned long CPUFUNC(op_478_5)(uint32_t opcode) /* SUB */
{
	OpcodeFamily = 7; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1692;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1692: ;
return 20;
}
unsigned long CPUFUNC(op_479_5)(uint32_t opcode) /* SUB */
{
	OpcodeFamily = 7; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1693;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1693: ;
return 24;
}
unsigned long CPUFUNC(op_480_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong_prefetch(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_490_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1695;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1695: ;
return 28;
}
unsigned long CPUFUNC(op_498_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1696;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1696: ;
return 28;
}
unsigned long CPUFUNC(op_4a0_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 30; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1697;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1697: ;
return 30;
}
unsigned long CPUFUNC(op_4a8_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1698;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1698: ;
return 32;
}
unsigned long CPUFUNC(op_4b0_5)(uint32_t opcode) /* SUB */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 7; CurrentInstrCycles = 34; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(6));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1699;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1699: ;
return 34;
}
unsigned long CPUFUNC(op_4b8_5)(uint32_t opcode) /* SUB */
{
	OpcodeFamily = 7; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1700;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1700: ;
return 32;
}
unsigned long CPUFUNC(op_4b9_5)(uint32_t opcode) /* SUB */
{
	OpcodeFamily = 7; CurrentInstrCycles = 36; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 10;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1701;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(10);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1701: ;
return 36;
}
unsigned long CPUFUNC(op_600_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte_prefetch(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_610_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 16;
}
unsigned long CPUFUNC(op_618_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 16;
}
unsigned long CPUFUNC(op_620_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 18;
}
unsigned long CPUFUNC(op_628_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 20;
}
unsigned long CPUFUNC(op_630_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 22; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 22;
}
unsigned long CPUFUNC(op_638_5)(uint32_t opcode) /* ADD */
{
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 20;
}
unsigned long CPUFUNC(op_639_5)(uint32_t opcode) /* ADD */
{
	OpcodeFamily = 11; CurrentInstrCycles = 24; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int8_t)(dst)) + ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint8_t)(~dst)) < ((uint8_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,newv);
}}}}}}}return 24;
}
unsigned long CPUFUNC(op_640_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword_prefetch(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_650_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1711;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1711: ;
return 16;
}
unsigned long CPUFUNC(op_658_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1712;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1712: ;
return 16;
}
unsigned long CPUFUNC(op_660_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1713;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1713: ;
return 18;
}
unsigned long CPUFUNC(op_668_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1714;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1714: ;
return 20;
}
unsigned long CPUFUNC(op_670_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1715;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1715: ;
return 22;
}
unsigned long CPUFUNC(op_678_5)(uint32_t opcode) /* ADD */
{
	OpcodeFamily = 11; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1716;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1716: ;
return 20;
}
unsigned long CPUFUNC(op_679_5)(uint32_t opcode) /* ADD */
{
	OpcodeFamily = 11; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1717;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int16_t)(dst)) + ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint16_t)(~dst)) < ((uint16_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,newv);
}}}}}}}}endlabel1717: ;
return 24;
}
unsigned long CPUFUNC(op_680_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong_prefetch(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_690_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1719;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1719: ;
return 28;
}
unsigned long CPUFUNC(op_698_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1720;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1720: ;
return 28;
}
unsigned long CPUFUNC(op_6a0_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 30; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1721;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1721: ;
return 30;
}
unsigned long CPUFUNC(op_6a8_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1722;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1722: ;
return 32;
}
unsigned long CPUFUNC(op_6b0_5)(uint32_t opcode) /* ADD */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 11; CurrentInstrCycles = 34; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(6));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1723;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1723: ;
return 34;
}
unsigned long CPUFUNC(op_6b8_5)(uint32_t opcode) /* ADD */
{
	OpcodeFamily = 11; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1724;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1724: ;
return 32;
}
unsigned long CPUFUNC(op_6b9_5)(uint32_t opcode) /* ADD */
{
	OpcodeFamily = 11; CurrentInstrCycles = 36; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 10;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1725;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{	refill_prefetch (m68k_getpc(), 2);
{uint32_t newv = ((int32_t)(dst)) + ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uint32_t)(~dst)) < ((uint32_t)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
m68k_incpc(10);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,newv);
}}}}}}}}endlabel1725: ;
return 36;
}
unsigned long CPUFUNC(op_800_5)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 10; 
{{	int16_t src = get_iword_prefetch(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}m68k_incpc(4);
fill_prefetch_0 ();
return 10;
}
unsigned long CPUFUNC(op_810_5)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_818_5)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_820_5)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 14; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 14;
}
unsigned long CPUFUNC(op_828_5)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_830_5)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 21; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 18;
}
unsigned long CPUFUNC(op_838_5)(uint32_t opcode) /* BTST */
{
	OpcodeFamily = 21; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_839_5)(uint32_t opcode) /* BTST */
{
	OpcodeFamily = 21; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(8);
fill_prefetch_0 ();
return 20;
}
unsigned long CPUFUNC(op_83a_5)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 21; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_getpc () + 4;
	dsta += (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_83b_5)(uint32_t opcode) /* BTST */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 21; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 18;
}
unsigned long CPUFUNC(op_83c_5)(uint32_t opcode) /* BTST */
{
	OpcodeFamily = 21; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword_prefetch(2);
{	int8_t dst = get_ibyte_prefetch(4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}m68k_incpc(6);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_840_5)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword_prefetch(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(4);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_850_5)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_858_5)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_860_5)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 18;
}
unsigned long CPUFUNC(op_868_5)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 20;
}
unsigned long CPUFUNC(op_870_5)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 22; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 22;
}
unsigned long CPUFUNC(op_878_5)(uint32_t opcode) /* BCHG */
{
	OpcodeFamily = 22; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 20;
}
unsigned long CPUFUNC(op_879_5)(uint32_t opcode) /* BCHG */
{
	OpcodeFamily = 22; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 24;
}
unsigned long CPUFUNC(op_87a_5)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 22; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_getpc () + 4;
	dsta += (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 20;
}
unsigned long CPUFUNC(op_87b_5)(uint32_t opcode) /* BCHG */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 22; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uint32_t)dst & (1 << src)) >> src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 22;
}
unsigned long CPUFUNC(op_880_5)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 14; 
{{	int16_t src = get_iword_prefetch(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	if ( src < 16 ) { m68k_incpc(4); return 12; }
}}}m68k_incpc(4);
fill_prefetch_0 ();
return 14;
}
unsigned long CPUFUNC(op_890_5)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_898_5)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_8a0_5)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 18;
}
unsigned long CPUFUNC(op_8a8_5)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 20;
}
unsigned long CPUFUNC(op_8b0_5)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 23; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 22;
}
unsigned long CPUFUNC(op_8b8_5)(uint32_t opcode) /* BCLR */
{
	OpcodeFamily = 23; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 20;
}
unsigned long CPUFUNC(op_8b9_5)(uint32_t opcode) /* BCLR */
{
	OpcodeFamily = 23; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 24;
}
unsigned long CPUFUNC(op_8ba_5)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 23; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_getpc () + 4;
	dsta += (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 20;
}
unsigned long CPUFUNC(op_8bb_5)(uint32_t opcode) /* BCLR */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 23; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 22;
}
unsigned long CPUFUNC(op_8c0_5)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword_prefetch(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(4);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_8d0_5)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_8d8_5)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 16;
}
unsigned long CPUFUNC(op_8e0_5)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 18;
}
unsigned long CPUFUNC(op_8e8_5)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 20;
}
unsigned long CPUFUNC(op_8f0_5)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 24; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 22;
}
unsigned long CPUFUNC(op_8f8_5)(uint32_t opcode) /* BSET */
{
	OpcodeFamily = 24; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 20;
}
unsigned long CPUFUNC(op_8f9_5)(uint32_t opcode) /* BSET */
{
	OpcodeFamily = 24; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 24;
}
unsigned long CPUFUNC(op_8fa_5)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 24; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_getpc () + 4;
	dsta += (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 20;
}
unsigned long CPUFUNC(op_8fb_5)(uint32_t opcode) /* BSET */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 24; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,dst);
}}}}return 22;
}
unsigned long CPUFUNC(op_a00_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte_prefetch(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_a10_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_a18_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_a20_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_a28_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_a30_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 22; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 22;
}
unsigned long CPUFUNC(op_a38_5)(uint32_t opcode) /* EOR */
{
	OpcodeFamily = 3; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_a39_5)(uint32_t opcode) /* EOR */
{
	OpcodeFamily = 3; CurrentInstrCycles = 24; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 24;
}
unsigned long CPUFUNC(op_a3c_5)(uint32_t opcode) /* EORSR */
{
	OpcodeFamily = 6; CurrentInstrCycles = 20; 
{	MakeSR();
{	int16_t src = get_iword_prefetch(2);
	src &= 0xFF;
	regs.sr ^= src;
	MakeFromSR();
}}m68k_incpc(4);
fill_prefetch_0 ();
return 20;
}
unsigned long CPUFUNC(op_a40_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword_prefetch(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_a50_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1777;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1777: ;
return 16;
}
unsigned long CPUFUNC(op_a58_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1778;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1778: ;
return 16;
}
unsigned long CPUFUNC(op_a60_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1779;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1779: ;
return 18;
}
unsigned long CPUFUNC(op_a68_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1780;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1780: ;
return 20;
}
unsigned long CPUFUNC(op_a70_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 22; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1781;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1781: ;
return 22;
}
unsigned long CPUFUNC(op_a78_5)(uint32_t opcode) /* EOR */
{
	OpcodeFamily = 3; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1782;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1782: ;
return 20;
}
unsigned long CPUFUNC(op_a79_5)(uint32_t opcode) /* EOR */
{
	OpcodeFamily = 3; CurrentInstrCycles = 24; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1783;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int16_t)(src)) == 0);
	SET_NFLG (((int16_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_16(dsta,src);
}}}}}endlabel1783: ;
return 24;
}
unsigned long CPUFUNC(op_a7c_5)(uint32_t opcode) /* EORSR */
{
	OpcodeFamily = 6; CurrentInstrCycles = 20; 
{if (!regs.s) { Exception(8,0,M68000_EXC_SRC_CPU); goto endlabel1784; }
{	MakeSR();
{	int16_t src = get_iword_prefetch(2);
	regs.sr ^= src;
	MakeFromSR();
}}}m68k_incpc(4);
fill_prefetch_0 ();
endlabel1784: ;
return 20;
}
#endif

#ifdef PART_2
unsigned long CPUFUNC(op_a80_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 16; 
{{	int32_t src = get_ilong_prefetch(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_a90_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1786;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1786: ;
return 28;
}
unsigned long CPUFUNC(op_a98_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1787;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1787: ;
return 28;
}
unsigned long CPUFUNC(op_aa0_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 30; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1788;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1788: ;
return 30;
}
unsigned long CPUFUNC(op_aa8_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1789;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1789: ;
return 32;
}
unsigned long CPUFUNC(op_ab0_5)(uint32_t opcode) /* EOR */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 3; CurrentInstrCycles = 34; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(6));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1790;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1790: ;
return 34;
}
unsigned long CPUFUNC(op_ab8_5)(uint32_t opcode) /* EOR */
{
	OpcodeFamily = 3; CurrentInstrCycles = 32; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1791;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1791: ;
return 32;
}
unsigned long CPUFUNC(op_ab9_5)(uint32_t opcode) /* EOR */
{
	OpcodeFamily = 3; CurrentInstrCycles = 36; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 10;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1792;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((int32_t)(src)) == 0);
	SET_NFLG (((int32_t)(src)) < 0);
m68k_incpc(10);
fill_prefetch_0 ();
	m68k_write_memory_32(dsta,src);
}}}}}endlabel1792: ;
return 36;
}
unsigned long CPUFUNC(op_c00_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte_prefetch(2);
{	int8_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_c10_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_c18_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_c20_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	int8_t dst = m68k_read_memory_8(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 14;
}
unsigned long CPUFUNC(op_c28_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_c30_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 18;
}
unsigned long CPUFUNC(op_c38_5)(uint32_t opcode) /* CMP */
{
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_c39_5)(uint32_t opcode) /* CMP */
{
	OpcodeFamily = 25; CurrentInstrCycles = 20; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
fill_prefetch_0 ();
return 20;
}
unsigned long CPUFUNC(op_c3a_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_getpc () + 4;
	dsta += (int32_t)(int16_t)get_iword_prefetch(4);
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_c3b_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 25; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword_prefetch(4));
	BusCyclePenalty += 2;
{	int8_t dst = m68k_read_memory_8(dsta);
{{uint32_t newv = ((int8_t)(dst)) - ((int8_t)(src));
{	int flgs = ((int8_t)(src)) < 0;
	int flgo = ((int8_t)(dst)) < 0;
	int flgn = ((int8_t)(newv)) < 0;
	SET_ZFLG (((int8_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint8_t)(src)) > ((uint8_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 18;
}
unsigned long CPUFUNC(op_c40_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 8;  
{{	int16_t src = get_iword_prefetch(2);
{	int16_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_c50_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1804;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(4);
fill_prefetch_0 ();
endlabel1804: ;
return 12;
}
unsigned long CPUFUNC(op_c58_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 12; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1805;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(4);
fill_prefetch_0 ();
endlabel1805: ;
return 12;
}
unsigned long CPUFUNC(op_c60_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 4;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1806;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(4);
fill_prefetch_0 ();
endlabel1806: ;
return 14;
}
unsigned long CPUFUNC(op_c68_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1807;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
endlabel1807: ;
return 16;
}
unsigned long CPUFUNC(op_c70_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1808;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
endlabel1808: ;
return 18;
}
unsigned long CPUFUNC(op_c78_5)(uint32_t opcode) /* CMP */
{
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1809;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
endlabel1809: ;
return 16;
}
unsigned long CPUFUNC(op_c79_5)(uint32_t opcode) /* CMP */
{
	OpcodeFamily = 25; CurrentInstrCycles = 20; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1810;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(8);
fill_prefetch_0 ();
endlabel1810: ;
return 20;
}
unsigned long CPUFUNC(op_c7a_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 25; CurrentInstrCycles = 16; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t dsta = m68k_getpc () + 4;
	dsta += (int32_t)(int16_t)get_iword_prefetch(4);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1811;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
endlabel1811: ;
return 16;
}
unsigned long CPUFUNC(op_c7b_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 25; CurrentInstrCycles = 18; 
{{	int16_t src = get_iword_prefetch(2);
{	uint32_t tmppc = m68k_getpc() + 4;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword_prefetch(4));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1812;
	}
{{	int16_t dst = m68k_read_memory_16(dsta);
{{uint32_t newv = ((int16_t)(dst)) - ((int16_t)(src));
{	int flgs = ((int16_t)(src)) < 0;
	int flgo = ((int16_t)(dst)) < 0;
	int flgn = ((int16_t)(newv)) < 0;
	SET_ZFLG (((int16_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint16_t)(src)) > ((uint16_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
endlabel1812: ;
return 18;
}
unsigned long CPUFUNC(op_c80_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 14; 
{{	int32_t src = get_ilong_prefetch(2);
{	int32_t dst = m68k_dreg(regs, dstreg);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 14;
}
unsigned long CPUFUNC(op_c90_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 20; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1814;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
endlabel1814: ;
return 20;
}
unsigned long CPUFUNC(op_c98_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 20; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1815;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
endlabel1815: ;
return 20;
}
unsigned long CPUFUNC(op_ca0_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 22; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - 4;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 6;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1816;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(6);
fill_prefetch_0 ();
endlabel1816: ;
return 22;
}
unsigned long CPUFUNC(op_ca8_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 24; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1817;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(8);
fill_prefetch_0 ();
endlabel1817: ;
return 24;
}
unsigned long CPUFUNC(op_cb0_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = opcode & 7;
	OpcodeFamily = 25; CurrentInstrCycles = 26; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(6));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1818;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(8);
fill_prefetch_0 ();
endlabel1818: ;
return 26;
}
unsigned long CPUFUNC(op_cb8_5)(uint32_t opcode) /* CMP */
{
	OpcodeFamily = 25; CurrentInstrCycles = 24; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1819;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(8);
fill_prefetch_0 ();
endlabel1819: ;
return 24;
}
unsigned long CPUFUNC(op_cb9_5)(uint32_t opcode) /* CMP */
{
	OpcodeFamily = 25; CurrentInstrCycles = 28; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = get_ilong_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 10;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1820;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(10);
fill_prefetch_0 ();
endlabel1820: ;
return 28;
}
unsigned long CPUFUNC(op_cba_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = 2;
	OpcodeFamily = 25; CurrentInstrCycles = 24; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t dsta = m68k_getpc () + 6;
	dsta += (int32_t)(int16_t)get_iword_prefetch(6);
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1821;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(8);
fill_prefetch_0 ();
endlabel1821: ;
return 24;
}
unsigned long CPUFUNC(op_cbb_5)(uint32_t opcode) /* CMP */
{
	uint32_t dstreg = 3;
	OpcodeFamily = 25; CurrentInstrCycles = 26; 
{{	int32_t src = get_ilong_prefetch(2);
{	uint32_t tmppc = m68k_getpc() + 6;
	uint32_t dsta = get_disp_ea_000(tmppc, get_iword_prefetch(6));
	BusCyclePenalty += 2;
	if ((dsta & 1) != 0) {
		last_fault_for_exception_3 = dsta;
		last_op_for_exception_3 = opcode;
		last_addr_for_exception_3 = m68k_getpc() + 8;
		Exception(3, 0, M68000_EXC_SRC_CPU);
		goto endlabel1822;
	}
{{	int32_t dst = m68k_read_memory_32(dsta);
{{uint32_t newv = ((int32_t)(dst)) - ((int32_t)(src));
{	int flgs = ((int32_t)(src)) < 0;
	int flgo = ((int32_t)(dst)) < 0;
	int flgn = ((int32_t)(newv)) < 0;
	SET_ZFLG (((int32_t)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uint32_t)(src)) > ((uint32_t)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(8);
fill_prefetch_0 ();
endlabel1822: ;
return 26;
}
unsigned long CPUFUNC(op_1000_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(2);
fill_prefetch_2 ();
return 4;
}
unsigned long CPUFUNC(op_1008_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 4;  
{{	int8_t src = m68k_areg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(2);
fill_prefetch_2 ();
return 4;
}
unsigned long CPUFUNC(op_1010_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
fill_prefetch_2 ();
return 8;
}
unsigned long CPUFUNC(op_1018_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
fill_prefetch_2 ();
return 8;
}
unsigned long CPUFUNC(op_1020_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 10; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
fill_prefetch_2 ();
return 10;
}
unsigned long CPUFUNC(op_1028_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_1030_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 14;
}
unsigned long CPUFUNC(op_1038_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_1039_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = get_ilong_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(6);
fill_prefetch_0 ();
return 16;
}
unsigned long CPUFUNC(op_103a_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 12;
}
unsigned long CPUFUNC(op_103b_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
fill_prefetch_0 ();
return 14;
}
unsigned long CPUFUNC(op_103c_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = get_ibyte_prefetch(2);
{	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
fill_prefetch_0 ();
return 8;
}
unsigned long CPUFUNC(op_1080_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}return 8;
}
unsigned long CPUFUNC(op_1088_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}return 8;
}
unsigned long CPUFUNC(op_1090_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}}return 12;
}
unsigned long CPUFUNC(op_1098_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}}return 12;
}
unsigned long CPUFUNC(op_10a0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}}return 14;
}
unsigned long CPUFUNC(op_10a8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_10b0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_10b8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_10b9_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_10ba_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_10bb_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_10bc_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 12;
}
unsigned long CPUFUNC(op_10c0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}return 8;
}
unsigned long CPUFUNC(op_10c8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}return 8;
}
unsigned long CPUFUNC(op_10d0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}}return 12;
}
unsigned long CPUFUNC(op_10d8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}}return 12;
}
unsigned long CPUFUNC(op_10e0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}}return 14;
}
unsigned long CPUFUNC(op_10e8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_10f0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_10f8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_10f9_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_10fa_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_10fb_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_10fc_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 12;
}
unsigned long CPUFUNC(op_1100_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}return 8;
}
unsigned long CPUFUNC(op_1108_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 8;  
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}return 8;
}
unsigned long CPUFUNC(op_1110_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}}return 12;
}
unsigned long CPUFUNC(op_1118_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}}return 12;
}
unsigned long CPUFUNC(op_1120_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(2);
fill_prefetch_2 ();
	m68k_write_memory_8(dsta,src);
}}}}return 14;
}
unsigned long CPUFUNC(op_1128_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_1130_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_1138_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_1139_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = get_ilong_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_113a_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_113b_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_113c_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 12;
}
unsigned long CPUFUNC(op_1140_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 12;
}
unsigned long CPUFUNC(op_1148_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 12;
}
unsigned long CPUFUNC(op_1150_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_1158_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_1160_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_1168_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_1170_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 22;
}
unsigned long CPUFUNC(op_1178_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_1179_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = get_ilong_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(6);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 24;
}
unsigned long CPUFUNC(op_117a_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_117b_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 22;
}
unsigned long CPUFUNC(op_117c_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = m68k_areg(regs, dstreg) + (int32_t)(int16_t)get_iword_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 16;
}
unsigned long CPUFUNC(op_1180_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 14;
}
unsigned long CPUFUNC(op_1188_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 14; 
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 14;
}
unsigned long CPUFUNC(op_1190_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_1198_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_11a0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_11a8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 22;
}
unsigned long CPUFUNC(op_11b0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 24;
}
unsigned long CPUFUNC(op_11b8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 22;
}
unsigned long CPUFUNC(op_11b9_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = get_ilong_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(6));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 26;
}
unsigned long CPUFUNC(op_11ba_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 22;
}
unsigned long CPUFUNC(op_11bb_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 24;
}
unsigned long CPUFUNC(op_11bc_5)(uint32_t opcode) /* MOVE */
{
	uint32_t dstreg = (opcode >> 9) & 7;
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword_prefetch(4));
	BusCyclePenalty += 2;
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 18;
}
unsigned long CPUFUNC(op_11c0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 12;
}
unsigned long CPUFUNC(op_11c8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 12; 
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 12;
}
unsigned long CPUFUNC(op_11d0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_11d8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 16;
}
unsigned long CPUFUNC(op_11e0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 18; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(4);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 18;
}
unsigned long CPUFUNC(op_11e8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_11f0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 22;
}
unsigned long CPUFUNC(op_11f8_5)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_11f9_5)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = get_ilong_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(6);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 24;
}
unsigned long CPUFUNC(op_11fa_5)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_getpc () + 2;
	srca += (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_11fb_5)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t tmppc = m68k_getpc() + 2;
	uint32_t srca = get_disp_ea_000(tmppc, get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 22;
}
unsigned long CPUFUNC(op_11fc_5)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int8_t src = get_ibyte_prefetch(2);
{	uint32_t dsta = (int32_t)(int16_t)get_iword_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 16;
}
unsigned long CPUFUNC(op_13c0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_dreg(regs, srcreg);
{	uint32_t dsta = get_ilong_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 16;
}
unsigned long CPUFUNC(op_13c8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 16; 
{{	int8_t src = m68k_areg(regs, srcreg);
{	uint32_t dsta = get_ilong_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}return 16;
}
unsigned long CPUFUNC(op_13d0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_ilong_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_13d8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 20; 
{{	uint32_t srca = m68k_areg(regs, srcreg);
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uint32_t dsta = get_ilong_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 20;
}
unsigned long CPUFUNC(op_13e0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 22; 
{{	uint32_t srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	int8_t src = m68k_read_memory_8(srca);
	m68k_areg (regs, srcreg) = srca;
{	uint32_t dsta = get_ilong_prefetch(2);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(6);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 22;
}
unsigned long CPUFUNC(op_13e8_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = m68k_areg(regs, srcreg) + (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_ilong_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 24;
}
unsigned long CPUFUNC(op_13f0_5)(uint32_t opcode) /* MOVE */
{
	uint32_t srcreg = (opcode & 7);
	OpcodeFamily = 30; CurrentInstrCycles = 26; 
{{	uint32_t srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword_prefetch(2));
	BusCyclePenalty += 2;
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_ilong_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_0 ();
	m68k_write_memory_8(dsta,src);
}}}}return 26;
}
unsigned long CPUFUNC(op_13f8_5)(uint32_t opcode) /* MOVE */
{
	OpcodeFamily = 30; CurrentInstrCycles = 24; 
{{	uint32_t srca = (int32_t)(int16_t)get_iword_prefetch(2);
{	int8_t src = m68k_read_memory_8(srca);
{	uint32_t dsta = get_ilong_prefetch(4);
	CLEAR_CZNV;
	SET_ZFLG (((int8_t)(src)) == 0);
	SET_NFLG (((int8_t)(src)) < 0);
m68k_incpc(8);
fill_prefetch_