// ----------------------------------------------------------------------------
//   ___  ___  ___  ___       ___  ____  ___  _  _
//  /__/ /__/ /  / /__  /__/ /__    /   /_   / |/ /
// /    / \  /__/ ___/ ___/ ___/   /   /__  /    /  emulator
//
// ----------------------------------------------------------------------------
// Copyright 2005 Greg Stanton
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// ----------------------------------------------------------------------------
// Region.h
// ----------------------------------------------------------------------------
#include "Region.h"
#include "Cartridge.h"
#include "ProSystem.h"
#include "Maria.h"
#include "Palette.h"
#include "Tia.h"
#include "Pokey.h"

uint8_t region_type = REGION_AUTO;

static const rect REGION_VISIBLE_AREA_NTSC = {0, 26, 319, 248};
static const rect REGION_VISIBLE_AREA_PAL = {0, 26, 319, 297};
static const rect REGION_DISPLAY_AREA_NTSC = {0, 16, 319, 258};
static const rect REGION_DISPLAY_AREA_PAL = {0, 16, 319, 306};
static const uint8_t REGION_FREQUENCY_NTSC = 60;
static const uint16_t REGION_SCANLINES_NTSC = 262;
static const uint8_t REGION_FREQUENCY_PAL = 50;
static const uint16_t REGION_SCANLINES_PAL = 312;

// ----------------------------------------------------------------------------
// PALETTE NTSC
// ----------------------------------------------------------------------------
static const uint8_t REGION_PALETTE_NTSC[ ] = {
0x00,0x00,0x00,0x14,0x14,0x14,0x29,0x29,0x29,0x3D,0x3D,0x3D,
0x52,0x52,0x52,0x66,0x66,0x66,0x7A,0x7A,0x7A,0x8F,0x8F,0x8F,
0xA3,0xA3,0xA3,0xB8,0xB8,0xB8,0xCC,0xCC,0xCC,0xE0,0xE0,0xE0,
0xF5,0xF5,0xF5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x18,0x11,0x00,0x2C,0x25,0x00,0x41,0x3A,0x00,0x55,0x4E,0x00,
0x6A,0x62,0x00,0x7E,0x77,0x00,0x92,0x8B,0x00,0xA7,0xA0,0x00,
0xBB,0xB4,0x0E,0xD0,0xC8,0x22,0xE4,0xDD,0x37,0xF8,0xF1,0x4B,
0xFF,0xFF,0x5F,0xFF,0xFF,0x74,0xFF,0xFF,0x88,0xFF,0xFF,0x9D,
0x3B,0x00,0x00,0x50,0x0C,0x00,0x64,0x21,0x00,0x79,0x35,0x00,
0x8D,0x49,0x00,0xA1,0x5E,0x00,0xB6,0x72,0x09,0xCA,0x87,0x1D,
0xDF,0x9B,0x31,0xF3,0xAF,0x46,0xFF,0xC4,0x5A,0xFF,0xD8,0x6F,
0xFF,0xED,0x83,0xFF,0xFF,0x97,0xFF,0xFF,0xAC,0xFF,0xFF,0xC0,
0x52,0x00,0x00,0x66,0x00,0x00,0x7B,0x09,0x00,0x8F,0x1E,0x08,
0xA4,0x32,0x1C,0xB8,0x47,0x31,0xCC,0x5B,0x45,0xE1,0x6F,0x5A,
0xF5,0x84,0x6E,0xFF,0x98,0x82,0xFF,0xAD,0x97,0xFF,0xC1,0xAB,
0xFF,0xD5,0xC0,0xFF,0xEA,0xD4,0xFF,0xFE,0xE8,0xFF,0xFF,0xFD,
0x57,0x00,0x13,0x6B,0x00,0x27,0x7F,0x00,0x3C,0x94,0x0D,0x50,
0xA8,0x22,0x65,0xBD,0x36,0x79,0xD1,0x4B,0x8D,0xE5,0x5F,0xA2,
0xFA,0x73,0xB6,0xFF,0x88,0xCB,0xFF,0x9C,0xDF,0xFF,0xB1,0xF3,
0xFF,0xC5,0xFF,0xFF,0xD9,0xFF,0xFF,0xEE,0xFF,0xFF,0xFF,0xFF,
0x48,0x00,0x57,0x5D,0x00,0x6B,0x71,0x00,0x80,0x86,0x08,0x94,
0x9A,0x1C,0xA9,0xAE,0x30,0xBD,0xC3,0x45,0xD1,0xD7,0x59,0xE6,
0xEC,0x6E,0xFA,0xFF,0x82,0xFF,0xFF,0x96,0xFF,0xFF,0xAB,0xFF,
0xFF,0xBF,0xFF,0xFF,0xD4,0xFF,0xFF,0xE8,0xFF,0xFF,0xFC,0xFF,
0x2A,0x00,0x88,0x3F,0x00,0x9C,0x53,0x00,0xB1,0x67,0x0D,0xC5,
0x7C,0x22,0xDA,0x90,0x36,0xEE,0xA5,0x4A,0xFF,0xB9,0x5F,0xFF,
0xCD,0x73,0xFF,0xE2,0x88,0xFF,0xF6,0x9C,0xFF,0xFF,0xB0,0xFF,
0xFF,0xC5,0xFF,0xFF,0xD9,0xFF,0xFF,0xEE,0xFF,0xFF,0xFF,0xFF,
0x03,0x00,0x9B,0x17,0x00,0xB0,0x2C,0x09,0xC4,0x40,0x1D,0xD9,
0x55,0x32,0xED,0x69,0x46,0xFF,0x7D,0x5B,0xFF,0x92,0x6F,0xFF,
0xA6,0x83,0xFF,0xBB,0x98,0xFF,0xCF,0xAC,0xFF,0xE3,0xC1,0xFF,
0xF8,0xD5,0xFF,0xFF,0xE9,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x8D,0x00,0x0C,0xA1,0x04,0x20,0xB6,0x18,0x35,0xCA,
0x2D,0x49,0xDE,0x41,0x5D,0xF3,0x56,0x72,0xFF,0x6A,0x86,0xFF,
0x7E,0x9B,0xFF,0x93,0xAF,0xFF,0xA7,0xC3,0xFF,0xBC,0xD8,0xFF,
0xD0,0xEC,0xFF,0xE4,0xFF,0xFF,0xF9,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x10,0x60,0x00,0x25,0x74,0x00,0x39,0x89,0x00,0x4E,0x9D,
0x0D,0x62,0xB1,0x21,0x76,0xC6,0x36,0x8B,0xDA,0x4A,0x9F,0xEF,
0x5E,0xB4,0xFF,0x73,0xC8,0xFF,0x87,0xDC,0xFF,0x9C,0xF1,0xFF,
0xB0,0xFF,0xFF,0xC4,0xFF,0xFF,0xD9,0xFF,0xFF,0xED,0xFF,0xFF,
0x00,0x26,0x1E,0x00,0x3A,0x32,0x00,0x4F,0x46,0x00,0x63,0x5B,
0x00,0x77,0x6F,0x10,0x8C,0x84,0x25,0xA0,0x98,0x39,0xB5,0xAC,
0x4E,0xC9,0xC1,0x62,0xDD,0xD5,0x76,0xF2,0xEA,0x8B,0xFF,0xFE,
0x9F,0xFF,0xFF,0xB4,0xFF,0xFF,0xC8,0xFF,0xFF,0xDC,0xFF,0xFF,
0x00,0x33,0x00,0x00,0x47,0x00,0x00,0x5C,0x00,0x00,0x70,0x12,
0x00,0x85,0x27,0x12,0x99,0x3B,0x27,0xAD,0x50,0x3B,0xC2,0x64,
0x4F,0xD6,0x78,0x64,0xEB,0x8D,0x78,0xFF,0xA1,0x8D,0xFF,0xB6,
0xA1,0xFF,0xCA,0xB5,0xFF,0xDE,0xCA,0xFF,0xF3,0xDE,0xFF,0xFF,
0x00,0x35,0x00,0x00,0x49,0x00,0x00,0x5E,0x00,0x00,0x72,0x00,
0x12,0x87,0x00,0x26,0x9B,0x00,0x3B,0xAF,0x10,0x4F,0xC4,0x25,
0x63,0xD8,0x39,0x78,0xED,0x4E,0x8C,0xFF,0x62,0xA1,0xFF,0x76,
0xB5,0xFF,0x8B,0xC9,0xFF,0x9F,0xDE,0xFF,0xB4,0xF2,0xFF,0xC8,
0x00,0x2C,0x00,0x00,0x40,0x00,0x0B,0x54,0x00,0x1F,0x69,0x00,
0x34,0x7D,0x00,0x48,0x92,0x00,0x5D,0xA6,0x00,0x71,0xBA,0x00,
0x85,0xCF,0x11,0x9A,0xE3,0x26,0xAE,0xF8,0x3A,0xC3,0xFF,0x4E,
0xD7,0xFF,0x63,0xEB,0xFF,0x77,0xFF,0xFF,0x8C,0xFF,0xFF,0xA0,
0x0B,0x19,0x00,0x1F,0x2D,0x00,0x33,0x41,0x00,0x48,0x56,0x00,
0x5C,0x6A,0x00,0x71,0x7F,0x00,0x85,0x93,0x00,0x99,0xA7,0x00,
0xAE,0xBC,0x09,0xC2,0xD0,0x1D,0xD7,0xE5,0x32,0xEB,0xF9,0x46,
0xFF,0xFF,0x5B,0xFF,0xFF,0x6F,0xFF,0xFF,0x83,0xFF,0xFF,0x98,
0x31,0x00,0x00,0x45,0x15,0x00,0x5A,0x29,0x00,0x6E,0x3D,0x00,
0x82,0x52,0x00,0x97,0x66,0x00,0xAB,0x7B,0x00,0xC0,0x8F,0x0E,
0xD4,0xA3,0x22,0xE8,0xB8,0x37,0xFD,0xCC,0x4B,0xFF,0xE1,0x60,
0xFF,0xF5,0x74,0xFF,0xFF,0x88,0xFF,0xFF,0x9D,0xFF,0xFF,0xB1
};

// --------------------------------------------------------------------------------------
// PALETTE PAL
// --------------------------------------------------------------------------------------
static const uint8_t REGION_PALETTE_PAL[ ] = {
  0x00,0x00,0x00,0x1c,0x1c,0x1c,0x39,0x39,0x39,0x59,0x59,0x59,
  0x79,0x79,0x79,0x92,0x92,0x92,0xab,0xab,0xab,0xbc,0xbc,0xbc,
  0xcd,0xcd,0xcd,0xd9,0xd9,0xd9,0xe6,0xe6,0xe6,0xec,0xec,0xec,
  0xf2,0xf2,0xf2,0xf8,0xf8,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,
  0x26,0x30,0x01,0x24,0x38,0x03,0x23,0x40,0x05,0x51,0x54,0x1b,
  0x80,0x69,0x31,0x97,0x81,0x35,0xaf,0x99,0x3a,0xc2,0xa7,0x3e,
  0xd5,0xb5,0x43,0xdb,0xc0,0x3d,0xe1,0xcb,0x38,0xe2,0xd8,0x36,
  0xe3,0xe5,0x34,0xef,0xf2,0x58,0xfb,0xff,0x7d,0xfb,0xff,0x7d,
  0x39,0x17,0x01,0x5e,0x23,0x04,0x83,0x30,0x08,0xa5,0x47,0x16,
  0xc8,0x5f,0x24,0xe3,0x78,0x20,0xff,0x91,0x1d,0xff,0xab,0x1d,
  0xff,0xc5,0x1d,0xff,0xce,0x34,0xff,0xd8,0x4c,0xff,0xe6,0x51,
  0xff,0xf4,0x56,0xff,0xf9,0x77,0xff,0xff,0x98,0xff,0xff,0x98,
  0x45,0x19,0x04,0x72,0x1e,0x11,0x9f,0x24,0x1e,0xb3,0x3a,0x20,
  0xc8,0x51,0x22,0xe3,0x69,0x20,0xff,0x81,0x1e,0xff,0x8c,0x25,
  0xff,0x98,0x2c,0xff,0xae,0x38,0xff,0xc5,0x45,0xff,0xc5,0x59,
  0xff,0xc6,0x6d,0xff,0xd5,0x87,0xff,0xe4,0xa1,0xff,0xe4,0xa1,
  0x4a,0x17,0x04,0x7e,0x1a,0x0d,0xb2,0x1d,0x17,0xc8,0x21,0x19,
  0xdf,0x25,0x1c,0xec,0x3b,0x38,0xfa,0x52,0x55,0xfc,0x61,0x61,
  0xff,0x70,0x6e,0xff,0x7f,0x7e,0xff,0x8f,0x8f,0xff,0x9d,0x9e,
  0xff,0xab,0xad,0xff,0xb9,0xbd,0xff,0xc7,0xce,0xff,0xc7,0xce,
  0x05,0x05,0x68,0x3b,0x13,0x6d,0x71,0x22,0x72,0x8b,0x2a,0x8c,
  0xa5,0x32,0xa6,0xb9,0x38,0xba,0xcd,0x3e,0xcf,0xdb,0x47,0xdd,
  0xea,0x51,0xeb,0xf4,0x5f,0xf5,0xfe,0x6d,0xff,0xfe,0x7a,0xfd,
  0xff,0x87,0xfb,0xff,0x95,0xfd,0xff,0xa4,0xff,0xff,0xa4,0xff,
  0x28,0x04,0x79,0x40,0x09,0x84,0x59,0x0f,0x90,0x70,0x24,0x9d,
  0x88,0x39,0xaa,0xa4,0x41,0xc3,0xc0,0x4a,0xdc,0xd0,0x54,0xed,
  0xe0,0x5e,0xff,0xe9,0x6d,0xff,0xf2,0x7c,0xff,0xf8,0x8a,0xff,
  0xff,0x98,0xff,0xfe,0xa1,0xff,0xfe,0xab,0xff,0xfe,0xab,0xff,
  0x35,0x08,0x8a,0x42,0x0a,0xad,0x50,0x0c,0xd0,0x64,0x28,0xd0,
  0x79,0x45,0xd0,0x8d,0x4b,0xd4,0xa2,0x51,0xd9,0xb0,0x58,0xec,
  0xbe,0x60,0xff,0xc5,0x6b,0xff,0xcc,0x77,0xff,0xd1,0x83,0xff,
  0xd7,0x90,0xff,0xdb,0x9d,0xff,0xdf,0xaa,0xff,0xdf,0xaa,0xff,
  0x05,0x1e,0x81,0x06,0x26,0xa5,0x08,0x2f,0xca,0x26,0x3d,0xd4,
  0x44,0x4c,0xde,0x4f,0x5a,0xee,0x5a,0x68,0xff,0x65,0x75,0xff,
  0x71,0x83,0xff,0x80,0x91,0xff,0x90,0xa0,0xff,0x97,0xa9,0xff,
  0x9f,0xb2,0xff,0xaf,0xbe,0xff,0xc0,0xcb,0xff,0xc0,0xcb,0xff,
  0x05,0x1e,0x81,0x06,0x26,0xa5,0x08,0x2f,0xca,0x26,0x3d,0xd4,
  0x44,0x4c,0xde,0x4f,0x5a,0xee,0x5a,0x68,0xff,0x65,0x75,0xff,
  0x71,0x83,0xff,0x80,0x91,0xff,0x90,0xa0,0xff,0x97,0xa9,0xff,
  0x9f,0xb2,0xff,0xaf,0xbe,0xff,0xc0,0xcb,0xff,0xc0,0xcb,0xff,
  0x0c,0x04,0x8b,0x22,0x18,0xa0,0x38,0x2d,0xb5,0x48,0x3e,0xc7,
  0x58,0x4f,0xda,0x61,0x59,0xec,0x6b,0x64,0xff,0x7a,0x74,0xff,
  0x8a,0x84,0xff,0x91,0x8e,0xff,0x99,0x98,0xff,0xa5,0xa3,0xff,
  0xb1,0xae,0xff,0xb8,0xb8,0xff,0xc0,0xc2,0xff,0xc0,0xc2,0xff,
  0x1d,0x29,0x5a,0x1d,0x38,0x76,0x1d,0x48,0x92,0x1c,0x5c,0xac,
  0x1c,0x71,0xc6,0x32,0x86,0xcf,0x48,0x9b,0xd9,0x4e,0xa8,0xec,
  0x55,0xb6,0xff,0x70,0xc7,0xff,0x8c,0xd8,0xff,0x93,0xdb,0xff,
  0x9b,0xdf,0xff,0xaf,0xe4,0xff,0xc3,0xe9,0xff,0xc3,0xe9,0xff,
  0x2f,0x43,0x02,0x39,0x52,0x02,0x44,0x61,0x03,0x41,0x7a,0x12,
  0x3e,0x94,0x21,0x4a,0x9f,0x2e,0x57,0xab,0x3b,0x5c,0xbd,0x55,
  0x61,0xd0,0x70,0x69,0xe2,0x7a,0x72,0xf5,0x84,0x7c,0xfa,0x8d,
  0x87,0xff,0x97,0x9a,0xff,0xa6,0xad,0xff,0xb6,0xad,0xff,0xb6,
  0x0a,0x41,0x08,0x0d,0x54,0x0a,0x10,0x68,0x0d,0x13,0x7d,0x0f,
  0x16,0x92,0x12,0x19,0xa5,0x14,0x1c,0xb9,0x17,0x1e,0xc9,0x19,
  0x21,0xd9,0x1b,0x47,0xe4,0x2d,0x6e,0xf0,0x40,0x78,0xf7,0x4d,
  0x83,0xff,0x5b,0x9a,0xff,0x7a,0xb2,0xff,0x9a,0xb2,0xff,0x9a,
  0x04,0x41,0x0b,0x05,0x53,0x0e,0x06,0x66,0x11,0x07,0x77,0x14,
  0x08,0x88,0x17,0x09,0x9b,0x1a,0x0b,0xaf,0x1d,0x48,0xc4,0x1f,
  0x86,0xd9,0x22,0x8f,0xe9,0x24,0x99,0xf9,0x27,0xa8,0xfc,0x41,
  0xb7,0xff,0x5b,0xc9,0xff,0x6e,0xdc,0xff,0x81,0xdc,0xff,0x81,
  0x02,0x35,0x0f,0x07,0x3f,0x15,0x0c,0x4a,0x1c,0x2d,0x5f,0x1e,
  0x4f,0x74,0x20,0x59,0x83,0x24,0x64,0x92,0x28,0x82,0xa1,0x2e,
  0xa1,0xb0,0x34,0xa9,0xc1,0x3a,0xb2,0xd2,0x41,0xc4,0xd9,0x45,
  0xd6,0xe1,0x49,0xe4,0xf0,0x4e,0xf2,0xff,0x53,0xf2,0xff,0x53,
};

// ----------------------------------------------------------------------------
// Reset
// ----------------------------------------------------------------------------
void region_Reset(void)
{
   if(region_type == REGION_PAL || (region_type == REGION_AUTO && cartridge_region == REGION_PAL))
   {
      maria_displayArea = REGION_DISPLAY_AREA_PAL;
      maria_visibleArea = REGION_VISIBLE_AREA_PAL;
      if(palette_default)
         palette_Load(REGION_PALETTE_PAL);  // Added check for default - bberlin
      prosystem_frequency = REGION_FREQUENCY_PAL;
      prosystem_scanlines = REGION_SCANLINES_PAL;
      tia_size = 624;
      pokey_size = 624;
   }  
   else
   {
      maria_displayArea = REGION_DISPLAY_AREA_NTSC;
      maria_visibleArea = REGION_VISIBLE_AREA_NTSC;
      if(palette_default)
         palette_Load(REGION_PALETTE_NTSC);  // Added check for default - bberlin
      prosystem_frequency = REGION_FREQUENCY_NTSC;
      prosystem_scanlines = REGION_SCANLINES_NTSC;
      tia_size = 524;
      pokey_size = 524;
   }
}
