/*****************************************************************************
** $Source: /cygdrive/d/Private/_SVNROOT/bluemsx/blueMSX/Src/Language/LanguageSwedish.h,v $
**
** $Revision: 1.61 $
**
** $Date: 2009-04-04 20:57:19 $
**
** More info: http://www.bluemsx.com
**
** Copyright (C) 2003-2006 Daniel Vik
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
******************************************************************************
*/
#ifndef LANGUAGE_SWEDISH_H
#define LANGUAGE_SWEDISH_H

#include "LanguageStrings.h"

void langInitSwedish(LanguageStrings* ls) 
{
    //----------------------
    // Language lines
    //----------------------

    ls->langCatalan             = "Catalan";
    ls->langChineseSimplified   = "Kinesiska Frenklad";
    ls->langChineseTraditional  = "Kinesiska Traditionell";
    ls->langDutch               = "Hollndska";
    ls->langEnglish             = "Engelska";
    ls->langFinnish             = "Finska";
    ls->langFrench              = "Franska";
    ls->langGerman              = "Tyska";
    ls->langItalian             = "Italienska";
    ls->langJapanese            = "Japanska";
    ls->langKorean              = "Koreanska";
    ls->langPolish              = "Polska";
    ls->langPortuguese          = "Portugisiska";
    ls->langRussian             = "Ryska";            // v2.8
    ls->langSpanish             = "Spanska";
    ls->langSwedish             = "Svenska";


    //----------------------
    // Generic lines
    //----------------------

    ls->textDevice              = "Enhet:";
    ls->textFilename            = "Filnamn:";
    ls->textFile                = "Fil";
    ls->textNone                = "Ingen";
    ls->textUnknown             = "Oknd";


    //----------------------
    // Warning and Error lines
    //----------------------

    ls->warningTitle            = "blueMSX - Varning";
    ls->warningDiscardChanges   = "Vill du stnga verktyget utan att spara dina ndringar?";
    ls->warningOverwriteFile    = "Vill du skriva ver filen:";
    ls->errorTitle              = "blueMSX - Fel";
    ls->errorEnterFullscreen    = "Misslyckades att byta till fullskrm.           \n";
    ls->errorDirectXFailed      = "Misslyckades att skapa DirectX objekt.          \nAnvnder GDI istllet.\nKontrollera video instllningarna.";
    ls->errorNoRomInZip         = "Kunde inte hitta en .rom fil i zip arkivet.";
    ls->errorNoDskInZip         = "Kunde inte hitta en .dsk fil i zip arkivet.";
    ls->errorNoCasInZip         = "Kunde inte hitta en .cas fil i zip arkivet.";
    ls->errorNoHelp             = "Kunde inte hitta hjlpfilen.";
    ls->errorStartEmu           = "Misslyckades att starta emulatorn.";
    ls->errorPortableReadonly   = "Flyttbar enhet r inte skrivbar";


    //----------------------
    // File related lines
    //----------------------

    ls->fileRom                 = "Rom fil";
    ls->fileAll                 = "Alla Filer";
    ls->fileCpuState            = "CPU-tillstnd";
    ls->fileVideoCapture        = "Videoinspelning"; 
    ls->fileDisk                = "Diskettfil";
    ls->fileCas                 = "Kassettfil";
    ls->fileAvi                 = "Videofil";    


    //----------------------
    // Menu related lines
    //----------------------

    ls->menuNoRecentFiles       = "- ingen filhistoria -";
    ls->menuInsert              = "Stt in";
    ls->menuEject               = "Ta ur";

    ls->menuCartGameReader      = "Game Reader";
    ls->menuCartIde             = "IDE";
    ls->menuCartBeerIde         = "Beer";
    ls->menuCartGIde            = "GIDE";
    ls->menuCartSunriseIde      = "Sunrise";  
    ls->menuCartScsi            = "SCSI";                // New in 2.7
    ls->menuCartMegaSCSI        = "MEGA-SCSI";           // New in 2.7
    ls->menuCartWaveSCSI        = "WAVE-SCSI";           // New in 2.7
    ls->menuCartGoudaSCSI       = "Gouda SCSI";          // New in 2.7
    ls->menuJoyrexPsg           = "Joyrex PSG Cartridge"; // New in 2.9
    ls->menuCartSCC             = "SCC Cartridge";
    ls->menuCartSCCPlus         = "SCC-I Cartridge";
    ls->menuCartFMPac           = "FM-PAC Cartridge";
    ls->menuCartPac             = "PAC Cartridge";
    ls->menuCartHBI55           = "Sony HBI-55 Cartridge";
    ls->menuCartInsertSpecial   = "Stt in Special";
    ls->menuCartMegaRam         = "MegaRAM";
    ls->menuCartExternalRam     = "Externt RAM";
    ls->menuCartEseRam          = "Ese-RAM";             // New in 2.7
    ls->menuCartEseSCC          = "Ese-SCC";             // New in 2.7
    ls->menuCartMegaFlashRom    = "Mega Flash ROM";      // New in 2.7

    ls->menuDiskInsertNew       = "Stt in ny diskett fil";
    ls->menuDiskInsertCdrom     = "Stt in CD-Rom";      // New in 2.7
    ls->menuDiskDirInsert       = "Stt in mapp";
    ls->menuDiskAutoStart       = "Starta om efter insttning/urdragning";
    ls->menuCartAutoReset       = "Starta om efter insttning/urdragning";

    ls->menuCasRewindAfterInsert= "Spola tillbaka vid insttning";
    ls->menuCasUseReadOnly      = "Tillt endast lsning av kassett";
    ls->lmenuCasSaveAs          = "Spara kassett som...";
    ls->menuCasSetPosition      = "Stt position";
    ls->menuCasRewind           = "Spola tillbaka";

    ls->menuVideoLoad           = "Ladda...";             
    ls->menuVideoPlay           = "Spela upp senaste";   
    ls->menuVideoRecord         = "Spela in";              
    ls->menuVideoRecording      = "Spelar in";           
    ls->menuVideoRecAppend      = "Spela in (lgg till)";     
    ls->menuVideoStop           = "Stopp";                
    ls->menuVideoRender         = "Spara videofil";   

    ls->menuPrnFormfeed         = "Pappersmatning";

    ls->menuZoomNormal          = "Normal storlek";
    ls->menuZoomDouble          = "Dubbel storlek";
    ls->menuZoomFullscreen      = "Fullskrm";
    
    ls->menuPropsEmulation      = "Emulering";
    ls->menuPropsVideo          = "Video";
    ls->menuPropsSound          = "Ljud";
    ls->menuPropsControls       = "Kontroller";
    ls->menuPropsEffects        = "Effekter";               // New in 2.9
    ls->menuPropsSettings       = "Instllningar";
    ls->menuPropsFile           = "Filer";
    ls->menuPropsDisk           = "Enheter";               // New in 2.7
    ls->menuPropsLanguage       = "Sprk";
    ls->menuPropsPorts          = "Portar";
    
    ls->menuVideoSource         = "Video ut klla";
    ls->menuVideoSourceDefault  = "Ingen videoklla inkopplad";
    ls->menuVideoChipAutodetect = "Automatisk detektering av video chip";    
    ls->menuVideoInSource       = "Video in klla";
    ls->menuVideoInBitmap       = "Bitmap fil";
    
    ls->menuEthInterface        = "Ntverksanslutning"; 

    ls->menuHelpHelp            = "Hjlp";
    ls->menuHelpAbout           = "Om blueMSX";

    ls->menuFileCart            = "Cartridge slot";
    ls->menuFileDisk            = "Diskettstation";
    ls->menuFileCas             = "Kassett";
    ls->menuFilePrn             = "Skrivare";
    ls->menuFileLoadState       = "Ls in CPU-tillstnd";
    ls->menuFileSaveState       = "Spara CPU-tillstnd";
    ls->menuFileQLoadState      = "Snabbladda CPU-tillstnd";
    ls->menuFileQSaveState      = "Snabbspara CPU-tillstnd";
    ls->menuFileCaptureAudio    = "Spara ljud";
    ls->menuFileCaptureVideo    = "Videoinspelning"; 
    ls->menuFileScreenShot      = "Spara skrmdump";
    ls->menuFileExit            = "Avsluta";

    ls->menuFileHarddisk        = "Hrddisk";
    ls->menuFileHarddiskNoPesent= "Inga enheter tillgngliga";
    ls->menuFileHarddiskRemoveAll= "Ta ur alla hrddiskar";    // New in 2.7

    ls->menuRunRun              = "Kr";
    ls->menuRunPause            = "Paus";
    ls->menuRunStop             = "Stanna";
    ls->menuRunSoftReset        = "Mjuk Omstart";
    ls->menuRunHardReset        = "Hrd Omstart";
    ls->menuRunCleanReset       = "Full Omstart";

    ls->menuToolsMachine        = "Konfigureringsverktyg";
    ls->menuToolsShortcuts      = "Kortkommando Verktyg";
    ls->menuToolsKeyboard       = "Tangentbordseditor";
    ls->menuToolsCtrlEditor     = "Kontrollers / Tangenbordseditor"; 
    ls->menuToolsMixer          = "Mixer";
    ls->menuToolsLoadMemory     = "Ladda Minne";
    ls->menuToolsDebugger       = "Avlusare";               
    ls->menuToolsTrainer        = "Spelfusk";                
    ls->menuToolsTraceLogger    = "Sprutskrift";           

    ls->menuFile                = "Arkiv";
    ls->menuRun                 = "Emulering";
    ls->menuWindow              = "Fnster";
    ls->menuOptions             = "Egenskaper";
    ls->menuTools               = "Verktyg";
    ls->menuHelp                = "Hjlp";
    

    //----------------------
    // Dialog related lines
    //----------------------

    ls->dlgOK                   = "OK";
    ls->dlgOpen                 = "ppna";
    ls->dlgCancel               = "Avbryt";
    ls->dlgSave                 = "Spara";
    ls->dlgSaveAs               = "Spara Som...";
    ls->dlgRun                  = "Kr";
    ls->dlgClose                = "Stng";

    ls->dlgLoadRom              = "blueMSX - Ladda en rom fil";
    ls->dlgLoadDsk              = "blueMSX - Ladda en dsk fil";
    ls->dlgLoadCas              = "blueMSX - Ladda en cas fil";
    ls->dlgLoadRomDskCas        = "blueMSX - Ladda en rom, dsk eller cas fil";
    ls->dlgLoadRomDesc          = "Vlj en cartridge fil:";
    ls->dlgLoadDskDesc          = "Vlj en diskett fil:";
    ls->dlgLoadCasDesc          = "Vlj en kassett fil:";
    ls->dlgLoadRomDskCasDesc    = "Vlj en fil:";
    ls->dlgLoadState            = "Ladda CPU-tillstnd";
    ls->dlgLoadVideoCapture     = "Ladda videoinspelning";      
    ls->dlgSaveState            = "Spara CPU-tillstnd";
    ls->dlgSaveCassette         = "blueMSX - Spara Kassett";
    ls->dlgSaveVideoClipAs      = "Spara videoinspeling som...";      
    ls->dlgAmountCompleted      = "Andel frdigt:";          
    ls->dlgInsertRom1           = "Stt in ROM cartridge i slot 1";
    ls->dlgInsertRom2           = "Stt in ROM cartridge i slot 2";
    ls->dlgInsertDiskA          = "Stt in diskett i diskettstation A";
    ls->dlgInsertDiskB          = "Stt in diskett i diskettstation B";
    ls->dlgInsertHarddisk       = "Stt in hrddisk";
    ls->dlgInsertCas            = "Stt in kassettband";
    ls->dlgRomType              = "Rom Typ:";
    ls->dlgDiskSize             = "Diskettstorlek:";             

    ls->dlgTapeTitle            = "blueMSX - Kassettposition";
    ls->dlgTapeFrameText        = "Kassettposition";
    ls->dlgTapeCurrentPos       = "Aktuell position";
    ls->dlgTapeTotalTime        = "Total lngd";
    ls->dlgTapeSetPosText       = "Kassettposition:";
    ls->dlgTapeCustom           = "Visa Specialfiler";
    ls->dlgTabPosition          = "Position";
    ls->dlgTabType              = "Typ";
    ls->dlgTabFilename          = "Filnamn";
    ls->dlgZipReset             = "Starta om efter insttning";
    
    ls->dlgAboutTitle           = "blueMSX - Information";

    ls->dlgLangLangText         = "Vlj sprk som blueMSX ska anvnda";
    ls->dlgLangLangTitle        = "blueMSX - Sprk";

    ls->dlgAboutAbout           = "INFORMATION\r\n========";
    ls->dlgAboutVersion         = "Version:";
    ls->dlgAboutBuildNumber     = "Bygge:";
    ls->dlgAboutBuildDate       = "Datum:";
    ls->dlgAboutCreat           = "Skapat av Daniel Vik";
    ls->dlgAboutDevel           = "UTVECKLARE\r\n========";
    ls->dlgAboutThanks          = "BIDRAGARE\r\n=======";       // New in 2.7 (retranslate, see english)
    ls->dlgAboutLisence         = "LICENS\r\n"
                                  "=====\r\n\r\n"
                                  "Denna programvara r erbjuden 'som den r', utan ngon explicit eller "
                                  "implicit garanti. Inte av ngon hndelse kommer frfattaren/na att hllas "
                                  "ansvariga fr ngra skador orsakade av detta program.\r\n\r\n"
                                  "Besk www.bluemsx.com for mer information.";

    ls->dlgSavePreview          = "Frvisning";
    ls->dlgSaveDate             = "Tid Sparad:";

    ls->dlgRenderVideoCapture   = "blueMSX - Generera videofil...";  


    //----------------------
    // Properties related lines
    //----------------------

    ls->propTitle               = "blueMSX - Egenskaper";
    ls->propEmulation           = "Emulering";
    ls->propVideo               = "Video";
    ls->propSound               = "Ljud";
    ls->propControls            = "Kontroller";
    ls->propPerformance         = "Prestanda";
    ls->propEffects             = "Effekter";             // New in 2.9
    ls->propSettings            = "Instllningar";
    ls->propFile                = "Filer";
    ls->propDisk                = "Enheter";              // New in 2.7
    ls->propPorts               = "Portar";

    ls->propEmuGeneralGB        = "Allmnt ";
    ls->propEmuFamilyText       = "MSX familj:";
    ls->propEmuMemoryGB         = "Minne ";
    ls->propEmuRamSizeText      = "RAM storlek:";
    ls->propEmuVramSizeText     = "VRAM storlek:";
    ls->propEmuSpeedGB          = "Emuleringshastighet ";
    ls->propEmuSpeedText        = "Emuleringshastighet:";
    ls->propEmuFrontSwitchGB    = "Panasonicbrytare ";
    ls->propEmuFrontSwitch      = " Frontbrytare";
    ls->propEmuNoSpriteLimits   = " Ignorera sprite begrnsning";  // New in 2.9
    ls->propEnableMsxKeyboardQuirk = " Emulera MSX tangentbordsfel";  // New in 2.9
    ls->propEmuFdcTiming        = " Sl av diskettstationstiming";
    ls->propEmuReversePlay      = " Tillt baklnges uppspelning";
    ls->propEmuPauseSwitch      = " Pausbrytare";
    ls->propEmuAudioSwitch      = " MSX-AUDIO cartridge switch";
    ls->propVideoFreqText       = "Videofrekvens:";
    ls->propVideoFreqAuto       = "Automatisk";
    ls->propSndOversampleText   = "versampling:";
    ls->propSndYkInGB           = "YK-01/YK-10/YK-20 In ";              
    ls->propSndMidiInGB         = "MIDI In ";
    ls->propSndMidiOutGB        = "MIDI Ut ";
    ls->propSndMidiChannel      = "MIDI Channel:";                      
    ls->propSndMidiAll          = "Alla";                               

    ls->propMonMonGB            = "Monitor ";
    ls->propMonTypeText         = "Monitor typ:";
    ls->propMonEmuText          = "Monitoremulering:";
    ls->propVideoTypeText       = "Videotyp:";
    ls->propWindowSizeText      = "Fnsterstorlek:";
    ls->propMonHorizStretch     = " Horizontell utstrckning";
    ls->propMonVertStretch      = " Vertikal utstrckning";
    ls->propMonDeInterlace      = " De-interlace";
    ls->propBlendFrames         = " Blanda efterfljande bilder";           
    ls->propMonBrightness       = "Ljusstyrka:";
    ls->propMonContrast         = "Kontrast:";
    ls->propMonSaturation       = "Frgmttnad:";
    ls->propMonGamma            = "Gamma:";
    ls->propMonScanlines        = " Scanlinjer:";
    ls->propMonColorGhosting    = " RF-modulering:";
    ls->propMonEffectsGB        = "Effekter ";

    ls->propPerfVideoDrvGB      = "Videodriver ";
    ls->propPerfVideoDispDrvText= "Skrmdriver:";
    ls->propPerfFrameSkipText   = "Frame skipping:";
    ls->propPerfAudioDrvGB      = "Lkuddriver ";
    ls->propPerfAudioDrvText    = "Ljuddriver:";
    ls->propPerfAudioBufSzText  = "Storlek p ljudbuffer:";
    ls->propPerfEmuGB           = "Emulering ";
    ls->propPerfSyncModeText    = "Synkronisering:";
    ls->propFullscreenResText   = "Fullskrmsupplsning:";

    ls->propSndChipEmuGB        = "Emulering av ljudchip ";
    ls->propSndMsxMusic         = " MSX-MUSIC";
    ls->propSndMsxAudio         = " MSX-AUDIO";
    ls->propSndMoonsound        = " Moonsound";
    ls->propSndMt32ToGm         = " Konvertera MT-32 instrument till General MIDI";

    ls->propPortsLptGB          = "Parallellport ";
    ls->propPortsComGB          = "Serieportar ";
    ls->propPortsLptText        = "Port:";
    ls->propPortsCom1Text       = "Port 1:";
    ls->propPortsNone           = "Ingen";
    ls->propPortsSimplCovox     = "SiMPL / Covox DAC";
    ls->propPortsFile           = "Skriv till Fil";
    ls->propPortsComFile        = "Skicka till Fil";
    ls->propPortsOpenLogFile    = "ppna Logfil";
    ls->propPortsEmulateMsxPrn  = "Emulering:";

    ls->propSetFileHistoryGB    = "Filhistoria ";
    ls->propSetFileHistorySize  = "Antal element i filhistorian:";
    ls->propSetFileHistoryClear = "Rensa historia";
    ls->propFileTypes           = " Registrera filtyper med blueMSX (.rom, .dsk, .cas, .sta)";
    ls->propWindowsEnvGB        = "Windows Milj ";
    ls->propSetScreenSaver      = " Deaktivera skrmslckare nr blueMSX kr";
    ls->propDisableWinKeys      = " Avaktivera Windows menyer nr emulatorn kr";
    ls->propPriorityBoost       = " Hj prioriteten p blueMSX";
    ls->propScreenshotPng       = " Anvnd Portable Network Graphics (.png) skrmdump";
    ls->propEjectMediaOnExit    = " Ta ur media nr blueMSX avslutas";
    ls->propClearHistory        = "Vill du verkligen radera filhistorien?";
    ls->propOpenRomGB           = "ppna Rom Dialog ";
    ls->propDefaultRomType      = "Default Rom Typ:";
    ls->propGuessRomType        = "Gissa Rom Typ";

    ls->propSettDefSlotGB       = "Dra och Slpp ";
    ls->propSettDefSlots        = "Stt in Rom i:";
    ls->propSettDefSlot         = " Slot";
    ls->propSettDefDrives       = "Stt in Diskett i:";
    ls->propSettDefDrive        = " Drive";

    ls->propThemeGB             = "Tema ";
    ls->propTheme               = "Tema";

    ls->propCdromGB             = "CD-ROM ";         // New in 2.7
    ls->propCdromMethod         = "tkomstmetod:";   // New in 2.7
    ls->propCdromMethodNone     = "Ingen";           // New in 2.7
    ls->propCdromMethodIoctl    = "IOCTL";           // New in 2.7
    ls->propCdromMethodAspi     = "ASPI";            // New in 2.7
    ls->propCdromDrive          = "Enhet:";          // New in 2.7

    ls->propD3DParametersGB         = "Parametrar ";                // New in 2.9
    ls->propD3DAspectRatioText      = "Aspect ratio";               // New in 2.9
    ls->propD3DLinearFilteringText  = " Linjrt filter";          // New in 2.9
    ls->propD3DForceHighResText     = " Tvinga hgupplsning";     // New in 2.9
    ls->propD3DExtendBorderColorText    = " Expandera ramfrger";   // New in 2.9

    ls->propD3DCroppingGB               = "Trimning ";              // New in 2.9
    ls->propD3DCroppingTypeText         = "Trimningstyp:";         // New in 2.9
    ls->propD3DCroppingLeftText         = "Vnster:";                  // New in 2.9
    ls->propD3DCroppingRightText        = "Hger:";                 // New in 2.9
    ls->propD3DCroppingTopText          = "Upptill:";                   // New in 2.9
    ls->propD3DCroppingBottomText       = "Nertill:";                // New in 2.9


    //----------------------
    // Dropdown related lines
    //----------------------

    ls->enumVideoMonColor       = "Frg";
    ls->enumVideoMonGrey        = "Svartvit";
    ls->enumVideoMonGreen       = "Grn";
    ls->enumVideoMonAmber       = "Orange";

    ls->enumVideoTypePAL        = "PAL";
    ls->enumVideoTypeNTSC       = "NTSC";

    ls->enumVideoEmuNone        = "Ingen";
    ls->enumVideoEmuYc          = "Y/C kabel (skarp)";
    ls->enumVideoEmuMonitor     = "Monitor";
    ls->enumVideoEmuYcBlur      = "Brusig Y/C kabel (skarp)";
    ls->enumVideoEmuComp        = "Kompositkabel (suddig)";
    ls->enumVideoEmuCompBlur    = "Brusig komposit (suddig)";
    ls->enumVideoEmuScale2x     = "Scale 2x";
    ls->enumVideoEmuHq2x        = "Hq2x";

    ls->enumVideoSize1x         = "Normal - 320x200";
    ls->enumVideoSize2x         = "Dubbel - 640x400";
    ls->enumVideoSizeFullscreen = "Fullskrm";

    ls->enumVideoDrvDirectDrawHW= "DirectDraw HW accel.";
    ls->enumVideoDrvDirectDraw  = "DirectDraw";
    ls->enumVideoDrvGDI         = "GDI";
    ls->enumVideoDrvD3D         = "Direct3D";

    ls->enumVideoFrameskip0     = "Ingen";
    ls->enumVideoFrameskip1     = "1 bild";
    ls->enumVideoFrameskip2     = "2 bilder";
    ls->enumVideoFrameskip3     = "3 bilder";
    ls->enumVideoFrameskip4     = "4 bilder";
    ls->enumVideoFrameskip5     = "5 bilder";

    ls->enumD3DARAuto           = "Automatisk";           // New in 2.9
    ls->enumD3DARStretch        = "Utstrckt";        // New in 2.9
    ls->enumD3DARPAL            = "PAL";            // New in 2.9
    ls->enumD3DARNTSC           = "NTSC";           // New in 2.9
    ls->enumD3DAR11             = "1:1";            // New in 2.9

    ls->enumD3DCropNone         = "Ingen";           // New in 2.9
    ls->enumD3DCropMSX1         = "MSX1";           // New in 2.9
    ls->enumD3DCropMSX1Plus8    = "MSX1+8";         // New in 2.9
    ls->enumD3DCropMSX2         = "MSX2";           // New in 2.9
    ls->enumD3DCropMSX2Plus8    = "MSX2+8";         // New in 2.9
    ls->enumD3DCropCustom       = "Individuell";         // New in 2.9

    ls->enumSoundDrvNone        = "Inget ljud";
    ls->enumSoundDrvWMM         = "WMM driver";
    ls->enumSoundDrvDirectX     = "DirectX driver";

    ls->enumEmuSync1ms          = "Synkronisera till MSX refresh";
    ls->enumEmuSyncVblank       = "Synkronisera till PC Vertikal Blank";
    ls->enumEmuAsyncVblank      = "Asynchronous PC Vblank";             
    ls->enumEmuSyncNone         = "Ingen";
    ls->enumEmuSyncAuto         = "Automatisk (snabb)";

    ls->enumControlsJoyNone     = "Ingen";
    ls->enumControlsJoyMouse    = "Mus";
    ls->enumControlsJoyTetris2Dongle = "Tetris 2 dosa";
    ls->enumControlsJoyTMagicKeyDongle = "MagicKey dosa";
    ls->enumControlsJoy2Button = "2-knapps Styrspak";                   
    ls->enumControlsJoyGunstick  = "Gun Stick";                         
    ls->enumControlsJoyAsciiLaser="ASCII Plus-X Terminator Laser";      
    ls->enumControlsArkanoidPad  ="Arkanoid Pad";                   // New in 2.7.1
    ls->enumControlsJoyColeco = "ColecoVision Styrspak";                

    ls->enumDiskMsx35Dbl9Sect    = "MSX 3.5\" Dubbelsidig, 9 Sektorer";     
    ls->enumDiskMsx35Dbl8Sect    = "MSX 3.5\" Dubbelsidig, 8 Sektorer";     
    ls->enumDiskMsx35Sgl9Sect    = "MSX 3.5\" Enkelsidig, 9 Sektorer";     
    ls->enumDiskMsx35Sgl8Sect    = "MSX 3.5\" Enkelsidig, 8 Sektorer";     
    ls->enumDiskSvi525Dbl        = "SVI-328\" 5.25 Dubbelsidig";           
    ls->enumDiskSvi525Sgl        = "SVI-328\" 5.25 Enkelsidig";   
    ls->enumDiskSf3Sgl           = "Sega SF-7000 3\" Enkelsidig";  


    //----------------------
    // Configuration related lines
    //----------------------

    ls->confTitle               = "blueMSX - Konfigureringsverktyg";
    ls->confConfigText          = "Konfigurering:";
    ls->confSlotLayout          = "Slot mappning";
    ls->confMemory              = "Minne";
    ls->confChipEmulation       = "Chipemulering";
    ls->confChipExtras          = "Extra";

    ls->confOpenRom             = "ppna Rom fil";
    ls->confSaveTitle           = "blueMSX - Spara Konfigurering";
    ls->confSaveText            = "Vill du skriva ver maskinkonfigureringen? :";
    ls->confSaveAsTitle         = "Spara Konfigurering Som...";
    ls->confSaveAsMachineName   = "Maskinnamn:";
    ls->confDiscardTitle        = "blueMSX - Konfigurering";
    ls->confExitSaveTitle       = "blueMSX - Avsluta Konfigureringsverktyg";
    ls->confExitSaveText        = "Vill du stanga konfigureringsverktyget utan att spara dina ndringar?";

    ls->confSlotLayoutGB        = "Slot Layout ";
    ls->confSlotExtSlotGB       = "Externa slots ";
    ls->confBoardGB             = "Board ";
    ls->confBoardText           = "Board Typ:";
    ls->confSlotPrimary         = "Primr";
    ls->confSlotExpanded        = "Expanderad (4 subslottar)";

    ls->confSlotCart            = "Cartridge:";
    ls->confSlot                = "Slot";
    ls->confSubslot             = "Subslot";

    ls->confMemAdd               = "Ny...";
    ls->confMemEdit              = "ndra...";
    ls->confMemRemove            = "Ta Bort";
    ls->confMemSlot              = "Slot";
    ls->confMemAddresss          = "Adress";
    ls->confMemType              = "Typ";
    ls->confMemRomImage          = "Rom Fil";
    
    ls->confChipVideoGB          = "Video ";
    ls->confChipVideoChip        = "Video Chip:";
    ls->confChipVideoRam         = "Video RAM:";
    ls->confChipSoundGB          = "Audio ";
    ls->confChipPsgStereoText    = " PSG Stereo";

    ls->confCmosGB               = "CMOS ";
    ls->confCmosEnable           = " Anvnd CMOS";
    ls->confCmosBattery          = " Anvnd Laddat Batteri";

    ls->confCpuFreqGB            = "CPU Frekvens ";
    ls->confZ80FreqText          = "Z80 Frekvens:";
    ls->confR800FreqText         = "R800 Frekvens:";
    ls->confFdcGB                = "Kontroller fr Diskettenhet ";
    ls->confCFdcNumDrivesText    = "Antal Diskettenheter:";

    ls->confEditMemTitle         = "blueMSX - ndra Minnesmap";
    ls->confEditMemGB            = "Detailjer ";
    ls->confEditMemType          = "Typ:";
    ls->confEditMemFile          = "Fil:";
    ls->confEditMemAddress       = "Adress";
    ls->confEditMemSize          = "Storlek";
    ls->confEditMemSlot          = "Slot";


    //----------------------
    // Shortcut lines
    //----------------------

    ls->shortcutKey             = "Tangentkombination";
    ls->shortcutDescription     = "Kortkommando";

    ls->shortcutSaveConfig      = "blueMSX - Spara Konfigurering";
    ls->shortcutOverwriteConfig = "Vill du skriva ver kortkommando konfigureringen:";
    ls->shortcutExitConfig      = "blueMSX - Avsluta Kortkommandoverktyget";
    ls->shortcutDiscardConfig   = "Vill du stanga konfigureringsverktyget utan att spara dina ndringar?";
    ls->shortcutSaveConfigAs    = "blueMSX - Spara Kortkommando Konfigurering Som...";
    ls->shortcutConfigName      = "Konfigurering:";
    ls->shortcutNewProfile      = "< Ny Profil >";
    ls->shortcutConfigTitle     = "blueMSX - Konfigurering av Kortkommandon";
    ls->shortcutAssign          = "Tilldela";
    ls->shortcutPressText       = "Tryck kortkommando:";
    ls->shortcutScheme          = "Kommandoschema:";
    ls->shortcutCartInsert1     = "Stt in Cartridge 1";
    ls->shortcutCartRemove1     = "Ta ur Cartridge 1";
    ls->shortcutCartInsert2     = "Stt in Cartridge 2";
    ls->shortcutCartRemove2     = "Ta ur Cartridge 2";
    ls->shortcutSpecialMenu1    = "Visa Specialrom meny fr Cartridge 1";
    ls->shortcutSpecialMenu2    = "Visa Specialrom meny fr Cartridge 2";
    ls->shortcutCartAutoReset   = "Starta om efter Insttning av Cartridge";
    ls->shortcutDiskInsertA     = "Stt in Diskett A";
    ls->shortcutDiskDirInsertA  = "Stt in Directory som Diskett A";
    ls->shortcutDiskRemoveA     = "Ta ur Diskett A";
    ls->shortcutDiskChangeA     = "Snabbbyt Diskett A";
    ls->shortcutDiskAutoResetA  = "Starta om efter Insttning av Diskett";
    ls->shortcutDiskInsertB     = "Stt in Diskett B";
    ls->shortcutDiskDirInsertB  = "Stt in Directory som Diskett B";
    ls->shortcutDiskRemoveB     = "Ta ur Diskett B";
    ls->shortcutCasInsert       = "Stt in Kassett";
    ls->shortcutCasEject        = "Ta ur Kassett";
    ls->shortcutCasAutorewind   = "Sl Av/P Automatisk Tillbakaspolning";
    ls->shortcutCasReadOnly     = "Sl Av/P Skrivskydd p Kassettfiler";
    ls->shortcutCasSetPosition  = "Stt Kassettposition";
    ls->shortcutCasRewind       = "Spola Tillabaka Kassett";
    ls->shortcutCasSave         = "Spara Kassett till fil";
    ls->shortcutPrnFormFeed     = "Form Feed p Skrivare";
    ls->shortcutCpuStateLoad    = "Ladda CPU-tillstnd";
    ls->shortcutCpuStateSave    = "Spara CPU-tillstnd";
    ls->shortcutCpuStateQload   = "Snabbladda CPU-tillstnd";
    ls->shortcutCpuStateQsave   = "Snabbspara CPU-tillstnd";
    ls->shortcutAudioCapture    = "Starta/Stanna Audioinspelning";
    ls->shortcutScreenshotOrig  = "Spar Skrmdump";
    ls->shortcutScreenshotSmall = "Spar Liten Ofiltrerad Skrmdump";
    ls->shortcutScreenshotLarge = "Spar Stor Ofiltrerad Skrmdump";
    ls->shortcutQuit            = "Avsluta blueMSX";
    ls->shortcutRunPause        = "Kr/Pause Emuleringen";
    ls->shortcutStop            = "Stanna Emuleringen";
    ls->shortcutResetHard       = "Hrd Omstart";
    ls->shortcutResetSoft       = "Mjuk Omstart";
    ls->shortcutResetClean      = "Full Omstart";
    ls->shortcutSizeSmall       = "Vxla till Liten Fnsterstorlek";
    ls->shortcutSizeNormal      = "Vxla till Normal Fnsterstorlek";
    ls->shortcutSizeFullscreen  = "Vxla till Fullskrm";
    ls->shortcutSizeMinimized   = "Minimera fnster";
    ls->shortcutToggleFullscren = "Vxla till/frn Fullskrm";
    ls->shortcutVolumeIncrease  = "ka Volymen";
    ls->shortcutVolumeDecrease  = "Minska Volymen";
    ls->shortcutVolumeMute      = "Stng av Volymen";
    ls->shortcutVolumeStereo    = "Vxla mellan mono/stereo";
    ls->shortcutSwitchMsxAudio  = "Sl om MSX-AUDIO brytare";
    ls->shortcutSwitchFront     = "Sl om Panasonic Front brytare";
    ls->shortcutSwitchPause     = "Sl om Pausbrytare";
    ls->shortcutToggleMouseLock = "Sl om Musls";
    ls->shortcutEmuSpeedMax     = "Maximal Emuleringshastighet";
    ls->shortcutEmuPlayReverse  = "Spola tillbaka";                     // New in 2.8.3
    ls->shortcutEmuSpeedToggle  = "Vxla Mellan Normal och Max Emuleringshastighet";
    ls->shortcutEmuSpeedNormal  = "Minska Emuleringhastigheten";
    ls->shortcutEmuSpeedInc     = "ka Emuleringhastigheten";
    ls->shortcutEmuSpeedDec     = "Minska Emuleringhastigheten";
    ls->shortcutThemeSwitch     = "Vxla fnstretema";
    ls->shortcutShowEmuProp     = "ppna Emuleringsfnstret";
    ls->shortcutShowVideoProp   = "ppna Videofnstret";
    ls->shortcutShowAudioProp   = "ppna Audiofnstret";
    ls->shortcutShowCtrlProp    = "ppna Kontrollfnstret";
    ls->shortcutShowEffectsProp    = "ppna Effektsfnstret";
    ls->shortcutShowSettProp    = "ppna Instllningsfnstret";
    ls->shortcutShowPorts       = "Visa Portegenskaper";
    ls->shortcutShowLanguage    = "ppna Sprkfnstret";
    ls->shortcutShowMachines    = "ppna Konfigureringsverktyget";
    ls->shortcutShowShortcuts   = "ppna Kortkommandoverktyget";
    ls->shortcutShowKeyboard    = "Visa Tangentbordseditor";
    ls->shortcutShowDebugger    = "Visa Debugger";
    ls->shortcutShowTrainer     = "Visa Trainer";
    ls->shortcutShowMixer       = "Visa Mixer";
    ls->shortcutShowHelp        = "ppna Hjlpfnstret";
    ls->shortcutShowAbout       = "ppna \"Om blueMSX\"-fnstret";
    ls->shortcutShowFiles       = "ppna Filerfnstret";
    ls->shortcutToggleSpriteEnable = "Visa/Dlj Sprites";
    ls->shortcutToggleFdcTiming = "Sl p/av Diskettstationstiming";
    ls->shortcutToggleNoSpriteLimits = "Sla p/av Spritebegrnsning";                 // New in 2.9
    ls->shortcutEnableMsxKeyboardQuirk = "Emulera MSX Keyboardfel";              // New in 2.9
    ls->shortcutToggleCpuTrace  = "Sl p/av CPU trace";
    ls->shortcutVideoLoad       = "Ladda...";             
    ls->shortcutVideoPlay       = "Spela upp senaste";   
    ls->shortcutVideoRecord     = "Spela in";              
    ls->shortcutVideoStop       = "Stopp";                
    ls->shortcutVideoRender     = "Spara videofil";   


    //----------------------
    // Keyboard config lines
    //----------------------

    ls->keyconfigSelectedKey    = "Vlj tangent:";
    ls->keyconfigMappedTo       = "Mappad till:";
    ls->keyconfigMappingScheme  = "Mapschema:";

    
    //----------------------
    // Rom type lines
    //----------------------

    ls->romTypeStandard         = "Standard";
    ls->romTypeZenima80         = "Zemina 80 in 1";
    ls->romTypeZenima90         = "Zemina 90 in 1";
    ls->romTypeZenima126        = "Zemina 126 in 1";
    ls->romTypeSccMirrored      = "SCC mirrored";
    ls->romTypeSccExtended      = "SCC extended";
    ls->romTypeKonamiGeneric    = "Konami Generic";
    ls->romTypeMirrored         = "Mirrored ROM";
    ls->romTypeNormal           = "Normal ROM";
    ls->romTypeDiskPatch        = "Normal + Disk Patch";
    ls->romTypeCasPatch         = "Normal + Cassette Patch";
    ls->romTypeTc8566afFdc      = "TC8566AF Disk Controller";
    ls->romTypeTc8566afTrFdc    = "TC8566AF Turbo-R Disk Controller";
    ls->romTypeMicrosolFdc      = "Microsol Disk Controller";
    ls->romTypeNationalFdc      = "National Disk Controller";
    ls->romTypePhilipsFdc       = "Philips Disk Controller";
    ls->romTypeSvi707Fdc        = "SVI-707 Disk Controller";
    ls->romTypeSvi738Fdc        = "SVI-738 Disk Controller";
    ls->romTypeMappedRam        = "Mapped RAM";
    ls->romTypeMirroredRam1k    = "1kB Mirrored RAM";
    ls->romTypeMirroredRam2k    = "2kB Mirrored RAM";
    ls->romTypeNormalRam        = "Normal RAM";
    ls->romTypeTurborPause      = "Turbo-R Pause";
    ls->romTypeF4deviceNormal   = "F4 Enhet Normal";
    ls->romTypeF4deviceInvert   = "F4 Enhet Inverted";
    ls->romTypeTurborTimer      = "Turbo-R Timer";
    ls->romTypeNormal4000       = "Normal 4000h";
    ls->romTypeNormalC000       = "Normal C000h";
    ls->romTypeExtRam           = "External RAM";
    ls->romTypeExtRam16         = "16kB External RAM";
    ls->romTypeExtRam32         = "32kB External RAM";
    ls->romTypeExtRam48         = "48kB External RAM";
    ls->romTypeExtRam64         = "64kB External RAM";
    ls->romTypeExtRam512        = "512kB External RAM";
    ls->romTypeExtRam1mb        = "1MB External RAM";
    ls->romTypeExtRam2mb        = "2MB External RAM";
    ls->romTypeExtRam4mb        = "4MB External RAM";
    ls->romTypeSvi328Cart       = "SVI-328 Cartridge";
    ls->romTypeSvi328Fdc        = "SVI-328 Disk Controller";
    ls->romTypeSvi328Prn        = "SVI-328 Printer";
    ls->romTypeSvi328Uart       = "SVI-328 Serial Port";
    ls->romTypeSvi328col80      = "SVI-328 80 Column Card";
    ls->romTypeSvi727col80      = "SVI-727 80 Column Card";
    ls->romTypeColecoCart       = "Coleco Cartridge";
    ls->romTypeSg1000Cart       = "SG-1000 Cartridge";
    ls->romTypeSc3000Cart       = "SC-3000 Cartridge";
    ls->romTypeMsxPrinter       = "MSX Printer";
    ls->romTypeTurborPcm        = "Turbo-R PCM Chip";
    ls->romTypeNms8280Digitiz   = "Philips NMS-8280 Digitizer";
    ls->romTypeHbiV1Digitiz     = "Sony HBI-V1 Digitizer";
    
    
    //----------------------
    // Debug type lines
    // Note: Only needs translation if debugger is translated
    //----------------------

    ls->dbgMemVisible           = "Visible Memory";
    ls->dbgMemRamNormal         = "Normal";
    ls->dbgMemRamMapped         = "Mapped";
    ls->dbgMemYmf278            = "YMF278 Sample RAM";
    ls->dbgMemAy8950            = "AY8950 Sample RAM";
    ls->dbgMemScc               = "Memory";

    ls->dbgCallstack            = "Callstack";

    ls->dbgRegs                 = "Registers";
    ls->dbgRegsCpu              = "CPU Registers";
    ls->dbgRegsYmf262           = "YMF262 Registers";
    ls->dbgRegsYmf278           = "YMF278 Registers";
    ls->dbgRegsAy8950           = "AY8950 Registers";
    ls->dbgRegsYm2413           = "YM2413 Registers";

    ls->dbgDevRamMapper         = "RAM Mapper";
    ls->dbgDevRam               = "RAM";
    ls->dbgDevF4Device          = "F4 Enhet";
    ls->dbgDevKorean80          = "Korean 80";
    ls->dbgDevKorean90          = "Korean 90";
    ls->dbgDevKorean128         = "Korean 128";
    ls->dbgDevFdcMicrosol       = "Microsol FDC";
    ls->dbgDevPrinter           = "Printer";
    ls->dbgDevSviFdc            = "SVI FDC";
    ls->dbgDevSviPrn            = "SVI Printer";
    ls->dbgDevSvi80Col          = "SVI 80 Column";
    ls->dbgDevRtc               = "RTC";
    ls->dbgDevTrPause           = "TR Pause";


    //----------------------
    // Debug type lines
    // Note: Can only be translated to european languages
    //----------------------
    ls->aboutScrollThanksTo     = "Speciellt tack till: ";
    ls->aboutScrollAndYou       = "och DIG !!!!";
};

#endif
