/*****************************************************************************
** $Source: /cygdrive/d/Private/_SVNROOT/bluemsx/blueMSX/Src/Language/LanguageJapanese.h,v $
**
** $Revision: 1.68 $
**
** $Date: 2009-04-04 20:57:19 $
**
** More info: http://www.bluemsx.com
**
** Copyright (C) 2003-2006 Daniel Vik
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
******************************************************************************
*/

#ifndef LANGUAGE_JAPANESE_H
#define LANGUAGE_JAPANESE_H

#include "LanguageStrings.h"

void langInitJapanese(LanguageStrings* ls) 

{
    //----------------------
    // Language lines
    //----------------------

    ls->langCatalan             = "Catalan";
    ls->langChineseSimplified   = "(ȑ̎)";
    ls->langChineseTraditional  = "(ɑ̎)";
    ls->langDutch               = "I_";
    ls->langEnglish             = "p";
    ls->langFinnish             = "tBh";
    ls->langFrench              = "tX";
    ls->langGerman              = "hCc";
    ls->langItalian             = "C^A";
    ls->langJapanese            = "{";
    ls->langKorean              = "؍";
    ls->langPolish              = "|[h";
    ls->langPortuguese          = "|gK";
    ls->langRussian             = "Russian";            // v2.8
    ls->langSpanish             = "XyC";
    ls->langSwedish             = "XEF[f";


    //----------------------
    // Generic lines
    //----------------------

    ls->textDevice              = "foCX:";
    ls->textFilename            = "t@C:";
    ls->textFile                = "t@C";
    ls->textNone                = "Ȃ";
    ls->textUnknown             = "s";


    //----------------------
    // Warning and Error lines
    //----------------------

    ls->warningTitle            = "blueMSX - x";
    ls->warningDiscardChanges   = "\\܂A낵ł?";
    ls->warningOverwriteFile    = "̃t@Cɏ㏑Ă낵ł:"; 
    ls->errorTitle              = "blueMSX - G[";
    ls->errorEnterFullscreen    = "tXN[[hɂł܂B          \n";
    ls->errorDirectXFailed      = "DirectX IuWFNg쐬ł܂B          \nGDIɎgp܂B\nOtBbNJ[h̐ݒmFĂB";
    ls->errorNoRomInZip         = "zipt@C̒.romt@C܂B";
    ls->errorNoDskInZip         = "zipt@C̒.dskt@C܂B";
    ls->errorNoCasInZip         = "zipt@C̒.cast@C܂B";
    ls->errorNoHelp             = "blueMSX ̃wvt@C܂B";
    ls->errorStartEmu           = "blueMSX ̊JnɎs܂B";
    ls->errorPortableReadonly   = "|[^ufoCX͓ǍpłB";


    //----------------------
    // File related lines
    //----------------------

    ls->fileRom                 = "ROM C[W";
    ls->fileAll                 = "SẴt@C";
    ls->fileCpuState            = "CPU Xe[g";
    ls->fileVideoCapture        = "rfĨLv`"; 
    ls->fileDisk                = "fBXNC[W";
    ls->fileCas                 = "e[vC[W";
    ls->fileAvi                 = "rfI Nbv";    


    //----------------------
    // Menu related lines
    //----------------------

    ls->menuNoRecentFiles       = "(gpt@CȂ)";
    ls->menuInsert              = "}";
    ls->menuEject               = "o";

    ls->menuCartGameReader      = "Q[[_[ɐڑ";
    ls->menuCartIde             = "IDE J[gbW";
    ls->menuCartBeerIde         = "Beer IDE";
    ls->menuCartGIde            = "GIDE";
    ls->menuCartSunriseIde      = "Sunrise IDE";
    ls->menuCartScsi            = "SCSI J[gbW";          // New in 2.7
    ls->menuCartMegaSCSI        = "MEGA-SCSI";                  // New in 2.7
    ls->menuCartWaveSCSI        = "WAVE-SCSI";                  // New in 2.7
    ls->menuCartGoudaSCSI       = "Gouda SCSI";                 // New in 2.7
    ls->menuJoyrexPsg           = "Joyrex PSG J[gbW"; // New in 2.9
    ls->menuCartSCC             = "SCC J[gbW";
    ls->menuCartSCCPlus         = "SCC-I J[gbW";
    ls->menuCartFMPac           = "FMPAC+ J[gbW";
    ls->menuCartPac             = "PAC+ J[gbW";
    ls->menuCartHBI55           = "Sony HBI-55 J[gbW";
    ls->menuCartInsertSpecial   = "J[gbW";
    ls->menuCartMegaRam         = "KRAM J[gbW";
    ls->menuCartExternalRam     = "ORAM J[gbW"; 
    ls->menuCartEseRam          = "RAM J[gbW";       // New in 2.7
    ls->menuCartEseSCC          = "SCC J[gbW";       // New in 2.7
    ls->menuCartMegaFlashRom    = "Mega Flash ROM";             // New in 2.7

    ls->menuDiskInsertNew       = "VKfBXNC[W}";
    ls->menuDiskInsertCdrom     = "CD-ROM}";          // New in 2.7
    ls->menuDiskDirInsert       = "fBNg}";
    ls->menuDiskAutoStart       = "}/oナZbg";
    ls->menuCartAutoReset       = "}/oナZbg";

    ls->menuCasRewindAfterInsert = "}㊪߂";
    ls->menuCasUseReadOnly       = "e[vǂݍݐpɂ";
    ls->lmenuCasSaveAs           = "e[vʖŕۑ...";
    ls->menuCasSetPosition      = "e[vʒuZbg";
    ls->menuCasRewind           = "߂";

    ls->menuVideoLoad           = "ǂݍ...";             
    ls->menuVideoPlay           = "Lv`f̍Đ";   
    ls->menuVideoRecord         = "^";              
    ls->menuVideoRecording      = "^撆";           
    ls->menuVideoRecAppend      = "^ (t)";     
    ls->menuVideoStop           = "~";                
    ls->menuVideoRender         = "rfIt@C̃_O";   
    
    ls->menuPrnFormfeed         = ""; 

    ls->menuZoomNormal          = "WTCY";
    ls->menuZoomDouble          = "2{TCY";
    ls->menuZoomFullscreen      = "tXN[";
    
    ls->menuPropsEmulation      = "G~[V";
    ls->menuPropsVideo          = "rfI";
    ls->menuPropsSound          = "TEh";
    ls->menuPropsControls       = "Rg[";
    ls->menuPropsEffects        = "Effects";               // New in 2.9
    ls->menuPropsSettings       = "̑";
    ls->menuPropsFile           = "t@C";
    ls->menuPropsDisk           = "fBXN";            // New in 2.7
    ls->menuPropsLanguage       = "";
    ls->menuPropsPorts          = "|[g";
    
    ls->menuVideoChipAutodetect = "rfI`bv̎F";
    ls->menuVideoSource         = "rfIo";
    ls->menuVideoSourceDefault  = "rfIo͂܂";
    ls->menuVideoInSource       = "rfI";
    ls->menuVideoInBitmap       = "rbg}bvt@C";
    
    ls->menuEthInterface        = "C[T[lbg@C^[tF[X"; 

    ls->menuHelpHelp            = "wvڎ";
    ls->menuHelpAbout           = "blueMSXɂ";

    ls->menuFileCart            = "ROMXbg";
    ls->menuFileDisk            = "fBXNhCu";
    ls->menuFileCas             = "JZbge[v";
    ls->menuFilePrn             = "v^["; 
    ls->menuFileLoadState       = "CPUXe[gǍ";
    ls->menuFileSaveState       = "CPUXe[gۑ";
    ls->menuFileQLoadState      = "NCbN[h";
    ls->menuFileQSaveState      = "NCbNZ[u";
    ls->menuFileCaptureAudio    = "^";
    ls->menuFileCaptureVideo    = "rfĨLv`"; 
    ls->menuFileScreenShot      = "XN[Vbg";
    ls->menuFileExit            = "I";

    ls->menuFileHarddisk        = "n[hfBXN";
    ls->menuFileHarddiskNoPesent= "n[hfBXN͖ł";
    ls->menuFileHarddiskRemoveAll= "n[hfBXNSĎo"; // New in 2.7

    ls->menuRunRun              = "s";
    ls->menuRunPause            = "f";
    ls->menuRunStop             = "~";
    ls->menuRunSoftReset        = "\\tgZbg";
    ls->menuRunHardReset        = "n[hZbg";
    ls->menuRunCleanReset       = "N[Zbg";

    ls->menuToolsMachine         = "}V\\ҏW";
    ls->menuToolsShortcuts      = "V[gJbg\\ҏW";
    ls->menuToolsCtrlEditor     = "Rg[[ / L[{[h\\ҏW"; 
    ls->menuToolsMixer          = "~LT[";
    ls->menuToolsDebugger       = "fobK[";
    ls->menuToolsTrainer        = "g[i[";
    ls->menuToolsTraceLogger    = "g[XK[";

    ls->menuFile                = "t@C";
    ls->menuRun                 = "s";
    ls->menuWindow              = "EBhE";
    ls->menuOptions             = "IvV";
    ls->menuTools                = "c[";
    ls->menuHelp                = "wv";


    //----------------------
    // Dialog related lines
    //----------------------

    ls->dlgOK                   = "OK";
    ls->dlgOpen                  = "J";
    ls->dlgCancel               = "LZ";
    ls->dlgSave                 = "ۑ";
    ls->dlgSaveAs               = "ʖۑ...";
    ls->dlgRun                  = "N";
    ls->dlgClose                = "";

    ls->dlgLoadRom              = "blueMSX - romC[WI";
    ls->dlgLoadDsk              = "blueMSX - dskC[WI";
    ls->dlgLoadCas              = "blueMSX - casC[WI";
    ls->dlgLoadRomDskCas        = "blueMSX - rom, dsk, ܂casC[WI";
    ls->dlgLoadRomDesc          = "ǂݍromC[W:";
    ls->dlgLoadDskDesc          = "ǂݍdskC[W:";
    ls->dlgLoadCasDesc          = "ǂݍcasC[W:";
    ls->dlgLoadRomDskCasDesc    = "ǂݍrom, dsk, casC[W:";
    ls->dlgLoadState            = "CPUXe[g ǂݍ";
    ls->dlgLoadVideoCapture     = "Lv`f̓ǂݍ";      
    ls->dlgSaveState            = "CPUXe[g ۑ";
    ls->dlgSaveCassette          = "blueMSX - e[vۑ";
    ls->dlgSaveVideoClipAs      = "rfINbvʖŕۑ...";      
    ls->dlgAmountCompleted      = ":";          
    ls->dlgInsertRom1           = "ROM C[WXbg1ɑ}";
    ls->dlgInsertRom2           = "ROM C[WXbg2ɑ}";
    ls->dlgInsertDiskA          = "fBXNC[WhCuAɑ}";
    ls->dlgInsertDiskB          = "fBXNC[WhCuBɑ}";
    ls->dlgInsertHarddisk       = "n[hfBXN}";                   
    ls->dlgInsertCas            = "JZbge[v}";
    ls->dlgRomType              = "ROM ^Cv:"; 
    ls->dlgDiskSize             = "fBXNv:";             

    ls->dlgTapeTitle            = "blueMSX - JZbge[v";
    ls->dlgTapeFrameText        = "e[vʒu";
    ls->dlgTapeCurrentPos       = "݈ʒu";
    ls->dlgTapeTotalTime        = "g[^^C";
    ls->dlgTapeSetPosText        = "e[vʒu:";
    ls->dlgTapeCustom            = "JX^t@C\\";
    ls->dlgTabPosition           = "ʒu";
    ls->dlgTabType               = "^Cv";
    ls->dlgTabFilename           = "t@C";
    ls->dlgZipReset             = "}ナZbg";

    ls->dlgAboutTitle           = "blueMSX ɂ";

    ls->dlgLangLangText         = "blueMSX Ŏgp錾IĂ";
    ls->dlgLangLangTitle        = "blueMSX - ";

    ls->dlgAboutAbout           = "̃\\tgɂ\r\n===========";
    ls->dlgAboutVersion         = "o[W:";
    ls->dlgAboutBuildNumber     = "rh:";
    ls->dlgAboutBuildDate       = "rht:";
    ls->dlgAboutCreat           = ":\tDaniel Vik";
    ls->dlgAboutDevel           = "J\r\n=====";
    ls->dlgAboutThanks          = "͂X\r\n=============";       // New in 2.7 (retranslate, see english)
    ls->dlgAboutLisence         = "CZX\r\n"
                                  "======\r\n\r\n"
                                  "̃\\tgEFA͌̂܂܂̏ԂŔzẑłAI܂"
                                  "َI킸؂̕ۏ؂͂܂B܂Ã\\tgEFA̎gp̌ʐ"
                                  "Ȃ鑹QɂĂA҂͐ӔC𕉂܂B\r\n\r\n"
                                  "ڂɂẮAwww.bluemsx.com B";

    ls->dlgSavePreview          = "vr[\\";
    ls->dlgSaveDate             = "Z[u:";

    ls->dlgRenderVideoCapture   = "blueMSX - Lv`f_O...";  


    //----------------------
    // Properties related lines
    //----------------------

    ls->propTitle               = "blueMSX - ݒ";
    ls->propEmulation           = "G~[V";
    ls->propVideo               = "rfI";
    ls->propSound               = "TEh";
    ls->propControls            = "Rg[";
    ls->propPerformance         = "ptH[}X";
    ls->propEffects             = "Effects";             // New in 2.9
    ls->propSettings            = "̑";
    ls->propFile                = "t@C";
    ls->propDisk                = "fBXN";            // New in 2.7
    ls->propPorts               = "|[g";
    
    ls->propEmuGeneralGB        = "  ";
    ls->propEmuFamilyText       = "}V\\:";
    ls->propEmuMemoryGB         = "  ";
    ls->propEmuRamSizeText      = "CRAM:";
    ls->propEmuVramSizeText     = "VRAM:";
    ls->propEmuSpeedGB          = " Xs[h ";
    ls->propEmuSpeedText        = "Xs[h:";
    ls->propEmuFrontSwitchGB     = " pi\\jbNXCb` "; 
    ls->propEmuFrontSwitch       = " O[\\tg]XCb`"; 
    ls->propEmuNoSpriteLimits   = " Disable Sprites Limitation";  // New in 2.9
    ls->propEnableMsxKeyboardQuirk = " Emulate MSX keyboard quirk";  // New in 2.9
    ls->propEmuFdcTiming        = " FDDhCũ^C~O𖳌";
    ls->propEmuReversePlay      = " Enable reverse playback"; // New in 2.8.3
    ls->propEmuPauseSwitch      = " |[YXCb`";
    ls->propEmuAudioSwitch       = " MSX-AUDIO J[gbWXCb`"; 
    ls->propVideoFreqText       = "rfIg:";
    ls->propVideoFreqAuto       = "";
    ls->propSndOversampleText   = "TvO:";
    ls->propSndYkInGB           = " YK-01/YK-10/YK-20 C ";
    ls->propSndMidiInGB         = " MIDI C ";
    ls->propSndMidiOutGB        = " MIDI AEg ";
    ls->propSndMidiChannel      = "MIDI `l:";
    ls->propSndMidiAll          = "S";

    ls->propMonMonGB            = " j^[ ";
    ls->propMonTypeText         = "j^[̎:";
    ls->propMonEmuText          = "j^[G~[V:";
    ls->propVideoTypeText       = "f:";
    ls->propWindowSizeText      = "EBhETCY:";
    ls->propMonHorizStretch      = " Ɋg";
    ls->propMonVertStretch       = " Ɋg";
    ls->propMonDeInterlace      = " C^[[X";
    ls->propBlendFrames         = " cc"; 
    ls->propMonBrightness       = "邳:";
    ls->propMonContrast         = "RgXg:";
    ls->propMonSaturation       = "ʓx:";
    ls->propMonGamma            = "K}:";
    ls->propMonScanlines        = " XLC:";
    ls->propMonColorGhosting    = " RFW[^:";
    ls->propMonEffectsGB        = " GtFNg "; 

    ls->propPerfVideoDrvGB      = " rfIhCo ";
    ls->propPerfVideoDispDrvText= "fBXvChCo:";
    ls->propPerfFrameSkipText   = "t[XLbv:";
    ls->propPerfAudioDrvGB      = " TEhhCo ";
    ls->propPerfAudioDrvText    = "TEhhCo:";
    ls->propPerfAudioBufSzText  = "TEhobt@:";
    ls->propPerfEmuGB           = " rfĨG~[V ";
    ls->propPerfSyncModeText    = "[h:";
    ls->propFullscreenResText   = "tXN[̉𑜓x:";

    ls->propSndChipEmuGB        = " TEh̃G~[V ";
    ls->propSndMsxMusic         = " MSX-MUSIC";
    ls->propSndMsxAudio         = " MSX-AUDIO";
    ls->propSndMoonsound         = " Moonsound";
    ls->propSndMt32ToGm         = " MT-32̉FGMɊ蓖"; 

    ls->propPortsLptGB          = " p|[g ";
    ls->propPortsComGB          = " VA|[g ";
    ls->propPortsLptText        = "|[g:";
    ls->propPortsCom1Text       = "|[g 1:";
    ls->propPortsNone           = "Ȃ";
    ls->propPortsSimplCovox     = "SiMPL / Covox DAC";
    ls->propPortsFile           = "Ot@C֏o";
    ls->propPortsComFile        = "Ot@C֏o";
    ls->propPortsOpenLogFile    = "Ot@CJ";
    ls->propPortsEmulateMsxPrn  = "G~[g:";

    ls->propSetFileHistoryGB    = " t@CqXg ";
    ls->propSetFileHistorySize  = "t@CqXǧ:";
    ls->propSetFileHistoryClear = "qXg̏";
    ls->propFileTypes           = " blueMSX Ŏgpt@C (rom, dsk, cas, sta) ֘At";
    ls->propWindowsEnvGB        = " Windows ";
    ls->propSetScreenSaver      = " blueMSX ̓쒆̓XN[Z[o𖳌ɂ";
    ls->propDisableWinKeys      = " Windows L[yъL[ blueMSX Ɋ蓖Ă";
    ls->propPriorityBoost       = " Windows  blueMSX ̗Dx";
    ls->propScreenshotPng       = " XN[Vbg PNG `Ŏ擾";
    ls->propEjectMediaOnExit    = " Eject media when blueMSX exits";        // New in 2.8
    ls->propClearHistory        = "qXg̏sĂ낵ł?";
    ls->propOpenRomGB           = " ROM C[W ";
    ls->propDefaultRomType      = "ftHgROM^Cv:";
    ls->propGuessRomType        = "ROM^Cv";

    ls->propSettDefSlotGB       = " hbOhbv "; 
    ls->propSettDefSlots        = "ROM }Xbg:"; 
    ls->propSettDefSlot         = " Xbg";
    ls->propSettDefDrives       = "fBXN}hCu:"; 
    ls->propSettDefDrive        = " hCu";

    ls->propThemeGB             = " e[} ";
    ls->propTheme               = "e[}:";

    ls->propCdromGB             = " CD-ROM ";       // New in 2.7
    ls->propCdromMethod         = "ANZX:";  // New in 2.7
    ls->propCdromMethodNone     = "Ȃ";           // New in 2.7
    ls->propCdromMethodIoctl    = "IOCTL";          // New in 2.7
    ls->propCdromMethodAspi     = "ASPI";           // New in 2.7
    ls->propCdromDrive          = "hCu:";      // New in 2.7

    ls->propD3DParametersGB         = "Parameters ";                // New in 2.9
    ls->propD3DAspectRatioText      = "Aspect ratio";               // New in 2.9
    ls->propD3DLinearFilteringText  = " Linear filtering";          // New in 2.9
    ls->propD3DForceHighResText     = " Force high resolution";     // New in 2.9
    ls->propD3DExtendBorderColorText    = " Extend border color";   // New in 2.9

    ls->propD3DCroppingGB               = "Cropping ";              // New in 2.9
    ls->propD3DCroppingTypeText         = "Cropping type:";         // New in 2.9
    ls->propD3DCroppingLeftText         = "Left:";                  // New in 2.9
    ls->propD3DCroppingRightText        = "Right:";                 // New in 2.9
    ls->propD3DCroppingTopText          = "Top:";                   // New in 2.9
    ls->propD3DCroppingBottomText       = "Bottom:";                // New in 2.9

    //----------------------
    // Dropdown related lines
    //----------------------

    ls->enumVideoMonColor       = "J[";
    ls->enumVideoMonGrey        = "mN";
    ls->enumVideoMonGreen       = "O[";
    ls->enumVideoMonAmber       = "Ao[";

    ls->enumVideoTypePAL        = "PAL";
    ls->enumVideoTypeNTSC       = "NTSC";

    ls->enumVideoEmuNone        = "Ȃ";
    ls->enumVideoEmuYc          = "Y/CP[u (N)";
    ls->enumVideoEmuMonitor     = "j^[";
    ls->enumVideoEmuYcBlur      = "Y/CP[u{mCY (N)";
    ls->enumVideoEmuComp        = "R|Wbg (sN)";
    ls->enumVideoEmuCompBlur    = "R|Wbg{mCY (sN)";
    ls->enumVideoEmuScale2x     = "Scale 2x";
    ls->enumVideoEmuHq2x        = "Hq2x";

    ls->enumVideoSize1x         = "WTCY - 320x200";
    ls->enumVideoSize2x         = "2{TCY - 640x400";
    ls->enumVideoSizeFullscreen = "tXN[";

    ls->enumVideoDrvDirectDrawHW= "DirectDraw n[hEFA";
    ls->enumVideoDrvDirectDraw  = "DirectDraw \\tgEFA";
    ls->enumVideoDrvGDI         = "GDI";
    ls->enumVideoDrvD3D         = "Direct3D";

    ls->enumVideoFrameskip0     = "Ȃ";
    ls->enumVideoFrameskip1     = "1t[";
    ls->enumVideoFrameskip2     = "2t[";
    ls->enumVideoFrameskip3     = "3t[";
    ls->enumVideoFrameskip4     = "4t[";
    ls->enumVideoFrameskip5     = "5t[";

    ls->enumD3DARAuto           = "Auto";           // New in 2.9
    ls->enumD3DARStretch        = "Stretch";        // New in 2.9
    ls->enumD3DARPAL            = "PAL";            // New in 2.9
    ls->enumD3DARNTSC           = "NTSC";           // New in 2.9
    ls->enumD3DAR11             = "1:1";            // New in 2.9

    ls->enumD3DCropNone         = "None";           // New in 2.9
    ls->enumD3DCropMSX1         = "MSX1";           // New in 2.9
    ls->enumD3DCropMSX1Plus8    = "MSX1+8";         // New in 2.9
    ls->enumD3DCropMSX2         = "MSX2";           // New in 2.9
    ls->enumD3DCropMSX2Plus8    = "MSX2+8";         // New in 2.9
    ls->enumD3DCropCustom       = "Custom";         // New in 2.9

    ls->enumSoundDrvNone        = "Ȃ";
    ls->enumSoundDrvWMM         = "WMM";
    ls->enumSoundDrvDirectX     = "DirectX";
    
    ls->enumEmuSync1ms          = "MSXɓ"; 
    ls->enumEmuSyncAuto         = "I[g()";
    ls->enumEmuSyncNone         = "Ȃ";
    ls->enumEmuSyncVblank       = "Windowsɓ";
    ls->enumEmuAsyncVblank      = "񓯊";

    ls->enumControlsJoyNone     = "Ȃ";
    ls->enumControlsJoyMouse    = "}EX";
    ls->enumControlsJoyTetris2Dongle = "egX2 hO";
    ls->enumControlsJoyTMagicKeyDongle = "MagicKey hO";
    ls->enumControlsJoy2Button = "2{^ WCXeBbN";
    ls->enumControlsJoyGunstick  = "KXeBbN";
    ls->enumControlsJoyAsciiLaser="ASCII Plus-X ^[~l[^[[U[";
    ls->enumControlsArkanoidPad  ="Arkanoid Pad";                   // New in 2.7.1
    ls->enumControlsJoyColeco = "ColecoVision WCXeBbN";

    ls->enumDiskMsx35Dbl9Sect    = "MSX 3.5C` 2DD (9ZN^)";
    ls->enumDiskMsx35Dbl8Sect    = "MSX 3.5C` 2DD (8ZN^)";
    ls->enumDiskMsx35Sgl9Sect    = "MSX 3.5C` 2D (9ZN^)";
    ls->enumDiskMsx35Sgl8Sect    = "MSX 3.5C` 2D (8ZN^)";
    ls->enumDiskSvi525Dbl        = "SVI-328 5.25C` 2DD";
    ls->enumDiskSvi525Sgl        = "SVI-328 5.25C` 2D";
    ls->enumDiskSf3Sgl           = "Sega SF-7000 3C` 2D";  


    //----------------------
    // Configuration related lines
    //----------------------

    ls->confTitle                = "blueMSX - }V\\ҏW";
    ls->confConfigText           = "}V\\:";
    ls->confSlotLayout           = "Xbg";
    ls->confMemory               = "";
    ls->confChipEmulation        = "`bv";
    ls->confChipExtras          = "̑";

    ls->confOpenRom             = "ROMC[WJ"; 
    ls->confSaveTitle            = "blueMSX - }V\\ҏW̏I";
    ls->confSaveText             = "݂̍\\܂A낵ł?";
    ls->confSaveAsTitle         = "ʖŕۑ...";
    ls->confSaveAsMachineName    = "\\:";
    ls->confDiscardTitle         = "blueMSX - }V\\ҏW";
    ls->confExitSaveTitle        = "blueMSX - }V\\ҏW̏I";
    ls->confExitSaveText         = "݂̍\\܂A낵ł?";

    ls->confSlotLayoutGB         = " Xbg\\ ";
    ls->confSlotExtSlotGB        = " OXbg ";
    ls->confBoardGB             = "  ";
    ls->confBoardText           = "Ճ^Cv:";
    ls->confSlotPrimary          = "{";
    ls->confSlotExpanded         = "g(4̊gXbg)";

    ls->confSlotCart             = "J[gbW";
    ls->confSlot                = "Xbg";
    ls->confSubslot             = "gXbg";

    ls->confMemAdd               = "ǉ...";
    ls->confMemEdit              = "ҏW...";
    ls->confMemRemove            = "폜";
    ls->confMemSlot              = "Xbg";
    ls->confMemAddresss          = "AhX";
    ls->confMemType              = "^Cv";
    ls->confMemRomImage          = "ROM C[W";
    
    ls->confChipVideoGB          = " rfI ";
    ls->confChipVideoChip        = "rfI`bv:";
    ls->confChipVideoRam         = "rfI RAM:";
    ls->confChipSoundGB          = " TEh ";
    ls->confChipPsgStereoText    = " PSG XeI̐؂ւ";

    ls->confCmosGB                = " CMOS "; 
    ls->confCmosEnable            = " CMOSL"; 
    ls->confCmosBattery           = " obe[L";

    ls->confCpuFreqGB            = " CPU g ";
    ls->confZ80FreqText          = "Z80 g:";
    ls->confR800FreqText         = "R800 g:";
    ls->confFdcGB                = " tbs[fBXNRg[[ ";
    ls->confCFdcNumDrivesText    = "hCu̐:";

    ls->confEditMemTitle         = "blueMSX - }bp̕ҏW";
    ls->confEditMemGB            = " }bp̏ڍ ";
    ls->confEditMemType          = "^Cv:";
    ls->confEditMemFile          = "t@C:";
    ls->confEditMemAddress       = "AhX:";
    ls->confEditMemSize          = "TCY:";
    ls->confEditMemSlot          = "Xbg:";


    //----------------------
    // Shortcut lines
    //----------------------

    ls->shortcutKey             = "@\\"; 
    ls->shortcutDescription     = "V[gJbg"; 

    ls->shortcutSaveConfig      = "blueMSX - \\̕ۑ";
    ls->shortcutOverwriteConfig = "V[gJbg\\㏑Ă낵ł?:";
    ls->shortcutExitConfig      = "blueMSX - V[gJbg\\ҏW̏I";
    ls->shortcutDiscardConfig   = "݂̍\\܂A낵ł?";
    ls->shortcutSaveConfigAs    = "blueMSX - V[gJbg\\ʖŕۑ";
    ls->shortcutConfigName      = "\\:";
    ls->shortcutNewProfile      = "< VKvt@C >";
    ls->shortcutConfigTitle     = "blueMSX - V[gJbg\\ҏW";
    ls->shortcutAssign          = "蓖";
    ls->shortcutPressText       = "V[gJbgL[͗:";
    ls->shortcutScheme          = "\\:";
    ls->shortcutCartInsert1     = "J[gbW1 }";
    ls->shortcutCartRemove1     = "J[gbW1 o";
    ls->shortcutCartInsert2     = "J[gbW2 }";
    ls->shortcutCartRemove2     = "J[gbW2 o";
    ls->shortcutSpecialMenu1    = "J[gbW1̂̑j[̕\\";
    ls->shortcutSpecialMenu2    = "J[gbW2̂̑j[̕\\";
    ls->shortcutCartAutoReset   = "J[gbW }/oナZbg";
    ls->shortcutDiskInsertA     = "fBXNA }";
    ls->shortcutDiskDirInsertA  = "fBNgfBXNAƂđ}"; 
    ls->shortcutDiskRemoveA     = "fBXNA o";
    ls->shortcutDiskChangeA     = "fBXNA ւ(v-DRIVE)";
    ls->shortcutDiskAutoResetA  = "fBXNA }/oナZbg";
    ls->shortcutDiskInsertB     = "fBXNB }";
    ls->shortcutDiskDirInsertB  = "fBNgfBXNBƂđ}";
    ls->shortcutDiskRemoveB     = "fBXNB o";
    ls->shortcutCasInsert       = "e[v }";
    ls->shortcutCasEject        = "e[v o";
    ls->shortcutCasAutorewind   = "e[v }㊪߂";
    ls->shortcutCasReadOnly     = "e[vǂݍݐpɂ";
    ls->shortcutCasSetPosition  = "e[vʒuZbg";
    ls->shortcutCasRewind       = "e[v߂";
    ls->shortcutCasSave         = "e[vC[Wۑ";
    ls->shortcutPrnFormFeed     = "v^["; 
    ls->shortcutCpuStateLoad    = "CPUXe[gǂݍ";
    ls->shortcutCpuStateSave    = "CPUXe[gۑ";
    ls->shortcutCpuStateQload   = "NCbN[h";
    ls->shortcutCpuStateQsave   = "NbNZ[u";
    ls->shortcutAudioCapture    = "TEh^̎s/~";
    ls->shortcutScreenshotOrig  = "XN[Vbg";
    ls->shortcutScreenshotSmall = "tB^[WTCY XN[Vbg";
    ls->shortcutScreenshotLarge = "tB^[2{TCY XN[Vbg";
    ls->shortcutQuit            = "blueMSX ̏I";
    ls->shortcutRunPause        = "G~[V̎s/f";
    ls->shortcutStop            = "~";
    ls->shortcutResetHard       = "n[hZbg";
    ls->shortcutResetSoft       = "\\tgZbg";
    ls->shortcutResetClean      = "N[Zbg";
    ls->shortcutSizeSmall       = "WTCY";
    ls->shortcutSizeNormal      = "2{TCY";
    ls->shortcutSizeFullscreen  = "tXN[";
    ls->shortcutSizeMinimized   = "EBhE ŏ";
    ls->shortcutToggleFullscren = "tXN[";
    ls->shortcutVolumeIncrease  = "{[グ";
    ls->shortcutVolumeDecrease  = "{[";
    ls->shortcutVolumeMute      = "~[g";
    ls->shortcutVolumeStereo    = "m/XeI̐؂ւ";
    ls->shortcutSwitchMsxAudio  = "MSX-AUDIO J[gbWXCb`";
    ls->shortcutSwitchFront     = "pi\\jbNn O[\\tg]XCb`";
    ls->shortcutSwitchPause     = "pi\\jbNn |[YXCb`";
    ls->shortcutToggleMouseLock = "}EXbN";
    ls->shortcutEmuSpeedMax     = "G~[Vsxő";
    ls->shortcutEmuPlayReverse  = "Rewind emulation";                     // New in 2.8.3
    ls->shortcutEmuSpeedToggle  = "ő̗L";
    ls->shortcutEmuSpeedNormal  = "G~[VsxW";
    ls->shortcutEmuSpeedInc     = "G~[Vx";
    ls->shortcutEmuSpeedDec     = "G~[Vx̌";
    ls->shortcutThemeSwitch     = "e[}̐؂ւ";
    ls->shortcutShowEmuProp     = "G~[Vݒʂ̕\\";
    ls->shortcutShowVideoProp   = "rfIݒʂ̕\\";
    ls->shortcutShowAudioProp   = "TEhݒʂ̕\\";
    ls->shortcutShowCtrlProp    = "Rg[ݒʂ̕\\";
    ls->shortcutShowEffectsProp = "Show Effects Properties";     // New in 2.9
    ls->shortcutShowSettProp    = "̑ݒʂ̕\\";
    ls->shortcutShowPorts       = "|[gݒʂ̕\\";
    ls->shortcutShowLanguage    = "_CAO̕\\";
    ls->shortcutShowMachines    = "}V\\ҏW̕\\";
    ls->shortcutShowShortcuts   = "V[gJbgGfB^[̕\\";
    ls->shortcutShowKeyboard    = "L[{[h\\ҏW̕\\";
    ls->shortcutShowMixer       = "~LT[̕\\"; 
	ls->shortcutShowDebugger    = "fobK[\\";
    ls->shortcutShowTrainer     = "g[i[\\";
    ls->shortcutShowHelp        = "wv_CAO̕\\";
    ls->shortcutShowAbout       = "blueMSX ɂĂ̕\\";
    ls->shortcutShowFiles       = "t@C_CAO\\";
    ls->shortcutToggleSpriteEnable = "XvCg̕\\/\\";
    ls->shortcutToggleFdcTiming = "FDDhCũ^C~O̗L/";
    ls->shortcutToggleNoSpriteLimits = "Toggle Sprites Limitation";                 // New in 2.9
    ls->shortcutEnableMsxKeyboardQuirk = "Emulate MSX Keyboard Quirk";              // New in 2.9
    ls->shortcutToggleCpuTrace  = "CPUg[X̗L/";
    ls->shortcutVideoLoad       = "ǂݍ...";             
    ls->shortcutVideoPlay       = "Lv`f̍Đ";   
    ls->shortcutVideoRecord     = "^";              
    ls->shortcutVideoStop       = "~";                
    ls->shortcutVideoRender     = "rfIt@C̃_O";   


    //----------------------
    // Keyboard config lines
    //----------------------
    
    ls->keyconfigSelectedKey    = "IL[:";
    ls->keyconfigMappedTo       = "ΏۃL[:";
    ls->keyconfigMappingScheme  = "\\:";


    
    //----------------------
    // Rom type lines
    //----------------------

    ls->romTypeStandard         = "Standard";
    ls->romTypeZenima80         = "Zemina 80 in 1";
    ls->romTypeZenima90         = "Zemina 90 in 1";
    ls->romTypeZenima126        = "Zemina 126 in 1";
    ls->romTypeSccMirrored      = "SCC mirrored";
    ls->romTypeSccExtended      = "SCC extended";
    ls->romTypeKonamiGeneric    = "Konami Generic";
    ls->romTypeMirrored         = "Mirrored ROM";
    ls->romTypeNormal           = "Normal ROM";
    ls->romTypeDiskPatch        = "Normal + Disk Patch";
    ls->romTypeCasPatch         = "Normal + Cassette Patch";
    ls->romTypeTc8566afFdc      = "TC8566AF Disk Controller";
    ls->romTypeTc8566afTrFdc    = "TC8566AF Turbo-R Disk Controller";
    ls->romTypeMicrosolFdc      = "Microsol Disk Controller";
    ls->romTypeNationalFdc      = "National Disk Controller";
    ls->romTypePhilipsFdc       = "Philips Disk Controller";
    ls->romTypeSvi707Fdc        = "SVI-707 Disk Controller";
    ls->romTypeSvi738Fdc        = "SVI-738 Disk Controller";
    ls->romTypeMappedRam        = "Mapped RAM";
    ls->romTypeMirroredRam1k    = "1kB Mirrored RAM";
    ls->romTypeMirroredRam2k    = "2kB Mirrored RAM";
    ls->romTypeNormalRam        = "Normal RAM";
    ls->romTypeTurborPause      = "Turbo-R Pause";
    ls->romTypeF4deviceNormal   = "F4 Device Normal";
    ls->romTypeF4deviceInvert   = "F4 Device Inverted";
    ls->romTypeTurborTimer      = "Turbo-R Timer";
    ls->romTypeNormal4000       = "Normal 4000h";
    ls->romTypeNormalC000       = "Normal C000h";
    ls->romTypeExtRam           = "External RAM";
    ls->romTypeExtRam16         = "16kB External RAM";
    ls->romTypeExtRam32         = "32kB External RAM";
    ls->romTypeExtRam48         = "48kB External RAM";
    ls->romTypeExtRam64         = "64kB External RAM";
    ls->romTypeExtRam512        = "512kB External RAM";
    ls->romTypeExtRam1mb        = "1MB External RAM";
    ls->romTypeExtRam2mb        = "2MB External RAM";
    ls->romTypeExtRam4mb        = "4MB External RAM";
    ls->romTypeSvi328Cart       = "SVI-328 Cartridge";
    ls->romTypeSvi328Fdc        = "SVI-328 Disk Controller";
    ls->romTypeSvi328Prn        = "SVI-328 Printer";
    ls->romTypeSvi328Uart       = "SVI-328 Serial Port";
    ls->romTypeSvi328col80      = "SVI-328 80 Column Card";
    ls->romTypeSvi727col80      = "SVI-727 80 Column Card";
    ls->romTypeColecoCart       = "Coleco Cartridge";
    ls->romTypeSg1000Cart       = "SG-1000 Cartridge";
    ls->romTypeSc3000Cart       = "SC-3000 Cartridge";
    ls->romTypeMsxPrinter       = "MSX Printer";
    ls->romTypeTurborPcm        = "Turbo-R PCM Chip";
    ls->romTypeNms8280Digitiz   = "Philips NMS-8280 Digitizer";
    ls->romTypeHbiV1Digitiz     = "Sony HBI-V1 Digitizer";
    
    
    //----------------------
    // Debug type lines
    // Note: Only needs translation if debugger is translated
    //----------------------

    ls->dbgMemVisible           = "Visible Memory";
    ls->dbgMemRamNormal         = "Normal";
    ls->dbgMemRamMapped         = "Mapped";
    ls->dbgMemYmf278            = "YMF278 Sample RAM";
    ls->dbgMemAy8950            = "AY8950 Sample RAM";
    ls->dbgMemScc               = "Memory";

    ls->dbgCallstack            = "Callstack";

    ls->dbgRegs                 = "Registers";
    ls->dbgRegsCpu              = "CPU Registers";
    ls->dbgRegsYmf262           = "YMF262 Registers";
    ls->dbgRegsYmf278           = "YMF278 Registers";
    ls->dbgRegsAy8950           = "AY8950 Registers";
    ls->dbgRegsYm2413           = "YM2413 Registers";

    ls->dbgDevRamMapper         = "RAM Mapper";
    ls->dbgDevRam               = "RAM";
    ls->dbgDevF4Device          = "F4 Device";
    ls->dbgDevKorean80          = "Korean 80";
    ls->dbgDevKorean90          = "Korean 90";
    ls->dbgDevKorean128         = "Korean 128";
    ls->dbgDevFdcMicrosol       = "Microsol FDC";
    ls->dbgDevPrinter           = "Printer";
    ls->dbgDevSviFdc            = "SVI FDC";
    ls->dbgDevSviPrn            = "SVI Printer";
    ls->dbgDevSvi80Col          = "SVI 80 Column";
    ls->dbgDevRtc               = "RTC";
    ls->dbgDevTrPause           = "TR Pause";


    //----------------------
    // Debug type lines
    // Note: Can only be translated to european languages
    //----------------------

    ls->aboutScrollThanksTo     = "Special thanks to: ";
    ls->aboutScrollAndYou       = "and Support wo shitekureru user no minasama  !!!!";
};

#endif
