/*****************************************************************************
** $Source: /cygdrive/d/Private/_SVNROOT/bluemsx/blueMSX/Src/Language/LanguageChineseSimplified.h,v $
**
** $Revision: 1.53 $
**
** $Date: 2009-04-04 20:57:19 $
**
** More info: http://www.bluemsx.com
**
** Copyright (C) 2003-2006 Daniel Vik
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
******************************************************************************
*/
#ifndef LANGUAGE_CHINESE_SIMPLIFIED_H
#define LANGUAGE_CHINESE_SIMPLIFIED_H

#include "LanguageStrings.h"
 
void langInitChineseSimplified(LanguageStrings* ls) 
{
    //----------------------
    // Language lines
    //----------------------

    ls->langCatalan             = "Catalan";
    ls->langChineseSimplified   = "";
    ls->langChineseTraditional  = "";
    ls->langDutch               = "";
    ls->langEnglish             = "Ӣ";
    ls->langFinnish             = "";
    ls->langFrench              = "";
    ls->langGerman              = "";
    ls->langItalian             = "";
    ls->langJapanese            = "";
    ls->langKorean              = "";
    ls->langPolish              = "";
    ls->langPortuguese          = "";
    ls->langRussian             = "Russian";            // v2.8
    ls->langSpanish             = "";
    ls->langSwedish             = "";


    //----------------------
    // Generic lines
    //----------------------

    ls->textDevice              = "豸:";
    ls->textFilename            = "ļ:";
    ls->textFile                = "ļ";
    ls->textNone                = "";
    ls->textUnknown             = "δ֪";                            


    //----------------------
    // Warning and Error lines
    //----------------------

    ls->warningTitle             = "blueMSX - ";
    ls->warningDiscardChanges   = "Ҫ޸";
    ls->warningOverwriteFile    = "Ҫԭļ:"; 
    ls->errorTitle              = "blueMSX - ";
    ls->errorEnterFullscreen    = "޷ȫģʽ           \n";
    ls->errorDirectXFailed      = "޷ DirectX            \nΪʹGDI\nԿá";
    ls->errorNoRomInZip         = "޷ zip ѹҵ .rom ļ";
    ls->errorNoDskInZip         = "޷ zip ѹҵ .dsk ļ";
    ls->errorNoCasInZip         = "޷ zip ѹҵ .cas ļ";
    ls->errorNoHelp             = "޷ҵ blueMSX ļ";
    ls->errorStartEmu           = "޷ MSX ģ";
    ls->errorPortableReadonly   = "Я豸Ϊֻ";        


    //----------------------
    // File related lines
    //----------------------

    ls->fileRom                 = "ROM ӳ";
    ls->fileAll                 = "ļ";
    ls->fileCpuState            = "CPU ״̬";
    ls->fileVideoCapture        = "ȡƵ"; 
    ls->fileDisk                = "ӳ";
    ls->fileCas                 = "Ŵӳ";
    ls->fileAvi                 = "Ƶ";    


    //----------------------
    // Menu related lines
    //----------------------

    ls->menuNoRecentFiles       = "- ļ -";
    ls->menuInsert              = "";
    ls->menuEject               = "";
    
    ls->menuCartGameReader      = "Game Reader";                        
    ls->menuCartIde             = "IDE";                                
    ls->menuCartBeerIde         = "Beer";                               
    ls->menuCartGIde            = "GIDE";                               
    ls->menuCartSunriseIde      = "Sunrise";                            
    ls->menuCartScsi            = "SCSI";                // New in 2.7
    ls->menuCartMegaSCSI        = "MEGA-SCSI";           // New in 2.7
    ls->menuCartWaveSCSI        = "WAVE-SCSI";           // New in 2.7
    ls->menuCartGoudaSCSI       = "Gouda SCSI";          // New in 2.7
    ls->menuJoyrexPsg           = "Joyrex PSG "; // New in 2.9
    ls->menuCartSCCPlus         = "SCC-I ";
    ls->menuCartSCC             = "SCC ";
    ls->menuCartFMPac           = "FM-PAC ";
    ls->menuCartPac             = "PAC ";
    ls->menuCartHBI55           = "Sony HBI-55 ";
    ls->menuCartInsertSpecial   = "";                     
    ls->menuCartMegaRam         = "MegaRAM";                            
    ls->menuCartExternalRam     = "չڴ";
    ls->menuCartEseRam          = "Ese-RAM";             // New in 2.7
    ls->menuCartEseSCC          = "Ese-SCC";             // New in 2.7
    ls->menuCartMegaFlashRom    = "Mega Flash ROM";      // New in 2.7

    ls->menuDiskInsertNew       = "µӳ";              
    ls->menuDiskInsertCdrom     = "Insert CD-Rom";       // New in 2.7
    ls->menuDiskDirInsert       = "Ŀ¼";
    ls->menuDiskAutoStart       = "";
    ls->menuCartAutoReset       = "/Ƴ";

    ls->menuCasRewindAfterInsert = "󵹴";
    ls->menuCasUseReadOnly       = "ʹôŴʱֻ";
    ls->lmenuCasSaveAs           = "Ϊ...";
    ls->menuCasSetPosition      = "Ŵλ";
    ls->menuCasRewind           = "";

    ls->menuVideoLoad           = "ȡ...";             
    ls->menuVideoPlay           = "һȡƵ";   
    ls->menuVideoRecord         = "¼";              
    ls->menuVideoRecording      = "¼";           
    ls->menuVideoRecAppend      = "¼ ӣ";     
    ls->menuVideoStop           = "ֹͣ";                
    ls->menuVideoRender         = "ȾƵļ";   

    ls->menuZoomNormal          = "׼ߴ";
    ls->menuZoomDouble          = "ߴ";
    ls->menuZoomFullscreen      = "ȫĻ";
    
    ls->menuPrnFormfeed         = "ҳ";
    
    ls->menuPropsEmulation      = "ģ";
    ls->menuPropsVideo          = "Ƶ";
    ls->menuPropsSound          = "";
    ls->menuPropsControls       = "";
    ls->menuPropsEffects        = "Effects";               // New in 2.9
    ls->menuPropsSettings        = "趨";
    ls->menuPropsFile           = "ļ";
    ls->menuPropsDisk           = "Disks";               // New in 2.7
    ls->menuPropsLanguage       = "";
    ls->menuPropsPorts          = "˿";
    
    ls->menuVideoSource         = "ƵԴ";                   
    ls->menuVideoSourceDefault  = "δƵԴ";      
    ls->menuVideoChipAutodetect = "ԶʾоƬ";
    ls->menuVideoInSource       = "ƵԴ";                    
    ls->menuVideoInBitmap       = "λͼļ";                        
    
    ls->menuEthInterface        = "Ethernet"; 

    ls->menuHelpHelp            = "";
    ls->menuHelpAbout           = " blueMSX";

    ls->menuFileCart            = "";
    ls->menuFileDisk            = "";
    ls->menuFileCas             = "Ŵ";
    ls->menuFilePrn             = "ӡ";
    ls->menuFileLoadState       = "ȡ CPU ״̬";
    ls->menuFileSaveState       = " CPU ״̬";
    ls->menuFileQLoadState      = "ٶȡ";
    ls->menuFileQSaveState      = "ٱ";
    ls->menuFileCaptureAudio    = "ȡƵ";
    ls->menuFileCaptureVideo    = "ȡƵ"; 
    ls->menuFileScreenShot      = "ͼ";
    ls->menuFileExit            = "˳";

    ls->menuFileHarddisk        = "Ӳ";                          
    ls->menuFileHarddiskNoPesent= "ǰ޿";             
    ls->menuFileHarddiskRemoveAll= "Eject All Harddisk";    // New in 2.7

    ls->menuRunRun              = "";
    ls->menuRunPause            = "ͣ";
    ls->menuRunStop             = "ֹͣ";
    ls->menuRunSoftReset        = "";
    ls->menuRunHardReset        = "Ӳ";
    ls->menuRunCleanReset       = "";

    ls->menuToolsMachine         = "ϱ༭";
    ls->menuToolsShortcuts      = "ݼ༭";
    ls->menuToolsCtrlEditor     = " / ̱༭"; 
    ls->menuToolsMixer          = "";
    ls->menuToolsDebugger       = "Թ";               
    ls->menuToolsTrainer        = "׹";                
    ls->menuToolsTraceLogger    = "׷ټ¼";           

    ls->menuFile                = "ļ";
    ls->menuRun                 = "";
    ls->menuWindow              = "";
    ls->menuOptions             = "ѡ";
    ls->menuTools                = "";
    ls->menuHelp                = "";


    //----------------------
    // Dialog related lines
    //----------------------

    ls->dlgOK                   = "ȷ";
    ls->dlgOpen                 = "";
    ls->dlgCancel               = "ȡ";
    ls->dlgSave                 = "";
    ls->dlgSaveAs               = "Ϊ...";
    ls->dlgRun                  = "";
    ls->dlgClose                = "ر";

    ls->dlgLoadRom              = "blueMSX - ѡ񿨴ӳ";
    ls->dlgLoadDsk              = "blueMSX - ѡӳ";
    ls->dlgLoadCas              = "blueMSX - ѡŴӳ";
    ls->dlgLoadRomDskCas        = "blueMSX - ѡ񿨴̻Ŵӳ";
    ls->dlgLoadRomDesc          = "ѡҪȡĿӳ:";
    ls->dlgLoadDskDesc          = "ѡҪȡӳ:";
    ls->dlgLoadCasDesc          = "ѡҪȡĴŴӳ:";
    ls->dlgLoadRomDskCasDesc    = "ѡҪȡĿ̻Ŵӳ:";
    ls->dlgLoadState            = "ȡ CPU ״̬";
    ls->dlgLoadVideoCapture     = "ȡȡƵ";      
    ls->dlgSaveState            = " CPU ״̬";
    ls->dlgSaveCassette          = "blueMSX - Ŵӳ";
    ls->dlgSaveVideoClipAs      = "ƵΪ...";     
    ls->dlgAmountCompleted      = "ܼ:";          
    ls->dlgInsertRom1           = "ڲ 1  ROM ";
    ls->dlgInsertRom2           = "ڲ 2  ROM ";
    ls->dlgInsertDiskA          = " A ӳ";
    ls->dlgInsertDiskB          = " B ӳ";
    ls->dlgInsertHarddisk       = "Ӳ";                   
    ls->dlgInsertCas            = "Ŵ";
    ls->dlgRomType              = "Rom :";
    ls->dlgDiskSize             = "̴С:";             

    ls->dlgTapeTitle            = "blueMSX - Ŵ";
    ls->dlgTapeFrameText        = "Ŵλ";
    ls->dlgTapeCurrentPos       = "ǰλ";
    ls->dlgTapeTotalTime        = "ʱ";
    ls->dlgTapeCustom            = "ʾԶļ";
    ls->dlgTapeSetPosText        = "Ŵλ:";
    ls->dlgTabPosition           = "λ";
    ls->dlgTabType               = "";
    ls->dlgTabFilename           = "ļ";
    ls->dlgZipReset             = "";

    ls->dlgAboutTitle           = "blueMSX - ";

    ls->dlgLangLangText         = "ѡ blueMSX ʹ";
    ls->dlgLangLangTitle        = "blueMSX - ";

    ls->dlgAboutAbout           = "\r\n====";
    ls->dlgAboutVersion         = "汾:";
    ls->dlgAboutBuildNumber     = ":";
    ls->dlgAboutBuildDate       = ":";
    ls->dlgAboutCreat           = ":	Daniel Vik";
    ls->dlgAboutDevel           = "λЭĿ\r\n========";
    ls->dlgAboutThanks          = "رл\r\n============";       // New in 2.7 (retranslate, see english)
    ls->dlgAboutLisence         = "Ȩ\r\n"
                                  "======\r\n\r\n"
                                  "ǸĿǰ״ģûκȷĬȨ "
                                  "κ£ʹñɵĺûԼе "
                                  "߽еκΡ\r\n\r\n"
                                  "½: www.bluemsx.com ";

    ls->dlgSavePreview          = "ʾԤ";
    ls->dlgSaveDate             = "ʱ:";

    ls->dlgRenderVideoCapture   = "blueMSX - ȾȡƵ...";  


    //----------------------
    // Properties related lines
    //----------------------

    ls->propTitle               = "blueMSX - ";
    ls->propEmulation           = "ģ";
    ls->propVideo               = "Ƶ";
    ls->propSound               = "";
    ls->propControls            = "";
    ls->propPerformance         = "";
    ls->propEffects             = "Effects";             // New in 2.9
    ls->propSettings             = "";
    ls->propFile                = "ļ";
    ls->propDisk                = "Disks";              // New in 2.7
    ls->propPorts               = "˿";
    
    ls->propEmuGeneralGB        = " ";
    ls->propEmuFamilyText       = "MSX :";
    ls->propEmuMemoryGB         = "ڴ ";
    ls->propEmuRamSizeText      = "ڴ:";
    ls->propEmuVramSizeText     = "Դ:";
    ls->propEmuSpeedGB          = "ģٶ ";
    ls->propEmuSpeedText        = "ģٶ:";
    ls->propEmuFrontSwitchGB     = "Panasonic  ";
    ls->propEmuFrontSwitch       = " ǰ˿";
    ls->propEmuNoSpriteLimits   = " Disable Sprites Limitation";  // New in 2.9
    ls->propEnableMsxKeyboardQuirk = " Emulate MSX keyboard quirk";  // New in 2.9
    ls->propEmuFdcTiming        = " ʱ";
    ls->propEmuReversePlay      = " Enable reverse playback"; // New in 2.8.3
    ls->propEmuPauseSwitch      = " ͣ";
    ls->propEmuAudioSwitch       = " MSX-AUDIO ";
    ls->propVideoFreqText       = "ƵƵ:";
    ls->propVideoFreqAuto       = "Զ";
    ls->propSndOversampleText   = ":";
    ls->propSndYkInGB           = "YK-01/YK-10/YK-20 In ";                
    ls->propSndMidiInGB         = "MIDI  ";
    ls->propSndMidiOutGB        = "MIDI  ";
    ls->propSndMidiChannel      = "MIDI :";                      
    ls->propSndMidiAll          = "ȫ";                                

    ls->propMonMonGB            = "ʾ ";
    ls->propMonTypeText         = "ʾ:";
    ls->propMonEmuText          = "ʾģ:";
    ls->propVideoTypeText       = "Ƶ:";
    ls->propWindowSizeText      = "ڴС:";
    ls->propMonHorizStretch      = " ˮƽ";
    ls->propMonVertStretch       = " ֱ";
    ls->propMonDeInterlace      = " ߻ʳ";
    ls->propBlendFrames         = " ֡";           
    ls->propMonBrightness       = ":";
    ls->propMonContrast         = "Աȶ:";
    ls->propMonSaturation       = "Ͷ:";
    ls->propMonGamma            = "٤ֵ:";
    ls->propMonScanlines        = " ɨ:";
    ls->propMonColorGhosting    = " RF-:";
    ls->propMonEffectsGB        = "Ч ";

    ls->propPerfVideoDrvGB      = "Ƶ ";
    ls->propPerfVideoDispDrvText= "ʾ:";
    ls->propPerfFrameSkipText   = "֡:";
    ls->propPerfAudioDrvGB      = "Ƶ ";
    ls->propPerfAudioDrvText    = ":";
    ls->propPerfAudioBufSzText  = ":";
    ls->propPerfEmuGB           = "ģ ";
    ls->propPerfSyncModeText    = "ͬģʽ:";
    ls->propFullscreenResText   = "ȫĻֱ:";

    ls->propSndChipEmuGB        = "оƬģ ";
    ls->propSndMsxMusic         = " MSX-MUSIC";
    ls->propSndMsxAudio         = " MSX-AUDIO";
    ls->propSndMoonsound         = " Moonsound";
    ls->propSndMt32ToGm         = " ӳ MT-32 Ϊһ MIDI 豸";

    ls->propPortsLptGB          = "ж˿ ";
    ls->propPortsComGB          = "ж˿ ";
    ls->propPortsLptText        = "˿:";
    ls->propPortsCom1Text       = "˿ 1:";
    ls->propPortsNone           = "";
    ls->propPortsSimplCovox     = "SiMPL/Covox ģת";
    ls->propPortsFile           = "ӡļ";
    ls->propPortsComFile        = "͵ļ";
    ls->propPortsOpenLogFile    = "򿪼¼ļ";
    ls->propPortsEmulateMsxPrn  = "ģ:";

    ls->propSetFileHistoryGB     = "ʷļ ";
    ls->propSetFileHistorySize   = "ʷļ:";
    ls->propSetFileHistoryClear  = "ʷļ";
    ls->propFileTypes            = "  blueMSX ļ ( .rom, .dsk, .cas, .sta)";
    ls->propWindowsEnvGB         = "Windows 趨 "; 
    ls->propSetScreenSaver       = " blueMSX ʱرĻ";
    ls->propDisableWinKeys       = " MSX ʹΧ Windows Ч"; 
    ls->propPriorityBoost       = "  blueMSX ȼ";
    ls->propScreenshotPng       = " ʹñЯͼʽ (.png) Ļͼ";  
    ls->propEjectMediaOnExit    = " Eject media when blueMSX exits";        // New in 2.8
    ls->propClearHistory         = "ȷҪʷļ";
    ls->propOpenRomGB           = " Rom Ի ";
    ls->propDefaultRomType      = "Ĭ Rom :";
    ls->propGuessRomType        = "² Rom ";

    ls->propSettDefSlotGB       = "Ϸ ";
    ls->propSettDefSlots        = " Rom :";
    ls->propSettDefSlot         = " ";
    ls->propSettDefDrives       = "̵:";
    ls->propSettDefDrive        = " ";

    ls->propThemeGB             = " ";
    ls->propTheme               = ":";

    ls->propCdromGB             = "CD-ROM ";         // New in 2.7
    ls->propCdromMethod         = "Access Method:";  // New in 2.7
    ls->propCdromMethodNone     = "None";            // New in 2.7
    ls->propCdromMethodIoctl    = "IOCTL";           // New in 2.7
    ls->propCdromMethodAspi     = "ASPI";            // New in 2.7
    ls->propCdromDrive          = "Drive:";          // New in 2.7

    ls->propD3DParametersGB         = "Parameters ";                // New in 2.9
    ls->propD3DAspectRatioText      = "Aspect ratio";               // New in 2.9
    ls->propD3DLinearFilteringText  = " Linear filtering";          // New in 2.9
    ls->propD3DForceHighResText     = " Force high resolution";     // New in 2.9
    ls->propD3DExtendBorderColorText    = " Extend border color";   // New in 2.9

    ls->propD3DCroppingGB               = "Cropping ";              // New in 2.9
    ls->propD3DCroppingTypeText         = "Cropping type:";         // New in 2.9
    ls->propD3DCroppingLeftText         = "Left:";                  // New in 2.9
    ls->propD3DCroppingRightText        = "Right:";                 // New in 2.9
    ls->propD3DCroppingTopText          = "Top:";                   // New in 2.9
    ls->propD3DCroppingBottomText       = "Bottom:";                // New in 2.9


    //----------------------
    // Dropdown related lines
    //----------------------

    ls->enumVideoMonColor       = "ɫ";
    ls->enumVideoMonGrey        = "ڰ";
    ls->enumVideoMonGreen       = "ɫ";
    ls->enumVideoMonAmber       = "ɫ";

    ls->enumVideoTypePAL        = "PAL";
    ls->enumVideoTypeNTSC       = "NTSC";

    ls->enumVideoEmuNone        = "";
    ls->enumVideoEmuYc          = "Y/C · ()";
    ls->enumVideoEmuMonitor     = "ʾ";
    ls->enumVideoEmuYcBlur      = " Y/C · ()";
    ls->enumVideoEmuComp        = " (ģ)";
    ls->enumVideoEmuCompBlur    = "븴 (ģ)";
    ls->enumVideoEmuScale2x     = "2 ữ";
    ls->enumVideoEmuHq2x        = "Hq2x";

    ls->enumVideoSize1x         = "׼ - 320x200";
    ls->enumVideoSize2x         = " - 640x400";
    ls->enumVideoSizeFullscreen = "ȫĻ";

    ls->enumVideoDrvDirectDrawHW = "DirectDraw HW "; 
    ls->enumVideoDrvDirectDraw  = "DirectDraw";
    ls->enumVideoDrvGDI         = "GDI";
    ls->enumVideoDrvD3D         = "Direct3D";

    ls->enumVideoFrameskip0     = "";
    ls->enumVideoFrameskip1     = "1֡";
    ls->enumVideoFrameskip2     = "2֡";
    ls->enumVideoFrameskip3     = "3֡";
    ls->enumVideoFrameskip4     = "4֡";
    ls->enumVideoFrameskip5     = "5֡";

    ls->enumD3DARAuto           = "Auto";           // New in 2.9
    ls->enumD3DARStretch        = "Stretch";        // New in 2.9
    ls->enumD3DARPAL            = "PAL";            // New in 2.9
    ls->enumD3DARNTSC           = "NTSC";           // New in 2.9
    ls->enumD3DAR11             = "1:1";            // New in 2.9

    ls->enumD3DCropNone         = "None";           // New in 2.9
    ls->enumD3DCropMSX1         = "MSX1";           // New in 2.9
    ls->enumD3DCropMSX1Plus8    = "MSX1+8";         // New in 2.9
    ls->enumD3DCropMSX2         = "MSX2";           // New in 2.9
    ls->enumD3DCropMSX2Plus8    = "MSX2+8";         // New in 2.9
    ls->enumD3DCropCustom       = "Custom";         // New in 2.9

    ls->enumSoundDrvNone        = "";
    ls->enumSoundDrvWMM         = "WMM ";
    ls->enumSoundDrvDirectX     = "DirectX ";

    ls->enumEmuSync1ms          = "ͬ MSX ˢ";
    ls->enumEmuSyncAuto         = "Զ ()";
    ls->enumEmuSyncNone         = "";
    ls->enumEmuSyncVblank       = "ͬ PC Ĵֱհ";
    ls->enumEmuAsyncVblank      = "첽 PC Ĵֱհ";             

    ls->enumControlsJoyNone     = "";
    ls->enumControlsJoyMouse    = "";
    ls->enumControlsJoyTetris2Dongle = "˹ 2 ģ";
    ls->enumControlsJoyTMagicKeyDongle = "MagicKey ģ";             
    ls->enumControlsJoy2Button = "2ݸ";                   
    ls->enumControlsJoyGunstick  = "ǹݸ";                         
    ls->enumControlsJoyAsciiLaser="ASCII Plus-X ս";      
    ls->enumControlsArkanoidPad  ="Arkanoid Pad";                   // New in 2.7.1
    ls->enumControlsJoyColeco = "ColecoVision ݸ";                

    ls->enumDiskMsx35Dbl9Sect    = "MSX 3.5\"  ˫, 9 ";     
    ls->enumDiskMsx35Dbl8Sect    = "MSX 3.5\"  ˫, 8 ";     
    ls->enumDiskMsx35Sgl9Sect    = "MSX 3.5\"  , 9 ";     
    ls->enumDiskMsx35Sgl8Sect    = "MSX 3.5\"  , 8 ";     
    ls->enumDiskSvi525Dbl        = "SVI-328 5.25\"  ˫";           
    ls->enumDiskSvi525Sgl        = "SVI-328 5.25\"  ";           
    ls->enumDiskSf3Sgl           = "Sega SF-7000 3\"  ";     


    //----------------------
    // Configuration related lines
    //----------------------

    ls->confTitle                = "blueMSX - ϱ༭";
    ls->confConfigText           = "";
    ls->confSlotLayout           = "";
    ls->confMemory               = "ڴ";
    ls->confChipEmulation        = "оƬģ";
    ls->confChipExtras          = "";

    ls->confOpenRom             = " ROM ӳ";
    ls->confSaveTitle            = "blueMSX - ";
    ls->confSaveText             = "ҪԭеĻ:";
    ls->confSaveAsTitle         = "Ϊ...";
    ls->confSaveAsMachineName    = ":";
    ls->confDiscardTitle         = "blueMSX - ";
    ls->confExitSaveTitle        = "blueMSX - ˳༭";
    ls->confExitSaveText         = "ҪԵǰļ޸";

    ls->confSlotLayoutGB         = " ";
    ls->confSlotExtSlotGB        = "չ ";
    ls->confBoardGB             = " ";
    ls->confBoardText           = ":";
    ls->confSlotPrimary          = "Ҫ";
    ls->confSlotExpanded         = "չ ĸӲۣ";

    ls->confSlotCart             = "";
    ls->confSlot                = "";
    ls->confSubslot             = "Ӳ";

    ls->confMemAdd               = "...";
    ls->confMemEdit              = "༭...";
    ls->confMemRemove            = "ɾ";
    ls->confMemSlot              = "";
    ls->confMemAddresss          = "ַ";
    ls->confMemType              = "";
    ls->confMemRomImage          = "Rom ӳ";
    
    ls->confChipVideoGB          = "Ƶ ";
    ls->confChipVideoChip        = "ʾоƬ:";
    ls->confChipVideoRam         = "ʾڴ:";
    ls->confChipSoundGB          = " ";
    ls->confChipPsgStereoText    = " PSG ";

    ls->confCmosGB                = "CMOS ";
    ls->confCmosEnable            = "  CMOS";
    ls->confCmosBattery           = " õ";

    ls->confCpuFreqGB            = "CPU Ƶ ";
    ls->confZ80FreqText          = "Z80 Ƶ:";
    ls->confR800FreqText         = "R800 Ƶ:";
    ls->confFdcGB                = "̿ ";
    ls->confCFdcNumDrivesText    = ":";

    ls->confEditMemTitle         = "blueMSX - ༭ Mapper";
    ls->confEditMemGB            = "Mapper ϸ ";
    ls->confEditMemType          = ":";
    ls->confEditMemFile          = "ļ:";
    ls->confEditMemAddress       = "ַ";
    ls->confEditMemSize          = "С";
    ls->confEditMemSlot          = "";


    //----------------------
    // Shortcut lines
    //----------------------

    ls->shortcutKey             = "ȼ";
    ls->shortcutDescription     = "ݼ";

    ls->shortcutSaveConfig      = "blueMSX - ";
    ls->shortcutOverwriteConfig = "ҪԭеĿݼ:";
    ls->shortcutExitConfig      = "blueMSX - ˳ݼ༭";
    ls->shortcutDiscardConfig   = "ҪԵǰļ޸";
    ls->shortcutSaveConfigAs    = "blueMSX - ݼΪ...";
    ls->shortcutConfigName      = ":";
    ls->shortcutNewProfile      = "< ½ >";
    ls->shortcutConfigTitle     = "blueMSX - ݼ༭";
    ls->shortcutAssign          = "";
    ls->shortcutPressText       = "ݼ:";
    ls->shortcutScheme          = "ӳ䷽:";
    ls->shortcutCartInsert1     = "뿨 1";
    ls->shortcutCartRemove1     = "Ƴ 1";
    ls->shortcutCartInsert2     = "뿨 2";
    ls->shortcutCartRemove2     = "Ƴ 2";
    ls->shortcutSpecialMenu1    = "Ϊ 1 ʾر Rom ˵";
    ls->shortcutSpecialMenu2    = "Ϊ 2 ʾر Rom ˵";
    ls->shortcutCartAutoReset   = "ģ";
    ls->shortcutDiskInsertA     = " A";
    ls->shortcutDiskDirInsertA  = "Ŀ¼ΪA";
    ls->shortcutDiskRemoveA     = " A";
    ls->shortcutDiskChangeA     = "л A";
    ls->shortcutDiskAutoResetA  = " A ģ";
    ls->shortcutDiskInsertB     = " B";
    ls->shortcutDiskDirInsertB  = "Ŀ¼ΪB";
    ls->shortcutDiskRemoveB     = " B";
    ls->shortcutCasInsert       = "Ŵ";
    ls->shortcutCasEject        = "Ŵ";
    ls->shortcutCasAutorewind   = "ŴԶ";
    ls->shortcutCasReadOnly     = "Ŵֻ";
    ls->shortcutCasSetPosition  = "趨Ŵλ";
    ls->shortcutCasRewind       = "";
    ls->shortcutCasSave         = "Ŵӳ";
    ls->shortcutPrnFormFeed     = "ӡҳ";
    ls->shortcutCpuStateLoad    = "ȡ CPU ״̬";
    ls->shortcutCpuStateSave    = " CPU ״̬";
    ls->shortcutCpuStateQload   = "ٶȡ CPU ״̬";
    ls->shortcutCpuStateQsave   = "ٱ CPU ״̬";
    ls->shortcutAudioCapture    = "ʼ/ֹͣ¼";
    ls->shortcutScreenshotOrig  = "Ļͼ ԭʼ";
    ls->shortcutScreenshotSmall = "Ļͼ ׼δˣ";
    ls->shortcutScreenshotLarge = "Ļͼ δˣ";
    ls->shortcutQuit            = "˳ blueMSX";
    ls->shortcutRunPause        = "/ͣģ";
    ls->shortcutStop            = "ֹͣģ";
    ls->shortcutResetHard       = "Ӳ";
    ls->shortcutResetSoft       = "";
    ls->shortcutResetClean      = "";
    ls->shortcutSizeSmall       = "Ϊ׼";
    ls->shortcutSizeNormal      = "Ϊ";
    ls->shortcutSizeFullscreen  = "ΪȫĻ";
    ls->shortcutSizeMinimized   = "С";
    ls->shortcutToggleFullscren = "лȫĻ";
    ls->shortcutVolumeIncrease  = "";
    ls->shortcutVolumeDecrease  = "С";
    ls->shortcutVolumeMute      = "";
    ls->shortcutVolumeStereo    = "л/";
    ls->shortcutSwitchMsxAudio  = "л MSX-AUDIO ";
    ls->shortcutSwitchFront     = "л Panasonic ǰ˿";
    ls->shortcutSwitchPause     = "лͣ";
    ls->shortcutToggleMouseLock = "л";
    ls->shortcutEmuSpeedMax     = "ģ";
    ls->shortcutEmuPlayReverse  = "Rewind emulation";                     // New in 2.8.3
    ls->shortcutEmuSpeedToggle  = "ģ";
    ls->shortcutEmuSpeedNormal  = "ģٶ";
    ls->shortcutEmuSpeedInc     = "ӿģٶ";
    ls->shortcutEmuSpeedDec     = "ģٶ";
    ls->shortcutThemeSwitch     = "л";
    ls->shortcutShowEmuProp     = "ʾģ";
    ls->shortcutShowVideoProp   = "ʾƵ";
    ls->shortcutShowAudioProp   = "ʾƵ";
    ls->shortcutShowCtrlProp    = "ʾ";
    ls->shortcutShowEffectsProp = "Show Effects Properties";     // New in 2.9
    ls->shortcutShowSettProp    = "ʾ";
    ls->shortcutShowPorts       = "ʾ˿趨";
    ls->shortcutShowLanguage    = "ʾԶԻ";
    ls->shortcutShowMachines    = "ʾϱ༭";
    ls->shortcutShowShortcuts   = "ʾݼ༭";
    ls->shortcutShowKeyboard    = "ʾ̱༭";
    ls->shortcutShowDebugger    = "ʾԹ";
    ls->shortcutShowTrainer     = "ʾ޸Ĺ";
    ls->shortcutShowMixer       = "ʾ";
    ls->shortcutShowHelp        = "ʾԻ";
    ls->shortcutShowAbout       = "ʾڶԻ";
    ls->shortcutShowFiles       = "ʾļ趨";
    ls->shortcutToggleSpriteEnable = "ʾ/ػ";
    ls->shortcutToggleFdcTiming = "/ʱ";
    ls->shortcutToggleNoSpriteLimits = "Toggle Sprites Limitation";                 // New in 2.9
    ls->shortcutEnableMsxKeyboardQuirk = "Emulate MSX Keyboard Quirk";              // New in 2.9
    ls->shortcutToggleCpuTrace  = "/ CPU ׷";
    ls->shortcutVideoLoad       = "ȡȡƵ";        
    ls->shortcutVideoPlay       = "һȡƵ";   
    ls->shortcutVideoRecord     = "¼ƽȡƵ";      
    ls->shortcutVideoStop       = "ֹͣȡƵ";        
    ls->shortcutVideoRender     = "ȾƵļ";         


    //----------------------
    // Keyboard config lines
    //----------------------
    
    ls->keyconfigSelectedKey    = "ѡм:";
    ls->keyconfigMappedTo       = "ӳ䵽:";
    ls->keyconfigMappingScheme  = "ӳ䷽:";

    
    //----------------------
    // Rom type lines
    //----------------------</p>

    ls->romTypeStandard         = "Standard";
    ls->romTypeZenima80         = "Zemina 80 in 1";
    ls->romTypeZenima90         = "Zemina 90 in 1";
    ls->romTypeZenima126        = "Zemina 126 in 1";
    ls->romTypeSccMirrored      = "SCC mirrored";
    ls->romTypeSccExtended      = "SCC extended";
    ls->romTypeKonamiGeneric    = "Konami Generic";
    ls->romTypeMirrored         = "Mirrored ROM";
    ls->romTypeNormal           = "Normal ROM";
    ls->romTypeDiskPatch        = "Normal + Disk Patch";
    ls->romTypeCasPatch         = "Normal + Cassette Patch";
    ls->romTypeTc8566afFdc      = "TC8566AF Disk Controller";
    ls->romTypeTc8566afTrFdc    = "TC8566AF Turbo-R Disk Controller";
    ls->romTypeMicrosolFdc      = "Microsol Disk Controller";
    ls->romTypeNationalFdc      = "National Disk Controller";
    ls->romTypePhilipsFdc       = "Philips Disk Controller";
    ls->romTypeSvi707Fdc        = "SVI-707 Disk Controller";
    ls->romTypeSvi738Fdc        = "SVI-738 Disk Controller";
    ls->romTypeMappedRam        = "Mapped RAM";
    ls->romTypeMirroredRam1k    = "1kB Mirrored RAM";
    ls->romTypeMirroredRam2k    = "2kB Mirrored RAM";
    ls->romTypeNormalRam        = "Normal RAM";
    ls->romTypeTurborPause      = "Turbo-R Pause";
    ls->romTypeF4deviceNormal   = "F4 Device Normal";
    ls->romTypeF4deviceInvert   = "F4 Device Inverted";
    ls->romTypeTurborTimer      = "Turbo-R Timer";
    ls->romTypeNormal4000       = "Normal 4000h";
    ls->romTypeNormalC000       = "Normal C000h";
    ls->romTypeExtRam           = "External RAM";
    ls->romTypeExtRam16         = "16kB External RAM";
    ls->romTypeExtRam32         = "32kB External RAM";
    ls->romTypeExtRam48         = "48kB External RAM";
    ls->romTypeExtRam64         = "64kB External RAM";
    ls->romTypeExtRam512        = "512kB External RAM";
    ls->romTypeExtRam1mb        = "1MB External RAM";
    ls->romTypeExtRam2mb        = "2MB External RAM";
    ls->romTypeExtRam4mb        = "4MB External RAM";
    ls->romTypeSvi328Cart       = "SVI-328 Cartridge";
    ls->romTypeSvi328Fdc        = "SVI-328 Disk Controller";
    ls->romTypeSvi328Prn        = "SVI-328 Printer";
    ls->romTypeSvi328Uart       = "SVI-328 Serial Port";
    ls->romTypeSvi328col80      = "SVI-328 80 Column Card";
    ls->romTypeSvi727col80      = "SVI-727 80 Column Card";
    ls->romTypeColecoCart       = "Coleco Cartridge";
    ls->romTypeSg1000Cart       = "SG-1000 Cartridge";
    ls->romTypeSc3000Cart       = "SC-3000 Cartridge";
    ls->romTypeMsxPrinter       = "MSX Printer";
    ls->romTypeTurborPcm        = "Turbo-R PCM Chip";
    ls->romTypeNms8280Digitiz   = "Philips NMS-8280 Digitizer";
    ls->romTypeHbiV1Digitiz     = "Sony HBI-V1 Digitizer";
    
    
    //----------------------
    // Debug type lines
    // Note: Only needs translation if debugger is translated
    //----------------------

    ls->dbgMemVisible           = "ɼڴ";
    ls->dbgMemRamNormal         = "ͨ";
    ls->dbgMemRamMapped         = "ӳ";
    ls->dbgMemYmf278            = "YMF278 ȡڴ";
    ls->dbgMemAy8950            = "AY8950 ȡڴ";
    ls->dbgMemScc               = "ڴ";

    ls->dbgCallstack            = "ջ";

    ls->dbgRegs                 = "Ĵ";
    ls->dbgRegsCpu              = "CPU Ĵ";
    ls->dbgRegsYmf262           = "YMF262 Ĵ";
    ls->dbgRegsYmf278           = "YMF278 Ĵ";
    ls->dbgRegsAy8950           = "AY8950 Ĵ";
    ls->dbgRegsYm2413           = "YM2413 Ĵ";

    ls->dbgDevRamMapper         = "ڴӳ";
    ls->dbgDevRam               = "ڴ";
    ls->dbgDevF4Device          = "F4 豸";
    ls->dbgDevKorean80          = "Korean 80";
    ls->dbgDevKorean90          = "Korean 90";
    ls->dbgDevKorean128         = "Korean 128";
    ls->dbgDevFdcMicrosol       = "Microsol FDC";
    ls->dbgDevPrinter           = "ӡ";
    ls->dbgDevSviFdc            = "SVI FDC";
    ls->dbgDevSviPrn            = "SVI ӡ";
    ls->dbgDevSvi80Col          = "SVI 80 ";
    ls->dbgDevRtc               = "RTC";
    ls->dbgDevTrPause           = "TR ͣ";


    //----------------------
    // Debug type lines
    // Note: Can only be translated to european languages
    //----------------------

    ls->aboutScrollThanksTo     = "Special thanks to: ";
    ls->aboutScrollAndYou       = "and YOU !!!!";
};

#endif
