/*****************************************************************************
** $Source: /cygdrive/d/Private/_SVNROOT/bluemsx/blueMSX/Src/IoDevice/FdcAudio.c,v $
**
** $Revision: 1.8 $
**
** $Date: 2008-05-17 04:51:03 $
**
** More info: http://www.bluemsx.com
**
** Copyright (C) 2003-2006 Daniel Vik
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
******************************************************************************
*/
#include "FdcAudio.h"
#include "Board.h"
#include "SamplePlayer.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#ifdef NO_EMBEDDED_SAMPLES

FdcAudio* fdcAudioCreate(FdcAudioType type) { return NULL; }
void fdcAudioDestroy(FdcAudio* fdcAudio) {}
void fdcAudioReset(FdcAudio* fdcAudio) {}
void fdcAudioSetMotor(FdcAudio* fdcAudio, int motorOn) {}
void fdcAudioSetReadWrite(FdcAudio* fdcAudio) {}

#else

static Int32 PanasonicReadCount = 17733;
static Int16 PanasonicReadSamples[] = {
    0x01c8, 0x0604, 0x08ac, 0x08c1, 0x062a, 0x02a0, 0xff25, 0xfb9d,
    0xf8c1, 0xf7b5, 0xf8d7, 0xfbbd, 0xffb7, 0x0428, 0x0892, 0x0bd0,
    0x0d09, 0x0bff, 0x0863, 0x0355, 0xff4f, 0xfd22, 0xfbfb, 0xfb54,
    0xfa5d, 0xf8a9, 0xf734, 0xf690, 0xf639, 0xf60b, 0xf6ea, 0xf9fd,
    0xff56, 0x05e8, 0x0c1f, 0x1019, 0x1090, 0x0d79, 0x07f3, 0x013e,
    0xfa8d, 0xf598, 0xf3ad, 0xf4b3, 0xf7ff, 0xfd39, 0x02f1, 0x06f0,
    0x07f1, 0x05f4, 0x02b3, 0x003e, 0xff2f, 0xff6e, 0x0015, 0xff31,
    0xfcaf, 0xfa48, 0xf97b, 0xfba4, 0x00bf, 0x0694, 0x0a79, 0x0adb,
    0x07b5, 0x02d9, 0xfe4e, 0xfb05, 0xf983, 0xf9e2, 0xfbb0, 0xfe2e,
    0x00e6, 0x0355, 0x04da, 0x0518, 0x0470, 0x0306, 0x00bd, 0xfe20,
    0xfaef, 0xf7a1, 0xf5c3, 0xf67f, 0xf955, 0xfd13, 0x0145, 0x055a,
    0x0859, 0x0977, 0x08a9, 0x06dc, 0x04b6, 0x0219, 0xfeb9, 0xfb09,
    0xf820, 0xf6a0, 0xf715, 0xf94a, 0xfc3d, 0xff24, 0x01aa, 0x02d2,
    0x023e, 0x01b1, 0x029b, 0x049c, 0x06b9, 0x084e, 0x08ee, 0x082b,
    0x064d, 0x03d3, 0x00b6, 0xfd23, 0xf9d3, 0xf7f9, 0xf7f0, 0xf963,
    0xfbbf, 0xfdb3, 0xfe6d, 0xfe2f, 0xfe13, 0xfe72, 0xff22, 0x0054,
    0x01e3, 0x02ff, 0x02e7, 0x0265, 0x0216, 0x01ba, 0x015c, 0x00ec,
    0xff8b, 0xfd38, 0xfb3b, 0xfab7, 0xfbf2, 0xfe48, 0x00dd, 0x02fb,
    0x03cb, 0x0285, 0xff7f, 0xfc74, 0xfaef, 0xfaf3, 0xfc8e, 0xff8c,
    0x02f9, 0x063a, 0x08cf, 0x09da, 0x07c2, 0x02f8, 0xfcee, 0xf707,
    0xf487, 0xf5e2, 0xf92b, 0xfd40, 0x0151, 0x04e4, 0x067b, 0x0631,
    0x0537, 0x03ca, 0x021e, 0x00ab, 0xff79, 0xfe5d, 0xfe69, 0xffca,
    0x00dd, 0x0068, 0xff55, 0xfe66, 0xfdba, 0xfe2d, 0xffac, 0x0143,
    0x01e3, 0x0184, 0x0062, 0xfeaa, 0xfd2f, 0xfc62, 0xfc37, 0xfcde,
    0xfe5a, 0xfffa, 0x0176, 0x02ae, 0x030f, 0x02fc, 0x037e, 0x0442,
    0x047b, 0x046c, 0x0416, 0x027d, 0xffcd, 0xfe0f, 0xfda4, 0xfd0b,
    0xfc37, 0xfb90, 0xfac8, 0xfa5a, 0xfbbf, 0xfe52, 0xffe1, 0x0067,
    0x0162, 0x0217, 0x00d9, 0xfe88, 0xfcf7, 0xfc98, 0xfd7a, 0x00cd,
    0x0568, 0x0883, 0x09b7, 0x0933, 0x0614, 0x0090, 0xfb76, 0xf913,
    0xf8e5, 0xfa10, 0xfc5b, 0xfe65, 0xff71, 0x0040, 0x0120, 0x014f,
    0xffc9, 0xfd22, 0xfade, 0xfa19, 0xfbf1, 0x0035, 0x0538, 0x09fc,
    0x0cd3, 0x0bf8, 0x075f, 0x00e0, 0xfaa2, 0xf584, 0xf2c6, 0xf385,
    0xf71c, 0xfbf2, 0x019e, 0x06ab, 0x096c, 0x0a49, 0x097c, 0x06da,
    0x0374, 0xffa0, 0xfb69, 0xf895, 0xf796, 0xf75f, 0xf8a3, 0xfd05,
    0x0295, 0x0630, 0x07f8, 0x0898, 0x0745, 0x03bf, 0xff6b, 0xfb12,
    0xf79d, 0xf651, 0xf72c, 0xf983, 0xfcbf, 0x0076, 0x03b0, 0x0573,
    0x0567, 0x040f, 0x0213, 0x0004, 0xfebd, 0xfe9d, 0xff4a, 0x00a4,
    0x02bb, 0x043d, 0x03f9, 0x0288, 0x006b, 0xfdbb, 0xfb5d, 0xfa20,
    0xfa8b, 0xfd1d, 0x017e, 0x065c, 0x0a20, 0x0ba4, 0x0a1b, 0x0605,
    0x00d3, 0xfb7e, 0xf772, 0xf5f4, 0xf721, 0xf9fe, 0xfd89, 0x00f8,
    0x02d6, 0x026c, 0x0054, 0xfd95, 0xfafa, 0xfa0d, 0xfc06, 0xff98,
    0x02c7, 0x045f, 0x048f, 0x0472, 0x040f, 0x02f3, 0x0107, 0xfed9,
    0xfd5e, 0xfd64, 0xfecc, 0x00b3, 0x02ff, 0x0550, 0x0634, 0x04f9,
    0x01cf, 0xfd85, 0xf975, 0xf726, 0xf78f, 0xfa30, 0xfe74, 0x0329,
    0x070e, 0x0980, 0x0980, 0x0725, 0x03ca, 0x0008, 0xfc61, 0xfa92,
    0xfb25, 0xfc8a, 0xfd36, 0xfd51, 0xfdb7, 0xfe95, 0xffad, 0x0153,
    0x0378, 0x04e5, 0x0467, 0x02f0, 0x01de, 0x0108, 0x0052, 0xff86,
    0xfe06, 0xfc3d, 0xfb96, 0xfbde, 0xfc5a, 0xfdac, 0x000e, 0x01bd,
    0x0151, 0xff41, 0xfce9, 0xfb20, 0xfa45, 0xfac3, 0xfc26, 0xfdc2,
    0xffed, 0x024b, 0x037a, 0x032d, 0x02aa, 0x02a2, 0x02f2, 0x040f,
    0x05eb, 0x0716, 0x06c7, 0x0568, 0x0282, 0xfdd5, 0xf95c, 0xf6df,
    0xf620, 0xf65c, 0xf841, 0xfcb9, 0x01a7, 0x0569, 0x08c8, 0x0ae7,
    0x09d8, 0x0647, 0x0241, 0xfe07, 0xf9ae, 0xf794, 0xf941, 0xfd43,
    0x0236, 0x07b2, 0x0bc6, 0x0c5e, 0x09c5, 0x0560, 0xffe9, 0xf94c,
    0xf303, 0xee62, 0xebab, 0xecce, 0xf2fa, 0xfc03, 0x0411, 0x08ef,
    0x0ad9, 0x09ec, 0x06a7, 0x03b2, 0x0238, 0x006d, 0xfe0a, 0xfd37,
    0xfe56, 0xff99, 0x0120, 0x0385, 0x0551, 0x0581, 0x0505, 0x035c,
    0xffa4, 0xfc5a, 0xfb4a, 0xfb8a, 0xfcaa, 0xfef1, 0x0209, 0x0473,
    0x04cc, 0x03ec, 0x0226, 0xfe67, 0xf9b7, 0xf767, 0xf8c8, 0xfcc5,
    0x0224, 0x0765, 0x0acb, 0x0b13, 0x07b5, 0x00ad, 0xf7fc, 0xf143,
    0xee5d, 0xeedf, 0xf30b, 0xfad2, 0x044f, 0x0d31, 0x13a6, 0x15e5,
    0x12c7, 0x0b4a, 0x0214, 0xf8dd, 0xf0cc, 0xec91, 0xee3d, 0xf496,
    0xfc5c, 0x03d4, 0x09a2, 0x0b73, 0x08ab, 0x036c, 0xfe96, 0xfb49,
    0xfa31, 0xfb2d, 0xfd24, 0xffa1, 0x02d4, 0x06f5, 0x0a8e, 0x0c16,
    0x0aca, 0x0690, 0x00d8, 0xfbae, 0xf850, 0xf720, 0xf739, 0xf83d,
    0xf9e4, 0xfb6e, 0xfc98, 0xfdfc, 0xfff3, 0x00d2, 0x0101, 0x0166,
    0x015f, 0x017b, 0x03cb, 0x07a9, 0x0949, 0x076a, 0x03d0, 0x0024,
    0xfcc0, 0xfab1, 0xfb29, 0xfcef, 0xfe58, 0xfef1, 0xfe36, 0xfba9,
    0xf8e7, 0xf828, 0xf9a0, 0xfc5d, 0xff87, 0x02b8, 0x0597, 0x0865,
    0x0ac8, 0x0b5d, 0x0959, 0x05c5, 0x0279, 0xffe9, 0xfe32, 0xfdc8,
    0xfe02, 0xfe33, 0xfe07, 0xfd38, 0xfc44, 0xfba3, 0xfb4f, 0xfb4a,
    0xfc0a, 0xfd63, 0xfe7f, 0xff35, 0x0006, 0x00a8, 0x0092, 0x0001,
    0xff70, 0xff23, 0xff0a, 0xff58, 0x0069, 0x028e, 0x04d8, 0x057f,
    0x044f, 0x0258, 0x0014, 0xfd6e, 0xfb15, 0xfaaa, 0xfcca, 0x003b,
    0x0323, 0x04ba, 0x04f2, 0x0490, 0x0544, 0x0694, 0x0695, 0x04df,
    0x0214, 0xfe06, 0xf9a9, 0xf71f, 0xf691, 0xf7da, 0xfb6d, 0xffb1,
    0x01ed, 0x0183, 0x0009, 0xfe6d, 0xfca9, 0xfb60, 0xfbee, 0xfe15,
    0x0052, 0x0288, 0x047c, 0x04ec, 0x03d0, 0x0301, 0x0343, 0x03d4,
    0x0460, 0x04f6, 0x0534, 0x053e, 0x0545, 0x04ae, 0x0350, 0x0185,
    0xff4d, 0xfc3a, 0xf87a, 0xf50b, 0xf32c, 0xf3a1, 0xf624, 0xfa77,
    0xfff1, 0x043a, 0x0687, 0x07c4, 0x078e, 0x056c, 0x026a, 0xffe7,
    0xfdee, 0xfc50, 0xfc25, 0xfdc4, 0xffc1, 0x011e, 0x026f, 0x0364,
    0x032a, 0x0165, 0xfe6a, 0xfb83, 0xf96d, 0xf8fe, 0xfa8e, 0xfdc2,
    0x01b6, 0x053d, 0x070d, 0x0728, 0x0687, 0x0524, 0x02a2, 0xfffc,
    0xfe38, 0xfcc9, 0xfb7b, 0xfb3c, 0xfd3a, 0x0056, 0x021b, 0x0199,
    0xfff0, 0xfe20, 0xfcb5, 0xfcb0, 0xfd93, 0xfdf3, 0xfe1d, 0xffa1,
    0x023b, 0x0482, 0x057d, 0x0473, 0x00d8, 0xfb7c, 0xf681, 0xf465,
    0xf681, 0xfb92, 0x00b9, 0x04e1, 0x082c, 0x0928, 0x0716, 0x0373,
    0xffe8, 0xfce0, 0xfa72, 0xf9ea, 0xfc86, 0x00db, 0x04bb, 0x0769,
    0x0964, 0x0add, 0x0ab9, 0x0867, 0x04b2, 0x0066, 0xfb37, 0xf5a9,
    0xf190, 0xefb0, 0xf041, 0xf33c, 0xf7f8, 0xfd9a, 0x0301, 0x0727,
    0x096c, 0x0931, 0x0693, 0x031d, 0x00ca, 0xffad, 0xfebe, 0xfe04,
    0xfe41, 0xff6a, 0x00af, 0x025a, 0x0491, 0x060d, 0x05c1, 0x0375,
    0xff1b, 0xf924, 0xf40c, 0xf2b0, 0xf5b2, 0xfb64, 0x015d, 0x064b,
    0x096b, 0x0aea, 0x0b20, 0x0991, 0x063d, 0x0259, 0xfea8, 0xfaeb,
    0xf87a, 0xf8b5, 0xfaaa, 0xfcd0, 0xfe31, 0xfd5b, 0xfa77, 0xf800,
    0xf73a, 0xf82c, 0xfb6b, 0x00b3, 0x05a1, 0x08de, 0x0b05, 0x0b45,
    0x0864, 0x03c2, 0xff67, 0xfb92, 0xf8bc, 0xf838, 0xfad9, 0x0006,
    0x0624, 0x0bc1, 0x0e7e, 0x0c83, 0x0740, 0x016f, 0xfc87, 0xf93f,
    0xf90c, 0xfba1, 0xfe34, 0xff85, 0x011b, 0x036a, 0x04d1, 0x0515,
    0x03fb, 0x0051, 0xfab9, 0xf557, 0xf237, 0xf273, 0xf642, 0xfcb3,
    0x041c, 0x0a77, 0x0e16, 0x0dde, 0x08bb, 0xfffc, 0xf729, 0xf16a,
    0xeff5, 0xf316, 0xfa13, 0x022d, 0x085f, 0x0bb1, 0x0c75, 0x0a1c,
    0x0623, 0x036e, 0x02ea, 0x03a3, 0x0453, 0x03f0, 0x0229, 0x008b,
    0x010b, 0x0326, 0x03d2, 0x00e0, 0xfa72, 0xf2cd, 0xed4b, 0xebe0,
    0xeece, 0xf429, 0xfaad, 0x03ea, 0x0e03, 0x13ea, 0x141a, 0x0fec,
    0x0871, 0x001b, 0xfaab, 0xf8a7, 0xf89b, 0xf998, 0xfa78, 0xfaf3,
    0xfb60, 0xfc47, 0xfd21, 0xfebb, 0x0230, 0x0536, 0x057b, 0x039e,
    0x01be, 0x00a9, 0xff81, 0xfe0a, 0xfe9d, 0x0147, 0x0375, 0x04ba,
    0x05d0, 0x0493, 0xff7d, 0xf946, 0xf500, 0xf42b, 0xf706, 0xfbf4,
    0x0015, 0x01cb, 0x01de, 0x011e, 0x0024, 0x008b, 0x02f0, 0x0611,
    0x0784, 0x05b7, 0x0212, 0xfe77, 0xfbb1, 0xfaba, 0xfc4b, 0xff14,
    0xffab, 0xfea0, 0xfce9, 0xf9c1, 0xf988, 0xff38, 0x07f5, 0x0f51,
    0x1377, 0x1375, 0x0dfc, 0x044f, 0xface, 0xf5ac, 0xf528, 0xf7d4,
    0xfbc2, 0xff13, 0xffb6, 0xfd33, 0xfb09, 0xfbda, 0xfe74, 0x00b6,
    0x0172, 0xfeb4, 0xf8e6, 0xf439, 0xf32f, 0xf571, 0xfa7a, 0x0122,
    0x0658, 0x0884, 0x082a, 0x0642, 0x0472, 0x0371, 0x0251, 0x0028,
    0xfd34, 0xfa3f, 0xf866, 0xf92f, 0xfcce, 0x01d1, 0x0680, 0x0912,
    0x0844, 0x03cf, 0xfd43, 0xf72f, 0xf479, 0xf771, 0xfe9c, 0x06b9,
    0x0d8d, 0x1185, 0x10cc, 0x0aa3, 0x0143, 0xf825, 0xf265, 0xf1aa,
    0xf595, 0xfc39, 0x02cd, 0x0783, 0x0a94, 0x0c62, 0x0b2b, 0x05ef,
    0xfe3f, 0xf67b, 0xf15c, 0xf16e, 0xf640, 0xfc72, 0x0285, 0x088d,
    0x0c02, 0x0aca, 0x06f4, 0x021a, 0xfbb8, 0xf5c2, 0xf45d, 0xf80d,
    0xfe0b, 0x03df, 0x0807, 0x0923, 0x0727, 0x03f5, 0xffea, 0xfa89,
    0xf59f, 0xf3c7, 0xf4d3, 0xf7d3, 0xfceb, 0x0210, 0x04e3, 0x0628,
    0x0703, 0x05e4, 0x026c, 0xfed0, 0xfbe9, 0xf971, 0xf8d2, 0xfb29,
    0xff18, 0x0384, 0x0879, 0x0cce, 0x0e36, 0x0bde, 0x06fe, 0x0103,
    0xfbcc, 0xf9a2, 0xfaeb, 0xfde0, 0x0105, 0x03aa, 0x0576, 0x071b,
    0x088d, 0x0860, 0x0557, 0xff04, 0xf6bd, 0xefc3, 0xec72, 0xeca8,
    0xef87, 0xf471, 0xfa33, 0xff54, 0x034c, 0x068d, 0x0886, 0x086e,
    0x06c2, 0x0462, 0x0212, 0x0085, 0x0133, 0x03f3, 0x0747, 0x0a62,
    0x0c32, 0x0ac8, 0x05fa, 0xff7f, 0xf849, 0xf287, 0xf054, 0xf142,
    0xf455, 0xfa42, 0x024f, 0x091c, 0x0c79, 0x0cbc, 0x0a65, 0x060d,
    0x00a7, 0xfafe, 0xf5c0, 0xf2c1, 0xf391, 0xf64a, 0xf956, 0xfd69,
    0x02c1, 0x07b6, 0x0a54, 0x095d, 0x0501, 0xfeb4, 0xf884, 0xf4f1,
    0xf509, 0xf901, 0x0012, 0x07a9, 0x0ca4, 0x0e12, 0x0d0d, 0x0a40,
    0x05d6, 0x00c2, 0xfd41, 0xfc01, 0xfb91, 0xfba3, 0xfd08, 0xffb7,
    0x020e, 0x030e, 0x02e9, 0x010a, 0xfd1a, 0xf8d7, 0xf6ab, 0xf77c,
    0xfb04, 0x00a6, 0x05da, 0x07ba, 0x0609, 0x0223, 0xfc98, 0xf6c2,
    0xf370, 0xf310, 0xf507, 0xf975, 0x000b, 0x073a, 0x0d2b, 0x1007,
    0x0dd1, 0x073a, 0x0023, 0xfb7a, 0xf8c7, 0xf7cc, 0xfa6d, 0x00a4,
    0x068e, 0x0945, 0x0910, 0x06be, 0x0301, 0xfef0, 0xfbbe, 0xf984,
    0xf907, 0xfb9b, 0xffee, 0x03ac, 0x0584, 0x0430, 0xff81, 0xfa24,
    0xf729, 0xf6dd, 0xf892, 0xfbcc, 0xffb1, 0x036f, 0x0612, 0x0729,
    0x06cf, 0x0496, 0x00ef, 0xfd1a, 0xf9ec, 0xf758, 0xf60d, 0xf734,
    0xfa79, 0xfe3d, 0x0142, 0x03bc, 0x056f, 0x05ca, 0x04bb, 0x0355,
    0x0318, 0x03f7, 0x044d, 0x0371, 0x019a, 0xff44, 0xfdaa, 0xfd0f,
    0xfd44, 0xffd6, 0x04cf, 0x0908, 0x0a91, 0x094e, 0x0518, 0xfecd,
    0xf994, 0xf76e, 0xf7ae, 0xf8e9, 0xfa47, 0xfbc0, 0xfda9, 0x0004,
    0x028d, 0x04e8, 0x0655, 0x0619, 0x0449, 0x0109, 0xfbd3, 0xf618,
    0xf2fd, 0xf34e, 0xf656, 0xfb2b, 0x0062, 0x04d2, 0x0749, 0x074c,
    0x0565, 0x0306, 0x0202, 0x03a0, 0x077c, 0x0bae, 0x0e27, 0x0dd0,
    0x0a78, 0x0509, 0xff60, 0xfa64, 0xf649, 0xf3e4, 0xf3d3, 0xf5d7,
    0xf99b, 0xfd8c, 0x0002, 0x0064, 0xfed3, 0xfc4c, 0xf9a8, 0xf88e,
    0xf93d, 0xfa66, 0xfc86, 0x0099, 0x0575, 0x0958, 0x0b7c, 0x0aa7,
    0x06c1, 0x019b, 0xfd92, 0xfbbc, 0xfbaa, 0xfd15, 0xff94, 0x023d,
    0x04d5, 0x06d5, 0x0854, 0x0917, 0x0823, 0x057f, 0x024f, 0xfeff,
    0xfcf3, 0xfddd, 0xffdc, 0x00a5, 0xff11, 0xfba7, 0xf744, 0xf3ea,
    0xf363, 0xf53a, 0xf7e9, 0xfa24, 0xfcd3, 0x006d, 0x0353, 0x03f9,
    0x039d, 0x0430, 0x03ff, 0x01bc, 0xfebb, 0xfcd6, 0xfced, 0xfe78,
    0x0068, 0x0159, 0x01c3, 0x025b, 0x0323, 0x0345, 0x0256, 0x0149,
    0x00f9, 0x011b, 0x0131, 0x024e, 0x03bf, 0x033f, 0x0121, 0xff63,
    0xfe89, 0xfec7, 0x00ac, 0x029f, 0x02e2, 0x0231, 0x00bf, 0xfee5,
    0xfe16, 0xfeb6, 0xff2b, 0xfebe, 0xfe12, 0xfd3f, 0xfc5a, 0xfc25,
    0xfc52, 0xfc2e, 0xfcc3, 0xfdea, 0xfed1, 0x0036, 0x01ff, 0x024d,
    0x00c6, 0xff2b, 0xff1c, 0x0181, 0x0528, 0x076d, 0x0788, 0x0519,
    0x00c3, 0xfcfd, 0xfb7b, 0xfb86, 0xfcc4, 0xffb7, 0x023e, 0x01ff,
    0xfeee, 0xfa74, 0xf66e, 0xf4db, 0xf722, 0xfbbc, 0x004f, 0x04e0,
    0x0968, 0x0c44, 0x0b74, 0x07bd, 0x02d9, 0xfd7e, 0xf9fe, 0xfa31,
    0xfcd3, 0xff29, 0x0011, 0x00a8, 0x0113, 0x011d, 0x01f2, 0x0384,
    0x03d8, 0x0289, 0x00cf, 0xfe6f, 0xfb70, 0xfa0f, 0xfbd9, 0xfede,
    0x0127, 0x02ef, 0x03be, 0x021b, 0xff19, 0xfd2f, 0xfd4e, 0xff85,
    0x02b0, 0x0471, 0x0353, 0x003c, 0xfce1, 0xf9e9, 0xf7b5, 0xf761,
    0xf957, 0xfcde, 0x0174, 0x061e, 0x0889, 0x0831, 0x0709, 0x05f0,
    0x044a, 0x01b6, 0xfe8d, 0xfb41, 0xf96a, 0xface, 0xfe76, 0x0207,
    0x044d, 0x0550, 0x04c5, 0x0240, 0xfe70, 0xfada, 0xf856, 0xf6d5,
    0xf6ff, 0xf979, 0xfd3e, 0x0009, 0x00a8, 0xffd2, 0xff17, 0xff5e,
    0x0142, 0x04bd, 0x0859, 0x0b2f, 0x0d24, 0x0dd7, 0x0c2c, 0x085b,
    0x042b, 0xffb9, 0xfafc, 0xf6d5, 0xf373, 0xf25a, 0xf55a, 0xfb3a,
    0x012f, 0x05b9, 0x07fc, 0x0730, 0x039d, 0xfed2, 0xfa87, 0xf7ba,
    0xf698, 0xf644, 0xf6fa, 0xf97c, 0xfd0b, 0x0116, 0x0554, 0x0872,
    0x09e4, 0x0af2, 0x0aba, 0x07f9, 0x02eb, 0xfc34, 0xf6cd, 0xf3cf,
    0xf2a7, 0xf401, 0xf82a, 0xfd7e, 0x0264, 0x0701, 0x0ac1, 0x0c5e,
    0x0bb7, 0x084e, 0x018c, 0xf9de, 0xf583, 0xf5ca, 0xf8c8, 0xfcc4,
    0x008c, 0x03b7, 0x0626, 0x077d, 0x07f5, 0x07c6, 0x05db, 0x0233,
    0xfea9, 0xfc3c, 0xfb77, 0xfd31, 0x0018, 0x010c, 0x0042, 0xfed0,
    0xfcaa, 0xfaf4, 0xfaf9, 0xfcff, 0xff79, 0x01cd, 0x0496, 0x0754,
    0x0857, 0x063d, 0x0259, 0xfe1a, 0xf976, 0xf5fb, 0xf5c7, 0xf883,
    0xfbe6, 0xfedf, 0x0187, 0x031c, 0x03af, 0x0489, 0x055f, 0x042b,
    0x012c, 0xfe8b, 0xfce7, 0xfb90, 0xfae7, 0xfc91, 0x00a6, 0x04e3,
    0x06e6, 0x05c2, 0x01ab, 0xfcbd, 0xf924, 0xf783, 0xf7e4, 0xf9be,
    0xfbfa, 0xfdf4, 0xff67, 0x0011, 0x0043, 0x0088, 0x0123, 0x029d,
    0x0584, 0x07cf, 0x07a1, 0x06b5, 0x0639, 0x04c0, 0x0147, 0xfd86,
    0xfb79, 0xfae6, 0xfbe2, 0xffef, 0x0580, 0x08cd, 0x096f, 0x08ab,
    0x05ef, 0x0167, 0xfd0e, 0xf9cb, 0xf6e4, 0xf495, 0xf415, 0xf501,
    0xf697, 0xf9f4, 0xff80, 0x0508, 0x0942, 0x0bd2, 0x0bc9, 0x0866,
    0x02f3, 0xfdb6, 0xf94c, 0xf65a, 0xf674, 0xf913, 0xfb70, 0xfdb0,
    0x0120, 0x03ce, 0x03a7, 0x0285, 0x0202, 0x00d0, 0xff8e, 0x0056,
    0x021e, 0x02bf, 0x030f, 0x047b, 0x05cf, 0x050a, 0x02e9, 0x0163,
    0x0007, 0xfd47, 0xfa36, 0xf8b6, 0xf7f0, 0xf879, 0xfbd9, 0xff86,
    0x0167, 0x0300, 0x0446, 0x0311, 0xffb4, 0xfcd4, 0xfc04, 0xfc41,
    0xfdc0, 0x01b7, 0x06fc, 0x0c52, 0x10ef, 0x1272, 0x0e58, 0x05b0,
    0xfc7b, 0xf4e3, 0xefce, 0xee32, 0xeef2, 0xf0d0, 0xf4ca, 0xfbd2,
    0x0392, 0x0954, 0x0c35, 0x0c89, 0x0a03, 0x052a, 0x0119, 0xfe26,
    0xfb39, 0xf8a5, 0xf725, 0xf73b, 0xf861, 0xfbb1, 0x0139, 0x067d,
    0x0981, 0x0aa4, 0x0a41, 0x0799, 0x045a, 0x011e, 0xfe91, 0xfd1e,
    0xfbfa, 0xfa73, 0xf8b4, 0xf8c6, 0xfa77, 0xfceb, 0x0007, 0x0371,
    0x0574, 0x0482, 0x0189, 0xff46, 0xffeb, 0x0220, 0x02be, 0x00f6,
    0xfe6d, 0xfca2, 0xfc2d, 0xfcc0, 0xfdfd, 0x0010, 0x0273, 0x03c3,
    0x041f, 0x0372, 0x00e7, 0xfdc9, 0xfc2c, 0xfbe7, 0xfc03, 0xfdb5,
    0x00bd, 0x0299, 0x0288, 0x02c3, 0x049e, 0x05d9, 0x0584, 0x04c2,
    0x030f, 0xff60, 0xfbb4, 0xfac0, 0xfb34, 0xfa79, 0xf98c, 0xfa37,
    0xfb83, 0xfc96, 0xfe4b, 0x0042, 0x011f, 0x0191, 0x02c3, 0x034b,
    0x022a, 0x01aa, 0x024d, 0x01a6, 0xff48, 0xfdec, 0xfed2, 0x008b,
    0x0237, 0x02e9, 0x0149, 0xfeb6, 0xfdbf, 0xfe37, 0xff0a, 0x00a5,
    0x0316, 0x0525, 0x0561, 0x03be, 0x0114, 0xfd5b, 0xf963, 0xf7b7,
    0xf90e, 0xfba7, 0xff34, 0x0457, 0x0901, 0x0a00, 0x06b7, 0xff90,
    0xf70b, 0xf1e8, 0xf1ca, 0xf5b2, 0xfbf5, 0x02ba, 0x07d9, 0x0a40,
    0x0a84, 0x08f2, 0x05b6, 0x0116, 0xfc96, 0xfa6a, 0xfa2a, 0xfa3a,
    0xfaf9, 0xfcd1, 0xfdeb, 0xfdf3, 0xff32, 0x01d4, 0x0421, 0x0564,
    0x0613, 0x0647, 0x061a, 0x05a3, 0x054d, 0x0580, 0x0524, 0x02d4,
    0xfe98, 0xf9f1, 0xf626, 0xf413, 0xf41a, 0xf6f8, 0xfc84, 0x0279,
    0x06c5, 0x08e4, 0x0912, 0x0784, 0x0400, 0xfe68, 0xf822, 0xf33f,
    0xf138, 0xf2d6, 0xf8b2, 0x019a, 0x0a7b, 0x10ea, 0x137c, 0x10ed,
    0x0953, 0xffac, 0xf766, 0xf157, 0xee2f, 0xefa2, 0xf544, 0xfc47,
    0x01fa, 0x0611, 0x091d, 0x0a80, 0x0a0a, 0x0946, 0x08b0, 0x06be,
    0x0337, 0x0015, 0xfe28, 0xfc7b, 0xfb92, 0xfbe6, 0xfbf5, 0xfbe8,
    0xfc5b, 0xfcae, 0xfd3f, 0xff30, 0x01ca, 0x0336, 0x02de, 0x01a3,
    0x009c, 0xff7f, 0xfd6f, 0xfad8, 0xf89c, 0xf6a0, 0xf56e, 0xf6c0,
    0xfb2e, 0x012c, 0x07b3, 0x0dc9, 0x1186, 0x1243, 0x10ea, 0x0e43,
    0x0a92, 0x0599, 0xff7b, 0xf977, 0xf3f7, 0xef71, 0xedb8, 0xefae,
    0xf3ec, 0xf9a7, 0x00bf, 0x07a3, 0x0ba9, 0x0b1d, 0x0509, 0xfa82,
    0xf112, 0xedcf, 0xf01f, 0xf523, 0xfca0, 0x0591, 0x0d10, 0x11e2,
    0x1427, 0x1368, 0x0f1b, 0x0804, 0x002a, 0xf8d1, 0xf295, 0xf052,
    0xf383, 0xf8ed, 0xfdb5, 0x0227, 0x0552, 0x055d, 0x0304, 0x0062,
    0xff2b, 0x008c, 0x044e, 0x0883, 0x0a7e, 0x0919, 0x04e6, 0xff25,
    0xf9b2, 0xf5cd, 0xf355, 0xf24b, 0xf429, 0xf8c5, 0xfdc9, 0x0250,
    0x05e6, 0x079b, 0x071d, 0x0504, 0x01d8, 0xfe46, 0xfc26, 0xfba4,
    0xfbae, 0xfced, 0x0135, 0x07c2, 0x0d4a, 0x0f98, 0x0d61, 0x06b7,
    0xfe20, 0xf6e5, 0xf24c, 0xf101, 0xf43d, 0xfa5e, 0xffda, 0x025e,
    0x0128, 0xfd0e, 0xf924, 0xf8da, 0xfc7e, 0x015c, 0x04b4, 0x059a,
    0x05be, 0x0687, 0x071f, 0x070d, 0x0548, 0x0123, 0xfcf3, 0xfb56,
    0xfcde, 0x001c, 0x034c, 0x0543, 0x0547, 0x03de, 0x01ef, 0x0020,
    0xfef9, 0xfe5a, 0xfc7e, 0xf7f7, 0xf30c, 0xf116, 0xf39f, 0xf996,
    0x0186, 0x09e6, 0x0f41, 0x1035, 0x0e63, 0x0b4c, 0x07ca, 0x04e8,
    0x02b6, 0xff92, 0xfb09, 0xf733, 0xf570, 0xf50f, 0xf507, 0xf616,
    0xf8cf, 0xfc19, 0xffa5, 0x0359, 0x05b0, 0x05b1, 0x04d8, 0x0430,
    0x030d, 0x01d9, 0x00ac, 0xfe2d, 0xfba3, 0xfb3f, 0xfc49, 0xfdbb,
    0x00c4, 0x056c, 0x0843, 0x075d, 0x0413, 0x0011, 0xfb99, 0xf7c2,
    0xf67d, 0xf719, 0xf7eb, 0xf8b7, 0xfb41, 0x0097, 0x0669, 0x0a99,
    0x0d73, 0x0ee0, 0x0d96, 0x0a81, 0x06b3, 0x00ee, 0xf9f0, 0xf561,
    0xf513, 0xf71f, 0xf9c0, 0xfb89, 0xfbba, 0xfc29, 0xfeb7, 0x0319,
    0x06d1, 0x0892, 0x08ea, 0x07eb, 0x046c, 0xfec5, 0xf95a, 0xf5f5,
    0xf492, 0xf53d, 0xf7c3, 0xfadf, 0xfdf2, 0x0187, 0x05b6, 0x08e8,
    0x0a69, 0x0ab5, 0x0a05, 0x08b4, 0x06db, 0x0373, 0xfea0, 0xf92c,
    0xf416, 0xf04c, 0xef71, 0xf2ea, 0xf9e2, 0x0246, 0x09e9, 0x0f31,
    0x1061, 0x0c65, 0x0353, 0xf8b6, 0xf20a, 0xf142, 0xf506, 0xfb4d,
    0x01de, 0x065d, 0x07e9, 0x07ea, 0x07e6, 0x07d6, 0x0712, 0x0494,
    0xffea, 0xfa5d, 0xf65e, 0xf5d4, 0xf801, 0xfb38, 0xfec4, 0x019a,
    0x0288, 0x0175, 0x0020, 0x0004, 0x012b, 0x035a, 0x05f0, 0x0806,
    0x081f, 0x0580, 0x0141, 0xfc74, 0xf77a, 0xf383, 0xf280, 0xf554,
    0xfaf0, 0x0181, 0x07ca, 0x0c5e, 0x0e25, 0x0cf5, 0x085f, 0x017c,
    0xfb4f, 0xf7b4, 0xf634, 0xf641, 0xf818, 0xfc05, 0x0244, 0x08e5,
    0x0c5c, 0x0ab3, 0x0511, 0xfe87, 0xf8e0, 0xf581, 0xf59e, 0xf8cf,
    0xfd09, 0x0034, 0x0177, 0x0014, 0xfc75, 0xf946, 0xf932, 0xfc76,
    0x0191, 0x06b5, 0x09f9, 0x0b08, 0x0b26, 0x09ab, 0x04f7, 0xfeab,
    0xfa67, 0xf8e2, 0xf93a, 0xfc86, 0x0285, 0x080b, 0x0b43, 0x0bd7,
    0x091d, 0x039e, 0xfdc1, 0xf8d4, 0xf493, 0xf1f3, 0xf227, 0xf3df,
    0xf5b2, 0xf83c, 0xfba9, 0xff2f, 0x0207, 0x0458, 0x0667, 0x07d8,
    0x0898, 0x093e, 0x09f5, 0x0a0f, 0x0906, 0x06bc, 0x02d4, 0xfd3d,
    0xf77e, 0xf3d5, 0xf332, 0xf50b, 0xf94b, 0xffb2, 0x0606, 0x09e5,
    0x0ab1, 0x088d, 0x03e4, 0xfe56, 0xf99f, 0xf60d, 0xf42a, 0xf4e3,
    0xf7e3, 0xfbcc, 0x0069, 0x0619, 0x0b7c, 0x0eca, 0x0f1d, 0x0c3b,
    0x0659, 0xff1e, 0xf874, 0xf320, 0xefc9, 0xf00a, 0xf41b, 0xf9d6,
    0xff83, 0x0476, 0x07ef, 0x094a, 0x09d1, 0x0a14, 0x0837, 0x0328,
    0xfdc5, 0xfb9d, 0xfd1c, 0x0021, 0x0259, 0x02eb, 0x011c, 0xfe8f,
    0xfd99, 0xfeb0, 0x00aa, 0x00e2, 0x0066, 0x01b0, 0x02ee, 0x01a5,
    0xfe4d, 0xfa00, 0xf542, 0xf23d, 0xf388, 0xf82b, 0xfe6c, 0x04b1,
    0x087f, 0x082c, 0x050e, 0x030c, 0x034a, 0x0534, 0x07aa, 0x0962,
    0x08b4, 0x04b8, 0xfef6, 0xfafc, 0xf957, 0xf93f, 0xfb00, 0xfc6b,
    0xfbcf, 0xfb28, 0xfe0f, 0x02e5, 0x066f, 0x07ae, 0x05ba, 0x007e,
    0xfa09, 0xf4f1, 0xf296, 0xf43d, 0xf9fa, 0x00af, 0x0606, 0x09bc,
    0x0b55, 0x0a5d, 0x0745, 0x0324, 0xfeb3, 0xfaae, 0xf801, 0xf7c1,
    0xf928, 0xfa83, 0xfc32, 0xff4b, 0x01ef, 0x02e8, 0x042a, 0x0591,
    0x0608, 0x065d, 0x0718, 0x079b, 0x0745, 0x060c, 0x03a5, 0xff9f,
    0xf9f5, 0xf4bb, 0xf327, 0xf523, 0xf8a1, 0xfcfd, 0x022e, 0x06d9,
    0x0937, 0x0935, 0x074b, 0x0379, 0xfeb8, 0xfa6f, 0xf6df, 0xf490,
    0xf4cd, 0xf7b9, 0xfcc4, 0x027e, 0x0735, 0x0a7e, 0x0bd5, 0x0961,
    0x0334, 0xfbbf, 0xf622, 0xf489, 0xf67a, 0xfa08, 0xfd70, 0x0115,
    0x0578, 0x0947, 0x0aa0, 0x08a4, 0x0392, 0xfced, 0xf7ae, 0xf619,
    0xf7cc, 0xfc27, 0x0291, 0x08ec, 0x0c90, 0x0b53, 0x05ae, 0xff6f,
    0xfbbf, 0xfac8, 0xfc26, 0xff64, 0x027b, 0x0435, 0x04af, 0x0390,
    0x002f, 0xfb3c, 0xf659, 0xf3b3, 0xf55f, 0xfa80, 0x0000, 0x0349,
    0x04e1, 0x05fd, 0x061b, 0x0545, 0x0425, 0x0262, 0xff07, 0xfb89,
    0xfac5, 0xfd26, 0x00c6, 0x048f, 0x0766, 0x06ba, 0x01c4, 0xfbd7,
    0xf821, 0xf6d2, 0xf7cf, 0xfad5, 0xff49, 0x0509, 0x0953, 0x0a0a,
    0x0812, 0x04a5, 0x012f, 0xfd36, 0xf8d2, 0xf546, 0xf42f, 0xf62e,
    0xfa50, 0xff57, 0x0352, 0x0682, 0x08d4, 0x099d, 0x0889, 0x0529,
    0x002f, 0xfb0f, 0xf813, 0xf81d, 0xfaa3, 0xfea5, 0x0269, 0x03bf,
    0x02e8, 0x0282, 0x0315, 0x0344, 0x0322, 0x02bb, 0x00fc, 0xff67,
    0xff97, 0x00ef, 0x021d, 0x028b, 0x034b, 0x034c, 0x01a8, 0xff4d,
    0xfc38, 0xf94e, 0xf8a3, 0xfa9e, 0xfcad, 0xfd4a, 0xfd25, 0xfdb5,
    0xff06, 0xffa9, 0xff40, 0xfec3, 0xfdfb, 0xfcfc, 0xfd33, 0xfeb1,
    0x0088, 0x02e1, 0x063a, 0x0960, 0x0aea, 0x0b07, 0x09e9, 0x0760,
    0x048b, 0x012d, 0xfd26, 0xf8de, 0xf434, 0xf002, 0xee88, 0xf175,
    0xf7f8, 0x012c, 0x0a8e, 0x0f96, 0x0ead, 0x084d, 0xfd53, 0xf205,
    0xeccc, 0xef78, 0xf5d0, 0xfd2c, 0x046b, 0x0994, 0x0bca, 0x0c0d,
    0x0b50, 0x0933, 0x05d0, 0x020f, 0xff12, 0xfcba, 0xfb0d, 0xfb03,
    0xfbfb, 0xfbfb, 0xfc25, 0xfde6, 0xffd3, 0x00ba, 0x008e, 0x0078,
    0x01b5, 0x0438, 0x06f6, 0x08f4, 0x08ba, 0x049f, 0xfdc9, 0xf8bc,
    0xf747, 0xf7c6, 0xfa4c, 0xff79, 0x0485, 0x0673, 0x065a, 0x04d8,
    0x013e, 0xfd4d, 0xfb3a, 0xfa05, 0xf859, 0xf7dd, 0xf973, 0xfbfa,
    0xff2f, 0x03e5, 0x096d, 0x0d4b, 0x0d4e, 0x096b, 0x02fd, 0xfbf1,
    0xf717, 0xf638, 0xf82c, 0xfb57, 0xff80, 0x0307, 0x039a, 0x0125,
    0xfcd7, 0xf89d, 0xf6a0, 0xf7be, 0xfa81, 0xfce4, 0xffb2, 0x044f,
    0x0a7f, 0x104b, 0x122a, 0x0e20, 0x065e, 0xff64, 0xfb6d, 0xfa0d,
    0xfadf, 0xfd7f, 0x0122, 0x03f8, 0x048b, 0x039b, 0x022d, 0xffda,
    0xfcd6, 0xfa69, 0xf853, 0xf5fb, 0xf486, 0xf569, 0xf851, 0xfbfa,
    0x002d, 0x0479, 0x06cf, 0x066b, 0x04ee, 0x03ca, 0x0333, 0x0340,
    0x0405, 0x04c4, 0x04ae, 0x038e, 0x010c, 0xfd14, 0xf972, 0xf80e,
    0xf87e, 0xfa42, 0xfdca, 0x01b4, 0x03c9, 0x0465, 0x04c3, 0x0488,
    0x0336, 0x0133, 0xfeab, 0xfba2, 0xf937, 0xf847, 0xf89b, 0xfa80,
    0xfe44, 0x02d0, 0x06f8, 0x09b7, 0x099d, 0x06ce, 0x0251, 0xfca2,
    0xf6f2, 0xf39c, 0xf3ae, 0xf66d, 0xfafa, 0x0091, 0x05f8, 0x0a53,
    0x0e26, 0x10aa, 0x0fd5, 0x0ae2, 0x0327, 0xfbb3, 0xf7b4, 0xf7b4,
    0xfa2e, 0xfce8, 0xfe8b, 0x002b, 0x01f6, 0x0335, 0x02bb, 0x0001,
    0xfc93, 0xfa00, 0xf8c7, 0xf869, 0xf8d8, 0xfa57, 0xfce5, 0x0039,
    0x035c, 0x050e, 0x0540, 0x043d, 0x01fb, 0xfe3e, 0xfa86, 0xf945,
    0xfb4f, 0xffd1, 0x0559, 0x0a6e, 0x0d8d, 0x0dff, 0x0c2a, 0x0811,
    0x00c3, 0xf8a5, 0xf324, 0xf043, 0xf015, 0xf473, 0xfd2e, 0x0753,
    0x0f4c, 0x123f, 0x0e3d, 0x0419, 0xf817, 0xee82, 0xea52, 0xecf3,
    0xf46c, 0xfc7d, 0x0360, 0x0955, 0x0db0, 0x0f40, 0x0e0f, 0x0a4f,
    0x0474, 0xfde8, 0xf845, 0xf4f4, 0xf4aa, 0xf725, 0xfb70, 0x00eb,
    0x05fd, 0x0962, 0x0a08, 0x0763, 0x0340, 0xffc7, 0xfe14, 0xfe2e,
    0xff6a, 0x0052, 0x0015, 0xff1e, 0xfd45, 0xfa58, 0xf889, 0xfa48,
    0xfe7d, 0x02d3, 0x06ed, 0x0a6e, 0x0aae, 0x0735, 0x02d9, 0xfec8,
    0xfafe, 0xf7d4, 0xf603, 0xf5b6, 0xf725, 0xfa3c, 0xfe49, 0x0247,
    0x054e, 0x0787, 0x087a, 0x0723, 0x03c4, 0xfff2, 0xfcaa, 0xfa6b,
    0xfa13, 0xfa9a, 0xfa63, 0xfa9e, 0xfd28, 0x00d9, 0x0321, 0x042f,
    0x044b, 0x015a, 0xfc33, 0xf902, 0xf8fc, 0xfae3, 0xff53, 0x0682,
    0x0c29, 0x0b60, 0x05e8, 0x00a9, 0xfe65, 0xfefe, 0x0218, 0x0678,
    0x082e, 0x06bc, 0x037a, 0xfe8b, 0xf968, 0xf6c7, 0xf727, 0xf858,
    0xfa7c, 0xfe4f, 0x01f8, 0x03ac, 0x03b9, 0x02b5, 0x0093, 0xfec3,
    0xfe84, 0xfe9f, 0xfdbd, 0xfcad, 0xfc3c, 0xfcf8, 0xfedd, 0x01fa,
    0x061d, 0x084e, 0x06dc, 0x032b, 0xff5c, 0xfc4b, 0xfb05, 0xfbcf,
    0xfe09, 0x0199, 0x0577, 0x07c2, 0x0784, 0x055e, 0x01f1, 0xfd9d,
    0xf8ba, 0xf42b, 0xf21b, 0xf410, 0xf901, 0xff27, 0x054f, 0x0967,
    0x0a56, 0x09d6, 0x0861, 0x048e, 0xff38, 0xfa86, 0xf6a3, 0xf470,
    0xf619, 0xfb1f, 0x0052, 0x040a, 0x06a8, 0x079c, 0x0640, 0x03e0,
    0x0207, 0xfffd, 0xfd6e, 0xfbc6, 0xfc13, 0xfed5, 0x033f, 0x07cc,
    0x0ad0, 0x0b4a, 0x09c4, 0x05bb, 0x0014, 0xfbe0, 0xf9e2, 0xf86d,
    0xf6da, 0xf5e4, 0xf53b, 0xf57d, 0xf842, 0xfd02, 0x0100, 0x0229,
    0x011b, 0xffc6, 0xff5b, 0x0057, 0x0228, 0x03ff, 0x0510, 0x053e,
    0x0580, 0x05b9, 0x0608, 0x0806, 0x0a06, 0x086b, 0x0339, 0xfc7c,
    0xf4f7, 0xeea1, 0xed4d, 0xf0f5, 0xf77e, 0x0035, 0x09d7, 0x10d5,
    0x114b, 0x0a07, 0xfdab, 0xf1f9, 0xebc1, 0xec6d, 0xf2d5, 0xfbe0,
    0x0560, 0x0e27, 0x13af, 0x137a, 0x0e7e, 0x0760, 0xff39, 0xf831,
    0xf4a3, 0xf37f, 0xf48a, 0xf940, 0xff8b, 0x041d, 0x071e, 0x08bc,
    0x06ce, 0x01cd, 0xfd25, 0xfb77, 0xfcbe, 0xff93, 0x03a4, 0x0802,
    0x0908, 0x04e1, 0xfe6d, 0xf956, 0xf666, 0xf5a7, 0xf888, 0xfdcd,
    0x0234, 0x0501, 0x06c1, 0x0658, 0x03ba, 0x0126, 0xff68, 0xfd5a,
    0xfb96, 0xfbe4, 0xfd3c, 0xfdbf, 0xfe6b, 0x0207, 0x07ec, 0x0c3b,
    0x0cff, 0x09f7, 0x03f1, 0xfcfd, 0xf7a4, 0xf531, 0xf562, 0xf819,
    0xfc2e, 0xfeb6, 0xfdac, 0xf9ac, 0xf546, 0xf36f, 0xf61f, 0xfd1d,
    0x04b7, 0x097c, 0x0ad9, 0x09c8, 0x076f, 0x0501, 0x0420, 0x0337,
    0x0126, 0xfff1, 0x0099, 0x02ce, 0x050b, 0x059d, 0x040f, 0x00ce,
    0xfcf1, 0xfa22, 0xf9bf, 0xfbcd, 0xfe96, 0xff67, 0xfcd2, 0xf8db,
    0xf738, 0xf946, 0xfddd, 0x039e, 0x08ea, 0x0b72, 0x09ef, 0x069d,
    0x038c, 0x0149, 0x0096, 0x0055, 0xfeea, 0xfc2f, 0xf9f1, 0xf8ad,
    0xf7df, 0xf80e, 0xf967, 0xfb64, 0xfdbf, 0x00f1, 0x0496, 0x0740,
    0x0878, 0x07ed, 0x050a, 0x014f, 0xff2a, 0xfe99, 0xfdaa, 0xfc12,
    0xfae9, 0xfa50, 0xfab8, 0xfdfb, 0x039a, 0x074f, 0x070a, 0x0475,
    0x00e2, 0xfd53, 0xfbcd, 0xfc9d, 0xfd55, 0xfc7e, 0xfb39, 0xfb3a,
    0xfc15, 0xfda3, 0x0171, 0x07b5, 0x0dac, 0x0fd4, 0x0db5, 0x08e4,
    0x0204, 0xfb32, 0xf7c7, 0xf839, 0xf9b2, 0xf90e, 0xf79f, 0xf8de,
    0xfd1c, 0x01b7, 0x0543, 0x0740, 0x079a, 0x0686, 0x037f, 0xfe34,
    0xf841, 0xf4a3, 0xf47f, 0xf726, 0xfb9d, 0x0197, 0x0686, 0x089f,
    0x0913, 0x07a1, 0x0449, 0x00fe, 0xffcd, 0x00ff, 0x0216, 0x0207,
    0x010d, 0xfeca, 0xfb65, 0xf7d2, 0xf5a3, 0xf595, 0xf877, 0xfd90,
    0x041c, 0x0b1b, 0x0f04, 0x0d0c, 0x0652, 0xfe46, 0xf750, 0xf324,
    0xf34c, 0xf75d, 0xfdc5, 0x044b, 0x0812, 0x07d4, 0x0555, 0x02ca,
    0x0048, 0xfe49, 0xfd13, 0xfbeb, 0xfb62, 0xfcba, 0xfea5, 0xffc2,
    0x0116, 0x024b, 0x01f7, 0x0100, 0x01bd, 0x0487, 0x078a, 0x08ff,
    0x08aa, 0x0733, 0x041a, 0xff53, 0xfa43, 0xf609, 0xf2b0, 0xf0a6,
    0xf1f3, 0xf6b9, 0xfd0f, 0x03b7, 0x098f, 0x0d05, 0x0dc1, 0x0c8e,
    0x095f, 0x046f, 0xfef9, 0xfa52, 0xf6ab, 0xf3e4, 0xf32c, 0xf648,
    0xfd72, 0x05b7, 0x0c50, 0x0ee8, 0x0c4c, 0x0601, 0xfeaf, 0xf87e,
    0xf51f, 0xf6ad, 0xfb49, 0xfef1, 0x0169, 0x01c4, 0xff53, 0xfc26,
    0xfa95, 0xfccc, 0x00c4, 0x045c, 0x071d, 0x07e7, 0x05a8, 0x00cb,
    0xfbd2, 0xf8a1, 0xf857, 0xf9f3, 0xfcdd, 0x00ce, 0x0439, 0x069c,
    0x07d5, 0x0769, 0x0529, 0x0204, 0xfedb, 0xfcee, 0xfcad, 0xfc79,
    0xfb0c, 0xf90a, 0xf8da, 0xfa70, 0xfd0b, 0x00e7, 0x0512, 0x0792,
    0x07e0, 0x0698, 0x0471, 0x037f, 0x03f4, 0x045c, 0x040f, 0x02b0,
    0xff22, 0xf9f1, 0xf5af, 0xf44f, 0xf5c6, 0xf96c, 0xff43, 0x05cb,
    0x0b12, 0x0d82, 0x0bcc, 0x0615, 0xfee3, 0xf88e, 0xf38e, 0xf0ce,
    0xf0ee, 0xf3d6, 0xf922, 0xff36, 0x042a, 0x073f, 0x091b, 0x09af,
    0x07ca, 0x03f9, 0x0076, 0xfde8, 0xfc58, 0xfcb4, 0xfee1, 0x0141,
    0x0257, 0x01e4, 0x00a5, 0xff22, 0xfda6, 0xfddf, 0x00cd, 0x060b,
    0x0b50, 0x0d3e, 0x0ae8, 0x0598, 0xff19, 0xf923, 0xf5b5, 0xf5be,
    0xf6d5, 0xf7af, 0xfb0e, 0x0060, 0x040f, 0x05ef, 0x0726, 0x066a,
    0x02f0, 0xfe95, 0xfa56, 0xf635, 0xf320, 0xf1f9, 0xf333, 0xf741,
    0xfe4a, 0x0655, 0x0cc9, 0x0ffa, 0x0ee7, 0x0a38, 0x03cb, 0xfea6,
    0xfe22, 0x0118, 0x0394, 0x0414, 0x019b, 0xfb7f, 0xf4c6, 0xf1ea,
    0xf400, 0xf96b, 0x00df, 0x08d7, 0x0f9d, 0x1342, 0x103f, 0x0652,
    0xfa12, 0xf091, 0xec4c, 0xee30, 0xf54d, 0xfdee, 0x057d, 0x0b08,
    0x0d6d, 0x0bef, 0x07cc, 0x02b0, 0xfd2c, 0xf7ae, 0xf369, 0xf184,
    0xf270, 0xf5ed, 0xfbe2, 0x042d, 0x0b72, 0x0e11, 0x0c28, 0x07d0,
    0x0379, 0x0174, 0x01f9, 0x02cf, 0x02ef, 0x024a, 0x004b, 0xfd07,
    0xfa12, 0xf835, 0xf6ac, 0xf673, 0xf917, 0xfd6d, 0x01c5, 0x0623,
    0x098a, 0x0a01, 0x07f9, 0x058f, 0x029d, 0xfe70, 0xfb07, 0xf9d7,
    0xf963, 0xf91a, 0xfb2e, 0x006b, 0x0634, 0x097c, 0x09b9, 0x0766,
    0x0276, 0xfc2b, 0xf794, 0xf638, 0xf7ac, 0xfbba, 0x00c5, 0x0324,
    0x0060, 0xfa56, 0xf5c2, 0xf5c0, 0xfab4, 0x027e, 0x099b, 0x0d4d,
    0x0d43, 0x0ac0, 0x0603, 0xffaa, 0xf9e5, 0xf6a6, 0xf600, 0xf7c3,
    0xfc67, 0x024d, 0x06ff, 0x0a5a, 0x0bff, 0x0992, 0x040e, 0xff3a,
    0xfc42, 0xfaec, 0xfa32, 0xf87d, 0xf596, 0xf3d9, 0xf624, 0xfc50,
    0x040e, 0x0a87, 0x0d37, 0x0ab8, 0x0454, 0xfe22, 0xfb21, 0xfba4,
    0xfe25, 0x0128, 0x02cd, 0x01f8, 0x001d, 0xfe57, 0xfcf3, 0xfcad,
    0xfe7c, 0x01b1, 0x04d6, 0x06f0, 0x0719, 0x0582, 0x02a0, 0xfeea,
    0xfbb4, 0xf978, 0xf83e, 0xf7fc, 0xf93b, 0xfbe4, 0xfe23, 0x006a,
    0x049c, 0x09aa, 0x0c2f, 0x0b07, 0x06bd, 0x0027, 0xf9c6, 0xf659,
    0xf65e, 0xf835, 0xfaae, 0xfc98, 0xfd84, 0xfe2a, 0xffe8, 0x03e3,
    0x08d0, 0x0cc8, 0x0ecc, 0x0d97, 0x0892, 0x021f, 0xfd74, 0xfb3a,
    0xfa52, 0xf992, 0xf8d0, 0xf936, 0xfb35, 0xfdc2, 0xffdf, 0x0150,
    0x0253, 0x030b, 0x0331, 0x026c, 0x00b9, 0xfd5a, 0xf7f0, 0xf2a5,
    0xf0f8, 0xf49d, 0xfc35, 0x052b, 0x0bcc, 0x0d7a, 0x0b56, 0x07ad,
    0x0480, 0x034b, 0x03ab, 0x0436, 0x0397, 0x0087, 0xfaf9, 0xf4cd,
    0xf09c, 0xf048, 0xf4bf, 0xfcef, 0x0581, 0x0bb5, 0x0e4d, 0x0c73,
    0x0736, 0x0148, 0xfbdf, 0xf708, 0xf46b, 0xf600, 0xfb4e, 0x0218,
    0x077b, 0x0967, 0x0874, 0x0616, 0x02a1, 0xfe96, 0xfae8, 0xf7a4,
    0xf598, 0xf5f3, 0xf7fd, 0xfb5f, 0x0043, 0x0497, 0x05a7, 0x03b2,
    0x01ae, 0x014d, 0x020f, 0x0339, 0x04cb, 0x06b4, 0x07f3, 0x0768,
    0x04c0, 0x00cc, 0xfc13, 0xf776, 0xf4ee, 0xf56b, 0xf7d2, 0xfb5d,
    0x0035, 0x044f, 0x070d, 0x091c, 0x0944, 0x06d5, 0x03dd, 0x028e,
    0x00cd, 0xfd0f, 0xf8ee, 0xf6ef, 0xf850, 0xfc2e, 0x0145, 0x050e,
    0x0650, 0x05ac, 0x0395, 0x005a, 0xfcdd, 0xfabe, 0xfa47, 0xfab1,
    0xfad5, 0xf969, 0xf627, 0xf392, 0xf5cd, 0xfcb4, 0x04a5, 0x0c0a,
    0x117a, 0x1219, 0x0d20, 0x057f, 0xff2f, 0xfb9b, 0xf9e8, 0xfa06,
    0xfc24, 0xff0d, 0x022c, 0x058d, 0x07e7, 0x075d, 0x0424, 0xff9f,
    0xfb3e, 0xf972, 0xfad0, 0xfd0c, 0xfdb3, 0xfce1, 0xfbae, 0xfa41,
    0xf9da, 0xfc1e, 0x0068, 0x0459, 0x0601, 0x05fd, 0x05c7, 0x0605,
    0x0726, 0x08cf, 0x0901, 0x0537, 0xfe1d, 0xf69b, 0xf177, 0xf0b4,
    0xf483, 0xfb79, 0x036b, 0x09d3, 0x0d54, 0x0dd3, 0x0ac8, 0x04bc,
    0xfd17, 0xf591, 0xf05f, 0xeeed, 0xf122, 0xf590, 0xfb1f, 0x0066,
    0x04ce, 0x0923, 0x0d06, 0x0dd9, 0x0a52, 0x04d5, 0xffa2, 0xfadc,
    0xf719, 0xf6e8, 0xfab3, 0xfebb, 0xffc6, 0xfee9, 0xfe84, 0xfe7d,
    0xfecb, 0x00fb, 0x0553, 0x09e0, 0x0c92, 0x0d09, 0x0b6e, 0x0736,
    0x0129, 0xfb0b, 0xf637, 0xf348, 0xf264, 0xf48b, 0xfa6e, 0x0186,
    0x0666, 0x08fb, 0x0949, 0x0750, 0x0429, 0x0054, 0xfb79, 0xf5ee,
    0xf20c, 0xf0bb, 0xf1e5, 0xf5fe, 0xfc86, 0x0369, 0x090e, 0x0cdd,
    0x0d19, 0x0992, 0x050b, 0x027a, 0x03b7, 0x060b, 0x053f, 0x0172,
    0xfc5f, 0xf6c8, 0xf222, 0xf146, 0xf521, 0xfbe6, 0x054a, 0x1070,
    0x18e0, 0x1a29, 0x12cc, 0x04d1, 0xf4bf, 0xe930, 0xe637, 0xe9ce,
    0xf0ab, 0xf97f, 0x0380, 0x0b84, 0x0eb7, 0x0e8d, 0x0caf, 0x084c,
    0x01b5, 0xfbb5, 0xf771, 0xf483, 0xf384, 0xf482, 0xf672, 0xf9a5,
    0xfe37, 0x01c1, 0x027a, 0x02de, 0x053a, 0x0851, 0x0acb, 0x0c72,
    0x0cd5, 0x0a70, 0x04d0, 0xfd49, 0xf5a4, 0xefb2, 0xedb4, 0xf10e,
    0xf8af, 0x020c, 0x0aa5, 0x1012, 0x1085, 0x0d12, 0x083d, 0x0314,
    0xfdf1, 0xfa50, 0xf92d, 0xf95c, 0xfa3e, 0xfc29, 0xff3b, 0x034c,
    0x0691, 0x0699, 0x0356, 0xfe07, 0xf86d, 0xf455, 0xf2b4, 0xf45f,
    0xf954, 0x000c, 0x0505, 0x062f, 0x0466, 0x00c2, 0xfc9d, 0xfafc,
    0xfe04, 0x035e, 0x078d, 0x0a4a, 0x0c73, 0x0c97, 0x0946, 0x02c5,
    0xfa8f, 0xf3a1, 0xf018, 0xeffd, 0xf3c9, 0xfb15, 0x03a0, 0x0b2d,
    0x0f92, 0x1049, 0x0e5b, 0x09dd, 0x03ba, 0xfe47, 0xf98c, 0xf49b,
    0xf06d, 0xef5e, 0xf1d9, 0xf5fe, 0xfb72, 0x01d6, 0x06c2, 0x084b,
    0x0714, 0x04f3, 0x0295, 0xffec, 0xfe67, 0x002c, 0x0437, 0x0745,
    0x07a3, 0x057e, 0x0259, 0xff5d, 0xfd2b, 0xfd0b, 0xff3b, 0x031c,
    0x06d8, 0x07b2, 0x04ed, 0x003e, 0xfb36, 0xf5a5, 0xf13a, 0xf06e,
    0xf315, 0xf757, 0xfbf7, 0x00d0, 0x05b4, 0x0ae8, 0x0f08, 0x0f5f,
    0x0b42, 0x04b8, 0xfeaa, 0xf9ff, 0xf5dd, 0xf291, 0xf27c, 0xf5eb,
    0xfa04, 0xfdc7, 0x0260, 0x06ea, 0x08b9, 0x08ed, 0x09f8, 0x0a6a,
    0x07af, 0x0201, 0xfcf8, 0xf9f0, 0xf8e0, 0xfbb2, 0x01bc, 0x07a7,
    0x0aaf, 0x0a59, 0x0750, 0x025c, 0xfda8, 0xfb9f, 0xfbbf, 0xfaf2,
    0xf81f, 0xf5a4, 0xf523, 0xf63e, 0xf895, 0xfbd8, 0xff12, 0x0190,
    0x0363, 0x03b3, 0x02fc, 0x02b2, 0x02a6, 0x01fd, 0x0155, 0x01f2,
    0x04e0, 0x08c2, 0x0993, 0x0635, 0x00b2, 0xfa4b, 0xf3bb, 0xf03c,
    0xf2a4, 0xf9c0, 0x0292, 0x0ba4, 0x12b5, 0x13b1, 0x0ce3, 0x0075,
    0xf2f3, 0xea30, 0xea1e, 0xf187, 0xfc64, 0x0668, 0x0db2, 0x1179,
    0x1089, 0x0c17, 0x07bd, 0x03f9, 0xfe16, 0xf648, 0xef59, 0xeb5b,
    0xeb86, 0xefb2, 0xf6e0, 0x01de, 0x0d64, 0x13a5, 0x1245, 0x0b31,
    0x03e0, 0xfefa, 0xfd14, 0xfdf3, 0x0101, 0x0483, 0x057e, 0x032d,
    0xff1b, 0xfa73, 0xf57c, 0xf360, 0xf611, 0xfb62, 0x013a, 0x06f4,
    0x0af9, 0x0b39, 0x091b, 0x06a5, 0x0280, 0xfce4, 0xf9a3, 0xf97a,
    0xf952, 0xf8db, 0xfa7c, 0xfec6, 0x040c, 0x0833, 0x09de, 0x075a,
    0x0076, 0xf907, 0xf43f, 0xf232, 0xf376, 0xf8eb, 0xffa5, 0x0360,
    0x03be, 0x0228, 0xff6c, 0xfd97, 0xff05, 0x02c0, 0x05cd, 0x06fe,
    0x0676, 0x04ab, 0x025e, 0x0059, 0xfea1, 0xfd07, 0xfcc6, 0xfe0d,
    0x00a7, 0x0429, 0x0785, 0x0a1d, 0x0a76, 0x07d9, 0x0391, 0xfefa,
    0xfaf7, 0xf8b6, 0xf84a, 0xf858, 0xf816, 0xf851, 0xf9db, 0xfb9f,
    0xfc9a, 0xfd37, 0xfdcd, 0xfe7d, 0x0019, 0x0359, 0x077f, 0x0ac1,
    0x0ba2, 0x0a1c, 0x0678, 0x0124, 0xfb5c, 0xf66f, 0xf3ff, 0xf502,
    0xf90e, 0xfe4d, 0x0318, 0x0765, 0x0b2c, 0x0c4c, 0x097f, 0x03ec,
    0xfd91, 0xf850, 0xf57f, 0xf610, 0xf94d, 0xfd81, 0x012b, 0x03e6,
    0x055a, 0x0535, 0x044a, 0x0339, 0x00ee, 0xfcfa, 0xf94f, 0xf73a,
    0xf65f, 0xf613, 0xf719, 0xfa34, 0xfe52, 0x021c, 0x0554, 0x07a9,
    0x0877, 0x0828, 0x0765, 0x06e5, 0x06dc, 0x06c1, 0x05b3, 0x03c9,
    0x0201, 0x0058, 0xfe83, 0xfd13, 0xfd08, 0xfdad, 0xfd0e, 0xfbe3,
    0xfc5c, 0xfe1f, 0x0051, 0x023c, 0x0221, 0xfee1, 0xf9db, 0xf620,
    0xf591, 0xf8a3, 0xfd6f, 0x01bd, 0x0419, 0x0423, 0x0317, 0x0162,
    0x0079, 0x0270, 0x0601, 0x07fe, 0x07fe, 0x070e, 0x04e5, 0x002b,
    0xf9bc, 0xf4a1, 0xf254, 0xf2dc, 0xf6b0, 0xfdb0, 0x059f, 0x0c5f,
    0x110d, 0x1262, 0x0ecd, 0x06ae, 0xfbe6, 0xf18e, 0xebbc, 0xed2d,
    0xf424, 0xfc66, 0x041d, 0x0a61, 0x0d19, 0x0ab0, 0x04c7, 0xff24,
    0xfbdd, 0xfb88, 0xfcf5, 0xfdde, 0xfd74, 0xfd1d, 0xfdd4, 0xfd92,
    0xfc46, 0xfd8a, 0x00d9, 0x0245, 0x020e, 0x02f6, 0x0550, 0x0798,
    0x0996, 0x0ac2, 0x0963, 0x0498, 0xfcf4, 0xf4a0, 0xee1f, 0xebc8,
    0xef06, 0xf73f, 0x01fa, 0x0bdb, 0x11d6, 0x1218, 0x0d07, 0x055b,
    0xfe79, 0xf9c7, 0xf7c7, 0xf927, 0xfc8c, 0x002b, 0x0310, 0x0419,
    0x036c, 0x02b5, 0x0283, 0x0170, 0xfe92, 0xfadf, 0xf7c5, 0xf69d,
    0xf833, 0xfb7c, 0xff29, 0x0255, 0x03e5, 0x0367, 0x019b, 0xff91,
    0xfe1e, 0xfd9d, 0xfe7a, 0x0039, 0x027b, 0x055b, 0x078a, 0x07f4,
    0x0635, 0x0208, 0xfbd3, 0xf5ff, 0xf403, 0xf636, 0xfc48, 0x0597,
    0x0df6, 0x1205, 0x1129, 0x0b83, 0x0249, 0xf950, 0xf425, 0xf2d9,
    0xf4ed, 0xf97e, 0xfdc1, 0xfff5, 0xffd7, 0xfd1f, 0xf968, 0xf7d1,
    0xf965, 0xfce0, 0x0176, 0x067e, 0x0a76, 0x0cfb, 0x0d9c, 0x0c12,
    0x0918, 0x04ef, 0xfff7, 0xfaae, 0xf61a, 0xf312, 0xf291, 0xf4fd,
    0xf9e4, 0x00cd, 0x07f0, 0x0be3, 0x0b47, 0x06dc, 0xffb3, 0xf834,
    0xf321, 0xf278, 0xf626, 0xfc5a, 0x028e, 0x0749, 0x0a98, 0x0b68,
    0x08e5, 0x04d0, 0x0094, 0xfcdf, 0xfa9e, 0xf9b7, 0xf88d, 0xf775,
    0xf880, 0xfb58, 0xfe6c, 0x0131, 0x02ff, 0x039b, 0x0531, 0x076a,
    0x0880, 0x0920, 0x09ab, 0x08b4, 0x05e6, 0x0313, 0x004b, 0xfc77,
    0xf93f, 0xf860, 0xf920, 0xfa05, 0xfa22, 0xfa3f, 0xfb31, 0xfc8c,
    0xfdc2, 0xfe9b, 0xfef4, 0xfe93, 0xfe02, 0xff59, 0x0280, 0x053c,
    0x04d1, 0x007c, 0xfb87, 0xf92a, 0xf9a1, 0xfc8e, 0x0266, 0x08ab,
    0x0b63, 0x0ac9, 0x0a39, 0x097d, 0x06a1, 0x015e, 0xfbc3, 0xf7b0,
    0xf4b6, 0xf383, 0xf4c5, 0xf858, 0xfebe, 0x084e, 0x127f, 0x178e,
    0x1472, 0x09e5, 0xfa5e, 0xeaf7, 0xe2fc, 0xe667, 0xf1ed, 0x00d9,
    0x0ffa, 0x1a1a, 0x1a83, 0x1219, 0x048b, 0xf662, 0xed35, 0xeb3d,
    0xee48, 0xf38d, 0xfa6b, 0x01a9, 0x05a5, 0x04f6, 0x0400, 0x05a5,
    0x0647, 0x03af, 0x00bc, 0x00f3, 0x0496, 0x09f6, 0x0df8, 0x0d80,
    0x08b7, 0x0191, 0xf967, 0xf1df, 0xec71, 0xe9dd, 0xeab8, 0xefe6,
    0xf89b, 0x019e, 0x084b, 0x0b64, 0x0b51, 0x08ff, 0x05f7, 0x02ee,
    0xffc9, 0xfe5e, 0xff90, 0x018e, 0x01d2, 0xffa4, 0xfd85, 0xfdac,
    0xff40, 0x0075, 0x002d, 0xfde9, 0xfb3e, 0xfb35, 0xfe26, 0x01e5,
    0x0635, 0x0afa, 0x0cca, 0x097a, 0x03d4, 0xff18, 0xfb9a, 0xfad8,
    0xfe16, 0x016c, 0x01f6, 0x0187, 0x010c, 0xffa5, 0xfd27, 0xfae8,
    0xfb16, 0xfdbb, 0x0037, 0x0221, 0x04cf, 0x06a5, 0x062f, 0x04c0,
    0x02d3, 0xff67, 0xfba0, 0xfa3a, 0xfaf9, 0xfcb1, 0xfe7a, 0xfe79,
    0xfc1a, 0xf94a, 0xf749, 0xf59b, 0xf56f, 0xf879, 0xfd6a, 0x013e,
    0x036f, 0x05ea, 0x0926, 0x0b0f, 0x0b67, 0x0bad, 0x0ab0, 0x0681,
    0xffac, 0xf907, 0xf44c, 0xf1d6, 0xf28a, 0xf791, 0x00d2, 0x0b11,
    0x1165, 0x1133, 0x0b2a, 0x0144, 0xf6b4, 0xef43, 0xed7a, 0xf167,
    0xf92a, 0x0206, 0x094a, 0x0dff, 0x0f5e, 0x0d3b, 0x08e7, 0x0337,
    0xfcc1, 0xf837, 0xf7e1, 0xf9e5, 0xfc5c, 0xfff0, 0x045d, 0x070d,
    0x05c3, 0x01dc, 0xfe93, 0xfd97, 0xff80, 0x0445, 0x0a6f, 0x0df8,
    0x0bf9, 0x0601, 0xffa3, 0xfb07, 0xf805, 0xf600, 0xf48e, 0xf358,
    0xf426, 0xf82d, 0xfcfa, 0x0031, 0x012e, 0xff9e, 0xfc4e, 0xf95c,
    0xf81c, 0xf8eb, 0xfb3f, 0xfcda, 0xfcff, 0xfd03, 0xfd87, 0xfe34,
    0xffab, 0x026c, 0x03b3, 0x01ca, 0xff49, 0xfeb9, 0x0167, 0x0845,
    0x1137, 0x17d5, 0x1818, 0x104f, 0x0240, 0xf37c, 0xea5f, 0xe985,
    0xefa9, 0xfa93, 0x07a5, 0x1268, 0x15f3, 0x1074, 0x052f, 0xf851,
    0xec7f, 0xe614, 0xe8ce, 0xf29e, 0xff50, 0x0bcd, 0x140a, 0x14c6,
    0x0f9f, 0x0717, 0xfbec, 0xf1da, 0xed2d, 0xeec0, 0xf4c5, 0xfbd5,
    0x0091, 0x0301, 0x046c, 0x03f6, 0x022c, 0x012a, 0x01a3, 0x039d,
    0x06e8, 0x0a18, 0x0cea, 0x0f9c, 0x1035, 0x0cc6, 0x065d, 0xff53,
    0xf795, 0xefb3, 0xebde, 0xee7b, 0xf4ca, 0xfc3a, 0x0310, 0x0676,
    0x0581, 0x023f, 0xff85, 0xfe2b, 0xfe5c, 0x003c, 0x024b, 0x0181,
    0xfed5, 0xfee9, 0x023a, 0x056a, 0x06e3, 0x067e, 0x0334, 0xfdd2,
    0xf92c, 0xf795, 0xf997, 0xff61, 0x0674, 0x09d5, 0x072c, 0xffa5,
    0xf5e0, 0xedfa, 0xec8a, 0xf2a7, 0xfcec, 0x0677, 0x0cca, 0x0fd0,
    0x0f50, 0x0acf, 0x04c7, 0xffc5, 0xfc10, 0xfa39, 0xfbc1, 0x004f,
    0x0514, 0x0878, 0x0a78, 0x0a8f, 0x0761, 0x01ac, 0xfc50, 0xf922,
    0xf7c1, 0xf72e, 0xf67c, 0xf4f7, 0xf39d, 0xf454, 0xf7b5, 0xfcba,
    0x015f, 0x03de, 0x03e5, 0x0258, 0x008a, 0xfffe, 0x01b0, 0x05a0,
    0x0ac2, 0x0dfe, 0x0caf, 0x07b7, 0x0147, 0xfb2e, 0xf670, 0xf433,
    0xf628, 0xfb5a, 0x00cd, 0x04bf, 0x064d, 0x0446, 0xfef4, 0xf977,
    0xf685, 0xf630, 0xf827, 0xfc29, 0x006a, 0x025d, 0x02a0, 0x0370,
    0x04f8, 0x062d, 0x0686, 0x060d, 0x0457, 0x012d, 0xfda0, 0xfb23,
    0xf94c, 0xf7a9, 0xf722, 0xf8c6, 0xfcff, 0x0249, 0x0701, 0x0b4d,
    0x0fa7, 0x1369, 0x150a, 0x1377, 0x0e7d, 0x06b5, 0xfdc1, 0xf5d3,
    0xf0d6, 0xee32, 0xecb7, 0xee23, 0xf31f, 0xf943, 0xff05, 0x0423,
    0x0706, 0x06cd, 0x065b, 0x05de, 0x0318, 0xfdfe, 0xf6d0, 0xef5f,
    0xebb9, 0xefae, 0xf9e1, 0x055a, 0x0e94, 0x1290, 0x0fe2, 0x0997,
    0x0411, 0x00ee, 0x0031, 0x0090, 0x0189, 0x02ab, 0x01ef, 0xfec0,
    0xfbe7, 0xfbff, 0xfe3e, 0x0175, 0x04c5, 0x067f, 0x066c, 0x0498,
    0x0026, 0xfa81, 0xf68f, 0xf4a7, 0xf4c0, 0xf8a2, 0x002f, 0x07af,
    0x0b86, 0x0aa0, 0x0547, 0xfe26, 0xf8da, 0xf66c, 0xf5df, 0xf5e2,
    0xf62a, 0xf6dc, 0xf7db, 0xf9cd, 0xfe77, 0x056c, 0x0a37, 0x0a15,
    0x079a, 0x061c, 0x0689, 0x08e9, 0x0ca2, 0x0f9e, 0x0fd1, 0x0c32,
    0x04df, 0xfc21, 0xf4aa, 0xeefc, 0xeaf1, 0xe9f6, 0xece5, 0xf258,
    0xf938, 0x00f4, 0x08a9, 0x0fdc, 0x1540, 0x164a, 0x11ee, 0x09df,
    0x0043, 0xf709, 0xf010, 0xecb6, 0xede5, 0xf2f8, 0xf944, 0xfef1,
    0x0360, 0x0552, 0x03c9, 0x006c, 0xfe29, 0xfe34, 0x00c1, 0x03f4,
    0x0465, 0x00d0, 0xfac0, 0xf5ff, 0xf61e, 0xfc39, 0x0666, 0x0ffa,
    0x1520, 0x1405, 0x0da0, 0x043d, 0xf970, 0xf0ea, 0xee8f, 0xf1f3,
    0xf888, 0x0042, 0x06da, 0x0ad7, 0x0bb3, 0x0a44, 0x0829, 0x05ce,
    0x0398, 0x0175, 0xff4c, 0xfd15, 0xfadc, 0xf914, 0xf7d9, 0xf795,
    0xf828, 0xf98b, 0xfb86, 0xfdb9, 0x0058, 0x030a, 0x05ea, 0x0933,
    0x0c2d, 0x0dde, 0x0e28, 0x0d0c, 0x09ed, 0x048f, 0xfe5b, 0xf8a7,
    0xf38a, 0xef8b, 0xee38, 0xf10c, 0xf7c2, 0x00db, 0x0994, 0x0e7b,
    0x0dbd, 0x06f0, 0xfbd5, 0xf0eb, 0xe9fe, 0xe8b1, 0xed71, 0xf68d,
    0x004b, 0x0816, 0x0d8c, 0x0f16, 0x0c81, 0x0863, 0x043d, 0x0014,
    0xfc5e, 0xf9e8, 0xf813, 0xf661, 0xf5a0, 0xf704, 0xfb1b, 0x0103,
    0x0680, 0x0a0b, 0x0c7a, 0x0e6b, 0x0ea7, 0x0c18, 0x07c6, 0x040b,
    0x01e6, 0x00d0, 0xff4e, 0xfc0a, 0xf7b4, 0xf584, 0xf778, 0xfbcd,
    0x0006, 0x0221, 0x013d, 0xff47, 0xfe3e, 0xfe36, 0xfe64, 0xfda3,
    0xfc4d, 0xfaf7, 0xf992, 0xf97f, 0xfbe3, 0xff78, 0x0287, 0x04de,
    0x06dd, 0x0806, 0x07d3, 0x07f5, 0x0888, 0x07aa, 0x0548, 0x019b,
    0xfd20, 0xf93b, 0xf71e, 0xf702, 0xf998, 0xfe8f, 0x02b0, 0x0409,
    0x03fe, 0x037b, 0x025c, 0x00be, 0xfeb7, 0xfc30, 0xf9cd, 0xf87b,
    0xf8e8, 0xfb65, 0xfe73, 0x00db, 0x0257, 0x02ee, 0x024e, 0x0114,
    0x008b, 0x0056, 0x00d2, 0x0207, 0x02c8, 0x01cc, 0xff3f, 0xfc8f,
    0xfadb, 0xfb08, 0xfcb0, 0xff18, 0x025f, 0x0524, 0x062b, 0x0676,
    0x0752, 0x07ff, 0x074b, 0x0593, 0x02b8, 0xffd2, 0xfdfb, 0xfc56,
    0xfa90, 0xfae3, 0xfe07, 0x018a, 0x0463, 0x06e0, 0x07c2, 0x05c9,
    0x0236, 0xfd2a, 0xf6bc, 0xf1f3, 0xf131, 0xf461, 0xfafd, 0x0316,
    0x0911, 0x0a9f, 0x07f5, 0x0395, 0xfffe, 0xfe1c, 0xfd01, 0xfb9f,
    0xfa5c, 0xf9ca, 0xfa5a, 0xfbf2, 0xfdda, 0x001b, 0x02fe, 0x0563,
    0x05c9, 0x0387, 0xffca, 0xfc89, 0xfae7, 0xfc27, 0xffcc, 0x03f7,
    0x075b, 0x0985, 0x0a21, 0x0761, 0x00e3, 0xf99f, 0xf516, 0xf4aa,
    0xf7d9, 0xfd30, 0x0271, 0x05cb, 0x06fa, 0x0715, 0x061d, 0x0393,
    0x0001, 0xfbcd, 0xf827, 0xf63e, 0xf647, 0xf7da, 0xfabd, 0xfe78,
    0x00c8, 0x00fa, 0x00d4, 0x00d5, 0x0016, 0xffbf, 0x0144, 0x03e4,
    0x06ea, 0x0a06, 0x0b8d, 0x0a67, 0x0702, 0x0213, 0xfc26, 0xf66d,
    0xf330, 0xf2c9, 0xf3dc, 0xf625, 0xfa54, 0xff5b, 0x03d3, 0x07b0,
    0x0a3c, 0x0a4e, 0x07d3, 0x0370, 0xfe77, 0xfb4c, 0xfb11, 0xfd11,
    0x0023, 0x038b, 0x0696, 0x0866, 0x0945, 0x0876, 0x048d, 0xfe0f,
    0xf842, 0xf58d, 0xf572, 0xf7a0, 0xfbd0, 0x0056, 0x02eb, 0x0475,
    0x0605, 0x0700, 0x06f9, 0x05f3, 0x0405, 0x0138, 0xffb3, 0x002d,
    0x00c4, 0x007a, 0xffc3, 0xff08, 0xfd7e, 0xfbdf, 0xfa9d, 0xf7af,
    0xf437, 0xf3d4, 0xf696, 0xfa35, 0xfdb2, 0x0146, 0x0448, 0x059e,
    0x060b, 0x05a0, 0x02fb, 0xfec1, 0xfbf3, 0xfb84, 0xfc91, 0xfe85,
    0x0116, 0x04ca, 0x099a, 0x0e5f, 0x113e, 0x10ce, 0x0c96, 0x0584,
    0xfca2, 0xf451, 0xefa5, 0xeeee, 0xf024, 0xf32e, 0xf965, 0x009e,
    0x0558, 0x08e2, 0x0cfc, 0x0de8, 0x09ca, 0x02e5, 0xfb4a, 0xf4ff,
    0xf3a0, 0xf77e, 0xfcb0, 0x00c3, 0x03ad, 0x05b4, 0x05b9, 0x0362,
    0x0049, 0xfdea, 0xfbe1, 0xfa11, 0xf9be, 0xfb86, 0xfea9, 0x01e8,
    0x0411, 0x04d6, 0x050f, 0x0400, 0xffd0, 0xf9a7, 0xf62a, 0xf86e,
    0xfe72, 0x04f6, 0x0a2d, 0x0bcb, 0x0943, 0x0463, 0xff5c, 0xfb22,
    0xf7f1, 0xf6dd, 0xf86c, 0xfc08, 0x0005, 0x02ed, 0x04a4, 0x04a0,
    0x037b, 0x0335, 0x0336, 0x020a, 0x007b, 0xffac, 0xfe97, 0xfc80,
    0xfb0b, 0xfb8b, 0xfe48, 0x02d6, 0x06b2, 0x0721, 0x04ad, 0x013b,
    0xfe2e, 0xfc2e, 0xfc41, 0xff3a, 0x032d, 0x0591, 0x04e0, 0x0137,
    0xfbe6, 0xf716, 0xf544, 0xf6fa, 0xfa06, 0xfcfa, 0x009e, 0x0460,
    0x06bf, 0x06e7, 0x0469, 0x0000, 0xfc01, 0xfb1a, 0xfe0c, 0x0354,
    0x08b0, 0x0c1e, 0x0bdd, 0x081b, 0x02bb, 0xfd7e, 0xf9ad, 0xf816,
    0xf82a, 0xf7bc, 0xf5a7, 0xf3dc, 0xf4dc, 0xf7e2, 0xfbb0, 0x00ce,
    0x0660, 0x0a55, 0x0bc4, 0x0b9d, 0x0a1a, 0x0736, 0x0476, 0x0231,
    0x00cc, 0x0133, 0x02c4, 0x03e2, 0x028b, 0xfeac, 0xf9e8, 0xf619,
    0xf448, 0xf536, 0xf91c, 0xfdff, 0x02a1, 0x06a5, 0x0895, 0x06ed,
    0x02f8, 0xfebd, 0xfab4, 0xf851, 0xf8c5, 0xfa75, 0xfc09, 0xfef1,
    0x0304, 0x059d, 0x05ec, 0x0476, 0x0161, 0xfd08, 0xf89f, 0xf5cc,
    0xf493, 0xf563, 0xf95a, 0xffc5, 0x06ac, 0x0c8b, 0x1123, 0x12de,
    0x0fad, 0x090b, 0x023d, 0xfcc7, 0xfa40, 0xfbfb, 0xffcf, 0x0236,
    0x021a, 0x0076, 0xfd5b, 0xf9c2, 0xf6fd, 0xf505, 0xf4ef, 0xf763,
    0xfc06, 0x0116, 0x0449, 0x0556, 0x051b, 0x044a, 0x02ee, 0x0228,
    0x0260, 0x01d0, 0xff8b, 0xfd57, 0xfd42, 0xfe44, 0x004d, 0x0432,
    0x07f9, 0x098d, 0x09a8, 0x0867, 0x04ba, 0xff22, 0xf8f1, 0xf4b1,
    0xf2f7, 0xf1f6, 0xf195, 0xf422, 0xf9f0, 0x0129, 0x0921, 0x1138,
    0x15eb, 0x13d3, 0x0a6e, 0xfc69, 0xf032, 0xeb59, 0xeddf, 0xf3da,
    0xfb85, 0x0385, 0x0921, 0x0b88, 0x0ad1, 0x0714, 0x01b7, 0xfd28,
    0xfa4d, 0xf90b, 0xf8c7, 0xf9ac, 0xfc59, 0xff4b, 0x01d7, 0x05a1,
    0x096b, 0x094e, 0x0567, 0x0129, 0xfef4, 0xff06, 0x008a, 0x0224,
    0x0272, 0x0152, 0xff18, 0xfc30, 0xfa90, 0xfb02, 0xfc3c, 0xfe98,
    0x02cd, 0x06c7, 0x0794, 0x0553, 0x013b, 0xfccb, 0xfab5, 0xfbc8,
    0xfdb3, 0xfed6, 0x0032, 0x01ec, 0x01eb, 0xff7b, 0xfcca, 0xfc7e,
    0xff09, 0x0246, 0x046c, 0x044e, 0x01d9, 0xfefd, 0xfdc5, 0xfdbe,
    0xfe01, 0xff56, 0x010a, 0x0166, 0x0005, 0xfd9b, 0xfb54, 0xfa35,
    0xfb3a, 0xfd8b, 0xfef7, 0xffc7, 0x007d, 0x00dc, 0x0002, 0xfcad,
    0xf94a, 0xf877, 0xf9f8, 0xfe78, 0x06bc, 0x0fb4, 0x155b, 0x164d,
    0x12e6, 0x0bde, 0x0273, 0xfa56, 0xf650, 0xf682, 0xf8aa, 0xfa07,
    0xf9df, 0xf8ca, 0xf7a5, 0xf707, 0xf843, 0xfc16, 0x01ef, 0x07ee,
    0x0ac4, 0x09a8, 0x06cf, 0x03d7, 0x0113, 0xff32, 0xff17, 0xfede,
    0xfe42, 0xffdf, 0x0102, 0xff58, 0xfda1, 0xfcde, 0xfbb9, 0xfa76,
    0xfacf, 0xfbd0, 0xfc5b, 0xfd78, 0xfee4, 0xff52, 0xfed8, 0xfeb2,
    0xff23, 0x0083, 0x03a7, 0x0752, 0x0937, 0x092e, 0x0825, 0x0526,
    0x002f, 0xfc11, 0xfa63, 0xf8fe, 0xf6a1, 0xf524, 0xf5e0, 0xf8d4,
    0xfd15, 0x01e8, 0x0713, 0x0c72, 0x10b1, 0x12d0, 0x11e2, 0x0cb0,
    0x04b3, 0xfc8a, 0xf613, 0xf25f, 0xf2ac, 0xf71a, 0xfd8f, 0x0267,
    0x029e, 0xfff1, 0xfda1, 0xfbc7, 0xfa4f, 0xfab4, 0xfd22, 0xffa8,
    0x00df, 0x00da, 0xff73, 0xfc3d, 0xf81f, 0xf571, 0xf5c8, 0xf997,
    0xffd9, 0x0694, 0x0cb4, 0x108d, 0x1107, 0x0e9e, 0x0ab6, 0x0744,
    0x0532, 0x022a, 0xfd29, 0xf8fb, 0xf6f4, 0xf5a1, 0xf558, 0xf6e8,
    0xf8bf, 0xfab8, 0xff1a, 0x0629, 0x0c1c, 0x0d6b, 0x0873, 0xff49,
    0xf6da, 0xf347, 0xf59f, 0xfc4c, 0x03e7, 0x0877, 0x08f5, 0x064c,
    0x024b, 0xff05, 0xfda0, 0xfd5f, 0xfcec, 0xfad6, 0xf696, 0xf2cd,
    0xf316, 0xf725, 0xfcba, 0x03a2, 0x09a3, 0x0b7a, 0x0a0e, 0x0936,
    0x0a5a, 0x0b60, 0x0add, 0x0931, 0x05c9, 0x00a1, 0xfb23, 0xf654,
    0xf28a, 0xf036, 0xf0b9, 0xf4c8, 0xfbb1, 0x0304, 0x0876, 0x0b3e,
    0x0ada, 0x085b, 0x05b7, 0x0341, 0x001b, 0xfdb4, 0xfd84, 0xfd6b,
    0xfb98, 0xf99f, 0xf994, 0xfc3a, 0x00c3, 0x0514, 0x0796, 0x0740,
    0x0472, 0x006f, 0xfbcd, 0xf7e8, 0xf734, 0xf9b2, 0xfd3c, 0xffc6,
    0xff9b, 0xfc8e, 0xf978, 0xfa6d, 0xff07, 0x02d4, 0x03dd, 0x0369,
    0x02e2, 0x02c7, 0x02b2, 0x0225, 0x0009, 0xfc92, 0xf9db, 0xf909,
    0xfb4a, 0xfff1, 0x0554, 0x09d4, 0x0b54, 0x09a4, 0x0572, 0x00a1,
    0xfd5c, 0xfbfb, 0xfa20, 0xf6be, 0xf402, 0xf388, 0xf5c5, 0xfad7,
    0x0230, 0x08ba, 0x0bba, 0x0b8f, 0x0968, 0x0693, 0x04f0, 0x04ed,
    0x050a, 0x044f, 0x0200, 0xfe75, 0xfbbb, 0xfa72, 0xfa60, 0xfc5a,
    0xffcb, 0x0224, 0x02a5, 0x0369, 0x04bd, 0x04b1, 0x02a4, 0xff5f,
    0xfc21, 0xf9f7, 0xf9f0, 0xfb7c, 0xfdb0, 0x0082, 0x0363, 0x05a4,
    0x06db, 0x0662, 0x0349, 0xfdc3, 0xf7c6, 0xf41a, 0xf30f, 0xf3c2,
    0xf608, 0xfa36, 0xfefc, 0x0256, 0x04b2, 0x0708, 0x0904, 0x0a57,
    0x0b83, 0x0c3b, 0x0b3d, 0x0899, 0x0568, 0x0109, 0xfae2, 0xf47f,
    0xefef, 0xee48, 0xf077, 0xf6d5, 0xfe23, 0x039e, 0x07b3, 0x0996,
    0x0838, 0x057a, 0x037b, 0x012c, 0xfe3a, 0xfbd2, 0xf9f0, 0xf8db,
    0xf90e, 0xfb26, 0xfe95, 0x0211, 0x0551, 0x079f, 0x09af, 0x0bb0,
    0x0cc1, 0x0cfc, 0x0c7c, 0x0abe, 0x07d0, 0x02c4, 0xfb3a, 0xf4e5,
    0xf240, 0xf2ac, 0xf51f, 0xf9d9, 0xff59, 0x034e, 0x05b7, 0x07bd,
    0x09d1, 0x0953, 0x02e3, 0xf830, 0xef90, 0xed29, 0xf02c, 0xf6a6,
    0xfe64, 0x03dd, 0x05d4, 0x0461, 0x0030, 0xfbce, 0xf99e, 0xf977,
    0xf9f7, 0xfa42, 0xf992, 0xf906, 0xfa97, 0xfdd3, 0x0183, 0x06a2,
    0x0c0b, 0x0dcf, 0x0b9a, 0x0956, 0x095b, 0x0a75, 0x0a84, 0x07e4,
    0x0236, 0xfa03, 0xf145, 0xebf6, 0xece2, 0xf28a, 0xf97b, 0xffe9,
    0x053f, 0x08be, 0x0abb, 0x0bb6, 0x0a9e, 0x087a, 0x079d, 0x072c,
    0x04d8, 0x019f, 0xffbc, 0xfeca, 0xfcee, 0xf8df, 0xf443, 0xf241,
    0xf473, 0xfa5d, 0x01cf, 0x0749, 0x08db, 0x07e8, 0x056c, 0x019d,
    0xfe4f, 0xfd8c, 0xfe88, 0xff5a, 0xffb7, 0xffe5, 0x00a8, 0x03af,
    0x08ec, 0x0bbb, 0x0863, 0x00d6, 0xf876, 0xf187, 0xedad, 0xed50,
    0xef49, 0xf2b2, 0xf830, 0xff6a, 0x06b3, 0x0d09, 0x1111, 0x11e3,
    0x0f4f, 0x0953, 0x01c9, 0xfbb0, 0xf8cc, 0xf7eb, 0xf77e, 0xf70b,
    0xf6ae, 0xf717, 0xf820, 0xf9ba, 0xfcb4, 0x01fc, 0x0848, 0x0d24,
    0x0f57, 0x0ef3, 0x0d42, 0x0b6e, 0x090a, 0x0608, 0x036d, 0x00a8,
    0xfd3b, 0xf95f, 0xf610, 0xf4fb, 0xf69f, 0xf9c3, 0xfce7, 0xffc8,
    0x01fb, 0x034b, 0x033a, 0x0142, 0xfd74, 0xf8a6, 0xf4e3, 0xf3e7,
    0xf678, 0xfb5a, 0xfff6, 0x0344, 0x068e, 0x0865, 0x05ea, 0x00dd,
    0xfd69, 0xfc81, 0xfcd7, 0xfe38, 0xffa2, 0xff42, 0xfe0d, 0xfeef,
    0x02f8, 0x080f, 0x0c94, 0x10f1, 0x13d5, 0x13b3, 0x0ea9, 0x049b,
    0xf9a1, 0xf20c, 0xf14b, 0xf7e7, 0x0229, 0x0abf, 0x0d4f, 0x0a7a,
    0x05d3, 0x00e5, 0xfc01, 0xf75e, 0xf3a0, 0xf1dc, 0xf350, 0xf5f1,
    0xf74f, 0xf876, 0xfa16, 0xfb0c, 0xf931, 0xf413, 0xedf8, 0xec8d,
    0xf3fb, 0x02d4, 0x1379, 0x1f8e, 0x2484, 0x22ae, 0x1b6f, 0x0e5c,
    0xfdd9, 0xef5b, 0xe673, 0xe3b2, 0xe616, 0xee1d, 0xf95d, 0x04e2,
    0x0ea0, 0x135c, 0x11a4, 0x0afd, 0x01fd, 0xfa56, 0xf7a3, 0xf9ec,
    0xfd74, 0xfff9, 0x01db, 0x0205, 0xfec8, 0xf8c0, 0xf3b3, 0xf3a5,
    0xf8e8, 0xff2b, 0x029c, 0x0210, 0xff9f, 0xfe9a, 0xfe84, 0xfd84,
    0xfc0b, 0xfcf0, 0xff90, 0x00c5, 0x0170, 0x051f, 0x0cbc, 0x1572,
    0x1beb, 0x1c4e, 0x144d, 0x0550, 0xf451, 0xe90e, 0xe75c, 0xec16,
    0xf39e, 0xfbd3, 0x0247, 0x055d, 0x0557, 0x02f7, 0xff04, 0xfd30,
    0x009a, 0x070f, 0x0ba0, 0x0aee, 0x049d, 0xfa4c, 0xef5d, 0xe7c4,
    0xe731, 0xeff6, 0xfebc, 0x0d0d, 0x15ad, 0x15be, 0x0f37, 0x065b,
    0xff13, 0xfaca, 0xf912, 0xf92a, 0xf934, 0xf8a2, 0xf764, 0xf5e2,
    0xf7af, 0xff0c, 0x090f, 0x0f00, 0x0d4d, 0x065a, 0xfecd, 0xfb2c,
    0xfc2c, 0x0000, 0x047c, 0x06db, 0x0485, 0xfe9a, 0xf927, 0xf6b5,
    0xf91a, 0x010d, 0x0b22, 0x1199, 0x10d7, 0x09dc, 0xffff, 0xf62c,
    0xeed2, 0xead4, 0xeaf6, 0xee51, 0xf299, 0xf78b, 0xfd7f, 0x037f,
    0x08a2, 0x0d1e, 0x10bb, 0x12aa, 0x12d6, 0x1112, 0x0c65, 0x06b9,
    0x0237, 0xfe24, 0xfa42, 0xf795, 0xf631, 0xf544, 0xf5e4, 0xf8db,
    0xfdf0, 0x045c, 0x0aab, 0x0f77, 0x1054, 0x0b51, 0x0248, 0xf85d,
    0xeedb, 0xe8a1, 0xe965, 0xf09e, 0xfa5a, 0x051a, 0x1000, 0x1731,
    0x163e, 0x0cd3, 0xff15, 0xf151, 0xe83a, 0xe67f, 0xeaff, 0xf2fb,
    0xfb97, 0x0220, 0x05df, 0x08cc, 0x0c40, 0x0f27, 0x0f5b, 0x0c02,
    0x0636, 0x0070, 0xfd3e, 0xfdc6, 0x0087, 0x0361, 0x04fa, 0x0414,
    0xffdc, 0xf9e0, 0xf56e, 0xf364, 0xf3ec, 0xf7b0, 0xfd70, 0x035c,
    0x08bb, 0x0c1b, 0x0b6c, 0x0694, 0xfe99, 0xf593, 0xee5f, 0xeb1f,
    0xed89, 0xf4f3, 0xfdca, 0x04ce, 0x0a57, 0x100a, 0x15f9, 0x1a8c,
    0x1afd, 0x15bd, 0x0aa8, 0xfbae, 0xec97, 0xe1d0, 0xe116, 0xebf3,
    0xfc71, 0x0ab9, 0x1364, 0x1641, 0x13e0, 0x0eae, 0x0ace, 0x08e7,
    0x04d3, 0xfc2b, 0xf147, 0xe985, 0xe955, 0xf0c0, 0xfb9b, 0x05a0,
    0x0bbf, 0x0b62, 0x048b, 0xfacc, 0xf253, 0xee2d, 0xef71, 0xf4b6,
    0xfb9f, 0x0254, 0x07b7, 0x0a71, 0x0920, 0x0484, 0x0005, 0xfd82,
    0xfc17, 0xfc05, 0xff77, 0x0729, 0x0fb5, 0x13f0, 0x10fb, 0x088c,
    0xff61, 0xf910, 0xf74d, 0xf9b3, 0xfc89, 0xfc02, 0xf8c0, 0xf7a8,
    0xfbb6, 0x0388, 0x0c86, 0x1239, 0x10e6, 0x0968, 0xff1b, 0xf42f,
    0xead7, 0xe716, 0xeb15, 0xf391, 0xfbfe, 0x0271, 0x0686, 0x08c1,
    0x0947, 0x0753, 0x027d, 0xfc9e, 0xf871, 0xf77f, 0xf93b, 0xfbd0,
    0xfe94, 0x007a, 0x01ea, 0x03ed, 0x050b, 0x05ba, 0x066b, 0x05fd,
    0x03ca, 0x000e, 0xfc6c, 0xfb72, 0xff0a, 0x04d0, 0x082d, 0x0625,
    0xfeb8, 0xf603, 0xf1d1, 0xf4b4, 0xfd13, 0x0702, 0x0ed4, 0x1299,
    0x10fd, 0x0a9f, 0x011d, 0xf6f7, 0xef5f, 0xec50, 0xedf3, 0xf2f1,
    0xfa9c, 0x0381, 0x0a63, 0x0cf8, 0x0b49, 0x06af, 0x0177, 0xff68,
    0x031c, 0x099c, 0x0dec, 0x0e30, 0x0a93, 0x036f, 0xfa05, 0xf21d,
    0xee93, 0xef55, 0xf3c9, 0xfb06, 0x01b6, 0x03d8, 0x0335, 0x03ba,
    0x041b, 0x0284, 0xffc5, 0xfb92, 0xf5e6, 0xf1c3, 0xf26a, 0xf7bf,
    0xff75, 0x06bc, 0x0ac8, 0x0a5f, 0x05e5, 0xfed2, 0xf737, 0xf19f,
    0xf138, 0xf648, 0xfd5f, 0x034b, 0x067e, 0x06c1, 0x0495, 0x023c,
    0x0237, 0x0499, 0x0998, 0x118a, 0x1991, 0x1be7, 0x1551, 0x088b,
    0xfa2f, 0xeec2, 0xeb30, 0xf109, 0xfaf4, 0x0169, 0x0330, 0x0305,
    0x01a2, 0x0031, 0x00a7, 0x01c2, 0x00b0, 0xfe5a, 0xfc47, 0xf92c,
    0xf5c6, 0xf58e, 0xf910, 0xfced, 0xff77, 0x012c, 0x012b, 0xff3e,
    0xfecb, 0x027c, 0x0881, 0x0e75, 0x11a6, 0x0ed3, 0x0491, 0xf5eb,
    0xe9a3, 0xe3fa, 0xe59c, 0xee56, 0xfcc9, 0x0b11, 0x143c, 0x17b2,
    0x15fb, 0x104b, 0x0877, 0x009d, 0xf90e, 0xf309, 0xf153, 0xf336,
    0xf6a6, 0xfb0e, 0xff02, 0x0005, 0xfde5, 0xfba8, 0xfbf9, 0xfeac,
    0x0166, 0x0209, 0x002d, 0xfd27, 0xfba7, 0xfd87, 0x017e, 0x04f4,
    0x0841, 0x0ab0, 0x094b, 0x051c, 0x027d, 0x0381, 0x05ab, 0x075b,
    0x08b4, 0x08e1, 0x0776, 0x057c, 0x039d, 0x0115, 0xfd70, 0xf972,
    0xf69d, 0xf6e9, 0xfb88, 0x02cb, 0x08b9, 0x09d3, 0x05fa, 0xff37,
    0xf758, 0xf129, 0xf001, 0xf462, 0xfb9a, 0x01a6, 0x0340, 0xffd7,
    0xfa84, 0xf735, 0xf6d5, 0xf8af, 0xfc20, 0x0038, 0x033d, 0x0450,
    0x0378, 0x007b, 0xfcea, 0xfb4d, 0xfc65, 0xfe41, 0xff8a, 0x011e,
    0x034c, 0x057a, 0x0769, 0x07f4, 0x0589, 0x016f, 0xfe31, 0xfc26,
    0xf9ce, 0xf749, 0xf6e7, 0xf956, 0xfd41, 0x0258, 0x091b, 0x0fd4,
    0x1417, 0x1515, 0x115b, 0x07bd, 0xfa4c, 0xedbf, 0xe6c7, 0xe7d5,
    0xf030, 0xfb4d, 0x0464, 0x0995, 0x0aba, 0x08a7, 0x0518, 0x0211,
    0x0104, 0x01fc, 0x0496, 0x0872, 0x0bb8, 0x0c3f, 0x09ed, 0x0647,
    0x01b1, 0xfcfb, 0xf9fa, 0xf868, 0xf696, 0xf473, 0xf388, 0xf49a,
    0xf79d, 0xfcf6, 0x03d3, 0x098a, 0x0bdb, 0x09d0, 0x0333, 0xf912,
    0xef96, 0xec81, 0xf218, 0xfcb1, 0x0701, 0x0e3f, 0x101a, 0x0b66,
    0x0277, 0xf999, 0xf3ac, 0xf1e5, 0xf46d, 0xf943, 0xfe3b, 0x02f5,
    0x0764, 0x0af1, 0x0e28, 0x10ef, 0x11fd, 0x1089, 0x0bfb, 0x04c9,
    0xfcab, 0xf637, 0xf319, 0xf471, 0xf94a, 0xfe9b, 0x031a, 0x044c,
    0x00b3, 0xfc44, 0xfa97, 0xfaf6, 0xfbf8, 0xfd4a, 0xfdb4, 0xfc9b,
    0xfb9d, 0xfbe5, 0xfcfc, 0xfde1, 0xfdb3, 0xfbb7, 0xf8b0, 0xf714,
    0xf923, 0xff29, 0x0752, 0x0fdc, 0x1694, 0x1892, 0x1492, 0x0c48,
    0x0238, 0xf832, 0xf071, 0xebf3, 0xea89, 0xec4b, 0xf1d9, 0xfb11,
    0x048a, 0x0b27, 0x0ee9, 0x106c, 0x0f0e, 0x0a83, 0x03e2, 0xfc89,
    0xf73a, 0xf5c2, 0xf662, 0xf7e4, 0xfa83, 0xfcdb, 0xfd7a, 0xfdab,
    0xff22, 0x0108, 0x0262, 0x02c8, 0x0087, 0xfb72, 0xf783, 0xf89c,
    0xfe22, 0x0502, 0x0b60, 0x0fc8, 0x0fc7, 0x0ab6, 0x03a7, 0xfeec,
    0xfd79, 0xfede, 0x0385, 0x0988, 0x0be5, 0x074a, 0xfe37, 0xf57d,
    0xef15, 0xec03, 0xef11, 0xf7da, 0x0196, 0x0864, 0x0bcd, 0x0a89,
    0x03b2, 0xfb33, 0xf5df, 0xf4b4, 0xf62b, 0xfa97, 0x013b, 0x0676,
    0x074a, 0x04a5, 0x0122, 0xfdc5, 0xfbd1, 0xfc7f, 0xfe4c, 0xff12,
    0x001c, 0x0298, 0x057d, 0x07c8, 0x094c, 0x0932, 0x0566, 0xfe2d,
    0xf60c, 0xefc3, 0xedf1, 0xf30e, 0xfdbd, 0x08dc, 0x107f, 0x12fc,
    0x0fba, 0x076e, 0xfd76, 0xf50f, 0xefe1, 0xf03e, 0xf6b2, 0x0077,
    0x0a17, 0x1136, 0x13b8, 0x0fd5, 0x084b, 0x0045, 0xf93d, 0xf547,
    0xf5ec, 0xfa01, 0xfe00, 0x0045, 0x0129, 0x00bf, 0xff15, 0xfd14,
    0xfc3b, 0xfcba, 0xfe37, 0x00fa, 0x04b5, 0x0835, 0x0a87, 0x0af0,
    0x0890, 0x041e, 0xff74, 0xfbc1, 0xf932, 0xf821, 0xf923, 0xfaf0,
    0xfb80, 0xfa1d, 0xf846, 0xf771, 0xf805, 0xfa1e, 0xfd7b, 0x012b,
    0x0346, 0x02eb, 0x0040, 0xfcef, 0xfbd0, 0xfd08, 0xfedf, 0x00a8,
    0x02b5, 0x04cf, 0x04f3, 0x0291, 0xff71, 0xfd33, 0xfc7e, 0xfcf5,
    0xfd45, 0xfcdf, 0xfd2e, 0xffd3, 0x04dc, 0x0ba2, 0x12e5, 0x178b,
    0x161f, 0x0f17, 0x06c8, 0xfffe, 0xfb85, 0xf966, 0xf8fd, 0xf939,
    0xfa2c, 0xfc9f, 0xfe69, 0xfdb0, 0xfaf9, 0xf6c3, 0xf329, 0xf2fc,
    0xf6d1, 0xfcfc, 0x02cd, 0x0632, 0x0736, 0x0645, 0x02cc, 0xfd47,
    0xf827, 0xf4e8, 0xf3a0, 0xf4a4, 0xf797, 0xfbf8, 0x01d1, 0x0899,
    0x0eb7, 0x1277, 0x1333, 0x0f89, 0x06b4, 0xfc9d, 0xf521, 0xf1ce,
    0xf2b8, 0xf655, 0xfaac, 0xfecc, 0x0307, 0x06df, 0x09e4, 0x0c71,
    0x0d7f, 0x0be0, 0x0706, 0xfe92, 0xf5a0, 0xf115, 0xf246, 0xf65c,
    0xfc00, 0x02cc, 0x0722, 0x06f8, 0x03fd, 0x003a, 0xfcbe, 0xfad3,
    0xfb40, 0xfcc5, 0xfe23, 0xff85, 0x01c9, 0x0415, 0x047e, 0x040b,
    0x0389, 0x0175, 0xfea5, 0xfde1, 0xfff5, 0x0386, 0x0753, 0x0a24,
    0x0a5b, 0x070b, 0x0064, 0xf80e, 0xf0be, 0xec6c, 0xebf8, 0xefde,
    0xf862, 0x039e, 0x0d77, 0x1316, 0x137f, 0x0f06, 0x0784, 0xff09,
    0xf725, 0xf219, 0xf193, 0xf472, 0xf815, 0xfae5, 0xfd32, 0x005e,
    0x04c6, 0x0880, 0x0997, 0x07c2, 0x03f0, 0x001d, 0xfe5c, 0xff12,
    0x0153, 0x049b, 0x07e2, 0x0863, 0x0453, 0xfd21, 0xf599, 0xf0f7,
    0xf16b, 0xf5e7, 0xfb80, 0x0087, 0x0592, 0x0ab4, 0x0cf6, 0x099d,
    0x01b6, 0xf90b, 0xf357, 0xf359, 0xf973, 0x0262, 0x0b21, 0x1249,
    0x15ea, 0x141c, 0x0d8c, 0x046b, 0xf9dc, 0xf042, 0xea77, 0xe7df,
    0xe775, 0xeab9, 0xf271, 0xfb60, 0x0267, 0x078b, 0x0ab8, 0x0b35,
    0x0a7d, 0x0b28, 0x0cc0, 0x0d3d, 0x0c49, 0x0a07, 0x061c, 0x00e2,
    0xfc00, 0xf8e0, 0xf7c7, 0xf9a7, 0xfde1, 0x0070, 0xff2e, 0xfca7,
    0xfad6, 0xf9a8, 0xfa8d, 0xfd93, 0x000a, 0x00d8, 0x0120, 0x01eb,
    0x0377, 0x05ae, 0x0732, 0x05ab, 0x015a, 0xfd3e, 0xfb1c, 0xfa91,
    0xfb6b, 0xfd59, 0xfedb, 0xfeb0, 0xfd24, 0xfb6f, 0xfa53, 0xfa90,
    0xfc31, 0xff1a, 0x03e7, 0x0a06, 0x0fc3, 0x13cd, 0x14b2, 0x109d,
    0x0857, 0xfec8, 0xf652, 0xf18a, 0xf1f8, 0xf4e8, 0xf78b, 0xfa67,
    0xfd4e, 0xfeaf, 0xfe84, 0xfdd8, 0xfc85, 0xfb1c, 0xfb40, 0xfcb4,
    0xfe15, 0xffbf, 0x0209, 0x0319, 0x0139, 0xfdde, 0xfb89, 0xfafb,
    0xfcc3, 0x00c2, 0x0571, 0x0963, 0x0c25, 0x0e4c, 0x0e9c, 0x0b1a,
    0x04e2, 0xfd77, 0xf5a8, 0xef4b, 0xecea, 0xeee6, 0xf3bd, 0xfae5,
    0x03b8, 0x0bf3, 0x118a, 0x132b, 0x0ff0, 0x092a, 0x01d5, 0xfb4f,
    0xf63c, 0xf3bc, 0xf469, 0xf811, 0xfcca, 0x0026, 0x0191, 0x02e8,
    0x046b, 0x0438, 0x0261, 0xff8b, 0xfbda, 0xf821, 0xf5db, 0xf6b9,
    0xf99b, 0xfd11, 0x0091, 0x02a9, 0x04ad, 0x0859, 0x0cd8, 0x0fbb,
    0x0fa8, 0x0d22, 0x08e2, 0x02cc, 0xfbc0, 0xf68e, 0xf3c1, 0xf2be,
    0xf3d1, 0xf742, 0xfb3a, 0xfda6, 0xffdd, 0x02ce, 0x05bc, 0x07fe,
    0x098a, 0x0921, 0x05f7, 0x01f2, 0xfd83, 0xf86f, 0xf4b1, 0xf48d,
    0xf776, 0xfbb5, 0x0017, 0x0340, 0x043e, 0x0455, 0x04a3, 0x043d,
    0x0283, 0xff7d, 0xfc03, 0xf95e, 0xf865, 0xf8db, 0xfa47, 0xfcc8,
    0x0012, 0x0416, 0x0831, 0x0ad2, 0x0b88, 0x0adc, 0x0845, 0x038d,
    0xfdf5, 0xf8b8, 0xf4b6, 0xf2ab, 0xf357, 0xf6e4, 0xfd0e, 0x0441,
    0x0a09, 0x0cac, 0x0bd5, 0x0818, 0x02cc, 0xfdf6, 0xfa9e, 0xf943,
    0xf9f4, 0xfc24, 0xff3f, 0x0208, 0x032b, 0x022e, 0x0073, 0xff50,
    0xfeee, 0xff7e, 0x009f, 0x0234, 0x0488, 0x06d8, 0x07d5, 0x0780,
    0x0620, 0x0325, 0xfec4, 0xfa18, 0xf699, 0xf5ee, 0xf863, 0xfd74,
    0x03a4, 0x088f, 0x0ae3, 0x0a18, 0x063c, 0x00a5, 0xfae2, 0xf56a,
    0xf120, 0xeeae, 0xeeda, 0xf1fc, 0xf71f, 0xfe0b, 0x051d, 0x09bf,
    0x0a9b, 0x086a, 0x04e7, 0x010f, 0xfe98, 0xfdcf, 0xfd73, 0xfe21,
    0x00e0, 0x0448, 0x0669, 0x06fc, 0x0683, 0x05cf, 0x058f, 0x053b,
    0x0382, 0x007e, 0xfd80, 0xfae5, 0xf8f9, 0xf88c, 0xf9c8, 0xfbda,
    0xfe0e, 0xfffe, 0x0199, 0x02f8, 0x0378, 0x037c, 0x03e1, 0x0407,
    0x033c, 0x01ac, 0xff31, 0xfbf3, 0xf904, 0xf6cf, 0xf598, 0xf619,
    0xf89f, 0xfc6d, 0x002d, 0x0322, 0x056e, 0x06ce, 0x06aa, 0x0577,
    0x044c, 0x03e3, 0x0393, 0x0260, 0x00dd, 0xffdd, 0xff8f, 0xff6f,
    0xff54, 0xff1d, 0xfebc, 0xfeae, 0xff4f, 0x00be, 0x026f, 0x035b,
    0x02e6, 0x0131, 0xff39, 0xfd9e, 0xfbe3, 0xfa35, 0xf917, 0xf8ff,
    0xf9e1, 0xfb95, 0xfe2f, 0x0079, 0x0154, 0x012e, 0x003d, 0xfed8,
    0xfe31, 0xfeae, 0x0033, 0x027a, 0x057f, 0x087b, 0x0997, 0x0894,
    0x0690, 0x0465, 0x0311, 0x02ce, 0x02c4, 0x0286, 0x0251, 0x01db,
    0x0061, 0xfe13, 0xfba6, 0xf9c5, 0xf902, 0xf93f, 0xfa18, 0xfb42,
    0xfc79, 0xfdec, 0xffb0, 0x0113, 0x01a6, 0x0146, 0x0024, 0xff2c,
    0xfe58, 0xfda2, 0xfd63, 0xfda7, 0xfe6e, 0xff71, 0x007b, 0x00dd,
    0x0067, 0xffb4, 0xff94, 0x0072, 0x01b2, 0x031e, 0x04d7, 0x05bb,
    0x04cd, 0x0351, 0x0295, 0x0186, 0xffd6, 0xfed6, 0xfe5a, 0xfdf5,
    0xfdfd, 0xfeff, 0x0022, 0x0068, 0x00b6, 0x011a, 0x00c0, 0xffa3,
    0xfe6c, 0xfcef, 0xfa8d, 0xf95c, 0xfa36, 0xfb2b, 0xfc2f, 0xfe2c,
    0x00a2, 0x020e, 0x02f8, 0x04d3, 0x067a, 0x068d, 0x0624, 0x055f,
    0x0280, 0xfd9a, 0xf9a6, 0xf823, 0xf822, 0xfa2c, 0xfeab, 0x02fb,
    0x052d, 0x0622, 0x0637, 0x0546, 0x0423, 0x0360, 0x01d4, 0xfe73,
    0xfa50, 0xf729, 0xf60f, 0xf743, 0xfaf1, 0x0065, 0x05f5, 0x09dc,
    0x0a70, 0x0731, 0x019d, 0xfca3, 0xfa36, 0xf983, 0xf98b, 0xfa56,
    0xfb6a, 0xfca3, 0xfe9c, 0x011a, 0x0283, 0x02f1, 0x0332, 0x0367,
    0x0380, 0x033a, 0x02b9, 0x01d7, 0x0128, 0x0184, 0x02a7, 0x0345,
    0x02b9, 0x01ac, 0x0080, 0xff41, 0xff11, 0x00d1, 0x02c7, 0x02e5,
    0x021b, 0x0158, 0xff82, 0xfd23, 0xfbba, 0xfb26, 0xfad1, 0xfaeb,
    0xfbe3, 0xfcb2, 0xfd80, 0xff97, 0x0242, 0x043a, 0x05b0, 0x06fe,
    0x0767, 0x060e, 0x03cd, 0x00f5, 0xfd3e, 0xf986, 0xf6e4, 0xf656,
    0xf7ee, 0xfaee, 0xfe8d, 0x021d, 0x055b, 0x07c2, 0x07fc, 0x05d4,
    0x0278, 0x0001, 0xff3e, 0xff5b, 0xff4b, 0xff7f, 0x00d5, 0x01db,
    0x015b, 0x00e1, 0x0174, 0x01cc, 0x0176, 0x0024, 0xfdf1, 0xfb22,
    0xf949, 0xf99e, 0xfa28, 0xfa21, 0xf9e8, 0xf98a, 0xf939, 0xf9d0,
    0xfcd3, 0x024d, 0x08e6, 0x0e52, 0x1096, 0x0f04, 0x0aa1, 0x0523,
    0xff67, 0xfa01, 0xf60f, 0xf3e0, 0xf379, 0xf543, 0xf894, 0xfd86,
    0x03b6, 0x08dc, 0x0c28, 0x0dbf, 0x0d23, 0x0a4e, 0x05de, 0x0063,
    0xf9e0, 0xf390, 0xf089, 0xf259, 0xf6ba, 0xfb93, 0x0023, 0x02c7,
    0x0322, 0x0242, 0x014f, 0x008b, 0xffdf, 0xff68, 0xfeb0, 0xfd12,
    0xfb49, 0xfb34, 0xfd68, 0x0112, 0x0591, 0x0a00, 0x0ce5, 0x0d80,
    0x0bfd, 0x08db, 0x0476, 0xff88, 0xfb59, 0xf812, 0xf55c, 0xf2cb,
    0xf129, 0xf225, 0xf551, 0xf984, 0xfe70, 0x038d, 0x0739, 0x088a,
    0x098f, 0x0aee, 0x0a8f, 0x08a6, 0x063c, 0x0279, 0xfd59, 0xf975,
    0xf87c, 0xf90d, 0xf9c8, 0xfae3, 0xfc11, 0xfc4b, 0xfc70, 0xfe06,
    0x006b, 0x0209, 0x02eb, 0x0393, 0x03bf, 0x0340, 0x02f1, 0x036b,
    0x0451, 0x055d, 0x0676, 0x06a1, 0x0533, 0x0407, 0x0390, 0x0221,
    0xff97, 0xfd00, 0xfa2e, 0xf67f, 0xf346, 0xf1c5, 0xf1ed, 0xf3b6,
    0xf7bb, 0xfd25, 0x01e0, 0x05ba, 0x09f4, 0x0d53, 0x0d66, 0x0b66,
    0x0987, 0x0710, 0x03b3, 0x00ff, 0xfe8a, 0xfaea, 0xf7b2, 0xf728,
    0xf7f0, 0xf89e, 0xfa3d, 0xfcc2, 0xfede, 0x009f, 0x02c6, 0x047b,
    0x043a, 0x0332, 0x031e, 0x032e, 0x02f8, 0x030f, 0x0340, 0x02be,
    0x0249, 0x030b, 0x0406, 0x0427, 0x03d9, 0x032c, 0x006f, 0xfbd6,
    0xf73f, 0xf2ff, 0xeff6, 0xefea, 0xf30e, 0xf7c0, 0xfc94, 0x0167,
    0x0624, 0x092f, 0x0a1c, 0x09cc, 0x082f, 0x05a8, 0x02e0, 0x0071,
    0xfeb2, 0xfd89, 0xfd0d, 0xfd43, 0xfd40, 0xfc7c, 0xfbc2, 0xfb07,
    0xfa07, 0xf9fe, 0xfba7, 0xfe2f, 0x00ee, 0x03ba, 0x05ca, 0x0634,
    0x0491, 0x01a0, 0xff06, 0xfe52, 0x0085, 0x04bd, 0x0885, 0x09f7,
    0x095c, 0x07a8, 0x044f, 0xff6a, 0xfaee, 0xf77a, 0xf4a5, 0xf3b5,
    0xf51e, 0xf785, 0xfab3, 0xff99, 0x04f8, 0x07f4, 0x0826, 0x06ef,
    0x04c7, 0x0275, 0x00fe, 0x00a6, 0x010a, 0x0104, 0x0041, 0xfee5,
    0xfd70, 0xfcdd, 0xfd06, 0xfdfa, 0xfff3, 0x0202, 0x02f2, 0x0263,
    0x0175, 0x00d0, 0xffb1, 0xfe1c, 0xfd96, 0xfde6, 0xfdf8, 0xfe74,
    0xff45, 0xff4a, 0xfe2b, 0xfdac, 0xfe34, 0xfe69, 0xff1b, 0x00fc,
    0x0221, 0x019b, 0x0047, 0xff46, 0xfebf, 0xfe44, 0xfe62, 0xfecd,
    0xff8c, 0x0107, 0x024d, 0x0284, 0x022a, 0x0307, 0x0506, 0x05c1,
    0x04b9, 0x026f, 0xfef0, 0xfb89, 0xf9e8, 0xf9ff, 0xfac0, 0xfc84,
    0xffc7, 0x036d, 0x0654, 0x085e, 0x09cd, 0x0974, 0x062a, 0x0171,
    0xfd4e, 0xf9cd, 0xf6fe, 0xf623, 0xf710, 0xf848, 0xf9bf, 0xfbe2,
    0xfe56, 0x00e5, 0x03fd, 0x06b9, 0x07cc, 0x07cb, 0x0734, 0x0570,
    0x0240, 0xff1f, 0xfd96, 0xfcaf, 0xfb22, 0xf9f7, 0xfa8d, 0xfc82,
    0xff4c, 0x02d8, 0x05e9, 0x06ac, 0x0552, 0x02d7, 0xfefb, 0xfa42,
    0xf66c, 0xf439, 0xf39b, 0xf560, 0xfa74, 0x0187, 0x0821, 0x0cb2,
    0x0e30, 0x0d1a, 0x0a36, 0x05a5, 0x00b1, 0xfc87, 0xf993, 0xf861,
    0xf835, 0xf860, 0xf946, 0xfa9c, 0xfbf7, 0xfdc4, 0x0055, 0x0283,
    0x0344, 0x02af, 0x01b9, 0x01d1, 0x02ea, 0x040d, 0x04a3, 0x04bf,
    0x0464, 0x03c1, 0x037e, 0x034e, 0x02d1, 0x0268, 0x01ee, 0x0165,
    0x00da, 0x0009, 0xfdf3, 0xf9ed, 0xf5f2, 0xf435, 0xf515, 0xf7a6,
    0xfacb, 0xfec4, 0x041f, 0x08f9, 0x0aef, 0x0a30, 0x0908, 0x068e,
    0x0233, 0xfe5b, 0xfc4d, 0xfc0e, 0xfc7c, 0xfd65, 0xfdb4, 0xfce0,
    0xfb93, 0xfa6c, 0xfa3a, 0xfb42, 0xfe1a, 0x01b9, 0x0435, 0x04f8,
    0x0473, 0x02ef, 0x0068, 0xfe79, 0xfed0, 0x013a, 0x04c9, 0x0841,
    0x09d7, 0x0828, 0x03df, 0xfeee, 0xf9e0, 0xf4d9, 0xf1c6, 0xf190,
    0xf2f4, 0xf592, 0xf994, 0xfe3f, 0x0276, 0x0602, 0x088f, 0x0951,
    0x0807, 0x05e5, 0x0480, 0x03f4, 0x044d, 0x05bd, 0x071c, 0x06be,
    0x03fe, 0xffc2, 0xfbe1, 0xf90d, 0xf75c, 0xf765, 0xf8d6, 0xfad6,
    0xfcfb, 0xff38, 0x0124, 0x0189, 0x00db, 0x00af, 0x0161, 0x02e9,
    0x03f5, 0x0396, 0x0236, 0x008d, 0xfefa, 0xfd4a, 0xfbed, 0xfb06,
    0xfae2, 0xfb9a, 0xfc4d, 0xfd08, 0xfdf9, 0xff13, 0x0049, 0x01ad,
    0x038b, 0x04d2, 0x0525, 0x0529, 0x04e4, 0x043e, 0x0410, 0x04f2,
    0x05c6, 0x0562, 0x036c, 0x0075, 0xfcfb, 0xfa14, 0xf8b2, 0xf853,
    0xf879, 0xf923, 0xfaf5, 0xfd8e, 0xff91, 0x005a, 0x0065, 0x0086,
    0x00f2, 0x01bf, 0x02f3, 0x03ed, 0x03a4, 0x0215, 0xff4f, 0xfb37,
    0xf7b9, 0xf6b7, 0xf840, 0xfbd2, 0x00d1, 0x0529, 0x0695, 0x05bd,
    0x03fa, 0x0183, 0xff55, 0xfeb8, 0xff56, 0x0054, 0x0190, 0x033b,
    0x04da, 0x05d0, 0x0622, 0x0599, 0x0450, 0x033a, 0x02de, 0x0275,
    0x00fc, 0xfe9f, 0xfcc5, 0xfbc2, 0xfa8f, 0xf8e5, 0xf7d1, 0xf857,
    0xfaa0, 0xfe3e, 0x01f1, 0x0467, 0x0573, 0x04e0, 0x0275, 0xff07,
    0xfbfb, 0xfa3b, 0xfa7f, 0xfc93, 0xff56, 0x0207, 0x03af, 0x03a8,
    0x0246, 0x0020, 0xfd3d, 0xfab7, 0xf9bd, 0xfa43, 0xfcf3, 0x01d4,
    0x06e3, 0x0a41, 0x0bae, 0x0ac2, 0x07aa, 0x04c2, 0x0366, 0x02b3,
    0x01fd, 0x00ef, 0xff4a, 0xfd5f, 0xfb97, 0xf9d6, 0xf73a, 0xf435,
    0xf33a, 0xf525, 0xf8d2, 0xfd7d, 0x0244, 0x064e, 0x0942, 0x0abc,
    0x09d6, 0x06ba, 0x02f5, 0xff0d, 0xfbbd, 0xfa39, 0xfb53, 0xfe55,
    0x0191, 0x0432, 0x048d, 0x0256, 0xfeb7, 0xfa79, 0xf884, 0xf9ab,
    0xfc6c, 0xffdb, 0x02c0, 0x03c1, 0x0231, 0x00ca, 0x010a, 0x0233,
    0x03eb, 0x0699, 0x096d, 0x0a63, 0x0804, 0x021c, 0xfb40, 0xf613,
    0xf383, 0xf2e2, 0xf376, 0xf589, 0xf914, 0xfd43, 0x00eb, 0x03c1,
    0x06af, 0x0900, 0x0984, 0x0829, 0x054d, 0x027d, 0x0168, 0x01bb,
    0x020e, 0x02e3, 0x03d5, 0x0223, 0xfd77, 0xf979, 0xf8c6, 0xfa1b,
    0xfcd9, 0x00af, 0x0411, 0x0572, 0x047d, 0x024a, 0xff80, 0xfcc9,
    0xfb2c, 0xfb40, 0xfcef, 0xff36, 0x0072, 0x00c9, 0x00c8, 0x0025,
    0xfeec, 0xfdcf, 0xfcfe, 0xfb38, 0xf8f0, 0xf7fb, 0xf8e9, 0xfae2,
    0xfdcd, 0x022b, 0x0635, 0x07b9, 0x06d8, 0x04e0, 0x025d, 0xffdc,
    0xff0e, 0x001b, 0x01d6, 0x0495, 0x0799, 0x076c, 0x02d9, 0xfd58,
    0xf924, 0xf646, 0xf61c, 0xf909, 0xfccb, 0xfff9, 0x0396, 0x0772,
    0x0928, 0x0777, 0x044b, 0x010a, 0xfde0, 0xfc40, 0xfcfc, 0xfe58,
    0xff2c, 0x0083, 0x01a1, 0x00a2, 0xfe5b, 0xfc87, 0xfb98, 0xfc24,
    0xfea6, 0x0141, 0x024a, 0x027d, 0x02ed, 0x031b, 0x0206, 0x00c7,
    0x0047, 0xff4b, 0xfda3, 0xfd10, 0xff00, 0x0233, 0x0470, 0x052f,
    0x04c3, 0x0302, 0x007d, 0xfe3a, 0xfc25, 0xfabc, 0xfa32, 0xfa3c,
    0xfa39, 0xfa0f, 0xfb05, 0xfdc3, 0x0172, 0x0483, 0x06fc, 0x0890,
    0x07c1, 0x0537, 0x02b5, 0x00b0, 0xfe9a, 0xfc99, 0xfb2e, 0xfa1f,
    0xf9fa, 0xfba5, 0xfd7d, 0xfe31, 0xff32, 0x0123, 0x02ed, 0x03c0,
    0x0446, 0x042f, 0x02a2, 0x00bf, 0x00d6, 0x0263, 0x0358, 0x02ed,
    0x016b, 0xffeb, 0xfe7d, 0xfdc8, 0xfe79, 0xfebc, 0xfd29, 0xfc0c,
    0xfc9a, 0xfc84, 0xfba4, 0xfc52, 0xfe58, 0xffdf, 0x0132, 0x02f3,
    0x04b6, 0x0622, 0x0688, 0x057a, 0x035f, 0x015f, 0x0007, 0xffa1,
    0x0067, 0x01c3, 0x0242, 0x009a, 0xfd5e, 0xfa83, 0xf859, 0xf774,
    0xf932, 0xfcb9, 0xff38, 0xffa1, 0xffe0, 0x00e4, 0x025c, 0x038e,
    0x055c, 0x0780, 0x07d0, 0x05a3, 0x025c, 0x0004, 0xff26, 0xff9d,
    0x0045, 0xff72, 0xfd4c, 0xfb68, 0xfa13, 0xf873, 0xf760, 0xf858,
    0xfb26, 0xfed8, 0x0262, 0x04b9, 0x05ac, 0x05b2, 0x04cd, 0x03ac,
    0x0405, 0x051f, 0x0535, 0x0435, 0x02e1, 0x015b, 0xff5d, 0xfd9b,
    0xfc89, 0xfc6c, 0xfcc4, 0xfc85, 0xfc71, 0xfdab, 0xfefd, 0xff2e,
    0xff49, 0x0015, 0x00dc, 0x0111, 0x00be, 0xff77, 0xfd47, 0xfb86,
    0xfb21, 0xfc07, 0xfdae, 0x003d, 0x0379, 0x058b, 0x0552, 0x03c1,
    0x021f, 0x006e, 0xfeb3, 0xfd3a, 0xfc1e, 0xfbec, 0xfd16, 0xfe9e,
    0xff97, 0x00fc, 0x0324, 0x04d4, 0x04fa, 0x0365, 0x00fa, 0xff12,
    0xfe98, 0xfeef, 0xff23, 0xff1d, 0xfef9, 0xff89, 0x0116, 0x01f9,
    0x0100, 0xfeee, 0xfda0, 0xfd8c, 0xfe23, 0xff71, 0x011f, 0x026c,
    0x030b, 0x02c8, 0x010f, 0xfe32, 0xfb60, 0xfa77, 0xfc78, 0x002f,
    0x035d, 0x04c2, 0x04fd, 0x0391, 0x0071, 0xfd1a, 0xfaa2, 0xf942,
    0xf9ba, 0xfc51, 0xff67, 0x02b3, 0x05c7, 0x06ec, 0x066b, 0x0585,
    0x0450, 0x02a7, 0x00f6, 0xffaa, 0xfe51, 0xfd10, 0xfc4e, 0xfc69,
    0xfd8a, 0xfe6e, 0xfe52, 0xfdb5, 0xfcff, 0xfc74, 0xfd4a, 0xff93,
    0x0196, 0x02cf, 0x03de, 0x0368, 0x00f0, 0xff23, 0xfecc, 0xfe65,
    0xfde4, 0xfe70, 0xff1b, 0xff1d, 0xff1a, 0xff46, 0xfeda, 0xfe4d,
    0xfe40, 0xfdda, 0xfe10, 0x0050, 0x047c, 0x08ff, 0x0c36, 0x0d5c,
    0x0b9a, 0x0736, 0x0219, 0xfd9b, 0xfa9c, 0xf945, 0xf86d, 0xf76a,
    0xf6cb, 0xf746, 0xf93a, 0xfcc5, 0x0043, 0x020a, 0x0302, 0x0398,
    0x0300, 0x01f9, 0x011c, 0xff6f, 0xfd07, 0xfbd6, 0xfc40, 0xfdd2,
    0x010a, 0x0510, 0x080a, 0x0898, 0x0690, 0x0255, 0xfdd2, 0xfa32,
    0xf7ca, 0xf847, 0xfad2, 0xfcd6, 0xfda2, 0xfe8a, 0xff6d, 0x00bd,
    0x0354, 0x0608, 0x088f, 0x0b17, 0x0bd1, 0x0892, 0x0325, 0xff67,
    0xfd6c, 0xfb41, 0xf935, 0xf7ea, 0xf73f, 0xf6fe, 0xf6fc, 0xf83d,
    0xfb87, 0xffb9, 0x0317, 0x0460, 0x02ed, 0xffee, 0xfe6d, 0xfef8,
    0xffbf, 0x0232, 0x0661, 0x0810, 0x06c3, 0x059c, 0x05cf, 0x060a,
    0x04cc, 0x020b, 0xfe91, 0xfb9f, 0xf9d4, 0xf8db, 0xf93f, 0xfb33,
    0xfdb0, 0xffb2, 0x0178, 0x038d, 0x04f7, 0x052d, 0x04fd, 0x03fc,
    0x0188, 0xfe0a, 0xfafb, 0xf94f, 0xf982, 0xfc85, 0x0026, 0x0151,
    0x009b, 0x0058, 0x00d2, 0x00bc, 0xffe5, 0xfe0e, 0xfb33, 0xf8f2,
    0xf942, 0xfb7d, 0xfe3c, 0x02cb, 0x08bb, 0x0c6c, 0x0b9d, 0x07f6,
    0x035e, 0xfe3d, 0xfa65, 0xf9b0, 0xfab8, 0xfbac, 0xfd2c, 0xffe0,
    0x0249, 0x0238, 0x0071, 0xfeed, 0xfe6e, 0xffd0, 0x02a2, 0x0545,
    0x06ee, 0x0732, 0x0570, 0x016c, 0xfd56, 0xfab5, 0xf924, 0xf966,
    0xfbb3, 0xfdb8, 0xfd9b, 0xfcb1, 0xfbb9, 0xfab7, 0xfa60, 0xfb58,
    0xfdf4, 0x00ff, 0x03a0, 0x067c, 0x09dc, 0x0bde, 0x0b68, 0x0989,
    0x069d, 0x0211, 0xfc43, 0xf7b1, 0xf64a, 0xf87a, 0xfc94, 0xfffe,
    0x01da, 0x0188, 0xffb8, 0xfe45, 0xfe11, 0xfedf, 0x000f, 0x0129,
    0x017e, 0x00d7, 0xffdf, 0xfe9c, 0xfd4f, 0xfe13, 0xffdb, 0x0088,
    0x0185, 0x030c, 0x031f, 0x0123, 0xff77, 0xfe25, 0xfbfe, 0xfad1,
    0xfb14, 0xfb7b, 0xfb7d, 0xfc36, 0xfe84, 0x01c7, 0x0522, 0x08ad,
    0x0c7f, 0x0f0f, 0x0e9c, 0x0b35, 0x05f4, 0xfff9, 0xfa4f, 0xf676,
    0xf4a9, 0xf418, 0xf4db, 0xf74c, 0xfb16, 0xfefd, 0x022b, 0x045e,
    0x05ba, 0x05d4, 0x040f, 0x0154, 0xff03, 0xfdb6, 0xfccb, 0xfbed,
    0xfb7b, 0xfb8b, 0xfc55, 0xfdf1, 0x0051, 0x03b5, 0x06ca, 0x0893,
    0x092a, 0x07ee, 0x050f, 0x005d, 0xfb54, 0xf858, 0xf681, 0xf43f,
    0xf2ac, 0xf380, 0xf780, 0xfe27, 0x0651, 0x0e4e, 0x13e3, 0x1574,
    0x1121, 0x079b, 0xfcf7, 0xf5c7, 0xf38e, 0xf4a2, 0xf727, 0xfa11,
    0xfd13, 0xff66, 0x0083, 0x018b, 0x02d1, 0x0297, 0x0167, 0x0055,
    0xfebf, 0xfe43, 0x0005, 0x0177, 0x017c, 0x01dd, 0x0239, 0x00be,
    0xfe0f, 0xfc56, 0xfc7d, 0xfe3f, 0x0120, 0x04e8, 0x0868, 0x0915,
    0x0662, 0x025a, 0xfe70, 0xfa4b, 0xf775, 0xf7a3, 0xf996, 0xfc55,
    0x0035, 0x03a6, 0x0532, 0x0630, 0x06b4, 0x05a1, 0x0330, 0x00a2,
    0xfe2b, 0xfbc9, 0xfa26, 0xf9ad, 0xfb0f, 0xfe18, 0x00f0, 0x01ef,
    0x0073, 0xfd5c, 0xfb38, 0xfb3b, 0xfc1b, 0xfdb2, 0x00ee, 0x0444,
    0x05b1, 0x0557, 0x0312, 0xff1c, 0xfb83, 0xfa0d, 0xfab7, 0xfc03,
    0xfd6d, 0xff92, 0x02b1, 0x06a7, 0x09ed, 0x0a77, 0x0845, 0x052d,
    0x02b1, 0x0109, 0xffad, 0xfe68, 0xfdbc, 0xfd89, 0xfcf1, 0xfc50,
    0xfc6b, 0xfcd9, 0xfd47, 0xfd6c, 0xfd61, 0xfd51, 0xfd39, 0xfda9,
    0xfea1, 0xffe1, 0x0170, 0x0320, 0x0432, 0x0441, 0x03a5, 0x0301,
    0x02b5, 0x0262, 0x01c0, 0x008e, 0xff25, 0xfdd1, 0xfc3c, 0xfad8,
    0xfad2, 0xfc8e, 0xfee5, 0x00b7, 0x01cb, 0x020b, 0x01f3, 0x0253,
    0x0314, 0x0374, 0x02bf, 0x00d7, 0xfebc, 0xfd34, 0xfc3f, 0xfbf9,
    0xfc4e, 0xfd4a, 0xfef1, 0x009f, 0x0166, 0x014d, 0x00a2, 0xfef5,
    0xfccb, 0xfbfb, 0xfc98, 0xfd2d, 0xfe26, 0x007e, 0x02eb, 0x0492,
    0x0687, 0x086c, 0x08cb, 0x0839, 0x077c, 0x05e4, 0x0341, 0xff8e,
    0xfb54, 0xf7d8, 0xf5f4, 0xf668, 0xf900, 0xfc7f, 0xff58, 0x0094,
    0x00d4, 0x015f, 0x0297, 0x03c3, 0x03f7, 0x02d2, 0x011a, 0xffd3,
    0xfefa, 0xfeb6, 0xff30, 0xff3f, 0xfe72, 0xfd97, 0xfd72, 0xfe16,
    0xff72, 0x01ce, 0x04b9, 0x0708, 0x0754, 0x04e0, 0x0056, 0xfbb9,
    0xf8c2, 0xf8f0, 0xfbb7, 0xfdb8, 0xfd22, 0xfbf0, 0xfc64, 0xfe43,
    0x00cf, 0x03f1, 0x0714, 0x08bf, 0x07af, 0x03a8, 0xfeb7, 0xfb8a,
    0xfad6, 0xfbc4, 0xfd33, 0xfe90, 0xffe7, 0x01a0, 0x030d, 0x02d2,
    0x019b, 0x00dc, 0x00bb, 0x0071, 0xff9e, 0xfe93, 0xfd94, 0xfc80,
    0xfb3f, 0xfa67, 0xfab5, 0xfc83, 0xff41, 0x0196, 0x033b, 0x053b,
    0x0771, 0x08a9, 0x0927, 0x090b, 0x06c0, 0x0212, 0xfd83, 0xfa7a,
    0xf857, 0xf766, 0xf8a9, 0xfbc3, 0xff3f, 0x0226, 0x0470, 0x0586,
    0x051f, 0x037e, 0x00c3, 0xfd6f, 0xfb1a, 0xfb36, 0xfcc1, 0xfe74,
    0x0076, 0x0282, 0x0329, 0x01b5, 0xfe48, 0xf9ee, 0xf687, 0xf589,
    0xf735, 0xfa7e, 0xff2e, 0x0515, 0x0a96, 0x0cfe, 0x0a9e, 0x04c4,
    0xfe3c, 0xf934, 0xf7f9, 0xfaf1, 0xfea5, 0x00de, 0x02e9, 0x0520,
    0x062c, 0x05c8, 0x0463, 0x0240, 0xffed, 0xfe75, 0xfe84, 0x0020,
    0x02c7, 0x051e, 0x05c7, 0x0418, 0x0048, 0xfb58, 0xf6b3, 0xf405,
    0xf43a, 0xf6b3, 0xf9e9, 0xfdcc, 0x027e, 0x0593, 0x05ba, 0x03ec,
    0x016f, 0xff83, 0xffdb, 0x0272, 0x05b7, 0x0908, 0x0b22, 0x0a71,
    0x0710, 0x028d, 0xfe82, 0xfa6c, 0xf590, 0xf22b, 0xf272, 0xf5c6,
    0xfaef, 0x0165, 0x071f, 0x09ae, 0x093b, 0x0707, 0x0348, 0xff1e,
    0xfc95, 0xfb55, 0xfa3e, 0xfa55, 0xfc26, 0xfe8e, 0x00fa, 0x0375,
    0x04ed, 0x042b, 0x012a, 0xfd94, 0xfc49, 0xfd74, 0xffb5, 0x022a,
    0x0357, 0x0156, 0xfd10, 0xfa4b, 0xfafa, 0xfe48, 0x0320, 0x0824,
    0x0ad9, 0x09d2, 0x04f2, 0xfdc0, 0xf70b, 0xf379, 0xf38a, 0xf659,
    0xfba8, 0x022a, 0x0754, 0x09b0, 0x098e, 0x06e7, 0x0206, 0xfd46,
    0xfa06, 0xf7cc, 0xf6aa, 0xf80d, 0xfbee, 0xffe6, 0x02d1, 0x052d,
    0x0679, 0x057c, 0x02cc, 0x0058, 0xff6b, 0x0000, 0x0208, 0x04e8,
    0x078c, 0x0932, 0x08fb, 0x064f, 0x0152, 0xfb5e, 0xf621, 0xf2b5,
    0xf1b4, 0xf2da, 0xf569, 0xf875, 0xfb27, 0xfdd4, 0x00c9, 0x0323,
    0x0475, 0x0560, 0x055b, 0x0435, 0x033f, 0x0363, 0x03ed, 0x047a,
    0x04b5, 0x0369, 0x0086, 0xfd53, 0xfb50, 0xfb38, 0xfcf6, 0x005c,
    0x0555, 0x09fe, 0x0b3c, 0x07e8, 0x00f5, 0xf865, 0xf15d, 0xeeef,
    0xf18b, 0xf731, 0xfe28, 0x0578, 0x0bbd, 0x0f99, 0x1042, 0x0da3,
    0x08b6, 0x0369, 0xff17, 0xfbfd, 0xfa82, 0xfa62, 0xfb4e, 0xfd4e,
    0x0007, 0x02d8, 0x0434, 0x0383, 0x01c6, 0x0000, 0xfdc5, 0xfb01,
    0xf995, 0xfa84, 0xfcd3, 0xff43, 0x0095, 0xfff2, 0xfea7, 0xfef4,
    0x0157, 0x045e, 0x0658, 0x0659, 0x0448, 0x00d8, 0xfca4, 0xf915,
    0xf78c, 0xf787, 0xf880, 0xf9e1, 0xfb32, 0xfd55, 0x00d4, 0x044b,
    0x0612, 0x06bc, 0x0746, 0x0741, 0x06a3, 0x05a8, 0x03b0, 0x0030,
    0xfbe4, 0xf816, 0xf5d5, 0xf5c9, 0xf815, 0xfd11, 0x037f, 0x0811,
    0x08fd, 0x0717, 0x0343, 0xfe28, 0xf96c, 0xf636, 0xf4c4, 0xf600,
    0xfabb, 0x018f, 0x0829, 0x0d07, 0x0f80, 0x0f7d, 0x0d1e, 0x08c8,
    0x03b8, 0x006a, 0xff79, 0xfecf, 0xfce1, 0xf96c, 0xf4c4, 0xf08b,
    0xeee4, 0xf0c9, 0xf59f, 0xfbf3, 0x0262, 0x0754, 0x0982, 0x086d,
    0x04a0, 0xfffb, 0xfc22, 0xf93d, 0xf7d8, 0xf976, 0xfe2c, 0x0436,
    0x08f7, 0x0a82, 0x0874, 0x0451, 0x0055, 0xfd00, 0xfa8b, 0xf9ad,
    0xfa4d, 0xfc13, 0xfeac, 0x016b, 0x03d2, 0x0664, 0x08e1, 0x09e6,
    0x08be, 0x0593, 0x01c6, 0xff70, 0xff0a, 0xff26, 0xfe42, 0xfc31,
    0xf985, 0xf73d, 0xf62f, 0xf630, 0xf75e, 0xf9da, 0xfdb4, 0x02ad,
    0x0769, 0x0ad3, 0x0c89, 0x0ba7, 0x07f5, 0x02e2, 0xfe06, 0xfa3b,
    0xf85e, 0xf91a, 0xfbc5, 0xff13, 0x026c, 0x04f2, 0x0544, 0x037f,
    0x0116, 0xffa0, 0xff7f, 0xffbd, 0xffab, 0xfebe, 0xfc63, 0xfa10,
    0xf9e0, 0xfc1d, 0xffd8, 0x0484, 0x092b, 0x0b72, 0x0a40, 0x0674,
    0x012c, 0xfb24, 0xf64e, 0xf45e, 0xf50c, 0xf77e, 0xfb64, 0x000d,
    0x040c, 0x06c4, 0x0807, 0x0762, 0x047c, 0x00aa, 0xfd73, 0xfab1,
    0xf8f8, 0xf992, 0xfbf3, 0xfeee, 0x0236, 0x0512, 0x063b, 0x0593,
    0x03e3, 0x0171, 0xfef4, 0xfdcd, 0xfe28, 0xfe1a, 0xfd8f, 0xfde5,
    0xfe1f, 0xfdac, 0xfdbe, 0xfecc, 0x000a, 0x0105, 0x0132, 0x0039,
    0xff1d, 0xff72, 0x01b6, 0x048c, 0x0654, 0x0703, 0x0677, 0x03be,
    0x002d, 0xfdae, 0xfb45, 0xf88b, 0xf841, 0xfae3, 0xfe36, 0x01a6,
    0x051b, 0x066c, 0x04ec, 0x033f, 0x0231, 0x007d, 0xfe71, 0xfd9c,
    0xfd5e, 0xfcc4, 0xfcdf, 0xfe97, 0x00b8, 0x0245, 0x0368, 0x0326,
    0x0115, 0xfedf, 0xfe1c, 0xfe24, 0xfe3f, 0xfe9d, 0xfea1, 0xfd72,
    0xfb57, 0xf979, 0xf886, 0xf8d1, 0xfbba, 0xffcb, 0x02b5, 0x053b,
    0x07bb, 0x0a52, 0x0b55, 0x0944, 0x04bd, 0xff56, 0xfad2, 0xf8aa,
    0xf977, 0xfbb1, 0xfe13, 0xffdf, 0x0137, 0x027d, 0x031f, 0x02f0,
    0x01d3, 0x003f, 0xfedb, 0xfe22, 0xfe14, 0xfebf, 0xfff0, 0x0049,
    0xff7b, 0xfea4, 0xfe83, 0xfede, 0xffac, 0x0118, 0x02c9, 0x0343,
    0x01fc, 0xffba, 0xfdaa, 0xfd50, 0xfe43, 0xfeff, 0xff28, 0xff28,
    0xff6a, 0xfff8, 0x00b7, 0x0192, 0x0231, 0x0247, 0x0245, 0x0284,
    0x02a2, 0x021b, 0x0091, 0xfe6f, 0xfcd1, 0xfc3d, 0xfc41, 0xfc50,
    0xfbd8, 0xfb36, 0xfba8, 0xfd55, 0xff2d, 0x0107, 0x02e3, 0x040b,
    0x0426, 0x02e6, 0x0066, 0xfda4, 0xfc1c, 0xfc95, 0xff07, 0x02a4,
    0x0688, 0x0965, 0x09a3, 0x06e8, 0x0254, 0xfda6, 0xfa5a, 0xf904,
    0xf99b, 0xfb2e, 0xfc6c, 0xfdaf, 0xffbd, 0x018e, 0x0296, 0x02bb,
    0x0122, 0xfe6a, 0xfcb6, 0xfd2e, 0xff2c, 0x01f5, 0x0543, 0x0744,
    0x0639, 0x036e, 0x0046, 0xfcf0, 0xfa0b, 0xf887, 0xf84c, 0xf8ff,
    0xfb13, 0xfeb3, 0x029c, 0x0588, 0x07b0, 0x0918, 0x0889, 0x061b,
    0x0307, 0xff1c, 0xfb22, 0xf8c1, 0xf7b3, 0xf74f, 0xf8d7, 0xfcf2,
    0x0195, 0x0532, 0x0791, 0x082b, 0x06d0, 0x03e5, 0xffe9, 0xfc29,
    0xf9c2, 0xf863, 0xf871, 0xfa92, 0xfe0c, 0x0192, 0x0472, 0x05cd,
    0x04ab, 0x0239, 0x006a, 0xff74, 0xfeda, 0xfef5, 0xff8f, 0x0078,
    0x01f2, 0x0354, 0x03b5, 0x02d8, 0x0115, 0xff10, 0xfd55, 0xfc88,
    0xfd22, 0xfee2, 0x0194, 0x04c2, 0x0743, 0x07c8, 0x05b1, 0x0218,
    0xfe96, 0xfba4, 0xf9bf, 0xfa11, 0xfc6f, 0xfec6, 0x0033, 0x00cf,
    0xffcf, 0xfcdc, 0xf976, 0xf755, 0xf77a, 0xfa25, 0xfe8a, 0x02f9,
    0x055a, 0x05c1, 0x05cf, 0x0607, 0x0611, 0x056e, 0x03a7, 0x0120,
    0xfeb0, 0xfd18, 0xfc76, 0xfc33, 0xfc7f, 0xfd7d, 0xfde9, 0xfd73,
    0xfd57, 0xfdd3, 0xfe94, 0xffc3, 0x01b3, 0x03b4, 0x054a, 0x06ce,
    0x07cc, 0x075b, 0x0518, 0x023c, 0x0020, 0xfe94, 0xfd78, 0xfddd,
    0xff52, 0xffba, 0xfe33, 0xfbcc, 0xfa1b, 0xfa3b, 0xfc79, 0xfff6,
    0x0345, 0x05b1, 0x06e7, 0x06e7, 0x0614, 0x04ac, 0x0247, 0xfee8,
    0xfb9a, 0xf91e, 0xf7fb, 0xf814, 0xf8bb, 0xf9d1, 0xfb98, 0xfd6a,
    0xfe46, 0xfdf6, 0xfdcd, 0xfed1, 0x008d, 0x024b, 0x0379, 0x0397,
    0x026d, 0x0139, 0x013d, 0x01a6, 0x017f, 0x01cf, 0x0367, 0x0539,
    0x068e, 0x070c, 0x05c5, 0x02b2, 0xfea0, 0xfa9a, 0xf82b, 0xf7be,
    0xf86a, 0xfa2c, 0xfcff, 0x003f, 0x02cf, 0x03f7, 0x03e9, 0x0319,
    0x01ea, 0x0080, 0xfeb9, 0xfcf6, 0xfc27, 0xfcc2, 0xff0a, 0x029c,
    0x062d, 0x0914, 0x0a85, 0x0949, 0x05b4, 0x00dd, 0xfc08, 0xf81d,
    0xf55a, 0xf39e, 0xf2fc, 0xf4c0, 0xf9d4, 0x00b5, 0x0671, 0x08ea,
    0x082a, 0x05d5, 0x035d, 0x0159, 0x002f, 0xff9e, 0xfea7, 0xfd29,
    0xfc7e, 0xfd87, 0xffbc, 0x021a, 0x0400, 0x04a0, 0x0372, 0x0113,
    0xfe38, 0xfc40, 0xfc3f, 0xfd85, 0xfef2, 0x003c, 0x0165, 0x0267,
    0x0296, 0x01e4, 0x007f, 0xfe21, 0xfb23, 0xf91d, 0xf9b7, 0xfcce,
    0x0149, 0x05bd, 0x08f4, 0x0a7e, 0x0a1f, 0x0649, 0xff36, 0xf85c,
    0xf440, 0xf31f, 0xf57a, 0xfb38, 0x020c, 0x082e, 0x0d45, 0x0fb1,
    0x0d6f, 0x0754, 0xffd3, 0xf84d, 0xf1dd, 0xeec1, 0xf058, 0xf5a7,
    0xfc45, 0x0285, 0x0783, 0x0995, 0x0828, 0x0490, 0x009e, 0xfe14,
    0xfdd2, 0xfed9, 0xff50, 0xff7e, 0x00ab, 0x02f2, 0x062d, 0x09c0,
    0x0b8c, 0x0906, 0x03b4, 0xff87, 0xfcad, 0xfa59, 0xf931, 0xf936,
    0xf8c0, 0xf805, 0xf84d, 0xf91b, 0xfa68, 0xfca6, 0xff6a, 0x014c,
    0x02ec, 0x05b6, 0x08e4, 0x0a06, 0x0857, 0x0480, 0xff28, 0xfaa1,
    0xf8ec, 0xf9ea, 0xfc22, 0xff11, 0x026e, 0x0498, 0x0395, 0xff5b,
    0xfa7d, 0xf72e, 0xf626, 0xf780, 0xfb01, 0xff64, 0x038f, 0x0835,
    0x0d10, 0x0fb5, 0x0eab, 0x0aee, 0x0627, 0x017b, 0xfdc5, 0xfbb8,
    0xfb06, 0xfafd, 0xfbbe, 0xfcd3, 0xfd88, 0xfe06, 0xfe60, 0xfdde,
    0xfc7c, 0xfb67, 0xfad7, 0xfa24, 0xfa00, 0xfbea, 0xff69, 0x02d8,
    0x0575, 0x06d0, 0x05e4, 0x0273, 0xfe8f, 0xfc98, 0xfd25, 0xfe8d,
    0xff92, 0x008b, 0x0127, 0x00bd, 0xff7e, 0xfe45, 0xfe0b, 0xff54,
    0x0167, 0x02ac, 0x02ff, 0x0343, 0x048e, 0x06f4, 0x091b, 0x0980,
    0x073f, 0x02da, 0xfdee, 0xfa63, 0xf85f, 0xf78d, 0xf8c9, 0xfbbc,
    0xfe75, 0xffa0, 0xff93, 0xfeab, 0xfce4, 0xfb44, 0xfad7, 0xfbd3,
    0xfd48, 0xfe9d, 0xffcf, 0x00c5, 0x0206, 0x0415, 0x069a, 0x0882,
    0x0933, 0x08dc, 0x0798, 0x060e, 0x04ca, 0x030e, 0x00bd, 0xfead,
    0xfd31, 0xfba8, 0xfa45, 0xf99e, 0xf94b, 0xf98d, 0xfb14, 0xfced,
    0xfe8b, 0x001a, 0x005f, 0xfff4, 0x006b, 0x0158, 0x01e4, 0x023e,
    0x02bb, 0x0251, 0x0095, 0xfe98, 0xfd16, 0xfc0a, 0xfbb0, 0xfd0d,
    0xff34, 0x00d7, 0x0110, 0x003a, 0xffb1, 0xffa9, 0x0091, 0x021c,
    0x0307, 0x02d1, 0x0253, 0x01a0, 0x0119, 0x0174, 0x01a0, 0x0092,
    0xff8a, 0xff8e, 0xffd8, 0x0004, 0x00ad, 0x022f, 0x02ed, 0x0171,
    0xfe42, 0xfb02, 0xf918, 0xf945, 0xfb4d, 0xfd4d, 0xfe34, 0xff13,
    0x00ab, 0x01e0, 0x0210, 0x021a, 0x01ba, 0xffe2, 0xfd69, 0xfbe9,
    0xfbea, 0xfdfd, 0x014d, 0x0395, 0x04ee, 0x0643, 0x0657, 0x0420,
    0x0087, 0xfd13, 0xfb0b, 0xfae2, 0xfce5, 0x017d, 0x0641, 0x086a,
    0x0836, 0x0754, 0x0649, 0x0476, 0x0210, 0xffc3, 0xfd2b, 0xf98e,
    0xf595, 0xf20b, 0xefe6, 0xf0a7, 0xf421, 0xf885, 0xfd4e, 0x024f,
    0x0659, 0x0879, 0x085b, 0x06d5, 0x0528, 0x040d, 0x0337, 0x0221,
    0x00a5, 0xff64, 0xfec4, 0xfe9f, 0xff72, 0x0169, 0x0421, 0x0600,
    0x04db, 0x009e, 0xfb5a, 0xf774, 0xf679, 0xf918, 0xfdf3, 0x028b,
    0x0615, 0x08ba, 0x0a6a, 0x0a70, 0x0856, 0x0496, 0x002a, 0xfc21,
    0xf8c9, 0xf63d, 0xf5c0, 0xf7e1, 0xfb0e, 0xfd96, 0xfe8b, 0xfde3,
    0xfc8e, 0xfbf6, 0xfd05, 0xff2c, 0x0168, 0x0391, 0x055b, 0x05ac,
    0x0459, 0x0294, 0x0100, 0xff59, 0xfd77, 0xfc52, 0xfcd2, 0xff30,
    0x03a9, 0x0930, 0x0d56, 0x0e5b, 0x0bae, 0x05cd, 0xfea4, 0xf876,
    0xf4ac, 0xf430, 0xf718, 0xfb7b, 0xff6a, 0x0254, 0x04c2, 0x0710,
    0x0879, 0x0777, 0x0386, 0xfe27, 0xf91d, 0xf617, 0xf604, 0xf84d,
    0xfba5, 0xffae, 0x046f, 0x0840, 0x099a, 0x07b1, 0x0279, 0xfba8,
    0xf63f, 0xf46b, 0xf660, 0xfba6, 0x023e, 0x06ed, 0x07ef, 0x0667,
    0x034b, 0xff8f, 0xfddf, 0xff74, 0x02d3, 0x05e5, 0x06eb, 0x0522,
    0x01d7, 0xff15, 0xfe1a, 0xfe54, 0xfdff, 0xfc41, 0xf994, 0xf743,
    0xf62a, 0xf733, 0xfacf, 0xff2c, 0x040f, 0x09df, 0x0d53, 0x0c1c,
    0x0841, 0x03a9, 0xfe9e, 0xfb46, 0xfb8b, 0xfd61, 0xfed3, 0xff30,
    0xfe2e, 0xfc5c, 0xfb3a, 0xfb8c, 0xfd18, 0x003e, 0x034a, 0x042e,
    0x02fa, 0x0107, 0xffc5, 0xff10, 0xfd56, 0xfbf5, 0xfd5f, 0x0051,
    0x02e4, 0x04f3, 0x05ae, 0x02cd, 0xfd81, 0xf991, 0xf89c, 0xfac7,
    0xff24, 0x0225, 0x00c3, 0xfdb0, 0xfb85, 0xf9ac, 0xf9ee, 0xfd79,
    0x02df, 0x077e, 0x0968, 0x08ae, 0x066b, 0x03a4, 0x0171, 0x01a3,
    0x02de, 0x02e8, 0x0219, 0x0075, 0xfbff, 0xf715, 0xf7f4, 0xfe44,
    0x0586, 0x0b56, 0x0dc7, 0x0a9c, 0x02bb, 0xfa51, 0xf52d, 0xf4d5,
    0xf8e3, 0xfe76, 0x0241, 0x02b2, 0xff7f, 0xfa63, 0xf6ad, 0xf6a7,
    0xf9ae, 0xfe1b, 0x018c, 0x019a, 0xff5d, 0xfd39, 0xfc3c, 0xfd1a,
    0x0005, 0x0333, 0x04ed, 0x055e, 0x04d8, 0x042b, 0x0442, 0x0476,
    0x039f, 0x0123, 0xfd3c, 0xf90c, 0xf646, 0xf620, 0xf88d, 0xfd58,
    0x03a4, 0x086e, 0x093d, 0x0607, 0x0055, 0xfa6c, 0xf7fd, 0xfa9c,
    0xffe3, 0x05d7, 0x0af5, 0x0d05, 0x0aee, 0x05b5, 0xff9e, 0xfaaf,
    0xf8a7, 0xf99a, 0xfc18, 0xff5d, 0x02a3, 0x0494, 0x050a, 0x04cf,
    0x02b5, 0xfe24, 0xf9aa, 0xf794, 0xf7e6, 0xfa93, 0xff12, 0x03d9,
    0x082c, 0x0b27, 0x0af8, 0x0722, 0x015d, 0xfbac, 0xf721, 0xf4c8,
    0xf600, 0xfaf7, 0x0103, 0x04b9, 0x055a, 0x0326, 0xff0c, 0xfadd,
    0xf7bc, 0xf62c, 0xf672, 0xf8c2, 0xfcd3, 0x021c, 0x06f0, 0x091b,
    0x08b1, 0x06cf, 0x03c0, 0xffe5, 0xfcb2, 0xfadd, 0xfa4d, 0xfbeb,
    0xffc4, 0x049c, 0x093c, 0x0cd1, 0x0df0, 0x0bbe, 0x0720, 0x0132,
    0xfb80, 0xf83d, 0xf829, 0xfa85, 0xfe2a, 0x0134, 0x0299, 0x02ca,
    0x0269, 0x024e, 0x0235, 0x00cd, 0xfd57, 0xf876, 0xf43d, 0xf27f,
    0xf38d, 0xf663, 0xf9fe, 0xfddb, 0x0155, 0x0388, 0x040f, 0x0444,
    0x04ed, 0x04ae, 0x02f8, 0x0117, 0x004b, 0x0093, 0x02da, 0x072e,
    0x0b19, 0x0cfa, 0x0ce5, 0x09e4, 0x044f, 0xfe5f, 0xf8cc, 0xf468,
    0xf2f0, 0xf494, 0xf7d5, 0xfc12, 0x00ab, 0x03b6, 0x03f6, 0x027f,
    0x00b2, 0xff69, 0xfe67, 0xfd76, 0xfceb, 0xfd18, 0xfe80, 0xffd9,
    0x0033, 0x0074, 0x01d3, 0x03cd, 0x04c3, 0x0338, 0xfee1, 0xf991,
    0xf560, 0xf3fe, 0xf589, 0xf9c3, 0x005b, 0x0764, 0x0c45, 0x0ec6,
    0x0fb4, 0x0e7e, 0x0b63, 0x0734, 0x02a5, 0xfe55, 0xfa42, 0xf726,
    0xf693, 0xf90f, 0xfcee, 0x0001, 0x0192, 0x0175, 0xff84, 0xfc8b,
    0xfabb, 0xfb60, 0xfda4, 0x0103, 0x0404, 0x047c, 0x0270, 0xff24,
    0xfb79, 0xf7d8, 0xf596, 0xf54e, 0xf6d4, 0xfa2f, 0xff6d, 0x0605,
    0x0bea, 0x0e4e, 0x0bb0, 0x063d, 0x0123, 0xfe05, 0xfd2b, 0xfe59,
    0x0116, 0x04a3, 0x0792, 0x07c0, 0x04b5, 0x001b, 0xfbca, 0xf86a,
    0xf678, 0xf65b, 0xf7d7, 0xfb63, 0x00d0, 0x0615, 0x08c6, 0x0776,
    0x02a3, 0xfca8, 0xf869, 0xf6f8, 0xf7f9, 0xfb21, 0xff90, 0x0428,
    0x07a6, 0x08b4, 0x0714, 0x033a, 0xfe35, 0xf961, 0xf5de, 0xf41f,
    0xf4af, 0xf81b, 0xfd46, 0x0269, 0x05f7, 0x07c0, 0x0835, 0x074f,
    0x04c0, 0x015a, 0xff35, 0xff50, 0x00be, 0x023e, 0x02d2, 0x01b9,
    0xffeb, 0xfe90, 0xfe14, 0xffe3, 0x0419, 0x0794, 0x0849, 0x06d7,
    0x03e8, 0x0071, 0xfe0e, 0xfd20, 0xfced, 0xfcb4, 0xfbba, 0xf9fd,
    0xf8dd, 0xf975, 0xfb8d, 0xfe97, 0x0214, 0x0512, 0x0646, 0x0547,
    0x025c, 0xfe55, 0xfa82, 0xf7cc, 0xf6fc, 0xf8b6, 0xfc2a, 0x00b0,
    0x0573, 0x0809, 0x0753, 0x0501, 0x0398, 0x0413, 0x061b, 0x08b8,
    0x09d0, 0x0804, 0x0489, 0x00d6, 0xfd30, 0xf9c1, 0xf6e6, 0xf51e,
    0xf515, 0xf79c, 0xfcbe, 0x0208, 0x0482, 0x0374, 0xff8a, 0xfa8d,
    0xf6c1, 0xf5c0, 0xf72a, 0xf951, 0xfc3e, 0x0053, 0x04fa, 0x090d,
    0x0b49, 0x0a7d, 0x074e, 0x03d3, 0x01a1, 0x0221, 0x04a4, 0x068b,
    0x0639, 0x04bf, 0x03c2, 0x01f7, 0xff33, 0xfd6a, 0xfc83, 0xfa7a,
    0xf862, 0xf870, 0xfa03, 0xfcfc, 0x00d0, 0x04bc, 0x0612, 0x036a,
    0xfece, 0xfac1, 0xf904, 0xf9d3, 0xfbfd, 0xfcff, 0xfd3a, 0xff02,
    0x0193, 0x021d, 0x0144, 0x015b, 0x0158, 0xff9a, 0xfe16, 0xfe7e,
    0x0034, 0x02cd, 0x0565, 0x0590, 0x0377, 0x01d2, 0x00f7, 0xff6a,
    0xfd1d, 0xfbb0, 0xfb5c, 0xfc0b, 0xfdbe, 0x004f, 0x02ce, 0x033f,
    0x0196, 0xfffc, 0xffc2, 0x0079, 0x0237, 0x04ae, 0x0621, 0x064a,
    0x05d6, 0x04b4, 0x0316, 0x0172, 0x0012, 0xfe99, 0xfcc1, 0xfadc,
    0xf92d, 0xf7e2, 0xf76b, 0xf821, 0xfa4a, 0xfd28, 0xff99, 0x021c,
    0x04a0, 0x057f, 0x0438, 0x01d2, 0xff62, 0xfefe, 0x01f0, 0x0554,
    0x05cd, 0x03af, 0x00a6, 0xfddf, 0xfc7c, 0xfcba, 0xfd9b, 0xfe7c,
    0xff33, 0xff4b, 0xfe50, 0xfc1f, 0xf970, 0xf7df, 0xf8c1, 0xfbd3,
    0xffc5, 0x03ba, 0x06e7, 0x084f, 0x0781, 0x0499, 0x00f0, 0xfde5,
    0xfc53, 0xfce8, 0xff35, 0x01bb, 0x030b, 0x02ce, 0x023e, 0x029b,
    0x0380, 0x03b2, 0x0329, 0x0250, 0x00a8, 0xfdc2, 0xfaf8, 0xfa38,
    0xfb7e, 0xfdad, 0xffdd, 0x016c, 0x0184, 0x0027, 0xfe58, 0xfd41,
    0xfd9a, 0xffd7, 0x0353, 0x0596, 0x04e7, 0x01cb, 0xfdf5, 0xfae5,
    0xf921, 0xf8f5, 0xfa8e, 0xfd01, 0xff93, 0x027b, 0x04f1, 0x05ac,
    0x05d7, 0x06b6, 0x06b2, 0x0466, 0x0089, 0xfc52, 0xf906, 0xf86f,
    0xfb0b, 0xfee2, 0x0286, 0x0621, 0x08bd, 0x084e, 0x0469, 0xfeaf,
    0xf944, 0xf594, 0xf41e, 0xf518, 0xf80b, 0xfb7b, 0xfdb7, 0xfe72,
    0xfeb8, 0xffdc, 0x025d, 0x05ef, 0x09bc, 0x0d15, 0x0f91, 0x1010,
    0x0e42, 0x0a51, 0x04a9, 0xff26, 0xfacc, 0xf790, 0xf4e6, 0xf307,
    0xf3b4, 0xf774, 0xfcfa, 0x022f, 0x0593, 0x0673, 0x050d, 0x0242,
    0xff2a, 0xfc83, 0xfa94, 0xf96b, 0xf815, 0xf70a, 0xf7c7, 0xfa12,
    0xfdbb, 0x0261, 0x063b, 0x0874, 0x09b5, 0x08db, 0x0611, 0x0272,
    0xfde3, 0xfa5b, 0xf8b0, 0xf85e, 0xf93b, 0xfbc7, 0xff80, 0x0331,
    0x069d, 0x08f8, 0x098b, 0x0832, 0x0453, 0xfdcd, 0xf7d3, 0xf62b,
    0xf83f, 0xfbaf, 0xff85, 0x032c, 0x06a7, 0x0979, 0x0a6e, 0x092f,
    0x05f1, 0x00ae, 0xfb7b, 0xf883, 0xf702, 0xf6f6, 0xf9b7, 0xfd8b,
    0xff8d, 0x00a0, 0x0172, 0x00c5, 0xff84, 0xff83, 0x00b5, 0x027f,
    0x053d, 0x086d, 0x0aa7, 0x0aef, 0x080f, 0x028e, 0xfc68, 0xf6f1,
    0xf357, 0xf272, 0xf466, 0xf842, 0xfc7e, 0x0059, 0x03a6, 0x0655,
    0x083e, 0x08b8, 0x06f3, 0x03b0, 0x0033, 0xfd16, 0xfabb, 0xf95e,
    0xfa06, 0xfd55, 0x014d, 0x030f, 0x01da, 0xfe75, 0xfaf5, 0xf8ba,
    0xf81c, 0xf999, 0xfd01, 0x004b, 0x01d9, 0x021f, 0x017d, 0x0061,
    0x0025, 0x01e6, 0x04f6, 0x07b9, 0x090f, 0x0921, 0x08ad, 0x073d,
    0x0407, 0xff08, 0xf95c, 0xf5e0, 0xf642, 0xf9e8, 0xffa7, 0x0590,
    0x0944, 0x09bc, 0x07b8, 0x0451, 0x0053, 0xfc07, 0xf831, 0xf56c,
    0xf3c3, 0xf343, 0xf450, 0xf7a3, 0xfd0e, 0x02d0, 0x070b, 0x0994,
    0x0a2c, 0x08f4, 0x06f9, 0x047c, 0x0159, 0xfe4b, 0xfc7d, 0xfc7f,
    0xfda7, 0xfecf, 0x0020, 0x014d, 0x0141, 0x0008, 0xfeb2, 0xfd5c,
    0xfc55, 0xfce2, 0xfeda, 0x00b6, 0x0224, 0x0372, 0x03ee, 0x037b,
    0x02b9, 0x0188, 0x0056, 0x0022, 0x0009, 0xfefa, 0xfdd6, 0xfd9e,
    0xfe40, 0xfec8, 0xfe60, 0xfdf3, 0xfe61, 0xfedb, 0xfe79, 0xfd35,
    0xfbc5, 0xfba8, 0xfcd5, 0xfec9, 0x01bc, 0x061d, 0x0bb1, 0x1090,
    0x127e, 0x0efe, 0x07b5, 0xfff7, 0xf8ab, 0xf332, 0xef75, 0xeddf,
    0xef46, 0xf359, 0xf9c6, 0x0152, 0x0831, 0x0c08, 0x0d3b, 0x0c39,
    0x083a, 0x02af, 0xfdd2, 0xfa2d, 0xf706, 0xf54d, 0xf604, 0xf889,
    0xfc5d, 0x024e, 0x08e9, 0x0cdc, 0x0e45, 0x0db4, 0x0ad4, 0x057a,
    0xfeae, 0xf9a4, 0xf6d2, 0xf4c5, 0xf3cb, 0xf5ea, 0xfa59, 0xfeb8,
    0x02f1, 0x0677, 0x0827, 0x0720, 0x0332, 0xfd98, 0xf993, 0xf99f,
    0xfb75, 0xfbe0, 0xfb7a, 0xfbd2, 0xfd6e, 0x0062, 0x0450, 0x0789,
    0x0890, 0x0725, 0x03c4, 0xffcb, 0xfc5f, 0xfac6, 0xfb9c, 0xfdf0,
    0x00da, 0x0489, 0x07b0, 0x07c5, 0x0487, 0x0006, 0xfd2e, 0xfc9c,
    0xfd42, 0xfe7c, 0xffc2, 0x00aa, 0x00f6, 0x0121, 0x013e, 0x0074,
    0xfe18, 0xfb0b, 0xf959, 0xf92c, 0xf906, 0xf957, 0xfb2c, 0xfe37,
    0x018b, 0x0404, 0x0508, 0x059a, 0x067d, 0x0672, 0x0414, 0xffdd,
    0xfc1c, 0xfb72, 0xfe03, 0x0188, 0x0415, 0x0564, 0x05b2, 0x04be,
    0x031e, 0x01ab, 0x0034, 0xfead, 0xfd2b, 0xfb98, 0xfa3f, 0xf885,
    0xf6e2, 0xf7d1, 0xfc32, 0x0145, 0x04cb, 0x0734, 0x0819, 0x0742,
    0x042f, 0xfe56, 0xf809, 0xf3c2, 0xf2ee, 0xf6c1, 0xfe71, 0x0685,
    0x0b95, 0x0cf5, 0x0b04, 0x066a, 0x00e3, 0xfc4e, 0xfa28, 0xfa78,
    0xfb9e, 0xfbc7, 0xfb1b, 0xfaea, 0xfbca, 0xfda3, 0xffa1, 0x01a8,
    0x03cf, 0x0556, 0x060f, 0x069c, 0x0717, 0x0720, 0x074a, 0x075c,
    0x05b3, 0x01a5, 0xfd0b, 0xf95d, 0xf65e, 0xf49c, 0xf58c, 0xf9aa,
    0xff51, 0x0437, 0x06fa, 0x0798, 0x06f3, 0x0536, 0x0226, 0xfd7b,
    0xf79a, 0xf205, 0xeedb, 0xf051, 0xf69f, 0xff93, 0x090f, 0x115f,
    0x156a, 0x12e2, 0x0ada, 0x0105, 0xf8c9, 0xf384, 0xf1fe, 0xf42a,
    0xf8eb, 0xfee5, 0x03f8, 0x0722, 0x0843, 0x06ef, 0x0440, 0x0315,
    0x04c9, 0x06d2, 0x0672, 0x045c, 0x019f, 0xfebf, 0xfd24, 0xfd1d,
    0xfce3, 0xfa4e, 0xf672, 0xf50b, 0xf779, 0xfbd3, 0x001f, 0x0338,
    0x0438, 0x03d7, 0x0341, 0x01cc, 0xfe8e, 0xfb32, 0xf8ff, 0xf716,
    0xf634, 0xf8cd, 0xfe1a, 0x042d, 0x0af3, 0x10ca, 0x1342, 0x124c,
    0x0f2f, 0x0ae4, 0x05ea, 0x0035, 0xfa5d, 0xf53f, 0xf14a, 0xef80,
    0xf1c5, 0xf6c7, 0xfb80, 0xffaf, 0x045d, 0x0861, 0x097c, 0x06f4,
    0xffd0, 0xf5d4, 0xee57, 0xec73, 0xef74, 0xf630, 0xff92, 0x0832,
    0x0d99, 0x104a, 0x10ff, 0x0f5b, 0x0b03, 0x0519, 0xff1e, 0xf955,
    0xf5bc, 0xf733, 0xfc24, 0x00a5, 0x037e, 0x043b, 0x01cb, 0xfd84,
    0xfa75, 0xfa67, 0xfd94, 0x0321, 0x092f, 0x0dc3, 0x0ef4, 0x0c18,
    0x0648, 0xff23, 0xf7fa, 0xf203, 0xeee0, 0xefda, 0xf42a, 0xf994,
    0xfee6, 0x0377, 0x05f7, 0x065c, 0x0586, 0x0373, 0x0099, 0xfe87,
    0xfd8f, 0xfc87, 0xfb77, 0xfc96, 0x01c6, 0x08e7, 0x0e4b, 0x0fcb,
    0x0c86, 0x0562, 0xfcef, 0xf62a, 0xf24b, 0xf1fd, 0xf5a9, 0xfb17,
    0xff08, 0xffee, 0xfe37, 0xfae0, 0xf857, 0xf963, 0xfd77, 0x0251,
    0x0634, 0x086e, 0x090d, 0x0877, 0x0658, 0x039e, 0x0195, 0xff4b,
    0xfd0e, 0xfcf9, 0xff32, 0x01b3, 0x0349, 0x03d9, 0x0331, 0x022e,
    0x01c0, 0x01ea, 0x0281, 0x0265, 0xffae, 0xf9f9, 0xf42e, 0xf0c0,
    0xf134, 0xf652, 0xfe54, 0x0663, 0x0c05, 0x0e6e, 0x0e49, 0x0c61,
    0x08e6, 0x043a, 0xffc2, 0xfbbc, 0xf789, 0xf453, 0xf36c, 0xf460,
    0xf644, 0xf92e, 0xfd67, 0x0268, 0x0715, 0x09d7, 0x09c1, 0x07eb,
    0x0592, 0x022c, 0xfe37, 0xfb77, 0xfafd, 0xfb61, 0xfbe2, 0xfcb8,
    0xfd60, 0xff1f, 0x0329, 0x087d, 0x0b58, 0x0a4f, 0x0632, 0xffca,
    0xf9b9, 0xf626, 0xf465, 0xf374, 0xf4fd, 0xf8a3, 0xfca7, 0x014b,
    0x06c4, 0x0b02, 0x0bf2, 0x0b08, 0x0988, 0x06f3, 0x040d, 0x022c,
    0x0032, 0xfd0a, 0xf9ff, 0xf89f, 0xf897, 0xf98b, 0xfbac, 0xfd8e,
    0xff23, 0x025b, 0x0752, 0x0b31, 0x0bb8, 0x087e, 0x0205, 0xf9e8,
    0xf26f, 0xee88, 0xefaa, 0xf49a, 0xfb08, 0x009e, 0x041a, 0x0630,
    0x0765, 0x084d, 0x0988, 0x0a29, 0x09b2, 0x08dc, 0x0756, 0x043f,
    0xff70, 0xf9e8, 0xf518, 0xf1f1, 0xf12c, 0xf30f, 0xf821, 0x0087,
    0x09fd, 0x1031, 0x1172, 0x0dfd, 0x0559, 0xf8eb, 0xed9a, 0xe8c8,
    0xeb40, 0xf252, 0xfb5c, 0x0478, 0x0bf5, 0x10bc, 0x1305, 0x125b,
    0x0e35, 0x07a8, 0x00c0, 0xfa67, 0xf520, 0xf2ee, 0xf4c7, 0xf95a,
    0xfe56, 0x025a, 0x0499, 0x0450, 0x0200, 0xff4a, 0xfe4e, 0x0042,
    0x03ec, 0x0663, 0x067c, 0x0472, 0x004f, 0xfb04, 0xf6c1, 0xf4f2,
    0xf551, 0xf832, 0xfd8a, 0x03dd, 0x08ea, 0x0b94, 0x0b78, 0x0879,
    0x03b1, 0xfe83, 0xf9c7, 0xf5d3, 0xf38e, 0xf3cf, 0xf6ac, 0xfb14,
    0xffd9, 0x0547, 0x0ac0, 0x0d97, 0x0c00, 0x071d, 0x0138, 0xfc1c,
    0xf96f, 0xf9b9, 0xfbcb, 0xfde2, 0xff2a, 0xfeae, 0xfc36, 0xf95a,
    0xf831, 0xf981, 0xfc63, 0xffad, 0x01c9, 0x0322, 0x0563, 0x086e,
    0x0a7a, 0x099c, 0x0570, 0xff50, 0xfa9b, 0xfa30, 0xfd3a, 0x0183,
    0x0617, 0x09c5, 0x0af0, 0x08ef, 0x0479, 0xff3c, 0xfa47, 0xf672,
    0xf420, 0xf354, 0xf467, 0xf7d5, 0xfd2d, 0x026a, 0x059a, 0x06d3,
    0x0700, 0x05f6, 0x03e0, 0x01f9, 0x00e9, 0x0066, 0x0030, 0x0030,
    0x009a, 0x013e, 0x01bf, 0x0157, 0xff98, 0xfd57, 0xfbc3, 0xfb15,
    0xfad8, 0xfbc7, 0xfe9e, 0x026f, 0x0527, 0x056c, 0x0334, 0xff95,
    0xfb9f, 0xf844, 0xf6c7, 0xf7d3, 0xfaa1, 0xfd63, 0x00ab, 0x0567,
    0x09c7, 0x0c35, 0x0cb6, 0x0ad8, 0x0641, 0x0016, 0xf9a1, 0xf3e7,
    0xf0c0, 0xf1ac, 0xf5f0, 0xfc0a, 0x0229, 0x068e, 0x08f9, 0x0a2d,
    0x0a0c, 0x07bb, 0x03cc, 0xfed9, 0xf9a5, 0xf60b, 0xf746, 0xfd7e,
    0x052c, 0x0b64, 0x0e7d, 0x0e39, 0x0a89, 0x051d, 0xffb3, 0xfaf9,
    0xf853, 0xf648, 0xf2e8, 0xf09c, 0xf1ce, 0xf4fc, 0xf7fa, 0xfaa8,
    0xfd82, 0x0071, 0x0401, 0x0843, 0x0c54, 0x0e7d, 0x0cd1, 0x0781,
    0x00a9, 0xfbd7, 0xfa21, 0xfb48, 0xfe8d, 0x01f1, 0x0373, 0x0271,
    0xffc6, 0xfe28, 0xfebc, 0xff9b, 0x00c4, 0x0174, 0x015e, 0x01af,
    0x02e0, 0x02df, 0x0055, 0xfd5b, 0xfb70, 0xfaf3, 0xfbde, 0xfca9,
    0xfc40, 0xfcc3, 0x0023, 0x0418, 0x057e, 0x0455, 0x0130, 0xfdb8,
    0xfc17, 0xfcb0, 0xfe61, 0x0052, 0x0231, 0x0371, 0x0357, 0x0153,
    0xfe32, 0xfb85, 0xfa19, 0xfa61, 0xfd77, 0x01fe, 0x056a, 0x06d5,
    0x068d, 0x0505, 0x0251, 0xff40, 0xfcd5, 0xfb8a, 0xfbde, 0xfe20,
    0x021d, 0x06a6, 0x0913, 0x0845, 0x05a9, 0x027a, 0xfe57, 0xf9b8,
    0xf61d, 0xf35b, 0xf22a, 0xf3fc, 0xf882, 0xfe5f, 0x043d, 0x0920,
    0x0b90, 0x0ad7, 0x0730, 0x022e, 0xfe35, 0xfb95, 0xf94f, 0xf73e,
    0xf5e8, 0xf5f7, 0xf7fe, 0xfb1b, 0xfe64, 0x0288, 0x07ae, 0x0c11,
    0x0d1e, 0x0998, 0x02eb, 0xfc12, 0xf78a, 0xf705, 0xfa78, 0x0086,
    0x073e, 0x0cdd, 0x0fad, 0x0d38, 0x05ba, 0xfce7, 0xf72f, 0xf685,
    0xf91d, 0xfd05, 0x0133, 0x0477, 0x0662, 0x062b, 0x032b, 0xfe77,
    0xf98c, 0xf663, 0xf6b3, 0xfa87, 0x0025, 0x04ef, 0x075b, 0x067e,
    0x0224, 0xfdab, 0xfb20, 0xf8c5, 0xf6c9, 0xf62f, 0xf77e, 0xfb33,
    0x01a7, 0x087b, 0x0cc2, 0x0ec3, 0x0daf, 0x0849, 0xffda, 0xf86d,
    0xf45d, 0xf338, 0xf4b9, 0xf968, 0x0173, 0x0a8e, 0x116d, 0x1323,
    0x0e28, 0x0436, 0xf94e, 0xf078, 0xebe5, 0xed9c, 0xf436, 0xfb9e,
    0x02b9, 0x09ee, 0x0ea5, 0x0f67, 0x0d92, 0x08f6, 0x014f, 0xf9b6,
    0xf520, 0xf32c, 0xf31c, 0xf5ed, 0xfb56, 0x0037, 0x02eb, 0x048b,
    0x04f5, 0x038e, 0x01bf, 0x0066, 0xfea5, 0xfd32, 0xfed3, 0x0450,
    0x0aed, 0x0f97, 0x1091, 0x0c89, 0x057d, 0xff31, 0xfac7, 0xf676,
    0xf176, 0xeee8, 0xf177, 0xf83f, 0x003b, 0x0682, 0x091d, 0x0896,
    0x0657, 0x02a8, 0xfdcf, 0xf9d2, 0xf798, 0xf5b2, 0xf42b, 0xf4fa,
    0xf8ad, 0xfe77, 0x05f1, 0x0d01, 0x10d9, 0x10af, 0x0d2e, 0x072d,
    0x007a, 0xf954, 0xf399, 0xf21c, 0xf3ba, 0xf6e3, 0xfc08, 0x0338,
    0x0a40, 0x0fc4, 0x120c, 0x0e14, 0x03f6, 0xf71f, 0xeb85, 0xe554,
    0xe7b9, 0xf0ee, 0xfb4a, 0x04bf, 0x0d0d, 0x1286, 0x13d2, 0x10c4,
    0x0ad0, 0x044b, 0xff3b, 0xfc3e, 0xfb8f, 0xfc12, 0xfc74, 0xfd5d,
    0xfe79, 0xfe29, 0xfcf3, 0xfb85, 0xf8f3, 0xf6ab, 0xf82f, 0xfddb,
    0x04f2, 0x0b3f, 0x0f11, 0x0f1f, 0x0b94, 0x053f, 0xfdaa, 0xf7b6,
    0xf520, 0xf523, 0xf79a, 0xfced, 0x025b, 0x04d3, 0x04f4, 0x03f5,
    0x017d, 0xfe0b, 0xfa67, 0xf6f1, 0xf536, 0xf695, 0xfa8d, 0xff73,
    0x0417, 0x0856, 0x0c91, 0x0fb3, 0x0ed2, 0x096a, 0x0193, 0xfa24,
    0xf580, 0xf523, 0xf872, 0xfcb3, 0x000a, 0x01f5, 0x01c8, 0xff41,
    0xfb7d, 0xf84f, 0xf6b7, 0xf72a, 0xfa09, 0xfe7e, 0x041b, 0x0a9f,
    0x1123, 0x1551, 0x138d, 0x0bbf, 0x0251, 0xfb5f, 0xf73f, 0xf601,
    0xf88e, 0xfd07, 0x0166, 0x0513, 0x0666, 0x046a, 0x00d0, 0xfd45,
    0xf9bb, 0xf6b1, 0xf53c, 0xf598, 0xf6f7, 0xf9d9, 0xfe75, 0x02c9,
    0x058c, 0x0688, 0x05a5, 0x02ac, 0xff31, 0xfd6b, 0xfda5, 0xff5b,
    0x026d, 0x062f, 0x07f6, 0x05e8, 0x0166, 0xfc5e, 0xf81b, 0xf633,
    0xf779, 0xfb88, 0x0110, 0x05dc, 0x0820, 0x07f9, 0x0680, 0x045a,
    0x01b3, 0xfdff, 0xf8f8, 0xf4ce, 0xf421, 0xf723, 0xfcad, 0x03af,
    0x0a33, 0x0e34, 0x0f5c, 0x0d52, 0x076d, 0xfef6, 0xf676, 0xefde,
    0xecb4, 0xee79, 0xf4dc, 0xfd2e, 0x0481, 0x0978, 0x0b85, 0x0ad1,
    0x08cc, 0x065e, 0x0375, 0x001a, 0xfcf7, 0xfc24, 0xff13, 0x0383,
    0x06cb, 0x07b6, 0x05ea, 0x020b, 0xfdcd, 0xfa83, 0xf734, 0xf455,
    0xf482, 0xf7a5, 0xfb77, 0xfe8a, 0x00f1, 0x0343, 0x0537, 0x06b5,
    0x06eb, 0x04f8, 0x01a8, 0xfe09, 0xfae8, 0xf8d3, 0xf875, 0xf9ed,
    0xfd6a, 0x02ba, 0x0837, 0x0c7b, 0x0e8c, 0x0d39, 0x091f, 0x02eb,
    0xfbac, 0xf5fc, 0xf2f8, 0xf24c, 0xf430, 0xf980, 0x0146, 0x0958,
    0x0ef0, 0x0f4b, 0x0997, 0xff6d, 0xf3e1, 0xeaeb, 0xe857, 0xed7a,
    0xf6ea, 0x0055, 0x086b, 0x0ea5, 0x125c, 0x1342, 0x1139, 0x0be4,
    0x043d, 0xfc17, 0xf511, 0xf101, 0xf14b, 0xf520, 0xfab3, 0x0014,
    0x03ec, 0x0646, 0x063e, 0x0332, 0xff2c, 0xfdb7, 0xff44, 0x01e3,
    0x0488, 0x0680, 0x06cc, 0x04e1, 0x0167, 0xfdb6, 0xfbb3, 0xfc02,
    0xfdc1, 0x0006, 0x0220, 0x02ad, 0x00d4, 0xfdf6, 0xfb6a, 0xfa0f,
    0xfa19, 0xfa8a, 0xfaac, 0xfb8c, 0xfdae, 0xffff, 0x0290, 0x0558,
    0x0788, 0x08b5, 0x0859, 0x059c, 0x00e8, 0xfc76, 0xf9ed, 0xf980,
    0xfa63, 0xfb49, 0xfc21, 0xfec4, 0x02f0, 0x05ab, 0x0541, 0x02fb,
    0x0025, 0xfca2, 0xf9c7, 0xf8d8, 0xfa63, 0xfdf2, 0x02df, 0x0817,
    0x0a2f, 0x06ea, 0x0062, 0xfc02, 0xfc30, 0xfec9, 0x0226, 0x053e,
    0x0653, 0x05ae, 0x045e, 0x019b, 0xfe67, 0xfcc5, 0xfc79, 0xfc51,
    0xfce4, 0xfe58, 0xff03, 0xfeb1, 0xfe3b, 0xfd80, 0xfca2, 0xfce6,
    0xfddc, 0xfd9d, 0xfcb5, 0xfc8f, 0xfd80, 0xffaa, 0x02b4, 0x0638,
    0x0919, 0x090d, 0x055b, 0x0087, 0xfd36, 0xfc60, 0xfd3c, 0xfeb1,
    0x00d2, 0x0314, 0x03aa, 0x025e, 0x00ce, 0xfef7, 0xfce8, 0xfb7a,
    0xf9f4, 0xf88b, 0xf964, 0xfd00, 0x0112, 0x0486, 0x07ad, 0x093b,
    0x0877, 0x0672, 0x03bd, 0xffab, 0xfadf, 0xf72d, 0xf59f, 0xf692,
    0xfa0e, 0xff69, 0x041b, 0x0603, 0x0579, 0x03fb, 0x01eb, 0xff89,
    0xfe8c, 0xfeb6, 0xfe42, 0xfd74, 0xfe8c, 0x019e, 0x0468, 0x06b3,
    0x0865, 0x0854, 0x05ed, 0x01a1, 0xfcf0, 0xf9c8, 0xf943, 0xfa22,
    0xfaf9, 0xfb7f, 0xfbdf, 0xfccd, 0xfe74, 0xfff7, 0x005e, 0xff75,
    0xfe2e, 0xfdc2, 0xfe83, 0x0000, 0x01a9, 0x0382, 0x059b, 0x0759,
    0x0798, 0x0670, 0x058a, 0x05b7, 0x04ac, 0x012d, 0xfc7e, 0xf70d,
    0xf1da, 0xefb8, 0xf1f1, 0xf6d6, 0xfd98, 0x05ec, 0x0d3a, 0x1026,
    0x0cf0, 0x03e4, 0xf801, 0xefb8, 0xef0c, 0xf3dd, 0xfb73, 0x040f,
    0x0bee, 0x1102, 0x124e, 0x0f6b, 0x08a8, 0x0086, 0xf96a, 0xf4f3,
    0xf367, 0xf447, 0xf7d1, 0xfd68, 0x0146, 0x0266, 0x0374, 0x03d4,
    0x012c, 0xfd4f, 0xfc0e, 0xfd71, 0x003b, 0x03e9, 0x071a, 0x0830,
    0x0673, 0x0235, 0xfd04, 0xf933, 0xf825, 0xfa06, 0xfe82, 0x03dd,
    0x07a5, 0x0901, 0x07eb, 0x043b, 0xff8b, 0xfb93, 0xf885, 0xf693,
    0xf641, 0xf817, 0xfba5, 0xff5c, 0x0249, 0x0573, 0x0950, 0x0b66,
    0x09c6, 0x0525, 0xffac, 0xfb1a, 0xf84f, 0xf7e9, 0xf9b0, 0xfd10,
    0x00df, 0x027d, 0x0091, 0xfc98, 0xf8d0, 0xf6f3, 0xf80e, 0xfbf6,
    0x0053, 0x0395, 0x063b, 0x0866, 0x09be, 0x097a, 0x06a2, 0x0233,
    0xfe49, 0xfbf5, 0xfbf8, 0xfe33, 0x0137, 0x03f2, 0x059a, 0x04f9,
    0x02c9, 0x00e6, 0xff77, 0xfee2, 0xffb8, 0x0016, 0xfdb2, 0xf93b,
    0xf60f, 0xf5f9, 0xf8e9, 0xfe9c, 0x057d, 0x0a6e, 0x0b6a, 0x08f9,
    0x0517, 0x0160, 0xfde0, 0xfb61, 0xfaf5, 0xfbd0, 0xfc23, 0xfbab,
    0xfb54, 0xfba3, 0xfc66, 0xfd76, 0xfff4, 0x03de, 0x0783, 0x097d,
    0x0938, 0x0614, 0x00aa, 0xfc2b, 0xfa22, 0xf947, 0xf912, 0xf9b7,
    0xfacd, 0xfbd6, 0xfda2, 0x0178, 0x0608, 0x099e, 0x0b2e, 0x0969,
    0x051a, 0x0043, 0xfbcf, 0xf7e3, 0xf57b, 0xf648, 0xf988, 0xfc72,
    0xfedd, 0x0240, 0x05f7, 0x0900, 0x0c28, 0x0f34, 0x0f71, 0x0b4d,
    0x0459, 0xfd46, 0xf724, 0xf314, 0xf2d3, 0xf55d, 0xf851, 0xfa90,
    0xfc43, 0xfe02, 0x002e, 0x027f, 0x0421, 0x03b1, 0x00a8, 0xfc9c,
    0xf9ae, 0xf8c6, 0xfa1b, 0xfe21, 0x0335, 0x075f, 0x09a8, 0x09d0,
    0x077c, 0x0351, 0xffaa, 0xfd02, 0xfb39, 0xfb63, 0xfe31, 0x033d,
    0x0788, 0x077d, 0x0403, 0xfec5, 0xf85f, 0xf2cd, 0xf198, 0xf589,
    0xfc9a, 0x055b, 0x0e58, 0x14a3, 0x147c, 0x0c8f, 0xfeeb, 0xf0de,
    0xe856, 0xe7b1, 0xecff, 0xf51d, 0xfe79, 0x0741, 0x0ce0, 0x0e6e,
    0x0cbb, 0x0996, 0x0571, 0x00d2, 0xfcdf, 0xf9c2, 0xf86d, 0xf9fb,
    0xfcef, 0xfedc, 0x008f, 0x028e, 0x0326, 0x0216, 0x013b, 0x0242,
    0x045b, 0x05ec, 0x0618, 0x053c, 0x0368, 0xffed, 0xfb76, 0xf812,
    0xf68c, 0xf6bd, 0xf9ee, 0x0009, 0x0621, 0x0996, 0x0a0f, 0x0756,
    0x0365, 0x007e, 0xfd81, 0xfaa7, 0xf8f2, 0xf90d, 0xfa54, 0xfb71,
    0xfc97, 0xfece, 0x03a8, 0x0974, 0x0c97, 0x0b3c, 0x0602, 0xff28,
    0xf94c, 0xf673, 0xf5e8, 0xf720, 0xfa14, 0xfd76, 0xff8b, 0xffe0,
    0xff34, 0xfee6, 0xff72, 0x00ad, 0x0258, 0x02f6, 0x029c, 0x02d5,
    0x03dc, 0x031a, 0xff64, 0xfb7b, 0xf9f0, 0xfaa7, 0xfc9c, 0x0053,
    0x049a, 0x07b8, 0x0a58, 0x0bfb, 0x0a6d, 0x05ee, 0x0112, 0xfced,
    0xfa81, 0xf9ca, 0xf997, 0xf92e, 0xf89b, 0xf9c8, 0xfc4e, 0xfe8b,
    0x00de, 0x038d, 0x0509, 0x0422, 0x01ae, 0xffbc, 0xfef9, 0xfec9,
    0x0066, 0x03f6, 0x0646, 0x0503, 0x01f2, 0xfee1, 0xfc4b, 0xfac3,
    0xfb2e, 0xfdfb, 0x0184, 0x04a7, 0x062d, 0x044e, 0xff85, 0xfa9e,
    0xf742, 0xf4d5, 0xf3f9, 0xf5e6, 0xf9ad, 0xfde9, 0x0256, 0x0689,
    0x0977, 0x0b1e, 0x0bb4, 0x0a22, 0x05eb, 0x0144, 0xfe06, 0xfb68,
    0xf967, 0xf998, 0xfbb0, 0xfd24, 0xfd45, 0xfe41, 0x0050, 0x0239,
    0x051f, 0x098a, 0x0d48, 0x0d50, 0x095f, 0x0347, 0xfd03, 0xf8ce,
    0xf7f3, 0xf9b2, 0xfb76, 0xfad0, 0xf94c, 0xfa2d, 0xfcd8, 0xff88,
    0x01b4, 0x0283, 0x00c4, 0xfd6a, 0xfa8b, 0xf8ef, 0xf92f, 0xfb32,
    0xfda5, 0x0018, 0x0318, 0x0690, 0x096e, 0x0b3c, 0x0b7f, 0x091e,
    0x0486, 0xff5d, 0xfc3b, 0xfd23, 0xff7f, 0x0035, 0xff03, 0xfbd5,
    0xf711, 0xf3e3, 0xf565, 0xfa1f, 0xfffa, 0x06f9, 0x0d99, 0x11d3,
    0x121f, 0x0c2f, 0x0086, 0xf3bf, 0xeb26, 0xe905, 0xece7, 0xf4f2,
    0xfee4, 0x0877, 0x0eef, 0x1066, 0x0d54, 0x0851, 0x02bf, 0xfd8b,
    0xfa02, 0xf7fa, 0xf748, 0xf8d2, 0xfbe5, 0xff4a, 0x0313, 0x058a,
    0x0417, 0xffd5, 0xfc89, 0xfc7d, 0xff74, 0x0387, 0x06cd, 0x082f,
    0x0768, 0x04a0, 0x005c, 0xfc0e, 0xf86d, 0xf5a2, 0xf541, 0xf881,
    0xfdd6, 0x037f, 0x089c, 0x0b02, 0x09e4, 0x069e, 0x0205, 0xfcd9,
    0xf8ee, 0xf751, 0xf794, 0xf917, 0xfba3, 0x004f, 0x07e5, 0x0f5a,
    0x1257, 0x1004, 0x0987, 0xffe2, 0xf60a, 0xf01d, 0xef22, 0xf248,
    0xf891, 0xff11, 0x01cc, 0xffaa, 0xfb88, 0xf907, 0xfaf4, 0x00ec,
    0x0715, 0x0a38, 0x09d5, 0x075b, 0x0443, 0x018e, 0xfed4, 0xfbaa,
    0xf912, 0xf82d, 0xf997, 0xfd4a, 0x025e, 0x0714, 0x0a42, 0x0a52,
    0x06df, 0x0282, 0xfeeb, 0xfc3b, 0xfa93, 0xfa06, 0xf925, 0xf75a,
    0xf767, 0xfb05, 0x00a8, 0x061c, 0x0a20, 0x0aeb, 0x078b, 0x02cd,
    0xffea, 0x000c, 0x0230, 0x03c9, 0x025e, 0xfeac, 0xfb1e, 0xf8b1,
    0xf7ee, 0xf964, 0xfd0d, 0x0174, 0x055d, 0x0821, 0x0953, 0x0877,
    0x050f, 0x0044, 0xfbec, 0xf855, 0xf645, 0xf5e5, 0xf692, 0xf815,
    0xf9c6, 0xfbdb, 0xffa4, 0x05ad, 0x0b29, 0x0d43, 0x0b7c, 0x0646,
    0xff8f, 0xfa78, 0xf89b, 0xf968, 0xfb9b, 0xfcb0, 0xfb5c, 0xf94f,
    0xf91c, 0xfc33, 0x0231, 0x09d8, 0x10aa, 0x133c, 0x10f0, 0x0c48,
    0x0779, 0x0307, 0xfe64, 0xf957, 0xf598, 0xf4ea, 0xf6e9, 0xfad2,
    0xfee9, 0x00d3, 0x004e, 0xff31, 0xfec9, 0xff26, 0xff5f, 0xfcd5,
    0xf72a, 0xf1dc, 0xf110, 0xf5b1, 0xfe78, 0x097b, 0x11dc, 0x13a8,
    0x0ff1, 0x09b7, 0x03be, 0x0031, 0xff80, 0xffe5, 0xfeae, 0xfb09,
    0xf5fd, 0xf1d8, 0xf192, 0xf62d, 0xfdc8, 0x05a8, 0x0bd9, 0x0f0c,
    0x0e07, 0x09a2, 0x048e, 0x005d, 0xfc93, 0xf8ef, 0xf6b9, 0xf6fd,
    0xf9c7, 0xfe1c, 0x0121, 0x0153, 0x009d, 0xfff2, 0xfead, 0xfd91,
    0xfd73, 0xfd89, 0xfe2c, 0xff6a, 0x0068, 0x015b, 0x0260, 0x020f,
    0xfecd, 0xfa4c, 0xf789, 0xf872, 0xfb93, 0xff1d, 0x037b, 0x0878,
    0x0bd3, 0x0bf2, 0x0aab, 0x07e3, 0x0297, 0xfcbd, 0xf8e4, 0xf708,
    0xf6bc, 0xf98a, 0xfe3f, 0x028b, 0x0663, 0x0936, 0x0997, 0x07aa,
    0x056c, 0x035f, 0x0080, 0xfcdc, 0xfa51, 0xfaa5, 0xfcda, 0xfeda,
    0xff83, 0xff3c, 0xfec1, 0xfe76, 0xfe75, 0xfe00, 0xfd29, 0xfce3,
    0xfced, 0xfba1, 0xf807, 0xf375, 0xf10c, 0xf347, 0xfa17, 0x033f,
    0x0baa, 0x116d, 0x13bf, 0x1220, 0x0d51, 0x066e, 0xfe4d, 0xf6d4,
    0xf365, 0xf4fe, 0xf965, 0xff27, 0x056c, 0x0a47, 0x0b3a, 0x07c0,
    0x01e2, 0xfcb6, 0xf9ee, 0xf936, 0xf9c9, 0xfb2b, 0xfc80, 0xfc5a,
    0xfb31, 0xfb39, 0xfd91, 0x0144, 0x0469, 0x0632, 0x067a, 0x05c8,
    0x0699, 0x09a7, 0x0bd5, 0x09e7, 0x03de, 0xfbc6, 0xf37c, 0xedfe,
    0xed9a, 0xf1f3, 0xf990, 0x02a1, 0x0a75, 0x0e73, 0x0e7c, 0x0c1f,
    0x084b, 0x035d, 0xfeab, 0xfb34, 0xf801, 0xf50c, 0xf450, 0xf5e0,
    0xf785, 0xfa43, 0x0009, 0x05a1, 0x078e, 0x0750, 0x0657, 0x0320,
    0xfe5a, 0xfba4, 0xfc49, 0xfdf9, 0xfefb, 0xff1d, 0xfda1, 0xfae0,
    0xf98f, 0xfb5e, 0x00a4, 0x087e, 0x0f83, 0x1230, 0x1032, 0x0b9b,
    0x0655, 0x0199, 0xfe2f, 0xfb4b, 0xf73e, 0xf36f, 0xf390, 0xf80d,
    0xfdef, 0x02b6, 0x04fa, 0x0567, 0x054d, 0x047b, 0x023b, 0xfe49,
    0xf8af, 0xf2bc, 0xef17, 0xef1c, 0xf20d, 0xf741, 0xff53, 0x0842,
    0x0e32, 0x103d, 0x0f54, 0x0d1d, 0x0b39, 0x090b, 0x0527, 0xff05,
    0xf798, 0xf109, 0xee13, 0xefa0, 0xf499, 0xfc11, 0x050f, 0x0e0e,
    0x1530, 0x1862, 0x14e3, 0x0a82, 0xfd08, 0xf16f, 0xeaa7, 0xe957,
    0xed42, 0xf4bd, 0xfd50, 0x0435, 0x0864, 0x0a7f, 0x0aae, 0x085b,
    0x03a6, 0xfdad, 0xf86c, 0xf649, 0xf74b, 0xf96d, 0xfc56, 0x0028,
    0x0220, 0x005b, 0xfd7a, 0xfcfe, 0xffa8, 0x044b, 0x08c2, 0x0b77,
    0x0c3e, 0x0b15, 0x07c8, 0x02f8, 0xfdc2, 0xf83e, 0xf319, 0xf0b1,
    0xf292, 0xf7ad, 0xfe25, 0x0480, 0x0928, 0x0b84, 0x0bca, 0x0a99,
    0x08b4, 0x0633, 0x031e, 0xffae, 0xfbc0, 0xf7d2, 0xf6a2, 0xf9d9,
    0xfe86, 0x01ac, 0x028e, 0x00df, 0xfda5, 0xfad5, 0xf906, 0xf83b,
    0xfa33, 0xfe59, 0x0111, 0x00c5, 0xfe6b, 0xfb04, 0xf865, 0xfa35,
    0x0113, 0x08ce, 0x0e82, 0x1177, 0x0fe8, 0x0a2d, 0x0311, 0xfc9b,
    0xf77d, 0xf3e7, 0xf27d, 0xf46d, 0xf965, 0xff8b, 0x0575, 0x09ba,
    0x0b3d, 0x09f0, 0x06a0, 0x02ec, 0x00a2, 0xfffe, 0xff53, 0xfced,
    0xf962, 0xf64d, 0xf3f2, 0xf3d6, 0xf833, 0xff47, 0x0482, 0x0658,
    0x0689, 0x0688, 0x061a, 0x0551, 0x0535, 0x054d, 0x0417, 0x009f,
    0xfb89, 0xf6f6, 0xf4dd, 0xf66d, 0xfbd2, 0x0393, 0x0b6c, 0x10d0,
    0x11d3, 0x0e15, 0x0773, 0xff3d, 0xf5dd, 0xee6e, 0xebea, 0xedd9,
    0xf201, 0xf731, 0xfc79, 0x0183, 0x06d5, 0x0c05, 0x0f13, 0x0d61,
    0x07ef, 0x0259, 0xfe2b, 0xfa71, 0xf7cc, 0xf7ac, 0xf82a, 0xf799,
    0xf784, 0xf9b1, 0xfcda, 0xff65, 0x02d6, 0x07f8, 0x0daa, 0x113b,
    0x1024, 0x0a5c, 0x0241, 0xfb56, 0xf824, 0xf985, 0xfd93, 0x0169,
    0x043b, 0x064d, 0x06e3, 0x060a, 0x0526, 0x03f0, 0x00c7, 0xfb9f,
    0xf648, 0xf21e, 0xefa2, 0xef6d, 0xf1f1, 0xf6a8, 0xfd09, 0x03bf,
    0x0864, 0x0a8e, 0x0ab0, 0x08bc, 0x04f6, 0x0113, 0xff9f, 0x0118,
    0x0295, 0x0202, 0x0017, 0xfd0a, 0xf81b, 0xf2f3, 0xf156, 0xf4db,
    0xfcc8, 0x06ba, 0x0ff9, 0x161b, 0x1737, 0x1217, 0x06cc, 0xfa9b,
    0xf255, 0xee36, 0xef11, 0xf48d, 0xfc1a, 0x02b8, 0x06c0, 0x080a,
    0x0816, 0x08cc, 0x0871, 0x04d5, 0xfe2a, 0xf638, 0xefeb, 0xedc4,
    0xeef4, 0xf2ed, 0xfb50, 0x0472, 0x08de, 0x086d, 0x05f9, 0x034b,
    0x0154, 0x01be, 0x04ed, 0x08df, 0x0a82, 0x0856, 0x0366, 0xfe56,
    0xfa56, 0xf785, 0xf6e3, 0xf91d, 0xfd61, 0x0278, 0x0764, 0x0a95,
    0x0b33, 0x0944, 0x0544, 0x009f, 0xfd0f, 0xface, 0xf94b, 0xf825,
    0xf782, 0xf934, 0xfe5c, 0x0489, 0x08f4, 0x0abf, 0x097c, 0x04f9,
    0xfe45, 0xf758, 0xf255, 0xf171, 0xf57a, 0xfb2b, 0xfe33, 0xfd8d,
    0xfb21, 0xf961, 0xfa72, 0xff99, 0x06f7, 0x0ce4, 0x0eff, 0x0e52,
    0x0b67, 0x05a0, 0xfe83, 0xf875, 0xf57e, 0xf647, 0xfaad, 0x00d8,
    0x05f8, 0x08ef, 0x0960, 0x0768, 0x041d, 0x00be, 0xfd76, 0xfa8a,
    0xf9f7, 0xfbc6, 0xfd84, 0xfd92, 0xfd23, 0xfd5d, 0xfcfe, 0xfc12,
    0xfc71, 0xfdcb, 0xfe75, 0xffe4, 0x03ce, 0x0821, 0x0ac7, 0x0bb1,
    0x0a32, 0x05ba, 0xffc3, 0xfa1d, 0xf5d3, 0xf3a7, 0xf4e1, 0xf97d,
    0xff45, 0x04ba, 0x09be, 0x0c76, 0x0af4, 0x0662, 0x00fb, 0xfbe8,
    0xf750, 0xf3fb, 0xf313, 0xf474, 0xf777, 0xfbe4, 0x0049, 0x0367,
    0x0640, 0x0900, 0x0a78, 0x097c, 0x05ec, 0x0059, 0xfa2b, 0xf4ef,
    0xf163, 0xf107, 0xf4b6, 0xfa95, 0x00d0, 0x0748, 0x0ce5, 0x0fd4,
    0x0fa4, 0x0cfd, 0x08e2, 0x04c7, 0x0173, 0xfe66, 0xfc11, 0xfb5f,
    0xfb5b, 0xfbcf, 0xfdc3, 0x00b5, 0x01fe, 0x005d, 0xfe63, 0xfd9a,
    0xfd97, 0xfe84, 0xff65, 0xfe5c, 0xfb80, 0xf927, 0xf8d8, 0xfaa4,
    0xfd99, 0x0064, 0x0276, 0x033b, 0x02eb, 0x01b0, 0x00a9, 0x0264,
    0x06d5, 0x0aaf, 0x0be3, 0x0a7d, 0x0691, 0xfff6, 0xf705, 0xef02,
    0xeb4c, 0xec49, 0xf159, 0xfa53, 0x057c, 0x0f6f, 0x158a, 0x1712,
    0x13a4, 0x0b5a, 0xfff7, 0xf41e, 0xeb41, 0xe8ed, 0xee1f, 0xf7de,
    0x0275, 0x0ba3, 0x10f5, 0x109b, 0x0b67, 0x03b6, 0xfc58, 0xf781,
    0xf539, 0xf4c8, 0xf60b, 0xf8e2, 0xfccc, 0xffce, 0x00cf, 0x01d0,
    0x0495, 0x0691, 0x04f6, 0x01af, 0xffe0, 0x003e, 0x0271, 0x05d9,
    0x08a5, 0x08e3, 0x05ab, 0x0002, 0xfa26, 0xf570, 0xf2bb, 0xf34d,
    0xf7b8, 0xfeef, 0x06f3, 0x0d69, 0x1010, 0x0de2, 0x082e, 0x01f6,
    0xfced, 0xf947, 0xf795, 0xf836, 0xfa52, 0xfc5d, 0xfdc8, 0xffa4,
    0x023e, 0x044d, 0x050b, 0x03e2, 0x0073, 0xfc14, 0xf8c8, 0xf74a,
    0xf778, 0xf9d7, 0xfd87, 0x005f, 0x016c, 0x0163, 0x0192, 0x0260,
    0x03ad, 0x052e, 0x05f9, 0x05d3, 0x0596, 0x055d, 0x0417, 0x0156,
    0xfd9b, 0xf947, 0xf652, 0xf76f, 0xfc8b, 0x038b, 0x0a5e, 0x0eed,
    0x0f60, 0x0b06, 0x03a2, 0xfb5f, 0xf46c, 0xf14e, 0xf2b0, 0xf6f1,
    0xfb3b, 0xfe64, 0x0016, 0xff3d, 0xfc19, 0xf9b3, 0xf955, 0xfa0b,
    0xfccf, 0x0273, 0x0913, 0x0dc9, 0x1012, 0x1009, 0x0d13, 0x0873,
    0x036e, 0xfe1f, 0xf8ca, 0xf52a, 0xf493, 0xf6ef, 0xfb3b, 0x00d9,
    0x071e, 0x0b4e, 0x0b18, 0x071d, 0x003e, 0xf6ff, 0xeea8, 0xeab6,
    0xec40, 0xf2cf, 0xfc47, 0x04c2, 0x0a50, 0x0d8b, 0x0dc8, 0x0a5c,
    0x0502, 0xffcb, 0xfb93, 0xf8e9, 0xf845, 0xf907, 0xfaa7, 0xfd07,
    0xffaf, 0x023d, 0x03e9, 0x0421, 0x03f8, 0x045e, 0x043b, 0x03e4,
    0x04be, 0x0685, 0x07b2, 0x0795, 0x06ce, 0x04bb, 0x0130, 0xfdb5,
    0xfb64, 0xfa6c, 0xfa2a, 0xfa5a, 0xfb9a, 0xfdaf, 0xfeda, 0xfe2a,
    0xfc6f, 0xfae8, 0xfa06, 0xf9b6, 0xf9ff, 0xfb91, 0xfe80, 0x0010,
    0xff59, 0xfe5f, 0xff00, 0x0031, 0x0283, 0x080e, 0x0de7, 0x0fa4,
    0x0d6d, 0x0a5b, 0x063d, 0x0042, 0xf95a, 0xf36c, 0xefe7, 0xeefa,
    0xf071, 0xf419, 0xfa0e, 0x0258, 0x0bc5, 0x1362, 0x164f, 0x12f8,
    0x0917, 0xfb8c, 0xefa2, 0xeaa9, 0xee1d, 0xf6a6, 0x008f, 0x097c,
    0x0f13, 0x0ed3, 0x0916, 0x001b, 0xf75e, 0xf2c0, 0xf30d, 0xf6d8,
    0xfc25, 0x01ca, 0x05ef, 0x0605, 0x0284, 0x007a, 0x01e1, 0x02cd,
    0x014a, 0x001a, 0x0200, 0x05c4, 0x0984, 0x0b5c, 0x09d8, 0x04bc,
    0xfd55, 0xf643, 0xf161, 0xefe5, 0xf1f3, 0xf6d5, 0xfda6, 0x0528,
    0x0afb, 0x0d23, 0x0baf, 0x088f, 0x059c, 0x02b3, 0xfef5, 0xfb4e,
    0xf9bf, 0xfa54, 0xfbfe, 0xfd9f, 0xff56, 0x01af, 0x04b6, 0x0699,
    0x04d6, 0x0006, 0xfa75, 0xf6a3, 0xf566, 0xf684, 0xfa27, 0xff88,
    0x04b0, 0x06cf, 0x04e9, 0x0043, 0xfab7, 0xf795, 0xf937, 0xfe58,
    0x03df, 0x07e1, 0x09c1, 0x0956, 0x06a9, 0x01d5, 0xfc57, 0xf9a3,
    0xfa74, 0xfca9, 0x00d2, 0x06cb, 0x0acc, 0x0b11, 0x094e, 0x06a1,
    0x021c, 0xfd97, 0xfbce, 0xfc7d, 0xfd8e, 0xfc94, 0xf994, 0xf645,
    0xf3f3, 0xf2f5, 0xf40e, 0xf7f2, 0xfd95, 0x0294, 0x05f7, 0x078d,
    0x07c3, 0x0772, 0x072a, 0x0818, 0x0a47, 0x0b62, 0x088b, 0x0269,
    0xfbd6, 0xf69a, 0xf375, 0xf3df, 0xf8f7, 0x00ed, 0x0809, 0x0c45,
    0x0c8e, 0x074f, 0xfe19, 0xf4f3, 0xef14, 0xee42, 0xf221, 0xf83c,
    0xfdaf, 0x01b3, 0x044b, 0x05e0, 0x0716, 0x0689, 0x0335, 0xff4a,
    0xfd8b, 0xfe02, 0xff1d, 0x0003, 0x00fc, 0x0210, 0x0202, 0xffc9,
    0xfd5b, 0xfced, 0xfe7a, 0x0268, 0x08f6, 0x0e9c, 0x0efe, 0x0a06,
    0x02fe, 0xfd79, 0xfb15, 0xfb17, 0xfbb7, 0xfbbb, 0xfc18, 0xfe33,
    0x007b, 0x0184, 0x0122, 0xff8b, 0xfd3e, 0xfb7e, 0xfab5, 0xfa0a,
    0xf9b5, 0xf99b, 0xf972, 0xf94f, 0xfa79, 0xfd56, 0x01a5, 0x069d,
    0x0a00, 0x0a45, 0x07e3, 0x04d8, 0x03e1, 0x0699, 0x0a79, 0x0d08,
    0x0c2c, 0x0507, 0xf808, 0xeaed, 0xe366, 0xe35d, 0xead5, 0xf80f,
    0x06fa, 0x1307, 0x18d2, 0x1652, 0x0d4f, 0x01c4, 0xf632, 0xed31,
    0xeb0c, 0xf13f, 0xfc24, 0x0717, 0x0e90, 0x10bf, 0x0e3e, 0x0857,
    0x002e, 0xf85d, 0xf33a, 0xf24e, 0xf5ee, 0xfab7, 0xfdc5, 0xffbf,
    0x0151, 0x018f, 0x0105, 0x01b9, 0x03e8, 0x0662, 0x079d, 0x0807,
    0x0966, 0x0ab8, 0x09e4, 0x0677, 0x0149, 0xfbd2, 0xf6a7, 0xf22c,
    0xf02d, 0xf186, 0xf583, 0xfb76, 0x01c1, 0x06c0, 0x09d6, 0x0a99,
    0x08e9, 0x05e7, 0x02f9, 0x0035, 0xfde0, 0xfc0e, 0xfbc5, 0xfe7e,
    0x02dd, 0x0601, 0x0697, 0x04db, 0x012a, 0xfc9a, 0xf875, 0xf5fc,
    0xf6ed, 0xfbc2, 0x01c5, 0x0508, 0x0326, 0xfd18, 0xf640, 0xf2b2,
    0xf55c, 0xfd32, 0x05f6, 0x0c5e, 0x0ef8, 0x0cb6, 0x074f, 0x016c,
    0xfbe5, 0xf80e, 0xf806, 0xfb9a, 0x005f, 0x0482, 0x0755, 0x08de,
    0x0931, 0x081e, 0x05e6, 0x02cd, 0xff70, 0xfc88, 0xfa00, 0xf7c8,
    0xf5ed, 0xf433, 0xf3a6, 0xf591, 0xf9d1, 0xffe4, 0x059d, 0x0853,
    0x080f, 0x06bc, 0x0564, 0x04e7, 0x05ea, 0x0794, 0x082e, 0x06c8,
    0x0346, 0xfe02, 0xf844, 0xf463, 0xf3fd, 0xf677, 0xfaba, 0x002a,
    0x0609, 0x09d7, 0x09be, 0x06a7, 0x0220, 0xfd56, 0xf913, 0xf681,
    0xf691, 0xf964, 0xfdb6, 0x0163, 0x03d2, 0x04dc, 0x0392, 0x00ba,
    0xfebe, 0xfdb8, 0xfc98, 0xfc0f, 0xfc67, 0xfcba, 0xfcd5, 0xfd44,
    0xfd9d, 0xfe06, 0x0089, 0x0505, 0x09aa, 0x0c78, 0x0cea, 0x0be8,
    0x09a3, 0x070d, 0x04aa, 0x02e6, 0x00c4, 0xfc1e, 0xf634, 0xf197,
    0xef45, 0xef77, 0xf2ff, 0xf8a6, 0xff5c, 0x07b5, 0x1004, 0x142e,
    0x1187, 0x09bf, 0xfded, 0xf012, 0xe5f0, 0xe3f6, 0xea97, 0xf7d0,
    0x071d, 0x127f, 0x16d4, 0x14b0, 0x0e66, 0x0707, 0x0041, 0xfb60,
    0xf955, 0xf8ae, 0xf731, 0xf525, 0xf5be, 0xf93a, 0xfdb5, 0x02e8,
    0x087f, 0x0c5f, 0x0c2b, 0x075d, 0xffe0, 0xf9c9, 0xf7e8, 0xf960,
    0xfc48, 0xffc1, 0x0360, 0x0600, 0x0657, 0x0484, 0x0223, 0x0016,
    0xfe1a, 0xfd20, 0xfd45, 0xfd53, 0xfc84, 0xfba5, 0xfb13, 0xfb1d,
    0xfd24, 0xffc0, 0xff8f, 0xfcf2, 0xfc52, 0xffa5, 0x04a3, 0x0828,
    0x095d, 0x0974, 0x08cc, 0x078f, 0x05df, 0x0323, 0xff0e, 0xf9dc,
    0xf42e, 0xef18, 0xec52, 0xecc9, 0xf0f8, 0xf958, 0x05ac, 0x1248,
    0x1a4a, 0x1bde, 0x17dc, 0x0fb9, 0x0560, 0xfbf9, 0xf4df, 0xf0cb,
    0xf1aa, 0xf6fa, 0xfd93, 0x0328, 0x06d3, 0x076d, 0x04be, 0x002a,
    0xfaa8, 0xf60a, 0xf4a0, 0xf58a, 0xf5ee, 0xf5cc, 0xf732, 0xfaed,
    0x00cd, 0x0890, 0x0fbd, 0x132c, 0x1386, 0x119d, 0x0bc3, 0x023d,
    0xf822, 0xf070, 0xec9e, 0xecf5, 0xf0b8, 0xf6c8, 0xfe2b, 0x05a4,
    0x0c30, 0x0fbc, 0x0ec8, 0x0aa5, 0x0520, 0xffe0, 0xfd62, 0xfddc,
    0xfdf0, 0xfc34, 0xfac7, 0xf9f3, 0xf890, 0xf84b, 0xfa9d, 0xfdb9,
    0xff27, 0xffd8, 0x01a9, 0x048c, 0x080b, 0x0bc0, 0x0e8a, 0x0e43,
    0x0a3b, 0x032c, 0xf9b9, 0xf079, 0xec0f, 0xede7, 0xf428, 0xfd8c,
    0x084a, 0x10ae, 0x1426, 0x122c, 0x0ac8, 0xffb4, 0xf433, 0xec1b,
    0xe9bc, 0xed85, 0xf5d4, 0xff2a, 0x0681, 0x0a22, 0x0a86, 0x08c9,
    0x050f, 0xffc4, 0xfabb, 0xf862, 0xf8a3, 0xfa5b, 0xfce7, 0xff1c,
    0x0042, 0x0096, 0x0135, 0x0283, 0x0486, 0x06f1, 0x0899, 0x08d7,
    0x081e, 0x0781, 0x06ce, 0x04d7, 0x01c6, 0xfeb7, 0xfc38, 0xfa38,
    0xf925, 0xf91e, 0xf991, 0xfa48, 0xfc12, 0xfec3, 0x01ab, 0x04b1,
    0x0656, 0x05b3, 0x0341, 0xffc3, 0xfb6f, 0xf679, 0xf215, 0xf083,
    0xf2c5, 0xf805, 0xff4d, 0x06a9, 0x0ccb, 0x114e, 0x12fc, 0x10c8,
    0x0b54, 0x0496, 0xfe8f, 0xf991, 0xf54b, 0xf319, 0xf38f, 0xf519,
    0xf7c5, 0xfcea, 0x031a, 0x0852, 0x0c04, 0x0e66, 0x0e10, 0x0998,
    0x0120, 0xf729, 0xf09f, 0xf06c, 0xf5d5, 0xfd0c, 0x02d7, 0x0645,
    0x07e2, 0x0865, 0x076c, 0x050b, 0x02a7, 0x00a4, 0xfddf, 0xf9da,
    0xf594, 0xf30b, 0xf2de, 0xf45a, 0xf7bc, 0xfe15, 0x05ea, 0x0b77,
    0x0cd7, 0x0bbb, 0x09df, 0x07a2, 0x0576, 0x031d, 0x000c, 0xfd02,
    0xfaf8, 0xf93e, 0xf81f, 0xf8c9, 0xfb65, 0xfec6, 0x022a, 0x04da,
    0x0545, 0x03a2, 0x0153, 0x0026, 0x00ea, 0x0211, 0x0276, 0x01d8,
    0x0073, 0xfebb, 0xfd67, 0xfcf7, 0xfdc6, 0x009a, 0x053f, 0x09c3,
    0x0a9e, 0x065c, 0xff0c, 0xf869, 0xf497, 0xf3ac, 0xf5c5, 0xfa95,
    0x0027, 0x036f, 0x032d, 0x00b4, 0xfdfd, 0xfd02, 0xfe82, 0x0164,
    0x0448, 0x065d, 0x06f6, 0x0595, 0x0232, 0xfc6e, 0xf669, 0xf398,
    0xf4dd, 0xf94e, 0xfff2, 0x072a, 0x0c44, 0x0e86, 0x0f0b, 0x0d99,
    0x095e, 0x029e, 0xfbd0, 0xf6aa, 0xf2af, 0xefbf, 0xeef4, 0xf244,
    0xf91d, 0x009c, 0x06ce, 0x0a73, 0x0ad3, 0x08ee, 0x05db, 0x02b0,
    0x00c2, 0x0001, 0xffc5, 0x0046, 0x01da, 0x03be, 0x0390, 0x0055,
    0xfb47, 0xf67e, 0xf3fb, 0xf4ce, 0xf92e, 0xff5a, 0x0533, 0x095f,
    0x0b34, 0x09e6, 0x054e, 0xfea6, 0xf808, 0xf40e, 0xf3a2, 0xf618,
    0xf9e3, 0xfe95, 0x03d3, 0x0804, 0x0a8d, 0x0aff, 0x0852, 0x02bf,
    0xfcbe, 0xf7f6, 0xf517, 0xf538, 0xf85a, 0xfd3c, 0x022e, 0x066a,
    0x094e, 0x09ca, 0x0864, 0x06ae, 0x0488, 0x021a, 0x0034, 0xfea6,
    0xfdae, 0xfd8e, 0xfec2, 0x017f, 0x04c2, 0x06a0, 0x0510, 0x0101,
    0xfd27, 0xfabb, 0xfa1c, 0xfb00, 0xfc43, 0xfd6a, 0xfe3c, 0xfee3,
    0xff9c, 0xffd6, 0xfed3, 0xfc9b, 0xfa39, 0xf948, 0xfad6, 0xfe05,
    0x0203, 0x05f4, 0x08a6, 0x0944, 0x0818, 0x068d, 0x04f2, 0x01b1,
    0xfcab, 0xf79e, 0xf30a, 0xef8b, 0xef9b, 0xf4b7, 0xfce0, 0x04bd,
    0x0b40, 0x1033, 0x11cf, 0x0fcd, 0x0a44, 0x01c0, 0xf9cf, 0xf62c,
    0xf6da, 0xf971, 0xfd2f, 0x0236, 0x071e, 0x09df, 0x09e2, 0x0787,
    0x0398, 0xfe0c, 0xf735, 0xf107, 0xedd7, 0xefce, 0xf69d, 0xfeb0,
    0x0568, 0x0a9b, 0x0c9f, 0x099b, 0x02be, 0xfc53, 0xf98c, 0xfa58,
    0xfdf1, 0x02c0, 0x064d, 0x06b6, 0x044b, 0x0117, 0xfe83, 0xfc5e,
    0xfad3, 0xfab5, 0xfc93, 0xff84, 0x01ba, 0x029f, 0x025e, 0x01b1,
    0x01bd, 0x0294, 0x0355, 0x0394, 0x0313, 0x016a, 0xfe8d, 0xfb59,
    0xf9ab, 0xfb7d, 0xffff, 0x041d, 0x06c7, 0x07f0, 0x060b, 0x015f,
    0xfc64, 0xf845, 0xf633, 0xf7f0, 0xfbb5, 0xfe3d, 0xfeac, 0xfe59,
    0xfe85, 0xff0f, 0x00f3, 0x0398, 0x0479, 0x039c, 0x036c, 0x04bb,
    0x044d, 0x003f, 0xfb73, 0xf856, 0xf770, 0xfa1a, 0x00fa, 0x090a,
    0x0e74, 0x10a7, 0x0f61, 0x0981, 0x00f5, 0xf971, 0xf4b5, 0xf2e5,
    0xf313, 0xf3bb, 0xf499, 0xf6f9, 0xfb15, 0xff72, 0x036c, 0x0769,
    0x0a13, 0x0a63, 0x099c, 0x0824, 0x062b, 0x041d, 0x01c4, 0xffa4,
    0xfdda, 0xfc7b, 0xfc41, 0xfc4f, 0xfb8f, 0xfaad, 0xfa91, 0xfac5,
    0xfb52, 0xfcbd, 0xfee1, 0x00c0, 0x01f8, 0x027e, 0x019f, 0xff9f,
    0xfd53, 0xfc17, 0xfcad, 0xff35, 0x024e, 0x046f, 0x05de, 0x065c,
    0x05ab, 0x03b8, 0xff90, 0xfa2e, 0xf613, 0xf461, 0xf51e, 0xf78c,
    0xfb3d, 0xff66, 0x035d, 0x0752, 0x0af4, 0x0d4f, 0x0d98, 0x0baa,
    0x083b, 0x044f, 0x0122, 0xfee3, 0xfced, 0xfb6d, 0xfadc, 0xfbb0,
    0xfd35, 0xfe5d, 0xfef2, 0xfe34, 0xfd12, 0xfcfa, 0xfdd8, 0xff0b,
    0x0001, 0x0081, 0x0007, 0xfe7c, 0xfc9b, 0xfbd7, 0xfcdb, 0xfee8,
    0x00fa, 0x022a, 0x029c, 0x02af, 0x02b9, 0x03b0, 0x04eb, 0x04e2,
    0x0334, 0x0077, 0xfd6b, 0xfb1c, 0xf908, 0xf7aa, 0xf8f5, 0xfba4,
    0xfd68, 0xff66, 0x02e8, 0x0645, 0x084b, 0x0a3e, 0x0c84, 0x0ca9,
    0x08f1, 0x0163, 0xf8bf, 0xf332, 0xf2ee, 0xf65b, 0xfaf6, 0xff90,
    0x0350, 0x0600, 0x067a, 0x044e, 0x006b, 0xfc23, 0xf8f7, 0xf7c8,
    0xf84b, 0xf993, 0xfc29, 0xff66, 0x00eb, 0x01cc, 0x0449, 0x0670,
    0x05f5, 0x03e2, 0x0205, 0x00e6, 0x006c, 0x00c0, 0x017c, 0x01ec,
    0x0122, 0xfea6, 0xfc7c, 0xfcb7, 0xfe1f, 0xffd4, 0x029c, 0x0621,
    0x07ff, 0x0764, 0x050f, 0x00fc, 0xfd0a, 0xfb4b, 0xfb3b, 0xfb06,
    0xfb14, 0xfc1c, 0xfc93, 0xfc0d, 0xfc0a, 0xfe04, 0x0197, 0x04bb,
    0x0617, 0x0478, 0x0036, 0xfbe3, 0xf935, 0xf7da, 0xf7df, 0xfb7b,
    0x0212, 0x079a, 0x0a28, 0x09dc, 0x0687, 0x01eb, 0xffc4, 0x0036,
    0xffc6, 0xfe37, 0xfd75, 0xfd35, 0xfcac, 0xfb4e, 0xf975, 0xf95a,
    0xfbf4, 0x0076, 0x0691, 0x0ce8, 0x10a7, 0x10c3, 0x0da6, 0x07cc,
    0xfff0, 0xf80f, 0xf2b8, 0xf182, 0xf45a, 0xf7ef, 0xf92e, 0xf8dd,
    0xf941, 0xf999, 0xf98d, 0xfbc9, 0xfff9, 0x052a, 0x09f4, 0x0bfb,
    0x0b90, 0x095c, 0x072a, 0x059f, 0x049f, 0x03ae, 0x01db, 0x0044,
    0xfe96, 0xfc87, 0xfb3b, 0xfbcb, 0xfce7, 0xfd95, 0xff00, 0x005c,
    0x0051, 0xfecb, 0xfc2e, 0xf8ec, 0xf6f7, 0xf7a9, 0xfa63, 0xfe91,
    0x0383, 0x079f, 0x0944, 0x08d9, 0x0744, 0x03ba, 0xfd92, 0xf752,
    0xf45c, 0xf4a2, 0xf64b, 0xf8df, 0xfc6b, 0x002c, 0x0300, 0x0471,
    0x055e, 0x0704, 0x08e7, 0x09f2, 0x0ab1, 0x0acd, 0x08b5, 0x044f,
    0xffa5, 0xfc20, 0xfa81, 0xfc77, 0x017e, 0x068d, 0x0755, 0x02eb,
    0xfdba, 0xf9fa, 0xf714, 0xf657, 0xf92c, 0xfd22, 0xffec, 0x0165,
    0x008c, 0xfc9f, 0xf727, 0xf379, 0xf335, 0xf66d, 0xfcc7, 0x0400,
    0x0a6a, 0x0f7d, 0x120f, 0x10a0, 0x0b8c, 0x04da, 0xfefb, 0xfae1,
    0xf6f7, 0xf47c, 0xf4a7, 0xf53f, 0xf5a0, 0xf842, 0xfcd9, 0x0140,
    0x0587, 0x0abc, 0x0f6a, 0x10ab, 0x0d3c, 0x0513, 0xfb18, 0xf367,
    0xf10d, 0xf42a, 0xfae8, 0x024d, 0x0780, 0x0908, 0x0724, 0x043f,
    0x0227, 0x0041, 0xfd6e, 0xfa09, 0xf69a, 0xf3f5, 0xf483, 0xf93f,
    0xfed9, 0x0385, 0x07ee, 0x09fa, 0x0815, 0x0465, 0x020a, 0x0197,
    0x020e, 0x0357, 0x04a5, 0x0445, 0x01ac, 0xfda6, 0xf99b, 0xf642,
    0xf449, 0xf524, 0xf8de, 0xfdef, 0x0310, 0x07ce, 0x0a8b, 0x0a2e,
    0x08a3, 0x0677, 0x0271, 0xfdc3, 0xfb6c, 0xfac3, 0xf9cb, 0xf983,
    0xfaf8, 0xfe40, 0x0304, 0x07f0, 0x0abf, 0x0998, 0x04ca, 0xfdc6,
    0xf675, 0xf0d1, 0xef25, 0xf289, 0xf8b4, 0xfee3, 0x02d9, 0x0365,
    0x01ee, 0x021c, 0x05c4, 0x09de, 0x0b4c, 0x0a2a, 0x0765, 0x037f,
    0xff3a, 0xfc13, 0xfa7d, 0xf939, 0xf913, 0xfb1c, 0xfed1, 0x035a,
    0x07a6, 0x0b1b, 0x0c13, 0x09bd, 0x0552, 0x0065, 0xfbef, 0xf8ed,
    0xf6c4, 0xf3cf, 0xf16a, 0xf220, 0xf672, 0xfcd4, 0x0341, 0x07d8,
    0x0963, 0x082f, 0x05a8, 0x0379, 0x0313, 0x047f, 0x0623, 0x0655,
    0x043e, 0x0030, 0xfbdd, 0xf87f, 0xf698, 0xf77e, 0xfb75, 0x0030,
    0x0353, 0x04ac, 0x053e, 0x0518, 0x033b, 0xff6a, 0xfb2f, 0xf838,
    0xf711, 0xf779, 0xf9c4, 0xfe67, 0x0370, 0x070b, 0x0999, 0x0b37,
    0x0a40, 0x05ae, 0xfeda, 0xf817, 0xf363, 0xf27d, 0xf554, 0xf98d,
    0xfd55, 0x0031, 0x023b, 0x0401, 0x06bb, 0x09b0, 0x0ad3, 0x0a80,
    0x0a3e, 0x0a5c, 0x0983, 0x067d, 0x0179, 0xfb25, 0xf5b1, 0xf3c5,
    0xf585, 0xf8de, 0xfb52, 0xfd56, 0x0038, 0x0298, 0x03c7, 0x04e6,
    0x05c0, 0x052c, 0x03c1, 0x0193, 0xfd48, 0xf802, 0xf426, 0xf2fc,
    0xf469, 0xf824, 0xfd92, 0x0307, 0x0874, 0x0d7d, 0x101c, 0x0f1e,
    0x0add, 0x04c0, 0xfea4, 0xf7de, 0xf1b4, 0xefe8, 0xf227, 0xf609,
    0xfb0f, 0x01f5, 0x0832, 0x0bae, 0x0d56, 0x0e22, 0x0de7, 0x0b46,
    0x0437, 0xfa20, 0xf24a, 0xf037, 0xf313, 0xf877, 0xfeae, 0x0383,
    0x05a1, 0x04ae, 0x018b, 0xfe89, 0xfcfe, 0xfc95, 0xfcf9, 0xfd1e,
    0xfba8, 0xfa31, 0xfa90, 0xfba0, 0xfcea, 0x0000, 0x0339, 0x03fb,
    0x0437, 0x06b7, 0x0a82, 0x0d34, 0x0dec, 0x0b68, 0x0583, 0xfe45,
    0xf6f9, 0xf111, 0xeebd, 0xf03d, 0xf38b, 0xf7ab, 0xfce8, 0x0260,
    0x0730, 0x0ac2, 0x0c3d, 0x0bd8, 0x0a97, 0x08b0, 0x0531, 0x0060,
    0xfc96, 0xfaec, 0xf9eb, 0xf857, 0xf791, 0xf928, 0xfcc1, 0x011d,
    0x043a, 0x0446, 0x018b, 0xfda9, 0xfa05, 0xf7f2, 0xf848, 0xfae4,
    0xfe62, 0x009a, 0x00bc, 0x0042, 0x01b3, 0x05d0, 0x0ac4, 0x0e0b,
    0x0d7b, 0x0858, 0x0053, 0xf905, 0xf48b, 0xf1f8, 0xf175, 0xf474,
    0xfb0c, 0x0285, 0x08d9, 0x0dad, 0x0ff1, 0x0f05, 0x0bdc, 0x0769,
    0x0231, 0xfe11, 0xfc3c, 0xfbe7, 0xfa91, 0xf6df, 0xf285, 0xeff9,
    0xf0b6, 0xf481, 0xfac7, 0x0206, 0x0804, 0x0b89, 0x0bed, 0x09c5,
    0x075d, 0x064b, 0x056a, 0x0457, 0x03a1, 0x01da, 0xfddd, 0xf938,
    0xf663, 0xf650, 0xf97b, 0xfed5, 0x0458, 0x086b, 0x09ea, 0x08e1,
    0x052a, 0xffb6, 0xfa43, 0xf539, 0xf191, 0xf203, 0xf74a, 0xfea6,
    0x0505, 0x0959, 0x0b28, 0x0941, 0x0436, 0xfe83, 0xfa01, 0xf760,
    0xf702, 0xf827, 0xf942, 0xfa3d, 0xfc1d, 0xfec1, 0x01ca, 0x050d,
    0x07a4, 0x098f, 0x0b16, 0x0ccb, 0x0d5e, 0x0b42, 0x06f5, 0x0143,
    0xfc25, 0xf905, 0xf82e, 0xf9d6, 0xfbbe, 0xfc87, 0xfe49, 0x00fa,
    0x0338, 0x049e, 0x0517, 0x0433, 0x02b9, 0x016b, 0xffac, 0xfc79,
    0xf785, 0xf255, 0xee61, 0xed95, 0xf0f0, 0xf818, 0x0281, 0x0e23,
    0x1720, 0x1a0f, 0x174f, 0x10ac, 0x084f, 0xfec6, 0xf540, 0xef09,
    0xec72, 0xec86, 0xef42, 0xf56a, 0xfcd9, 0x03a9, 0x0988, 0x0df7,
    0x10bb, 0x10e2, 0x0cdf, 0x0407, 0xf99a, 0xf312, 0xf1c1, 0xf3eb,
    0xf9d0, 0x01e6, 0x07a5, 0x0821, 0x0547, 0x0240, 0x0029, 0xff3b,
    0xfece, 0xfda2, 0xfba6, 0xfa70, 0xfa23, 0xf966, 0xf977, 0xfcce,
    0x0056, 0x00d7, 0x0032, 0x00e6, 0x0415, 0x0922, 0x0def, 0x0ffc,
    0x0e9e, 0x09c1, 0x01b0, 0xf911, 0xf368, 0xf0bb, 0xef08, 0xef30,
    0xf26a, 0xf7d1, 0xfe7c, 0x0656, 0x0d66, 0x11c6, 0x13ff, 0x134d,
    0x0d98, 0x044e, 0xfc0d, 0xf72b, 0xf4c2, 0xf409, 0xf639, 0xfbbe,
    0x01c5, 0x066a, 0x08dc, 0x07bd, 0x0404, 0xff79, 0xfa2c, 0xf42c,
    0xf095, 0xf28f, 0xf79b, 0xfbde, 0xfe00, 0xfde0, 0xfd56, 0xffa0,
    0x0574, 0x0a15, 0x09f1, 0x0766, 0x051a, 0x02a2, 0xffce, 0xfd23,
    0xfa17, 0xf7c1, 0xf8ac, 0xfcb9, 0x0219, 0x071e, 0x0ac5, 0x0cf3,
    0x0d85, 0x0c43, 0x0964, 0x04b9, 0xfe6f, 0xf7cc, 0xf2e0, 0xf04b,
    0xef14, 0xefde, 0xf3b7, 0xf993, 0xff60, 0x0485, 0x0886, 0x09cc,
    0x0854, 0x06a0, 0x06e0, 0x0867, 0x08e5, 0x07db, 0x059c, 0x0147,
    0xfb91, 0xf66a, 0xf2f5, 0xf242, 0xf5a4, 0xfc65, 0x0412, 0x0ab6,
    0x0eba, 0x0e77, 0x09c8, 0x0306, 0xfbbb, 0xf433, 0xedd3, 0xeb3e,
    0xee67, 0xf6a8, 0x00dc, 0x0985, 0x0ea2, 0x0eec, 0x0a48, 0x037b,
    0xfdd5, 0xfa06, 0xf7df, 0xf72f, 0xf768, 0xf7c3, 0xf88c, 0xfb11,
    0xfedb, 0x039c, 0x09de, 0x0fb9, 0x11d8, 0x10e0, 0x0f12, 0x0c8a,
    0x08dc, 0x039d, 0xfd8c, 0xf85c, 0xf583, 0xf567, 0xf74a, 0xf8ed,
    0xf908, 0xf976, 0xfb8b, 0xfe80, 0x01ab, 0x04fe, 0x0732, 0x0691,
    0x0402, 0x008e, 0xfc24, 0xf847, 0xf682, 0xf712, 0xf942, 0xfc91,
    0x00a5, 0x0482, 0x0881, 0x0c7b, 0x0e0a, 0x0bd1, 0x0730, 0x0118,
    0xf942, 0xf0d9, 0xebff, 0xeda4, 0xf3bd, 0xfaed, 0x00c9, 0x05ae,
    0x095a, 0x0a72, 0x0aca, 0x0c86, 0x0ee8, 0x0f0a, 0x0aff, 0x029e,
    0xf870, 0xf14b, 0xef57, 0xf177, 0xf6fe, 0xfe54, 0x0385, 0x051e,
    0x04d6, 0x0419, 0x0347, 0x01e9, 0xff5d, 0xfbbe, 0xf863, 0xf7a4,
    0xfa05, 0xfcaa, 0xfdee, 0xff7f, 0x01fc, 0x03ea, 0x0485, 0x0540,
    0x0687, 0x06da, 0x05d4, 0x0427, 0x025e, 0xffaf, 0xfc23, 0xf94d,
    0xf84c, 0xf871, 0xf8c0, 0xfa27, 0xfd1c, 0x015c, 0x06c4, 0x0be2,
    0x0e43, 0x0d7d, 0x0b7c, 0x0811, 0x0227, 0xfbb6, 0xf799, 0xf5c5,
    0xf41c, 0xf2bc, 0xf323, 0xf5ee, 0xfc33, 0x044d, 0x0a22, 0x0bb5,
    0x0921, 0x0457, 0xfead, 0xf8ef, 0xf578, 0xf5d6, 0xf9a3, 0xff0c,
    0x03db, 0x05ee, 0x0577, 0x048a, 0x04df, 0x05a0, 0x03d3, 0xfff4,
    0xfc6b, 0xfa63, 0xf975, 0xf8f2, 0xf8bc, 0xf975, 0xfced, 0x0322,
    0x0a44, 0x0fd2, 0x1235, 0x11c2, 0x0ec4, 0x08e3, 0x015b, 0xfa0d,
    0xf44b, 0xf10c, 0xf05f, 0xf154, 0xf2d4, 0xf55c, 0xf922, 0xfd5d,
    0x0190, 0x057b, 0x07e0, 0x0840, 0x076a, 0x0635, 0x0545, 0x04f9,
    0x04fa, 0x04b1, 0x03f1, 0x0228, 0xff82, 0xfcb2, 0xfa5c, 0xf8ff,
    0xf92a, 0xfb57, 0xfe7f, 0x023b, 0x0603, 0x079c, 0x0662, 0x031c,
    0xfe49, 0xf8ee, 0xf543, 0xf52a, 0xf875, 0xfda5, 0x029f, 0x05f2,
    0x077d, 0x0709, 0x0452, 0x0032, 0xfc19, 0xf915, 0xf769, 0xf650,
    0xf593, 0xf5c0, 0xf758, 0xfa67, 0xff41, 0x0582, 0x0b8c, 0x0fe1,
    0x111b, 0x0f65, 0x0bf3, 0x07a7, 0x03bc, 0x0116, 0xffd9, 0xff4d,
    0xff06, 0xfe94, 0xfd72, 0xfc79, 0xfbe4, 0xfb2c, 0xfaf9, 0xfbd1,
    0xfd99, 0xffb5, 0x0168, 0x0213, 0x019c, 0x0065, 0xfe86, 0xfc3a,
    0xfa15, 0xf8ba, 0xf8b2, 0xfa7b, 0xfd54, 0x007a, 0x03e7, 0x0796,
    0x0b5c, 0x0d64, 0x0c3b, 0x07ba, 0x0008, 0xf66d, 0xed28, 0xe881,
    0xeae4, 0xf2cc, 0xfc80, 0x05a2, 0x0d76, 0x1215, 0x12fa, 0x10ff,
    0x0d66, 0x08cd, 0x033d, 0xfd47, 0xf7ef, 0xf5a3, 0xf703, 0xf9dc,
    0xfca0, 0xfea4, 0xffd5, 0x0008, 0xff53, 0xfe98, 0xfef1, 0x002c,
    0x005a, 0xfe3a, 0xfac2, 0xf856, 0xf959, 0xfe39, 0x036e, 0x05f7,
    0x06dc, 0x0619, 0x027c, 0xfe17, 0xfd45, 0x004f, 0x0399, 0x05c4,
    0x06eb, 0x05bc, 0x0138, 0xfb8e, 0xf7d6, 0xf6df, 0xf857, 0xfc3f,
    0x01f4, 0x0737, 0x0ab1, 0x0c8b, 0x0b0f, 0x0584, 0xff81, 0xfc42,
    0xfaa7, 0xf98d, 0xfa22, 0xfbc7, 0xfcb0, 0xfc59, 0xfb30, 0xf9ad,
    0xf985, 0xfbf6, 0xffa8, 0x027e, 0x03c1, 0x047c, 0x04c0, 0x04b6,
    0x0441, 0x02ca, 0x0098, 0xfe15, 0xfbe0, 0xf9d6, 0xf8e3, 0xfaf4,
    0xffc2, 0x0507, 0x080f, 0x07b0, 0x04df, 0x016d, 0xfda6, 0xf95b,
    0xf5fe, 0xf519, 0xf7b5, 0xfdbf, 0x058d, 0x0c72, 0x105e, 0x11ac,
    0x102f, 0x0b33, 0x03ec, 0xfc47, 0xf592, 0xf0aa, 0xeea4, 0xef72,
    0xf23d, 0xf687, 0xfc19, 0x01e5, 0x0645, 0x08d9, 0x0918, 0x069f,
    0x0360, 0x0152, 0x00da, 0x021b, 0x049d, 0x0710, 0x0812, 0x073c,
    0x04ca, 0x0194, 0xfe41, 0xfac5, 0xf79d, 0xf56a, 0xf4a1, 0xf64f,
    0xfa7d, 0xffbc, 0x0456, 0x06f3, 0x06e3, 0x03bb, 0xff1f, 0xfb86,
    0xfa74, 0xfc6e, 0x0020, 0x0383, 0x0504, 0x04b8, 0x03c1, 0x0233,
    0xff8f, 0xfc3f, 0xf93c, 0xf6cf, 0xf538, 0xf54a, 0xf765, 0xfb92,
    0x019e, 0x084e, 0x0df4, 0x10b4, 0x0fa3, 0x0c6b, 0x08dd, 0x05b7,
    0x0303, 0x00a8, 0xfe38, 0xfb67, 0xf9b3, 0xf9c0, 0xfb06, 0xfc98,
    0xfc13, 0xf9a8, 0xf8a0, 0xfa1e, 0xfcb1, 0xfff8, 0x03c9, 0x0655,
    0x06e4, 0x05b1, 0x02e7, 0xff60, 0xfc85, 0xfa48, 0xf7f7, 0xf746,
    0xf94d, 0xfd59, 0x022f, 0x0754, 0x0bf7, 0x0d9c, 0x0b40, 0x05c8,
    0xfec0, 0xf74a, 0xf1a4, 0xf00d, 0xf1cb, 0xf5c0, 0xfb89, 0x0261,
    0x086a, 0x0be5, 0x0d3f, 0x0dc0, 0x0d74, 0x0ba0, 0x073e, 0x002a,
    0xf938, 0xf64a, 0xf6b2, 0xf7db, 0xfa14, 0xfcd1, 0xfe86, 0x0028,
    0x02a2, 0x0428, 0x03b8, 0x025d, 0xfff0, 0xfb5d, 0xf685, 0xf526,
    0xf82f, 0xfd67, 0x0258, 0x04ff, 0x04a0, 0x024b, 0xffe6, 0xfed7,
    0xff3f, 0x00a8, 0x03db, 0x08f9, 0x0cc8, 0x0ba8, 0x0500, 0xfc9e,
    0xf62c, 0xf2fb, 0xf3f1, 0xf928, 0x00fe, 0x0818, 0x0ca9, 0x0d86,
    0x0908, 0x011a, 0xfabd, 0xf890, 0xf939, 0xfb7f, 0xfe49, 0x0004,
    0xffdb, 0xfdc8, 0xfaf3, 0xf874, 0xf7b4, 0xf9d0, 0xfdd1, 0x0183,
    0x03c3, 0x0538, 0x064e, 0x06ea, 0x06ce, 0x05da, 0x03dd, 0x000a,
    0xfa33, 0xf3d9, 0xf077, 0xf2a0, 0xfac5, 0x0639, 0x1001, 0x13c1,
    0x10f1, 0x0970, 0xfeeb, 0xf49b, 0xee9d, 0xef13, 0xf589, 0x003a,
    0x0c54, 0x1585, 0x17fc, 0x12fe, 0x0868, 0xfc73, 0xf314, 0xeeac,
    0xefbc, 0xf4b9, 0xfb97, 0x00fa, 0x029d, 0x009b, 0xfc8f, 0xf85a,
    0xf53c, 0xf5b7, 0xfa44, 0x0074, 0x06c8, 0x0c91, 0x10b0, 0x11fc,
    0x0fed, 0x0a71, 0x02da, 0xfbec, 0xf855, 0xf7ea, 0xf909, 0xfbb7,
    0xfef8, 0x00b6, 0x007d, 0xffd7, 0xff75, 0xff26, 0xfee6, 0xfe3e,
    0xfd54, 0xfc4c, 0xfb61, 0xfb62, 0xfd32, 0x00af, 0x03e9, 0x055a,
    0x0515, 0x03e8, 0x0249, 0xff6a, 0xfb5c, 0xf78d, 0xf5e7, 0xf6dc,
    0xf874, 0xf9c1, 0xfb77, 0xfe48, 0x0295, 0x07f6, 0x0d71, 0x112c,
    0x1193, 0x0e88, 0x08e5, 0x02b8, 0xfdf7, 0xfc10, 0xfcf9, 0xff22,
    0x0105, 0x01d5, 0x0179, 0xff60, 0xfbd0, 0xf779, 0xf2af, 0xefc8,
    0xf1a8, 0xf841, 0x00b1, 0x0784, 0x0b18, 0x0ba7, 0x0990, 0x051b,
    0xff4b, 0xfa2d, 0xf6fa, 0xf5b3, 0xf619, 0xf870, 0xfd09, 0x02f3,
    0x089f, 0x0c8f, 0x0e17, 0x0d0b, 0x07e9, 0xfefc, 0xf666, 0xf145,
    0xf0d6, 0xf448, 0xf913, 0xfdbc, 0x024b, 0x0710, 0x0ae4, 0x0cc3,
    0x0d36, 0x0c55, 0x095f, 0x0348, 0xfa8e, 0xf2c7, 0xef8d, 0xf185,
    0xf6e6, 0xfdd0, 0x0432, 0x07f0, 0x08b7, 0x067c, 0x01d4, 0xfd7f,
    0xfb49, 0xfa9a, 0xfb30, 0xfd8b, 0x0057, 0x0232, 0x0338, 0x02b2,
    0x0099, 0xfd9e, 0xf9f6, 0xf6f8, 0xf6ab, 0xfa60, 0x017f, 0x0942,
    0x0eb8, 0x111c, 0x101f, 0x0a66, 0x00b1, 0xf76c, 0xf1c7, 0xeff0,
    0xf29d, 0xfadb, 0x063f, 0x0f9f, 0x1436, 0x132f, 0x0cd1, 0x0344,
    0xf988, 0xf1d6, 0xeda1, 0xeedc, 0xf467, 0xf9cf, 0xfd0c, 0xff4c,
    0x01f7, 0x048f, 0x05bf, 0x0531, 0x02c4, 0xff24, 0xfc82, 0xfcbe,
    0xfee7, 0x0153, 0x049b, 0x07ed, 0x07ff, 0x0317, 0xfb4d, 0xf451,
    0xf0d5, 0xf2e8, 0xf9c0, 0x014f, 0x0734, 0x0ba2, 0x0ef6, 0x0f38,
    0x0a07, 0x0103, 0xf817, 0xf30e, 0xf36f, 0xf89d, 0x00bc, 0x08c1,
    0x0ee9, 0x1249, 0x11f0, 0x0d69, 0x05c9, 0xfd20, 0xf4e3, 0xee6f,
    0xeae4, 0xeac7, 0xee89, 0xf600, 0xfea0, 0x04e8, 0x07eb, 0x0899,
    0x07c0, 0x0653, 0x05db, 0x06fa, 0x0850, 0x0818, 0x064a, 0x03a1,
    0x002f, 0xfc6a, 0xf9bf, 0xf91f, 0xfb05, 0xfee9, 0x0199, 0x00a3,
    0xfd5b, 0xfa3d, 0xf7f3, 0xf709, 0xf86b, 0xfb16, 0xfdad, 0x00e2,
    0x049e, 0x07ef, 0x0a59, 0x0a71, 0x071f, 0x019a, 0xfc87, 0xf910,
    0xf79f, 0xf8a3, 0xfb77, 0xfe72, 0xfffc, 0xffa7, 0xfdd4, 0xfb80,
    0xfa4c, 0xfb6e, 0xfd95, 0xfff1, 0x03d3, 0x0944, 0x0e5a, 0x11fb,
    0x131a, 0x0f2d, 0x06ff, 0xfeb0, 0xf9d8, 0xf95d, 0xfbeb, 0xfe13,
    0xfd49, 0xfaef, 0xf96b, 0xf991, 0xfa96, 0xfb85, 0xfc30, 0xfdb4,
    0xffd4, 0x00fc, 0x016a, 0x01e1, 0x019c, 0xff67, 0xfba3, 0xf825,
    0xf674, 0xf77f, 0xfbc6, 0x022b, 0x0854, 0x0c6e, 0x0de3, 0x0d31,
    0x0a69, 0x04ee, 0xfdd4, 0xf73a, 0xf203, 0xeec0, 0xef17, 0xf34e,
    0xf9d2, 0x016e, 0x0954, 0x0fae, 0x133f, 0x1396, 0x0faf, 0x0871,
    0x00de, 0xfa9c, 0xf561, 0xf393, 0xf634, 0xf9be, 0xfc77, 0xfe60,
    0x00a5, 0x040e, 0x0735, 0x0834, 0x0584, 0x0003, 0xfa36, 0xf6fa,
    0xf6e3, 0xf88d, 0xfb0c, 0xfde6, 0x0014, 0x00b3, 0x01c9, 0x04c2,
    0x0838, 0x09ef, 0x0994, 0x0815, 0x0521, 0x0099, 0xfc2a, 0xf995,
    0xf85b, 0xf7e7, 0xf88a, 0xf9be, 0xfaf5, 0xfce2, 0x0086, 0x047b,
    0x0778, 0x09c1, 0x0ac0, 0x0968, 0x064f, 0x0261, 0xfd69, 0xf7e0,
    0xf3f5, 0xf382, 0xf71e, 0xfd1f, 0x02ae, 0x0664, 0x07c1, 0x072e,
    0x0551, 0x0284, 0xfe92, 0xfa1e, 0xf676, 0xf4b0, 0xf555, 0xf7cf,
    0xfb5b, 0xff4b, 0x033e, 0x0781, 0x0b66, 0x0d37, 0x0c59, 0x099e,
    0x05ef, 0x013f, 0xfbc3, 0xf6cf, 0xf3f5, 0xf46f, 0xf7ca, 0xfca1,
    0x017a, 0x0501, 0x070c, 0x0765, 0x0604, 0x03d2, 0x0110, 0xfe65,
    0xfd5d, 0xfe87, 0x00e1, 0x0308, 0x042a, 0x03b8, 0x018f, 0xfe6d,
    0xfbc3, 0xfa20, 0xf982, 0xfa3d, 0xfc9f, 0x0027, 0x03de, 0x0702,
    0x0886, 0x079e, 0x03bb, 0xfdf9, 0xf867, 0xf511, 0xf53c, 0xf8be,
    0xfe69, 0x043c, 0x08c6, 0x0b14, 0x09f2, 0x05e7, 0x013f, 0xfc9e,
    0xf790, 0xf2be, 0xf02f, 0xf1a1, 0xf6e2, 0xfe59, 0x058b, 0x0a2c,
    0x0ba6, 0x0a64, 0x0702, 0x0300, 0xffef, 0xfe31, 0xfd3a, 0xfd46,
    0xfe2c, 0xff5a, 0x0069, 0x0099, 0x0023, 0xffe1, 0x002d, 0x0091,
    0x019c, 0x032e, 0x0381, 0x0205, 0xffa8, 0xfdfa, 0xfd4d, 0xfd97,
    0xfed4, 0x0009, 0x0092, 0x00eb, 0x01b8, 0x02a9, 0x0315, 0x0325,
    0x0289, 0x00e2, 0xff37, 0xfdaa, 0xfc62, 0xfc1e, 0xfc0e, 0xfb0d,
    0xf996, 0xf91c, 0xfa90, 0xfdb1, 0x013a, 0x0437, 0x0614, 0x06a4,
    0x0638, 0x0422, 0x0096, 0xfd0e, 0xfa02, 0xf7f9, 0xf800, 0xfa5c,
    0xfe72, 0x0393, 0x085b, 0x09b2, 0x0768, 0x0487, 0x02cc, 0x021f,
    0x020e, 0x02c6, 0x02b7, 0x0101, 0xffca, 0xff4b, 0xfdde, 0xfb8f,
    0xf924, 0xf71d, 0xf62f, 0xf7f5, 0xfc58, 0x0087, 0x02a8, 0x0373,
    0x031d, 0x011e, 0xff08, 0xfeec, 0x0072, 0x0198, 0x027b, 0x0387,
    0x0397, 0x029b, 0x019b, 0x0093, 0xff03, 0xfe75, 0xffb8, 0x00d0,
    0x012f, 0x026f, 0x03be, 0x036f, 0x025c, 0x01ac, 0x00a3, 0xff27,
    0xfe63, 0xfdfe, 0xfd25, 0xfcbc, 0xfdb5, 0xff32, 0x002e, 0x006d,
    0xffe3, 0xfe5f, 0xfca3, 0xfc44, 0xfe6d, 0x01d1, 0x0489, 0x0670,
    0x06f6, 0x0570, 0x025f, 0xfef8, 0xfbfc, 0xf9bb, 0xf8ca, 0xf9b0,
    0xfc07, 0xff05, 0x020f, 0x045e, 0x0536, 0x0498, 0x0365, 0x01cc,
    0xff63, 0xfcc0, 0xfaec, 0xfa31, 0xfae7, 0xfd74, 0x0148, 0x0533,
    0x083d, 0x0981, 0x081b, 0x0489, 0x0029, 0xfc0f, 0xf8a8, 0xf6a4,
    0xf68f, 0xf818, 0xfb0d, 0xffa0, 0x0481, 0x07e7, 0x0938, 0x0804,
    0x04fa, 0x01f1, 0xffd0, 0xfe10, 0xfbf8, 0xf9ec, 0xf8f3, 0xf97b,
    0xfb5a, 0xfe5c, 0x01fe, 0x0511, 0x067f, 0x05ca, 0x0391, 0x012f,
    0xff81, 0xff1f, 0x0006, 0x009a, 0xffbd, 0xfe99, 0xfda7, 0xfc3a,
    0xfb40, 0xfc2c, 0xfe58, 0x00a8, 0x0272, 0x0328, 0x02d7, 0x0210,
    0x01f7, 0x02a3, 0x031d, 0x0275, 0x0058, 0xfd52, 0xfa1b, 0xf78c,
    0xf6e6, 0xf95e, 0xfe0e, 0x02b1, 0x0617, 0x073a, 0x05cb, 0x038d,
    0x025e, 0x016c, 0x0003, 0xff23, 0xfe91, 0xfde7, 0xfdc6, 0xfe8e,
    0x00b9, 0x0402, 0x06d2, 0x07f9, 0x070d, 0x045e, 0x0129, 0xfdee,
    0xfa3c, 0xf780, 0xf6e2, 0xf7e9, 0xf9d4, 0xfc4b, 0xfed1, 0x002e,
    0x0047, 0x0062, 0x0159, 0x0360, 0x0689, 0x0a3a, 0x0c23, 0x0a21,
    0x046f, 0xfd83, 0xf78e, 0xf303, 0xf0a5, 0xf120, 0xf49b, 0xf9a7,
    0xff81, 0x0614, 0x0ace, 0x0b7c, 0x0933, 0x068e, 0x045d, 0x0277,
    0x00ea, 0xffac, 0xfeee, 0xfe95, 0xfea8, 0xff20, 0x00b0, 0x035f,
    0x05c3, 0x060f, 0x02fb, 0xfdcf, 0xf892, 0xf4e0, 0xf303, 0xf2d1,
    0xf3f2, 0xf67a, 0xfa78, 0xff36, 0x0425, 0x0955, 0x0e78, 0x11e9,
    0x1243, 0x0e8f, 0x0726, 0xfec6, 0xf7ec, 0xf389, 0xf258, 0xf3dd,
    0xf66b, 0xf935, 0xfc4e, 0xff70, 0x0206, 0x04a0, 0x07b9, 0x0aec,
    0x0d14, 0x0d31, 0x0b1d, 0x06b9, 0x0036, 0xf932, 0xf3e4, 0xf19a,
    0xf2de, 0xf664, 0xfad3, 0xff4c, 0x02db, 0x0505, 0x0536, 0x03c8,
    0x01ba, 0xffaf, 0xfe2d, 0xfd10, 0xfbf9, 0xfbc1, 0xfd17, 0xffdd,
    0x0370, 0x069d, 0x08f7, 0x09f5, 0x08c5, 0x063c, 0x0393, 0x00ce,
    0xfdf2, 0xfc55, 0xfb7b, 0xf9c8, 0xf76c, 0xf58a, 0xf5b8, 0xf7ea,
    0xfb63, 0xff81, 0x02aa, 0x04ca, 0x06ea, 0x08f4, 0x0a03, 0x0992,
    0x07d4, 0x04ef, 0x00d4, 0xfd1e, 0xfb21, 0xfaba, 0xfb61, 0xfc8d,
    0xfd88, 0xfd52, 0xfcbd, 0xfd18, 0xfeac, 0x0097, 0x01ee, 0x029b,
    0x0279, 0x017e, 0xfff7, 0xfe9a, 0xfdf4, 0xfe37, 0xffe2, 0x02b9,
    0x0577, 0x072f, 0x07ac, 0x06cf, 0x0428, 0x0037, 0xfc22, 0xf87f,
    0xf58f, 0xf36a, 0xf238, 0xf322, 0xf667, 0xfae5, 0xffd5, 0x045e,
    0x07f8, 0x0a88, 0x0c1e, 0x0c67, 0x0b9f, 0x0a4d, 0x086b, 0x05e8,
    0x0247, 0xfdc0, 0xf9a5, 0xf6b7, 0xf543, 0xf571, 0xf6f3, 0xf959,
    0xfc02, 0xfec7, 0x0118, 0x020b, 0x024c, 0x0225, 0x015c, 0x00b1,
    0x00c8, 0x01a5, 0x02c6, 0x041d, 0x05f9, 0x082f, 0x09ef, 0x0a97,
    0x0a03, 0x07ab, 0x033e, 0xfde7, 0xf8dd, 0xf3eb, 0xefda, 0xeeac,
    0xf01b, 0xf2fe, 0xf7bc, 0xfd60, 0x01e1, 0x0511, 0x07a3, 0x08df,
    0x0843, 0x06ee, 0x056a, 0x0391, 0x01dc, 0x00af, 0xff94, 0xfe0d,
    0xfc6d, 0xfb65, 0xfa40, 0xf916, 0xf90d, 0xf9b8, 0xfb69, 0xff0c,
    0x0324, 0x0629, 0x087a, 0x0950, 0x0714, 0x0305, 0xfec5, 0xfaed,
    0xf8d3, 0xfa7d, 0x0057, 0x07bc, 0x0d67, 0x0f10, 0x0cb6, 0x0771,
    0x0068, 0xf9b4, 0xf4ba, 0xf12a, 0xef65, 0xf091, 0xf458, 0xf94a,
    0xff4c, 0x0613, 0x0a79, 0x0b19, 0x092e, 0x05bf, 0x023c, 0x003d,
    0xff5a, 0xfe7e, 0xfdf4, 0xfd14, 0xfb53, 0xfa97, 0xfc4c, 0xff60,
    0x02a9, 0x0603, 0x0898, 0x08f1, 0x06e6, 0x0331, 0xfef4, 0xfc08,
    0xfb61, 0xfc83, 0xfe62, 0x002e, 0x0195, 0x026a, 0x01e1, 0xffb8,
    0xfd2a, 0xfb10, 0xf9a5, 0xf9bd, 0xfba1, 0xfe3f, 0x0084, 0x0195,
    0x0130, 0x0025, 0xff58, 0xfe96, 0xfdb1, 0xfd95, 0xfeb4, 0x0071,
    0x01e3, 0x027b, 0x0342, 0x05ad, 0x08c6, 0x0a17, 0x08fc, 0x0508,
    0xfe5f, 0xf839, 0xf556, 0xf531, 0xf6b0, 0xf985, 0xfd12, 0x00f0,
    0x054f, 0x09ed, 0x0d62, 0x0e38, 0x0b72, 0x059a, 0xfece, 0xf8a7,
    0xf455, 0xf2e7, 0xf45c, 0xf735, 0xf9c3, 0xfbbd, 0xfdbe, 0x008a,
    0x03b7, 0x05d1, 0x05b6, 0x03ad, 0x0108, 0xfec1, 0xfdbd, 0xfed2,
    0x0182, 0x0459, 0x058d, 0x04b1, 0x02c6, 0x008a, 0xfe8f, 0xfda4,
    0xfe54, 0x0027, 0x0227, 0x030a, 0x021a, 0x0005, 0xfd9a, 0xfaab,
    0xf7cd, 0xf6b9, 0xf833, 0xfc1b, 0x01be, 0x0788, 0x0c2f, 0x0e6c,
    0x0e02, 0x0b34, 0x05d0, 0xff54, 0xf981, 0xf58f, 0xf3aa, 0xf3ba,
    0xf56f, 0xf816, 0xfb22, 0xfe33, 0x0132, 0x0324, 0x035f, 0x01df,
    0xffcb, 0xff36, 0x0038, 0x0233, 0x0507, 0x078a, 0x083b, 0x0763,
    0x0656, 0x04dc, 0x03eb, 0x0412, 0x03a2, 0x0206, 0xff32, 0xfbfc,
    0xf95b, 0xf774, 0xf651, 0xf646, 0xf7ac, 0xfa35, 0xfddc, 0x01b6,
    0x04d8, 0x06cf, 0x0793, 0x06a3, 0x03d8, 0x00cb, 0xfe8d, 0xfcf8,
    0xfbf4, 0xfc0f, 0xfd01, 0xfe35, 0xff2b, 0xffbc, 0xff2d, 0xfd9d,
    0xfc92, 0xfbf0, 0xfbb0, 0xfcf1, 0xffae, 0x02c4, 0x05a4, 0x07bf,
    0x0780, 0x042e, 0x0088, 0xff5b, 0x0082, 0x03a9, 0x0866, 0x0c42,
    0x0c5c, 0x08ce, 0x02fc, 0xfc21, 0xf553, 0xefff, 0xedc7, 0xee9a,
    0xf15d, 0xf63e, 0xfd0e, 0x0357, 0x0836, 0x0c0d, 0x0da3, 0x0bcb,
    0x07b9, 0x0301, 0xfe74, 0xfb02, 0xf982, 0xfa54, 0xfc4b, 0xfdf5,
    0xfe50, 0xfdb0, 0xfd16, 0xfd53, 0xfe61, 0xfff4, 0x0242, 0x048c,
    0x05f1, 0x05f2, 0x0517, 0x0393, 0x0121, 0xff3d, 0xff9f, 0x01bd,
    0x02d5, 0x0206, 0x0078, 0xfe64, 0xfbd1, 0xfa17, 0xf9ac, 0xf9d0,
    0xfaa6, 0xfc03, 0xfd2a, 0xfdf5, 0xfe22, 0xfe35, 0xff67, 0x018a,
    0x03a1, 0x0568, 0x06a3, 0x06d6, 0x05d5, 0x045b, 0x036d, 0x02bb,
    0x0185, 0xffe1, 0xfdb7, 0xfadb, 0xf850, 0xf729, 0xf7e2, 0xfa32,
    0xfdd7, 0x0194, 0x0412, 0x05d7, 0x06eb, 0x066f, 0x0447, 0x01e2,
    0x0043, 0xff55, 0xff82, 0x00ca, 0x01b4, 0x00ef, 0xfeb5, 0xfb5b,
    0xf7d5, 0xf587, 0xf5d1, 0xf8f4, 0xfdb2, 0x01e5, 0x0410, 0x0470,
    0x0392, 0x01f5, 0x00a3, 0x0002, 0xff90, 0xff6d, 0x000b, 0x0136,
    0x0293, 0x03ac, 0x0444, 0x0505, 0x05a8, 0x05c7, 0x05ef, 0x056e,
    0x02f6, 0xff08, 0xfb46, 0xf8b5, 0xf73c, 0xf6ee, 0xf83d, 0xfb71,
    0xffe8, 0x0425, 0x0739, 0x083e, 0x0700, 0x048e, 0x011a, 0xfcca,
    0xf91e, 0xf746, 0xf7b1, 0xf9fa, 0xfd53, 0x00c7, 0x02f0, 0x0334,
    0x01dc, 0xff6f, 0xfc53, 0xf98e, 0xf921, 0xfb75, 0xff8f, 0x047c,
    0x094d, 0x0c9d, 0x0d63, 0x0bce, 0x07ff, 0x02dc, 0xff0f, 0xfe42,
    0xff87, 0x00c5, 0x00dd, 0x0031, 0xff03, 0xfdac, 0xfc5c, 0xf9a8,
    0xf64c, 0xf532, 0xf730, 0xfb3f, 0x0048, 0x0512, 0x0877, 0x09e3,
    0x09a9, 0x07e1, 0x046b, 0x0060, 0xfd15, 0xfae7, 0xf9eb, 0xfaee,
    0xfd94, 0x000a, 0x0146, 0x0164, 0x0042, 0xfd90, 0xfac0, 0xfa71,
    0xfc2b, 0xfe6e, 0x00ad, 0x01b2, 0x0042, 0xfd64, 0xfc57, 0xfdf5,
    0x0123, 0x0595, 0x0b34, 0x0f67, 0x0f4c, 0x0a55, 0x0242, 0xfac3,
    0xf63c, 0xf47e, 0xf461, 0xf4fc, 0xf644, 0xf8da, 0xfcc5, 0x0094,
    0x03a9, 0x0681, 0x0824, 0x07a7, 0x0586, 0x02a2, 0x001b, 0xff63,
    0xffed, 0x0020, 0x0046, 0xff9f, 0xfc9c, 0xf842, 0xf5da, 0xf77f,
    0xfbf1, 0x01b4, 0x0786, 0x0b4a, 0x0b43, 0x07de, 0x0378, 0xff7a,
    0xfc35, 0xfad7, 0xfc9d, 0x008e, 0x0437, 0x05df, 0x0596, 0x03a5,
    0x007b, 0xfcec, 0xf9b6, 0xf758, 0xf5db, 0xf53d, 0xf5df, 0xf7a7,
    0xfa2a, 0xfe3c, 0x0406, 0x0946, 0x0b81, 0x0a3a, 0x068d, 0x0289,
    0xffad, 0xfe49, 0xfebf, 0x015e, 0x04a1, 0x067c, 0x0500, 0xff9f,
    0xf929, 0xf46a, 0xf34f, 0xf613, 0xfa47, 0xfe03, 0x0157, 0x050a,
    0x08b5, 0x0b79, 0x0b72, 0x083d, 0x0473, 0x0154, 0xfee4, 0xfd29,
    0xfc0f, 0xfb4c, 0xfad9, 0xfa5a, 0xf931, 0xf80e, 0xf88a, 0xfbc3,
    0x00cd, 0x054d, 0x07c5, 0x07d1, 0x064b, 0x044f, 0x0208, 0xffe0,
    0xfeb4, 0xfe46, 0xfd86, 0xfc88, 0xfc58, 0xfd8c, 0xfffd, 0x028b,
    0x03e0, 0x0377, 0x01b6, 0xff91, 0xfdb7, 0xfc9e, 0xfcc7, 0xfe36,
    0xffd2, 0x004e, 0x0000, 0xfffd, 0x0197, 0x04b3, 0x072c, 0x07e2,
    0x073a, 0x05fa, 0x03cd, 0x00ad, 0xfcb5, 0xf91a, 0xf67b, 0xf548,
    0xf68c, 0xf926, 0xfbe5, 0xfdea, 0xff40, 0xfff2, 0x00c4, 0x020c,
    0x028d, 0x022a, 0x01c7, 0x01d1, 0x01ef, 0x0273, 0x03c0, 0x0546,
    0x059e, 0x048d, 0x0287, 0xfffa, 0xfe1c, 0xfdf7, 0xff76, 0x002a,
    0xfefc, 0xfe22, 0xfdb5, 0xfc9b, 0xfc1b, 0xfd6e, 0xff27, 0x006d,
    0x01fd, 0x03d6, 0x0585, 0x064f, 0x052e, 0x0195, 0xfd2a, 0xfa01,
    0xf93e, 0xfb1a, 0xfe9e, 0x0258, 0x0477, 0x040a, 0x0172, 0xfee1,
    0xfd17, 0xfb94, 0xfbba, 0xfdae, 0xff31, 0xfec5, 0xfe12, 0xfe4e,
    0xfefb, 0x0028, 0x0285, 0x0579, 0x0758, 0x06ed, 0x04de, 0x035a,
    0x02bd, 0x0265, 0x016e, 0xfea0, 0xfab8, 0xf7a4, 0xf5c1, 0xf429,
    0xf3d0, 0xf69a, 0xfc03, 0x0246, 0x079c, 0x0a14, 0x0941, 0x0706,
    0x04a7, 0x02e0, 0x03a9, 0x0629, 0x0729, 0x0591, 0x02b6, 0x003b,
    0xfe44, 0xfd03, 0xfc07, 0xfac7, 0xf963, 0xf85a, 0xf860, 0xf9d9,
    0xfc5e, 0xfe88, 0x0089, 0x0318, 0x0570, 0x06b0, 0x06b0, 0x0581,
    0x02ed, 0xffa6, 0xfcf2, 0xfb0c, 0xfa91, 0xfbd0, 0xfd71, 0xfdfd,
    0xfd6d, 0xfc5a, 0xfb83, 0xfb7c, 0xfcfb, 0xff1b, 0x0056, 0x017d,
    0x030e, 0x047a, 0x0568, 0x067e, 0x0836, 0x0951, 0x08c8, 0x0631,
    0x0149, 0xfb78, 0xf709, 0xf539, 0xf55d, 0xf6ae, 0xf9c0, 0xfe8f,
    0x0342, 0x0605, 0x061c, 0x0469, 0x029d, 0x01bc, 0x01c5, 0x01af,
    0x0148, 0x00d9, 0x002b, 0xfefd, 0xfd1b, 0xfab2, 0xf8a0, 0xf799,
    0xf80a, 0xfab3, 0xff18, 0x03a9, 0x0712, 0x08a7, 0x0774, 0x0345,
    0xff7b, 0xfed7, 0x000a, 0x0188, 0x0349, 0x04cf, 0x0475, 0x029d,
    0x0149, 0x00ff, 0x00e6, 0x0081, 0x0004, 0xff42, 0xfe61, 0xfd46,
    0xfbe1, 0xfb1b, 0xfb67, 0xfc82, 0xfe4b, 0x0047, 0x018a, 0x020d,
    0x0290, 0x0354, 0x0382, 0x028c, 0x0097, 0xfe38, 0xfcae, 0xfc11,
    0xfbc1, 0xfbd9, 0xfc40, 0xfcae, 0xfd97, 0xfeb7, 0xff06, 0xfe4a,
    0xfd81, 0xfd3b, 0xfdd0, 0xffb2, 0x0243, 0x0524, 0x086e, 0x0bba,
    0x0dd3, 0x0d8d, 0x0aa9, 0x054a, 0xfe2c, 0xf853, 0xf5df, 0xf62c,
    0xf842, 0xfaaf, 0xfc65, 0xfd7f, 0xff26, 0x0233, 0x0493, 0x0463,
    0x02cb, 0x017c, 0x007c, 0xffbd, 0x0008, 0x0022, 0xfdb5, 0xf9bb,
    0xf708, 0xf66b, 0xf88b, 0xfd93, 0x039d, 0x075e, 0x07fb, 0x06bc,
    0x039c, 0x0022, 0xfe6d, 0xfed1, 0xffe3, 0x00a3, 0x008b, 0xfeaa,
    0xfc8a, 0xfc98, 0xff05, 0x020c, 0x051e, 0x0898, 0x0a8a, 0x08ee,
    0x0597, 0x031e, 0x0157, 0xff5b, 0xfd1f, 0xfa67, 0xf71f, 0xf4b1,
    0xf3bc, 0xf410, 0xf695, 0xfbca, 0x01ba, 0x0561, 0x0589, 0x02d6,
    0xffdb, 0xfe35, 0xfd58, 0xfe84, 0x02b1, 0x06e6, 0x0867, 0x0819,
    0x07bf, 0x0736, 0x0599, 0x02ba, 0xff03, 0xfb76, 0xf8bf, 0xf7b4,
    0xf895, 0xfa2c, 0xfb41, 0xfc44, 0xfe5f, 0x017e, 0x04eb, 0x07ab,
    0x0910, 0x08fa, 0x0749, 0x03d4, 0xffe2, 0xfd62, 0xfc31, 0xfc03,
    0xfcc7, 0xfd26, 0xfc32, 0xfb5b, 0xfc29, 0xfd70, 0xfdb4, 0xfcc2,
    0xfb07, 0xf9b9, 0xfa41, 0xfcc0, 0x0033, 0x0475, 0x0918, 0x0b70,
    0x0998, 0x04f9, 0xff5d, 0xf9d9, 0xf648, 0xf600, 0xf7e8, 0xfaeb,
    0xff40, 0x0405, 0x07b2, 0x087b, 0x05c0, 0x01d1, 0xff73, 0xff6a,
    0x013d, 0x0496, 0x084a, 0x09ef, 0x08ff, 0x062c, 0x018a, 0xfc2d,
    0xf75a, 0xf46a, 0xf436, 0xf62f, 0xf8bf, 0xfac4, 0xfc4c, 0xfd61,
    0xfe1a, 0xff5f, 0x01ad, 0x0358, 0x0400, 0x051c, 0x06b2, 0x083d,
    0x08d2, 0x08f5, 0x0878, 0x05a5, 0x0135, 0xfc5b, 0xf8d6, 0xf853,
    0xfa06, 0xfc11, 0xfd28, 0xfd56, 0xfd34, 0xfd17, 0xfdbc, 0x0035,
    0x037d, 0x0582, 0x0599, 0x03cf, 0x00bb, 0xfdbf, 0xfc8b, 0xfc9a,
    0xfc9f, 0xfd2e, 0xff2b, 0x01ae, 0x028c, 0x018e, 0xff2e, 0xfb9e,
    0xf84a, 0xf66c, 0xf646, 0xf7a9, 0xfa6e, 0xfe13, 0x0286, 0x070d,
    0x0b36, 0x0ee0, 0x1181, 0x1265, 0x0fe6, 0x0a0c, 0x0263, 0xfb5e,
    0xf715, 0xf58c, 0xf5e1, 0xf70a, 0xf84e, 0xfa5b, 0xfe21, 0x0234,
    0x0498, 0x051c, 0x043c, 0x0293, 0x0078, 0xfee8, 0xfecd, 0xff66,
    0xff8b, 0xfe68, 0xfbb6, 0xf93b, 0xf88b, 0xf933, 0xfba6, 0xfffa,
    0x04a3, 0x085b, 0x0ac7, 0x0b60, 0x094f, 0x0479, 0xff44, 0xfb88,
    0xf8b3, 0xf509, 0xf159, 0xf0f0, 0xf4d6, 0xfc12, 0x0530, 0x0e98,
    0x1530, 0x168b, 0x11d2, 0x0818, 0xfd58, 0xf5fb, 0xf37f, 0xf4c7,
    0xf7ff, 0xfb15, 0xfcb0, 0xfcbc, 0xfc19, 0xfc26, 0xfd36, 0xfe09,
    0xfda5, 0xfc64, 0xfc16, 0xfe5c, 0x0281, 0x05da, 0x074b, 0x07dc,
    0x0705, 0x03c1, 0xffdd, 0xfdae, 0xfd46, 0xfde1, 0xffb2, 0x0325,
    0x070d, 0x08a2, 0x0699, 0x0266, 0xfd19, 0xf7b3, 0xf4e4, 0xf611,
    0xf9e3, 0xfe79, 0x032a, 0x0788, 0x0a7e, 0x0b86, 0x0aaa, 0x0840,
    0x04e4, 0x0101, 0xfcd6, 0xf8ee, 0xf596, 0xf331, 0xf3cc, 0xf7a8,
    0xfbdd, 0xfe63, 0xfea7, 0xfde8, 0xfdba, 0xfe57, 0xff8a, 0x015f,
    0x03f1, 0x05fb, 0x068f, 0x05c3, 0x0334, 0xff31, 0xfbed, 0xfb01,
    0xfb85, 0xfc4a, 0xfd6c, 0xff46, 0x01ce, 0x0476, 0x064f, 0x06d0,
    0x060d, 0x04d8, 0x0435, 0x0488, 0x04a2, 0x0384, 0x01a3, 0xfee5,
    0xfb09, 0xf793, 0xf6a0, 0xf804, 0xf9f0, 0xfbb0, 0xfd5c, 0xfecb,
    0xffa5, 0xffde, 0xfffe, 0x0081, 0x0164, 0x0279, 0x0373, 0x0393,
    0x0368, 0x048d, 0x0687, 0x07a3, 0x073b, 0x0507, 0x0102, 0xfc45,
    0xf823, 0xf5ac, 0xf5b2, 0xf86d, 0xfcd0, 0x00ef, 0x0381, 0x0440,
    0x03aa, 0x027a, 0x015e, 0x00ec, 0x0106, 0x0084, 0xff32, 0xfe71,
    0xfe6b, 0xfe43, 0xfe95, 0xffb6, 0x0041, 0xffc9, 0xff62, 0xff49,
    0xfe7e, 0xfca6, 0xfb1d, 0xfaef, 0xfbdf, 0xfd62, 0xff2a, 0x009a,
    0x01b4, 0x035d, 0x0554, 0x0748, 0x092c, 0x0a72, 0x0a6a, 0x0937,
    0x06a3, 0x01e4, 0xfc58, 0xf7b3, 0xf414, 0xf2a3, 0xf540, 0xfb13,
    0x005b, 0x0361, 0x055f, 0x0642, 0x0579, 0x0406, 0x025f, 0xfffe,
    0xfd55, 0xfbdf, 0xfbef, 0xfc66, 0xfcf7, 0xfd79, 0xfd33, 0xfc75,
    0xfd3c, 0xffdd, 0x0244, 0x03ba, 0x054b, 0x064d, 0x04df, 0x019f,
    0xfee3, 0xfd35, 0xfc1e, 0xfd4d, 0x0035, 0x0115, 0xff2d, 0xfd73,
    0xfdbb, 0xfecb, 0xfffa, 0x01d9, 0x03c3, 0x047f, 0x040c, 0x024c,
    0x0073, 0x0088, 0x01e6, 0x0247, 0x007a, 0xfdc3, 0xfbf6, 0xfb8a,
    0xfc56, 0xfdb5, 0xff31, 0x00df, 0x0266, 0x02b1, 0x0142, 0xfedb,
    0xfc99, 0xfa8c, 0xf834, 0xf6d8, 0xf841, 0xfc26, 0x005e, 0x03d4,
    0x06f4, 0x09ab, 0x0ab4, 0x09ec, 0x088e, 0x0671, 0x02d5, 0xfe5b,
    0xfae6, 0xf92e, 0xf8be, 0xf9b5, 0xfc8a, 0x008a, 0x03ca, 0x055b,
    0x0595, 0x04f5, 0x0393, 0x0144, 0xfe53, 0xfb90, 0xfa5b, 0xfb17,
    0xfd8f, 0x0117, 0x03ff, 0x04ea, 0x036e, 0xff8a, 0xf9b9, 0xf3dc,
    0xf06d, 0xf0f2, 0xf56f, 0xfc6a, 0x0434, 0x0b85, 0x1006, 0x0f1f,
    0x095f, 0x012c, 0xf8e1, 0xf3da, 0xf48f, 0xf9cf, 0xffa3, 0x0456,
    0x0847, 0x0b0e, 0x0bb0, 0x0a05, 0x0693, 0x0220, 0xfd92, 0xfa5b,
    0xfacd, 0xfeae, 0x030f, 0x05a2, 0x0696, 0x0511, 0x0097, 0xfb52,
    0xf69d, 0xf334, 0xf22f, 0xf3c6, 0xf743, 0xfc61, 0x0246, 0x06a2,
    0x0782, 0x0570, 0x02a5, 0x008d, 0x0047, 0x0280, 0x0639, 0x096c,
    0x0a7c, 0x08fb, 0x0608, 0x02bb, 0xff27, 0xfb18, 0xf6f9, 0xf45c,
    0xf4d3, 0xf82a, 0xfce0, 0x0196, 0x0554, 0x071c, 0x0645, 0x03d2,
    0x0175, 0xffa1, 0xfd9a, 0xfb6c, 0xfaab, 0xfbc8, 0xfdaa, 0xffd1,
    0x01de, 0x0304, 0x02ee, 0x01bb, 0x0000, 0xff54, 0x0020, 0x019e,
    0x02a2, 0x01bd, 0xfe22, 0xf90f, 0xf5b3, 0xf5f9, 0xfa45, 0x0197,
    0x0970, 0x0ecd, 0x0fe8, 0x0bae, 0x0341, 0xfa62, 0xf3f3, 0xf13b,
    0xf29a, 0xf7e8, 0xff3b, 0x0595, 0x095c, 0x0a0b, 0x07a4, 0x02c6,
    0xfd90, 0xf9ca, 0xf6ed, 0xf569, 0xf710, 0xfb95, 0x00e5, 0x05c7,
    0x0980, 0x0a5f, 0x07c8, 0x0337, 0xfdff, 0xfa2f, 0xf9ee, 0xfca1,
    0x0042, 0x03fb, 0x0790, 0x09b2, 0x0913, 0x05cf, 0x00eb, 0xfb48,
    0xf64a, 0xf37c, 0xf2b3, 0xf323, 0xf4d0, 0xf7ef, 0xfb9f, 0xfef9,
    0x01fe, 0x0449, 0x059e, 0x05ed, 0x056a, 0x0479, 0x03c0, 0x03e8,
    0x04e7, 0x05b0, 0x04e3, 0x0299, 0x000e, 0xfe85, 0xfec6, 0x0064,
    0x0255, 0x0457, 0x063b, 0x064e, 0x0327, 0xfd37, 0xf640, 0xf06a,
    0xedda, 0xf00d, 0xf643, 0xfe9d, 0x06e3, 0x0d2c, 0x1056, 0x0fd6,
    0x0c9c, 0x0872, 0x04c1, 0x022d, 0x0072, 0xff95, 0xfeca, 0xfd63,
    0xfc58, 0xfbc5, 0xfbf5, 0xfd7a, 0xffc2, 0x0125, 0x0153, 0x014d,
    0x00b3, 0xff2a, 0xfe57, 0xfebd, 0xfe61, 0xfd00, 0xfbbb, 0xfb3a,
    0xfc07, 0xfeed, 0x03e7, 0x07ed, 0x084c, 0x0590, 0x0143, 0xfbd8,
    0xf644, 0xf31e, 0xf2c4, 0xf41d, 0xf719, 0xfb19, 0xff94, 0x0490,
    0x0914, 0x0b28, 0x0ab2, 0x0996, 0x0854, 0x064f, 0x03dd, 0x018e,
    0xff1e, 0xfc25, 0xf943, 0xf7a5, 0xf7b0, 0xf991, 0xfd89, 0x02cc,
    0x06ec, 0x0779, 0x04d7, 0x013f, 0xfd9e, 0xfa3e, 0xf7a0, 0xf638,
    0xf6d1, 0xfa06, 0x0002, 0x0723, 0x0ccb, 0x0f2a, 0x0e53, 0x0b31,
    0x0633, 0x00aa, 0xfd2d, 0xfd2c, 0xfea5, 0xfed1, 0xfc9f, 0xf8bd,
    0xf471, 0xf183, 0xf1b7, 0xf5a3, 0xfbdf, 0x0210, 0x075f, 0x0aec,
    0x0a9e, 0x0623, 0x0069, 0xfbd0, 0xf81d, 0xf558, 0xf566, 0xf8fa,
    0xfed4, 0x057a, 0x0ac8, 0x0c46, 0x09d4, 0x05df, 0x01ab, 0xfd50,
    0xfa36, 0xf928, 0xf937, 0xfa57, 0xfd1d, 0x0091, 0x03d6, 0x0751,
    0x0a73, 0x0b8e, 0x0a18, 0x0761, 0x04a9, 0x024c, 0x005a, 0xfed7,
    0xfd0a, 0xfa77, 0xf839, 0xf758, 0xf6f0, 0xf66b, 0xf77a, 0xfac2,
    0xff2e, 0x041b, 0x08d7, 0x0b96, 0x0b01, 0x073b, 0x0164, 0xfb4a,
    0xf6b0, 0xf4b1, 0xf5ac, 0xf8cb, 0xfd06, 0x0204, 0x0663, 0x07fd,
    0x06f1, 0x0516, 0x0376, 0x02b7, 0x0385, 0x042b, 0x0266, 0xfe85,
    0xfa2d, 0xf6bb, 0xf5b3, 0xf892, 0xfeba
};


static Int32 PanasonicMotorCount = 9392;
static Int16 PanasonicMotorSamples[] = {
    0x007e, 0x02d3, 0x03a2, 0x02ce, 0x0122, 0xff24, 0xfdb0, 0xfc3e,
    0xf9b1, 0xf745, 0xf6af, 0xf7e4, 0xfaee, 0x01c6, 0x0c62, 0x15e9,
    0x19de, 0x1836, 0x11cf, 0x0735, 0xfa12, 0xed77, 0xe5c6, 0xe511,
    0xea8d, 0xf3d4, 0xff0c, 0x0a40, 0x1284, 0x169e, 0x15ad, 0x0f48,
    0x0483, 0xf75a, 0xeb67, 0xe546, 0xe85c, 0xf38a, 0x0198, 0x0dfb,
    0x1699, 0x19a9, 0x154c, 0x0a9f, 0xfde0, 0xf384, 0xedee, 0xecbd,
    0xeec6, 0xf2f6, 0xf864, 0xfdc4, 0x00c0, 0x0188, 0x0363, 0x06b4,
    0x0845, 0x0730, 0x0666, 0x0845, 0x0b3a, 0x0cdc, 0x0bf0, 0x087c,
    0x02b9, 0xfb33, 0xf491, 0xf17d, 0xf196, 0xf3b6, 0xf81e, 0xfe03,
    0x03ae, 0x0824, 0x0a74, 0x094f, 0x0606, 0x038f, 0x01f0, 0xff83,
    0xfd13, 0xfc83, 0xfd05, 0xfc5e, 0xfa73, 0xf8ff, 0xf9a4, 0xfc54,
    0xff4d, 0x00f9, 0x009a, 0xff20, 0xfe2a, 0xfe41, 0xff7a, 0x01f8,
    0x04f2, 0x06d4, 0x060e, 0x0238, 0xfd3d, 0xfaf7, 0xfd35, 0x01fd,
    0x0640, 0x086a, 0x0802, 0x052c, 0x0118, 0xfc54, 0xf637, 0xf1e2,
    0xf2f3, 0xf801, 0xff5d, 0x06bf, 0x0be7, 0x0e0a, 0x0d15, 0x0a00,
    0x0534, 0x006d, 0xfd45, 0xfbac, 0xfb30, 0xfb4e, 0xfc00, 0xfcc6,
    0xfd24, 0xfcc4, 0xfc26, 0xfb9b, 0xfaa6, 0xf8f8, 0xf795, 0xf81c,
    0xfa61, 0xfe20, 0x038e, 0x0a3b, 0x0f7c, 0x1127, 0x0fd2, 0x0b6d,
    0x0356, 0xf9c0, 0xf2d4, 0xf082, 0xf216, 0xf787, 0x00fc, 0x0b9f,
    0x128c, 0x1284, 0x0b9f, 0xfff6, 0xf350, 0xe9d2, 0xe679, 0xeb06,
    0xf61f, 0x0298, 0x0c0a, 0x1106, 0x1181, 0x0d82, 0x06d0, 0x0114,
    0xfcbe, 0xf894, 0xf5ff, 0xf5cc, 0xf677, 0xf816, 0xfc61, 0x0249,
    0x0681, 0x0768, 0x05e9, 0x0331, 0xffcc, 0xfdb3, 0xfe81, 0x0184,
    0x046e, 0x05a1, 0x0590, 0x0519, 0x04f9, 0x04ab, 0x036c, 0x01c5,
    0xffcf, 0xfd2f, 0xfb03, 0xfa40, 0xfa67, 0xfb2a, 0xfc43, 0xfc98,
    0xfc25, 0xfc4d, 0xfd96, 0xff17, 0xffd6, 0xfef9, 0xfc14, 0xf85a,
    0xf654, 0xf796, 0xfcb1, 0x0444, 0x0afa, 0x0f23, 0x10ac, 0x0fec,
    0x0e61, 0x0c3d, 0x088b, 0x034f, 0xfb97, 0xf1aa, 0xe8e0, 0xe5c7,
    0xea43, 0xf4b8, 0x0279, 0x0fc5, 0x181d, 0x182e, 0x0ed7, 0xff56,
    0xf05e, 0xe75e, 0xe5f8, 0xebb7, 0xf77f, 0x05e1, 0x1283, 0x19a2,
    0x1916, 0x123e, 0x0874, 0xfdd8, 0xf4c8, 0xef8b, 0xee6f, 0xf1c7,
    0xf849, 0xfd24, 0xfee4, 0x00b4, 0x02e6, 0x031f, 0x0204, 0x01cb,
    0x0317, 0x055e, 0x074f, 0x08fb, 0x0a90, 0x0a50, 0x0667, 0x009e,
    0xfbd0, 0xf854, 0xf637, 0xf66c, 0xf931, 0xfc5c, 0xfe88, 0xffbf,
    0xffda, 0xffff, 0x0192, 0x03f0, 0x058e, 0x05f7, 0x052e, 0x034c,
    0x007e, 0xfd1e, 0xfae1, 0xfb61, 0xfe60, 0x01e8, 0x03da, 0x0303,
    0xff55, 0xfae4, 0xf8c5, 0xf9d0, 0xfd56, 0x025a, 0x0648, 0x0555,
    0xff06, 0xf751, 0xf256, 0xf258, 0xf7ba, 0x0042, 0x0827, 0x0d19,
    0x0f38, 0x0eb7, 0x0ae7, 0x0478, 0xfdc6, 0xf94a, 0xf7e3, 0xf925,
    0xfc75, 0x00fb, 0x0615, 0x0a66, 0x0c3a, 0x0afc, 0x0738, 0x0261,
    0xfdb1, 0xfa17, 0xf767, 0xf483, 0xf1bf, 0xf15f, 0xf56e, 0xfcc3,
    0x0462, 0x0a5c, 0x0c61, 0x092c, 0x024d, 0xfb30, 0xf766, 0xf763,
    0xfad0, 0x0185, 0x0915, 0x0d4f, 0x0c6f, 0x07d5, 0x00c2, 0xf9af,
    0xf5e3, 0xf5c4, 0xf7ad, 0xfb7e, 0x00a2, 0x0450, 0x0511, 0x03b0,
    0x0152, 0xfdda, 0xfa04, 0xf7f6, 0xf851, 0xfa52, 0xfd46, 0x0180,
    0x061c, 0x0990, 0x0baa, 0x0c0f, 0x097c, 0x042b, 0xfea5, 0xf9f7,
    0xf519, 0xf0f9, 0xeffb, 0xf259, 0xf6b5, 0xfcc3, 0x0475, 0x0bc7,
    0x108b, 0x125a, 0x114e, 0x0d96, 0x08eb, 0x0525, 0x021f, 0xffeb,
    0xfdc9, 0xfa4d, 0xf5da, 0xf20b, 0xf0c2, 0xf245, 0xf5b4, 0xfae0,
    0x0172, 0x07ce, 0x0ba1, 0x0b26, 0x064e, 0xfed2, 0xf6ec, 0xf1a2,
    0xf1f3, 0xf846, 0x029f, 0x0d59, 0x1378, 0x1292, 0x0c4e, 0x0347,
    0xfa9a, 0xf44b, 0xf234, 0xf4ee, 0xf938, 0xfbcc, 0xfcf2, 0xfed7,
    0x0123, 0x0318, 0x0554, 0x076c, 0x0806, 0x06bb, 0x032f, 0xfe57,
    0xfb53, 0xfb8d, 0xfcfb, 0xfdc2, 0xfe6b, 0xfefb, 0xff3e, 0xff94,
    0xffdb, 0x0076, 0x025b, 0x04b7, 0x0650, 0x06be, 0x05a6, 0x032c,
    0xffc2, 0xfc10, 0xf94d, 0xf8bb, 0xf99b, 0xf97f, 0xf7cb, 0xf6fc,
    0xfa21, 0x00f5, 0x0814, 0x0d34, 0x0f70, 0x0e5c, 0x0ac0, 0x0646,
    0x01eb, 0xfd52, 0xf8ae, 0xf41a, 0xefc7, 0xecee, 0xed2a, 0xf182,
    0xf9d9, 0x04f6, 0x0f8e, 0x160c, 0x16c4, 0x1310, 0x0d01, 0x05eb,
    0xff1c, 0xfa28, 0xf8c1, 0xfa98, 0xfd3f, 0xff6c, 0x013a, 0x0254,
    0x01cf, 0xff7f, 0xfc94, 0xf8c5, 0xf49d, 0xf364, 0xf5bf, 0xf886,
    0xf934, 0xf86e, 0xf809, 0xfa56, 0x0107, 0x09f5, 0x1153, 0x150f,
    0x14f1, 0x103c, 0x06db, 0xfbb2, 0xf385, 0xf08d, 0xf21a, 0xf6cb,
    0xfc69, 0x0110, 0x044d, 0x0646, 0x0650, 0x0514, 0x03d0, 0x026d,
    0x00e1, 0x0013, 0xffc8, 0xfeb1, 0xfd07, 0xfc8f, 0xfcb4, 0xfc45,
    0xfc96, 0xfecd, 0x015d, 0x0226, 0x0155, 0x0035, 0xffcc, 0x00bd,
    0x034e, 0x0627, 0x0771, 0x05d7, 0x00e5, 0xf9d6, 0xf408, 0xf1f9,
    0xf3c8, 0xf965, 0x0259, 0x0bd8, 0x12df, 0x15f7, 0x135e, 0x0a86,
    0xfdeb, 0xf1f8, 0xe97e, 0xe5cc, 0xe8a0, 0xf0d9, 0xfa86, 0x033d,
    0x0a8a, 0x0f34, 0x0fba, 0x0c80, 0x0736, 0x0189, 0xfd32, 0xfb91,
    0xfb99, 0xfb91, 0xfc0e, 0xfd62, 0xfe2c, 0xfe74, 0xfff3, 0x01f1,
    0x02c8, 0x03dc, 0x063c, 0x087e, 0x0991, 0x0968, 0x07bf, 0x0407,
    0xff3e, 0xfafb, 0xf70d, 0xf314, 0xf0c6, 0xf21b, 0xf6ce, 0xfcde,
    0x0316, 0x0867, 0x0b52, 0x0b7d, 0x0915, 0x0508, 0xffe3, 0xfa52,
    0xf587, 0xf1fa, 0xf0bf, 0xf38e, 0xfab0, 0x02c4, 0x09c2, 0x0ffe,
    0x1324, 0x114a, 0x0b75, 0x0433, 0xfd2d, 0xf6fc, 0xf30e, 0xf274,
    0xf40a, 0xf654, 0xfa34, 0x0077, 0x0773, 0x0d17, 0x103c, 0x1111,
    0x0eb4, 0x0924, 0x0159, 0xf7c6, 0xef44, 0xec64, 0xf06f, 0xf806,
    0xffe3, 0x05e5, 0x0893, 0x085b, 0x06e9, 0x0503, 0x02f6, 0x00e6,
    0xfeb9, 0xfb8f, 0xf74b, 0xf41b, 0xf30e, 0xf280, 0xf250, 0xf4c6,
    0xfa5c, 0x00d0, 0x0625, 0x09f2, 0x0c37, 0x0d19, 0x0ce6, 0x0bc2,
    0x092b, 0x052b, 0x007e, 0xfbb9, 0xf828, 0xf704, 0xf878, 0xfb51,
    0xfe57, 0x0173, 0x043a, 0x05fc, 0x0602, 0x0539, 0x04da, 0x0437,
    0x02ca, 0x010b, 0xff40, 0xfc84, 0xf9d0, 0xf896, 0xf909, 0xfc3a,
    0x01e5, 0x07d0, 0x0b2b, 0x0a3f, 0x0598, 0xff2f, 0xf94c, 0xf518,
    0xf359, 0xf4c9, 0xf840, 0xfb3e, 0xfc84, 0xfcaa, 0xfd30, 0xff4a,
    0x0301, 0x0738, 0x09bb, 0x09c0, 0x083a, 0x061e, 0x033c, 0xfe5f,
    0xf932, 0xf611, 0xf52f, 0xf762, 0xfd48, 0x04ca, 0x0ab5, 0x0df8,
    0x0e54, 0x0b30, 0x058f, 0xff69, 0xfaa1, 0xf7e0, 0xf658, 0xf51f,
    0xf4a0, 0xf667, 0xfa82, 0xffc0, 0x046b, 0x0777, 0x08e0, 0x08dc,
    0x0754, 0x0443, 0x014a, 0xff39, 0xfe2d, 0xff29, 0x01ea, 0x04aa,
    0x0601, 0x05c9, 0x030c, 0xfe40, 0xf9a3, 0xf6f2, 0xf66f, 0xf812,
    0xfc34, 0x0140, 0x04c6, 0x05dd, 0x0438, 0xffe7, 0xfa44, 0xf57c,
    0xf3b4, 0xf57c, 0xf9a1, 0xfe8b, 0x0393, 0x0851, 0x0bde, 0x0cde,
    0x09e6, 0x03b4, 0xfcff, 0xf7e5, 0xf4e3, 0xf393, 0xf479, 0xf827,
    0xfda9, 0x045c, 0x0af1, 0x0e93, 0x0efe, 0x0e4f, 0x0d23, 0x0a1d,
    0x048f, 0xfdfc, 0xf870, 0xf57c, 0xf680, 0xfaf0, 0xffd2, 0x01bc,
    0x0058, 0xfebc, 0xfdd3, 0xfdb5, 0xfeeb, 0xffe4, 0xffc0, 0xff39,
    0xff0b, 0xff53, 0xffa9, 0xffbe, 0xff4c, 0xfdf1, 0xfc53, 0xfc2e,
    0xfd17, 0xfe61, 0x004c, 0x01b7, 0x025c, 0x0317, 0x0449, 0x05ba,
    0x0651, 0x0522, 0x02c0, 0xfe7d, 0xf7e8, 0xf269, 0xf1a7, 0xf588,
    0xfc32, 0x0403, 0x0ae9, 0x0ebb, 0x0edd, 0x0b19, 0x0381, 0xfa99,
    0xf43b, 0xf230, 0xf415, 0xf949, 0x0043, 0x0738, 0x0c1c, 0x0e5e,
    0x0ed4, 0x0d40, 0x0921, 0x028f, 0xfa4b, 0xf1ae, 0xeba3, 0xeb08,
    0xef55, 0xf651, 0xfedc, 0x06c5, 0x0ab4, 0x098a, 0x050f, 0x00a3,
    0xfe43, 0xfdfa, 0xffdf, 0x0310, 0x056e, 0x04ff, 0x0302, 0x0120,
    0xfe31, 0xfaa7, 0xf839, 0xf8b0, 0xfb74, 0xfefd, 0x0300, 0x05b2,
    0x0657, 0x0643, 0x064e, 0x0586, 0x0455, 0x039d, 0x0280, 0x0075,
    0xfd7f, 0xfae6, 0xfac4, 0xfde2, 0x021c, 0x04d0, 0x057a, 0x0437,
    0x00cc, 0xfc22, 0xf7a2, 0xf44d, 0xf41f, 0xf730, 0xfa28, 0xfb1f,
    0xfb52, 0xfc68, 0xfefd, 0x036e, 0x0855, 0x0b0c, 0x0a94, 0x087f,
    0x0680, 0x0403, 0x001a, 0xfb03, 0xf642, 0xf454, 0xf72a, 0xfe48,
    0x06ab, 0x0d84, 0x1174, 0x114a, 0x0c3e, 0x03a6, 0xfa9e, 0xf408,
    0xf1ac, 0xf381, 0xf72a, 0xfa26, 0xfcb2, 0xff60, 0x00cd, 0x00a1,
    0x002b, 0xffe4, 0xff8c, 0x00ea, 0x0506, 0x09ad, 0x0cb7, 0x0cc7,
    0x09ae, 0x03ff, 0xfd99, 0xf8a1, 0xf528, 0xf341, 0xf458, 0xf87c,
    0xfd00, 0x0091, 0x03be, 0x063b, 0x075c, 0x0717, 0x056b, 0x01d2,
    0xfc64, 0xf6d5, 0xf34b, 0xf2df, 0xf663, 0xfd22, 0x0445, 0x09d8,
    0x0d21, 0x0d7e, 0x0a23, 0x0348, 0xfa8a, 0xf26d, 0xee05, 0xee5f,
    0xf2aa, 0xf904, 0xff87, 0x054d, 0x09ed, 0x0e0f, 0x115f, 0x1197,
    0x0e6c, 0x0975, 0x0443, 0x006d, 0xfddf, 0xfbba, 0xfa0e, 0xf985,
    0xfb41, 0xfeaf, 0x020a, 0x031e, 0x00ba, 0xfd3a, 0xfa34, 0xf812,
    0xf774, 0xf93a, 0xfd21, 0x00c5, 0x0306, 0x041f, 0x03d3, 0x012a,
    0xfd09, 0xf999, 0xf7db, 0xf947, 0xfd94, 0x030c, 0x086c, 0x0bb4,
    0x0b64, 0x07c7, 0x026f, 0xfd14, 0xf89a, 0xf4fe, 0xf482, 0xf7e9,
    0xfb8d, 0xfdce, 0x01a7, 0x075f, 0x0bcb, 0x0e64, 0x1034, 0x0f7e,
    0x0b2d, 0x0481, 0xfc14, 0xf3c1, 0xef2a, 0xf03f, 0xf4f3, 0xfb5a,
    0x0231, 0x075a, 0x094c, 0x0839, 0x04eb, 0x0004, 0xfa22, 0xf4e1,
    0xf2b8, 0xf39d, 0xf6c9, 0xfbce, 0x0025, 0x01bc, 0x02f7, 0x05a7,
    0x06f1, 0x0520, 0x0289, 0x014c, 0x00ef, 0x011d, 0x026a, 0x03f0,
    0x03a2, 0x0183, 0xff2f, 0xfe52, 0xfeda, 0xff62, 0xffe9, 0x0132,
    0x0320, 0x04d8, 0x061a, 0x061c, 0x04b9, 0x0328, 0x01bc, 0xff37,
    0xfb80, 0xf84d, 0xf604, 0xf4d5, 0xf564, 0xf832, 0xfd5d, 0x0422,
    0x0a0b, 0x0c6a, 0x0a9c, 0x053c, 0xfdd9, 0xf6d3, 0xf2eb, 0xf320,
    0xf736, 0xfda4, 0x0390, 0x06f0, 0x077c, 0x05eb, 0x03ef, 0x03c3,
    0x0477, 0x03dd, 0x01f5, 0xffc3, 0xfd53, 0xfada, 0xf830, 0xf5c2,
    0xf62b, 0xfa87, 0x0108, 0x089c, 0x0fce, 0x1395, 0x12de, 0x0e67,
    0x0795, 0xff5e, 0xf710, 0xf177, 0xf10f, 0xf522, 0xf9b9, 0xfc49,
    0xfcc3, 0xfb92, 0xf914, 0xf754, 0xf869, 0xfb46, 0xfeee, 0x033c,
    0x06c8, 0x090a, 0x0afa, 0x0bec, 0x0a55, 0x06fe, 0x03c9, 0x0147,
    0xffc2, 0xffbb, 0x009b, 0x017e, 0x0232, 0x02ca, 0x02c4, 0x0186,
    0xff55, 0xfcf8, 0xfa88, 0xf7ec, 0xf5a5, 0xf4a0, 0xf5cf, 0xf969,
    0xff4e, 0x053e, 0x089e, 0x0928, 0x07d7, 0x0581, 0x01cf, 0xfc28,
    0xf58b, 0xf117, 0xf0aa, 0xf321, 0xf6f9, 0xfb4d, 0xffb2, 0x0365,
    0x05b3, 0x0793, 0x0a1e, 0x0cc9, 0x0e12, 0x0d8b, 0x0b54, 0x0787,
    0x034b, 0x0087, 0xffeb, 0xffdd, 0x003e, 0x01e8, 0x03cc, 0x0483,
    0x028e, 0xfe60, 0xfa63, 0xf76d, 0xf60e, 0xf776, 0xfafe, 0xfe2f,
    0xffd2, 0xfffc, 0xfecc, 0xfc41, 0xf875, 0xf56d, 0xf58b, 0xf96a,
    0xff3d, 0x04c9, 0x09bf, 0x0ce7, 0x0cdc, 0x0a1e, 0x05b9, 0x00c6,
    0xfc8e, 0xf89f, 0xf513, 0xf495, 0xf77e, 0xfae7, 0xfdb1, 0x0157,
    0x0574, 0x08c8, 0x0b6d, 0x0d45, 0x0d93, 0x0b54, 0x04f7, 0xfbb5,
    0xf45f, 0xf20a, 0xf3ed, 0xf7d6, 0xfcdf, 0x02ad, 0x0731, 0x081b,
    0x054e, 0x0155, 0xfd8d, 0xf9fd, 0xf886, 0xf883, 0xf7d5, 0xf754,
    0xf8be, 0xfacb, 0xfcde, 0x0131, 0x0650, 0x0858, 0x06fb, 0x05fa,
    0x0718, 0x08eb, 0x0a07, 0x09d3, 0x0770, 0x0318, 0xfdf2, 0xf89a,
    0xf50c, 0xf4a3, 0xf735, 0xfbd2, 0x01e9, 0x079e, 0x0a18, 0x093f,
    0x063c, 0x02a4, 0xff6a, 0xfc9a, 0xfa92, 0xf982, 0xf9d6, 0xfb77,
    0xfcd1, 0xfcb0, 0xfc38, 0xfdd5, 0x0130, 0x03cf, 0x0552, 0x05e4,
    0x0427, 0x0004, 0xfb6f, 0xf73f, 0xf532, 0xf6e5, 0xfada, 0xfe5b,
    0xff5b, 0xfeee, 0x0054, 0x0523, 0x0b20, 0x0de2, 0x0ba5, 0x069a,
    0x019c, 0xfe3b, 0xfc05, 0xfa36, 0xf8f0, 0xf941, 0xfba8, 0xffa7,
    0x04d8, 0x0927, 0x0aca, 0x0a58, 0x089d, 0x053a, 0x00c2, 0xfd54,
    0xfb91, 0xfa48, 0xf80c, 0xf4ef, 0xf234, 0xf18f, 0xf4b2, 0xfb00,
    0x01a5, 0x06a5, 0x0982, 0x09e3, 0x07db, 0x054e, 0x042f, 0x03d7,
    0x02d5, 0x012c, 0xff1e, 0xfcce, 0xfb30, 0xfb2d, 0xfc81, 0xfee0,
    0x026a, 0x0627, 0x0810, 0x07b6, 0x069d, 0x0478, 0xfff2, 0xfa3c,
    0xf644, 0xf532, 0xf5c5, 0xf71f, 0xfa09, 0xfe57, 0x0244, 0x059f,
    0x097a, 0x0c31, 0x0a84, 0x04df, 0xfde2, 0xf73a, 0xf1f2, 0xef68,
    0xeff0, 0xf300, 0xf867, 0xff3c, 0x05e2, 0x0b4e, 0x0f03, 0x1049,
    0x0f1c, 0x0d6a, 0x0c08, 0x0a1a, 0x073a, 0x038e, 0xff32, 0xfa71,
    0xf7b1, 0xf80e, 0xf9d4, 0xfb00, 0xfa67, 0xf9c3, 0xfab1, 0xfc38,
    0xfe41, 0x012a, 0x03ba, 0x04ca, 0x04ae, 0x02f3, 0xff39, 0xfb4c,
    0xf8c7, 0xf7c8, 0xf7d8, 0xf9f0, 0xfdc0, 0x01e0, 0x06bc, 0x0b32,
    0x0ca7, 0x0a9e, 0x0681, 0x013c, 0xfbed, 0xf6a0, 0xf228, 0xf051,
    0xf17b, 0xf574, 0xfc48, 0x057c, 0x0df0, 0x12c7, 0x13c6, 0x1239,
    0x0eba, 0x0895, 0xff4c, 0xf50f, 0xee65, 0xed77, 0xf110, 0xf76c,
    0xfe6b, 0x0439, 0x07b0, 0x07d0, 0x053a, 0x0187, 0xfe22, 0xfb72,
    0xf953, 0xf7bb, 0xf713, 0xf875, 0xfb45, 0xfd65, 0xff2b, 0x01ad,
    0x035c, 0x0375, 0x03d6, 0x05de, 0x08bf, 0x0baf, 0x0d81, 0x0c65,
    0x0831, 0x01e4, 0xfa56, 0xf3aa, 0xf062, 0xf12b, 0xf4ed, 0xfa59,
    0x00f7, 0x07da, 0x0d57, 0x0f0b, 0x0c15, 0x0751, 0x03a9, 0x00cb,
    0xfda2, 0xfb01, 0xf9e8, 0xf953, 0xf86c, 0xf772, 0xf752, 0xf938,
    0xfcef, 0x017e, 0x0500, 0x05c6, 0x03bc, 0x00cd, 0xfea8, 0xfcb6,
    0xfb32, 0xfadf, 0xfb63, 0xfbb0, 0xfb96, 0xfc02, 0xfe18, 0x033e,
    0x0a9e, 0x0fc7, 0x0f9d, 0x0b0d, 0x04b1, 0xfddd, 0xf783, 0xf386,
    0xf27c, 0xf46a, 0xf9ac, 0x01ac, 0x09e4, 0x0f04, 0x101b, 0x0dec,
    0x08da, 0x0240, 0xfc73, 0xf908, 0xf8fa, 0xfb96, 0xfdd9, 0xfd14,
    0xfa10, 0xf749, 0xf593, 0xf528, 0xf6eb, 0xfb70, 0x017c, 0x06fe,
    0x0ab2, 0x0bdf, 0x0a8a, 0x07a1, 0x048f, 0x01fc, 0xff83, 0xfe0f,
    0xfe4f, 0xfe79, 0xfd87, 0xfdca, 0x0062, 0x02b1, 0x03a0, 0x04ab,
    0x0514, 0x033a, 0x002a, 0xfc56, 0xf74d, 0xf2ab, 0xf0b7, 0xf254,
    0xf780, 0xfed8, 0x0553, 0x0997, 0x0c9c, 0x0e0f, 0x0bed, 0x05db,
    0xfe28, 0xf7ef, 0xf4c0, 0xf45f, 0xf55c, 0xf6a5, 0xf903, 0xfcc2,
    0x00fc, 0x0432, 0x062c, 0x082c, 0x09a0, 0x09f6, 0x09eb, 0x0a69,
    0x0bc3, 0x0c33, 0x0a1b, 0x04e5, 0xfda6, 0xf773, 0xf3c3, 0xf352,
    0xf56c, 0xf81d, 0xfbd7, 0x0031, 0x0385, 0x050c, 0x049c, 0x01da,
    0xfdcc, 0xfb37, 0xfa32, 0xf949, 0xf8a6, 0xf9c0, 0xfb96, 0xfcfe,
    0xff41, 0x028f, 0x0670, 0x0ac3, 0x0df3, 0x0e36, 0x0bd1, 0x06b9,
    0x0032, 0xf93e, 0xf1ac, 0xecb9, 0xecfe, 0xf1d0, 0xf82e, 0x001d,
    0x0941, 0x1003, 0x12a7, 0x11ff, 0x1011, 0x0bb6, 0x0326, 0xf824,
    0xeef7, 0xeb34, 0xedc6, 0xf487, 0xfcb3, 0x0498, 0x0a2d, 0x0aec,
    0x078f, 0x0316, 0xff50, 0xfca2, 0xfb3f, 0xfbb4, 0xfc72, 0xfce0,
    0xfd35, 0xfd31, 0xfc70, 0xfc38, 0xfe49, 0x005f, 0x0144, 0x02fa,
    0x0753, 0x0cb0, 0x1037, 0x10e4, 0x0df3, 0x0642, 0xfb1e, 0xf0b3,
    0xea14, 0xe8c8, 0xed48, 0xf657, 0x010d, 0x0afc, 0x1234, 0x1453,
    0x1046, 0x087e, 0x0175, 0xfd74, 0xfb4b, 0xf9f3, 0xfa11, 0xfa86,
    0xfa0c, 0xf8bd, 0xf778, 0xf858, 0xfc7e, 0x0216, 0x06f9, 0x099a,
    0x08d0, 0x0469, 0xfe69, 0xf9cc, 0xf744, 0xf6e1, 0xf8e2, 0xfc86,
    0xfec9, 0xfde6, 0xfccd, 0xfe3f, 0x02af, 0x084f, 0x0c5e, 0x0d3f,
    0x0b24, 0x07cb, 0x032c, 0xfcff, 0xf663, 0xf1e7, 0xf169, 0xf4d8,
    0xfbe7, 0x045a, 0x0aff, 0x0efd, 0x102f, 0x0dc4, 0x0862, 0x02c3,
    0xfe29, 0xfa4b, 0xf745, 0xf4d4, 0xf2a9, 0xf178, 0xf33a, 0xf7bd,
    0xfd0f, 0x0284, 0x0781, 0x0a63, 0x0a94, 0x0988, 0x0791, 0x0472,
    0x0235, 0x0210, 0x027d, 0x022d, 0x0109, 0xfed9, 0xfb7c, 0xf955,
    0xfa25, 0xfc41, 0xfe4e, 0x00f2, 0x0451, 0x0654, 0x05a1, 0x024e,
    0xfcae, 0xf625, 0xf0f3, 0xef8a, 0xf329, 0xfa72, 0x01ef, 0x07a0,
    0x0bf5, 0x0f17, 0x0ee3, 0x0a1a, 0x02cf, 0xfbd9, 0xf733, 0xf4fa,
    0xf3bc, 0xf33b, 0xf3e7, 0xf66c, 0xfb23, 0x0121, 0x07ec, 0x0e0e,
    0x11b7, 0x1255, 0x10c3, 0x0d90, 0x091b, 0x046b, 0xffdf, 0xfbcd,
    0xf968, 0xf9e1, 0xfb7d, 0xfc4a, 0xfc70, 0xfb5d, 0xf9d0, 0xf9f3,
    0xfbcf, 0xfe8b, 0x01bf, 0x0473, 0x04ff, 0x034d, 0xffcd, 0xfb29,
    0xf784, 0xf679, 0xf82d, 0xfb4b, 0xfe2f, 0x0038, 0x0203, 0x04a4,
    0x082b, 0x0b10, 0x0bbd, 0x09f2, 0x0587, 0xfe62, 0xf53d, 0xed73,
    0xeba2, 0xefb4, 0xf6a6, 0xfe5d, 0x0649, 0x0cfe, 0x10c9, 0x11fb,
    0x121b, 0x10d9, 0x0c07, 0x035b, 0xf925, 0xf161, 0xeee5, 0xf13d,
    0xf5ed, 0xfb62, 0x011e, 0x054e, 0x06c3, 0x0665, 0x0475, 0x010e,
    0xfd48, 0xfa2a, 0xf7bc, 0xf656, 0xf805, 0xfcb5, 0x00da, 0x02f5,
    0x04cb, 0x05eb, 0x04ac, 0x0240, 0x0137, 0x0283, 0x04cc, 0x06a2,
    0x06eb, 0x0548, 0x0198, 0xfc38, 0xf787, 0xf563, 0xf54d, 0xf709,
    0xfb25, 0x0132, 0x07c1, 0x0d46, 0x100a, 0x0e83, 0x0a3d, 0x05d5,
    0x015a, 0xfbd4, 0xf661, 0xf37b, 0xf3e5, 0xf61b, 0xf7e7, 0xf912,
    0xfb9e, 0x0038, 0x0531, 0x08f6, 0x09fe, 0x075b, 0x0273, 0xfd4d,
    0xf8bf, 0xf516, 0xf3bf, 0xf5a8, 0xf9aa, 0xfe65, 0x0258, 0x0565,
    0x0868, 0x0b5d, 0x0cd9, 0x0ae1, 0x062d, 0x00ec, 0xfc6e, 0xf90f,
    0xf684, 0xf5f0, 0xf8a6, 0xfdf7, 0x0473, 0x0a57, 0x0d65, 0x0d02,
    0x0a84, 0x0694, 0x01a3, 0xfce8, 0xf991, 0xf7f9, 0xf7af, 0xf7f2,
    0xf79f, 0xf6b6, 0xf6cf, 0xf916, 0xfcdf, 0x00e4, 0x047e, 0x06d9,
    0x077e, 0x0737, 0x070d, 0x06e9, 0x063e, 0x0562, 0x044c, 0x01f8,
    0xfe46, 0xfa89, 0xf7fe, 0xf724, 0xf8ae, 0xfbd6, 0xfed3, 0x00c5,
    0x0265, 0x0488, 0x0673, 0x0734, 0x05ce, 0x0199, 0xfbca, 0xf712,
    0xf5ac, 0xf85c, 0xfdd4, 0x02fa, 0x059a, 0x05cc, 0x0481, 0x0211,
    0xfed3, 0xfb5f, 0xf845, 0xf631, 0xf579, 0xf605, 0xf7e2, 0xfb24,
    0xffbd, 0x0552, 0x0aa0, 0x0df5, 0x0f5b, 0x1027, 0x1069, 0x0f84,
    0x0c54, 0x060a, 0xfce1, 0xf3fa, 0xf02c, 0xf265, 0xf777, 0xfa5e,
    0xfa7e, 0xfa28, 0xfad8, 0xfddc, 0x024e, 0x05b8, 0x06c3, 0x0739,
    0x06e3, 0x047c, 0x007e, 0xfbfd, 0xf833, 0xf58e, 0xf501, 0xf69a,
    0xfa47, 0xff89, 0x056a, 0x0a8b, 0x0c9f, 0x0b83, 0x0765, 0x013f,
    0xfad9, 0xf5ca, 0xf352, 0xf349, 0xf565, 0xf8fd, 0xfe48, 0x0427,
    0x0889, 0x0bb2, 0x0e40, 0x0fc4, 0x0f02, 0x0ae7, 0x0349, 0xfadf,
    0xf5ec, 0xf4aa, 0xf5b2, 0xf98a, 0xff09, 0x0215, 0x0135, 0xff68,
    0xff01, 0x00aa, 0x0325, 0x0406, 0x0151, 0xfbbc, 0xf6fb, 0xf60d,
    0xf8cf, 0xfc83, 0x0033, 0x0319, 0x02be, 0xffff, 0xfec9, 0x007c,
    0x0366, 0x06f3, 0x0ae2, 0x0cd5, 0x0a88, 0x04dc, 0xfe93, 0xf951,
    0xf5c6, 0xf468, 0xf583, 0xf91b, 0xfee8, 0x0602, 0x0c02, 0x0e1c,
    0x0bea, 0x0722, 0x020e, 0xfd85, 0xf9dd, 0xf7fe, 0xf853, 0xf969,
    0xfa03, 0xfada, 0xfc24, 0xfd75, 0xfed8, 0x0126, 0x036c, 0x0465,
    0x0481, 0x038a, 0x0027, 0xfb7a, 0xf8ff, 0xf978, 0xfb13, 0xfcd0,
    0xfe77, 0x0026, 0x02f1, 0x074d, 0x0b21, 0x0b2e, 0x0746, 0x01ff,
    0xfcaf, 0xf834, 0xf636, 0xf768, 0xfb00, 0xffd4, 0x053b, 0x096e,
    0x0a75, 0x097d, 0x08b3, 0x074e, 0x03bf, 0xfe9d, 0xf8f6, 0xf361,
    0xf074, 0xf2b3, 0xf88c, 0xfea0, 0x0338, 0x052e, 0x038e, 0x0005,
    0xfc91, 0xfa3e, 0xfa05, 0xfc65, 0x0141, 0x07e4, 0x0f14, 0x13a5,
    0x12dd, 0x0c9a, 0x0304, 0xfa54, 0xf570, 0xf460, 0xf5b3, 0xf848,
    0xfba2, 0xff40, 0x031b, 0x06b5, 0x087b, 0x074d, 0x037d, 0xfdc6,
    0xf6a9, 0xefa9, 0xebaa, 0xedb2, 0xf5cc, 0x008f, 0x0a13, 0x0f9c,
    0x104d, 0x0ca8, 0x05ff, 0xfe63, 0xf816, 0xf458, 0xf2f5, 0xf423,
    0xf824, 0xfd8a, 0x0239, 0x054d, 0x07d2, 0x0ad3, 0x0e4a, 0x114c,
    0x1147, 0x0d16, 0x057b, 0xfcba, 0xf5df, 0xf2e3, 0xf563, 0xfaf0,
    0xff10, 0x0147, 0x01bb, 0xff86, 0xfb83, 0xf7ff, 0xf66e, 0xf7ef,
    0xfcf1, 0x0370, 0x08dc, 0x0b23, 0x0901, 0x035c, 0xfbd5, 0xf3d4,
    0xeede, 0xf0d9, 0xf96e, 0x04bc, 0x0e49, 0x1366, 0x1399, 0x0fc4,
    0x093d, 0x00fa, 0xf92d, 0xf2c9, 0xedc0, 0xeb85, 0xee02, 0xf590,
    0xff67, 0x0843, 0x0eef, 0x12e3, 0x12a2, 0x0cf2, 0x0393, 0xfa50,
    0xf493, 0xf467, 0xf899, 0xfe9e, 0x048d, 0x07d7, 0x06bd, 0x028e,
    0xfdb8, 0xfa4d, 0xf99c, 0xfb53, 0xfd79, 0xfd91, 0xfbfe, 0xfb50,
    0xfbe8, 0xfcce, 0xfe62, 0x00d8, 0x0273, 0x01a6, 0xff61, 0xff64,
    0x02ba, 0x06d4, 0x0a8b, 0x0d13, 0x0cce, 0x0821, 0x0100, 0xfb03,
    0xf70d, 0xf518, 0xf57f, 0xf848, 0xfc07, 0x000d, 0x0401, 0x057f,
    0x0384, 0x017d, 0x01f4, 0x0335, 0x0344, 0x028c, 0x0257, 0x0168,
    0xfeff, 0xfcaa, 0xfb13, 0xf9ba, 0xf964, 0xfb5b, 0xfe90, 0x020f,
    0x0594, 0x07df, 0x06f3, 0x02ea, 0xfe3a, 0xf9dc, 0xf63c, 0xf4a3,
    0xf51a, 0xf6c3, 0xfa5a, 0x0140, 0x092f, 0x0e4c, 0x100c, 0x0f1f,
    0x0af8, 0x02ff, 0xf949, 0xf186, 0xee92, 0xf2c2, 0xfdaf, 0x09b1,
    0x1179, 0x1384, 0x1069, 0x093c, 0xffb5, 0xf6e5, 0xf196, 0xf057,
    0xf2b8, 0xf795, 0xfca4, 0x0018, 0x0224, 0x03f8, 0x0456, 0x0269,
    0x0003, 0xfe49, 0xfd11, 0xfd2c, 0xff96, 0x03fa, 0x08bc, 0x0bcc,
    0x0b93, 0x07c9, 0x022b, 0xfd14, 0xf9c1, 0xf885, 0xf95b, 0xfb7c,
    0xfda7, 0xff83, 0x01f6, 0x0452, 0x055f, 0x0576, 0x04dd, 0x030c,
    0xff0d, 0xf9da, 0xf542, 0xf332, 0xf527, 0xf99d, 0xfe55, 0x02a1,
    0x0698, 0x08f0, 0x0885, 0x0474, 0xfe58, 0xf8ff, 0xf4d7, 0xf328,
    0xf38c, 0xf574, 0xf95f, 0xff35, 0x0620, 0x0cae, 0x1311, 0x17ce,
    0x1819, 0x12ea, 0x0a4d, 0x014c, 0xfa34, 0xf652, 0xf3dc, 0xf26a,
    0xf3a1, 0xf710, 0xfa40, 0xfbbc, 0xfd12, 0xffd3, 0x030c, 0x0550,
    0x05e1, 0x0512, 0x0304, 0xfea1, 0xf91f, 0xf545, 0xf4a3, 0xf74b,
    0xfc79, 0x0334, 0x0997, 0x0e1d, 0x0f88, 0x0c29, 0x05e6, 0xff3d,
    0xfa02, 0xf81c, 0xf8d5, 0xfa9b, 0xfbce, 0xfb6c, 0xf8c1, 0xf5d8,
    0xf69f, 0xfb3c, 0x0211, 0x08c6, 0x0c4c, 0x0c54, 0x0b60, 0x0a55,
    0x06bb, 0x01c8, 0xfed3, 0xfc27, 0xf841, 0xf591, 0xf63b, 0xf9f6,
    0xffb6, 0x05f6, 0x0a5a, 0x0b15, 0x0754, 0xfff2, 0xf76b, 0xf03f,
    0xed5d, 0xf097, 0xf73f, 0xfe34, 0x0502, 0x0a8a, 0x0d19, 0x0ca8,
    0x0a42, 0x0707, 0x03d5, 0x00da, 0xfdef, 0xfc94, 0xfd5e, 0xfdf7,
    0xfd13, 0xfb91, 0xfaa1, 0xf9e7, 0xf9b5, 0xfb02, 0xfd95, 0x020b,
    0x0772, 0x0b02, 0x0bde, 0x0b29, 0x0906, 0x04d0, 0xff3b, 0xf9aa,
    0xf64f, 0xf6e4, 0xf9f2, 0xfd19, 0x005f, 0x0421, 0x06ac, 0x0636,
    0x02b5, 0xfd10, 0xf77b, 0xf4f4, 0xf5dd, 0xf85c, 0xfad5, 0xfd7e,
    0x0131, 0x05d9, 0x0abd, 0x0d4d, 0x0b2b, 0x05d0, 0x0076, 0xfc39,
    0xf7f5, 0xf421, 0xf34b, 0xf63e, 0xfbf1, 0x031d, 0x0a30, 0x0e30,
    0x0db5, 0x0b2a, 0x07d9, 0x0365, 0xfe68, 0xfaac, 0xf96a, 0xfa1b,
    0xfb9f, 0xfc92, 0xfd37, 0xfe42, 0xfee7, 0xfe1e, 0xfc34, 0xfa64,
    0xf93e, 0xf954, 0xfbc4, 0x0126, 0x08af, 0x1026, 0x142a, 0x12ab,
    0x0b6d, 0x0075, 0xf5aa, 0xeed3, 0xee21, 0xf284, 0xf9c1, 0x018f,
    0x0815, 0x0d46, 0x1030, 0x0f1f, 0x0988, 0x00da, 0xf81d, 0xf183,
    0xef34, 0xf210, 0xf87a, 0xff72, 0x03d4, 0x04fa, 0x0455, 0x0320,
    0x0159, 0xfee5, 0xfd3c, 0xfcdb, 0xfc69, 0xfba5, 0xfb52, 0xfb0c,
    0xfb76, 0xfcdd, 0xfe27, 0xff94, 0x0158, 0x039d, 0x06e9, 0x0b9c,
    0x0f82, 0x1011, 0x0d9b, 0x097e, 0x04e1, 0x0060, 0xfb2d, 0xf3f2,
    0xed21, 0xeabc, 0xee50, 0xf698, 0x0037, 0x07c6, 0x0b8b, 0x0c52,
    0x0b06, 0x0813, 0x0479, 0x00c8, 0xfc7b, 0xf725, 0xf25e, 0xf061,
    0xf275, 0xf876, 0x0169, 0x0b19, 0x11de, 0x13e5, 0x118f, 0x0bfc,
    0x03eb, 0xfaac, 0xf336, 0xef06, 0xed9a, 0xeeaa, 0xf23a, 0xf7f4,
    0xfe9a, 0x04ff, 0x09ed, 0x0cfd, 0x0e74, 0x0d26, 0x092f, 0x04fb,
    0x01d8, 0xff23, 0xfd9e, 0xfe27, 0xff64, 0x005d, 0x0047, 0xfeb9,
    0xfcb3, 0xfb9c, 0xfb36, 0xfab2, 0xfa69, 0xfab9, 0xfc31, 0xff0b,
    0x0121, 0x01ba, 0x0225, 0x0139, 0xfdf0, 0xfa66, 0xfa6e, 0xfee0,
    0x0515, 0x0aed, 0x0f07, 0x0fdb, 0x0c1e, 0x045e, 0xfbd0, 0xf581,
    0xf1e3, 0xf0e9, 0xf2f0, 0xf6f6, 0xfb7f, 0x0098, 0x063d, 0x0ad3,
    0x0d6a, 0x0e4d, 0x0cce, 0x0870, 0x035b, 0xff8c, 0xfc9e, 0xf99e,
    0xf7ea, 0xf8f6, 0xfba9, 0xfe14, 0xff6a, 0xff8f, 0xfe4e, 0xfd1e,
    0xfd59, 0xfd9c, 0xfc84, 0xfb5f, 0xfbe3, 0xfdc7, 0x002c, 0x02f5,
    0x0588, 0x0790, 0x0955, 0x0a0b, 0x082c, 0x03d2, 0xff76, 0xfd38,
    0xfc5b, 0xfb81, 0xfa18, 0xf7fa, 0xf63d, 0xf673, 0xf932, 0xfda2,
    0x01be, 0x04fa, 0x07e9, 0x097c, 0x08e2, 0x073c, 0x04b2, 0x00df,
    0xfdf0, 0xfd04, 0xfcd1, 0xfcae, 0xfcb6, 0xfc11, 0xf9b2, 0xf78b,
    0xf86e, 0xfc4e, 0x0141, 0x05b7, 0x08d3, 0x0a37, 0x0927, 0x0523,
    0xffd9, 0xfb93, 0xf916, 0xf82d, 0xf969, 0xfc75, 0x0159, 0x07f3,
    0x0d88, 0x0eb8, 0x0b88, 0x0694, 0x00ab, 0xfa9e, 0xf5b8, 0xf3d5,
    0xf443, 0xf4f2, 0xf71e, 0xfb94, 0x007c, 0x032d, 0x0383, 0x0274,
    0xffcb, 0xfc6f, 0xfab3, 0xfbbc, 0xff2a, 0x042b, 0x086f, 0x09d9,
    0x080c, 0x03b7, 0xfdb8, 0xf799, 0xf3dd, 0xf403, 0xf86f, 0x005f,
    0x0968, 0x0fbd, 0x1151, 0x0e49, 0x075f, 0xff18, 0xf8c8, 0xf577,
    0xf448, 0xf505, 0xf7ff, 0xfd73, 0x0456, 0x0af1, 0x0fc6, 0x1171,
    0x0ec8, 0x0812, 0xffa5, 0xf77b, 0xf14f, 0xeeb0, 0xefe8, 0xf390,
    0xf816, 0xfcea, 0x010c, 0x03f1, 0x05d3, 0x060a, 0x04e8, 0x03cd,
    0x035b, 0x0316, 0x0241, 0xffff, 0xfcc8, 0xfa99, 0xfa4f, 0xfbbf,
    0xfddf, 0xff48, 0xff65, 0xfeb6, 0xfeed, 0x00dc, 0x039f, 0x05e8,
    0x0777, 0x0807, 0x0696, 0x0402, 0x019b, 0xff40, 0xfd14, 0xfc1e,
    0xfc40, 0xfcaa, 0xfe13, 0x011a, 0x041d, 0x0508, 0x0401, 0x01e1,
    0xfeb6, 0xfaf5, 0xf7ca, 0xf5f2, 0xf5a0, 0xf775, 0xfb86, 0x00d6,
    0x0688, 0x0b17, 0x0c0b, 0x08f0, 0x0462, 0x00bc, 0xfec3, 0xfeae,
    0xff8a, 0xffa8, 0xfee4, 0xfdfc, 0xfdb4, 0xfe9b, 0x0105, 0x03a3,
    0x0491, 0x03ea, 0x02b3, 0x01bb, 0x00ae, 0xff92, 0xfe86, 0xfcc4,
    0xfabe, 0xf9c6, 0xfa07, 0xfad0, 0xfc7c, 0xff09, 0x00f8, 0x0145,
    0x00e3, 0x0094, 0xff91, 0xfe44, 0xfdba, 0xfd87, 0xfd0e, 0xfd45,
    0xfe84, 0xfff9, 0x01f2, 0x049e, 0x067f, 0x061d, 0x045b, 0x0294,
    0x00a6, 0xfecb, 0xfdce, 0xfd46, 0xfc2d, 0xfb4e, 0xfc18, 0xfdf3,
    0xffad, 0x01e4, 0x049f, 0x0683, 0x07e3, 0x0930, 0x08a4, 0x0587,
    0x0183, 0xfe0f, 0xfada, 0xf83b, 0xf75d, 0xf7cc, 0xf84f, 0xf8fe,
    0xfac5, 0xfcf2, 0xfe6a, 0x0017, 0x02ec, 0x0577, 0x06b9, 0x075f,
    0x06f9, 0x044e, 0x0093, 0xfe05, 0xfcbb, 0xfb7e, 0xfb6d, 0xfd86,
    0xff98, 0x00b5, 0x01b4, 0x0269, 0x0214, 0x0138, 0x00a9, 0xffe9,
    0xfe41, 0xfbed, 0xf91d, 0xf62c, 0xf540, 0xf8b0, 0xfff6, 0x083f,
    0x0e6e, 0x1059, 0x0dbb, 0x08aa, 0x03d0, 0x0091, 0xfe7e, 0xfc5f,
    0xf9fc, 0xf7f7, 0xf64d, 0xf520, 0xf54e, 0xf6c8, 0xf9a1, 0xfe37,
    0x0374, 0x0743, 0x08e1, 0x091a, 0x081d, 0x0594, 0x01d4, 0xfe60,
    0xfc9e, 0xfc5e, 0xfd50, 0xff55, 0x01a8, 0x03fb, 0x06d9, 0x098e,
    0x0a54, 0x083b, 0x03d7, 0xfe2a, 0xf804, 0xf376, 0xf26a, 0xf4ef,
    0xf951, 0xfdcc, 0x01e1, 0x04c1, 0x05c4, 0x05de, 0x05ce, 0x05f0,
    0x06c0, 0x0744, 0x063c, 0x03e0, 0x0063, 0xfb79, 0xf5cd, 0xf0a0,
    0xeda1, 0xedf7, 0xf1dd, 0xf872, 0xffa4, 0x064f, 0x0baf, 0x0e36,
    0x0d73, 0x0aa7, 0x073a, 0x03ca, 0x00c6, 0xfebc, 0xfdd9, 0xfe86,
    0x0058, 0x01e3, 0x02ba, 0x03f6, 0x05c8, 0x0662, 0x03f3, 0xff0d,
    0xf950, 0xf423, 0xf1b8, 0xf2d3, 0xf5dd, 0xf97a, 0xfd28, 0x0047,
    0x0227, 0x0384, 0x0558, 0x074a, 0x08d3, 0x08dd, 0x06ab, 0x02a6,
    0xfe0b, 0xfa89, 0xf916, 0xf9b3, 0xfbd0, 0xfdf4, 0xfec8, 0xfe8c,
    0xfe61, 0xfefb, 0x00b9, 0x03d3, 0x07a7, 0x0aee, 0x0bea, 0x0a82,
    0x07d2, 0x03cd, 0xfe89, 0xf9dd, 0xf797, 0xf78b, 0xf8b4, 0xfaab,
    0xfc62, 0xfca3, 0xfc48, 0xfc17, 0xfbfd, 0xfbc4, 0xfbbc, 0xfc38,
    0xfc85, 0xfc8d, 0xfd3c, 0xff1b, 0x01b7, 0x04e3, 0x0867, 0x0b94,
    0x0dc3, 0x0de5, 0x0c12, 0x08fb, 0x04e6, 0x0072, 0xfc4e, 0xf868,
    0xf41d, 0xf072, 0xefd9, 0xf29a, 0xf7bf, 0xfe4b, 0x0445, 0x080a,
    0x0a49, 0x0c12, 0x0c71, 0x0ae1, 0x0860, 0x0576, 0x0201, 0xfeac,
    0xfbc7, 0xf8e7, 0xf5ab, 0xf4a1, 0xf699, 0xf841, 0xf96a, 0xfac8,
    0xfc6a, 0xfe31, 0x0027, 0x022f, 0x032c, 0x03eb, 0x0542, 0x0669,
    0x066d, 0x0565, 0x03f6, 0x02b5, 0x0201, 0x01a9, 0x028a, 0x0423,
    0x044c, 0x02d8, 0x006b, 0xfd25, 0xfa1e, 0xf835, 0xf665, 0xf4c3,
    0xf558, 0xf8fe, 0xfdf8, 0x0312, 0x0774, 0x09c8, 0x0a5e, 0x0a18,
    0x0862, 0x051e, 0x00ff, 0xfcf2, 0xfa16, 0xf8c2, 0xf819, 0xf7c4,
    0xf906, 0xfc08, 0xff70, 0x024f, 0x03ac, 0x0282, 0xffdf, 0xfd9f,
    0xfc83, 0xfce9, 0xff00, 0x01ee, 0x04d6, 0x06fd, 0x07cc, 0x0761,
    0x0670, 0x0555, 0x048e, 0x050a, 0x05f0, 0x05b3, 0x03c7, 0x0012,
    0xfb77, 0xf73d, 0xf3ee, 0xf1d0, 0xf117, 0xf1bf, 0xf3d4, 0xf7b7,
    0xfd14, 0x01f6, 0x0594, 0x07d5, 0x08c4, 0x08b7, 0x0780, 0x05c8,
    0x046c, 0x0376, 0x022e, 0x0094, 0xfee0, 0xfd17, 0xfc25, 0xfcde,
    0xfde1, 0xfddc, 0xfdf0, 0xfea2, 0xff68, 0xffee, 0x0027, 0xfffc,
    0xffea, 0xffbf, 0xff1d, 0xff00, 0xffc9, 0x0130, 0x02e7, 0x04e6,
    0x06c0, 0x07ec, 0x0853, 0x0694, 0x0262, 0xfe09, 0xfa39, 0xf70d,
    0xf58b, 0xf585, 0xf6f6, 0xf9f3, 0xfda2, 0x0127, 0x0442, 0x069b,
    0x06ef, 0x0506, 0x0229, 0xffbf, 0xfec3, 0xff2f, 0x0009, 0x0112,
    0x0222, 0x02ce, 0x02d0, 0x01d9, 0x0017, 0xfe40, 0xfd26, 0xfd04,
    0xfe29, 0x0068, 0x0254, 0x02ec, 0x0362, 0x03e6, 0x02f5, 0x0117,
    0xffa3, 0xfe4c, 0xfcc8, 0xfbe0, 0xfaf8, 0xf8cf, 0xf6a4, 0xf780,
    0xfae8, 0xfe69, 0x01ba, 0x04ce, 0x061e, 0x0476, 0x01db, 0x0005,
    0xfdf1, 0xfc17, 0xfc1d, 0xfddc, 0x0017, 0x027f, 0x053a, 0x0705,
    0x0786, 0x0848, 0x090a, 0x0800, 0x0460, 0xff6a, 0xfa5b, 0xf5f9,
    0xf424, 0xf53d, 0xf792, 0xfac9, 0xff5d, 0x044f, 0x08a2, 0x0b6d,
    0x0b94, 0x08a3, 0x03d1, 0xfec1, 0xfabb, 0xf973, 0xfa4c, 0xfc13,
    0xfe4e, 0xff39, 0xfe51, 0xfd10, 0xfc0e, 0xfb72, 0xfc26, 0xfe5b,
    0x0083, 0x0158, 0x01cb, 0x0283, 0x028e, 0x02c9, 0x0420, 0x0511,
    0x03e8, 0x0181, 0xff8c, 0xfe52, 0xfdec, 0xfe74, 0xffb5, 0x00dd,
    0x0232, 0x0397, 0x0351, 0x00e9, 0xfd99, 0xfaa6, 0xf844, 0xf716,
    0xf7e2, 0xfa4b, 0xfe3c, 0x0383, 0x08a0, 0x0be9, 0x0cb1, 0x0b46,
    0x0797, 0x01ed, 0xfbca, 0xf6bf, 0xf3fc, 0xf395, 0xf502, 0xf7d9,
    0xfb32, 0xfe26, 0x0088, 0x0252, 0x02e0, 0x0204, 0x00c1, 0x000a,
    0x0064, 0x0229, 0x052b, 0x082a, 0x0a10, 0x0aa3, 0x09de, 0x07c3,
    0x0516, 0x0273, 0xffa2, 0xfd01, 0xfb07, 0xf9bf, 0xf945, 0xf99d,
    0xfa46, 0xfa0d, 0xf8fb, 0xf863, 0xf952, 0xfc0a, 0xffb9, 0x039f,
    0x071e, 0x09c6, 0x0a8f, 0x0905, 0x0611, 0x02f3, 0xffdc, 0xfc57,
    0xf9af, 0xf974, 0xfb59, 0xfd8f, 0xff6c, 0x00c7, 0x00d0, 0xff29,
    0xfce2, 0xfb69, 0xfb41, 0xfcd5, 0xfffa, 0x0369, 0x059d, 0x063e,
    0x0532, 0x02f1, 0x0131, 0x0141, 0x035c, 0x0683, 0x0919, 0x0924,
    0x05d6, 0x0076, 0xfa71, 0xf4ea, 0xf0cc, 0xef0e, 0xf0be, 0xf578,
    0xfbdf, 0x0277, 0x0782, 0x0a26, 0x0a9f, 0x0963, 0x06d5, 0x032f,
    0xff99, 0xfd65, 0xfcbc, 0xfce6, 0xfd94, 0xfeeb, 0x0016, 0xffc6,
    0xfed1, 0xfea9, 0xfebe, 0xfe71, 0xfeca, 0x007e, 0x01ca, 0x01f0,
    0x01ed, 0x01d5, 0x00a2, 0xfecb, 0xfe15, 0xfeca, 0x0083, 0x0320,
    0x0577, 0x05e4, 0x0446, 0x01af, 0xfea8, 0xfae1, 0xf812, 0xf7d2,
    0xf8a3, 0xf910, 0xfa4d, 0xfc7f, 0xfe26, 0x005a, 0x03aa, 0x0607,
    0x0674, 0x0698, 0x0752, 0x06c5, 0x04bb, 0x0315, 0x0262, 0x016f,
    0xffab, 0xfd44, 0xfa3d, 0xf6da, 0xf460, 0xf4a4, 0xf688, 0xf8ca,
    0xfbfa, 0x005c, 0x04e3, 0x0860, 0x0a6f, 0x0a10, 0x07bc, 0x056e,
    0x03c0, 0x02c3, 0x02e4, 0x036e, 0x02b2, 0xffbe, 0xfb34, 0xf6a6,
    0xf408, 0xf4d4, 0xf892, 0xfda4, 0x01f8, 0x0406, 0x0438, 0x040c,
    0x03de, 0x030d, 0x01e7, 0x00fc, 0x00c9, 0x00d5, 0x00dd, 0x018c,
    0x02f4, 0x041a, 0x0409, 0x0334, 0x01d5, 0xffd1, 0xfd92, 0xfbcd,
    0xfa17, 0xf8b5, 0xf896, 0xf922, 0xfa2e, 0xfd28, 0x0277, 0x0756,
    0x09a4, 0x09bc, 0x0828, 0x0556, 0x01f4, 0xff22, 0xfd1f, 0xfb27,
    0xf9bb, 0xf9b3, 0xfa77, 0xfb3d, 0xfc24, 0xfcf6, 0xfd3d, 0xfd94,
    0xfe80, 0xfebf, 0xfe3d, 0xfeab, 0x008a, 0x0321, 0x0619, 0x090a,
    0x0a45, 0x090d, 0x0601, 0x028f, 0x0059, 0xff77, 0xff5d, 0xffda,
    0x0087, 0x0183, 0x029f, 0x02dd, 0x00d3, 0xfbfb, 0xf6c5, 0xf3ce,
    0xf423, 0xf784, 0xfd21, 0x036c, 0x085f, 0x0b41, 0x0c1e, 0x0a33,
    0x0587, 0x0004, 0xfb6b, 0xf7ae, 0xf588, 0xf685, 0xfa4e, 0xffa1,
    0x051c, 0x0850, 0x0752, 0x02f0, 0xfd77, 0xf999, 0xf7b9, 0xf88d,
    0xfc85, 0x00fb, 0x02d5, 0x0214, 0x017f, 0x017a, 0x0248, 0x0488,
    0x0825, 0x0b7f, 0x0c32, 0x090a, 0x0278, 0xfb6d, 0xf618, 0xf2ca,
    0xf172, 0xf1e4, 0xf482, 0xf91b, 0xfdfe, 0x018d, 0x0484, 0x079a,
    0x0947, 0x086e, 0x0558, 0x0152, 0xfe54, 0xfdc5, 0xfecc, 0x0019,
    0x01e8, 0x0361, 0x0228, 0xfea7, 0xfc21, 0xfc27, 0xfd42, 0xfebf,
    0x0170, 0x0439, 0x04ef, 0x0433, 0x0357, 0x019a, 0xfe4a, 0xfb46,
    0xfa72, 0xfb73, 0xfd5f, 0xffc5, 0x01fa, 0x0293, 0x0200, 0x014c,
    0x0081, 0xfecb, 0xfc9c, 0xfb76, 0xfaff, 0xfab3, 0xfb0c, 0xfcd7,
    0xff89, 0x0226, 0x0451, 0x04ce, 0x02e3, 0x0002, 0xfe0b, 0xfdf2,
    0xffbb, 0x0358, 0x07d2, 0x0a61, 0x0897, 0x02d2, 0xfb95, 0xf532,
    0xf1f3, 0xf337, 0xf774, 0xfc2c, 0x010c, 0x0667, 0x0b05, 0x0ceb,
    0x0b1a, 0x06ac, 0x022c, 0xff67, 0xfdff, 0xfd9c, 0xfe1e, 0xfede,
    0xff30, 0xfe3c, 0xfbf6, 0xf965, 0xf81a, 0xf99f, 0xfde0, 0x0334,
    0x0704, 0x07bc, 0x0603, 0x0364, 0x00af, 0xfe57, 0xfd57, 0xfd50,
    0xfcee, 0xfc71, 0xfd3b, 0xffd5, 0x0352, 0x0620, 0x06b5, 0x052c,
    0x026f, 0xfefd, 0xfba1, 0xf999, 0xfa0f, 0xfbd6, 0xfd11, 0xfdc4,
    0xfe6f, 0xff82, 0x0150, 0x034e, 0x04ff, 0x065a, 0x06d9, 0x05f7,
    0x03f9, 0x01b3, 0xffa9, 0xfd61, 0xfaa5, 0xf832, 0xf6c1, 0xf6e7,
    0xf8c7, 0xfb4b, 0xfdb1, 0x009f, 0x0428, 0x0685, 0x0689, 0x052f,
    0x0370, 0x01a7, 0x00d1, 0x01be, 0x03bb, 0x04db, 0x042c, 0x022a,
    0xffe1, 0xfe37, 0xfdd2, 0xff46, 0x0080, 0xff91, 0xfe37, 0xfd89,
    0xfc2e, 0xfab0, 0xfae8, 0xfce2, 0xff67, 0x01d2, 0x03d1, 0x054b,
    0x0645, 0x05b0, 0x0309, 0xffbd, 0xfdae, 0xfd26, 0xfe25, 0x00aa,
    0x0327, 0x03cd, 0x01ed, 0xfdd7, 0xf9c6, 0xf706, 0xf649, 0xf8d2,
    0xfd5f, 0x0109, 0x0254, 0x030b, 0x0367, 0x02e3, 0x029b, 0x03a2,
    0x05d2, 0x06ed, 0x0539, 0x013f, 0xfd76, 0xfb98, 0xfbe9, 0xfd73,
    0xfde5, 0xfd30, 0xfcfe, 0xfce4, 0xfbac, 0xfa42, 0xfa47, 0xfbe3,
    0xff54, 0x03fa, 0x06f5, 0x06b4, 0x04a0, 0x0238, 0xffe6, 0xffa9,
    0x023e, 0x0490, 0x047e, 0x02d6, 0x014f, 0xffa4, 0xfdc1, 0xfd2e,
    0xfde8, 0xfecd, 0xfee9, 0xfed7, 0xff42, 0xff62, 0xff1b, 0xff9a,
    0x00db, 0x012a, 0x0146, 0x0183, 0xff5d, 0xfc37, 0xfaab, 0xfae7,
    0xfbef, 0xfe10, 0x01cd, 0x04dd, 0x05b4, 0x0486, 0x024d, 0xff4d,
    0xfc73, 0xfb4d, 0xfaf6, 0xfa72, 0xfadb, 0xfc89, 0xfe1a, 0xff5d,
    0x015f, 0x048d, 0x07df, 0x09e6, 0x09aa, 0x0718, 0x0386, 0x0077,
    0xfe6c, 0xfcdd, 0xfbbc, 0xfb91, 0xfd19, 0xffad, 0x0129, 0x006b,
    0xfe42, 0xfca9, 0xfcb8, 0xfdad, 0xfe9d, 0xfff1, 0x0235, 0x046e,
    0x050f, 0x03f8, 0x0152, 0xfd9a, 0xfa49, 0xf8d3, 0xf9e4, 0xfcba,
    0xff9c, 0x0220, 0x041a, 0x03ed, 0x0138, 0xfe3b, 0xfc97, 0xfc4f,
    0xfddb, 0x00a7, 0x0361, 0x05ba, 0x0749, 0x07a2, 0x0777, 0x0747,
    0x063c, 0x039e, 0x0044, 0xfcda, 0xf932, 0xf6b6, 0xf681, 0xf85f,
    0xfb61, 0xfe2e, 0x0054, 0x0187, 0x018e, 0x0141, 0x0191, 0x01e4,
    0x01a4, 0x00e8, 0xffaf, 0xfdea, 0xfc76, 0xfc9b, 0xfdb8, 0xfea1,
    0xff0d, 0xfef2, 0xfe38, 0xfd0e, 0xfc2c, 0xfbe2, 0xfca2, 0xfeaf,
    0x013e, 0x030c, 0x0428, 0x0601, 0x08c5, 0x0bb1, 0x0d44, 0x0c4e,
    0x08a0, 0x035d, 0xfe64, 0xfab0, 0xf908, 0xf872, 0xf720, 0xf692,
    0xf86e, 0xfbd2, 0xfff4, 0x034c, 0x0446, 0x036c, 0x026e, 0x016f,
    0x0028, 0xfed0, 0xfdb6, 0xfce1, 0xfbfd, 0xfbfd, 0xfd28, 0xff52,
    0x02ea, 0x0700, 0x08ca, 0x0749, 0x0349, 0xfe5d, 0xfa6c, 0xf881,
    0xf98b, 0xfc6b, 0xfe55, 0xfdcb, 0xfbce, 0xfad7, 0xfcdc, 0x01ad,
    0x078d, 0x0d16, 0x10f4, 0x108c, 0x0aba, 0x02de, 0xfd02, 0xf999,
    0xf77f, 0xf6b6, 0xf6f2, 0xf77b, 0xf855, 0xf961, 0xfa69, 0xfcd6,
    0x0111, 0x049f, 0x050d, 0x02ae, 0xff8e, 0xfdd6, 0xfe2a, 0xff70,
    0x01e1, 0x0477, 0x04ec, 0x0305, 0x004d, 0xff32, 0xffdb, 0x0067,
    0x0027, 0xffdf, 0xff9c, 0xfea7, 0xfdf4, 0xfef6, 0x0118, 0x02ef,
    0x043a, 0x0515, 0x049d, 0x02df, 0x0224, 0x02a5, 0x024d, 0x00b6,
    0xfe90, 0xfc06, 0xfa57, 0xfbb6, 0xff20, 0x0100, 0x0071, 0xfec1,
    0xfce1, 0xfbc1, 0xfbd1, 0xfbbf, 0xfa25, 0xf8af, 0xf972, 0xfb9f,
    0xfe2d, 0x0129, 0x041c, 0x0682, 0x0748, 0x05df, 0x0349, 0x00c2,
    0xff3e, 0xffab, 0x019a, 0x02df, 0x0329, 0x03b2, 0x040c, 0x02c6,
    0x0015, 0xfd59, 0xfb5e, 0xfae6, 0xfcdb, 0x004d, 0x03d1, 0x06bb,
    0x07f8, 0x0679, 0x0258, 0xfddb, 0xfaaf, 0xf8f0, 0xf8c6, 0xfa27,
    0xfc39, 0xfdde, 0xff07, 0xffe9, 0xff79, 0xfd66, 0xfbcb, 0xfc7f,
    0xfe65, 0x00b7, 0x0428, 0x0786, 0x092c, 0x09b0, 0x09a4, 0x07fe,
    0x03d4, 0xfe71, 0xf9aa, 0xf714, 0xf7d6, 0xfa9f, 0xfd80, 0xff90,
    0x007a, 0x00af, 0x00b0, 0x00dc, 0x0183, 0x02a6, 0x0310, 0x01a0,
    0xfeff, 0xfc9b, 0xfbb3, 0xfca4, 0xfeb9, 0x0079, 0x01a4, 0x030c,
    0x03af, 0x0248, 0x002d, 0xfe36, 0xfbf0, 0xf9e5, 0xf8a8, 0xf82c,
    0xf87e, 0xf994, 0xfbb2, 0xff6a, 0x047b, 0x09d0, 0x0e88, 0x123b,
    0x12a9, 0x0e66, 0x073b, 0xffe0, 0xfa58, 0xf7c0, 0xf7c4, 0xf859,
    0xf832, 0xf896, 0xfb1d, 0xfeb2, 0x017a, 0x0308, 0x0396, 0x033a,
    0x0224, 0x00f4, 0x005d, 0x0089, 0x00bc, 0x000b, 0xfd78, 0xfa2a,
    0xf8a1, 0xf977, 0xfc68, 0x00e5, 0x0520, 0x07a6, 0x0863, 0x07bb,
    0x059b, 0x01b2, 0xfd27, 0xf958, 0xf679, 0xf3b5, 0xf217, 0xf386,
    0xf842, 0xfec6, 0x0605, 0x0df0, 0x1434, 0x1629, 0x12c4, 0x0ab3,
    0x00c0, 0xf97c, 0xf66f, 0xf588, 0xf55c, 0xf64b, 0xf832, 0xfa20,
    0xfc9b, 0xffe2, 0x032f, 0x04d3, 0x045f, 0x02a6, 0xffc7, 0xfcd7,
    0xfb87, 0xfc55, 0xfe4e, 0x00d0, 0x0235, 0x0138, 0xfeb5, 0xfcc6,
    0xfcf4, 0xfe56, 0x001b, 0x0267, 0x0562, 0x0760, 0x074c, 0x0620,
    0x045a, 0x0194, 0xfe5a, 0xfbda, 0xfa63, 0xf9ff, 0xfb2d, 0xfe30,
    0x019e, 0x048a, 0x069e, 0x0711, 0x0622, 0x050f, 0x03e0, 0x0188,
    0xfe4e, 0xfb64, 0xfa29, 0xfab7, 0xfbb6, 0xfbe5, 0xfaca, 0xf96f,
    0xf875, 0xf7fb, 0xf868, 0xfa29, 0xfdda, 0x0305, 0x07c2, 0x09d0,
    0x0839, 0x0494, 0x0177, 0xffb3, 0xfefa, 0xff07, 0xff91, 0x00cc,
    0x02e5, 0x052a, 0x0628, 0x0515, 0x02c7, 0x00c3, 0x0018, 0x00ad,
    0x01db, 0x0333, 0x03d2, 0x0306, 0x00b1, 0xfda2, 0xfb68, 0xfa90,
    0xfa91, 0xfac2, 0xfb60, 0xfbe8, 0xfbf7, 0xfc17, 0xfc09, 0xfbba,
    0xfb8e, 0xfc7c, 0xfe78, 0x0051, 0x0246, 0x053a, 0x08d8, 0x0b97,
    0x0bd1, 0x0977, 0x052a, 0xffba, 0xfa5a, 0xf6a9, 0xf600, 0xf86e,
    0xfd05, 0x01c5, 0x04f1, 0x05cc, 0x048c, 0x024b, 0x002c, 0xfead,
    0xfddb, 0xfd43, 0xfc85, 0xfc7e, 0xfd8c, 0xfeab, 0xff7b, 0x00b1,
    0x01d3, 0x0169, 0xffe7, 0xfe43, 0xfc6c, 0xfa6e, 0xf98c, 0xfabd,
    0xfcb9, 0xfe61, 0x000c, 0x0197, 0x02c2, 0x0451, 0x06ac, 0x0936,
    0x0abf, 0x0b01, 0x0abf, 0x0a06, 0x07da, 0x03c2, 0xff22, 0xfad8,
    0xf681, 0xf377, 0xf347, 0xf57b, 0xf907, 0xfcdd, 0x0059, 0x0354,
    0x055e, 0x065d, 0x062c, 0x04dd, 0x02da, 0x0081, 0xfe62, 0xfc7d,
    0xfb32, 0xfab6, 0xfa68, 0xfa23, 0xfb27, 0xfd2d, 0xfedd, 0x00e6,
    0x0401, 0x0695, 0x0704, 0x05e2, 0x0358, 0xff87, 0xfc34, 0xfb57,
    0xfc88, 0xfdab, 0xfd8d, 0xfd1d, 0xfde7, 0xfff9, 0x02c5, 0x059b,
    0x0803, 0x093b, 0x07cf, 0x036c, 0xfe0f, 0xfa78, 0xf973, 0xf9f0,
    0xfb82, 0xfe30, 0x00ec, 0x02d9, 0x03c1, 0x02cd, 0xfff7, 0xfd5e,
    0xfc8a, 0xfc58, 0xfbd2, 0xfc13, 0xfd1d, 0xfd24, 0xfbe1, 0xfb56,
    0xfccb, 0xff72, 0x0247, 0x04a1, 0x0599, 0x0598, 0x0633, 0x0756,
    0x0809, 0x07c4, 0x0607, 0x02e3, 0xff65, 0xfcd2, 0xfadd, 0xf924,
    0xf8e7, 0xfaf4, 0xfdda, 0x0047, 0x0237, 0x0345, 0x0342, 0x02c9,
    0x01a7, 0xffe9, 0xff96, 0x0104, 0x0217, 0x0193, 0xffea, 0xfd9e,
    0xfb6f, 0xf9de, 0xf83a, 0xf6b9, 0xf66a, 0xf7b1, 0xfa98, 0xfee0,
    0x037a, 0x071a, 0x0989, 0x0a36, 0x07c2, 0x0211, 0xfb7f, 0xf73a,
    0xf73d, 0xfb0d, 0x002a, 0x0456, 0x0696, 0x072f, 0x06e9, 0x0616,
    0x048b, 0x0298, 0x00e8, 0xffa2, 0xffa1, 0x023b, 0x05e5, 0x081a,
    0x0812, 0x0532, 0xffab, 0xf959, 0xf42a, 0xf0cb, 0xefe0, 0xf1b1,
    0xf5c7, 0xfc1a, 0x0374, 0x092e, 0x0a9a, 0x0771, 0x0277, 0xfe91,
    0xfce8, 0xfddc, 0x0112, 0x051f, 0x0851, 0x0961, 0x08c9, 0x0702,
    0x0367, 0xfddf, 0xf867, 0xf50c, 0xf4dd, 0xf819, 0xfd43, 0x026b,
    0x062e, 0x0809, 0x07d6, 0x05a1, 0x0240, 0xfec4, 0xfb40, 0xf82c,
    0xf7a7, 0xfa0a, 0xfd9a, 0x011b, 0x03ea, 0x0542, 0x048e, 0x01fb,
    0xfe61, 0xfbb0, 0xfa70, 0xfac4, 0xfc59, 0xfd91, 0xfd47, 0xfc46,
    0xfcad, 0xfee9, 0x02ae, 0x07f7, 0x0d4e, 0x0fab, 0x0de9, 0x086d,
    0x0001, 0xf7b5, 0xf2d2, 0xf22b, 0xf4ab, 0xf9a9, 0x004f, 0x05e8,
    0x0891, 0x08a1, 0x0689, 0x0283, 0xfdb8, 0xf990, 0xf6ed, 0xf644,
    0xf7ce, 0xfb99, 0x00c8, 0x0589, 0x0871, 0x0875, 0x054c, 0x001d,
    0xfb53, 0xf92f, 0xfa25, 0xfd7f, 0x01e6, 0x0629, 0x09a1, 0x0b22,
    0x09b1, 0x05ab, 0xff9d, 0xf869, 0xf2c4, 0xf0a7, 0xf0fa, 0xf2b7,
    0xf5c7, 0xfadd, 0x013a, 0x0652, 0x095d, 0x0a15, 0x097e, 0x080f,
    0x052f, 0x0272, 0x017b, 0x01fd, 0x0278, 0x01b4, 0xff53, 0xfc17,
    0xf966, 0xf849, 0xf950, 0xfc2b, 0x0036, 0x054f, 0x0a9e, 0x0d5d,
    0x0b56, 0x04d3, 0xfb73, 0xf1d4, 0xec46, 0xed76, 0xf3a9, 0xfb7e,
    0x034d, 0x0a3a, 0x0ec7, 0x0fe8, 0x0e39, 0x0b70, 0x0902, 0x0673,
    0x0348, 0x009e, 0xfe1b, 0xfba5, 0xfa53, 0xfa42, 0xfb03, 0xfca3,
    0xfe90, 0xffca, 0x00c1, 0x01b8, 0x0166, 0xff71, 0xfdd0, 0xfcff,
    0xfbdc, 0xfab5, 0xfa51, 0xfafc, 0xfd5d, 0x01d7, 0x06a0, 0x091e,
    0x08ff, 0x0746, 0x03b2, 0xfdc9, 0xf7e9, 0xf4b8, 0xf404, 0xf4cf,
    0xf69d, 0xf94d, 0xfd37, 0x0279, 0x07ce, 0x0ba2, 0x0da1, 0x0d60,
    0x0aa2, 0x0699, 0x0369, 0x018a, 0xff8f, 0xfcda, 0xf9b4, 0xf645,
    0xf37c, 0xf34d, 0xf686, 0xfb6f, 0xffc8, 0x02f2, 0x044d, 0x0315,
    0x0031, 0xfd6a, 0xfafc, 0xf947, 0xf9f7, 0xfdc3, 0x037d, 0x097d,
    0x0e5b, 0x104d, 0x0ed2, 0x0ae1, 0x05bf, 0x00a9, 0xfd9a, 0xfd30,
    0xfd8b, 0xfc8c, 0xf9bb, 0xf607, 0xf2be, 0xf20f, 0xf539, 0xfac8,
    0x00cd, 0x065f, 0x09de, 0x0997, 0x05ea, 0x00cd, 0xfbd6, 0xf7be,
    0xf509, 0xf456, 0xf669, 0xfb81, 0x0276, 0x08d2, 0x0c5b, 0x0c35,
    0x0947, 0x04df, 0xffca, 0xfb5b, 0xf898, 0xf821, 0xfa75, 0xfeda,
    0x0326, 0x0612, 0x0831, 0x09ad, 0x0a32, 0x098e, 0x0722, 0x035e,
    0x002a, 0xfea3, 0xfe41, 0xfd9b, 0xfbfe, 0xfa71, 0xf9c3, 0xf924,
    0xf854, 0xf87b, 0xfa17, 0xfc6b, 0xff91, 0x0405, 0x086a, 0x0a90,
    0x0a01, 0x076b, 0x02de, 0xfd76, 0xf923, 0xf6f3, 0xf6bf, 0xf838,
    0xfbb9, 0x00ad, 0x04e8, 0x0703, 0x076b, 0x05d0, 0x028a, 0x0033,
    0xff60, 0xfe0a, 0xfbe6, 0xf9bd, 0xf7a3, 0xf6ac, 0xf8f9, 0xfed9,
    0x05ef, 0x0c7c, 0x10bd, 0x104f, 0x0b2d, 0x040f, 0xfd3e, 0xf7e5,
    0xf541, 0xf59e, 0xf849, 0xfb71, 0xfe6b, 0x012f, 0x02fa, 0x02f9,
    0x01c0, 0x007e, 0xfea5, 0xfc6f, 0xfab6, 0xf994, 0xf933, 0xfa72,
    0xfd00, 0xff72, 0x019d, 0x0435, 0x06be, 0x07b3, 0x06ee, 0x05b1,
    0x0450, 0x0271, 0x0046, 0xfe5b, 0xfd66, 0xfdc6, 0xff90, 0x01b0,
    0x02dd, 0x02c8, 0x01c3, 0x0001, 0xfdb4, 0xfc71, 0xfd95, 0x0017,
    0x0325, 0x0650, 0x081c, 0x07f6, 0x05d1, 0x0210, 0xfd9e, 0xf916,
    0xf4ae, 0xf11a, 0xf0a0, 0xf49e, 0xfb8a, 0x0278, 0x074f, 0x0947,
    0x0820, 0x0449, 0x0004, 0xfd3c, 0xfca3, 0xfda0, 0xff17, 0x0168,
    0x040b, 0x05b1, 0x0660, 0x068f, 0x053c, 0x01bb, 0xfdcc, 0xfb23,
    0xfa37, 0xfb16, 0xfd04, 0xfee6, 0x0025, 0xffe7, 0xfe23, 0xfc1a,
    0xfaec, 0xfad7, 0xfbe0, 0xfe1b, 0x0167, 0x0545, 0x086d, 0x097e,
    0x079c, 0x0306, 0xfd3b, 0xf830, 0xf557, 0xf5b1, 0xf862, 0xfbf8,
    0x0085, 0x04b1, 0x06ee, 0x0799, 0x0754, 0x0615, 0x042c, 0x023a,
    0x0058, 0xff17, 0xff02, 0xffcb, 0x00a4, 0x0087, 0xff04, 0xfd60,
    0xfcee, 0xfdc5, 0xff50, 0x0102, 0x025c, 0x0220, 0x0027, 0xfdfd,
    0xfd1f, 0xfd6c, 0xfe43, 0xff54, 0xffee, 0xff87, 0xfe59, 0xfd5d,
    0xfd36, 0xfe2b, 0x0054, 0x0317, 0x055b, 0x068f, 0x066e, 0x04af,
    0x01be, 0xff5c, 0xfecc, 0xff14, 0xfeb1, 0xfd81, 0xfbff, 0xfb21,
    0xfbf0, 0xfe67, 0x0109, 0x0322, 0x04b2, 0x0496, 0x021a, 0xfdc5,
    0xf9b8, 0xf7fa, 0xf8b1, 0xfb83, 0x007f, 0x0686, 0x0b2c, 0x0cbe,
    0x0ab5, 0x0512, 0xfd5e, 0xf766, 0xf5b1, 0xf707, 0xf90a, 0xfaba,
    0xfc06, 0xfd40, 0xff2d, 0x012d, 0x026e, 0x017f, 0xfe2c, 0xfb71,
    0xfb4f, 0xfd7d, 0x00fc, 0x0544, 0x08ab, 0x0944, 0x072f, 0x03fe,
    0x00e4, 0xfe39, 0xfc39, 0xfa91, 0xfa00, 0xfbb0, 0xfe7e, 0x0136,
    0x040f, 0x069b, 0x079f, 0x070e, 0x04fd, 0x01c1, 0xfe1b, 0xfac7,
    0xf8f0, 0xf889, 0xf920, 0xfb5b, 0xffbb, 0x04b0, 0x08ad, 0x0a87,
    0x094d, 0x0575, 0x0095, 0xfbec, 0xf785, 0xf45b, 0xf33d, 0xf361,
    0xf4e7, 0xf92c, 0xffb7, 0x05cb, 0x0a1e, 0x0cd7, 0x0cc7, 0x09cc,
    0x0599, 0x014b, 0xfd86, 0xfb38, 0xfb28, 0xfd00, 0xff5e, 0x0123,
    0x01d7, 0x0172, 0x0059, 0xff53, 0xff6d, 0x00b1, 0x0267, 0x04cb,
    0x0799, 0x0948, 0x0930, 0x07a6, 0x0494, 0x00a7, 0xfcb9, 0xf89c,
    0xf549, 0xf3d8, 0xf3fe, 0xf583, 0xf8e1, 0xfc69, 0xfe12, 0xfe12,
    0xfd3f, 0xfcf9, 0xfe98, 0x0217, 0x05d2, 0x083f, 0x0904, 0x081f,
    0x0659, 0x0495, 0x02b6, 0x0053, 0xfdbb, 0xfb74, 0xf9bc, 0xf965,
    0xfaaf, 0xfd21, 0x0084, 0x03c7, 0x0549, 0x0448, 0x0182, 0xfedc,
    0xfdde, 0xff11, 0x01da, 0x044d, 0x054e, 0x0555, 0x04cb, 0x02d2,
    0xff94, 0xfd03, 0xfbca, 0xfaf6, 0xfadb, 0xfcc0, 0xffa2, 0x010c,
    0x00ed, 0x0075, 0xffb8, 0xfee9, 0xff32, 0x010c, 0x02f1, 0x03ce,
    0x0384, 0x0269, 0x00c7, 0xfea6, 0xfc49, 0xfa78, 0xf9a3, 0xf99c,
    0xfa5e, 0xfc21, 0xfea5, 0x013d, 0x0373, 0x0413, 0x025e, 0xffab,
    0xfe06, 0xfdfc, 0xfed8, 0x0008, 0x00c4, 0x007b, 0xfff8, 0xffff,
    0x0030, 0xffe2, 0xff67, 0xffbe, 0x01be, 0x04a5, 0x06ba, 0x0730,
    0x05ff, 0x034d, 0xffb3, 0xfc8a, 0xfa95, 0xf96a, 0xf92c, 0xfa69,
    0xfceb, 0x0039, 0x03b8, 0x05f6, 0x05b7, 0x03d4, 0x0174, 0xfecc,
    0xfc57, 0xfb17, 0xfb44, 0xfcb4, 0xfff0, 0x0469, 0x0807, 0x0984,
    0x08f3, 0x06c0, 0x02fe, 0xfeac, 0xfad4, 0xf762, 0xf4dc, 0xf38f,
    0xf3b2, 0xf62c, 0xfa7b, 0xff2a, 0x029e, 0x0410, 0x04e6, 0x0592,
    0x0589, 0x0565, 0x0524, 0x03c0, 0x0127, 0xff04, 0xfe9c, 0xff64,
    0x009f, 0x01db, 0x0249, 0x0150, 0xffbc, 0xfdc9, 0xfb9f, 0xfab1,
    0xfb6f, 0xfcb0, 0xfde7, 0xff69, 0x0151, 0x02d7, 0x0366, 0x03ab,
    0x02f4, 0x0036, 0xfd5d, 0xfd48, 0xff8a, 0x02e0, 0x06ab, 0x0921,
    0x0875, 0x059f, 0x0160, 0xfac8, 0xf439, 0xf19d, 0xf355, 0xf779,
    0xfda1, 0x0550, 0x0c14, 0x0ff5, 0x1063, 0x0cd2, 0x057a, 0xfcb4,
    0xf561, 0xf048, 0xed97, 0xef2f, 0xf61b, 0xff63, 0x06a4, 0x0ad4,
    0x0be6, 0x08b5, 0x0237, 0xfcc9, 0xfb21, 0xfbdf, 0xfe12, 0x014e,
    0x0429, 0x05d4, 0x06e5, 0x07da, 0x07cb, 0x05f5, 0x0264, 0xfe03,
    0xfa36, 0xf829, 0xf82d, 0xf952, 0xfad0, 0xfca8, 0xfe7f, 0xfeef,
    0xfdc7, 0xfcd3, 0xfd64, 0xfe96, 0xff0b, 0xff35, 0xffb9, 0x012b,
    0x03fb, 0x071f, 0x0804, 0x0554, 0x013e, 0xfe5a, 0xfd56, 0xfd91,
    0xfe71, 0xffd6, 0x0156, 0x01c8, 0x004b, 0xfd78, 0xfae9, 0xf985,
    0xf997, 0xfafd, 0xfd02, 0xff64, 0x0250, 0x0581, 0x0801, 0x090c,
    0x082e, 0x0615, 0x0412, 0x0260, 0x010e, 0x005e, 0x0047, 0x0012,
    0xfef7, 0xfdb5, 0xfd92, 0xfd81, 0xfcbe, 0xfc29, 0xfbda, 0xfba5,
    0xfb4a, 0xfb6b, 0xfca8, 0xfe1d, 0xfefa, 0xff8c, 0x0091, 0x019f,
    0x01f5, 0x01ce, 0x024d, 0x0439, 0x05d0, 0x0566, 0x0397, 0x0120,
    0xfe89, 0xfc5d, 0xfaf6, 0xfb08, 0xfd1a, 0x000d, 0x020d, 0x02f2,
    0x03cb, 0x04ea, 0x05fe, 0x06b1, 0x05e1, 0x02c8, 0xfec7, 0xfb2a,
    0xfa0f, 0xfb84, 0xfd01, 0xff1e, 0x0189, 0x0299, 0x0156, 0xfec4,
    0xfc55, 0xf9b8, 0xf7d4, 0xf799, 0xf95a, 0xfbec, 0xfebc, 0x019c,
    0x0338, 0x0369, 0x0363, 0x042e, 0x0598, 0x075b, 0x08cd, 0x08f9,
    0x0830, 0x078a, 0x0664, 0x03cc, 0x00d9, 0xfe2a, 0xfaf9, 0xf7e4,
    0xf680, 0xf61d, 0xf601, 0xf74d, 0xfa81, 0xfe9b, 0x02c9, 0x05a4,
    0x063e, 0x0569, 0x03ee, 0x0279, 0x00e7, 0xff00, 0xfd70, 0xfc5f,
    0xfc07, 0xfc8e, 0xfdc2, 0xfea8, 0xfef4, 0xff06, 0xfef5, 0xfe84,
    0xfcae, 0xfb0f, 0xfbb8, 0xfe80, 0x02b9, 0x0798, 0x0b01, 0x0bad,
    0x09bf, 0x0647, 0x0268, 0xfe36, 0xfa50, 0xf7e6, 0xf7d4, 0xf9ad,
    0xfce8, 0x00a0, 0x03c3, 0x05b1, 0x0560, 0x02b1, 0xff34, 0xfd46,
    0xfdc8, 0xfeec, 0xff15, 0xfdf7, 0xfc4d, 0xfb7a, 0xfc3c, 0xfdb1,
    0xfea8, 0xfea4, 0xfdbe, 0xfca0, 0xfbbb, 0xfbd9, 0xfe47, 0x02d0,
    0x06b9, 0x08c3, 0x0a62, 0x0aeb, 0x08ae, 0x04a9, 0x0064, 0xfbdd,
    0xf7fa, 0xf6ab, 0xf876, 0xfc4f, 0x0050, 0x02fb, 0x049b, 0x06a6,
    0x08b8, 0x099c, 0x093c, 0x07b7, 0x0454, 0xff1c, 0xf9d4, 0xf592,
    0xf32b, 0xf366, 0xf5a7, 0xf854, 0xfacf, 0xfce5, 0xfdf5, 0xfe2e,
    0xfdef, 0xfdf9, 0xff3b, 0x0161, 0x03a1, 0x0571, 0x067f, 0x06bb,
    0x065c, 0x05b5, 0x053c, 0x0558, 0x05c0, 0x051d, 0x0254, 0xfe02,
    0xf931, 0xf52b, 0xf3cc, 0xf5a6, 0xf8a7, 0xfbb2, 0xffd7, 0x04ac,
    0x08bc, 0x0b23, 0x0bb6, 0x0a2b, 0x0669, 0x0176, 0xfca2, 0xf8d5,
    0xf6d4, 0xf6de, 0xf7e7, 0xf889, 0xf88d, 0xf8ab, 0xf967, 0xfafb,
    0xfd41, 0x002b, 0x0352, 0x061b, 0x0843, 0x08d4, 0x0740, 0x0427,
    0x00ba, 0xfe14, 0xfc79, 0xfc21, 0xfdee, 0x023e, 0x07ec, 0x0d14,
    0x1012, 0x0f24, 0x0937, 0x006a, 0xf841, 0xf31a, 0xf1bf, 0xf443,
    0xf942, 0xfe2d, 0x02be, 0x0730, 0x0a6b, 0x0bc6, 0x0b52, 0x082b,
    0x01d2, 0xfa1f, 0xf403, 0xf126, 0xf14c, 0xf482, 0xfa4f, 0x00cb,
    0x0623, 0x093f, 0x095a, 0x05bc, 0x000d, 0xfa6e, 0xf58f, 0xf389,
    0xf62c, 0xfc87, 0x0373, 0x08bd, 0x0b0f, 0x099d, 0x05c7, 0x01c5,
    0xffe9, 0x00bb, 0x033f, 0x05c4, 0x064c, 0x0424, 0x0165, 0x004b,
    0xffac, 0xfe97, 0xfd87, 0xfbe1, 0xf8f9, 0xf68b, 0xf623, 0xf750,
    0xfa54, 0xfeea, 0x03ca, 0x0878, 0x0b76, 0x0b32, 0x081e, 0x037f,
    0xff46, 0xfcf0, 0xfc76, 0xfc89, 0xfd9c, 0xfea8, 0xfd85, 0xfbb3,
    0xfb72, 0xfc2c, 0xfd7d, 0x0120, 0x0537, 0x0690, 0x0523, 0x023e,
    0xfe81, 0xfae3, 0xf760, 0xf4dd, 0xf631, 0xfb2d, 0x0187, 0x0798,
    0x0ca1, 0x0e0c, 0x0a13, 0x0334, 0xfcf6, 0xf96e, 0xf8b9, 0xf925,
    0xf94a, 0xf9c5, 0xfbb7, 0xfe9d, 0x01d9, 0x0583, 0x087c, 0x0949,
    0x0782, 0x0388, 0xfe79, 0xf9e8, 0xf7d9, 0xf9ba, 0xfe2f, 0x0285,
    0x05c1, 0x06dd, 0x03f4, 0xfe9d, 0xfc22, 0xfebb, 0x03cf, 0x08c3,
    0x0b8c, 0x0a05, 0x0442, 0xfd2a, 0xf818, 0xf724, 0xf9fa, 0xfdbe,
    0x0040, 0x012a, 0xff78, 0xfb64, 0xf858, 0xf8f5, 0xfc31, 0x0008,
    0x032e, 0x032d, 0xff54, 0xfab3, 0xf7b3, 0xf6b8, 0xf834, 0xfbf9,
    0x003c, 0x02f6, 0x037d, 0x037d, 0x047c, 0x057a, 0x056b, 0x0463,
    0x01d4, 0xfd48, 0xf8be, 0xf6cc, 0xf7fb, 0xfc1f, 0x02d4, 0x09c2,
    0x0cef, 0x0af6, 0x05cd, 0xff82, 0xfb2b, 0xfb7b, 0xfec8, 0x0266,
    0x05d0, 0x0857, 0x0874, 0x054d, 0x008e, 0xfcc2, 0xfaea, 0xfade,
    0xfc4d, 0xfe63, 0x00a4, 0x02dd, 0x0484, 0x0474, 0x0195, 0xfd8a,
    0xfa49, 0xf85a, 0xf832, 0xfaf1, 0xfea3, 0x0107, 0x0421, 0x07f0,
    0x08e8, 0x0648, 0x02ae, 0xff32, 0xfbba, 0xf944, 0xf949, 0xfb82,
    0xfe33, 0x0060, 0x017f, 0x00b5, 0xfe10, 0xfb61, 0xf988, 0xf860,
    0xf8dc, 0xfb93, 0xff77, 0x037c, 0x06f6, 0x07ff, 0x059c, 0x01fb,
    0xff65, 0xfdb4, 0xfcd6, 0xfd1d, 0xfe97, 0x00f8, 0x0356, 0x053f,
    0x06ab, 0x07a8, 0x07b5, 0x064c, 0x0385, 0xffc9, 0xfc86, 0xfb81,
    0xfce8, 0xffaf, 0x0340, 0x0643, 0x06b7, 0x04ab, 0x0199, 0xfeaa,
    0xfc40, 0xfa9d, 0xf9a4, 0xf86f, 0xf755, 0xf7a3, 0xf8ea, 0xf981,
    0xf9d3, 0xfb85, 0xfe16, 0x0036, 0x022f, 0x048f, 0x0651, 0x0683,
    0x05d2, 0x04b5, 0x03ad, 0x0316, 0x036c, 0x04d3, 0x05ea, 0x05f2,
    0x051a, 0x03be, 0x0246, 0x00ae, 0xfdd8, 0xfa7a, 0xf884, 0xf805,
    0xf818, 0xf95e, 0xfc55, 0xff90, 0x018b, 0x0293, 0x0361, 0x03ab,
    0x030b, 0x0130, 0xfe8c, 0xfc27, 0xfb27, 0xfafd, 0xfac0, 0xfb62,
    0xfe95, 0x0396, 0x07e8, 0x09f6, 0x08c7, 0x0483, 0xfebc, 0xf9c2,
    0xf671, 0xf542, 0xf71c, 0xfba3, 0x00d2, 0x0566, 0x093c, 0x0b4f,
    0x0b75, 0x0a60, 0x0817, 0x04af, 0x00d4, 0xfd59, 0xfb19, 0xfb20,
    0xfcf6, 0xfe6f, 0xfe8c, 0xfdba, 0xfc17, 0xf99c, 0xf7da, 0xf868,
    0xfa3e, 0xfc9e, 0xffa5, 0x01d8, 0x017c, 0xff51, 0xfd28, 0xfb50,
    0xfa16, 0xfa56, 0xfc78, 0x0007, 0x0430, 0x088e, 0x0c0d, 0x0ccb,
    0x09e3, 0x0470, 0xfecc, 0xfaa2, 0xf8c4, 0xf962, 0xfc3a, 0x00b0,
    0x05a5, 0x0945, 0x09ba, 0x06e4, 0x0267, 0xfdde, 0xfa6c, 0xf8db,
    0xf927, 0xfb8a, 0xffa5, 0x03d4, 0x0602, 0x0424, 0xfe45, 0xf72d,
    0xf2aa, 0xf297, 0xf633, 0xfc19, 0x02a5, 0x0872, 0x0caf, 0x0e6d,
    0x0d22, 0x0926, 0x0351, 0xfcc0, 0xf719, 0xf33a, 0xf158, 0xf29e,
    0xf69c, 0xfbdb, 0x00fe, 0x04b6, 0x068c, 0x06d5, 0x05de, 0x0393,
    0x01d6, 0x0279, 0x0425, 0x0564, 0x0609, 0x0540, 0x0289, 0xff2a,
    0xfd07, 0xfccb, 0xfe53, 0x00ce, 0x02c3, 0x0330, 0x0216, 0x00ca,
    0xfffb, 0xfeef, 0xfdb8, 0xfd60, 0xfd3e, 0xfbad, 0xf9d4, 0xf9bf,
    0xfb11, 0xfd53, 0x00d7, 0x0481, 0x0674, 0x06a6, 0x05a0, 0x0254,
    0xfcf1, 0xf7c3, 0xf452, 0xf337, 0xf50f, 0xfa34, 0x0158, 0x0739,
    0x0a59, 0x0b46, 0x0a9b, 0x09b8, 0x09c9, 0x0a0d, 0x08b4, 0x0607,
    0x0338, 0xff8e, 0xfb7b, 0xf92f, 0xf8a6, 0xf7f2, 0xf77c, 0xf8bf,
    0xfb35, 0xfd2e, 0xfd84, 0xfc2d, 0xf962, 0xf70c, 0xf7b1, 0xfb06,
    0xff49, 0x02b0, 0x048a, 0x05c8, 0x079d, 0x0999, 0x0ab0, 0x0a1d,
    0x0700, 0x0224, 0xfe42, 0xfd57, 0xfe82, 0x006c, 0x02d3, 0x04b0,
    0x04f5, 0x0410, 0x0282, 0x014a, 0x00af, 0xffde, 0xfe4f, 0xfc58,
    0xfa9c, 0xfab0, 0xfc79, 0xfdd4, 0xfe65, 0xfdab, 0xfb18, 0xf7b4,
    0xf645, 0xf77a, 0xf9bd, 0xfbf8, 0xfeac, 0x02b6, 0x0757, 0x0a65,
    0x0a64, 0x0894, 0x0670, 0x0326, 0xfe29, 0xf93e, 0xf709, 0xf85c,
    0xfbc2, 0xff37, 0x01b4, 0x03fa, 0x05d2, 0x0685, 0x0514, 0x0168,
    0xfd9c, 0xfbfd, 0xfc90, 0xfe34, 0x0128, 0x03da, 0x0398, 0x0137,
    0xff7c, 0xff1b, 0xff82, 0x007b, 0x0141, 0x0178, 0x01d2, 0x01cf,
    0x0113, 0x00cb, 0x015b, 0x019d, 0x0188, 0x0152, 0x0034, 0xfe52,
    0xfc6a, 0xfa4a, 0xf85c, 0xf84a, 0xf9e3, 0xfbcb, 0xfddd, 0xffd3,
    0x0096, 0xffc1, 0xfe7f, 0xff77, 0x03ea, 0x091b, 0x0bb2, 0x0b0a,
    0x0755, 0x018b, 0xfc58, 0xfa07, 0xf9e9, 0xfaa7, 0xfb8e, 0xfd08,
    0xfe0a, 0xfbac, 0xf7f5, 0xf5f2, 0xf67d, 0xf9a9, 0xfec5, 0x04dc,
    0x09dd, 0x0cda, 0x0dd0, 0x0c65, 0x084f, 0x02b3, 0xfe31, 0xfbfb,
    0xfc2e, 0xfe5f, 0x0081, 0x011a, 0x0185, 0x0256, 0x0295, 0x021a,
    0x0126, 0xff8d, 0xfd7b, 0xfb76, 0xfa02, 0xf966, 0xfac4, 0xfe5b,
    0x019d, 0x0310, 0x030b, 0x01e0, 0xff50, 0xfc42, 0xfae8, 0xfcc3,
    0x0071, 0x030e, 0x03d7, 0x028d, 0xff60, 0xfc3f, 0xf9e8, 0xf80e,
    0xf7de, 0xfa64, 0xfe68, 0x021b, 0x0530, 0x07b3, 0x094b, 0x0a34,
    0x0aa2, 0x0996, 0x062d, 0x0102, 0xfc37, 0xf9aa, 0xf9b0, 0xfb5d,
    0xfd8d, 0xffc4, 0x017f, 0x0228, 0x0116, 0xfe75, 0xfbc3, 0xfa33,
    0xfa13, 0xfadc, 0xfc6d, 0xfe98, 0x0016, 0xff86, 0xfdde, 0xfdaf,
    0xffc4, 0x03ca, 0x086f, 0x0b16, 0x0ab9, 0x0897, 0x0673, 0x0571,
    0x0510, 0x049e, 0x027d, 0xfd9c, 0xf8f1, 0xf7e7, 0xf9cb, 0xfc24,
    0xfe1b, 0xfef7, 0xfe29, 0xfd06, 0xfc91, 0xfc34, 0xfbb6, 0xfbc0,
    0xfbfc, 0xfbce, 0xfbeb, 0xfcdd, 0xff39, 0x0306, 0x06a6, 0x090a,
    0x0a62, 0x0a59, 0x0a36, 0x09c3, 0x063c, 0xfffd, 0xf7fa, 0xef7d,
    0xea15, 0xeadf, 0xf08f, 0xf7be, 0xfe9b, 0x04d0, 0x0aee, 0x106f,
    0x12a7, 0x0f29, 0x07ec, 0x002e, 0xf962, 0xf4da, 0xf3d1, 0xf6c2,
    0xfc8e, 0x02d0, 0x0731, 0x08db, 0x08c8, 0x0768, 0x04a7, 0x0131,
    0xfd12, 0xf97f, 0xf953, 0xfceb, 0x0182, 0x0547, 0x074d, 0x0618,
    0x01b8, 0xfd31, 0xfb18, 0xfb11, 0xfc1e, 0xfe3a, 0x009d, 0x01ba,
    0x01b8, 0x01b8, 0x021a, 0x0160, 0xfe6e, 0xfabb, 0xf823, 0xf756,
    0xf879, 0xfba1, 0xff65, 0x026b, 0x04f2, 0x06cc, 0x06f9, 0x0593,
    0x03d8, 0x019e, 0xfda2, 0xf85c, 0xf4f7, 0xf642, 0xfb94, 0x01d7,
    0x06a1, 0x081e, 0x06b8, 0x04ab, 0x0246, 0xff5b, 0xfd33, 0xfce6,
    0xfcf8, 0xfbcb, 0xf994, 0xf71b, 0xf600, 0xf795, 0xfc76, 0x03ec,
    0x0a9c, 0x0e05, 0x0e95, 0x0d57, 0x0a84, 0x05fa, 0x00bd, 0xfc4f,
    0xf9d8, 0xf9f3, 0xfbf9, 0xff00, 0x022e, 0x0496, 0x0477, 0x01cd,
    0xfea0, 0xfc03, 0xfaa4, 0xfafe, 0xfc62, 0xfd55, 0xfde1, 0xfec9,
    0xffc8, 0xffec, 0xff40, 0xfef3, 0xff33, 0xff4b, 0xff33, 0xff8e,
    0x0111, 0x02f2, 0x0331, 0x01e2, 0x00f4, 0x00c6, 0xffe1, 0xfd9b,
    0xfaf5, 0xf987, 0xf99f, 0xfada, 0xfd48, 0x0102, 0x04d1, 0x07e1,
    0x0adb, 0x0cc9, 0x0c6a, 0x0a42, 0x06dd, 0x01c6, 0xfba7, 0xf5b3,
    0xf040, 0xece4, 0xedbd, 0xf2e2, 0xfa21, 0x0165, 0x06c0, 0x08d8,
    0x0875, 0x06d4, 0x043b, 0x01aa, 0x00a1, 0x0179, 0x03b6, 0x06e5,
    0x0aa0, 0x0ccd, 0x0ba1, 0x08db, 0x0628, 0x02e0, 0xfde2, 0xf787,
    0xf1fc, 0xefc6, 0xf1bc, 0xf601, 0xf9b6, 0xfb6a, 0xfc4d, 0xfdcf,
    0xff51, 0x00c1, 0x0333, 0x0572, 0x0602, 0x0590, 0x0467, 0x01e1,
    0xfebb, 0xfcd9, 0xfbe7, 0xfaf4, 0xfc0b, 0x0060, 0x05d6, 0x09f0,
    0x0ac3, 0x08ba, 0x04c1, 0xffd9, 0xfc10, 0xfb75, 0xfdd5, 0x0007,
    0x00c1, 0x00a5, 0xfff7, 0xfe96, 0xfcde, 0xfa93, 0xf879, 0xf993,
    0xfdbb, 0x015c, 0x03db, 0x06b2, 0x08d7, 0x0842, 0x0516, 0x00d0,
    0xfc2a, 0xf839, 0xf64d, 0xf5f7, 0xf5dc, 0xf6f7, 0xfb2d, 0x0156,
    0x0652, 0x0957, 0x0ae0, 0x0980, 0x048e, 0xff05, 0xfce2, 0xfe7d,
    0x01df, 0x0541, 0x06d3, 0x0594, 0x01f4, 0xfda4, 0xfa7d, 0xf901,
    0xf8b3, 0xf951, 0xfb12, 0xfd95, 0xfef5, 0xff0d, 0xfed5, 0xfeb1,
    0xfea3, 0xff1e, 0x001c, 0x00aa, 0x016e, 0x02ed, 0x04a0, 0x04fe,
    0x0456, 0x04a7, 0x05ab, 0x04cd, 0x00f0, 0xfbd5, 0xf776, 0xf4f7,
    0xf528, 0xf8ad, 0xfe53, 0x0410, 0x089c, 0x0a35, 0x0779, 0x01b4,
    0xfbde, 0xf850, 0xf91d, 0xfe02, 0x03a9, 0x0770, 0x099f, 0x0b0c,
    0x0aae, 0x06b2, 0x0013, 0xfa66, 0xf652, 0xf3c7, 0xf4af, 0xf8ee,
    0xfdc3, 0x01c8, 0x04c1, 0x0509, 0x026d, 0xff05, 0xfc06, 0xf9e0,
    0xf947, 0xfa13, 0xfaad, 0xfad4, 0xfc17, 0xfe7e, 0x010a, 0x0340,
    0x049f, 0x041a, 0x01d7, 0x0028, 0x0109, 0x03d3, 0x06d6, 0x09e0,
    0x0c14, 0x0b6c, 0x079d, 0x02fb, 0xff12, 0xfb97, 0xf8c3, 0xf842,
    0xfa82, 0xfe0f, 0x017d, 0x0381, 0x040b, 0x0428, 0x0464, 0x0352,
    0xff9e, 0xfa65, 0xf5aa, 0xf2aa, 0xf2d6, 0xf6ea, 0xfd3d, 0x03e5,
    0x0a28, 0x0e54, 0x0d8a, 0x0747, 0xfeb5, 0xf722, 0xf1c8, 0xeff8,
    0xf2e5, 0xf963, 0x0012, 0x0484, 0x075c, 0x096f, 0x0a4e, 0x09fb,
    0x0999, 0x0929, 0x07c1, 0x05c5, 0x03ee, 0x01f4, 0xff3e, 0xfcd2,
    0xfae1, 0xf908, 0xf84b, 0xf835, 0xf822, 0xf9b5, 0xfe35, 0x03cc,
    0x07b0, 0x083d, 0x0558, 0x0016, 0xfa6b, 0xf599, 0xf2b3, 0xf244,
    0xf336, 0xf563, 0xf974, 0xfead, 0x038d, 0x0812, 0x0c3b, 0x0f2a,
    0x1077, 0x106c, 0x0f41, 0x0db2, 0x0aee, 0x05c7, 0xff76, 0xf95d,
    0xf43c, 0xf0f4, 0xf0c4, 0xf2cd, 0xf63c, 0xfc2d, 0x03e3, 0x0a30,
    0x0c7f, 0x0990, 0x0230, 0xfa5b, 0xf5a9, 0xf449, 0xf4d4, 0xf77c,
    0xfc2f, 0x0170, 0x05ff, 0x08f5, 0x09ba, 0x07c4, 0x033f, 0xfd8f,
    0xf7fa, 0xf361, 0xf20f, 0xf5af, 0xfbe9, 0x0255, 0x0800, 0x0b28,
    0x0aad, 0x0791, 0x046f, 0x032f, 0x04bc, 0x07d4, 0x0a06, 0x099b,
    0x0603, 0x0051, 0xfa60, 0xf602, 0xf3d6, 0xf3c5, 0xf5b3, 0xf923,
    0xfd00, 0x004b, 0x02d0, 0x0482, 0x0545, 0x04fa, 0x0327, 0x0009,
    0xfd15, 0xfb68, 0xfaa2, 0xfa64, 0xfb29, 0xfdf1, 0x02dd, 0x07a9,
    0x09f3, 0x087d, 0x040d, 0xff4a, 0xfbe0, 0xfa6d, 0xfb2f, 0xfe46,
    0x020e, 0x03a5, 0x0249, 0xfee2, 0xfa46, 0xf64e, 0xf685, 0xfb7c,
    0x0131, 0x04fa, 0x0764, 0x08a2, 0x083b, 0x05f4, 0x0272, 0xfedc,
    0xfb84, 0xf9a0, 0xfb1b, 0xffd1, 0x0519, 0x0863, 0x092a, 0x0735,
    0x02dd, 0xfe2f, 0xfa1c, 0xf78b, 0xf768, 0xf8a8, 0xf880, 0xf6f2,
    0xf6bf, 0xf892, 0xfc2a, 0x0124, 0x05d1, 0x07f2, 0x0796, 0x0703,
    0x0728, 0x07c6, 0x08d9, 0x09b9, 0x08ac, 0x0497, 0xff2d, 0xfa66,
    0xf6c4, 0xf49f, 0xf429, 0xf5d4, 0xfa16, 0x0069, 0x064c, 0x091b,
    0x08f8, 0x0748, 0x0478, 0x00b3, 0xfced, 0xf99d, 0xf5ed, 0xf2cb,
    0xf383, 0xf7bf, 0xfcec, 0x0353, 0x0b19, 0x1081, 0x105b, 0x0c16,
    0x056a, 0xfd1a, 0xf58d, 0xf142, 0xf058, 0xf294, 0xf77e, 0xfd56,
    0x0316, 0x08e4, 0x0e23, 0x10df, 0x1042, 0x0d01, 0x07d1, 0x01d2,
    0xfcc2, 0xf914, 0xf6aa, 0xf616, 0xf7c8, 0xfb04, 0xfec7, 0x02c8,
    0x04d2, 0x0384, 0x013e, 0x0052, 0x00cc, 0x01f4, 0x0315, 0x02af,
    0x0038, 0xfcd8, 0xf9e0, 0xf8a3, 0xf983, 0xfba5, 0xfd05, 0xfd1e,
    0xfe0c, 0xfffe, 0x01bf, 0x03e4, 0x0631, 0x0749, 0x07db, 0x0919,
    0x0952, 0x0591, 0xfe1b, 0xf691, 0xf137, 0xee5e, 0xeecb, 0xf367,
    0xfb91, 0x05d5, 0x0fc7, 0x155e, 0x14d3, 0x0e06, 0x0261, 0xf649,
    0xeeea, 0xee89, 0xf2cf, 0xf916, 0xfff8, 0x060f, 0x0a75, 0x0cf5,
    0x0da7, 0x0c02, 0x07a1, 0x00e9, 0xf9bc, 0xf40c, 0xf0b7, 0xf115,
    0xf583, 0xfbd1, 0x016c, 0x056e, 0x074c, 0x05ad, 0x0224, 0x0067,
    0x00c8, 0x02ca, 0x0567, 0x0711, 0x06a8, 0x037c, 0xfefa, 0xfa2a,
    0xf6d7, 0xf5dc, 0xf761, 0xfb75, 0x00fd, 0x065d, 0x0a40, 0x0c2f,
    0x0b20, 0x0805, 0x0425, 0xff61, 0xf9db, 0xf4e4, 0xf1f5, 0xf16f,
    0xf39b, 0xf874, 0xff96, 0x0796, 0x0d70, 0x0e69, 0x0a64, 0x0394,
    0xfce9, 0xf8c5, 0xf810, 0xf9c9, 0xfcb8, 0xffcb, 0x0181, 0x00b8,
    0xfe06, 0xfb9a, 0xfb3a, 0xfd54, 0x0031, 0x0169, 0x0084, 0xffe8,
    0x019f, 0x04be, 0x0752, 0x07af, 0x0560, 0x01f1, 0xfff7, 0x00ad,
    0x036d, 0x0664, 0x0831, 0x08b5, 0x06bb, 0x0210, 0xfca2, 0xf818,
    0xf511, 0xf3e9, 0xf4a2, 0xf645, 0xf8dc, 0xfcb4, 0x00bc, 0x0304,
    0x02c1, 0x0124, 0xff18, 0xfd56, 0xfca4, 0xfdae, 0x00d2, 0x0472,
    0x067c, 0x06e2, 0x064c, 0x0498, 0x0267, 0x012c, 0x0059, 0xfee0,
    0xfe04, 0xfe31, 0xfe0f, 0xfd8c, 0xfe3f, 0x0013, 0x01bc, 0x02c6,
    0x023d, 0xfee1, 0xf9ab, 0xf63f, 0xf624, 0xf892, 0xfcfb, 0x0277,
    0x06fb, 0x0995, 0x0ae0, 0x0a6f, 0x083e, 0x0572, 0x02e0, 0xff94,
    0xfaf8, 0xf660, 0xf399, 0xf372, 0xf5aa, 0xfa82, 0x0145, 0x0786,
    0x0b1b, 0x0bcc, 0x0983, 0x0433, 0xfe00, 0xf9a6, 0xf7fe, 0xf86c,
    0xfad3, 0xfdba, 0x0050, 0x03a3, 0x0816, 0x0c87, 0x0e91, 0x0d47,
    0x08b3, 0x01e3, 0xfb46, 0xf612, 0xf34b, 0xf1df, 0xf0ea, 0xf308,
    0xf8b4, 0xfe8f, 0x0182, 0x026b, 0x02be, 0x0320, 0x0477, 0x05f7,
    0x0654, 0x05d0, 0x04f2, 0x02f2, 0xffa9, 0xfd5c, 0xfd24, 0xff65,
    0x0382, 0x06a0, 0x0658, 0x02f6, 0xfe64, 0xfb6e, 0xfba2, 0xfd24,
    0xff61, 0x00cd, 0xff8b, 0xfcba, 0xfa96, 0xf931, 0xf867, 0xf9de,
    0xfcdb, 0x0004, 0x0425, 0x07e3, 0x08aa, 0x07a1, 0x06d3, 0x0458,
    0xfee8, 0xf9d6, 0xf77d, 0xf723, 0xf803, 0xf9f2, 0xfc9d, 0xff75,
    0x023b, 0x04aa, 0x05d7, 0x0484, 0x018d, 0xffa7, 0xff88, 0x0103,
    0x043e, 0x0716, 0x0761, 0x04d4, 0x0052, 0xfc29, 0xfa05, 0xfa4c,
    0xfcef, 0x0135, 0x04de, 0x067c, 0x06a8, 0x0678, 0x0561, 0x027c,
    0xfec0, 0xfb7b, 0xf8a0, 0xf636, 0xf616, 0xf862, 0xfbb2, 0xff4a,
    0x0211, 0x030e, 0x02ef, 0x02ae, 0x01dd, 0xff79, 0xfbf3, 0xf98e,
    0xfa66, 0xfd53, 0xff8b, 0x00c3, 0x01a6, 0x01f3, 0x01fc, 0x02f9,
    0x03f2, 0x03b2, 0x039b, 0x0426, 0x0366, 0x00cb, 0xfd92, 0xfb69,
    0xfb6c, 0xfd81, 0x0018, 0x0154, 0x01a9, 0x02d5, 0x0588, 0x0785,
    0x05de, 0x0130, 0xfcd6, 0xfaa1, 0xfb3c, 0xfec7, 0x024f, 0x03a1,
    0x03ee, 0x0310, 0xff97, 0xfadc, 0xf7f9, 0xf7d3, 0xfa1b, 0xfe5d,
    0x034e, 0x0738, 0x08fb, 0x085d, 0x0459, 0xfd94, 0xf750, 0xf419,
    0xf487, 0xf7db, 0xfd2b, 0x0319, 0x076d, 0x090f, 0x08f6, 0x07bf,
    0x055e, 0x021e, 0xfe37, 0xf9d9, 0xf61c, 0xf484, 0xf5c7, 0xf9d3,
    0xffbf, 0x06a9, 0x0c60, 0x0e08, 0x0b37, 0x05dc, 0xffcf, 0xfa32,
    0xf68f, 0xf68d, 0xfa03, 0xfeea, 0x0321, 0x05d0, 0x06f7, 0x059a,
    0x020f, 0xfec8, 0xfcac, 0xfb3e, 0xfa73, 0xfaa4, 0xfb83, 0xfcfd,
    0xff19, 0x00f8, 0x0291, 0x03b1, 0x02f1, 0x007f, 0xfe75, 0xfd87,
    0xfd3b, 0xfe1c, 0x00de, 0x050d, 0x0a38, 0x0efb, 0x101d, 0x0b4f,
    0x0208, 0xf93b, 0xf460, 0xf389, 0xf58e, 0xf841, 0xfa9e, 0xfe14,
    0x030d, 0x0738, 0x088a, 0x06ac, 0x02a9, 0xfd9f, 0xf811, 0xf35f,
    0xf1b8, 0xf410, 0xf901, 0xff37, 0x053b, 0x099c, 0x0bdc, 0x0bba,
    0x09e0, 0x0740, 0x0423, 0x00c9, 0xfdb5, 0xfc83, 0xfbbb, 0xf9b6,
    0xf86f, 0xf8e7, 0xfa4c, 0xfbf6, 0xfef8, 0x02da, 0x067f, 0x081c,
    0x064d, 0x01fc, 0xfcc0, 0xf7be, 0xf415, 0xf42b, 0xf87e, 0xfe4e,
    0x03ad, 0x087c, 0x0b52, 0x0b55, 0x08b2, 0x04aa, 0x01af, 0x0095,
    0xffee, 0xff3c, 0xfeff, 0xfdfd, 0xfc81, 0xfcb8, 0xfd9b, 0xfd37,
    0xfc54, 0xfb41, 0xf9ed, 0xfab2, 0xffb6, 0x071b, 0x0cde, 0x0ef8,
    0x0ccf, 0x06c6, 0xfec4, 0xf721, 0xf2f9, 0xf37f, 0xf732, 0xfc80,
    0x02b4, 0x0839, 0x0aaf, 0x0a06, 0x0724, 0x01fa, 0xfbcf, 0xf6d1,
    0xf3c0, 0xf359, 0xf6b6, 0xfcd2, 0x02af, 0x0686, 0x085f, 0x08b8,
    0x0811, 0x05da, 0x0288, 0xffd8, 0xfe5c, 0xfe34, 0xff0d, 0xff6b,
    0xfdef, 0xfb7e, 0xfa20, 0xf9f5, 0xfa35, 0xf9e2, 0xf7f4, 0xf614,
    0xf7c0, 0xfd64, 0x03f0, 0x09a2, 0x0e17, 0x1013, 0x0f0e, 0x0aaa,
    0x02d5, 0xfa84, 0xf5a7, 0xf5c9, 0xfa03, 0x00ed, 0x084f, 0x0d12,
    0x0e0f, 0x0b48, 0x0591, 0xfe86, 0xf83e, 0xf513, 0xf4f6, 0xf5fa,
    0xf69e, 0xf6fd, 0xf84e, 0xfb93, 0x0039, 0x0468, 0x06df, 0x074f,
    0x05b1, 0x0282, 0xff98, 0xff7d, 0x0289, 0x0624, 0x07bf, 0x066c,
    0x020c, 0xfb9c, 0xf59a, 0xf1f9, 0xf11b, 0xf352, 0xf8bd, 0xff88,
    0x05c6, 0x0a42, 0x0c74, 0x0cf9, 0x0bc6, 0x0892, 0x0366, 0xfc9e,
    0xf603, 0xf2ea, 0xf4be, 0xf921, 0xfdf9, 0x0341, 0x07b5, 0x094b,
    0x07ca, 0x040f, 0xff15, 0xfa2c, 0xf77f, 0xf837, 0xfba3, 0x0079,
    0x04ad, 0x064e, 0x05a4, 0x0406, 0x026f, 0x01b4, 0x01eb, 0x018f,
    0xffdf, 0xfe30, 0xfd80, 0xfdce, 0xfeb1, 0x0040, 0x01e0, 0x0283,
    0x016f, 0xfe67, 0xfba5, 0xfb4f, 0xfcb8, 0xfe66, 0xffa5, 0xff8f,
    0xfe32, 0xfcff, 0xfcc3, 0xfd24, 0xfddc, 0xfe11, 0xfcf7, 0xfbf4,
    0xfcba, 0xfed7, 0x0156, 0x0468, 0x0804, 0x0afc, 0x0cad, 0x0dcf,
    0x0e51, 0x0d22, 0x08a3, 0x011c, 0xf85c, 0xf018, 0xeaa1, 0xea2c,
    0xee0e, 0xf45a, 0xfcc0, 0x05ef, 0x0d86, 0x11a0, 0x10ab, 0x093b,
    0xfd62, 0xf39f, 0xf060, 0xf24d, 0xf707, 0xfd19, 0x02e1, 0x06f3,
    0x08e5, 0x08ba, 0x06dd, 0x040a, 0x0045, 0xfc21, 0xf872, 0xf630,
    0xf774, 0xfced, 0x034c, 0x07ae, 0x09de, 0x09db, 0x06b9, 0x0191,
    0xfe01, 0xfd2e, 0xfe27, 0x0078, 0x03be, 0x060d, 0x05a1, 0x02dc,
    0xff1d, 0xfb8b, 0xf8d4, 0xf7bc, 0xf8a5, 0xfb31, 0xfe3c, 0x0137,
    0x03b5, 0x04ae, 0x04b2, 0x048e, 0x0380, 0x0134, 0xfe60, 0xfb5a,
    0xf878, 0xf73f, 0xf8e1, 0xfdaa, 0x04a4, 0x0a6d, 0x0c46, 0x0a1c,
    0x054f, 0xff3b, 0xf99d, 0xf5cd, 0xf413, 0xf525, 0xf922, 0xfe55,
    0x0306, 0x0659, 0x0758, 0x0596, 0x0284, 0x0033, 0xfe09, 0xfb39,
    0xf9b1, 0xfb2d, 0xfe4d, 0x0118, 0x02d8, 0x040c, 0x04a7, 0x0454,
    0x04bd, 0x0635, 0x06dd, 0x0660, 0x0564, 0x02f8, 0xff48, 0xfc7e,
    0xfafc, 0xfa16, 0xfa9e, 0xfc2d, 0xfc3c, 0xf982, 0xf681, 0xf57a,
    0xf6c3, 0xfb6d, 0x02a3, 0x086d, 0x0a59, 0x090f, 0x06aa, 0x0530,
    0x0532, 0x0645, 0x06b8, 0x0456, 0xff85, 0xfaea, 0xf7c8, 0xf71b,
    0xf920, 0xfcad, 0x0152, 0x069a, 0x0a34, 0x09ea, 0x0693, 0x021d,
    0xfd8a, 0xf978, 0xf6b1, 0xf556, 0xf542, 0xf766, 0xfbee, 0x011b,
    0x04ad, 0x065b, 0x0738, 0x06c7, 0x03ee, 0xff81, 0xfbe8, 0xf9b7,
    0xf93e, 0xfb14, 0xfee5, 0x036a, 0x0680, 0x071d, 0x054f, 0x019d,
    0xfe07, 0xfdf0, 0x0162, 0x04e0, 0x0596, 0x02d3, 0xfde0, 0xf977,
    0xf86b, 0xfa92, 0xfddf, 0x0063, 0x0086, 0x0097, 0x034e, 0x062e,
    0x06ab, 0x04d5, 0x01c3, 0xfd87, 0xf8ee, 0xf5f7, 0xf520, 0xf6b3,
    0xf9a5, 0xfc71, 0xfe73, 0x00a4, 0x0398, 0x0634, 0x08b9, 0x0ad8,
    0x0ade, 0x0882, 0x04f6, 0x01f4, 0x015e, 0x0229, 0x021c, 0x0058,
    0xfc7f, 0xf719, 0xf2ae, 0xf1e2, 0xf42c, 0xf8ba, 0xff31, 0x063e,
    0x0cdd, 0x1088, 0x0de6, 0x0557, 0xfb3f, 0xf361, 0xefa9, 0xf18f,
    0xf811, 0x0092, 0x08a8, 0x0da6, 0x0db9, 0x0a27, 0x0586, 0x00a5,
    0xfc31, 0xf8a9, 0xf591, 0xf42f, 0xf66b, 0xfb11, 0xfff9, 0x03f8,
    0x0573, 0x03e7, 0x00a1, 0xfe2e, 0xfe42, 0x00b3, 0x045f, 0x07a5,
    0x09ac, 0x092c, 0x0568, 0x00c2, 0xfd24, 0xfa54, 0xf874, 0xf8c7,
    0xfb0c, 0xfd19, 0xffa7, 0x02e2, 0x045b, 0x03b0, 0x02a7, 0x014f,
    0xfecb, 0xfce3, 0xfcac, 0xfce1, 0xfc1d, 0xfbac, 0xfe40, 0x0423,
    0x0a68, 0x0ddc, 0x0c7c, 0x05d1, 0xfca2, 0xf54a, 0xf249, 0xf32e,
    0xf789, 0xfe23, 0x023d, 0x00f0, 0xfcba, 0xf93c, 0xf869, 0xfbc5,
    0x02dc, 0x0915, 0x0a4f, 0x0758, 0x03ba, 0x020c, 0x01e3, 0x01b4,
    0x013a, 0x0031, 0xfefa, 0xff95, 0x01cc, 0x0338, 0x03cc, 0x0405,
    0x0239, 0xfee1, 0xfcef, 0xfca8, 0xfcc0, 0xfc57, 0xfaf5, 0xf8ec,
    0xf7d4, 0xf971, 0xfdbc, 0x02d9, 0x06fd, 0x08d1, 0x0821, 0x0653,
    0x04c7, 0x04bd, 0x053f, 0x045a, 0x0144, 0xfd75, 0xfa50, 0xf7ab,
    0xf654, 0xf713, 0xfa00, 0xfdfc, 0x01a3, 0x0447, 0x0602, 0x0740,
    0x0767, 0x059f, 0x0239, 0xfe5a, 0xfb1c, 0xf929, 0xf8c2, 0xf9ba,
    0xfb55, 0xfc7f, 0xfd7d, 0xfff9, 0x0399, 0x0619, 0x066b, 0x0451,
    0x0044, 0xfcdf, 0xfc6a, 0xfec6, 0x01ef, 0x0351, 0x0231, 0xff32,
    0xfbd4, 0xfae1, 0xfe1b, 0x03cb, 0x07fa, 0x0955, 0x0923, 0x07c9,
    0x0539, 0x02c4, 0x016b, 0xffce, 0xfb7a, 0xf5c2, 0xf2c9, 0xf3e4,
    0xf79a, 0xfc42, 0x0030, 0x027d, 0x03a1, 0x04b6, 0x0556, 0x03bc,
    0xff41, 0xf97e, 0xf4db, 0xf2bc, 0xf535, 0xfba2, 0x0344, 0x09fb,
    0x0dae, 0x0e5a, 0x0c9a, 0x09e9, 0x089c, 0x0776, 0x0499, 0xff87,
    0xf8aa, 0xf165, 0xecb3, 0xed8c, 0xf309, 0xfae3, 0x02f8, 0x0a3f,
    0x0fdc, 0x1151, 0x0cfc, 0x0495, 0xfc36, 0xf671, 0xf380, 0xf3f7,
    0xf7b0, 0xfd8d, 0x0387, 0x06b0, 0x0558, 0x00ff, 0xfc8a, 0xf969,
    0xf8d9, 0xfa84, 0xfcdd, 0x0041, 0x0533, 0x08bb, 0x08c7, 0x074c,
    0x04ac, 0xffdb, 0xfaab, 0xf8bd, 0xfa88, 0xfe51, 0x02fb, 0x0789,
    0x0ab8, 0x0b09, 0x0842, 0x0387, 0xfe81, 0xf9f1, 0xf64f, 0xf4d4,
    0xf600, 0xf938, 0xfdcb, 0x02b5, 0x0655, 0x087d, 0x09cb, 0x0962,
    0x0727, 0x045d, 0x018b, 0xfe7f, 0xfab5, 0xf6f2, 0xf5f2, 0xf922,
    0xfd7d, 0x0085, 0x0267, 0x02b9, 0x0133, 0xff3d, 0xfd69, 0xfafa,
    0xf9a0, 0xfb5c, 0xfe65, 0xfffd, 0x0008, 0xfe70, 0xfbcf, 0xfb19,
    0xfe0c, 0x0276, 0x0673, 0x0ace, 0x0e59, 0x0e43, 0x09a0, 0x0230,
    0xfad4, 0xf620, 0xf4cb, 0xf622, 0xf9aa, 0xfe2c, 0x036f, 0x0840,
    0x096a, 0x0756, 0x04fb, 0x024c, 0xff16, 0xfdeb, 0xfe54, 0xfcea,
    0xf929, 0xf65a, 0xf59b, 0xf5d4, 0xf86d, 0xfdb0, 0x02dd, 0x0630,
    0x07dd, 0x081b, 0x07f7, 0x0813, 0x07aa, 0x068f, 0x0457, 0xffab,
    0xf99a, 0xf541, 0xf458, 0xf6e1, 0xfbb6, 0x023c, 0x0973, 0x0f24,
    0x1147, 0x0ece, 0x081e, 0xfef8, 0xf63c, 0xefcd, 0xec62, 0xecdd,
    0xf155, 0xf851, 0xffdd, 0x05fe, 0x0991, 0x0a83, 0x0928, 0x0621,
    0x01c9, 0xfcd0, 0xf865, 0xf605, 0xf781, 0xfc6f, 0x01f4, 0x05b9,
    0x0755, 0x069d, 0x0407, 0x01df, 0x00ce, 0x0102, 0x0333, 0x0753,
    0x0aa3, 0x0a6b, 0x0768, 0x0288, 0xfca6, 0xf77b, 0xf528, 0xf58e,
    0xf686, 0xf873, 0xfd53, 0x038b, 0x0891, 0x0be2, 0x0bf6, 0x0721,
    0xff58, 0xf86a, 0xf2d2, 0xeeed, 0xee5e, 0xf0a6, 0xf491, 0xfa6a,
    0x01d1, 0x07f1, 0x0bde, 0x0dbe, 0x0cbc, 0x08e7, 0x043f, 0x0158,
    0x01c7, 0x03ae, 0x0331, 0xffec, 0xfaa6, 0xf497, 0xf0f1, 0xf28f,
    0xf8ed, 0x01a4, 0x0b73, 0x13cc, 0x17d7, 0x16df, 0x0ff6, 0x0336,
    0xf529, 0xebc9, 0xe908, 0xeb7c, 0xf1a1, 0xfa2d, 0x0372, 0x0a8b,
    0x0d57, 0x0c46, 0x08b9, 0x03e6, 0xff03, 0xfadd, 0xf6d8, 0xf3ca,
    0xf3ec, 0xf6ac, 0xfa41, 0xffa5, 0x05b8, 0x0854, 0x06ac, 0x03cb,
    0x02aa, 0x036b, 0x0557, 0x0746, 0x0745, 0x0496, 0x0006, 0xfaef,
    0xf6c4, 0xf500, 0xf689, 0xfa47, 0xfeb7, 0x0386, 0x07c8, 0x0a0a,
    0x09b2, 0x0779, 0x0467, 0x0146, 0xfe8a, 0xfcb2, 0xfbf5, 0xfbb2,
    0xfb2f, 0xfab4, 0xfc15, 0x005a, 0x05e9, 0x0967, 0x0888, 0x0469,
    0xfeb3, 0xf8c0, 0xf4b8, 0xf430, 0xf6d3, 0xfad9, 0xfee1, 0x0100,
    0xffce, 0xfc8f, 0xfa43, 0xfb05, 0xff09, 0x0427, 0x07a8, 0x09c8,
    0x0b70, 0x0c1b, 0x0a27, 0x055a, 0xffb6, 0xfa8d, 0xf754, 0xf709,
    0xf93a, 0xfcda, 0x0110, 0x0602, 0x0a40, 0x0b1c, 0x083e, 0x03e4,
    0xff7e, 0xfb63, 0xf7fd, 0xf4ad, 0xf1e4, 0xf1dc, 0xf58d, 0xfc29,
    0x0393, 0x0987, 0x0be6, 0x0a00, 0x04f2, 0xff24, 0xfbfa, 0xfc5c,
    0xfeef, 0x02a1, 0x0549, 0x0521, 0x02f9, 0x0004, 0xfcf7, 0xfac4,
    0xfb3a, 0xfe7d, 0x02d4, 0x06d1, 0x08bf, 0x07a4, 0x0410, 0xffa0,
    0xfc24, 0xf9d4, 0xf7ef, 0xf67c, 0xf61e, 0xf719, 0xf954, 0xfd10,
    0x0297, 0x08f4, 0x0d83, 0x0dca, 0x09a9, 0x027f, 0xfa56, 0xf3db,
    0xf0ce, 0xf1ae, 0xf596, 0xfa9f, 0xfee7, 0x01f2, 0x04b3, 0x0832,
    0x0c4e, 0x0f70, 0x0fdd, 0x0c2b, 0x0505, 0xfdb6, 0xf9b0, 0xfa19,
    0xfcd4, 0xff29, 0x00c1, 0x0255, 0x0341, 0x0331, 0x025a, 0x0048,
    0xfdd4, 0xfc78, 0xfc29, 0xfb66, 0xfa6f, 0xf9b1, 0xf800, 0xf6a6,
    0xf7ae, 0xfac0, 0xfe46, 0x0280, 0x0684, 0x077c, 0x05f3, 0x0409,
    0x0372, 0x051f, 0x078c, 0x0930, 0x085b, 0x02d1, 0xf93b, 0xefa1,
    0xea79, 0xebc9, 0xf35e, 0xfe80, 0x098a, 0x120b, 0x15bf, 0x1392,
    0x0d12, 0x0551, 0xfe51, 0xf801, 0xf328, 0xf1df, 0xf504, 0xfb70,
    0x01fa, 0x064a, 0x08d0, 0x09c7, 0x07cd, 0x0312, 0xfde5, 0xf90c,
    0xf54b, 0xf3f5, 0xf48b, 0xf766, 0xfd45, 0x0345, 0x054b, 0x02df,
    0xffb0, 0xfe6e, 0xfe22, 0xfe96, 0x0199, 0x06e7, 0x0b01, 0x0b94,
    0x096d, 0x052e, 0xff52, 0xfa34, 0xf7d2, 0xf77c, 0xf80f, 0xfad8,
    0xfff2, 0x04ad, 0x0806, 0x0a61, 0x0ac9, 0x08df, 0x065a, 0x0445,
    0x0168, 0xfc95, 0xf73e, 0xf4b5, 0xf5df, 0xf94f, 0xfd9e, 0x018b,
    0x0422, 0x04ed, 0x044c, 0x0196, 0xfd3b, 0xf9f2, 0xf890, 0xf827,
    0xf71e, 0xf448, 0xf126, 0xf1c4, 0xf81e, 0x0208, 0x0c57, 0x1461,
    0x17ad, 0x145a, 0x0bdb, 0x0209, 0xf969, 0xf32d, 0xf184, 0xf53e,
    0xfb58, 0x0189, 0x0753, 0x0c05, 0x0dea, 0x0b93, 0x0639, 0x00c3,
    0xfd70, 0xfc37, 0xfc14, 0xfb9d, 0xfa45, 0xf840, 0xf6a8, 0xf713,
    0xf94e, 0xfc27, 0xfe86, 0xffb2, 0x0061, 0x01d0, 0x04c8, 0x0967,
    0x0dd5, 0x0f37, 0x0c04, 0x04f0, 0xfb9a, 0xf2fa, 0xee51, 0xef9f,
    0xf712, 0x0138, 0x094c, 0x0c1f, 0x0b4c, 0x0937, 0x05bf, 0x01f3,
    0xfe8f, 0xfbee, 0xf99b, 0xf720, 0xf684, 0xf88c, 0xfb88, 0xfe6a,
    0x02a0, 0x07d6, 0x0a96, 0x097c, 0x05bc, 0xffe6, 0xf8b4, 0xf3cf,
    0xf420, 0xf86d, 0xfd04, 0xff70, 0xffeb, 0xfee4, 0xfd5b, 0xfd93,
    0x0102, 0x070f, 0x0ceb, 0x1085, 0x114a, 0x0eec, 0x0a03, 0x0455,
    0xffda, 0xfbb8, 0xf5fc, 0xeffa, 0xed9e, 0xf0eb, 0xf7f6, 0x0042,
    0x06f8, 0x0a9e, 0x0bd6, 0x0b03, 0x084d, 0x03a7, 0xfd4c, 0xf5a1,
    0xef27, 0xec42, 0xed16, 0xf1b0, 0xfa06, 0x03bf, 0x0b0f, 0x0e86,
    0x0eb0, 0x0d36, 0x0c1b, 0x0ac8, 0x07b7, 0x0254, 0xfa59, 0xf178,
    0xeb97, 0xeafe, 0xef72, 0xf87b, 0x044d, 0x0fa9, 0x180d, 0x1bb3,
    0x181f, 0x0d32, 0xff81, 0xf3cc, 0xec34, 0xea38, 0xee77, 0xf710,
    0x00b4, 0x0819, 0x0b50, 0x0b03, 0x0918, 0x0636, 0x023b, 0xfd33,
    0xf7c9, 0xf469, 0xf4d1, 0xf722, 0xf9ab, 0xfd83, 0x012e, 0x00dc,
    0xfd79, 0xfbc9, 0xfd73, 0x005e, 0x035e, 0x0714, 0x0b2c, 0x0d94,
    0x0cb0, 0x090d, 0x03c9, 0xfca2, 0xf4b8, 0xef71, 0xeee8, 0xf30a,
    0xfa8c, 0x0369, 0x0a74, 0x0e22, 0x0f18, 0x0da7, 0x0a46, 0x061a,
    0x0237, 0xfdfc, 0xf8e8, 0xf4b0, 0xf3c8, 0xf725, 0xfd3b, 0x02fd,
    0x05e7, 0x0520, 0x01f7, 0xfe47, 0xfaba, 0xf823, 0xf7e2, 0xf9d0,
    0xfc17, 0xfd9e, 0xfe16, 0xfcd6, 0xfb10, 0xfc5a, 0x01a8, 0x083e,
    0x0cff, 0x0f2b, 0x0eb5, 0x0b62, 0x0643, 0x0021, 0xf9fa, 0xf4f0,
    0xf1c1, 0xf1fb, 0xf5f8, 0xfbd4, 0x0206, 0x0791, 0x0a88, 0x0a97,
    0x094f, 0x06b6, 0x03a5, 0x026b, 0x0230, 0xffb4, 0xfa6b, 0xf502,
    0xf091, 0xee04, 0xf05e, 0xf871, 0x01fe, 0x086f, 0x0b39, 0x0b58,
    0x0a06, 0x0812, 0x06ad, 0x0693, 0x0676, 0x041c, 0xff26, 0xfa1d,
    0xf752, 0xf747, 0xf9b2, 0xfe62, 0x045a, 0x0a3b, 0x0d7c, 0x0bcc,
    0x05f0, 0xfed5, 0xf7cf, 0xf17f, 0xeeb9, 0xf0b4, 0xf54c, 0xfa35,
    0xfe97, 0x01dd, 0x04aa, 0x07f6, 0x0a65, 0x0a15, 0x06ba, 0x01d5,
    0xfcf0, 0xf840, 0xf4ac, 0xf3d3, 0xf603, 0xf9d2, 0xfd43, 0x0055,
    0x03aa, 0x067d, 0x082f, 0x098f, 0x0bdb, 0x0e57, 0x0e34, 0x0a32,
    0x040e, 0xfd7f, 0xf7c1, 0xf518, 0xf73c, 0xfc3d, 0x00a0, 0x0377,
    0x051d, 0x0537, 0x052f, 0x06c6, 0x0832, 0x061e, 0x0073, 0xfa13,
    0xf441, 0xefbc, 0xedcb, 0xef10, 0xf2ae, 0xf7a0, 0xfd7c, 0x0293,
    0x065c, 0x0956, 0x0aa9, 0x09c5, 0x07e9, 0x071a, 0x07d1, 0x07d9,
    0x0541, 0x0103, 0xfc16, 0xf63c, 0xf118, 0xefe2, 0xf42a, 0xfc4e,
    0x05d4, 0x0ea5, 0x142e, 0x144d, 0x0dd5, 0x0241, 0xf5de, 0xedeb,
    0xec67, 0xefde, 0xf6a0, 0xfec9, 0x0636, 0x0ad6, 0x0c18, 0x0bca,
    0x0b2f, 0x08b2, 0x036b, 0xfc01, 0xf364, 0xec9c, 0xeaa1, 0xecbc,
    0xf290, 0xfcb5, 0x070a, 0x0c44, 0x0b50, 0x075c, 0x037f, 0x0156,
    0x0280, 0x06b5, 0x0b08, 0x0c77, 0x0a10, 0x0417, 0xfcb8, 0xf6db,
    0xf3e1, 0xf3b3, 0xf678, 0xfbec, 0x0270, 0x0810, 0x0b5d, 0x0bf0,
    0x09dc, 0x05dd, 0x015c, 0xfda9, 0xfb2c, 0xf9ad, 0xf8ab, 0xf807,
    0xf99a, 0xfeae, 0x0464, 0x0787, 0x0777, 0x03df, 0xfd58, 0xf69d,
    0xf254, 0xf12a, 0xf3bf, 0xfa3f, 0x0133, 0x04aa, 0x044d, 0x018c,
    0xfe26, 0xfce0, 0xffb6, 0x04b2, 0x08a9, 0x0aec, 0x0c57, 0x0c05,
    0x07f8, 0x016d, 0xfadc, 0xf654, 0xf4e1, 0xf729, 0xfcee, 0x02f0,
    0x0787, 0x0a7d, 0x0a36, 0x06a9, 0x02a0, 0xfefc, 0xfbac, 0xfa8c,
    0xfb67, 0xfbac, 0xfaa5, 0xfa2e, 0xfa8c, 0xfa2b, 0xf93b, 0xf9ca,
    0xfbae, 0xfd86, 0x0086, 0x05d5, 0x0c15, 0x102d, 0x10c0, 0x0df3,
    0x0782, 0xfefd, 0xf757, 0xf2dc, 0xf1f1, 0xf46c, 0xf979, 0xff5f,
    0x0545, 0x0a35, 0x0c5d, 0x0a54, 0x04d6, 0xfe80, 0xf9f9, 0xf745,
    0xf592, 0xf5d4, 0xf888, 0xfc68, 0x000a, 0x0326, 0x0507, 0x0516,
    0x0478, 0x0455, 0x0339, 0x002c, 0xfcc1, 0xf990, 0xf66e, 0xf45c,
    0xf4e9, 0xf835, 0xfce0, 0x0145, 0x0559, 0x0922, 0x0b7b, 0x0bd7,
    0x0b51, 0x0a7f, 0x08e5, 0x06a2, 0x03a5, 0x0080, 0xfdeb, 0xfc41,
    0xfbe5, 0xfd03, 0xff0f, 0xffc7, 0xfe0d, 0xfc06, 0xfb56, 0xfbe4,
    0xfd94, 0xff5e, 0xff5b, 0xfd00, 0xfa55, 0xf975, 0xfb14, 0xfdce,
    0xffa6, 0x0042, 0xffe6, 0xff8f, 0xff6f, 0x005c, 0x0428, 0x095e,
    0x0c3f, 0x0b7b, 0x086e, 0x03f5, 0xfdd7, 0xf703, 0xf1c8, 0xef19,
    0xef49, 0xf2fb, 0xfa2d, 0x03cb, 0x0db4, 0x1504, 0x178a, 0x14c5,
    0x0d20, 0x01bf, 0xf5d0, 0xedb4, 0xebfd, 0xf040, 0xf805, 0x00d8,
    0x0868, 0x0ca0, 0x0c64, 0x080b, 0x017d, 0xfb54, 0xf7c7, 0xf6d7,
    0xf769, 0xf932, 0xfca6, 0x00d9, 0x02c1, 0x01a5, 0x0108, 0x0258,
    0x02e1, 0x0157, 0xffaf, 0xffb3, 0x0158, 0x04ba, 0x094f, 0x0cce,
    0x0c80, 0x0715, 0xfe99, 0xf69a, 0xf10a, 0xee82, 0xef67, 0xf491,
    0xfd97, 0x07d4, 0x1014, 0x13ba, 0x11af, 0x0b69, 0x0442, 0xfe01,
    0xf948, 0xf6ea, 0xf705, 0xf89d, 0xfa67, 0xfc38, 0xfe38, 0xffed,
    0x0112, 0x0145, 0x0004, 0xfd8f, 0xfb57, 0xfa9d, 0xfb51, 0xfd56,
    0x0015, 0x01eb, 0x01c2, 0x0057, 0xfee1, 0xfe54, 0xfef4, 0x009a,
    0x02e4, 0x047c, 0x0559, 0x0655, 0x0709, 0x05c6, 0x0286, 0xfe98,
    0xfa60, 0xf82a, 0xf9f9, 0xff3b, 0x0664, 0x0ccf, 0x0f85, 0x0d0f,
    0x06b5, 0xfe83, 0xf661, 0xf12c, 0xf099, 0xf450, 0xfa55, 0xffec,
    0x033e, 0x0367, 0xffe4, 0xfa5c, 0xf616, 0xf4c0, 0xf6c0, 0xfbc0,
    0x02f0, 0x0a81, 0x1070, 0x1329, 0x11d3, 0x0d68, 0x0711, 0xffc8,
    0xf866, 0xf299, 0xf066, 0xf279, 0xf7db, 0xff42, 0x0769, 0x0e3e,
    0x10e2, 0x0e1c, 0x0745, 0xfda2, 0xf36d, 0xeb7b, 0xe84c, 0xeb58,
    0xf3a4, 0xfd98, 0x05f6, 0x0b79, 0x0d7e, 0x0bce, 0x07a8, 0x02eb,
    0xfedb, 0xfc2c, 0xfab6, 0xfa20, 0xf9ec, 0xfa59, 0xfbf5, 0xfeb8,
    0x0181, 0x035f, 0x051f, 0x0751, 0x0841, 0x0721, 0x05f3, 0x058f,
    0x0541, 0x04e3, 0x04db, 0x041f, 0x0199, 0xfe87, 0xfcaa, 0xfbe3,
    0xfb5d, 0xfab0, 0xfa42, 0xfab3, 0xfb79, 0xfc15, 0xfc80, 0xfcb3,
    0xfc68, 0xfc4d, 0xfd7a, 0xff6f, 0x0164, 0x0219, 0x0078, 0xfdd0,
    0xfc96, 0xfd9a, 0xff8f, 0x0377, 0x09d9, 0x0ed2, 0x0f20, 0x0c43,
    0x0845, 0x0361, 0xfcfc, 0xf5c6, 0xf0d0, 0xeec1, 0xeebd, 0xf14c,
    0xf77d, 0xffe1, 0x0899, 0x115e, 0x178c, 0x1759, 0x100d, 0x0398,
    0xf5c3, 0xeba6, 0xe9d2, 0xf00e, 0xf9e5, 0x0446, 0x0d06, 0x1040,
    0x0bea, 0x02aa, 0xf8b8, 0xf1be, 0xf02b, 0xf37a, 0xf8e3, 0xfe44,
    0x0345, 0x0604, 0x03b5, 0xfef7, 0xfdf9, 0x0085, 0x028d, 0x0438,
    0x06f1, 0x09fd, 0x0c5b, 0x0dac, 0x0c9a, 0x07ff, 0x00a1, 0xf890,
    0xf1bc, 0xee88, 0xf027, 0xf4fa, 0xfb1d, 0x01fa, 0x0896, 0x0cbf,
    0x0d78, 0x0b14, 0x06a7, 0x01dc, 0xfe54, 0xfc50, 0xfae2, 0xfa82,
    0xfbf5, 0xfda4, 0xfd78, 0xfcf4, 0xfe9b, 0x0146, 0x0269, 0x0170,
    0xff15, 0xfbc3, 0xf8ad, 0xf7cb, 0xf951, 0xfc6f, 0x00e1, 0x055c,
    0x06b9, 0x039f, 0xfdfb, 0xf9e0, 0xf9f0, 0xfd38, 0x0270, 0x0742,
    0x0a53, 0x0b3e, 0x095d, 0x04c8, 0xfe58, 0xf8d7, 0xf6bb, 0xf8c5,
    0xfcc4, 0x01a2, 0x06f6, 0x0a16, 0x09e0, 0x0722, 0x0393, 0x0027,
    0xfd8d, 0xfcfa, 0xfd86, 0xfdd4, 0xfd7f, 0xfc43, 0xf9f6, 0xf7e8,
    0xf708, 0xf727, 0xf8c9, 0xfbec, 0xff42, 0x0119, 0x01a2, 0x028e,
    0x04f6, 0x07cb, 0x0a9f, 0x0d6a, 0x0dbc, 0x09ee, 0x0302, 0xfb8c,
    0xf5e6, 0xf361, 0xf460, 0xf921, 0x014f, 0x099e, 0x0d37, 0x0a8c,
    0x035f, 0xfa00, 0xf176, 0xed15, 0xeeb6, 0xf542, 0xfd68, 0x0405,
    0x07c9, 0x08c2, 0x074f, 0x04c4, 0x0268, 0xffbd, 0xfc6f, 0xfaf3,
    0xfc21, 0xfd62, 0xfe07, 0xff7c, 0x01e8, 0x0302, 0x0207, 0x0082,
    0xff4e, 0xfecc, 0x002b, 0x04a1, 0x0b0a, 0x0f09, 0x0dc0, 0x0879,
    0x0207, 0xfce7, 0xfa22, 0xf9a9, 0xfab2, 0xfbc4, 0xfd28, 0xffc7,
    0x01ad, 0x018f, 0x000a, 0xfd8e, 0xfa10, 0xf715, 0xf645, 0xf7a2,
    0xfa9f, 0xfddb, 0x000b, 0x00aa, 0x0097, 0x0089, 0x010a, 0x031e,
    0x04b5, 0x03f3, 0x0276, 0x01fe, 0x034a, 0x070c, 0x0bd3, 0x0ef7,
    0x0dd7, 0x062b, 0xf8cc, 0xeaeb, 0xe36b, 0xe430, 0xec5e, 0xfaad,
    0x0b1d, 0x186a, 0x1da5, 0x181f, 0x09fa, 0xf9bb, 0xed04, 0xe64a,
    0xe742, 0xeff8, 0xfcf1, 0x09ff, 0x13c3, 0x17b4, 0x158f, 0x0eb8,
    0x04c6, 0xfa5d, 0xf2a9, 0xef41, 0xf0dc, 0xf5ed, 0xfaa3, 0xfe36,
    0x0137, 0x023b, 0x011e, 0x004c, 0x0121, 0x0369, 0x0654, 0x0889,
    0x09e9, 0x0ae1, 0x0a02, 0x0553, 0xfe4d, 0xf811, 0xf37f, 0xf091,
    0xf1c8, 0xf802, 0xff22, 0x04c7, 0x093d, 0x0b15, 0x09a7, 0x06c4,
    0x034a, 0xff62, 0xfc7d, 0xfc3f, 0xfda4, 0xfdd8, 0xfcf8, 0xfdc1,
    0x006a, 0x02f3, 0x041b, 0x0400, 0x0236, 0xfe83, 0xfb0c, 0xf9ff,
    0xfbe9, 0xffc3, 0x0449, 0x0655, 0x0251, 0xf9f8, 0xf1c9, 0xed55,
    0xef37, 0xf7fe, 0x03a0, 0x0c25, 0x0fc6, 0x0f6c, 0x0b94, 0x05d3,
    0x0051, 0xfc8f, 0xfb79, 0xfcb0, 0xff37, 0x025c, 0x05d0, 0x0924,
    0x0b73, 0x0b75, 0x07f1, 0x0227, 0xfc9d, 0xf7ef, 0xf480, 0xf2e9,
    0xf258, 0xf23b, 0xf41c, 0xf987, 0x00f1, 0x07fd, 0x0c62, 0x0c0f,
    0x07c5, 0x0206, 0xfd42, 0xfbcb, 0xfe4f, 0x0327, 0x0848, 0x0b81,
    0x0a82, 0x04bd, 0xfcc7, 0xf5ea, 0xf23b, 0xf280, 0xf5e0, 0xfb38,
    0x0117, 0x05c2, 0x08a2, 0x0939, 0x0695, 0x01e9, 0xfd16, 0xf908,
    0xf6cb, 0xf6ff, 0xf902, 0xfc14, 0xffe7, 0x03f5, 0x0785, 0x0916,
    0x07ba, 0x043f, 0xffb3, 0xfbeb, 0xfa0d, 0xf918, 0xf85f, 0xf8a9,
    0xfa09, 0xfc00, 0xffb4, 0x050e, 0x0a26, 0x0ce9, 0x0cc9, 0x0ac2,
    0x083e, 0x0688, 0x0508, 0x03bf, 0x02d4, 0x001a, 0xfb82, 0xf6b4,
    0xf2b5, 0xf11f, 0xf2db, 0xf778, 0xfdd9, 0x04c6, 0x0adb, 0x0e01,
    0x0c2d, 0x049d, 0xfa05, 0xf02b, 0xe9c6, 0xe9fc, 0xf22c, 0xffc9,
    0x0c77, 0x1330, 0x1401, 0x1051, 0x0989, 0x0270, 0xfc5f, 0xf87e,
    0xf7ab, 0xf83b, 0xf799, 0xf6ad, 0xf8af, 0xfcdc, 0x010d, 0x0525,
    0x0967, 0x0c01, 0x0b35, 0x0716, 0x015f, 0xfd09, 0xfb37, 0xfb18,
    0xfc4b, 0xfe97, 0x0102, 0x027c, 0x0258, 0x0098, 0xff14, 0xff23,
    0x001c, 0x00fa, 0x00b0, 0xff1f, 0xfc9b, 0xf9e0, 0xf7f1, 0xf854,
    0xfb9d, 0xff23, 0x0067, 0xffce, 0xfff6, 0x02c6, 0x064e, 0x07e1,
    0x0844, 0x0868, 0x0797, 0x0605, 0x04ff, 0x0378, 0xff5f, 0xfa0a,
    0xf501, 0xefcd, 0xeb3a, 0xea86, 0xeec4, 0xf7a3, 0x04ca, 0x1213,
    0x19ca, 0x1a23, 0x167b, 0x1069, 0x07c0, 0xfe03, 0xf66f, 0xf38e,
    0xf4b2, 0xf8fb, 0xff56, 0x04b3, 0x06bf, 0x0648, 0x0421, 0xfff0,
    0xfa12, 0xf4d9, 0xf20a, 0xf16c, 0xf266, 0xf3b3, 0xf556, 0xf8ad,
    0xfef4, 0x076c, 0x0f46, 0x14a5, 0x1646, 0x1387, 0x0c2f, 0x019b,
    0xf735, 0xf0f8, 0xf076, 0xf3ce, 0xf885, 0xfd72, 0x01ef, 0x05a4,
    0x085d, 0x0943, 0x081d, 0x056d, 0x0254, 0x0045, 0xffbe, 0xff5d,
    0xfe06, 0xfc0b, 0xf9fd, 0xf859, 0xf793, 0xf879, 0xfb44, 0xfeba,
    0x0174, 0x0284, 0x0335, 0x050b, 0x07b5, 0x0b14, 0x0df1, 0x0dcc,
    0x08d5, 0xffef, 0xf5dc, 0xedf1, 0xeb1e, 0xee09, 0xf5ef, 0x014d,
    0x0caa, 0x146e, 0x173b, 0x13c6, 0x0a65, 0xfe51, 0xf307, 0xeb45,
    0xe989, 0xee46, 0xf65b, 0xfe5f, 0x04ba, 0x08e9, 0x0a8b, 0x0936,
    0x04f7, 0xff4b, 0xfa08, 0xf68d, 0xf628, 0xf8bf, 0xfbfd, 0xff01
};



struct FdcAudio {
    SamplePlayer* samplePlayer;
    int motorOn;
    Int16* readSamples;
    Int32  readCount;
    Int16* motorSamples;
    Int32  motorCount;
};

static void loadSample(char* filename, Int16** samples, Int32* count, 
                       Int16* defSamples, Int32 defCount)
{
    FILE* f = fopen(filename, "rb"); // Try read 16 bit 44.1kHz mono sample
    if (f != NULL) {
        while (!feof(f)) {
            UInt32 data = 0;
            if (fread(&data, 4, 1, f) == 1) {
                if (data == 0x61746164) {
                    UInt32 size = 0;
                    if (fread(&size, 4, 1, f) == 1) {
                        if (size < 131072) {
                            *samples = malloc(size);
                            *count = fread(*samples, 2, size / 2, f);
                            if (*count == size / 2) {
                                fclose(f);
                                return;
                            }
                            free(*samples);
                        }
                    }
                }
            }
        }
        fclose(f);
    }

    *samples = malloc(defCount * sizeof(Int16));
    memcpy(*samples, defSamples, defCount * sizeof(Int16));
    *count = defCount;
}

FdcAudio* fdcAudioCreate(FdcAudioType type)
{
    FdcAudio* fdcAudio = malloc(sizeof(FdcAudio));

    fdcAudio->samplePlayer = samplePlayerCreate(boardGetMixer(), MIXER_CHANNEL_IO, 16, 44100);

    switch (type) {
    default:
    case FA_PANASONIC:
        loadSample("FdcRead.wav",  
                   &fdcAudio->readSamples,  &fdcAudio->readCount,  
                   PanasonicReadSamples, PanasonicReadCount);
        loadSample("FdcMotor.wav", 
                   &fdcAudio->motorSamples, &fdcAudio->motorCount, 
                   PanasonicMotorSamples, PanasonicMotorCount);
        break;
    case FA_WESTERN_DIGITAL:
        loadSample("FdcRead.wav",  
                   &fdcAudio->readSamples,  &fdcAudio->readCount,  
                   PanasonicReadSamples, PanasonicReadCount);
        loadSample("FdcMotor.wav", 
                   &fdcAudio->motorSamples, &fdcAudio->motorCount, 
                   PanasonicMotorSamples, PanasonicMotorCount);
        break;
    }

    fdcAudioReset(fdcAudio);

    return fdcAudio;
}

void fdcAudioDestroy(FdcAudio* fdcAudio)
{
    samplePlayerDestroy(fdcAudio->samplePlayer);
    free(fdcAudio->readSamples);
    free(fdcAudio->motorSamples);
    free(fdcAudio);
}

void fdcAudioReset(FdcAudio* fdcAudio)
{
    fdcAudio->motorOn = 0;
    samplePlayerReset(fdcAudio->samplePlayer);
}

void fdcAudioSetReadWrite(FdcAudio* fdcAudio)
{
    if (fdcAudio->motorOn) {
        samplePlayerDoSync(fdcAudio->samplePlayer);
        if (samplePlayerIsLooping(fdcAudio->samplePlayer)) {
            samplePlayerWrite(fdcAudio->samplePlayer, fdcAudio->readSamples, fdcAudio->readCount, fdcAudio->motorSamples, fdcAudio->motorCount);
        }
    }
}

void fdcAudioSetMotor(FdcAudio* fdcAudio, int motorOn)
{
    if (motorOn != fdcAudio->motorOn) {
        if (motorOn) {
            samplePlayerDoSync(fdcAudio->samplePlayer);
            if (samplePlayerIsIdle(fdcAudio->samplePlayer)) {
                samplePlayerWrite(fdcAudio->samplePlayer, NULL, 0, fdcAudio->motorSamples, fdcAudio->motorCount);
            }
        }
        else {
            samplePlayerStopAfter(fdcAudio->samplePlayer, 5);
        }
        fdcAudio->motorOn = motorOn;
    }
}

#endif