/**
 * @file
 * @brief Contains additional external requirements defs for external includes.
 * @note   DO NOT EDIT THIS FILE, your changes will be lost.
 *         Edit ir/be/ia32/ia32_spec.pl instead.
 *         created by: ir/be/scripts/generate_regalloc_if.pl ir/be/ia32/ia32_spec.pl ir/be/ia32
 * @date   Mon Nov 19 18:12:23 2012
 */
#ifndef FIRM_BE_IA32_GEN_IA32_REGALLOC_IF_H
#define FIRM_BE_IA32_GEN_IA32_REGALLOC_IF_H

#include "bearch.h"
#include "ia32_nodes_attr.h"

/** global register indices for ia32 registers */
enum reg_indices {
	REG_XMM0,
	REG_XMM1,
	REG_XMM2,
	REG_XMM3,
	REG_XMM4,
	REG_XMM5,
	REG_XMM6,
	REG_XMM7,
	REG_XMM_NOREG,
	REG_EFLAGS,
	REG_EDX,
	REG_ECX,
	REG_EAX,
	REG_EBX,
	REG_ESI,
	REG_EDI,
	REG_EBP,
	REG_ESP,
	REG_GP_NOREG,
	REG_ST0,
	REG_ST1,
	REG_ST2,
	REG_ST3,
	REG_ST4,
	REG_ST5,
	REG_ST6,
	REG_ST7,
	REG_FP_NOREG,
	REG_MM0,
	REG_MM1,
	REG_MM2,
	REG_MM3,
	REG_MM4,
	REG_MM5,
	REG_MM6,
	REG_MM7,
	REG_FPCW,

	N_IA32_REGISTERS
};
/** local register indices for ia32 registers */
enum {
	REG_XMM_XMM0 = 0,
	REG_XMM_XMM1 = 1,
	REG_XMM_XMM2 = 2,
	REG_XMM_XMM3 = 3,
	REG_XMM_XMM4 = 4,
	REG_XMM_XMM5 = 5,
	REG_XMM_XMM6 = 6,
	REG_XMM_XMM7 = 7,
	REG_XMM_XMM_NOREG = 8,
	REG_FLAGS_EFLAGS = 0,
	REG_GP_EDX = 0,
	REG_GP_ECX = 1,
	REG_GP_EAX = 2,
	REG_GP_EBX = 3,
	REG_GP_ESI = 4,
	REG_GP_EDI = 5,
	REG_GP_EBP = 6,
	REG_GP_ESP = 7,
	REG_GP_GP_NOREG = 8,
	REG_FP_ST0 = 0,
	REG_FP_ST1 = 1,
	REG_FP_ST2 = 2,
	REG_FP_ST3 = 3,
	REG_FP_ST4 = 4,
	REG_FP_ST5 = 5,
	REG_FP_ST6 = 6,
	REG_FP_ST7 = 7,
	REG_FP_FP_NOREG = 8,
	REG_MMX_MM0 = 0,
	REG_MMX_MM1 = 1,
	REG_MMX_MM2 = 2,
	REG_MMX_MM3 = 3,
	REG_MMX_MM4 = 4,
	REG_MMX_MM5 = 5,
	REG_MMX_MM6 = 6,
	REG_MMX_MM7 = 7,
	REG_FP_CW_FPCW = 0,

};

/** number of registers in ia32 register classes. */
enum {
	N_ia32_xmm_REGS = 9,
	N_ia32_flags_REGS = 1,
	N_ia32_gp_REGS = 9,
	N_ia32_fp_REGS = 9,
	N_ia32_mmx_REGS = 8,
	N_ia32_fp_cw_REGS = 1,

};
enum reg_classes {
	CLASS_ia32_xmm = 0,
	CLASS_ia32_flags = 1,
	CLASS_ia32_gp = 2,
	CLASS_ia32_fp = 3,
	CLASS_ia32_mmx = 4,
	CLASS_ia32_fp_cw = 5,
	N_IA32_CLASSES = 6
};



extern const arch_register_t ia32_registers[N_IA32_REGISTERS];

extern arch_register_class_t ia32_reg_classes[N_IA32_CLASSES];

void ia32_register_init(void);

#endif
