/**
 * @file
 * @brief     Generated functions to emit code for assembler ir nodes.
 * @note      DO NOT EDIT THIS FILE, your changes will be lost.
 *            Edit ir/be/TEMPLATE/TEMPLATE_spec.pl instead.
 *            created by: ir/be/scripts/generate_emitter.pl ir/be/TEMPLATE/TEMPLATE_spec.pl ir/be/TEMPLATE
 * @date      Mon Nov 19 18:12:23 2012
 */
#include "config.h"

#include <stdio.h>
#include <assert.h>

#include "irnode.h"
#include "irop_t.h"
#include "irprog_t.h"
#include "beemitter.h"

#include "gen_TEMPLATE_emitter.h"
#include "TEMPLATE_new_nodes.h"
#include "TEMPLATE_emitter.h"

static void emit_TEMPLATE_fConst(const ir_node *node)
{
	TEMPLATE_emitf(node, "fmov %I, %D1");
}

static void emit_TEMPLATE_Shr(const ir_node *node)
{
	TEMPLATE_emitf(node, "shr %S2, %D1");
}

static void emit_TEMPLATE_fMul(const ir_node *node)
{
	TEMPLATE_emitf(node, "fmul %S1, %S2, %D1");
}

static void emit_TEMPLATE_Or(const ir_node *node)
{
	TEMPLATE_emitf(node, "or %S1, %S2, %D1");
}

static void emit_TEMPLATE_Xor(const ir_node *node)
{
	TEMPLATE_emitf(node, "xor %S1, %S2, %D1");
}

static void emit_TEMPLATE_fAdd(const ir_node *node)
{
	TEMPLATE_emitf(node, "fadd %S1, %S2, %D1");
}

static void emit_TEMPLATE_Not(const ir_node *node)
{
	TEMPLATE_emitf(node, "not %S1, %D1");
}

static void emit_TEMPLATE_Shl(const ir_node *node)
{
	TEMPLATE_emitf(node, "shl %S1, %S2, %D1");
}

static void emit_TEMPLATE_fMinus(const ir_node *node)
{
	TEMPLATE_emitf(node, "fneg %S1, %D1");
}

static void emit_TEMPLATE_Add(const ir_node *node)
{
	TEMPLATE_emitf(node, "add %S1, %S2, %D1");
}

static void emit_TEMPLATE_Store(const ir_node *node)
{
	TEMPLATE_emitf(node, "movl %S2, (%S1)");
}

static void emit_TEMPLATE_And(const ir_node *node)
{
	TEMPLATE_emitf(node, "and %S1, %S2, %D1");
}

static void emit_TEMPLATE_fStore(const ir_node *node)
{
	TEMPLATE_emitf(node, "fmov %S2, (%S1)");
}

static void emit_TEMPLATE_fLoad(const ir_node *node)
{
	TEMPLATE_emitf(node, "fmov (%S1), %D1");
}

static void emit_TEMPLATE_fSub(const ir_node *node)
{
	TEMPLATE_emitf(node, "fsub %S1, %S2, %D1");
}

static void emit_TEMPLATE_Minus(const ir_node *node)
{
	TEMPLATE_emitf(node, "neg %S1, %D1");
}

static void emit_TEMPLATE_fDiv(const ir_node *node)
{
	TEMPLATE_emitf(node, "fdiv %S1, %S2, %D1");
}

static void emit_TEMPLATE_Const(const ir_node *node)
{
	TEMPLATE_emitf(node, "mov %I, %D1");
}

static void emit_TEMPLATE_Sub(const ir_node *node)
{
	TEMPLATE_emitf(node, "sub %S1, %S2, %D1");
}

static void emit_TEMPLATE_Load(const ir_node *node)
{
	TEMPLATE_emitf(node, "mov (%S1), %D1");
}

static void emit_TEMPLATE_Mul(const ir_node *node)
{
	TEMPLATE_emitf(node, "mul %S1, %S2, %D1");
}


typedef void (*emit_func)(const ir_node *node);

static void TEMPLATE_register_emitter(ir_op *op, emit_func func)
{
	assert(op->ops.generic == NULL);
	op->ops.generic = (op_func)func;
}

/**
 * Enters the emitter functions for handled nodes into the generic
 * pointer of an opcode.
 */
void TEMPLATE_register_spec_emitters(void)
{
  TEMPLATE_register_emitter(op_TEMPLATE_fConst, emit_TEMPLATE_fConst);
  TEMPLATE_register_emitter(op_TEMPLATE_Shr, emit_TEMPLATE_Shr);
  TEMPLATE_register_emitter(op_TEMPLATE_fMul, emit_TEMPLATE_fMul);
  TEMPLATE_register_emitter(op_TEMPLATE_Or, emit_TEMPLATE_Or);
  TEMPLATE_register_emitter(op_TEMPLATE_Xor, emit_TEMPLATE_Xor);
  TEMPLATE_register_emitter(op_TEMPLATE_fAdd, emit_TEMPLATE_fAdd);
  TEMPLATE_register_emitter(op_TEMPLATE_Not, emit_TEMPLATE_Not);
  TEMPLATE_register_emitter(op_TEMPLATE_Shl, emit_TEMPLATE_Shl);
  TEMPLATE_register_emitter(op_TEMPLATE_fMinus, emit_TEMPLATE_fMinus);
  TEMPLATE_register_emitter(op_TEMPLATE_Add, emit_TEMPLATE_Add);
  TEMPLATE_register_emitter(op_TEMPLATE_Store, emit_TEMPLATE_Store);
  TEMPLATE_register_emitter(op_TEMPLATE_And, emit_TEMPLATE_And);
  TEMPLATE_register_emitter(op_TEMPLATE_fStore, emit_TEMPLATE_fStore);
  TEMPLATE_register_emitter(op_TEMPLATE_fLoad, emit_TEMPLATE_fLoad);
  TEMPLATE_register_emitter(op_TEMPLATE_fSub, emit_TEMPLATE_fSub);
  TEMPLATE_register_emitter(op_TEMPLATE_Minus, emit_TEMPLATE_Minus);
  TEMPLATE_register_emitter(op_TEMPLATE_fDiv, emit_TEMPLATE_fDiv);
  TEMPLATE_register_emitter(op_TEMPLATE_Const, emit_TEMPLATE_Const);
  TEMPLATE_register_emitter(op_TEMPLATE_Sub, emit_TEMPLATE_Sub);
  TEMPLATE_register_emitter(op_TEMPLATE_Load, emit_TEMPLATE_Load);
  TEMPLATE_register_emitter(op_TEMPLATE_Mul, emit_TEMPLATE_Mul);
}

