// generated by js/modules/k6/html/gen/gen_elements.go;  DO NOT EDIT
package html

import "github.com/grafana/sobek"

func selToElement(sel Selection) sobek.Value {
	if sel.sel.Length() == 0 {
		return sobek.Undefined()
	}

	elem := Element{sel.sel.Nodes[0], &sel}

	switch elem.node.Data {
	case AnchorTagName:
		return sel.rt.ToValue(AnchorElement{HrefElement{elem}})
	case AreaTagName:
		return sel.rt.ToValue(AreaElement{HrefElement{elem}})
	case AudioTagName:
		return sel.rt.ToValue(AudioElement{MediaElement{elem}})
	case BaseTagName:
		return sel.rt.ToValue(BaseElement{elem})
	case ButtonTagName:
		return sel.rt.ToValue(ButtonElement{FormFieldElement{elem}})
	case CanvasTagName:
		return sel.rt.ToValue(CanvasElement{elem})
	case DataTagName:
		return sel.rt.ToValue(DataElement{elem})
	case DataListTagName:
		return sel.rt.ToValue(DataListElement{elem})
	case DelTagName:
		return sel.rt.ToValue(DelElement{ModElement{elem}})
	case EmbedTagName:
		return sel.rt.ToValue(EmbedElement{elem})
	case FieldSetTagName:
		return sel.rt.ToValue(FieldSetElement{elem})
	case FormTagName:
		return sel.rt.ToValue(FormElement{elem})
	case IFrameTagName:
		return sel.rt.ToValue(IFrameElement{elem})
	case ImageTagName:
		return sel.rt.ToValue(ImageElement{elem})
	case InputTagName:
		return sel.rt.ToValue(InputElement{FormFieldElement{elem}})
	case InsTagName:
		return sel.rt.ToValue(InsElement{ModElement{elem}})
	case KeygenTagName:
		return sel.rt.ToValue(KeygenElement{elem})
	case LabelTagName:
		return sel.rt.ToValue(LabelElement{elem})
	case LegendTagName:
		return sel.rt.ToValue(LegendElement{elem})
	case LiTagName:
		return sel.rt.ToValue(LiElement{elem})
	case LinkTagName:
		return sel.rt.ToValue(LinkElement{elem})
	case MapTagName:
		return sel.rt.ToValue(MapElement{elem})
	case MetaTagName:
		return sel.rt.ToValue(MetaElement{elem})
	case MeterTagName:
		return sel.rt.ToValue(MeterElement{elem})
	case OListTagName:
		return sel.rt.ToValue(OListElement{elem})
	case ObjectTagName:
		return sel.rt.ToValue(ObjectElement{elem})
	case OptGroupTagName:
		return sel.rt.ToValue(OptGroupElement{elem})
	case OptionTagName:
		return sel.rt.ToValue(OptionElement{elem})
	case OutputTagName:
		return sel.rt.ToValue(OutputElement{elem})
	case ParamTagName:
		return sel.rt.ToValue(ParamElement{elem})
	case PreTagName:
		return sel.rt.ToValue(PreElement{elem})
	case ProgressTagName:
		return sel.rt.ToValue(ProgressElement{elem})
	case QuoteTagName:
		return sel.rt.ToValue(QuoteElement{elem})
	case ScriptTagName:
		return sel.rt.ToValue(ScriptElement{elem})
	case SelectTagName:
		return sel.rt.ToValue(SelectElement{elem})
	case SourceTagName:
		return sel.rt.ToValue(SourceElement{elem})
	case StyleTagName:
		return sel.rt.ToValue(StyleElement{elem})
	case TableTagName:
		return sel.rt.ToValue(TableElement{elem})
	case TableBodyTagName:
		return sel.rt.ToValue(TableBodyElement{TableSectionElement{elem}})
	case TableColTagName:
		return sel.rt.ToValue(TableColElement{elem})
	case TableDataCellTagName:
		return sel.rt.ToValue(TableDataCellElement{TableCellElement{elem}})
	case TableFootTagName:
		return sel.rt.ToValue(TableFootElement{TableSectionElement{elem}})
	case TableHeadTagName:
		return sel.rt.ToValue(TableHeadElement{TableSectionElement{elem}})
	case TableHeaderCellTagName:
		return sel.rt.ToValue(TableHeaderCellElement{TableCellElement{elem}})
	case TableRowTagName:
		return sel.rt.ToValue(TableRowElement{elem})
	case TextAreaTagName:
		return sel.rt.ToValue(TextAreaElement{elem})
	case TimeTagName:
		return sel.rt.ToValue(TimeElement{elem})
	case TitleTagName:
		return sel.rt.ToValue(TitleElement{elem})
	case TrackTagName:
		return sel.rt.ToValue(TrackElement{elem})
	case UListTagName:
		return sel.rt.ToValue(UListElement{elem})
	case VideoTagName:
		return sel.rt.ToValue(VideoElement{MediaElement{elem}})
	default:
		return sel.rt.ToValue(elem)
	}
}

func (h HrefElement) Download() string {
	return h.attrAsString("download")
}

func (h HrefElement) ReferrerPolicy() string {
	attrVal := h.attrAsString("referrerpolicy")
	switch attrVal {
	case "no-referrer":
		return attrVal
	case "no-referrer-when-downgrade":
		return attrVal
	case "origin":
		return attrVal
	case "origin-when-cross-origin":
		return attrVal
	case "unsafe-url":
		return attrVal
	default:
		return ""
	}
}

func (h HrefElement) Rel() string {
	return h.attrAsString("rel")
}

func (h HrefElement) Href() string {
	return h.attrAsURLString("href", "")
}

func (h HrefElement) Target() string {
	return h.attrAsString("target")
}

func (h HrefElement) Type() string {
	return h.attrAsString("type")
}

func (h HrefElement) AccessKey() string {
	return h.attrAsString("accesskey")
}

func (h HrefElement) HrefLang() string {
	return h.attrAsString("hreflang")
}

func (h HrefElement) ToString() string {
	return h.attrAsURLString("href", "")
}

func (m MediaElement) Autoplay() bool {
	return m.attrIsPresent("autoplay")
}

func (m MediaElement) Controls() bool {
	return m.attrIsPresent("controls")
}

func (m MediaElement) Loop() bool {
	return m.attrIsPresent("loop")
}

func (m MediaElement) Muted() bool {
	return m.attrIsPresent("muted")
}

func (m MediaElement) Preload() string {
	attrVal := m.attrAsString("preload")
	switch attrVal {
	case "metadata":
		return attrVal
	case "none":
		return attrVal
	default:
		return "auto"
	}
}

func (m MediaElement) Src() string {
	return m.attrAsURLString("src", "")
}

func (m MediaElement) CrossOrigin() sobek.Value {
	attrVal, exists := m.sel.sel.Attr("crossorigin")
	if !exists {
		return sobek.Undefined()
	}
	switch attrVal {
	case "anonymous":
		return m.sel.rt.ToValue(attrVal)
	case "use-credentials":
		return m.sel.rt.ToValue(attrVal)
	default:
		return sobek.Undefined()
	}
}

func (m MediaElement) CurrentSrc() string {
	return m.attrAsString("src")
}

func (m MediaElement) DefaultMuted() bool {
	return m.attrIsPresent("muted")
}

func (m MediaElement) MediaGroup() string {
	return m.attrAsString("mediagroup")
}

func (b BaseElement) Href() string {
	return b.attrAsURLString("href", b.sel.URL)
}

func (b BaseElement) Target() string {
	return b.attrAsString("target")
}

func (b ButtonElement) AccessKey() string {
	return b.attrAsString("accesskey")
}

func (b ButtonElement) Autofocus() bool {
	return b.attrIsPresent("autofocus")
}

func (b ButtonElement) Disabled() bool {
	return b.attrIsPresent("disabled")
}

func (b ButtonElement) TabIndex() int {
	return b.attrAsInt("tabindex", 0)
}

func (b ButtonElement) Type() string {
	attrVal := b.attrAsString("type")
	switch attrVal {
	case "button":
		return attrVal
	case "menu":
		return attrVal
	case "reset":
		return attrVal
	default:
		return "submit"
	}
}

func (d DataElement) Value() string {
	return d.attrAsString("value")
}

func (e EmbedElement) Height() string {
	return e.attrAsString("height")
}

func (e EmbedElement) Width() string {
	return e.attrAsString("width")
}

func (e EmbedElement) Src() string {
	return e.attrAsString("src")
}

func (e EmbedElement) Type() string {
	return e.attrAsString("type")
}

func (f FieldSetElement) Disabled() bool {
	return f.attrIsPresent("disabled")
}

func (f FieldSetElement) Name() string {
	return f.attrAsString("name")
}

func (f FormElement) Action() string {
	return f.attrAsURLString("action", "")
}

func (f FormElement) Name() string {
	return f.attrAsString("name")
}

func (f FormElement) Target() string {
	return f.attrAsString("target")
}

func (f FormElement) Enctype() string {
	attrVal := f.attrAsString("enctype")
	switch attrVal {
	case "multipart/form-data":
		return attrVal
	case "text/plain":
		return attrVal
	default:
		return "application/x-www-form-urlencoded"
	}
}

func (f FormElement) Encoding() string {
	attrVal := f.attrAsString("enctype")
	switch attrVal {
	case "multipart/form-data":
		return attrVal
	case "text/plain":
		return attrVal
	default:
		return "application/x-www-form-urlencoded"
	}
}

func (f FormElement) AcceptCharset() string {
	return f.attrAsString("accept-charset")
}

func (f FormElement) Autocomplete() string {
	attrVal := f.attrAsString("autocomplete")
	switch attrVal {
	case "off":
		return attrVal
	default:
		return "on"
	}
}

func (f FormElement) NoValidate() bool {
	return f.attrIsPresent("novalidate")
}

func (i IFrameElement) Allowfullscreen() bool {
	return i.attrIsPresent("allowfullscreen")
}

func (i IFrameElement) ReferrerPolicy() string {
	attrVal := i.attrAsString("referrerpolicy")
	switch attrVal {
	case "no-referrer":
		return attrVal
	case "no-referrer-when-downgrade":
		return attrVal
	case "origin":
		return attrVal
	case "origin-when-cross-origin":
		return attrVal
	case "unsafe-url":
		return attrVal
	default:
		return ""
	}
}

func (i IFrameElement) Height() string {
	return i.attrAsString("height")
}

func (i IFrameElement) Width() string {
	return i.attrAsString("width")
}

func (i IFrameElement) Name() string {
	return i.attrAsString("name")
}

func (i IFrameElement) Src() string {
	return i.attrAsURLString("src", "")
}

func (i ImageElement) CurrentSrc() string {
	return i.attrAsURLString("src", "")
}

func (i ImageElement) Sizes() string {
	return i.attrAsString("sizes")
}

func (i ImageElement) Srcset() string {
	return i.attrAsString("srcset")
}

func (i ImageElement) Alt() string {
	return i.attrAsString("alt")
}

func (i ImageElement) CrossOrigin() sobek.Value {
	attrVal, exists := i.sel.sel.Attr("crossorigin")
	if !exists {
		return sobek.Undefined()
	}
	switch attrVal {
	case "anonymous":
		return i.sel.rt.ToValue(attrVal)
	case "use-credentials":
		return i.sel.rt.ToValue(attrVal)
	default:
		return sobek.Undefined()
	}
}

func (i ImageElement) Height() int {
	return i.attrAsInt("height", 0)
}

func (i ImageElement) Width() int {
	return i.attrAsInt("width", 0)
}

func (i ImageElement) IsMap() bool {
	return i.attrIsPresent("ismap")
}

func (i ImageElement) Name() string {
	return i.attrAsString("name")
}

func (i ImageElement) Src() string {
	return i.attrAsURLString("src", "")
}

func (i ImageElement) UseMap() string {
	return i.attrAsString("usemap")
}

func (i ImageElement) ReferrerPolicy() string {
	attrVal := i.attrAsString("referrerpolicy")
	switch attrVal {
	case "no-referrer":
		return attrVal
	case "no-referrer-when-downgrade":
		return attrVal
	case "origin":
		return attrVal
	case "origin-when-cross-origin":
		return attrVal
	case "unsafe-url":
		return attrVal
	default:
		return ""
	}
}

func (i InputElement) Name() string {
	return i.attrAsString("name")
}

func (i InputElement) TabIndex() int {
	return i.attrAsInt("tabindex", 0)
}

func (i InputElement) Type() string {
	attrVal := i.attrAsString("type")
	switch attrVal {
	case "button":
		return attrVal
	case "checkbox":
		return attrVal
	case "color":
		return attrVal
	case "date":
		return attrVal
	case "datetime-local":
		return attrVal
	case "email":
		return attrVal
	case "file":
		return attrVal
	case "hidden":
		return attrVal
	case "image":
		return attrVal
	case "month":
		return attrVal
	case "number":
		return attrVal
	case "password":
		return attrVal
	case "radio":
		return attrVal
	case "range":
		return attrVal
	case "reset":
		return attrVal
	case "search":
		return attrVal
	case "submit":
		return attrVal
	case "tel":
		return attrVal
	case "time":
		return attrVal
	case "url":
		return attrVal
	case "week":
		return attrVal
	default:
		return "text"
	}
}

func (i InputElement) Disabled() bool {
	return i.attrIsPresent("disabled")
}

func (i InputElement) Autofocus() bool {
	return i.attrIsPresent("autofocus")
}

func (i InputElement) Required() bool {
	return i.attrIsPresent("required")
}

func (i InputElement) Value() string {
	return i.attrAsString("value")
}

func (i InputElement) Checked() bool {
	return i.attrIsPresent("checked")
}

func (i InputElement) DefaultChecked() bool {
	return i.attrIsPresent("checked")
}

func (i InputElement) Alt() string {
	return i.attrAsString("alt")
}

func (i InputElement) Src() string {
	return i.attrAsURLString("src", "")
}

func (i InputElement) Height() string {
	return i.attrAsString("height")
}

func (i InputElement) Width() string {
	return i.attrAsString("width")
}

func (i InputElement) Accept() string {
	return i.attrAsString("accept")
}

func (i InputElement) Autocomplete() string {
	attrVal := i.attrAsString("autocomplete")
	switch attrVal {
	case "off":
		return attrVal
	default:
		return "on"
	}
}

func (i InputElement) MaxLength() int {
	return i.attrAsInt("maxlength", -1)
}

func (i InputElement) Size() int {
	return i.attrAsInt("size", 0)
}

func (i InputElement) Pattern() string {
	return i.attrAsString("pattern")
}

func (i InputElement) Placeholder() string {
	return i.attrAsString("placeholder")
}

func (i InputElement) Readonly() bool {
	return i.attrIsPresent("readonly")
}

func (i InputElement) Min() string {
	return i.attrAsString("min")
}

func (i InputElement) Max() string {
	return i.attrAsString("max")
}

func (i InputElement) DefaultValue() string {
	return i.attrAsString("value")
}

func (i InputElement) DirName() string {
	return i.attrAsString("dirname")
}

func (i InputElement) AccessKey() string {
	return i.attrAsString("accesskey")
}

func (i InputElement) Multiple() bool {
	return i.attrIsPresent("multiple")
}

func (i InputElement) Step() string {
	return i.attrAsString("step")
}

func (k KeygenElement) Autofocus() bool {
	return k.attrIsPresent("autofocus")
}

func (k KeygenElement) Challenge() string {
	return k.attrAsString("challenge")
}

func (k KeygenElement) Disabled() bool {
	return k.attrIsPresent("disabled")
}

func (k KeygenElement) Keytype() string {
	attrVal := k.attrAsString("keytype")
	switch attrVal {
	case "DSA":
		return attrVal
	case "EC":
		return attrVal
	default:
		return "RSA"
	}
}

func (k KeygenElement) Name() string {
	return k.attrAsString("name")
}

func (k KeygenElement) Type() string {
	return "keygen"
}

func (l LabelElement) HtmlFor() string {
	return l.attrAsString("for")
}

func (l LegendElement) AccessKey() string {
	return l.attrAsString("accesskey")
}

func (l LiElement) Value() int {
	return l.attrAsInt("value", 0)
}

func (l LiElement) Type() string {
	attrVal := l.attrAsString("type")
	switch attrVal {
	case "1":
		return attrVal
	case "a":
		return attrVal
	case "A":
		return attrVal
	case "i":
		return attrVal
	case "I":
		return attrVal
	case "disc":
		return attrVal
	case "square":
		return attrVal
	case "circle":
		return attrVal
	default:
		return ""
	}
}

func (l LinkElement) CrossOrigin() sobek.Value {
	attrVal, exists := l.sel.sel.Attr("crossorigin")
	if !exists {
		return sobek.Undefined()
	}
	switch attrVal {
	case "anonymous":
		return l.sel.rt.ToValue(attrVal)
	case "use-credentials":
		return l.sel.rt.ToValue(attrVal)
	default:
		return sobek.Undefined()
	}
}

func (l LinkElement) ReferrerPolicy() string {
	attrVal := l.attrAsString("referrerpolicy")
	switch attrVal {
	case "no-referrer":
		return attrVal
	case "no-referrer-when-downgrade":
		return attrVal
	case "origin":
		return attrVal
	case "origin-when-cross-origin":
		return attrVal
	case "unsafe-url":
		return attrVal
	default:
		return ""
	}
}

func (l LinkElement) Href() string {
	return l.attrAsURLString("href", "")
}

func (l LinkElement) Hreflang() string {
	return l.attrAsString("hreflang")
}

func (l LinkElement) Media() string {
	return l.attrAsString("media")
}

func (l LinkElement) Rel() string {
	return l.attrAsString("rel")
}

func (l LinkElement) Target() string {
	return l.attrAsString("target")
}

func (l LinkElement) Type() string {
	return l.attrAsString("type")
}

func (m MapElement) Name() string {
	return m.attrAsString("name")
}

func (m MetaElement) Content() string {
	return m.attrAsString("content")
}

func (m MetaElement) Name() string {
	return m.attrAsString("name")
}

func (m MetaElement) HttpEquiv() string {
	attrVal := m.attrAsString("http-equiv")
	switch attrVal {
	case "default-style":
		return attrVal
	case "refresh":
		return attrVal
	default:
		return "content-type"
	}
}

func (m MeterElement) Min() int {
	return m.attrAsInt("min", 0)
}

func (m MeterElement) Max() int {
	return m.attrAsInt("max", 0)
}

func (m MeterElement) High() int {
	return m.attrAsInt("high", 0)
}

func (m MeterElement) Low() int {
	return m.attrAsInt("low", 0)
}

func (m MeterElement) Optimum() int {
	return m.attrAsInt("optimum", 0)
}

func (m ModElement) Cite() string {
	return m.attrAsString("cite")
}

func (m ModElement) Datetime() string {
	return m.attrAsString("datetime")
}

func (o ObjectElement) Data() string {
	return o.attrAsURLString("data", "")
}

func (o ObjectElement) Height() string {
	return o.attrAsString("height")
}

func (o ObjectElement) Name() string {
	return o.attrAsString("name")
}

func (o ObjectElement) Type() string {
	return o.attrAsString("type")
}

func (o ObjectElement) TabIndex() int {
	return o.attrAsInt("tabindex", 0)
}

func (o ObjectElement) TypeMustMatch() bool {
	return o.attrIsPresent("typemustmatch")
}

func (o ObjectElement) UseMap() string {
	return o.attrAsString("usemap")
}

func (o ObjectElement) Width() string {
	return o.attrAsString("width")
}

func (o OListElement) Reversed() bool {
	return o.attrIsPresent("reversed")
}

func (o OListElement) Start() int {
	return o.attrAsInt("start", 0)
}

func (o OListElement) Type() string {
	attrVal := o.attrAsString("type")
	switch attrVal {
	case "a":
		return attrVal
	case "A":
		return attrVal
	case "i":
		return attrVal
	case "I":
		return attrVal
	default:
		return "1"
	}
}

func (o OptGroupElement) Disabled() bool {
	return o.attrIsPresent("disabled")
}

func (o OptGroupElement) Label() string {
	return o.attrAsString("label")
}

func (o OptionElement) DefaultSelected() bool {
	return o.attrIsPresent("selected")
}

func (o OptionElement) Selected() bool {
	return o.attrIsPresent("selected")
}

func (o OutputElement) HtmlFor() string {
	return o.attrAsString("for")
}

func (o OutputElement) Name() string {
	return o.attrAsString("name")
}

func (o OutputElement) Type() string {
	return "output"
}

func (p ParamElement) Name() string {
	return p.attrAsString("name")
}

func (p ParamElement) Value() string {
	return p.attrAsString("value")
}

func (p PreElement) Name() string {
	return p.attrAsString("name")
}

func (p PreElement) Value() string {
	return p.attrAsString("value")
}

func (q QuoteElement) Cite() string {
	return q.attrAsString("cite")
}

func (s ScriptElement) CrossOrigin() string {
	return s.attrAsString("crossorigin")
}

func (s ScriptElement) Type() string {
	return s.attrAsString("type")
}

func (s ScriptElement) Src() string {
	return s.attrAsURLString("src", "")
}

func (s ScriptElement) Charset() string {
	return s.attrAsString("charset")
}

func (s ScriptElement) Async() bool {
	return s.attrIsPresent("async")
}

func (s ScriptElement) Defer() bool {
	return s.attrIsPresent("defer")
}

func (s ScriptElement) NoModule() bool {
	return s.attrIsPresent("nomodule")
}

func (s SelectElement) Autofocus() bool {
	return s.attrIsPresent("autofocus")
}

func (s SelectElement) Disabled() bool {
	return s.attrIsPresent("disabled")
}

func (s SelectElement) Multiple() bool {
	return s.attrIsPresent("multiple")
}

func (s SelectElement) Name() string {
	return s.attrAsString("name")
}

func (s SelectElement) Required() bool {
	return s.attrIsPresent("required")
}

func (s SelectElement) TabIndex() int {
	return s.attrAsInt("tabindex", 0)
}

func (s SourceElement) KeySystem() string {
	return s.attrAsString("keysystem")
}

func (s SourceElement) Media() string {
	return s.attrAsString("media")
}

func (s SourceElement) Sizes() string {
	return s.attrAsString("sizes")
}

func (s SourceElement) Src() string {
	return s.attrAsURLString("src", "")
}

func (s SourceElement) Srcset() string {
	return s.attrAsString("srcset")
}

func (s SourceElement) Type() string {
	return s.attrAsString("type")
}

func (s StyleElement) Media() string {
	return s.attrAsString("media")
}

func (t TableElement) Sortable() bool {
	return t.attrIsPresent("sortable")
}

func (t TableCellElement) ColSpan() int {
	return t.attrAsInt("colspan", 1)
}

func (t TableCellElement) RowSpan() int {
	return t.attrAsInt("rowspan", 1)
}

func (t TableCellElement) Headers() string {
	return t.attrAsString("headers")
}

func (t TableHeaderCellElement) Abbr() string {
	return t.attrAsString("abbr")
}

func (t TableHeaderCellElement) Scope() string {
	attrVal := t.attrAsString("scope")
	switch attrVal {
	case "row":
		return attrVal
	case "col":
		return attrVal
	case "colgroup":
		return attrVal
	case "rowgroup":
		return attrVal
	default:
		return ""
	}
}

func (t TableHeaderCellElement) Sorted() bool {
	return t.attrIsPresent("sorted")
}

func (t TextAreaElement) Type() string {
	return "textarea"
}

func (t TextAreaElement) Value() string {
	return t.attrAsString("value")
}

func (t TextAreaElement) DefaultValue() string {
	return t.attrAsString("value")
}

func (t TextAreaElement) Placeholder() string {
	return t.attrAsString("placeholder")
}

func (t TextAreaElement) Rows() int {
	return t.attrAsInt("rows", 0)
}

func (t TextAreaElement) Cols() int {
	return t.attrAsInt("cols", 0)
}

func (t TextAreaElement) MaxLength() int {
	return t.attrAsInt("maxlength", 0)
}

func (t TextAreaElement) TabIndex() int {
	return t.attrAsInt("tabindex", 0)
}

func (t TextAreaElement) AccessKey() string {
	return t.attrAsString("accesskey")
}

func (t TextAreaElement) ReadOnly() bool {
	return t.attrIsPresent("readonly")
}

func (t TextAreaElement) Required() bool {
	return t.attrIsPresent("required")
}

func (t TextAreaElement) Autocomplete() string {
	attrVal := t.attrAsString("autocomplete")
	switch attrVal {
	case "off":
		return attrVal
	default:
		return "on"
	}
}

func (t TextAreaElement) Autocapitalize() string {
	attrVal := t.attrAsString("autocapitalize")
	switch attrVal {
	case "none":
		return attrVal
	case "off":
		return attrVal
	case "characters":
		return attrVal
	case "words":
		return attrVal
	default:
		return "sentences"
	}
}

func (t TextAreaElement) Wrap() string {
	attrVal := t.attrAsString("wrap")
	switch attrVal {
	case "hard":
		return attrVal
	case "off":
		return attrVal
	default:
		return "soft"
	}
}

func (t TimeElement) Datetime() string {
	return t.attrAsString("datetime")
}

func (t TrackElement) Kind() string {
	attrVal := t.attrAsString("kind")
	switch attrVal {
	case "captions":
		return attrVal
	case "descriptions":
		return attrVal
	case "chapters":
		return attrVal
	case "metadata":
		return attrVal
	default:
		return "subtitle"
	}
}

func (t TrackElement) Src() string {
	return t.attrAsURLString("src", "")
}

func (t TrackElement) Srclang() string {
	return t.attrAsString("srclang")
}

func (t TrackElement) Label() string {
	return t.attrAsString("label")
}

func (t TrackElement) Default() bool {
	return t.attrIsPresent("default")
}

func (u UListElement) Type() string {
	return u.attrAsString("type")
}
