// This file is generated by generate-std.joke script. Do not edit manually!

package bolt

import (
	"fmt"
	. "github.com/candid82/joker/core"
	"os"
)

func InternsOrThunks() {
	if VerbosityLevel > 0 {
		fmt.Fprintln(os.Stderr, "Lazily running slow version of bolt.InternsOrThunks().")
	}
	boltNamespace.ResetMeta(MakeMeta(nil, `Provide API for Bolt embedded database https://github.com/etcd-io/bbolt.

         Example:

         user=> (def db (joker.bolt/open "bolt.db" 0600))
         #'user/db
         user=> (joker.bolt/create-bucket db "users")
         nil
         user=> (def id (joker.bolt/next-sequence db "users"))
         #'user/id
         user=> id
         1
         user=> (joker.bolt/put db "users" (str id) (joker.json/write-string {:id id :name "Joe Black"}))
         nil
         user=> (joker.json/read-string (joker.bolt/get db "users" (str id)))
         {"id" 1, "name" "Joe Black"}`, "1.0"))

	boltNamespace.InternVar("by-prefix", by_prefix_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("db"), MakeSymbol("bucket"), MakeSymbol("prefix"))),
			`Retrives key/value pairs for all keys in bucket
  that start with prefix.
  Returns a vector of [key value] tuples. Passing empty prefix
  will return all key/values in bucket.`, "1.0"))

	boltNamespace.InternVar("close", close_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("db"))),
			`Releases all database resources.
  It will block waiting for any open transactions to finish
  before closing the database and returning.`, "1.0"))

	boltNamespace.InternVar("create-bucket", create_bucket_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("db"), MakeSymbol("name"))),
			`Creates a new bucket. Throws an error if the bucket already exists,
  if the bucket name is blank, or if the bucket name is too long.`, "1.0"))

	boltNamespace.InternVar("create-bucket-if-not-exists", create_bucket_if_not_exists_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("db"), MakeSymbol("name"))),
			`Creates a new bucket if it doesn't already exist.
   Throws an error if the bucket name is blank, or if the bucket name is too long.`, "1.0"))

	boltNamespace.InternVar("delete", delete_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("db"), MakeSymbol("bucket"), MakeSymbol("key"))),
			`Removes a key from the bucket if it exists.`, "1.0"))

	boltNamespace.InternVar("delete-bucket", delete_bucket_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("db"), MakeSymbol("name"))),
			`Deletes a bucket. Throws an error if the bucket doesn't exist.`, "1.0"))

	boltNamespace.InternVar("get", get_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("db"), MakeSymbol("bucket"), MakeSymbol("key"))),
			`Retrieves the value for a key in the bucket.
  Returns nil if the key does not exist.`, "1.0"))

	boltNamespace.InternVar("next-sequence", next_sequence_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("db"), MakeSymbol("bucket"))),
			`Returns an autoincrementing integer for the bucket.`, "1.0"))

	boltNamespace.InternVar("open", open_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("filename"), MakeSymbol("mode"))),
			`Creates and opens a database at the given path.
  If the file does not exist then it will be created automatically
  with mode perm (before umask).
  mode is normally passed as an octal literal, e.g. 0600`, "1.0").Plus(MakeKeyword("tag"), String{S: "BoltDB"}))

	boltNamespace.InternVar("put", put_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("db"), MakeSymbol("bucket"), MakeSymbol("key"), MakeSymbol("value"))),
			`Sets the value for a key in the bucket.
  If the key exist then its previous value will be overwritten.
  Throws an error if the key is blank, if the key is too large, or if the value is too large.`, "1.0"))

}
