/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"

#ifndef  TRUE
#define  TRUE  1
#define  FALSE 0
#endif

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
add_content_field_attr (c, name, value)
     content_field      *c;
     char               *name;
     char               *value;
{
  int                 i;

  if (!c)
    return;
  for (i = 0; i < NB_ATTR; i++) {
    if (c->attr[i].name || c->attr[i].value)
      continue;
    if (strlen (name) > 0)
      c->attr[i].name = strdup (name);
    if (strlen (value) > 0)
      c->attr[i].value = strdup (value);
    break;
  }
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
save_content_field (buf, head)
     content_field      *buf;
     content_field     **head;
{
  content_field      *new;

  if (!buf || !head)
    return;

  if ((new = (content_field *) malloc (sizeof (content_field))) == NULL) {
    return;
  }
  *new = *buf;

  if (*head != NULL) {
    content_field      *p = *head;

    while (p->next != NULL)
      p = p->next;
    p->next = new;
  } else
    *head = new;
  new->next = NULL;

  memset (buf, 0, sizeof (content_field));
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
free_content_field (p)
     content_field      *p;
{
  int                 i;

  if (!p)
    return;

  if (p->value)
    free (p->value);
  for (i = 0; i < NB_ATTR; i++) {
    if (p->attr[i].name)
      free (p->attr[i].name);
    if (p->attr[i].value)
      free (p->attr[i].value);
  }
  free (p);
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
free_content_field_rec (p)
     content_field      *p;
{
  int                 i;

  if (!p)
    return;

  if (p->value)
    free (p->value);
  for (i = 0; i < NB_ATTR; i++) {
    if (p->attr[i].name)
      free (p->attr[i].name);
    if (p->attr[i].value)
      free (p->attr[i].value);
  }
  memset (p, 0, sizeof (content_field));
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
free_content_field_list (head)
     content_field      *head;
{
  content_field      *p = head;

  while (head) {
    p = head->next;
    free_content_field (head);
    head = p;
  }
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */


/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */

void
free_attachment_list (head)
     attachment         *head;
{
  attachment         *p = head;

  while (head) {
    p = head->next;
    if (head->name)
      free (head->name);
    if (head->disposition)
      free (head->disposition);
    if (head->mimetype)
      free (head->mimetype);
    free (head);
    head = p;
  }
}


/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */

void
add_attachment (file, head)
     attachment         *file;
     attachment        **head;
{
  if (!file || !head)
    return;
  if (*head != NULL) {
    attachment         *p = *head;

    while (p->next != NULL)
      p = p->next;
    p->next = file;
  } else
    *head = file;
  file->next = NULL;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */

attachment         *
get_attachment (filename, head)
     char               *filename;
     attachment         *head;
{
  attachment         *p = head;

  if (!filename || !head)
    return NULL;
  while (p != NULL) {
    if (p->name != NULL && !strcasecmp (filename, p->name))
      return p;
    p = p->next;
  }
  return NULL;
}


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static int
is_attachment (mimetype, attr, value)
     char               *mimetype;
     char               *attr;
     char               *value;
{
  if (attr == NULL || value == NULL)
    return 0;

  if (!strcasecmp ("name", attr) && strlen (value) > 0)
    return 1;

  if (!strcasecmp ("filename", attr) && strlen (value) > 0)
    return 1;

  if (mimetype != NULL && !strcasecmp ("message/partial", mimetype)) {
    if (!strcasecmp ("id", attr))
      return 1;
  }

  if (mimetype != NULL && !strcasecmp ("message/external-body", mimetype)) {
    if (!strcasecmp ("name", attr))
      return 1;
  }

  return 0;
}


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
extract_attachments (chead, ahead)
     content_field      *chead;
     attachment        **ahead;
{
  int                 result;
  char                buf[1024];
  int                 nb = 0;
  int                 i;

  content_field      *p;

  /* Let's take a look at Content-Type tags */
  p = chead;
  while (p) {
    if (p->field_type == CT_TYPE) {
      for (i = 0; i < NB_ATTR; i++) {
        if (p->attr[i].name) {
#if 1
          if (is_attachment (p->value, p->attr[i].name, p->attr[i].value)) {
#else
          if (!strcasecmp ("name", p->attr[i].name) &&
              p->attr[i].value && strlen (p->attr[i].value) > 0) {
#endif
            attachment         *file;
            char                filename[2048];
            int                 len;

            file = (attachment *) malloc (sizeof (attachment));
            file->name = strdup (p->attr[i].value);
            file->mimetype = strdup (p->value);
            get_file_disposition (chead, p->attr[i].value, buf);
            file->disposition = strdup (buf);

            if (is_rfc1521_encoded (p->attr[i].value))
              decode_rfc1521 (filename, p->attr[i].value);
            else
              strcpy (filename, p->attr[i].value);

            /* Look if filename ends with a "." */
            len = strlen (filename);
            if (filename[len - 1] == '.')
              filename[len - 1] = '\0';

            result = !check_filename (filename);
            file->exefile = result ? 0 : 1;

            /* RFC 2046 */
#if RFC2046_MSGS_ARE_XFILES == 1
            if (file->mimetype &&
                ((strcasecmp (file->mimetype, "message/partial") == 0) ||
                 (strcasecmp (file->mimetype, "message/external-body") ==
                  0))) {
              file->exefile = 1;
            }
#endif
            add_attachment (file, ahead);
            nb++;
          }
        }
      }
    }
    p = p->next;
  }

  /* Now, it's time too look at Content-Disposition tags */
  p = chead;
  while (p) {
    if (p->field_type == CT_DISP) {
      for (i = 0; i < NB_ATTR; i++) {
        if (p->attr[i].name) {
          if (!strcasecmp ("filename", p->attr[i].name) &&
              p->attr[i].value && strlen (p->attr[i].value) > 0) {
            attachment         *file;
            char                filename[2048];
            int                 len;

            if ((file = get_attachment (p->attr[i].value, *ahead)) == NULL) {
              file = (attachment *) malloc (sizeof (attachment));
              file->name = strdup (p->attr[i].value);
              file->disposition = strdup (p->value);
              file->mimetype = NULL;

              if (is_rfc1521_encoded (p->attr[i].value))
                decode_rfc1521 (filename, p->attr[i].value);
              else
                strcpy (filename, p->attr[i].value);

              /* Look if filename ends with a "." */
              len = strlen (filename);
              if (filename[len - 1] == '.')
                filename[len - 1] = '\0';

              result = !check_filename (filename);
              file->exefile = result ? 0 : 1;

              add_attachment (file, ahead);
              nb++;
            }
          }
        }
      }
    }

    p = p->next;
  }

  /* Last but not least, uuencoded files */
  p = chead;
  while (p) {
    if (p->field_type == CT_UUFILE) {
      attachment         *file;
      int                 len;

      file = (attachment *) malloc (sizeof (attachment));
      file->name = strdup (p->value);
      file->mimetype = NULL;
      file->disposition = strdup ("uuencoded");;

      /* Look if filename ends with a "." */
      len = strlen (p->value);
      if (p->value[len - 1] == '.')
        p->value[len - 1] = '\0';

      result = !check_filename (p->value);
      file->exefile = result ? 0 : 1;

      add_attachment (file, ahead);
      nb++;
    }

    p = p->next;
  }

  return nb;
}



/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
get_file_disposition (head, name, value)
     content_field      *head;
     char               *name;
     char               *value;
{
  content_field      *p = head;
  int                 i;

  *value = '\0';
  if (!head)
    return 0;
  while (p) {
    if (p->field_type != CT_DISP) {
      p = p->next;
      continue;
    }
    if (!p->value) {
      p = p->next;
      continue;
    }
    for (i = 0; i < NB_ATTR; i++) {
      if (p->attr[i].name && !strcasecmp (p->attr[i].name, "filename") &&
          p->attr[i].value && !strcasecmp (p->attr[i].value, name)) {
        strcpy (value, p->value ? p->value : "");
        return 1;
      }
    }
    p = p->next;
  }
  return 0;
}
