/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"

#undef  DEBUG
#define DEBUG 0



/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
#define USER_LEN          256

typedef struct {
  char                user[USER_LEN];
} USER_REC;

static j_table      htbl;

static pthread_mutex_t st_mutex = PTHREAD_MUTEX_INITIALIZER;

static int          use_db = FALSE;

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
void
dump_local_users_table ()
{
  USER_REC            p;

  printf ("Let's dump j_user_table : \n");
  if (j_table_get_first (&htbl, &p) == 0) {
    do {
      printf ("-> USER : %-20s\n", p.user);
    } while (j_table_get_next (&htbl, &p) == 0);
  }
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
static int
user_comp (pa, pb)
     const void         *pa;
     const void         *pb;
{
  USER_REC           *a = (USER_REC *) pa;
  USER_REC           *b = (USER_REC *) pb;

  return strcasecmp (a->user, b->user);
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
static int
add_user_rec (k, v)
     char               *k;
     char               *v;
{
  USER_REC            r;

  memset (&r, 0, sizeof (r));
  if (k == NULL || strlen (k) == 0)
    return 0;
  if (v == NULL)
    v = "";

  strlcpy (r.user, k, sizeof (r.user));

  return j_table_add (&htbl, &r);
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
int
load_local_users_table (fname)
     char               *fname;
{
  int                 res = 0;
  static int          htbl_ok = FALSE;

  pthread_mutex_lock (&st_mutex);
  if (htbl_ok == FALSE) {
    memset (&htbl, 0, sizeof (htbl));
    res = j_table_init (&htbl, sizeof (USER_REC), 256, user_comp);
    if (res == 0)
      htbl_ok = TRUE;
  }
  if (res == 0)
    res = j_table_clear (&htbl);

  if (res == 0) {
    if (use_db) {
      void               *dbh;

      if ((dbh = j_db_open (fname)) != NULL) {
        res = j_db_walk (dbh, add_user_rec);
        j_db_close (dbh);
      } else
        res = -1;
    } else {
      res = j_rd_text_file (fname, RD_ONE_COLUMN, RD_NORMAL, add_user_rec);
    }
  }

  if (res == 0)
    res = j_table_sort (&htbl);
  pthread_mutex_unlock (&st_mutex);

#if 0
  dump_local_users_table ();
#endif

  return res;
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
int
check_local_user (user)
     char               *user;
{
  USER_REC            p;
  int                 res;

  if (user == NULL)
    return FALSE;

  memset (&p, 0, sizeof (p));
  strlcpy (p.user, user, sizeof (p.user));

  pthread_mutex_lock (&st_mutex);
  res = (j_table_fetch (&htbl, &p) != 0 ? FALSE : TRUE);
  pthread_mutex_unlock (&st_mutex);
  return res;
}
