/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"

#undef  DEBUG
#define DEBUG 0



/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/

typedef struct {
  char                from[USER_ACCESS_MSG_LEN];
  char                to[USER_ACCESS_MSG_LEN];
  char                value[USER_ACCESS_MSG_LEN];
} ACCESS_REC;

static j_table      htbl;

static pthread_mutex_t st_mutex = PTHREAD_MUTEX_INITIALIZER;

static int          use_db = FALSE;

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
void
dump_user_access_table ()
{
  ACCESS_REC          p;

  printf ("Let's dump j_acces_table : \n");
  if (j_table_get_first (&htbl, &p) == 0) {
    do {
      printf ("-> %-20s %-20s : %s\n", p.from, p.to, p.value);
    } while (j_table_get_next (&htbl, &p) == 0);
  }
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
static int
user_access_comp (pa, pb)
     const void         *pa;
     const void         *pb;
{
  ACCESS_REC         *a = (ACCESS_REC *) pa;
  ACCESS_REC         *b = (ACCESS_REC *) pb;

  return strcasecmp (a->from, b->from);
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
static int
add_user_access_rec (k, v)
     char               *k;
     char               *v;
{
  ACCESS_REC          r;

  char *ka = NULL, *kb = NULL;
  char *p;

  memset (&r, 0, sizeof (r));
  if (k == NULL)
    k = "";
  if (v == NULL)
    v = "";

  ka = k;
  if ((p = strchr(k, '/')) != NULL) {
    *p = '\0';
    p++;
    if (*p != '\0')
      kb = p;
  }

  p = ka;
  if (strncasecmp(p, "to:", strlen("to:")) == 0) {
    p += strlen("to:");
    strlcpy(r.to, p, sizeof(r.to));
  } else {
    if (strncasecmp(p, "from:", strlen("from:")) == 0) {
      p += strlen("from:");
      strlcpy(r.from, p, sizeof(r.from));
    }
  }

  p = kb;
  if (strncasecmp(p, "to:", strlen("to:")) == 0) {
    p += strlen("to:");
    strlcpy(r.to, p, sizeof(r.to));
  } else {
    if (strncasecmp(p, "from:", strlen("from:")) == 0) {
      p += strlen("from:");
    strlcpy(r.from, p, sizeof(r.from));
    }
  }

  if (strcasecmp(v, "OK") == 0 || strcasecmp(v, "REJECT") == 0)
    strlcpy (r.value, v, sizeof (r.value));
  else
    syslog(LOG_WARNING, "%s : Error at line : %s %s", J_FUNCTION, k, v);

  return j_table_add (&htbl, &r);
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
int
load_user_access_table (fname)
     char               *fname;
{
  int                 res = 0;
  static int          htbl_ok = FALSE;

  pthread_mutex_lock (&st_mutex);
  if (htbl_ok == FALSE) {
    memset (&htbl, 0, sizeof (htbl));
    res = j_table_init (&htbl, sizeof (ACCESS_REC), 256, user_access_comp);
    if (res == 0)
      htbl_ok = TRUE;
  }
  if (res == 0)
    res = j_table_clear (&htbl);

  if (res == 0) {
    if (use_db) {
      void               *dbh;

      if ((dbh = j_db_open (fname)) != NULL) {
        res = j_db_walk (dbh, add_user_access_rec);
        j_db_close (dbh);
      } else
        res = -1;
    } else {
      res = j_rd_text_file (fname, RD_TWO_COLUMN, RD_NORMAL, add_user_access_rec);
    }
  }

  if (res == 0)
    res = j_table_sort (&htbl);
  pthread_mutex_unlock (&st_mutex);

#if 0
  dump_user_access_table ();
#endif

  return res;
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
int
check_user_access (from, to, msg)
     char               *from;
     char               *to;
     char               *msg;
{
  ACCESS_REC          p;
  int                 res;

  if (from == NULL || to == NULL)
    return 0;

  memset (&p, 0, sizeof (p));
  strlcpy (p.from, from, sizeof (p.from));

  pthread_mutex_lock (&st_mutex);
  res = j_table_fetch (&htbl, &p);
  pthread_mutex_unlock (&st_mutex);

  if (res != 0)
    return USER_ACCESS_DEFAULT;

  if (strcasecmp (p.value, "OK") == 0)
    return USER_ACCESS_OK;

  if (strcasecmp (p.value, "REJECT") == 0)
    return USER_ACCESS_REJECT;

  if (msg != NULL)
    strcpy (msg, p.value);

  return USER_ACCESS_MSG;
}
