#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sysexits.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>

#include "libmilter/mfapi.h"

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
#define MLFIPRIV	((struct mlfiPriv *) smfi_getpriv(ctx))

sfsistat
mlfi_connect (ctx, hostname, hostaddr)
     SMFICTX            *ctx;
     char               *hostname;
     _SOCK_ADDR         *hostaddr;
{
  if (hostname == NULL)
    hostname = "HOST_UNKNOWN";

  smfi_setpriv (ctx, NULL);

  if (smfi_setreply (ctx, "553", "5.3.0", "COUCOU ...") == MI_FAILURE)
        printf ("smfi_setreply returned SMFI_FAILURE");

  printf ("IDENT = %s \n", hostname);
  return SMFIS_REJECT;
}

sfsistat
mlfi_hello (ctx)
     SMFICTX            *ctx;
{
  printf("smfi_hello -> OK !\n");
  return SMFIS_CONTINUE;
}


struct smfiDesc     smfilter = {
  "SampleFilter",               /* filter name */
  SMFI_VERSION,                 /* version code -- do not change */
  SMFIF_ADDHDRS,                /* flags */
  mlfi_connect,                 /* connection info filter */
  mlfi_hello,                   /* SMTP HELO command filter */
  NULL,                         /* envelope sender filter */
  NULL,                         /* envelope recipient filter */
  NULL,                         /* header filter */
  NULL,                         /* end of header */
  NULL,                         /* body block filter */
  NULL,                         /* end of message */
  NULL,                         /* message aborted */
  NULL                          /* connection cleanup */
};

int
main (argc, argv)
     int                 argc;
     char               *argv[];
{
  int                 res;

  (void) smfi_setconn ("local:/var/jchkmail/j-chkmail.sock");
  if (smfi_register (smfilter) == MI_FAILURE) {
    fprintf (stderr, "smfi_register failed\n");
    exit (EX_UNAVAILABLE);
  }

  res = smfi_main ();
  printf ("smfi_mail returned %d\n", res);
  return res;
}

/* eof */
