/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>
#include <j-table.h>

#include "j-chkmail.h"


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static int          j_table_resize (j_table *);

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_table_init (tbh, sz, dim, comp)
     j_table            *tbh;
     size_t              sz;
     int                 dim;
     int                 (*comp) (const void *, const void *);
{
  if (tbh == NULL)
    return -1;

  if ((tbh->data = malloc (sz * dim)) == NULL)
    return -1;
  tbh->sz = sz;
  tbh->dim = dim;
  tbh->chunk = dim;
  tbh->nb = 0;
  tbh->comp = comp;
  tbh->index = 0;

  return 0;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static int
j_table_resize (tbh)
     j_table            *tbh;
{
  int                 newsz;
  void               *ptr;

  if (tbh == NULL)
    return -1;

  newsz = tbh->sz * (tbh->dim + tbh->chunk);
  if (newsz == 0)
    return -2;

  if (tbh->data == NULL)
    ptr = malloc (newsz);
  else
    ptr = realloc (tbh->data, newsz);

  if (ptr != NULL) {
    tbh->dim += tbh->chunk;
    tbh->data = ptr;
  }

  return ptr != NULL ? 0 : -3;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_table_free (tbh)
     j_table            *tbh;
{
  if (tbh == NULL)
    return -1;

  if (tbh->data)
    free (tbh->data);
  tbh->data = NULL;
  tbh->sz = 0;
  tbh->dim = 0;
  tbh->nb = 0;
  tbh->comp = NULL;
  tbh->index = 0;

  return 0;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_table_clear (tbh)
     j_table            *tbh;
{
  if (tbh == NULL)
    return -1;

  if (tbh->data)
    memset (tbh->data, 0, tbh->sz * tbh->dim);
  tbh->nb = 0;
  tbh->index = 0;

  return 0;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_table_add (tbh, data)
     j_table            *tbh;
     void               *data;
{
  if (tbh == NULL)
    return -1;

  if (tbh->data == NULL)
    return -1;

  if ((tbh->nb >= tbh->dim) && (j_table_resize (tbh) < 0)) {
    return -1;
  }

  memcpy ((char *) tbh->data + tbh->nb * tbh->sz, data, tbh->sz);
  tbh->nb++;

  return 0;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_table_fetch (tbh, data)
     j_table            *tbh;
     void               *data;
{
  if (tbh == NULL)
    return -1;

  if (tbh->data == NULL)
    return -1;

  if (tbh->comp) {
    void               *ptr;

    if ((ptr =
         bsearch (data, tbh->data, tbh->nb, tbh->sz, tbh->comp)) != NULL) {
      memcpy (data, ptr, tbh->sz);
      return 0;
    }
  }
  return -1;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_table_count (tbh)
     j_table            *tbh;
{
  if (tbh == NULL)
    return -1;

  if (tbh->data == NULL)
    return -1;

  return tbh->nb;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_table_get_ind (tbh, data, ind)
     j_table            *tbh;
     void               *data;
     int                 ind;
{
  if (tbh == NULL)
    return -1;

  if (tbh->data == NULL)
    return -1;

  if (data == NULL)
    return -2;

  memcpy (data, (char *) tbh->data + ind * tbh->sz, tbh->sz);

  return 0;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_table_get_first (tbh, data)
     j_table            *tbh;
     void               *data;
{
  if (tbh == NULL)
    return -1;

  if (tbh->data == NULL)
    return -1;

  if (data == NULL)
    return -2;

  if (tbh->nb == 0)
    return 1;

  tbh->index = 0;
  memcpy (data, (char *) tbh->data + tbh->index * tbh->sz, tbh->sz);

  return 0;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_table_get_next (tbh, data)
     j_table            *tbh;
     void               *data;
{
  if (tbh == NULL)
    return -1;

  if (tbh->data == NULL)
    return -1;

  if (data == NULL)
    return -2;

  if (tbh->index < tbh->nb - 1)
    tbh->index++;
  else
    return 1;

  memcpy (data, (char *) tbh->data + tbh->index * tbh->sz, tbh->sz);

  return 0;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
void *
j_table_get_first_ptr (tbh)
     j_table            *tbh;
{
  if (tbh == NULL)
    return NULL;

  if (tbh->data == NULL)
    return NULL;

  if (tbh->nb == 0)
    return NULL;

  tbh->index = 0;

  return (char *) tbh->data + tbh->index * tbh->sz;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
void *
j_table_get_next_ptr (tbh)
     j_table            *tbh;
{
  if (tbh == NULL)
    return NULL;

  if (tbh->data == NULL)
    return NULL;

  if (tbh->index < tbh->nb - 1)
    tbh->index++;
  else
    return NULL;

  return (char *) tbh->data + tbh->index * tbh->sz;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_table_sort (tbh)
     j_table            *tbh;
{
  if (tbh == NULL)
    return -1;

  if (tbh->data == NULL)
    return -1;

  if (tbh->comp != NULL)
    qsort (tbh->data, tbh->nb, tbh->sz, tbh->comp);

  return 0;
}
