/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __J_SYS_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if HAVE_PTHREAD_H
#define _POSIX_PTHREAD_SEMANTICS    1
#endif

#include <stdio.h>
#include <stdlib.h>

#if STDC_HEADERS
# include <string.h>
#else
# if HAVE_STRING_H
#  include <string.h>
# endif
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char           *strchr (), *strrchr ();

# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif
#include <sysexits.h>

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#if HAVE_LIMITS_H
#include <limits.h>
#else
#if HAVE_VALUES_H
#include <values.h>
#else
Error - dont have limits.h nor values.h
#endif
#endif

#if HAVE_STDARG_H
#include <stdarg.h>
#endif

#if HAVE_MATH_H
#include <math.h>
#endif

#include <errno.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

#if HAVE_SIGNAL_H
#include <signal.h>
#endif

#if HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#ifndef WEXITSTATUS
# define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif

#ifndef WIFEXITED
# define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

#if HAVE_FCNTL_H
#include <fcntl.h>
#endif

#if HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#if HAVE_DIRENT_H
#include <dirent.h>
#endif

#if HAVE_REGEX_H
#include <regex.h>
#endif

#if HAVE_CTYPE_H
#include <ctype.h>
#endif

#if HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#if HAVE_POLL_H
#include <poll.h>
#endif

#if HAVE_SYS_POLL_H
#include <sys/poll.h>
#endif

#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#if HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif

#if HAVE_NETDB_H
#include <netdb.h>
#endif

#if HAVE_SYSLOG_H
#include <syslog.h>
#endif

#if HAVE_THREAD_H
#include <thread.h>
#endif

#if HAVE_PTHREAD_H
#include <pthread.h>
#endif

#if HAVE_PWD_H
#include <pwd.h>
#endif

#if HAVE_GRP_H
#include <grp.h>
#endif

#ifdef HAVE_KSTAT_H
#include <kstat.h>
#endif

#ifdef HAVE_SYS_LOADAVG_H
#include <sys/loadavg.h>
#endif

#ifdef  __GNUC__
#define J_FUNCTION         __FUNCTION__
#define J_PRETTY_FUNCTION  __PRETTY_FUNCTION__
#else              /* !__GNUC__ */
#define J_FUNCTION         __FILE__
#define J_PRETTY_FUNCTION  __FILE__
#endif             /* !__GNUC__ */
/* #undef HAVE_IN_ADDR6_T */
/* #undef HAVE_IN_ADDR_T */

#if !defined(HAVE_INT16_T)
typedef short   int16_t;
#endif

#if !defined(HAVE_UINT16_T)
typedef unsigned short uint16_t;
#endif

#if !defined(HAVE_INT32_T)
typedef long    uint32_t;
#endif

#if !defined(HAVE_UINT32_T)
typedef unsigned long uint32_t;
#endif

#if !defined(HAVE_OFF_T)
typedef unsigned long off_t;
#endif

#if !defined(HAVE_MODE_T)
typedef unsigned int mode_t;
#endif

#if !defined(HAVE_SSIZE_T)
typedef long    ssize_t;
#endif

#if !defined(HAVE_SOCKET_T)
typedef int socket_t;
#endif

#if 1 && !defined(HAVE_SOCKLEN_T)
#if HAVE_SIZE_T
typedef size_t socklen_t;
#else
typedef int socklen_t;
#endif
#endif

#if !defined (HAVE_BOOL)
typedef int     bool;
#endif

#ifndef true
# define true   1
# define false  0
#endif

#ifndef TRUE
# define TRUE 	1
# define FALSE	0
#endif

#define __J_SYS_H__

#endif
