/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"


#define MAX_FILES  256




/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void                usage ();

#define RES_OK         0
#define RES_SCAN_ERROR 1
#define RES_XFILE      2
#define RES_ERROR      3

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */


int
main (int argc, char **argv)
{
  char                chunk[0x10001];
  char                old[10000];

  char               *fname = "VIRUS_SIRCAM";
  FILE               *fin;

  int                 state = 0;
  int                 nb;

  const char         *args = "hvc:";
  int                 c;

  int                 io;

  int                 main_result = RES_OK;

  content_field       content;
  content_field      *list, *p;

  memset (&content, 0, sizeof (content));
  list = NULL;
  openlog ("j-scanfile", LOG_PID | LOG_NOWAIT | LOG_NDELAY, LOG_LOCAL5);
  if (argc > 1)
    fname = argv[1];

  j_output = J_STDOUT;

  opt = (OPT_REC *) malloc (sizeof (OPT_REC));
  memset (opt, 0, sizeof (OPT_REC));

  init_default_file_extensions ();

  opt->arg_v = 0;

  while ((c = getopt (argc, argv, args)) != -1) {
    switch (c) {
      case 'h':                /* OK */
        opt->arg_h = TRUE;
        usage ();
        exit (RES_OK);
        break;
      case 'v':
        opt->arg_v++;
        break;

        /*  */
      case 'c':
        if (optarg == NULL || *optarg == '\0') {
          (void) fprintf (stderr, "Erreur %s\n", optarg);
          exit (RES_ERROR);
        }
        if (opt->arg_c != NULL) {
          j_print_msg (j_output, LOG_ERR, "Only one c option, please");
          exit (RES_ERROR);
        }
        if ((opt->arg_c = strdup (optarg)) == NULL) {
          j_print_msg_sys (j_output, LOG_ERR,
                           "FATAL ERROR - memory allocation opt->arg_c");
          exit (RES_ERROR);
        }
        conf_file = opt->arg_c;
        break;
    }
  }


  io = optind;

  while (io < argc && *argv[io] == '-')
    io++;

  configure (conf_file, 1);

  while (io < argc) {
    fname = argv[io++];

    fin = fopen (fname, "r");

    if (!fin) {
      sprintf (old, "Error opening file %s !", fname);
      perror (old);
      exit (RES_ERROR);
    }

    memset (chunk, 0, sizeof (chunk));
    memset (old, 0, sizeof (old));
    while ((nb = fread (chunk, 1, sizeof (chunk) - 1, fin)) > 0) {
      int                 res;

      res = scan_block (0x12345678, old, sizeof (old) - 1, chunk, nb, &state,
                        &content, &list);

      if (res != 0) {
        printf (" scan_block res = %d\n", res);
        exit (RES_SCAN_ERROR);
      }
    }

    fclose (fin);
    printf ("*** FILE %s scanned\n\n", fname);

    if (opt->arg_v > 1) {
      p = list;

      while (p) {
        int                 i;
        char               *label[] =
          { "", "Content-Type", "Content-Disposition", "" };

        printf ("*** FIELD     : %s\n", label[p->field_type]);
        printf ("    VALEUR    : %s\n", p->value ? p->value : "");
        for (i = 0; i < NB_ATTR; i++) {
          if (p->attr[i].name) {
            printf ("    ATTR[%2d]  : %s\n", i, p->attr[i].name);
            if (p->attr[i].value)
              printf ("    DATA[%2d]  : %s\n", i, p->attr[i].value);
          }
        }
        p = p->next;
      }

      printf ("\n");
    }

    {
      int                 i = 0, nb = 0;
      attachment         *ahead = NULL, *p;

      extract_attachments (list, &ahead);
      p = ahead;
      while (p) {
        char               *svirus;

        nb++;
        switch (p->exefile) {
          case 0:
            svirus = "";
            break;
          case 1:
            svirus = "XFILE";
            i++;
            break;
          default:
            svirus = "UNCHECKED";
        }
        if (opt->arg_v > 0 || p->exefile == 1) {
          printf (" ***** (%-10s) : %-10s %-30s %-15s\n",
                  svirus,
                  p->disposition ? p->disposition : "",
                  p->mimetype ? p->mimetype : "", p->name);
        }
        p = p->next;

      }
      if (i > 0)
        main_result = RES_XFILE;
      if (opt->arg_v > 1)
        printf ("\n %4d FILES - %4d XFILES\n", nb, i++);
    }
    free_content_field_list (list);
    list = NULL;
  }



  return main_result;
}


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
void
usage ()
{
  printf ("Usage : j-scanfile [-h] [-c] [-v] file file file...\n");
  printf ("  %s\n", PACKAGE);
  printf ("  Compiled on %s %s\n", __DATE__, __TIME__);
  printf ("        -h : help\n");
  printf ("        -c : configuration file\n");
  printf ("        -v : verbose\n");
  printf ("\n%s - Copyright Ecole des Mines de Paris - (C) 2002\n\n",
          PACKAGE);
}
