/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
#define        SZ_WORK      0x2000




#define EXPR_CT  "Content-type[ \t]*:"
#define EXPR_CD  "Content-disposition[ \t]*:"
#define EXPR_UU  "begin(-base64){0,1}[ \t]{1,}[0]{0,1}[0-7]{3,3}[ \t]{1,}[^ \t\r\n]{1,}"

#define   REGCOMP_FLAGS  REG_ICASE | REG_NEWLINE | REG_EXTENDED

#if !defined(CRLF)
#define CRLF      "\r\n"
#endif

#define   TAG_NONE     0
#define   TAG_CTYPE    1
#define   TAG_CDESC    2
#define   TAG_UUTYPE   3

#define   STATE_IDLE      0
#define   STATE_TAG       1
#define   STATE_VALUE     2
#define   STATE_SEPARATOR 3
#define   STATE_PARAMETER 4

/*****************************************************************************
 *                                                                           *
 *                                                                           *
 *****************************************************************************/
typedef struct mime_parameter mime_parameter;

struct mime_parameter {
  char               *attr;
  char               *value;
  mime_parameter     *next;
};

typedef struct {
  int                 tag_type;
  char                value[256];
  mime_parameter     *head;
} mime_header;

mime_header        *
mime_header_init (p)
     mime_header        *p;
{
  if (p != NULL)
    memset (p, 0, sizeof (*p));

  return p;
}

int
mime_header_set_type (p, t)
     mime_header        *p;
     int                 t;
{
  return 0;
}

int
mime_header_set_value (p, v)
     mime_header        *p;
     char               *v;
{
  return 0;
}

int
mime_header_add_parameter (p, attr, value)
     mime_header        *p;
     char               *attr;
     char               *value;
{
  return 0;
}

void
mime_header_free (p)
     mime_header        *p;
{
}


/*****************************************************************************
 *                                                                           *
 *                                                                           *
 *****************************************************************************/
static int          scan_line (char *, int *, mime_header *);

int                 scan_chunk (unsigned long, scanbuf_rec *, scanbuf_rec *,
                                int *, mime_header *);

static int          split_parameter_tag (char *, char *, char *);

/*****************************************************************************
 *                                                                           *
 *                                                                           *
 *****************************************************************************/
int
scan_chunk (id, old, new, state, mime)
     unsigned long       id;
     scanbuf_rec        *old;
     scanbuf_rec        *new;
     int                *state;
     mime_header        *mime;
{
  char               *p, *q;

  char                work[SZ_WORK];
  int                 i;

  long                szold, sznew, nbc;

  if (old == NULL || new == NULL)
    return 0;

  if (old->buffer == NULL || new->buffer == NULL)
    return 0;

  szold = old->len;
  sznew = new->len;

  memset (work, 0, sizeof (work));

  /* strip out bad chars from old and new buffers */
  for (i = szold, p = old->buffer; i > 0; i--, p++) {
    if (*p == '\0')
      *p = ' ';
  }
  for (i = sznew, p = new->buffer; i > 0; i--, p++) {
    if (*p == '\0')
      *p = ' ';
  }

  /* Let's work on old saved buffer first */
  p = old->buffer;
  q = work;
  while ((nbc = buf_get_line (q, old->size, p, szold)) < szold) {
    p += nbc;
    szold -= nbc;

    /* do the job ... */
    scan_line (work, state, mime);

    q = work;
  }
  q += nbc;

  /* Now let's concatenate new fresh buffer and work on it */
  p = new->buffer;
  while ((nbc = buf_get_line (q, old->size, p, sznew)) < sznew) {
    p += nbc;
    sznew -= nbc;

    /* do the job ... */
    scan_line (work, state, mime);

    q = work;
  }

  /* Let's save remaining buffer to work on next time */
  if (sznew < old->size) {
    memcpy (old->buffer, p, sznew);
    old->buffer[sznew] = '\0';
    old->len = strlen (old->buffer);
  } else {
    printf ("%s sznew (%ld)> old->size (%ld)", J_FUNCTION, sznew, old->size);
  }

  return 0;
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
static int
scan_line (line, state, mime)
     char               *line;
     int                *state;
     mime_header        *mime;
{
  static int          regex_ok = FALSE;
  static regex_t      re_ct, re_cd, re_uu;
  regmatch_t          rm;
  char               *lptr;

  /* Let's initialise regex_t if not already done */
  if (regex_ok == FALSE) {
    int                 err;
    char                errbuf[256];

    regex_ok = TRUE;

    printf ("Compile...\n");
    if ((err = regcomp (&re_ct, EXPR_CT, REGCOMP_FLAGS)) != 0) {
      regerror (err, &re_ct, errbuf, 256);
      printf ("%s : Error regcomp : %s\n", J_FUNCTION, errbuf);
      regex_ok = FALSE;
    }
    if ((err = regcomp (&re_cd, EXPR_CD, REGCOMP_FLAGS)) != 0) {
      regerror (err, &re_cd, errbuf, 256);
      printf ("%s : Error regcomp : %s\n", J_FUNCTION, errbuf);
      regex_ok = FALSE;
    }
    if ((err = regcomp (&re_uu, EXPR_UU, REGCOMP_FLAGS)) != 0) {
      regerror (err, &re_uu, errbuf, 256);
      printf ("%s : Error regcomp : %s\n", J_FUNCTION, errbuf);
      regex_ok = FALSE;
    }

    if (regex_ok == FALSE) {
      regfree (&re_ct);
      regfree (&re_cd);
      regfree (&re_uu);
    }
  }


  /* Let's work on the line... */
  lptr = line;
  lptr += strspn (lptr, " \t");

  if (*state == STATE_SEPARATOR) {
    if (*lptr == ';') {
      *state = STATE_PARAMETER;
      lptr++;
    } else
      *state = STATE_IDLE;
  }

  if (strlen (lptr) == 0) {
    /* printf(" -> Empty line... \n"); */

    if (*state != STATE_IDLE) {
      /* save curent state and already detected mime data */
    }
    *state = STATE_IDLE;
    return 0;
  }

  if (*state == STATE_IDLE) {
    if (!regexec (&re_ct, lptr, 1, &rm, REG_NOTBOL | REG_NOTEOL)) {
      printf ("-> CT : %3ld %3ld : %s\n", (long ) rm.rm_so, (long ) rm.rm_eo, lptr);
      mime_header_set_type (mime, TAG_CTYPE);
      lptr += rm.rm_eo;
      *state = STATE_VALUE;
    }

    if (!regexec (&re_cd, lptr, 1, &rm, REG_NOTBOL | REG_NOTEOL)) {
      printf ("-> CD : %3ld %3ld : %s\n", (long ) rm.rm_so, (long ) rm.rm_eo, lptr);
      mime_header_set_type (mime, TAG_CDESC);
      lptr += rm.rm_eo;
      *state = STATE_VALUE;
    }

    if (!regexec (&re_uu, lptr, 1, &rm, REG_NOTBOL | REG_NOTEOL)) {
      printf ("-> UU : %3ld %3ld : %s\n", (long ) rm.rm_so, (long ) rm.rm_eo, lptr);
      mime_header_set_type (mime, TAG_UUTYPE);
    }
  }

  if (*state != STATE_IDLE) {
    lptr += strspn (lptr, " \t");
  }

  if (*state == STATE_VALUE) {
    int                 len;

    lptr += strspn (lptr, " \t");
    if (strlen (lptr) == 0)
      return 0;

    if ((len = strcspn (lptr, "; \t")) > 0) {
      char                s[256];

      memset (s, 0, sizeof (s));
      strncpy (s, lptr, len);
      printf ("    VALUE : %s\n", s);
    }
    lptr += len;

    *state = STATE_SEPARATOR;
  }

  while (*state == STATE_SEPARATOR || *state == STATE_PARAMETER) {
    lptr += strspn (lptr, " \t");
    if (strlen (lptr) == 0)
      break;

    if (*state == STATE_SEPARATOR) {
      if (*lptr == ';') {
        *state = STATE_PARAMETER;
        lptr++;
        continue;
      }
      *state = STATE_IDLE;
      continue;
    }
    if (*state == STATE_PARAMETER) {
      char                s[256];
      char                pa[256], pb[256];

      int                 len;

      memset (s, 0, sizeof (s));
      /* ici, c'est faux */
      len = strcspn (lptr, " \t");
      strncpy (s, lptr, len);
      printf ("    PARAM : %s\n", s);

      if ((len = split_parameter_tag (lptr, pa, pb)) > 0) {
	if (pa[strlen(pa) - 1] == '*')
	  pa[strlen(pa) - 1] = '\0';
	if (is_rfc2231_encoded (pb)) {
	  char                sout[1024];
	  printf ("    RFC 2231\n");
	  decode_rfc2231 (sout, pb);
	  strcpy (pb, sout);
	}
	if (is_rfc2047_encoded (pb)) {
	  char                sout[1024];
	  printf ("    RFC 2047\n");
	  decode_rfc2047 (sout, pb);
	  strcpy (pb, sout);
	}
 
  printf ("    - A : %s\n", pa);
  printf ("    - B : %s\n", pb);
	lptr += len;
	*state = STATE_SEPARATOR;
	continue;
      }
      if (len == 0) {
        *state = STATE_IDLE;
      }
      if (len == -1) {
        *state = STATE_IDLE;
      }
      if (len == -2) {
        *state = STATE_IDLE;
      }
    }
    
  }
#if 0
  *state = STATE_IDLE;
#endif

#if 0
  printf ("LINE : %s\n", line);
#endif
  return 0;
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
static int
split_parameter_tag (in, pa, pb)
     char               *in;
     char               *pa;
     char               *pb;
{
  int                 res = 0, la, lb;

  if (in == NULL || strlen (in) == 0)
    return 0;

  if (pa == NULL || pb == NULL)
    return -1;

  *pa = *pb = '\0';

  la = strcspn (in, "=");
  if (la == strlen(in)) {
    return -2;
  }

  la++;
  strlcpy (pa, in, la);
  res += la;

  in += la;
  if (*in != '\0') {
    if (*in != '"') {
      int da, db, dc;

      da = strlen(in);
      db = strcspn (in, ";");
      dc = strcspn (in, " \t");

      if (db > 0 && db < da) {
	char *p = in + db - 1;

	while (p >= in && strspn(p, " \t") > 0) {
	  db--;
	  p--;
	}
	lb = db;
      } else {
	lb = strcspn (in, " \t");
      }
    } else {
      in++;
      lb = strcspn (in + 1, "\"") + 1;
    }
    lb++;
    strlcpy (pb, in, lb);
    res += lb;
  }

  return res;
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
int
main (argc, argv)
     int                 argc;
     char              **argv;
{
  char                wbuf[0x400];
  char                rbuf[0x2000];

  scanbuf_rec         old, new;

  int                 fd;
  int                 i;

  int                 state = 0;

  mime_header         mime;

  old.buffer = wbuf;
  *old.buffer = '\0';
  old.len = 0;
  old.size = sizeof (wbuf);

  new.buffer = rbuf;
  new.len = 0;
  new.size = sizeof (rbuf);

  for (i = 0; i < argc; i++) {
    printf ("%2d : %s\n", i, argv[i]);
  }

  if (argc < 2)
    exit (1);

  if ((fd = open (argv[1], O_RDONLY)) < 0) {
    exit (1);
  }

  mime_header_init (&mime);

  while ((new.len = read (fd, new.buffer, new.size)) > 0) {
    scan_chunk (0, &old, &new, &state, &mime);
    /*    printf("sizeof old = %4ld : %s\n", old.len, old.buffer); */
  }

  close (fd);
  return 0;
}
