/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"


int                 j_rd_text_file (char *, int, int,
                                    int (*)(char *, char *));

static void         str_clear_blanks (char *);

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_rd_text_file (fname, rdtype, rdreverse, func)
     char               *fname;
     int                 rdtype;
     int                 rdreverse;
     int                 (*func) (char *, char *);
{
#define BSIZE 1024
  char                s[BSIZE];
  FILE               *fin = stdin;

  if (fname != NULL) {
    if ((fin = fopen (fname, "r")) == NULL) {
      syslog (LOG_WARNING, "fopen(%s) : %s\n", fname, strerror (errno));
      return -1;
    }
  }

  memset (s, 0, sizeof (s));
  while (fgets (s, BSIZE, fin) == s) {
    char               *pk = NULL, *pv = NULL;
    char               *q;

    s[BSIZE - 1] = '\0';
    if ((pk = strchr (s, '\n')) != NULL)
      *pk = '\0';

    pk = s;
    pk += strspn (pk, " \t");
    if ((strlen (pk) == 0) || (*pk == '#'))
      continue;
    q = pk + strlen (pk) - 1;
    while ((q != pk) && (*q == ' ' || *q == '\t')) {
      *q-- = '\0';
    }

    if (rdtype == RD_TWO_COLUMN) {
      pv = pk + strcspn (pk, " \t");
      if (*pv != '\0') {
        q = pv;
        pv += strspn (pv, " \t");
        *q = '\0';
      }
      if (rdreverse == RD_REVERSE) {
        q = pv;
        pv = pk;
        pk = q;
      }
    }
    str_clear_blanks (pk);
    str_clear_blanks (pv);

    if (strlen (pk) > 0) {
      int                 res;

      if (func != NULL) {
        if ((res = func (pk, pv)) != 0) {
          /* what do we do if ther's an error ??? */
          /* separate negative and positive errors ??? */
          if (res < 0) {
            /* fatal errors ... */
          } else {
            /* non fatal errors ... */
          }
        }
      } else {
        pv = pv != NULL ? pv : "";
        printf (" k : %-40s : v : %s\n", pk, pv);
        res = 0;
      }
    }
    memset (s, 0, sizeof (s));
  }

  if (fname != NULL) {
    fclose (fin);
  }

  return 0;
}

static void
str_clear_blanks (s)
     char               *s;
{
  char               *p;

  if (s == NULL || strlen (s) == 0)
    return;

  p = s + strlen (s) - 1;
  while (p != s && (*p == ' ' || *p == '\t'))
    *p-- = '\0';
}
